/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.analysis.Path;
import org.systemsbiology.biotapestry.analysis.PathTracker;
import org.systemsbiology.biotapestry.genome.Linkage;

public class AllPathsResult {
    private String srcID_;
    private String targID_;
    private TreeMap nodes_;
    private HashSet links_;
    private PathTracker tracker_;

    public AllPathsResult(String srcID, String targID) {
        this.srcID_ = srcID;
        this.targID_ = targID;
        this.nodes_ = new TreeMap();
        this.links_ = new HashSet();
    }

    public void addNode(String nodeID) {
        this.nodes_.put(nodeID, new Integer(0));
    }

    public void setDepth(String nodeID, int depth) {
        this.nodes_.put(nodeID, new Integer(depth));
    }

    public void addLink(String linkID) {
        this.links_.add(linkID);
    }

    public Integer getDepth(String nodeID) {
        return (Integer)this.nodes_.get(nodeID);
    }

    public Iterator getLinks() {
        return this.links_.iterator();
    }

    public Set getLinkSet() {
        return Collections.unmodifiableSet(this.links_);
    }

    public Iterator getNodes() {
        return this.nodes_.keySet().iterator();
    }

    public String getSource() {
        return this.srcID_;
    }

    public String getTarget() {
        return this.targID_;
    }

    public List getPaths() {
        ArrayList<Path> retval = new ArrayList<Path>();
        Iterator paths = this.tracker_.getPaths();
        while (paths.hasNext()) {
            Path path = (Path)paths.next();
            retval.add(new Path(path));
        }
        return retval;
    }

    public void setTracker(PathTracker tracker) {
        this.tracker_ = tracker;
        Iterator paths = tracker.getPaths();
        while (paths.hasNext()) {
            Path path = (Path)paths.next();
            Iterator lit = path.pathIterator();
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                this.addLink(link.getID());
                this.addNode(link.getSource());
            }
        }
        this.addNode(this.targID_);
    }

    public String toString() {
        return "AllPathsResult source = " + this.srcID_ + " target = " + this.targID_ + " links = " + this.links_ + " nodes = " + this.nodes_;
    }
}

