/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.systemsbiology.biotapestry.analysis.AllPathsResult;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.analysis.SignedLink;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;

public class GraphSearcher {
    private HashSet allNodes_ = new HashSet();
    private HashSet allEdges_ = new HashSet();
    private ArrayList nodeOrder_;
    private ArrayList edgeOrder_;

    public GraphSearcher(Genome gen, AllPathsResult allPaths) {
        this.edgeOrder_ = null;
        this.nodeOrder_ = null;
        Iterator ni = allPaths.getNodes();
        Iterator li = allPaths.getLinks();
        while (ni.hasNext()) {
            this.allNodes_.add(ni.next());
        }
        while (li.hasNext()) {
            String linkID = (String)li.next();
            Linkage link = gen.getLinkage(linkID);
            String trg = link.getTarget();
            String src = link.getSource();
            int sign = link.getSign();
            SignedLink cfl = new SignedLink(src, trg, sign);
            this.allEdges_.add(cfl);
        }
    }

    public GraphSearcher(Genome gen) {
        this(gen, false);
    }

    public GraphSearcher(Genome gen, boolean invert) {
        this.edgeOrder_ = null;
        this.nodeOrder_ = null;
        Iterator nit = gen.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            this.allNodes_.add(node.getID());
        }
        Iterator lit = gen.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String trg = link.getTarget();
            String src = link.getSource();
            int sign = link.getSign();
            SignedLink cfl = invert ? new SignedLink(trg, src, sign) : new SignedLink(src, trg, sign);
            this.allEdges_.add(cfl);
        }
    }

    public GraphSearcher(Set nodes, Set links) {
        this.edgeOrder_ = null;
        this.nodeOrder_ = null;
        Iterator ni = nodes.iterator();
        Iterator li = links.iterator();
        while (ni.hasNext()) {
            this.allNodes_.add(ni.next());
        }
        while (li.hasNext()) {
            Link link = (Link)li.next();
            this.allEdges_.add((Link)link.clone());
        }
    }

    public GraphSearcher(List nodes, List links) {
        this.edgeOrder_ = new ArrayList();
        this.nodeOrder_ = new ArrayList();
        Iterator li = links.iterator();
        this.nodeOrder_.addAll(nodes);
        this.allNodes_.addAll(nodes);
        while (li.hasNext()) {
            Link link = (Link)li.next();
            if (!this.allEdges_.contains(link)) {
                this.edgeOrder_.add((Link)link.clone());
            }
            this.allEdges_.add((Link)link.clone());
        }
    }

    public Map topoSort(boolean compress) {
        if (this.edgeOrder_ != null) {
            throw new IllegalStateException();
        }
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        HashSet currentNodes = new HashSet(this.allNodes_);
        Set<Link> currentEdges = new HashSet<Link>();
        Iterator li = this.allEdges_.iterator();
        while (li.hasNext()) {
            Link link = (Link)li.next();
            currentEdges.add((Link)link.clone());
        }
        Map outEdges = this.calcOutboundEdges(currentEdges);
        Set rootNodes = this.buildRootList(currentNodes, currentEdges);
        int level = 0;
        while (!rootNodes.isEmpty()) {
            Integer ilevel = new Integer(level++);
            Iterator rit = rootNodes.iterator();
            while (rit.hasNext()) {
                String nodeID = (String)rit.next();
                retval.put(nodeID, ilevel);
                outEdges.remove(nodeID);
                currentNodes.remove(nodeID);
            }
            currentEdges = this.invertOutboundEdges(outEdges);
            rootNodes = this.buildRootList(currentNodes, currentEdges);
        }
        if (compress) {
            this.contractTopoSort(retval);
        }
        return retval;
    }

    public List depthSearch() {
        HashSet<String> visited = new HashSet<String>();
        Set rootNodes = this.buildRootList(this.allNodes_, this.allEdges_);
        Map outEdges = this.calcOutboundEdges(this.allEdges_);
        ArrayList<QueueEntry> retval = new ArrayList<QueueEntry>();
        if (this.edgeOrder_ != null) {
            HashSet<String> seenRoots = new HashSet<String>();
            Iterator nit = this.nodeOrder_.iterator();
            while (nit.hasNext()) {
                String currNode = (String)nit.next();
                if (!rootNodes.contains(currNode)) continue;
                boolean gottaLink = false;
                Iterator eit = this.edgeOrder_.iterator();
                while (eit.hasNext()) {
                    Link link = (Link)eit.next();
                    String src = link.getSrc();
                    if (!currNode.equals(src) || seenRoots.contains(src)) continue;
                    seenRoots.add(src);
                    gottaLink = true;
                    this.searchGutsDepth(src, visited, outEdges, 0, this.edgeOrder_, retval);
                }
                if (gottaLink) continue;
                visited.add(currNode);
                retval.add(new QueueEntry(0, currNode));
            }
        } else {
            Iterator rit = rootNodes.iterator();
            while (rit.hasNext()) {
                this.searchGutsDepth((String)rit.next(), visited, outEdges, 0, null, retval);
            }
        }
        return retval;
    }

    public List breadthSearch() {
        if (this.edgeOrder_ != null) {
            throw new IllegalStateException();
        }
        HashSet visited = new HashSet();
        ArrayList<QueueEntry> queue = new ArrayList<QueueEntry>();
        ArrayList retval = new ArrayList();
        Set rootNodes = this.buildRootList(this.allNodes_, this.allEdges_);
        Map outEdges = this.calcOutboundEdges(this.allEdges_);
        Iterator rit = rootNodes.iterator();
        while (rit.hasNext()) {
            queue.add(new QueueEntry(0, (String)rit.next()));
        }
        this.searchGutsBreadth(visited, queue, outEdges, retval, null);
        return retval;
    }

    public List breadthSearchUntilStopped(Set startNodes, CriteriaJudge judge) {
        if (this.edgeOrder_ != null) {
            throw new IllegalStateException();
        }
        HashSet visited = new HashSet();
        ArrayList<QueueEntry> queue = new ArrayList<QueueEntry>();
        ArrayList retval = new ArrayList();
        Map outEdges = this.calcOutboundEdges(this.allEdges_);
        Iterator rit = startNodes.iterator();
        while (rit.hasNext()) {
            queue.add(new QueueEntry(0, (String)rit.next()));
        }
        this.searchGutsBreadth(visited, queue, outEdges, retval, judge);
        return retval;
    }

    public int invertTopoSort(Map topoSort, Map invert) {
        Iterator kit = topoSort.keySet().iterator();
        int maxLevel = -1;
        while (kit.hasNext()) {
            ArrayList<String> nodeList;
            String key = (String)kit.next();
            Integer level = (Integer)topoSort.get(key);
            int currLev = level;
            if (currLev > maxLevel) {
                maxLevel = currLev;
            }
            if ((nodeList = (ArrayList<String>)invert.get(level)) == null) {
                nodeList = new ArrayList<String>();
                invert.put(level, nodeList);
            }
            nodeList.add(key);
        }
        return maxLevel;
    }

    public List topoSortToPartialOrdering(Map topoSort) {
        ArrayList retval = new ArrayList();
        TreeMap invert = new TreeMap();
        this.invertTopoSort(topoSort, invert);
        Iterator kit = invert.values().iterator();
        while (kit.hasNext()) {
            ArrayList listForLevel = (ArrayList)kit.next();
            Collections.sort(listForLevel);
            retval.addAll(listForLevel);
        }
        return retval;
    }

    public static Map topoSortReposition(Map origSort, String moveID, boolean moveMin) {
        int inc;
        int maxMove;
        int minMove;
        int moveCol;
        Integer origCol = (Integer)origSort.get(moveID);
        if (origCol == null) {
            return new HashMap(origSort);
        }
        int colVal = origCol;
        boolean colDup = false;
        int minVal = Integer.MAX_VALUE;
        int maxVal = Integer.MIN_VALUE;
        Iterator oskit = origSort.keySet().iterator();
        while (oskit.hasNext()) {
            String key = (String)oskit.next();
            if (key.equals(moveID)) continue;
            Integer checkCol = (Integer)origSort.get(key);
            int chekVal = checkCol;
            if (chekVal < minVal) {
                minVal = chekVal;
            }
            if (chekVal > maxVal) {
                maxVal = chekVal;
            }
            if (chekVal != colVal) continue;
            colDup = true;
        }
        if (moveMin) {
            if (colDup) {
                moveCol = minVal;
                minMove = minVal;
                maxMove = maxVal;
                inc = 1;
            } else {
                moveCol = colVal < minVal ? colVal : minVal;
                minMove = minVal;
                maxMove = colVal - 1;
                inc = 1;
            }
        } else if (colDup) {
            moveCol = maxVal + 1;
            minMove = minVal - 1;
            maxMove = minVal - 1;
            inc = 0;
        } else {
            moveCol = colVal > maxVal ? colVal : maxVal;
            minMove = minVal - 1;
            maxMove = minVal - 1;
            inc = 0;
        }
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        oskit = origSort.keySet().iterator();
        while (oskit.hasNext()) {
            String key = (String)oskit.next();
            if (key.equals(moveID)) {
                retval.put(moveID, new Integer(moveCol));
                continue;
            }
            Integer checkCol = (Integer)origSort.get(key);
            int chekVal = checkCol;
            if (chekVal >= minMove && chekVal <= maxMove) {
                retval.put(key, new Integer(chekVal + inc));
                continue;
            }
            retval.put(key, checkCol);
        }
        return retval;
    }

    private Map calcOutboundEdges(Set edges) {
        HashMap<String, HashSet<String>> retval = new HashMap<String, HashSet<String>>();
        Iterator li = edges.iterator();
        while (li.hasNext()) {
            Link link = (Link)li.next();
            String trg = link.getTrg();
            String src = link.getSrc();
            HashSet<String> forSrc = (HashSet<String>)retval.get(src);
            if (forSrc == null) {
                forSrc = new HashSet<String>();
                retval.put(src, forSrc);
            }
            forSrc.add(trg);
        }
        return retval;
    }

    private Set buildRootList(Set nodes, Set edges) {
        HashSet retval = new HashSet();
        retval.addAll(nodes);
        Iterator ei = edges.iterator();
        while (ei.hasNext()) {
            Link link = (Link)ei.next();
            String trg = link.getTrg();
            retval.remove(trg);
        }
        return retval;
    }

    private Set invertOutboundEdges(Map outEdges) {
        HashSet<Link> retval = new HashSet<Link>();
        Iterator ki = outEdges.keySet().iterator();
        while (ki.hasNext()) {
            String src = (String)ki.next();
            Set links = (Set)outEdges.get(src);
            Iterator sit = links.iterator();
            while (sit.hasNext()) {
                String trg = (String)sit.next();
                Link link = new Link(src, trg);
                retval.add(link);
            }
        }
        return retval;
    }

    private void searchGutsDepth(String vertexID, HashSet visited, Map edgesFromSrc, int depth, List edgeOrder, List results) {
        if (visited.contains(vertexID)) {
            return;
        }
        visited.add(vertexID);
        results.add(new QueueEntry(depth, vertexID));
        HashSet outEdges = (HashSet)edgesFromSrc.get(vertexID);
        if (outEdges == null) {
            return;
        }
        if (edgeOrder != null) {
            Iterator eit = edgeOrder.iterator();
            while (eit.hasNext()) {
                String targ;
                Link link = (Link)eit.next();
                if (!vertexID.equals(link.getSrc()) || visited.contains(targ = link.getTrg())) continue;
                this.searchGutsDepth(targ, visited, edgesFromSrc, depth + 1, edgeOrder, results);
            }
        } else {
            Iterator eit = outEdges.iterator();
            while (eit.hasNext()) {
                String targ = (String)eit.next();
                if (visited.contains(targ)) continue;
                this.searchGutsDepth(targ, visited, edgesFromSrc, depth + 1, edgeOrder, results);
            }
        }
    }

    private void searchGutsBreadth(HashSet visited, ArrayList queue, Map edgesFromSrc, List results, CriteriaJudge judge) {
        while (queue.size() > 0) {
            HashSet outEdges;
            QueueEntry curr = (QueueEntry)queue.remove(0);
            if (visited.contains(curr.name)) continue;
            visited.add(curr.name);
            results.add(curr);
            if (judge != null && judge.stopHere(curr.name) || (outEdges = (HashSet)edgesFromSrc.get(curr.name)) == null) continue;
            Iterator oit = outEdges.iterator();
            while (oit.hasNext()) {
                queue.add(new QueueEntry(curr.depth + 1, (String)oit.next()));
            }
        }
    }

    private void contractTopoSort(Map topoSort) {
        boolean changed;
        HashMap nodesAtLevel = new HashMap();
        int maxLevel = this.invertTopoSort(topoSort, nodesAtLevel);
        if (maxLevel == -1) {
            return;
        }
        Map outEdges = this.calcOutboundEdges(this.allEdges_);
        do {
            changed = false;
            for (int i = maxLevel; i >= 0; --i) {
                List nodeList = (List)nodesAtLevel.get(new Integer(i));
                ArrayList listCopy = new ArrayList(nodeList);
                int numNodes = nodeList.size();
                for (int j = 0; j < numNodes; ++j) {
                    String currNode = (String)listCopy.get(j);
                    Set targsForNode = (Set)outEdges.get(currNode);
                    int min = this.getMinLevel(targsForNode, topoSort, i, maxLevel);
                    if (min <= i + 1) continue;
                    List higherNodeList = (List)nodesAtLevel.get(new Integer(min - 1));
                    higherNodeList.add(currNode);
                    nodeList.remove(currNode);
                    topoSort.put(currNode, new Integer(min - 1));
                    changed = true;
                }
            }
        } while (changed);
    }

    private int getMinLevel(Set targs, Map topoSort, int currLevel, int maxLevel) {
        if (targs == null) {
            return currLevel;
        }
        int min = maxLevel;
        Iterator trgit = targs.iterator();
        while (trgit.hasNext()) {
            String trg = (String)trgit.next();
            Integer level = (Integer)topoSort.get(trg);
            int currLev = level;
            if (min <= currLev) continue;
            min = currLev;
        }
        return min;
    }

    public static interface CriteriaJudge {
        public boolean stopHere(String var1);
    }

    public class QueueEntry {
        public int depth;
        public String name;

        QueueEntry(int depth, String name) {
            this.depth = depth;
            this.name = name;
        }

        public String toString() {
            return this.name + " depth = " + this.depth;
        }
    }
}

