/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.analysis;

import java.util.Collection;
import java.util.Iterator;

public class Link
implements Cloneable,
Comparable {
    protected String src_;
    protected String trg_;

    public Link(String src, String trg) {
        if (src == null || trg == null) {
            throw new IllegalArgumentException();
        }
        this.src_ = src;
        this.trg_ = trg;
    }

    public Link(Link other) {
        this.src_ = other.src_;
        this.trg_ = other.trg_;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String getTrg() {
        return this.trg_;
    }

    public String getSrc() {
        return this.src_;
    }

    public int hashCode() {
        return this.src_.hashCode() + this.trg_.hashCode();
    }

    public String toString() {
        return "src = " + this.src_ + " trg = " + this.trg_;
    }

    public String toSymbolicString() {
        return this.src_ + this.signSymbol() + this.trg_;
    }

    public static String toSymbolicString(Collection links) {
        StringBuffer buf = new StringBuffer();
        Iterator lit = links.iterator();
        while (lit.hasNext()) {
            Link lnk = (Link)lit.next();
            buf.append(lnk.toSymbolicString());
            if (!lit.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String signSymbol() {
        return "--";
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Link)) {
            return false;
        }
        Link otherLink = (Link)other;
        return this.src_.equals(otherLink.src_) && this.trg_.equals(otherLink.trg_);
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        Link otherLink = (Link)o;
        if (!this.src_.equals(otherLink.src_)) {
            return this.src_.compareToIgnoreCase(otherLink.src_);
        }
        return this.trg_.compareToIgnoreCase(otherLink.trg_);
    }
}

