/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biotapestry.db.GenomeSource;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;

public class Path
implements Comparable {
    private ArrayList links_;
    private HashMap nameMap_;
    private int ranking_;
    private boolean simpleLoop_;

    public Path() {
        this.links_ = new ArrayList();
        this.nameMap_ = new HashMap();
        this.ranking_ = 0;
        this.simpleLoop_ = false;
    }

    public Path(Path other) {
        this.links_ = new ArrayList(other.links_);
        this.nameMap_ = new HashMap(other.nameMap_);
        this.ranking_ = other.ranking_;
        this.simpleLoop_ = other.simpleLoop_;
    }

    public void setRanking(int ranking) {
        this.ranking_ = ranking;
    }

    public int getRanking() {
        return this.ranking_;
    }

    public boolean isSimpleLoop() {
        return this.simpleLoop_;
    }

    public void addLinkNoChecks(Linkage link, GenomeSource src) {
        this.links_.add(link);
        this.addToNameMap(this.nameMap_, link, src);
    }

    public void addSimpleLoopLink(Linkage link, GenomeSource src) {
        String srcKey = link.getSource();
        String trgKey = link.getTarget();
        if (!trgKey.equals(srcKey)) {
            throw new IllegalArgumentException();
        }
        if (this.links_.size() != 0) {
            throw new IllegalStateException();
        }
        this.links_.add(link);
        this.addToNameMap(this.nameMap_, link, src);
        this.simpleLoop_ = true;
    }

    public boolean addLink(Linkage link, GenomeSource src) {
        if (this.simpleLoop_) {
            throw new IllegalStateException();
        }
        String srcKey = link.getSource();
        String trgKey = link.getTarget();
        if (trgKey.equals(srcKey)) {
            return false;
        }
        int size = this.links_.size();
        if (size == 0) {
            this.links_.add(link);
            this.addToNameMap(this.nameMap_, link, src);
            return true;
        }
        Linkage lastLink = (Linkage)this.links_.get(size - 1);
        if (!lastLink.getTarget().equals(link.getSource())) {
            throw new IllegalArgumentException();
        }
        String newTarget = link.getTarget();
        for (int i = 0; i < size; ++i) {
            Linkage pathLink = (Linkage)this.links_.get(i);
            String source = pathLink.getSource();
            String target = pathLink.getTarget();
            if (!newTarget.equals(source) && !newTarget.equals(target)) continue;
            return false;
        }
        this.addToNameMap(this.nameMap_, link, src);
        this.links_.add(link);
        return true;
    }

    public Iterator pathIterator() {
        return this.links_.iterator();
    }

    public String getStart() {
        int size = this.links_.size();
        if (size == 0) {
            return null;
        }
        return ((Linkage)this.links_.get(0)).getSource();
    }

    public String getEnd() {
        int size = this.links_.size();
        if (size == 0) {
            return null;
        }
        return ((Linkage)this.links_.get(this.links_.size() - 1)).getTarget();
    }

    public int getDepth() {
        return this.links_.size();
    }

    public void pop() {
        this.links_.remove(this.links_.size() - 1);
    }

    public boolean contains(String node) {
        return this.position(node) != -1;
    }

    public int position(String node) {
        int size = this.links_.size();
        for (int i = 0; i < size; ++i) {
            Linkage link = (Linkage)this.links_.get(i);
            if (link.getSource().equals(node)) {
                return i;
            }
            if (i != size - 1 || !link.getTarget().equals(node)) continue;
            return size;
        }
        return -1;
    }

    public Path tail(String start) {
        int position = this.position(start);
        int size = this.links_.size();
        if (position == -1) {
            return null;
        }
        if (position == size) {
            return new Path();
        }
        ArrayList retList = new ArrayList(this.links_.subList(position, size - 1));
        HashMap retMap = new HashMap();
        int rSize = retList.size();
        for (int i = 0; i < rSize; ++i) {
            Linkage link = (Linkage)retList.get(i);
            String linkSource = link.getSource();
            String linkTarget = link.getTarget();
            if (retMap.get(linkSource) == null) {
                retMap.put(linkSource, this.nameMap_.get(linkSource));
            }
            if (retMap.get(linkTarget) != null) continue;
            retMap.put(linkTarget, this.nameMap_.get(linkTarget));
        }
        return new Path(retList, retMap);
    }

    public Set pathNodes() {
        HashSet<String> retval = new HashSet<String>();
        int size = this.links_.size();
        for (int i = 0; i < size; ++i) {
            Linkage link = (Linkage)this.links_.get(i);
            retval.add(link.getSource());
            if (i != size - 1) continue;
            retval.add(link.getTarget());
        }
        return retval;
    }

    public Path mergeTail(Path tail) {
        String tailStart = tail.getStart();
        String headEnd = this.getEnd();
        if (tailStart != null && headEnd != null && !headEnd.equals(tailStart)) {
            throw new IllegalArgumentException();
        }
        Set headNodes = this.pathNodes();
        ArrayList<Linkage> retlinks = new ArrayList<Linkage>(this.links_);
        HashMap retMap = new HashMap(this.nameMap_);
        int tailSize = tail.links_.size();
        for (int i = 0; i < tailSize; ++i) {
            Linkage link = (Linkage)tail.links_.get(i);
            String linkSource = link.getSource();
            String linkTarget = link.getTarget();
            if (headNodes.contains(linkSource) || headNodes.contains(linkTarget)) {
                return null;
            }
            retlinks.add(link);
            if (retMap.get(linkSource) == null) {
                retMap.put(linkSource, tail.nameMap_.get(linkSource));
            }
            if (retMap.get(linkTarget) != null) continue;
            retMap.put(linkTarget, tail.nameMap_.get(linkTarget));
        }
        return new Path(retlinks, retMap);
    }

    public int getSign() {
        int size = this.links_.size();
        if (size == 0) {
            return 0;
        }
        int retval = ((Linkage)this.links_.get(0)).getSign();
        for (int i = 1; i < size; ++i) {
            Linkage link = (Linkage)this.links_.get(i);
            retval = this.resolveSign(retval, link.getSign());
        }
        return retval;
    }

    private int resolveSign(int current, int newSign) {
        if (newSign == 0) {
            return 0;
        }
        switch (current) {
            case -1: {
                return newSign == 1 ? -1 : 1;
            }
            case 1: {
                return newSign == -1 ? -1 : 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.links_.size();
        for (int i = 0; i < size; ++i) {
            Linkage link = (Linkage)this.links_.get(i);
            String display = (String)this.nameMap_.get(link.getSource());
            buf.append(display);
            if (link.getSign() == -1) {
                buf.append("-|");
            } else if (link.getSign() == 1) {
                buf.append("->");
            } else {
                buf.append("--");
            }
            if (i != size - 1) continue;
            buf.append((String)this.nameMap_.get(link.getTarget()));
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path other = (Path)o;
        if (this.ranking_ != other.ranking_) {
            return false;
        }
        int size = this.links_.size();
        if (other.links_.size() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Linkage otherLink;
            Linkage thisLink = (Linkage)this.links_.get(i);
            if (thisLink == (otherLink = (Linkage)other.links_.get(i)) || thisLink.getID().equals(otherLink.getID())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int size = this.links_.size();
        if (size == 0) {
            return 0;
        }
        String val = this.getStart() + "-" + size + "-" + this.getEnd();
        return val.hashCode();
    }

    public int compareTo(Object o) {
        Linkage otherLink;
        Linkage thisLink;
        int i;
        int otherSize;
        if (this == o) {
            return 0;
        }
        Path other = (Path)o;
        int rdiff = this.ranking_ - other.ranking_;
        if (rdiff != 0) {
            return rdiff;
        }
        int size = this.links_.size();
        int diff = size - (otherSize = other.links_.size());
        if (diff != 0) {
            return diff;
        }
        for (i = 0; i < size; ++i) {
            int otherSign;
            String otherTarget;
            String otherSource;
            thisLink = (Linkage)this.links_.get(i);
            if (thisLink == (otherLink = (Linkage)other.links_.get(i))) continue;
            String thisSource = thisLink.getSource();
            if (!thisSource.equals(otherSource = otherLink.getSource())) {
                String thisDisplay = (String)this.nameMap_.get(thisSource);
                String otherDisplay = (String)other.nameMap_.get(otherSource);
                return thisDisplay.compareToIgnoreCase(otherDisplay);
            }
            String thisTarget = thisLink.getTarget();
            if (!thisTarget.equals(otherTarget = otherLink.getTarget())) {
                String thisDisplay = (String)this.nameMap_.get(thisTarget);
                String otherDisplay = (String)other.nameMap_.get(otherTarget);
                return thisDisplay.compareToIgnoreCase(otherDisplay);
            }
            int thisSign = thisLink.getSign();
            if (thisSign == (otherSign = otherLink.getSign())) continue;
            if (thisSign == 0) {
                return 1;
            }
            if (otherSign == 0) {
                return -1;
            }
            return thisSign - otherSign;
        }
        for (i = 0; i < size; ++i) {
            String otherID;
            thisLink = (Linkage)this.links_.get(i);
            otherLink = (Linkage)other.links_.get(i);
            String thisID = thisLink.getID();
            if (thisID.equals(otherID = otherLink.getID())) continue;
            return thisID.compareTo(otherID);
        }
        return 0;
    }

    private Path(ArrayList list, HashMap nameMap) {
        this.links_ = list;
        this.nameMap_ = nameMap;
        this.ranking_ = 0;
    }

    private void addToNameMap(HashMap nameMap, Linkage link, GenomeSource src) {
        String trgKey;
        String srcKey = link.getSource();
        Genome gen = src.getGenome();
        if (nameMap.get(srcKey) == null) {
            String srcName = gen.getNode(GenomeItemInstance.getBaseID(srcKey)).getName();
            nameMap.put(srcKey, srcName);
        }
        if (nameMap.get(trgKey = link.getTarget()) == null) {
            String trgName = gen.getNode(GenomeItemInstance.getBaseID(trgKey)).getName();
            nameMap.put(trgKey, trgName);
        }
    }
}

