/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.analysis.AllPathsResult;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.analysis.Path;
import org.systemsbiology.biotapestry.analysis.PathTracker;
import org.systemsbiology.biotapestry.db.GenomeSource;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;

public class PathAnalyzer {
    public Set getNetworkRoots(String genomeID, GenomeSource gSrc) {
        Genome genome = gSrc.getGenome(genomeID);
        HashSet<String> netNodes = new HashSet<String>();
        HashSet<String> netTargets = new HashSet<String>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String src = link.getSource();
            netNodes.add(src);
            String trg = link.getTarget();
            netNodes.add(trg);
            netTargets.add(trg);
        }
        netNodes.removeAll(netTargets);
        return netNodes;
    }

    public AllPathsResult getAllPaths(String genomeID, String sourceID, String targetID, int maxDepth, GenomeSource gSrc) {
        Genome genome = gSrc.getGenome(genomeID);
        HashMap<String, HashSet<Linkage>> edges = new HashMap<String, HashSet<Linkage>>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String src = link.getSource();
            HashSet<Linkage> linkList = (HashSet<Linkage>)edges.get(src);
            if (linkList == null) {
                linkList = new HashSet<Linkage>();
                edges.put(src, linkList);
            }
            linkList.add(link);
        }
        AllPathsResult retval = new AllPathsResult(sourceID, targetID);
        PathTracker tracker = sourceID.equals(targetID) ? this.simpleAutoregulation(sourceID, targetID, maxDepth, edges, gSrc) : this.depthSearch(sourceID, targetID, maxDepth, edges, gSrc);
        retval.setTracker(tracker);
        GraphSearcher gs = new GraphSearcher(genome, retval);
        List ordering = gs.breadthSearch();
        Iterator oit = ordering.iterator();
        int depth = 0;
        while (oit.hasNext()) {
            GraphSearcher.QueueEntry qe = (GraphSearcher.QueueEntry)oit.next();
            retval.setDepth(qe.name, depth++);
        }
        retval.setDepth(targetID, depth);
        return retval;
    }

    private PathTracker simpleAutoregulation(String source, String target, int maxDepth, HashMap edges, GenomeSource gSrc) {
        if (!source.equals(target)) {
            throw new IllegalArgumentException();
        }
        PathTracker retval = new PathTracker();
        if (maxDepth < 1) {
            return retval;
        }
        HashSet outEdges = (HashSet)edges.get(source);
        if (outEdges == null) {
            return retval;
        }
        Iterator eit = outEdges.iterator();
        while (eit.hasNext()) {
            Linkage link = (Linkage)eit.next();
            if (!link.getTarget().equals(source)) continue;
            Path currPath = new Path();
            currPath.addSimpleLoopLink(link, gSrc);
            retval.addNewPath(currPath);
        }
        return retval;
    }

    private PathTracker depthSearch(String source, String target, int maxDepth, HashMap edges, GenomeSource src) {
        HashSet visited = new HashSet();
        Path currPath = new Path();
        PathTracker retval = new PathTracker();
        this.searchGutsDepth(source, target, visited, 0, maxDepth, currPath, retval, edges, src);
        return retval;
    }

    private void searchGutsDepth(String vertexID, String targetID, HashSet visited, int depth, int maxDepth, Path currPath, PathTracker tracker, HashMap edges, GenomeSource gSrc) {
        if (depth++ > maxDepth) {
            return;
        }
        if (vertexID.equals(targetID)) {
            tracker.addNewPath(new Path(currPath));
            return;
        }
        HashSet outEdges = (HashSet)edges.get(vertexID);
        if (outEdges == null) {
            return;
        }
        Iterator eit = outEdges.iterator();
        while (eit.hasNext()) {
            Linkage link = (Linkage)eit.next();
            boolean ok = currPath.addLink(link, gSrc);
            if (!ok) continue;
            this.searchGutsDepth(link.getTarget(), targetID, visited, depth, maxDepth, currPath, tracker, edges, gSrc);
            currPath.pop();
        }
    }

    public AllPathsResult getAllPathsOld(String genomeID, String sourceID, String targetID, int maxDepth, GenomeSource gSrc) {
        Set fanIn = this.getAllSources(genomeID, targetID, sourceID, maxDepth, gSrc);
        return this.pruneToSingleSource(genomeID, targetID, sourceID, fanIn, gSrc);
    }

    private Set getAllSources(String genomeID, String targetID, String sourceID, int maxDepth, GenomeSource gSrc) {
        TreeMap<String, Integer> processed = new TreeMap<String, Integer>();
        TreeMap<String, Integer> pending = new TreeMap<String, Integer>();
        Genome genome = gSrc.getGenome(genomeID);
        pending.put(targetID, new Integer(0));
        while (!pending.isEmpty()) {
            String nid = (String)pending.firstKey();
            Integer depth = (Integer)pending.remove(nid);
            Integer depthP1 = new Integer(depth + 1);
            pending.remove(nid);
            processed.put(nid, depth);
            if (depth == maxDepth || nid.equals(sourceID)) continue;
            Iterator lid = genome.getLinkageIterator();
            while (lid.hasNext()) {
                boolean isPending;
                Linkage link = (Linkage)lid.next();
                if (!link.getTarget().equals(nid)) continue;
                String srcID = link.getSource();
                Integer srcDepth = (Integer)processed.get(srcID);
                boolean isProcessed = srcDepth != null;
                boolean bl = isPending = pending.get(srcID) != null;
                if (isProcessed || isPending) continue;
                pending.put(srcID, depthP1);
            }
        }
        return processed.keySet();
    }

    private AllPathsResult pruneToSingleSource(String genomeID, String targetID, String sourceID, Set fanIn, GenomeSource gSrc) {
        AllPathsResult retval = new AllPathsResult(sourceID, targetID);
        TreeSet<String> pending = new TreeSet<String>();
        Genome genome = gSrc.getGenome(genomeID);
        if (!fanIn.contains(sourceID)) {
            throw new IllegalArgumentException();
        }
        pending.add(sourceID);
        while (!pending.isEmpty()) {
            String nid = (String)pending.first();
            pending.remove(nid);
            Iterator lid = genome.getLinkageIterator();
            while (lid.hasNext()) {
                String currTargID;
                Linkage link = (Linkage)lid.next();
                if (!link.getSource().equals(nid) || !fanIn.contains(currTargID = link.getTarget()) || link.getTarget().equals(sourceID) || link.getSource().equals(targetID)) continue;
                retval.addLink(link.getID());
                retval.addNode(nid);
                boolean isProcessed = retval.getDepth(currTargID) != null;
                boolean isPending = pending.contains(currTargID);
                if (isProcessed || isPending) continue;
                pending.add(currTargID);
            }
        }
        retval.addNode(targetID);
        GraphSearcher gs = new GraphSearcher(genome, retval);
        List bfres = gs.breadthSearch();
        Iterator bit = bfres.iterator();
        int count = 0;
        while (bit.hasNext()) {
            GraphSearcher.QueueEntry qe = (GraphSearcher.QueueEntry)bit.next();
            retval.setDepth(qe.name, count++);
        }
        retval.setDepth(targetID, count);
        return retval;
    }
}

