/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.analysis;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biotapestry.analysis.Path;

public class PathTracker {
    private HashSet paths_ = new HashSet();
    private int pathLimit_;

    public PathTracker() {
        this.pathLimit_ = Integer.MAX_VALUE;
    }

    public PathTracker(int pathLimit) {
        this.pathLimit_ = pathLimit;
    }

    public Iterator getPaths() {
        return this.paths_.iterator();
    }

    public boolean addNewPath(Path path) {
        this.paths_.add(path);
        return this.paths_.size() >= this.pathLimit_;
    }

    public Set getTails(String nodeID) {
        HashSet<Path> retval = new HashSet<Path>();
        Iterator pit = this.paths_.iterator();
        while (pit.hasNext()) {
            Path path = (Path)pit.next();
            Path tail = path.tail(nodeID);
            if (tail == null || tail.getDepth() == 0) continue;
            retval.add(tail);
        }
        return retval;
    }
}

