/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.analysis;

import org.systemsbiology.biotapestry.analysis.Link;

public class SignedLink
extends Link
implements Cloneable,
Comparable {
    protected int sign_;

    public SignedLink(String src, String trg, int sign) {
        super(src, trg);
        this.sign_ = sign;
    }

    public SignedLink(SignedLink other) {
        super(other);
        this.sign_ = other.sign_;
    }

    public int getSign() {
        return this.sign_;
    }

    public Object clone() {
        return super.clone();
    }

    public int hashCode() {
        return super.hashCode() + this.sign_;
    }

    public String toString() {
        return super.toString() + " sign = " + this.sign_;
    }

    public String signSymbol() {
        switch (this.sign_) {
            case -1: {
                return "-|";
            }
            case 1: {
                return "->";
            }
            case 0: {
                return "--";
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof SignedLink)) {
            return false;
        }
        SignedLink otherLink = (SignedLink)other;
        return this.sign_ == otherLink.sign_;
    }

    public int compareTo(Object o) {
        int supRes = super.compareTo(o);
        if (supRes != 0) {
            return supRes;
        }
        SignedLink otherLink = (SignedLink)o;
        return this.sign_ - otherLink.sign_;
    }
}

