/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class ArgParser {
    public static final int EDITOR = 0;
    public static final int VIEWER = 1;
    public static final int PIPELINE = 2;
    public static final String BIG_SCREEN = "bigScreen";
    public static final String GAGGLE = "gaggle";
    public static final String FILE = "file";
    public static final String RES_URL = "resource";
    public static final String REM_URL = "remote";
    public static final String PLUG_IN_DIR = "plugInDir";
    public static final String USE_PASSWORD = "salt";
    public static final String CSV_BATCH_INPUT = "csvImport";
    public static final String WEB_BATCH_OUTPUT = "webExport";
    public static final String IMAGE_BATCH_OUTPUT = "imageExport";
    public static final String BTP_BATCH_OUTPUT = "saveFile";
    public static final String CSV_BATCH_COMPRESS = "compress";

    public Map parse(int type, String[] argv) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            list.add(arg.startsWith("-") ? arg.toLowerCase() : arg);
        }
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        String finalArg = list.size() > 0 ? (String)list.get(list.size() - 1) : null;
        List targs = this.loadForType(type);
        int tNum = targs.size();
        for (int i = 0; i < tNum; ++i) {
            Object argVal;
            ArgInfo ai = (ArgInfo)targs.get(i);
            int index = list.indexOf("-" + ai.key.toLowerCase());
            if (!ai.followOn) {
                if (index != -1) {
                    argVal = true;
                    list.remove(index);
                } else {
                    argVal = false;
                }
                argMap.put(ai.key, argVal);
                continue;
            }
            if (index != -1) {
                if (index == list.size() - 1) {
                    return null;
                }
                argVal = (String)list.get(index + 1);
                if (((String)argVal).startsWith("-")) {
                    return null;
                }
                list.remove(index + 1);
                list.remove(index);
            } else {
                argVal = null;
            }
            argMap.put(ai.key, argVal);
        }
        if (list.size() == 0) {
            return argMap;
        }
        if (list.size() > 1) {
            return null;
        }
        String remains = (String)list.get(0);
        if (remains.equals(finalArg)) {
            argMap.put(FILE, remains);
        }
        return argMap;
    }

    public String getUsage(int type) {
        List targs = this.loadForType(type);
        return this.generateUsage(targs);
    }

    private List loadForType(int type) {
        ArrayList<ArgInfo> retval = new ArrayList<ArgInfo>();
        if (type == 0) {
            retval.add(new ArgInfo(BIG_SCREEN, false, false));
            retval.add(new ArgInfo(GAGGLE, true, false));
            retval.add(new ArgInfo(PLUG_IN_DIR, true, false));
            retval.add(new ArgInfo(RES_URL, true, false));
            retval.add(new ArgInfo(REM_URL, true, false));
            retval.add(new ArgInfo(USE_PASSWORD, true, false));
            retval.add(new ArgInfo(FILE, true, true));
        } else if (type == 1) {
            retval.add(new ArgInfo(BIG_SCREEN, false, false));
            retval.add(new ArgInfo(PLUG_IN_DIR, true, false));
            retval.add(new ArgInfo(RES_URL, true, false));
            retval.add(new ArgInfo(REM_URL, true, false));
            retval.add(new ArgInfo(USE_PASSWORD, true, false));
            retval.add(new ArgInfo(FILE, true, true));
        } else if (type == 2) {
            retval.add(new ArgInfo(FILE, true, true));
            retval.add(new ArgInfo(CSV_BATCH_INPUT, true, true));
            retval.add(new ArgInfo(WEB_BATCH_OUTPUT, true, true));
            retval.add(new ArgInfo(IMAGE_BATCH_OUTPUT, true, true));
            retval.add(new ArgInfo(BTP_BATCH_OUTPUT, true, true));
            retval.add(new ArgInfo(CSV_BATCH_COMPRESS, false, false));
        } else {
            throw new IllegalArgumentException();
        }
        return retval;
    }

    private String generateUsage(List targs) {
        StringBuffer buf = new StringBuffer();
        ResourceManager rMan = ResourceManager.getManager();
        buf.append(rMan.getString("argParser.arguments"));
        buf.append("\n");
        int tNum = targs.size();
        for (int i = 0; i < tNum; ++i) {
            ArgInfo ai = (ArgInfo)targs.get(i);
            buf.append(ai.opKey ? " [ -" : " -");
            buf.append(ai.key);
            buf.append(ai.opKey ? " ] " : " ");
            if (ai.followOn) {
                buf.append(" argument ]");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    private class ArgInfo {
        String key;
        boolean followOn;
        boolean opKey;

        ArgInfo(String key, boolean followOn, boolean opKey) {
            this.key = key;
            this.followOn = followOn;
            this.opKey = opKey;
        }
    }
}

