/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.app;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.app.EditorWindow;
import org.systemsbiology.biotapestry.app.NavigationChange;
import org.systemsbiology.biotapestry.app.PopupTree;
import org.systemsbiology.biotapestry.app.SliderChange;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.NavigationChangeCmd;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.cmd.UserTreePathController;
import org.systemsbiology.biotapestry.cmd.ZoomCommandSupport;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseFactory;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.event.EventManager;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.event.ModelChangeListener;
import org.systemsbiology.biotapestry.event.SelectionChangeEvent;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.nav.GroupSettingManager;
import org.systemsbiology.biotapestry.nav.ImageManager;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.nav.OverlayDisplayChange;
import org.systemsbiology.biotapestry.parser.SUParser;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.ModelImagePanel;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.ui.dialogs.LoginDialog;
import org.systemsbiology.biotapestry.util.BTToggleButton;
import org.systemsbiology.biotapestry.util.BackgroundWorkerControlManager;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJComboBox;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class CommonView
implements TreeSelectionListener,
ChangeListener,
ModelChangeListener,
BackgroundWorkerControlManager {
    private SUPanel sup_;
    private ModelImagePanel mip_;
    private boolean mipVisible_;
    private JPanel ovrPanel_;
    private boolean ovrVisible_;
    private CardLayout myCard_;
    private JPanel hidingPanel_;
    private PopupTree myTree_;
    private JPanel sliderPanel_;
    private LayoutManager layoutMgr_;
    private UndoManager undo_;
    private JScrollPane jsp_;
    private JFrame topFrame_;
    private String currDip_;
    private int lastSetting_ = -1;
    private Integer frozenSlider_;
    private boolean managing_;
    private HashMap sliders_;
    private String currSlider_;
    private JPanel blankPanel_;
    private JPanel currSliderPanel_;
    private boolean sliderVisible_;
    private MainCommands mcmd_;
    private boolean doingUndo_;
    private TreePath lastPath_;
    private UserTreePathController utpControl_;
    private MainCommands.ChecksForEnabled undoAction_;
    private MainCommands.ChecksForEnabled redoAction_;
    private JButton gaggleInstallButton_;
    private JButton gaggleUpdateGooseButton_;
    private SyncToggleWidgets pulldownSync_;
    private HashMap actionMap_;
    private JToolBar toolBar_;
    private BTToggleButton tb_;
    private AbstractAction pullwi_;
    private FixedJComboBox userPathsCombo_;
    private FixedJComboBox gaggleGooseCombo_;
    private NetOverlayController noc_;
    private String doGaggle_;
    private boolean pathControlsVisible_;
    private boolean isEditor_;

    public void disableControls() {
        this.disableControls(1, true);
    }

    public void reenableControls() {
        if (this.myTree_.getSelectionPath() == null) {
            this.myTree_.setSelectionPath(Database.getDB().getNavTree().getVfgSelection());
        }
        this.enableControls(true);
    }

    public void redraw() {
        this.getSUPanel().repaint();
    }

    public void buildForHeadless(Map args) {
        this.buildEditorView(null, new JPanel(), args);
    }

    public void buildEditorView(EditorWindow editorWindow, Container cp, Map args) {
        JMenu gaggleGooseChooseMenu;
        this.topFrame_ = editorWindow;
        this.isEditor_ = true;
        ((JComponent)cp).getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "BioTapCancel");
        ((JComponent)cp).getActionMap().put("BioTapCancel", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CommonView.this.sup_.cancelAddMode();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        ((JComponent)cp).getInputMap(1).put(KeyStroke.getKeyStroke("DELETE"), "BioTapDelete");
        ((JComponent)cp).getInputMap(1).put(KeyStroke.getKeyStroke("BACK_SPACE"), "BioTapDelete");
        ((JComponent)cp).getActionMap().put("BioTapDelete", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CommonView.this.sup_.deleteSelected();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        ((JComponent)cp).getInputMap(1).put(KeyStroke.getKeyStroke(38, 1), "BioTapNudgeUp");
        ((JComponent)cp).getActionMap().put("BioTapNudgeUp", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CommonView.this.sup_.nudgeSelected(0);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        ((JComponent)cp).getInputMap(1).put(KeyStroke.getKeyStroke(40, 1), "BioTapNudgeDown");
        ((JComponent)cp).getActionMap().put("BioTapNudgeDown", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CommonView.this.sup_.nudgeSelected(1);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        ((JComponent)cp).getInputMap(1).put(KeyStroke.getKeyStroke(37, 1), "BioTapNudgeLeft");
        ((JComponent)cp).getActionMap().put("BioTapNudgeLeft", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CommonView.this.sup_.nudgeSelected(2);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        ((JComponent)cp).getInputMap(1).put(KeyStroke.getKeyStroke(39, 1), "BioTapNudgeRight");
        ((JComponent)cp).getActionMap().put("BioTapNudgeRight", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CommonView.this.sup_.nudgeSelected(3);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.doGaggle_ = (String)args.get("gaggle");
        ResourceManager rMan = ResourceManager.getManager();
        cp.setLayout(new BorderLayout());
        this.undo_ = new UndoManager();
        this.undo_.setLimit(50);
        this.sup_ = new SUPanel(this.topFrame_, this, this.undo_, false);
        JMenuBar menuBar = new JMenuBar();
        JMenu recentMenu = new JMenu(rMan.getString("command.recentMenu"));
        recentMenu.setMnemonic(rMan.getChar("command.recentMenuMnem"));
        JMenu userPathChooseMenu = new JMenu(rMan.getString("command.userPaths"));
        userPathChooseMenu.setMnemonic(rMan.getChar("command.userPathsMnem"));
        JMenu jMenu = gaggleGooseChooseMenu = this.doGaggle_ != null ? new JMenu(rMan.getString("command.gooseChoose")) : null;
        if (this.doGaggle_ != null) {
            gaggleGooseChooseMenu.setMnemonic(rMan.getChar("command.gooseChooseMnem"));
        }
        this.userPathsCombo_ = new FixedJComboBox(250);
        this.gaggleGooseCombo_ = this.doGaggle_ != null ? new FixedJComboBox(250) : null;
        this.mcmd_ = MainCommands.initCmds(this, this.topFrame_, recentMenu, userPathChooseMenu, this.userPathsCombo_, gaggleGooseChooseMenu, this.gaggleGooseCombo_);
        this.utpControl_ = this.mcmd_.getPathController();
        this.noc_ = this.mcmd_.getOverlayController();
        Boolean doBig = (Boolean)args.get("bigScreen");
        if (doBig == null) {
            doBig = new Boolean(false);
        }
        this.myTree_ = new PopupTree(Database.getDB().getNavTree(), false, this, doBig);
        JMenu fMenu = new JMenu(rMan.getString("command.File"));
        fMenu.setMnemonic(rMan.getChar("command.FileMnem"));
        menuBar.add(fMenu);
        fMenu.add(this.mcmd_.getAction(9, false, null));
        fMenu.add(this.mcmd_.getAction(8, false, null));
        fMenu.add(recentMenu);
        fMenu.add(new JSeparator());
        fMenu.add(this.mcmd_.getAction(6, false, null));
        fMenu.add(this.mcmd_.getAction(7, false, null));
        fMenu.add(new JSeparator());
        JMenu importMenu = new JMenu(rMan.getString("command.importMenu"));
        importMenu.setMnemonic(rMan.getChar("command.importMenuMnem"));
        fMenu.add(importMenu);
        importMenu.add(this.mcmd_.getAction(44, false, null));
        importMenu.add(this.mcmd_.getAction(57, false, null));
        importMenu.add(new JSeparator());
        importMenu.add(this.mcmd_.getAction(41, false, null));
        importMenu.add(this.mcmd_.getAction(40, false, null));
        importMenu.add(new JSeparator());
        importMenu.add(this.mcmd_.getAction(29, false, null));
        importMenu.add(this.mcmd_.getAction(30, false, null));
        importMenu.add(this.mcmd_.getAction(64, false, null));
        JMenu exportMenu = new JMenu(rMan.getString("command.exportMenu"));
        exportMenu.setMnemonic(rMan.getChar("command.exportMenuMnem"));
        fMenu.add(exportMenu);
        exportMenu.add(this.mcmd_.getAction(2, false, null));
        exportMenu.add(this.mcmd_.getAction(65, false, null));
        exportMenu.add(new JSeparator());
        exportMenu.add(this.mcmd_.getAction(3, false, null));
        exportMenu.add(new JSeparator());
        exportMenu.add(this.mcmd_.getAction(31, false, null));
        exportMenu.add(this.mcmd_.getAction(32, false, null));
        exportMenu.add(this.mcmd_.getAction(109, false, null));
        exportMenu.add(new JSeparator());
        exportMenu.add(this.mcmd_.getAction(4, false, null));
        exportMenu.add(this.mcmd_.getAction(49, false, null));
        exportMenu.add(new JSeparator());
        exportMenu.add(this.mcmd_.getAction(5, false, null));
        fMenu.add(new JSeparator());
        fMenu.add(this.mcmd_.getAction(10, false, null));
        fMenu.add(new JSeparator());
        fMenu.add(this.mcmd_.getAction(1, false, null));
        this.undoAction_ = this.mcmd_.getAction(20, false, null);
        this.redoAction_ = this.mcmd_.getAction(21, false, null);
        JMenu eMenu = new JMenu(rMan.getString("command.Edit"));
        eMenu.setMnemonic(rMan.getChar("command.EditMnem"));
        menuBar.add(eMenu);
        eMenu.add(this.undoAction_);
        eMenu.add(this.redoAction_);
        eMenu.add(new JSeparator());
        eMenu.add(this.mcmd_.getAction(12, false, null));
        eMenu.add(this.mcmd_.getAction(82, false, null));
        JMenu dropSelMenu = new JMenu(rMan.getString("command.removeFromSelections"));
        dropSelMenu.setMnemonic(rMan.getChar("command.removeFromSelectionsMnem"));
        eMenu.add(dropSelMenu);
        dropSelMenu.add(this.mcmd_.getAction(67, false, null));
        dropSelMenu.add(this.mcmd_.getAction(66, false, null));
        dropSelMenu.add(new JSeparator());
        Vector typeChoices = DBNode.getTypeChoices(true);
        int numC = typeChoices.size();
        for (int j = 0; j < numC; ++j) {
            ChoiceContent cc = (ChoiceContent)typeChoices.get(j);
            dropSelMenu.add(new MainCommands.RemoveSingleTypeSelections(new Integer(cc.val), cc.name));
        }
        eMenu.add(this.sup_.getSelectedMenu());
        eMenu.add(this.myTree_.getCurrentModelMenu());
        eMenu.add(new JSeparator());
        JMenu addMenu = new JMenu(rMan.getString("command.addMenu"));
        addMenu.setMnemonic(rMan.getChar("command.addMenuMnem"));
        eMenu.add(addMenu);
        addMenu.add(this.mcmd_.getAction(97, false, null));
        addMenu.add(this.mcmd_.getAction(13, false, null));
        addMenu.add(this.mcmd_.getAction(16, false, null));
        addMenu.add(this.mcmd_.getAction(14, false, null));
        addMenu.add(this.mcmd_.getAction(39, false, null));
        addMenu.add(this.mcmd_.getAction(46, false, null));
        eMenu.add(this.mcmd_.getAction(47, false, null));
        eMenu.add(this.mcmd_.getAction(103, false, null));
        eMenu.add(this.mcmd_.getAction(15, false, null));
        MainCommands.ChecksForEnabled pda = this.mcmd_.getAction(17, false, null);
        JCheckBoxMenuItem jcb = new JCheckBoxMenuItem(pda);
        eMenu.add(jcb);
        eMenu.add(new JSeparator());
        JMenu imageMenu = new JMenu(rMan.getString("command.imageMenu"));
        imageMenu.setMnemonic(rMan.getChar("command.imageMenuMnem"));
        eMenu.add(imageMenu);
        imageMenu.add(this.mcmd_.getAction(83, false, null));
        imageMenu.add(this.mcmd_.getAction(84, false, null));
        JMenu overlayMenu = new JMenu(rMan.getString("command.overlayMenu"));
        overlayMenu.setMnemonic(rMan.getChar("command.overlayMenuMnem"));
        eMenu.add(overlayMenu);
        overlayMenu.add(this.mcmd_.getAction(98, false, null));
        overlayMenu.add(this.mcmd_.getAction(101, false, null));
        overlayMenu.add(this.mcmd_.getAction(100, false, null));
        overlayMenu.add(this.mcmd_.getAction(99, false, null));
        overlayMenu.add(this.mcmd_.getAction(104, false, null));
        overlayMenu.add(this.mcmd_.getAction(105, false, null));
        eMenu.add(new JSeparator());
        eMenu.add(this.mcmd_.getAction(19, false, null));
        eMenu.add(this.mcmd_.getAction(42, false, null));
        eMenu.add(this.mcmd_.getAction(60, false, null));
        eMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent ev) {
            }

            public void menuDeselected(MenuEvent ev) {
            }

            public void menuSelected(MenuEvent ev) {
                try {
                    boolean canUndo = CommonView.this.undo_.canUndo();
                    boolean canRedo = CommonView.this.undo_.canRedo();
                    ResourceManager rMan = ResourceManager.getManager();
                    String desc = canUndo ? CommonView.this.undo_.getUndoPresentationName() : rMan.getString("command.Undo");
                    CommonView.this.undoAction_.putValue("Name", desc);
                    CommonView.this.undoAction_.setEnabled(CommonView.this.undoAction_.isPushed() ? false : canUndo);
                    desc = canRedo ? CommonView.this.undo_.getRedoPresentationName() : rMan.getString("command.Redo");
                    CommonView.this.redoAction_.putValue("Name", desc);
                    CommonView.this.redoAction_.setEnabled(CommonView.this.redoAction_.isPushed() ? false : canRedo);
                    CommonView.this.sup_.stockSelectedMenu();
                    CommonView.this.myTree_.stockCurrentModelMenu();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        JMenu vMenu = new JMenu(rMan.getString("command.View"));
        vMenu.setMnemonic(rMan.getChar("command.ViewMnem"));
        menuBar.add(vMenu);
        vMenu.add(this.mcmd_.getAction(18, false, null));
        vMenu.add(this.mcmd_.getAction(22, false, null));
        vMenu.add(this.mcmd_.getAction(23, false, null));
        vMenu.add(this.mcmd_.getAction(76, false, null));
        vMenu.add(this.mcmd_.getAction(114, false, null));
        vMenu.add(this.mcmd_.getAction(35, false, null));
        vMenu.add(this.mcmd_.getAction(113, false, null));
        vMenu.add(this.mcmd_.getAction(27, false, null));
        vMenu.add(this.mcmd_.getAction(77, false, null));
        vMenu.add(this.mcmd_.getAction(80, false, null));
        vMenu.add(this.mcmd_.getAction(102, false, null));
        vMenu.add(new JSeparator());
        JMenu userPathsSubMenu = new JMenu(rMan.getString("command.userPathsSubMenu"));
        userPathsSubMenu.setMnemonic(rMan.getChar("command.userPathsSubMenuMnem"));
        vMenu.add(userPathsSubMenu);
        userPathsSubMenu.add(userPathChooseMenu);
        userPathsSubMenu.add(this.mcmd_.getAction(85, false, null));
        userPathsSubMenu.add(this.mcmd_.getAction(86, false, null));
        userPathsSubMenu.add(this.mcmd_.getAction(87, false, null));
        userPathsSubMenu.add(this.mcmd_.getAction(88, false, null));
        userPathsSubMenu.add(this.mcmd_.getAction(89, false, null));
        userPathsSubMenu.add(this.mcmd_.getAction(90, false, null));
        JMenu loMenu = new JMenu(rMan.getString("command.Layout"));
        loMenu.setMnemonic(rMan.getChar("command.LayoutMnem"));
        menuBar.add(loMenu);
        JMenu specLayoutMenu = new JMenu(rMan.getString("command.specLayoutMenu"));
        specLayoutMenu.setMnemonic(rMan.getChar("command.specLayoutMenuMnem"));
        loMenu.add(specLayoutMenu);
        specLayoutMenu.add(this.mcmd_.getAction(28, false, null));
        specLayoutMenu.add(this.mcmd_.getAction(112, false, null));
        specLayoutMenu.add(this.mcmd_.getAction(72, false, null));
        specLayoutMenu.add(this.mcmd_.getAction(71, false, null));
        specLayoutMenu.add(this.mcmd_.getAction(26, false, null));
        specLayoutMenu.add(this.mcmd_.getAction(108, false, null));
        loMenu.add(new JSeparator());
        loMenu.add(this.mcmd_.getAction(79, false, null));
        loMenu.add(this.mcmd_.getAction(50, false, null));
        loMenu.add(this.mcmd_.getAction(51, false, null));
        loMenu.add(this.mcmd_.getAction(58, false, null));
        loMenu.add(this.mcmd_.getAction(62, false, null));
        loMenu.add(this.mcmd_.getAction(115, false, null));
        JMenu fixOrthoSubMenu = new JMenu(rMan.getString("command.fixAllOrthoSubMenu"));
        fixOrthoSubMenu.setMnemonic(rMan.getChar("command.fixAllOrthoSubMenuMnem"));
        loMenu.add(fixOrthoSubMenu);
        fixOrthoSubMenu.add(this.mcmd_.getAction(110, false, null));
        fixOrthoSubMenu.add(this.mcmd_.getAction(111, false, null));
        loMenu.add(new JSeparator());
        JMenu centeringMenu = new JMenu(rMan.getString("command.centerMenu"));
        centeringMenu.setMnemonic(rMan.getChar("command.centerMenuMnem"));
        loMenu.add(centeringMenu);
        centeringMenu.add(this.mcmd_.getAction(78, false, null));
        centeringMenu.add(this.mcmd_.getAction(81, false, null));
        centeringMenu.add(this.mcmd_.getAction(59, false, null));
        loMenu.add(new JSeparator());
        JMenu layoutMenu = new JMenu(rMan.getString("command.layoutMenu"));
        layoutMenu.setMnemonic(rMan.getChar("command.layoutMenuMnem"));
        loMenu.add(layoutMenu);
        layoutMenu.add(this.mcmd_.getAction(52, false, null));
        layoutMenu.add(this.mcmd_.getAction(54, false, null));
        layoutMenu.add(this.mcmd_.getAction(75, false, null));
        layoutMenu.add(this.mcmd_.getAction(73, false, null));
        layoutMenu.add(this.mcmd_.getAction(55, false, null));
        loMenu.add(new JSeparator());
        loMenu.add(this.mcmd_.getAction(53, false, null));
        JMenu sMenu = new JMenu(rMan.getString("command.Tools"));
        sMenu.setMnemonic(rMan.getChar("command.ToolsMnem"));
        menuBar.add(sMenu);
        sMenu.add(this.mcmd_.getAction(48, false, null));
        sMenu.add(this.mcmd_.getAction(61, false, null));
        sMenu.add(new JSeparator());
        sMenu.add(this.mcmd_.getAction(43, false, null));
        sMenu.add(new JSeparator());
        sMenu.add(this.mcmd_.getAction(45, false, null));
        sMenu.add(this.mcmd_.getAction(63, false, null));
        JMenu dMenu = new JMenu(rMan.getString("command.Data"));
        dMenu.setMnemonic(rMan.getChar("command.DataMnem"));
        menuBar.add(dMenu);
        dMenu.add(this.mcmd_.getAction(38, false, null));
        dMenu.add(this.mcmd_.getAction(74, false, null));
        JMenu dMenu0 = new JMenu(rMan.getString("command.DataPert"));
        dMenu0.setMnemonic(rMan.getChar("command.DataQpcrMnem"));
        dMenu0.add(this.mcmd_.getAction(107, false, null));
        dMenu.add(dMenu0);
        JMenu dMenu2 = new JMenu(rMan.getString("command.DataTimeCourse"));
        dMenu2.setMnemonic(rMan.getChar("command.DataTimeCourseMnem"));
        dMenu2.add(this.mcmd_.getAction(33, false, null));
        dMenu2.add(this.mcmd_.getAction(68, false, null));
        dMenu2.add(this.mcmd_.getAction(36, false, null));
        dMenu.add(dMenu2);
        JMenu dMenu3 = new JMenu(rMan.getString("command.DataTemporalInputs"));
        dMenu3.setMnemonic(rMan.getChar("command.DataTemporalInputsMnem"));
        dMenu3.add(this.mcmd_.getAction(37, false, null));
        dMenu.add(dMenu3);
        if (this.doGaggle_ != null) {
            JMenu gMenu = new JMenu(rMan.getString("command.Gaggle"));
            gMenu.setMnemonic(rMan.getChar("command.GaggleMnem"));
            menuBar.add(gMenu);
            gMenu.add(gaggleGooseChooseMenu);
            gMenu.add(this.mcmd_.getAction(91, false, null));
            gMenu.add(this.mcmd_.getAction(92, false, null));
            gMenu.add(this.mcmd_.getAction(93, false, null));
            gMenu.add(this.mcmd_.getAction(94, false, null));
            gMenu.add(this.mcmd_.getAction(95, false, null));
            gMenu.add(this.mcmd_.getAction(96, false, null));
        }
        JMenu hMenu = new JMenu(rMan.getString("command.Help"));
        hMenu.setMnemonic(rMan.getChar("command.HelpMnem"));
        menuBar.add(hMenu);
        if (editorWindow != null) {
            JMenuItem hbItem = new JMenuItem(rMan.getString("command.HelpBrowser"), rMan.getChar("command.HelpBrowserMnem"));
            hbItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        ResourceManager rMan = ResourceManager.getManager();
                        JOptionPane.showMessageDialog(CommonView.this.topFrame_, UiUtil.convertMessageToHtml(rMan.getString("helpMsg.howToFindHelp")), rMan.getString("helpMsg.howToFindHelpTitle"), 2);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                    }
                }
            });
            hMenu.add(hbItem);
        }
        URL aurl = this.getClass().getResource("/org/systemsbiology/biotapestry/data/about.html");
        hMenu.add(this.mcmd_.getAction(25, false, new Object[]{aurl}));
        this.actionMap_ = new HashMap();
        this.stockActionMap();
        this.toolBar_ = new JToolBar();
        this.pathControlsVisible_ = false;
        this.stockEditorToolBar(false, false);
        this.pulldownSync_ = new SyncToggleWidgets(jcb, this.tb_, (MainCommands.ToggleAction)((Object)pda), (MainCommands.ToggleAction)((Object)this.pullwi_));
        if (this.topFrame_ != null) {
            this.topFrame_.setJMenuBar(menuBar);
        }
        this.buildCore(cp, this.toolBar_, false, doBig);
        NavTree navTree = Database.getDB().getNavTree();
        this.utpControl_.setTreeObjects(navTree, this.myTree_);
        TreePath dstp = navTree.getDefaultSelection();
        navTree.setSkipFlag(1);
        this.myTree_.setSelectionPath(dstp);
        navTree.setSkipFlag(0);
        this.sup_.fixCenterPoint(true, null, false);
    }

    public void stockActionMap() {
        this.actionMap_.put(new Integer(6), this.mcmd_.getAction(6, true, null));
        this.actionMap_.put(new Integer(10), this.mcmd_.getAction(10, true, null));
        this.actionMap_.put(new Integer(22), this.mcmd_.getAction(22, true, null));
        this.actionMap_.put(new Integer(23), this.mcmd_.getAction(23, true, null));
        this.actionMap_.put(new Integer(76), this.mcmd_.getAction(76, true, null));
        this.actionMap_.put(new Integer(114), this.mcmd_.getAction(114, true, null));
        this.actionMap_.put(new Integer(35), this.mcmd_.getAction(35, true, null));
        this.actionMap_.put(new Integer(113), this.mcmd_.getAction(113, true, null));
        this.actionMap_.put(new Integer(27), this.mcmd_.getAction(27, true, null));
        this.actionMap_.put(new Integer(77), this.mcmd_.getAction(77, true, null));
        this.actionMap_.put(new Integer(45), this.mcmd_.getAction(45, true, null));
        this.actionMap_.put(new Integer(18), this.mcmd_.getAction(18, true, null));
        this.actionMap_.put(new Integer(82), this.mcmd_.getAction(82, true, null));
        this.actionMap_.put(new Integer(47), this.mcmd_.getAction(47, true, null));
        this.actionMap_.put(new Integer(106), this.mcmd_.getAction(106, true, null));
        this.actionMap_.put(new Integer(97), this.mcmd_.getAction(97, true, null));
        this.actionMap_.put(new Integer(13), this.mcmd_.getAction(13, true, null));
        this.actionMap_.put(new Integer(16), this.mcmd_.getAction(16, true, null));
        this.actionMap_.put(new Integer(14), this.mcmd_.getAction(14, true, null));
        this.actionMap_.put(new Integer(39), this.mcmd_.getAction(39, true, null));
        this.actionMap_.put(new Integer(15), this.mcmd_.getAction(15, true, null));
        this.actionMap_.put(new Integer(17), this.mcmd_.getAction(17, true, null));
        this.actionMap_.put(new Integer(85), this.mcmd_.getAction(85, true, null));
        this.actionMap_.put(new Integer(86), this.mcmd_.getAction(86, true, null));
        this.actionMap_.put(new Integer(87), this.mcmd_.getAction(87, true, null));
        this.actionMap_.put(new Integer(88), this.mcmd_.getAction(88, true, null));
        this.actionMap_.put(new Integer(89), this.mcmd_.getAction(89, true, null));
        this.actionMap_.put(new Integer(90), this.mcmd_.getAction(90, true, null));
        this.actionMap_.put(new Integer(98), this.mcmd_.getAction(98, true, null));
        this.actionMap_.put(new Integer(99), this.mcmd_.getAction(99, true, null));
        this.actionMap_.put(new Integer(104), this.mcmd_.getAction(104, true, null));
        this.actionMap_.put(new Integer(105), this.mcmd_.getAction(105, true, null));
        if (this.doGaggle_ != null) {
            this.actionMap_.put(new Integer(91), this.mcmd_.getAction(91, true, null));
            this.actionMap_.put(new Integer(92), this.mcmd_.getAction(92, true, null));
            this.actionMap_.put(new Integer(93), this.mcmd_.getAction(93, true, null));
            this.actionMap_.put(new Integer(94), this.mcmd_.getAction(94, true, null));
            this.actionMap_.put(new Integer(95), this.mcmd_.getAction(95, true, null));
            this.actionMap_.put(new Integer(96), this.mcmd_.getAction(96, true, null));
        }
    }

    public void stockEditorToolBar(boolean showPathControls, boolean showOverlayControls) {
        this.toolBar_.removeAll();
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(6)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(10)));
        this.toolBar_.addSeparator();
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(22)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(23)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(76)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(114)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(35)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(113)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(27)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(77)));
        this.toolBar_.addSeparator();
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(45)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(18)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(82)));
        this.toolBar_.addSeparator();
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(47)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(106)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(97)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(13)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(16)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(14)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(39)));
        this.toolBar_.addSeparator();
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(15)));
        if (this.tb_ == null) {
            this.pullwi_ = (AbstractAction)this.actionMap_.get(new Integer(17));
            this.tb_ = new BTToggleButton(this.pullwi_);
        }
        this.toolBar_.add(this.tb_);
        this.toolBar_.addSeparator();
        if (showPathControls) {
            this.toolBar_.add(this.userPathsCombo_);
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(85)));
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(86)));
        }
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(87)));
        if (showPathControls) {
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(88)));
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(89)));
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(90)));
        }
        this.toolBar_.addSeparator();
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(98)));
        if (showOverlayControls) {
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(99)));
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(104)));
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(105)));
        }
        if (this.doGaggle_ != null) {
            boolean updateMcmd = false;
            this.toolBar_.addSeparator();
            if (this.gaggleUpdateGooseButton_ == null) {
                AbstractAction gaggleUpdate = (AbstractAction)this.actionMap_.get(new Integer(91));
                this.gaggleUpdateGooseButton_ = this.toolBar_.add(gaggleUpdate);
                updateMcmd = true;
            } else {
                this.toolBar_.add(this.gaggleUpdateGooseButton_);
            }
            this.toolBar_.add(this.gaggleGooseCombo_);
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(92)));
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(93)));
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(94)));
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(95)));
            if (this.gaggleInstallButton_ == null) {
                AbstractAction gaggleInstall = (AbstractAction)this.actionMap_.get(new Integer(96));
                this.gaggleInstallButton_ = this.toolBar_.add(gaggleInstall);
                updateMcmd = true;
            } else {
                this.toolBar_.add(this.gaggleInstallButton_);
            }
            if (updateMcmd) {
                this.mcmd_.setGaggleButtons(this.gaggleInstallButton_, this.gaggleUpdateGooseButton_, this.gaggleInstallButton_.getBackground());
            }
        }
    }

    public void disableControls(int pushFlags, boolean displayToo) {
        JSlider slider;
        this.mcmd_.pushDisabled(pushFlags);
        if (displayToo) {
            this.myCard_.show(this.hidingPanel_, "Hiding");
            this.sup_.acceptKeystrokes(false);
        }
        this.myTree_.setEnabled(false);
        if (this.currSlider_ != null && (slider = (JSlider)this.sliders_.get(this.currSlider_)) != null) {
            slider.setEnabled(false);
        }
        if (this.userPathsCombo_ != null) {
            this.userPathsCombo_.setEnabled(false);
        }
        if (this.gaggleGooseCombo_ != null) {
            this.gaggleGooseCombo_.setEnabled(false);
        }
        this.topFrame_.getContentPane().validate();
    }

    public void enableControls() {
        this.enableControls(false);
    }

    public void enableControls(boolean withFocus) {
        JSlider slider;
        this.mcmd_.popDisabled();
        this.myCard_.show(this.hidingPanel_, "SUPanel");
        this.sup_.acceptKeystrokes(true);
        this.myTree_.setEnabled(true);
        if (this.currSlider_ != null && (slider = (JSlider)this.sliders_.get(this.currSlider_)) != null) {
            slider.setEnabled(true);
        }
        if (this.userPathsCombo_ != null) {
            this.userPathsCombo_.setEnabled(true);
        }
        if (this.gaggleGooseCombo_ != null) {
            this.gaggleGooseCombo_.setEnabled(true);
        }
        if (this.topFrame_ != null) {
            this.topFrame_.getContentPane().validate();
        }
        if (withFocus) {
            this.sup_.requestFocus();
        }
    }

    public void cancelModals(int which) {
        if ((which & 1) == 0 && this.pulldownSync_ != null) {
            this.pulldownSync_.cancelled();
        }
    }

    public void enableModals(int which) {
        if ((which & 1) != 0 && this.pulldownSync_ != null) {
            this.pulldownSync_.activated();
        }
    }

    public void newModelTweaks() {
        this.mcmd_.newModelTweaks();
    }

    public void buildViewOnlyView(JFrame frame, Container cp, AppletContext ctxt, URL about, boolean bigScreen) {
        this.topFrame_ = frame;
        this.isEditor_ = false;
        cp.setLayout(new BorderLayout());
        this.undo_ = new UndoManager();
        this.undo_.setLimit(100);
        this.sup_ = new SUPanel(null, this, this.undo_, true);
        this.userPathsCombo_ = new FixedJComboBox(250);
        this.mcmd_ = MainCommands.initCmds(this, null, null, null, this.userPathsCombo_, null, null);
        this.utpControl_ = this.mcmd_.getPathController();
        this.noc_ = this.mcmd_.getOverlayController();
        this.actionMap_ = new HashMap();
        this.stockViewActionMap(ctxt, about);
        this.toolBar_ = new JToolBar();
        this.pathControlsVisible_ = false;
        this.stockViewerToolBar(false);
        this.toolBar_.setFloatable(false);
        this.myTree_ = new PopupTree(Database.getDB().getNavTree(), true, this, bigScreen);
        this.buildCore(cp, this.toolBar_, true, bigScreen);
        NavTree navTree = Database.getDB().getNavTree();
        this.utpControl_.setTreeObjects(navTree, this.myTree_);
    }

    public void stockViewActionMap(AppletContext ctxt, URL about) {
        this.actionMap_.put(new Integer(22), this.mcmd_.getAction(22, true, null));
        this.actionMap_.put(new Integer(23), this.mcmd_.getAction(23, true, null));
        this.actionMap_.put(new Integer(76), this.mcmd_.getAction(76, true, null));
        this.actionMap_.put(new Integer(114), this.mcmd_.getAction(114, true, null));
        this.actionMap_.put(new Integer(35), this.mcmd_.getAction(35, true, null));
        this.actionMap_.put(new Integer(113), this.mcmd_.getAction(113, true, null));
        this.actionMap_.put(new Integer(27), this.mcmd_.getAction(27, true, null));
        this.actionMap_.put(new Integer(77), this.mcmd_.getAction(77, true, null));
        this.actionMap_.put(new Integer(45), this.mcmd_.getAction(45, true, null));
        this.actionMap_.put(new Integer(82), this.mcmd_.getAction(82, true, null));
        if (ctxt == null) {
            this.actionMap_.put(new Integer(25), this.mcmd_.getAction(25, true, new Object[]{about}));
        } else {
            this.actionMap_.put(new Integer(24), this.mcmd_.getAction(24, true, new Object[]{ctxt, about}));
        }
        this.actionMap_.put(new Integer(85), this.mcmd_.getAction(85, true, null));
        this.actionMap_.put(new Integer(86), this.mcmd_.getAction(86, true, null));
    }

    public void stockViewerToolBar(boolean showPathControls) {
        this.toolBar_.removeAll();
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(22)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(23)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(76)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(114)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(35)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(113)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(27)));
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(77)));
        this.toolBar_.addSeparator();
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(45)));
        this.toolBar_.addSeparator();
        this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(82)));
        this.toolBar_.addSeparator();
        AbstractAction aboutAct = (AbstractAction)this.actionMap_.get(new Integer(24));
        if (aboutAct == null) {
            aboutAct = (AbstractAction)this.actionMap_.get(new Integer(25));
        }
        this.toolBar_.add(aboutAct);
        if (showPathControls) {
            this.toolBar_.addSeparator();
            this.toolBar_.add(this.userPathsCombo_);
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(85)));
            this.toolBar_.add((AbstractAction)this.actionMap_.get(new Integer(86)));
        }
    }

    public void buildViewOnlyView(JFrame frame, Container cp, URL about, boolean bigScreen) {
        this.topFrame_ = frame;
        this.isEditor_ = false;
        cp.setLayout(new BorderLayout());
        this.undo_ = new UndoManager();
        this.undo_.setLimit(100);
        this.sup_ = new SUPanel(null, this, this.undo_, true);
        this.userPathsCombo_ = new FixedJComboBox(250);
        this.mcmd_ = MainCommands.initCmds(this, null, null, null, this.userPathsCombo_, null, null);
        this.utpControl_ = this.mcmd_.getPathController();
        this.noc_ = this.mcmd_.getOverlayController();
        this.actionMap_ = new HashMap();
        this.stockViewActionMap(null, about);
        this.toolBar_ = new JToolBar();
        this.pathControlsVisible_ = false;
        this.stockViewerToolBar(false);
        this.toolBar_.setFloatable(false);
        this.myTree_ = new PopupTree(Database.getDB().getNavTree(), true, this, bigScreen);
        this.buildCore(cp, this.toolBar_, true, bigScreen);
        NavTree navTree = Database.getDB().getNavTree();
        this.utpControl_.setTreeObjects(navTree, this.myTree_);
    }

    private void buildCore(Container cp, JToolBar toolBar, boolean readOnly, boolean bigScreen) {
        this.sliders_ = new HashMap();
        cp.add((Component)toolBar, "North");
        this.jsp_ = new JScrollPane(this.sup_);
        this.hidingPanel_ = new JPanel();
        this.myCard_ = new CardLayout();
        this.hidingPanel_.setLayout(this.myCard_);
        this.hidingPanel_.add((Component)this.jsp_, "SUPanel");
        JPanel blankPanel = new JPanel();
        blankPanel.setBackground(Color.white);
        this.hidingPanel_.add((Component)blankPanel, "Hiding");
        this.sup_.setScrollPane(this.jsp_);
        this.jsp_.setHorizontalScrollBarPolicy(32);
        this.jsp_.setVerticalScrollBarPolicy(22);
        ZoomCommandSupport zcs = this.mcmd_.getZoomController();
        zcs.registerScrollPaneAndZoomTarget(this.jsp_, this.sup_);
        this.myTree_.setRootVisible(false);
        this.myTree_.setFont(FontManager.getMgr().getFixedFont(0));
        this.myTree_.getSelectionModel().setSelectionMode(1);
        JScrollPane tjsp = new JScrollPane(this.myTree_);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        UiUtil.gbcSet(gbc, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0, 11, 1.0, 1.0);
        controlPanel.add((Component)tjsp, gbc);
        this.mip_ = new ModelImagePanel(this.topFrame_);
        this.mip_.setBorder(new LineBorder(Color.black, 1));
        this.mip_.setImage(null);
        this.mipVisible_ = false;
        this.mip_.setMinimumSize(new Dimension(250, 0));
        this.mip_.setPreferredSize(new Dimension(250, 0));
        this.ovrPanel_ = this.noc_.getNetOverlayNavigator();
        this.ovrPanel_.setBorder(new LineBorder(Color.black, 1));
        this.ovrVisible_ = false;
        this.ovrPanel_.setMinimumSize(new Dimension(250, 0));
        this.ovrPanel_.setPreferredSize(new Dimension(250, 0));
        this.sliderPanel_ = new JPanel();
        this.sliderPanel_.setBorder(new LineBorder(Color.black, 1));
        this.sliderVisible_ = false;
        this.sliderPanel_.setMinimumSize(new Dimension(250, 0));
        this.sliderPanel_.setPreferredSize(new Dimension(250, 0));
        this.sliderPanel_.setLayout(new GridLayout());
        this.blankPanel_ = new JPanel();
        this.sliderPanel_.add(this.blankPanel_);
        UiUtil.gbcSet(gbc, 0, 2, 1, 1, 2, 0, 0, 0, 0, 0, 0, 10, 1.0, 0.0);
        controlPanel.add((Component)this.sliderPanel_, gbc);
        UiUtil.gbcSet(gbc, 0, 3, 1, 1, 2, 0, 0, 0, 0, 0, 0, 10, 1.0, 0.0);
        controlPanel.add((Component)this.ovrPanel_, gbc);
        UiUtil.gbcSet(gbc, 0, 4, 1, 1, 2, 0, 0, 0, 0, 0, 0, 10, 1.0, 0.0);
        controlPanel.add((Component)this.mip_, gbc);
        this.layoutMgr_ = new LayoutManager();
        JTextPane jtp = this.sup_.getTextBoxManager().getTextPane();
        if (bigScreen) {
            Font tpFont = jtp.getFont();
            String fontName = tpFont.getName();
            int fontType = tpFont.getStyle();
            jtp.setFont(new Font(fontName, fontType, 20));
        }
        jtp.setMinimumSize(new Dimension(640, bigScreen ? 75 : 50));
        jtp.setPreferredSize(new Dimension(640, bigScreen ? 75 : 50));
        jtp.setEditable(false);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridLayout());
        JScrollPane txtsp = new JScrollPane(jtp, 20, 31);
        textPanel.add(txtsp);
        JPanel topPanel = new JPanel();
        this.myTree_.addTreeSelectionListener(this);
        this.jsp_.setMinimumSize(new Dimension(150, 150));
        tjsp.setMinimumSize(new Dimension(250, 250));
        this.myTree_.setMinimumSize(new Dimension(250, 250));
        controlPanel.setMinimumSize(new Dimension(250, 250));
        JSplitPane sp = new JSplitPane(1, controlPanel, this.hidingPanel_);
        topPanel.setLayout(new GridLayout(1, 1));
        topPanel.add(sp);
        cp.add((Component)topPanel, "Center");
        cp.add((Component)textPanel, "South");
        DisplayOptionsManager.getMgr().setForBigScreen(bigScreen);
        EventManager mgr = EventManager.getManager();
        mgr.addModelChangeListener(this);
        SelectionChangeEvent ev = new SelectionChangeEvent(null, null, 2);
        mgr.sendSelectionChangeEvent(ev);
    }

    public void makeImageVisible(boolean show) {
        if (this.mipVisible_ == show) {
            return;
        }
        int height = show ? 200 : 0;
        this.mip_.setMinimumSize(new Dimension(250, height));
        this.mip_.setPreferredSize(new Dimension(250, height));
        this.mip_.invalidate();
        this.topFrame_.getContentPane().validate();
        this.mipVisible_ = show;
    }

    public void makeOverlayControlsVisible(boolean show) {
        if (this.ovrVisible_ == show) {
            if (this.toolBar_ != null && this.topFrame_ != null) {
                this.toolBar_.invalidate();
                this.topFrame_.getContentPane().validate();
                this.toolBar_.repaint();
            }
            return;
        }
        if (this.isEditor_) {
            this.stockEditorToolBar(this.pathControlsVisible_, show);
        }
        int height = show ? 250 : 0;
        this.ovrPanel_.setMinimumSize(new Dimension(250, height));
        this.ovrPanel_.setPreferredSize(new Dimension(250, height));
        this.ovrPanel_.invalidate();
        if (this.toolBar_ != null) {
            this.toolBar_.invalidate();
        }
        if (this.topFrame_ != null) {
            this.topFrame_.getContentPane().validate();
        }
        if (this.toolBar_ != null) {
            this.toolBar_.repaint();
        }
        this.ovrVisible_ = show;
    }

    public void makeSliderVisible(boolean show) {
        if (this.sliderVisible_ == show) {
            return;
        }
        int height = show ? 75 : 0;
        this.sliderPanel_.setMinimumSize(new Dimension(250, height));
        this.sliderPanel_.setPreferredSize(new Dimension(250, height));
        this.sliderPanel_.invalidate();
        this.topFrame_.getContentPane().validate();
        this.sliderVisible_ = show;
    }

    public void makePathControlsVisible(boolean show) {
        if (this.pathControlsVisible_ == show) {
            if (this.toolBar_ != null && this.topFrame_ != null) {
                this.toolBar_.invalidate();
                this.topFrame_.getContentPane().validate();
                this.toolBar_.repaint();
            }
            return;
        }
        if (this.isEditor_) {
            this.stockEditorToolBar(show, this.ovrVisible_);
        } else {
            this.stockViewerToolBar(show);
        }
        if (this.toolBar_ != null && this.topFrame_ != null) {
            this.toolBar_.invalidate();
            this.topFrame_.getContentPane().validate();
            this.toolBar_.repaint();
        }
        this.pathControlsVisible_ = show;
    }

    public SUPanel getSUPanel() {
        return this.sup_;
    }

    public LayoutManager getLayoutMgr() {
        return this.layoutMgr_;
    }

    public JTree getTree() {
        return this.myTree_;
    }

    public JScrollPane getScrollPane() {
        return this.jsp_;
    }

    public UndoManager getUndoManager() {
        return this.undo_;
    }

    public JFrame getWindow() {
        return this.topFrame_;
    }

    public String getCurrentSliderKey(DynamicInstanceProxy dip) {
        JSlider slider = (JSlider)this.sliders_.get(dip.getID());
        int val = slider == null ? dip.getMinimumTime() : slider.getValue();
        return dip.getKeyForTime(val, true);
    }

    public void valueChanged(TreeSelectionEvent e) {
        try {
            UserTreePathController.PathNavigationInfo pni = this.utpControl_.getPendingNavUndo();
            UndoSupport support = pni == null ? new UndoSupport(this.undo_, "undo.treeSelection") : pni.support;
            TreePath tp = this.myTree_.getSelectionPath();
            Database db = Database.getDB();
            String genomeID = db.getNavTree().getGenomeID(tp);
            String proxyID = db.getNavTree().getDynamicProxyID(tp);
            if (genomeID != null) {
                this.sliderPanel_.remove(0);
                this.sliderPanel_.add(this.blankPanel_);
                this.sliderPanel_.revalidate();
                this.sliderPanel_.repaint();
                this.loadGenome(genomeID, support);
            } else if (proxyID != null) {
                DynamicInstanceProxy dip = db.getDynamicProxy(proxyID);
                this.currDip_ = proxyID;
                this.manageSliderSetup(dip, null);
                this.sliderPanel_.remove(0);
                this.sliderPanel_.add(this.currSliderPanel_);
                this.sliderPanel_.revalidate();
                this.sliderPanel_.repaint();
                genomeID = dip.getKeyForTime(this.lastSetting_, true);
                this.loadGenome(genomeID, support);
            } else if (!this.myTree_.ignoreSelection()) {
                this.sliderPanel_.remove(0);
                this.sliderPanel_.add(this.blankPanel_);
                this.sliderPanel_.revalidate();
                this.sliderPanel_.repaint();
                this.sup_.setGraphLayout(null);
                if (!this.doingUndo_) {
                    this.sup_.setGenome(genomeID, support);
                } else {
                    this.sup_.setGenomeForUndo(genomeID);
                }
                this.sup_.revalidate();
                this.sup_.repaint();
            }
            NavTree nt = db.getNavTree();
            if (!(this.doingUndo_ || nt.amDoingUndo() || this.myTree_.amDoingUndo() || nt.getSkipFlag() == 1)) {
                NavigationChange nc;
                NavigationChange navigationChange = nc = pni == null ? new NavigationChange() : pni.nav;
                if (pni == null) {
                    this.utpControl_.syncPathControls(nc);
                }
                nc.newPath = tp;
                nc.oldPath = this.lastPath_;
                nc.commonView = this;
                support.addEdit(new NavigationChangeCmd(nc));
                if (nt.getSkipFlag() != 2) {
                    if (pni == null) {
                        support.finish();
                    } else {
                        pni.finish();
                    }
                }
            }
            this.lastPath_ = tp;
            SelectionChangeEvent ev = new SelectionChangeEvent(genomeID, null, 2);
            EventManager.getManager().sendSelectionChangeEvent(ev);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void modelHasChanged(ModelChangeEvent event, int remaining) {
        this.modelHasChanged(event);
    }

    public void modelHasChanged(ModelChangeEvent mcev) {
        if (mcev.getChangeType() == 2) {
            this.sliders_.clear();
            this.makeImageVisible(ImageManager.getMgr().hasAnImage());
            this.makeOverlayControlsVisible(this.mcmd_.getOverlayController().aModelHasOverlays());
            this.makeSliderVisible(new FullGenomeHierarchyOracle().hourlyDynamicModelExists());
            this.mip_.setImage(null);
            this.mip_.repaint();
            return;
        }
        if (mcev.getChangeType() == 5) {
            this.makeSliderVisible(new FullGenomeHierarchyOracle().hourlyDynamicModelExists());
        }
        this.makeOverlayControlsVisible(this.mcmd_.getOverlayController().aModelHasOverlays());
        Database db = Database.getDB();
        if (mcev.getChangeType() == 3) {
            if (!this.isCurrentlyDisplayed(mcev)) {
                this.ditchSliderIfStale(mcev);
            } else if (this.isDynamic()) {
                if (this.noLongerHourly(mcev)) {
                    this.hideAndDitchSlider(mcev);
                } else if (this.newlyHourly(mcev)) {
                    this.setupAndDisplayNewSlider(mcev, this.frozenSlider_);
                    this.frozenSlider_ = null;
                } else if (this.hourlyChange(mcev)) {
                    this.ditchOldAndDisplayNewSlider(mcev, this.frozenSlider_);
                    this.frozenSlider_ = null;
                }
                String id = null;
                if (mcev.isProxyKey()) {
                    String proxID = mcev.getProxyKey();
                    id = db.getDynamicProxy(proxID).getKeyForTime(this.lastSetting_, true);
                } else {
                    id = mcev.getGenomeKey();
                }
                this.loadGenome(id, null);
            } else {
                this.sup_.getTextBoxManager().checkForChanges(mcev);
                String id = mcev.getGenomeKey();
                Genome currGenome = db.getGenome(id);
                String mi = currGenome.getGenomeImage();
                BufferedImage bi = ImageManager.getMgr().getImage(mi);
                this.makeImageVisible(ImageManager.getMgr().hasAnImage());
                this.mip_.setImage(bi);
                this.mip_.repaint();
                this.sup_.revalidate();
                this.sup_.repaint();
            }
            this.updateNavTreeNames(mcev);
        }
    }

    private boolean isCurrentlyDisplayed(ModelChangeEvent mcev) {
        String id;
        String currID = this.sup_.getGenome();
        if (currID == null) {
            return false;
        }
        String proxyID = null;
        if (DynamicInstanceProxy.isDynamicInstance(currID)) {
            proxyID = DynamicInstanceProxy.extractProxyID(currID);
        }
        if ((id = mcev.getOldKey()) != null) {
            if (mcev.oldKeyIsProxy()) {
                return proxyID != null && id.equals(proxyID);
            }
            return id.equals(currID);
        }
        if (mcev.isProxyKey()) {
            return proxyID != null && mcev.getProxyKey().equals(proxyID);
        }
        return mcev.getGenomeKey().equals(currID);
    }

    private void ditchSliderIfStale(ModelChangeEvent mcev) {
        String id = null;
        if (mcev.isProxyKey()) {
            id = mcev.getProxyKey();
        } else if (mcev.oldKeyIsProxy()) {
            id = mcev.getOldKey();
        } else {
            return;
        }
        JSlider slider = (JSlider)this.sliders_.get(id);
        if (slider != null) {
            DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(id);
            int dipMin = dip.getMinimumTime();
            int dipMax = dip.getMaximumTime();
            if (slider.getMinimum() != dipMin || slider.getMaximum() != dipMax) {
                this.sliders_.remove(id);
            }
        }
    }

    private boolean isDynamic() {
        TreePath tp = this.myTree_.getSelectionPath();
        Database db = Database.getDB();
        String genomeID = db.getNavTree().getGenomeID(tp);
        String proxyID = db.getNavTree().getDynamicProxyID(tp);
        return proxyID != null || DynamicInstanceProxy.isDynamicInstance(genomeID);
    }

    private boolean noLongerHourly(ModelChangeEvent mcev) {
        return mcev.getOldKey() != null && mcev.oldKeyIsProxy() && !mcev.isProxyKey();
    }

    private boolean newlyHourly(ModelChangeEvent mcev) {
        return mcev.getOldKey() != null && !mcev.oldKeyIsProxy() && mcev.isProxyKey();
    }

    private boolean hourlyChange(ModelChangeEvent mcev) {
        if (!mcev.isProxyKey()) {
            return false;
        }
        String id = mcev.getProxyKey();
        JSlider slider = (JSlider)this.sliders_.get(id);
        if (slider == null) {
            throw new IllegalStateException();
        }
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(id);
        int dipMin = dip.getMinimumTime();
        int dipMax = dip.getMaximumTime();
        return slider.getMinimum() != dipMin || slider.getMaximum() != dipMax;
    }

    private void hideAndDitchSlider(ModelChangeEvent mcev) {
        String id = mcev.getOldKey();
        if (id == null || !mcev.oldKeyIsProxy()) {
            throw new IllegalStateException();
        }
        JSlider slider = (JSlider)this.sliders_.get(id);
        if (slider != null) {
            this.sliders_.remove(id);
        }
        this.sliderPanel_.remove(0);
        this.sliderPanel_.add(this.blankPanel_);
        this.sliderPanel_.revalidate();
        this.sliderPanel_.repaint();
    }

    private void setupAndDisplayNewSlider(ModelChangeEvent mcev, Integer time) {
        String id = mcev.getProxyKey();
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(id);
        this.currDip_ = id;
        this.manageSliderSetup(dip, time);
        this.sliderPanel_.remove(0);
        this.sliderPanel_.add(this.currSliderPanel_);
        this.sliderPanel_.revalidate();
        this.sliderPanel_.repaint();
    }

    private void ditchOldAndDisplayNewSlider(ModelChangeEvent mcev, Integer time) {
        String id = mcev.getProxyKey();
        JSlider slider = (JSlider)this.sliders_.get(id);
        if (slider != null) {
            this.sliders_.remove(id);
        }
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(id);
        this.currDip_ = id;
        this.manageSliderSetup(dip, time);
        this.sliderPanel_.remove(0);
        this.sliderPanel_.add(this.currSliderPanel_);
        this.sliderPanel_.revalidate();
        this.sliderPanel_.repaint();
    }

    public void updateNavTreeNames(ModelChangeEvent mcev) {
        String id = mcev.isProxyKey() ? mcev.getProxyKey() : mcev.getGenomeKey();
        NavTree navTree = Database.getDB().getNavTree();
        navTree.nodeNameRefresh(id);
        this.myTree_.revalidate();
        this.myTree_.repaint();
    }

    public void setSliderForTime(DynamicInstanceProxy dip, int newTime) {
        JSlider slider = (JSlider)this.sliders_.get(dip.getID());
        slider.setValue(newTime);
    }

    public void changeUndo(NavigationChange undo) {
        if (undo.userPathSelection || undo.userPathSync) {
            this.utpControl_.changeUndo(undo);
        }
        if (undo.odc != null) {
            OverlayDisplayChange odc = undo.odc;
            NetOverlayController noc = this.mcmd_.getOverlayController();
            if (odc.oldOvrKey != null || odc.newOvrKey != null) {
                boolean differentModel;
                if (odc.oldGenomeID == null) {
                    differentModel = odc.newGenomeID != null;
                } else {
                    boolean bl = differentModel = !odc.oldGenomeID.equals(odc.newGenomeID);
                }
                if (differentModel) {
                    noc.preloadForNextGenome(odc.oldGenomeID, odc.oldOvrKey, odc.oldModKeys, odc.oldRevealedKeys);
                } else {
                    noc.setFullOverlayState(odc.oldOvrKey, odc.oldModKeys, odc.oldRevealedKeys, null);
                }
            }
        }
        if (undo.oldPath != null) {
            this.doingUndo_ = true;
            NavTree navTree = Database.getDB().getNavTree();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)navTree.getRoot();
            this.myTree_.setSelectionPath(navTree.mapPath(undo.oldPath, root));
            this.doingUndo_ = false;
        } else if (undo.sliderID != null) {
            this.doingUndo_ = true;
            JSlider slider = (JSlider)this.sliders_.get(undo.sliderID);
            slider.setValue(undo.oldHour);
            this.doingUndo_ = false;
        }
    }

    public void changeRedo(NavigationChange undo) {
        if (undo.userPathSelection || undo.userPathSync) {
            this.utpControl_.changeRedo(undo);
        }
        if (undo.odc != null) {
            OverlayDisplayChange odc = undo.odc;
            NetOverlayController noc = this.mcmd_.getOverlayController();
            if (odc.oldOvrKey != null || odc.newOvrKey != null) {
                boolean differentModel;
                if (odc.newGenomeID == null) {
                    differentModel = odc.oldGenomeID != null;
                } else {
                    boolean bl = differentModel = !odc.newGenomeID.equals(odc.oldGenomeID);
                }
                if (differentModel) {
                    noc.preloadForNextGenome(odc.newGenomeID, odc.newOvrKey, odc.newModKeys, odc.newRevealedKeys);
                } else {
                    noc.setFullOverlayState(odc.newOvrKey, odc.newModKeys, odc.newRevealedKeys, null);
                }
            }
        }
        if (undo.newPath != null) {
            this.doingUndo_ = true;
            NavTree navTree = Database.getDB().getNavTree();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)navTree.getRoot();
            this.myTree_.setSelectionPath(navTree.mapPath(undo.newPath, root));
            this.doingUndo_ = false;
        } else if (undo.sliderID != null) {
            this.doingUndo_ = true;
            JSlider slider = (JSlider)this.sliders_.get(undo.sliderID);
            slider.setValue(undo.newHour);
            this.doingUndo_ = false;
        }
    }

    public void preloadWithoutRefresh() {
        Database db = Database.getDB();
        NavTree navTree = db.getNavTree();
        TreePath dstp = navTree.getDefaultSelection();
        String genomeID = navTree.getGenomeID(dstp);
        String proxyID = navTree.getDynamicProxyID(dstp);
        if (genomeID != null) {
            String layoutID = this.layoutMgr_.getLayout(genomeID);
            this.sup_.setGraphLayout(layoutID);
            this.sup_.setGenomeForUndo(genomeID);
        } else if (proxyID != null) {
            DynamicInstanceProxy dip = db.getDynamicProxy(proxyID);
            int min = dip.getMinimumTime();
            genomeID = dip.getKeyForTime(min, true);
            String layoutID = this.layoutMgr_.getLayout(genomeID);
            this.sup_.setGraphLayout(layoutID);
            this.sup_.setGenomeForUndo(genomeID);
        } else {
            this.sup_.setGraphLayout(null);
            this.sup_.setGenomeForUndo(genomeID);
        }
    }

    private void loadGenome(String genomeID, UndoSupport support) {
        DisplayOptions dop = DisplayOptionsManager.getMgr().getDisplayOptions();
        int navZoomMode = dop.getNavZoomMode();
        String oldLayoutID = this.sup_.getLayoutKey();
        String layoutID = this.layoutMgr_.getLayout(genomeID);
        Database db = Database.getDB();
        Genome currGenome = db.getGenome(genomeID);
        if (currGenome == null) {
            System.err.println("No genome: " + genomeID);
            throw new IllegalStateException();
        }
        this.sup_.setGraphLayout(layoutID);
        if (!this.doingUndo_ && support != null) {
            this.sup_.setGenome(genomeID, support);
        } else {
            this.sup_.setGenomeForUndo(genomeID);
        }
        if (!(navZoomMode != 1 || oldLayoutID != null && oldLayoutID.equals(layoutID))) {
            this.mcmd_.getZoomController().zoomToModel();
        }
        this.sup_.revalidate();
        this.sup_.repaint();
        String mi = currGenome.getGenomeImage();
        BufferedImage bi = ImageManager.getMgr().getImage(mi);
        this.makeImageVisible(ImageManager.getMgr().hasAnImage());
        this.mip_.setImage(bi);
        this.mip_.repaint();
        this.makeOverlayControlsVisible(this.mcmd_.getOverlayController().aModelHasOverlays());
        this.makeSliderVisible(new FullGenomeHierarchyOracle().hourlyDynamicModelExists());
    }

    public void stateChanged(ChangeEvent e) {
        try {
            if (this.managing_) {
                return;
            }
            JSlider slider = (JSlider)e.getSource();
            if (!slider.getValueIsAdjusting()) {
                int value = slider.getValue();
                if (value == this.lastSetting_) {
                    return;
                }
                UserTreePathController.PathNavigationInfo pni = this.utpControl_.getPendingNavUndo();
                UndoSupport support = pni == null ? new UndoSupport(this.undo_, "undo.sliderPos") : pni.support;
                NavigationChange nc = pni == null ? new NavigationChange() : pni.nav;
                nc.commonView = this;
                if (!this.doingUndo_) {
                    nc.oldHour = this.lastSetting_;
                }
                Database db = Database.getDB();
                DynamicInstanceProxy dip = db.getDynamicProxy(this.currDip_);
                String genomeID = dip.getKeyForTime(value, true);
                this.lastSetting_ = value;
                this.loadGenome(genomeID, support);
                if (!this.doingUndo_) {
                    if (pni == null) {
                        this.utpControl_.syncPathControls(nc);
                    }
                    nc.newHour = value;
                    nc.sliderID = dip.getID();
                    support.addEdit(new NavigationChangeCmd(nc));
                    if (pni == null) {
                        support.finish();
                    } else {
                        pni.finish();
                    }
                }
                SelectionChangeEvent ev = new SelectionChangeEvent(genomeID, null, 2);
                EventManager.getManager().sendSelectionChangeEvent(ev);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    private JSlider buildSlider(DynamicInstanceProxy dip, Integer time) {
        int timeVal;
        int min = dip.getMinimumTime();
        int max = dip.getMaximumTime();
        JSlider slider = new JSlider(0, min, max, min);
        slider.setMinorTickSpacing(1);
        int spacing = max - min < 6 ? 1 : 3;
        slider.setMajorTickSpacing(spacing);
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        if (tad.haveNamedStages()) {
            Hashtable<Integer, JLabel> namedStageMap = new Hashtable<Integer, JLabel>();
            List stages = tad.getNamedStages();
            int numStage = stages.size();
            for (int i = 0; i < numStage; ++i) {
                String stageName = ((TimeAxisDefinition.NamedStage)stages.get((int)i)).abbrev;
                namedStageMap.put(new Integer(i), new JLabel(stageName));
            }
            slider.setLabelTable(namedStageMap);
        } else {
            slider.setLabelTable(slider.createStandardLabels(spacing));
        }
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setSnapToTicks(true);
        if (time != null && (timeVal = time.intValue()) >= min && timeVal <= max) {
            slider.setValue(time);
        }
        slider.addChangeListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        this.currSliderPanel_ = new JPanel();
        this.currSliderPanel_.setLayout(new GridBagLayout());
        UiUtil.gbcSet(gbc, 0, 0, 1, 2, 1, 0, 0, 5, 5, 0, 5, 11, 1.0, 1.0);
        this.currSliderPanel_.add((Component)slider, gbc);
        UiUtil.gbcSet(gbc, 0, 2, 1, 1, 2, 0, 0, 0, 0, 5, 0, 10, 1.0, 0.0);
        String displayUnits = tad.unitDisplayString();
        this.currSliderPanel_.add((Component)new JLabel(displayUnits, 0), gbc);
        return slider;
    }

    public SliderChange recordSliderStateForUndo() {
        this.frozenSlider_ = new Integer(this.lastSetting_);
        SliderChange retval = new SliderChange();
        retval.cview = this;
        retval.timeVal = this.frozenSlider_;
        return retval;
    }

    public void restoreSliderState(Integer timeVal) {
        this.frozenSlider_ = timeVal;
    }

    private void manageSliderSetup(DynamicInstanceProxy dip, Integer time) {
        this.managing_ = true;
        JSlider slider = (JSlider)this.sliders_.get(dip.getID());
        if (slider == null) {
            slider = this.buildSlider(dip, time);
            this.sliders_.put(dip.getID(), slider);
        } else {
            this.currSliderPanel_ = (JPanel)slider.getParent();
        }
        this.currSlider_ = dip.getID();
        this.lastSetting_ = slider.getValue();
        this.managing_ = false;
    }

    public PasswordEvaluation processConnectionHeader(URL url, String args) throws IOException {
        URLConnection connect = url.openConnection();
        connect.setDoOutput(true);
        PrintWriter out = new PrintWriter(connect.getOutputStream());
        out.print(args);
        out.close();
        PasswordEvaluation retval = new PasswordEvaluation();
        String warningValue = connect.getHeaderField("Warning");
        retval.failure = warningValue != null && warningValue.equals("717 Failed Login");
        retval.stream = connect.getInputStream();
        return retval;
    }

    public boolean loadRemoteGenome(URL url, URL saltUrl, boolean isViewer) {
        PasswordEvaluation pEval;
        Database db;
        block11: {
            db = Database.getDB();
            pEval = null;
            boolean retval = true;
            try {
                String args;
                if (saltUrl != null && (args = this.getPasswordString(saltUrl)) != null) {
                    pEval = this.processConnectionHeader(url, args);
                }
            }
            catch (IOException ioe) {
                this.mcmd_.displayFileInputError(ioe);
                db.drop();
                this.mcmd_.manageWindowTitle(null);
                this.mcmd_.newModelOperations();
                this.sup_.revalidate();
                this.sup_.repaint();
                return pEval != null ? !pEval.failure : true;
            }
            db.drop();
            db.setWorkspaceNeedsCenter();
            db.installLegacyTimeAxisDefinition();
            GroupSettingManager.getGroupMgr().drop();
            ArrayList<DatabaseFactory> alist = new ArrayList<DatabaseFactory>();
            alist.add(new DatabaseFactory(isViewer));
            SUParser sup = new SUParser(alist);
            try {
                if (pEval != null) {
                    sup.parse(pEval.stream);
                } else {
                    sup.parse(url);
                }
                db.legacyIOFixup(this.topFrame_);
                if (!url.getProtocol().toLowerCase().equals("file")) break block11;
                try {
                    String path = url.getPath();
                    path = URLDecoder.decode(path, "UTF-8");
                    if (!path.trim().equals("")) {
                        this.mcmd_.setCurrentFile(new File(path));
                    }
                }
                catch (UnsupportedEncodingException ueex) {
                    throw new IllegalStateException();
                }
            }
            catch (IOException ioe) {
                this.mcmd_.displayFileInputError(ioe);
                db.drop();
                this.mcmd_.manageWindowTitle(null);
                this.mcmd_.newModelOperations();
                this.sup_.revalidate();
                this.sup_.repaint();
                return pEval != null ? !pEval.failure : true;
            }
        }
        if (db.getGenome() == null) {
            this.mcmd_.displayFileInputError(null);
            db.drop();
            this.mcmd_.manageWindowTitle(null);
            this.mcmd_.newModelOperations();
            this.sup_.revalidate();
            this.sup_.repaint();
            return pEval != null ? !pEval.failure : true;
        }
        this.mcmd_.manageWindowTitle(url.toString());
        this.mcmd_.postLoadOperations(false);
        this.sup_.revalidate();
        this.sup_.repaint();
        return pEval != null ? !pEval.failure : true;
    }

    public void embeddedPanelInit() {
        Database db = Database.getDB();
        db.drop();
        db.setWorkspaceNeedsCenter();
        db.installLegacyTimeAxisDefinition();
        GroupSettingManager.getGroupMgr().drop();
        this.mcmd_.newModelOperations();
        this.sup_.revalidate();
        this.sup_.repaint();
    }

    public String getPasswordString(URL saltUrl) {
        LoginDialog ld = new LoginDialog(this.topFrame_);
        ld.setVisible(true);
        if (!ld.haveResult()) {
            return null;
        }
        String user = ld.getUserName();
        char[] password = ld.getPassword();
        String passAsString = new String(password);
        for (int i = 0; i < password.length; ++i) {
            password[i] = '\u0000';
        }
        return DataUtil.buildPasswordString(saltUrl, user, passAsString);
    }

    public URL getURLFromArgs(Map args) throws MalformedURLException {
        URL retval = null;
        boolean failure = false;
        String resourceSrc = (String)args.get("resource");
        if (resourceSrc != null && (retval = this.getClass().getResource(resourceSrc)) == null) {
            failure = true;
        }
        if (retval != null) {
            return retval;
        }
        String remSrc = (String)args.get("remote");
        if (remSrc != null) {
            try {
                retval = new URL(remSrc);
            }
            catch (MalformedURLException mue) {
                failure = true;
            }
        }
        if (retval != null) {
            return retval;
        }
        String fileSrc = (String)args.get("file");
        if (fileSrc != null) {
            File fileArg = new File(fileSrc);
            if (fileArg.exists() && fileArg.isFile() && fileArg.canRead()) {
                retval = fileArg.toURI().toURL();
            } else {
                failure = true;
            }
        }
        if (retval != null) {
            return retval;
        }
        if (failure) {
            throw new MalformedURLException();
        }
        return null;
    }

    public URL getSaltURLFromArgs(Map args) throws MalformedURLException {
        String saltSrc = (String)args.get("salt");
        if (saltSrc != null) {
            return new URL(saltSrc);
        }
        return null;
    }

    public void haveInboundGaggleCommands() {
        this.mcmd_.triggerGaggleState(96, true);
    }

    public void haveGaggleGooseChange() {
        this.mcmd_.triggerGaggleState(91, true);
    }

    private class SyncToggleWidgets
    implements ActionListener {
        private JCheckBoxMenuItem jcb_;
        private BTToggleButton tb_;
        private MainCommands.ToggleAction noIcons_;
        private MainCommands.ToggleAction withIcons_;
        private boolean ignore_;

        SyncToggleWidgets(JCheckBoxMenuItem jcb, BTToggleButton tb, MainCommands.ToggleAction noIcons, MainCommands.ToggleAction withIcons) {
            this.jcb_ = jcb;
            this.tb_ = tb;
            this.noIcons_ = noIcons;
            this.withIcons_ = withIcons;
            this.ignore_ = false;
            if (this.jcb_ != null) {
                this.jcb_.addActionListener(this);
            }
            if (this.tb_ != null) {
                this.tb_.addActionListener(this);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.ignore_) {
                    return;
                }
                this.ignore_ = true;
                if (this.jcb_ != null && e.getSource() == this.jcb_) {
                    if (this.tb_ != null) {
                        this.withIcons_.setToIgnore(true);
                        this.tb_.setSelected(this.jcb_.isSelected());
                        this.withIcons_.setToIgnore(false);
                    }
                } else if (this.tb_ != null && e.getSource() == this.tb_ && this.jcb_ != null) {
                    this.noIcons_.setToIgnore(true);
                    this.jcb_.setSelected(this.tb_.isSelected());
                    this.noIcons_.setToIgnore(false);
                }
                this.ignore_ = false;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void cancelled() {
            MainCommands.ToggleAction useMe = this.withIcons_ == null ? this.noIcons_ : this.withIcons_;
            useMe.setAsActive(false);
            this.ignore_ = true;
            if (this.noIcons_ != null) {
                this.noIcons_.setToIgnore(true);
            }
            if (this.withIcons_ != null) {
                this.withIcons_.setToIgnore(true);
            }
            if (this.jcb_ != null) {
                this.jcb_.setSelected(false);
            }
            if (this.tb_ != null) {
                this.tb_.setSelected(false);
            }
            if (this.noIcons_ != null) {
                this.noIcons_.setToIgnore(false);
            }
            if (this.withIcons_ != null) {
                this.withIcons_.setToIgnore(false);
            }
            this.ignore_ = false;
        }

        public void activated() {
            MainCommands.ToggleAction useMe = this.withIcons_ == null ? this.noIcons_ : this.withIcons_;
            useMe.setAsActive(true);
            this.ignore_ = true;
            if (this.noIcons_ != null) {
                this.noIcons_.setToIgnore(true);
            }
            if (this.withIcons_ != null) {
                this.withIcons_.setToIgnore(true);
            }
            if (this.jcb_ != null) {
                this.jcb_.setSelected(true);
            }
            if (this.tb_ != null) {
                this.tb_.setSelected(true);
            }
            if (this.noIcons_ != null) {
                this.noIcons_.setToIgnore(false);
            }
            if (this.withIcons_ != null) {
                this.withIcons_.setToIgnore(false);
            }
            this.ignore_ = false;
        }
    }

    private class PasswordEvaluation {
        InputStream stream;
        boolean failure;

        private PasswordEvaluation() {
        }
    }
}

