/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.app;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.gaggle.GooseAppInterface;
import org.systemsbiology.biotapestry.gaggle.GooseManager;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class EditorWindow
extends JFrame {
    private CommonView cview_;

    public EditorWindow(Map args) {
        super(ResourceManager.getManager().getString("window.editorTitle"));
        Dimension dim = UiUtil.centerBigFrame(this, 1600, 1200, 1.0, 0);
        Container cp = this.getContentPane();
        this.cview_ = new CommonView();
        this.cview_.buildEditorView(this, cp, args);
        cp.setSize(dim);
        this.setDefaultCloseOperation(0);
        ExceptionHandler.getHandler().initialize(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EditorWindow.this.shutdownEditor(true);
            }
        });
        URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/BioTapFab16White.gif");
        this.setIconImage(new ImageIcon(ugif).getImage());
        this.setResizable(true);
        this.setVisible(true);
        URL gurl = null;
        URL saltUrl = null;
        try {
            gurl = this.cview_.getURLFromArgs(args);
            saltUrl = this.cview_.getSaltURLFromArgs(args);
        }
        catch (MalformedURLException mue) {
            System.err.println("malformed URL argument");
            return;
        }
        if (gurl != null) {
            while (!this.cview_.loadRemoteGenome(gurl, saltUrl, false)) {
            }
        } else {
            this.cview_.newModelTweaks();
        }
        this.cview_.getTree().requestFocus();
    }

    public ActionListener buildHelp() {
        return null;
    }

    public void shutdownEditor(boolean doGaggle) {
        GooseAppInterface goose;
        ResourceManager rMan;
        int ok;
        if (MainCommands.getCmds().havePerturbationEditsInProgress() && (ok = JOptionPane.showConfirmDialog(this, (rMan = ResourceManager.getManager()).getString("closeApp.warningMessagePertEdits"), rMan.getString("closeApp.warningMessagePertEditsTitle"), 0)) != 0) {
            return;
        }
        if (UndoSupport.hasAChange() && (ok = JOptionPane.showConfirmDialog(this, (rMan = ResourceManager.getManager()).getString("closeApp.warningMessage"), rMan.getString("closeApp.warningMessageTitle"), 0)) != 0) {
            return;
        }
        if (doGaggle && (goose = GooseManager.getManager().getGoose()) != null && goose.isActivated()) {
            goose.closeDown();
        }
        this.dispose();
        System.exit(0);
    }

    public CommonView getCommonView() {
        return this.cview_;
    }
}

