/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.app;

import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.systemsbiology.biotapestry.app.ImageGeneratorApplication;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.util.DirectoryNamedOutputStreamSource;
import org.systemsbiology.biotapestry.util.ModelNodeIDPair;
import org.systemsbiology.biotapestry.util.NamedOutputStreamSource;
import org.systemsbiology.biotapestry.util.NodeRegionModelNameTuple;
import org.systemsbiology.biotapestry.util.WebPublisher;

public class ImageGeneratorAppTestWrapper {
    public static void main(String[] argv) {
        ImageGeneratorAppTestWrapper.main2(argv);
    }

    public static void main1(String[] argv) {
        FileInputStream is = null;
        DirectoryNamedOutputStreamSource noss = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            is = new FileInputStream(argv[0]);
            File targetDir = new File(argv[1]);
            noss = new DirectoryNamedOutputStreamSource(targetDir);
        }
        catch (IOException ioex) {
            System.err.println("IO Failure");
            System.exit(1);
        }
        ImageGeneratorApplication iga1 = null;
        try {
            iga1 = new ImageGeneratorApplication(1, (InputStream)is, null, 1, (OutputStream)baos, new Integer(1), new Integer(2), new Boolean(true));
            iga1.process();
        }
        catch (ImageGeneratorApplication.GeneratorException gex) {
            System.err.println("Failure: " + gex.getMessage() + " exception: " + gex.getWrappedException());
            System.exit(1);
        }
        System.out.println("-----------------Model Map------------------");
        Map modelIDMap = iga1.getModelIDMap();
        Iterator kit = modelIDMap.keySet().iterator();
        while (kit.hasNext()) {
            String csvModelName = (String)kit.next();
            String modelInternalID = (String)modelIDMap.get(csvModelName);
            System.out.println("  CSV Model: " + csvModelName + " -> InternalID: " + modelInternalID);
        }
        System.out.println("-----------------Node  Map------------------");
        Map nodeIDMap = iga1.getNodeIDMap();
        Iterator nkit = nodeIDMap.keySet().iterator();
        while (nkit.hasNext()) {
            NodeRegionModelNameTuple nrmTuple = (NodeRegionModelNameTuple)nkit.next();
            ModelNodeIDPair internalID = (ModelNodeIDPair)nodeIDMap.get(nrmTuple);
            String csvModelName = nrmTuple.getModelName();
            String csvRegionName = nrmTuple.getRegionName();
            String csvNodeName = nrmTuple.getNodeName();
            String modelID = internalID.getModelID();
            String nodeID = internalID.getNodeID();
            System.out.println("  CSV Model/Region/Node: " + csvModelName + "/" + csvRegionName + "/" + csvNodeName + " -> Internal Model/Node: " + modelID + "/" + nodeID);
        }
        HashSet<WebPublisher.ModelScale> keysToPublish = new HashSet<WebPublisher.ModelScale>();
        String mod1 = (String)modelIDMap.get("ENDOMESODERM");
        keysToPublish.add(new WebPublisher.ModelScale(mod1, 0));
        String mod2 = (String)modelIDMap.get("ENDO");
        keysToPublish.add(new WebPublisher.ModelScale(mod2, 0));
        byte[] btpBytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(btpBytes);
        ImageGeneratorApplication iga2 = null;
        try {
            iga2 = new ImageGeneratorApplication(0, (InputStream)bais, null, (NamedOutputStreamSource)noss, keysToPublish, null, null, null);
            iga2.process();
        }
        catch (ImageGeneratorApplication.GeneratorException gex) {
            System.err.println("Failure: " + gex.getMessage() + " exception: " + gex.getWrappedException());
            System.exit(1);
        }
        System.out.println("-----------------Intersection  Map------------------");
        Map intersectMap = iga2.getIntersectionMap();
        Iterator ikit = intersectMap.keySet().iterator();
        while (ikit.hasNext()) {
            WebPublisher.ModelScale mScale = (WebPublisher.ModelScale)ikit.next();
            String modelID = mScale.getModelID();
            String scale = WebPublisher.ModelScale.getSizeTag(mScale.getSize());
            String fileName = mScale.getFileName();
            System.out.println("----Model/Scale: " + modelID + "/" + scale + " (filename: " + fileName + ")");
            SUPanel.BoundsMaps bMaps = (SUPanel.BoundsMaps)intersectMap.get(mScale);
            Iterator bkit = bMaps.nodeBounds.keySet().iterator();
            while (bkit.hasNext()) {
                String nodeID = (String)bkit.next();
                Rectangle rect = (Rectangle)bMaps.nodeBounds.get(nodeID);
                System.out.println("  NodeID: " + nodeID + " -> Rectangle: " + rect);
            }
        }
    }

    public static void main2(String[] argv) {
        FileInputStream isb = null;
        FileInputStream isc = null;
        DirectoryNamedOutputStreamSource noss = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            isb = new FileInputStream(argv[0]);
            isc = new FileInputStream(argv[1]);
            File targetDir = new File(argv[2]);
            noss = new DirectoryNamedOutputStreamSource(targetDir);
        }
        catch (IOException ioex) {
            System.err.println("IO Failure");
            System.exit(1);
        }
        ImageGeneratorApplication iga1 = null;
        try {
            iga1 = new ImageGeneratorApplication(2, (InputStream)isb, (InputStream)isc, 1, (OutputStream)baos, new Integer(0), new Integer(2), new Boolean(true));
            iga1.process();
        }
        catch (ImageGeneratorApplication.GeneratorException gex) {
            System.err.println("Failure: " + gex.getMessage() + " exception: " + gex.getWrappedException());
            System.exit(1);
        }
        System.out.println("-----------------Model Map------------------");
        Map modelIDMap = iga1.getModelIDMap();
        Iterator kit = modelIDMap.keySet().iterator();
        while (kit.hasNext()) {
            String csvModelName = (String)kit.next();
            String modelInternalID = (String)modelIDMap.get(csvModelName);
            System.out.println("  CSV Model: " + csvModelName + " -> InternalID: " + modelInternalID);
        }
        System.out.println("-----------------Node  Map------------------");
        Map nodeIDMap = iga1.getNodeIDMap();
        Iterator nkit = nodeIDMap.keySet().iterator();
        while (nkit.hasNext()) {
            NodeRegionModelNameTuple nrmTuple = (NodeRegionModelNameTuple)nkit.next();
            ModelNodeIDPair internalID = (ModelNodeIDPair)nodeIDMap.get(nrmTuple);
            String csvModelName = nrmTuple.getModelName();
            String csvRegionName = nrmTuple.getRegionName();
            String csvNodeName = nrmTuple.getNodeName();
            String modelID = internalID.getModelID();
            String nodeID = internalID.getNodeID();
            System.out.println("  CSV Model/Region/Node: " + csvModelName + "/" + csvRegionName + "/" + csvNodeName + " -> Internal Model/Node: " + modelID + "/" + nodeID);
        }
        HashSet<WebPublisher.ModelScale> keysToPublish = new HashSet<WebPublisher.ModelScale>();
        String mod1 = (String)modelIDMap.get("ENDOMESODERM");
        keysToPublish.add(new WebPublisher.ModelScale(mod1, 0));
        String mod2 = (String)modelIDMap.get("ENDO");
        keysToPublish.add(new WebPublisher.ModelScale(mod2, 0));
        byte[] btpBytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(btpBytes);
        ImageGeneratorApplication iga2 = null;
        try {
            iga2 = new ImageGeneratorApplication(0, (InputStream)bais, null, (NamedOutputStreamSource)noss, keysToPublish, null, null, null);
            iga2.process();
        }
        catch (ImageGeneratorApplication.GeneratorException gex) {
            System.err.println("Failure: " + gex.getMessage() + " exception: " + gex.getWrappedException());
            System.exit(1);
        }
        System.out.println("-----------------Intersection  Map------------------");
        Map intersectMap = iga2.getIntersectionMap();
        Iterator ikit = intersectMap.keySet().iterator();
        while (ikit.hasNext()) {
            WebPublisher.ModelScale mScale = (WebPublisher.ModelScale)ikit.next();
            String modelID = mScale.getModelID();
            String scale = WebPublisher.ModelScale.getSizeTag(mScale.getSize());
            String fileName = mScale.getFileName();
            System.out.println("----Model/Scale: " + modelID + "/" + scale + " (filename: " + fileName + ")");
            SUPanel.BoundsMaps bMaps = (SUPanel.BoundsMaps)intersectMap.get(mScale);
            Iterator bkit = bMaps.nodeBounds.keySet().iterator();
            while (bkit.hasNext()) {
                String nodeID = (String)bkit.next();
                Rectangle rect = (Rectangle)bMaps.nodeBounds.get(nodeID);
                System.out.println("  NodeID: " + nodeID + " -> Rectangle: " + rect);
            }
        }
    }
}

