/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.app;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.util.ExceptionHandler;

public class PopupCellRenderer
extends DefaultTreeCellRenderer {
    private DefaultMutableTreeNode myNode_;

    public String getToolTipText() {
        Object[] tn = this.myNode_.getPath();
        TreePath tp = new TreePath(tn);
        Database db = Database.getDB();
        String genomeID = db.getNavTree().getGenomeID(tp);
        if (genomeID == null) {
            return null;
        }
        Genome currGenome = db.getGenome(genomeID);
        return currGenome.getLongName();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component retval = null;
        try {
            this.myNode_ = (DefaultMutableTreeNode)value;
            retval = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return retval;
    }
}

