/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.app;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.app.ExpansionChange;
import org.systemsbiology.biotapestry.app.PopupCellRenderer;
import org.systemsbiology.biotapestry.cmd.DatabaseChangeCmd;
import org.systemsbiology.biotapestry.cmd.DeleteCommands;
import org.systemsbiology.biotapestry.cmd.ExpansionChangeCmd;
import org.systemsbiology.biotapestry.cmd.ImageChangeCmd;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.NavTreeChangeCmd;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.cmd.PropChangeCmd;
import org.systemsbiology.biotapestry.cmd.TemporalInputChangeCmd;
import org.systemsbiology.biotapestry.cmd.TimeCourseChangeCmd;
import org.systemsbiology.biotapestry.cmd.UserTreePathController;
import org.systemsbiology.biotapestry.cmd.UserTreePathControllerChangeCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.db.StartupView;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.nav.ImageChange;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.nav.NavTreeChange;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputChange;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseChange;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.DataLocator;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.dialogs.DynSingleModelPropDialog;
import org.systemsbiology.biotapestry.ui.dialogs.DynamicInstanceCreationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.GenomeInstanceCopyDialog;
import org.systemsbiology.biotapestry.ui.dialogs.SingleInstanceModelPropDialog;
import org.systemsbiology.biotapestry.ui.dialogs.SingleModelPropDialog;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.MenuItemTarget;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PopupTree
extends JTree
implements TreeSelectionListener,
TreeExpansionListener {
    private JPopupMenu leafPopup_;
    private ModelMenu popMenuContents_;
    private ModelMenu mainMenuContents_;
    private Genome popupTarget_;
    private TreeNode popupNode_;
    private String selectionTargetID_;
    private TreeNode selectionNode_;
    private boolean readOnly_;
    private CommonView cView_;
    private boolean doingUndo_;
    private boolean doSelectionIgnore_;
    private JMenu currModMenu_;

    public PopupTree(DefaultTreeModel dtm, boolean readOnly, CommonView cView, boolean bigScreen) {
        super(dtm);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(new MouseHandler());
        this.setCellRenderer(new PopupCellRenderer());
        this.readOnly_ = readOnly;
        this.cView_ = cView;
        this.doSelectionIgnore_ = false;
        this.selectionTargetID_ = null;
        this.selectionNode_ = null;
        if (!this.readOnly_) {
            this.popMenuContents_ = new ModelMenu(this.readOnly_);
            this.leafPopup_ = new JPopupMenu();
            this.leafPopup_.addPopupMenuListener(new PopupHandler());
            this.popMenuContents_.fillMenu(this.readOnly_, new MenuItemTarget(this.leafPopup_));
            this.mainMenuContents_ = new ModelMenu(this.readOnly_);
        }
        if (bigScreen) {
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            Font drFont = this.getFont();
            String fontName = drFont == null ? "arial" : drFont.getName();
            int fontType = drFont == null ? 0 : drFont.getStyle();
            renderer.setFont(new Font(fontName, fontType, 20));
            this.setCellRenderer(renderer);
        }
        ResourceManager rMan = ResourceManager.getManager();
        this.currModMenu_ = new JMenu(rMan.getString("command.currentModelMenu"));
        this.currModMenu_.setMnemonic(rMan.getChar("command.currentModelMenuMnem"));
    }

    public JMenu getCurrentModelMenu() {
        return this.currModMenu_;
    }

    public void stockCurrentModelMenu() {
        if (this.selectionTargetID_ == null || this.selectionNode_ == null || this.readOnly_) {
            this.currModMenu_.removeAll();
            this.currModMenu_.setEnabled(false);
        } else {
            this.popupTarget_ = Database.getDB().getGenome(this.selectionTargetID_);
            this.popupNode_ = this.selectionNode_;
            this.mainMenuContents_.manageActionEnables(this.readOnly_, this.popupTarget_, this.popupNode_);
            this.currModMenu_.removeAll();
            this.mainMenuContents_.fillMenu(this.readOnly_, new MenuItemTarget(this.currModMenu_));
            this.currModMenu_.setEnabled(true);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        try {
            TreePath tp = this.getSelectionPath();
            Database db = Database.getDB();
            String genomeID = db.getNavTree().getGenomeID(tp);
            PathResolution res = this.resolvePath(tp);
            if (res == null) {
                this.selectionTargetID_ = null;
                this.selectionNode_ = null;
            } else {
                this.selectionTargetID_ = res.pathTarget.getID();
                this.selectionNode_ = res.pathNode;
            }
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
    }

    public void changeUndo(ExpansionChange undo) {
        if (undo.isForUndo) {
            this.doingUndo_ = true;
            Iterator plit = undo.expanded.iterator();
            while (plit.hasNext()) {
                TreePath tp = (TreePath)plit.next();
                this.expandPath(tp);
            }
            if (undo.selected != null) {
                this.setSelectionPath(undo.selected);
            }
            this.doingUndo_ = false;
            this.revalidate();
        }
    }

    public void changeRedo(ExpansionChange undo) {
        if (!undo.isForUndo) {
            this.doingUndo_ = true;
            Iterator plit = undo.expanded.iterator();
            while (plit.hasNext()) {
                TreePath tp = (TreePath)plit.next();
                this.expandPath(tp);
            }
            if (undo.selected != null) {
                this.setSelectionPath(undo.selected);
            }
            this.doingUndo_ = false;
            this.revalidate();
        }
    }

    public boolean amDoingUndo() {
        return this.doingUndo_;
    }

    public boolean ignoreSelection() {
        return this.doSelectionIgnore_;
    }

    public ExpansionChange buildExpansionChange(boolean forUndo) {
        NavTree nt = Database.getDB().getNavTree();
        List nonleafPaths = nt.getAllPathsToNonLeaves();
        Iterator nlpit = nonleafPaths.iterator();
        ExpansionChange ec = new ExpansionChange();
        ec.isForUndo = forUndo;
        ec.tree = this;
        ec.expanded = new ArrayList();
        ec.selected = this.getSelectionPath();
        while (nlpit.hasNext()) {
            TreePath tp = (TreePath)nlpit.next();
            if (!this.isExpanded(tp)) continue;
            ec.expanded.add(tp);
        }
        return ec;
    }

    public ExpansionChange doUndoExpansionChange(UndoSupport support, boolean recordPathControllerState) {
        ExpansionChange ec = this.buildExpansionChange(true);
        support.addEdit(new ExpansionChangeCmd(ec));
        if (recordPathControllerState) {
            UserTreePathController utpc = MainCommands.getCmds().getPathController();
            support.addEdit(new UserTreePathControllerChangeCmd(utpc.recordStateForUndo(true)));
        }
        return ec;
    }

    public void doRedoExpansionChange(UndoSupport support, NavTreeChange ntc, boolean recordPathControllerState) {
        Database db = Database.getDB();
        ExpansionChange ec = this.buildExpansionChange(false);
        NavTree nt = db.getNavTree();
        ec.expanded = nt.mapAllPaths(ec.expanded, ntc, false);
        ec.selected = nt.mapAPath(ec.selected, ntc, false);
        if (recordPathControllerState) {
            UserTreePathController utpc = MainCommands.getCmds().getPathController();
            support.addEdit(new UserTreePathControllerChangeCmd(utpc.recordStateForUndo(false)));
        }
        support.addEdit(new ExpansionChangeCmd(ec));
    }

    public void addNewGenomeInstance(String newName, UndoSupport support, boolean timeBounded, int minTime, int maxTime, Genome parent, boolean isPopup) {
        TreeNode targetNode;
        GenomeInstance vfg;
        Database db = Database.getDB();
        NavTree nt = db.getNavTree();
        ExpansionChange ec = this.buildExpansionChange(true);
        List holdExpanded = ec.expanded;
        support.addEdit(new ExpansionChangeCmd(ec));
        if (isPopup) {
            if (this.popupTarget_ == null || parent != this.popupTarget_) {
                throw new IllegalStateException();
            }
            vfg = this.popupTarget_ instanceof GenomeInstance ? (GenomeInstance)this.popupTarget_ : null;
            targetNode = this.popupNode_;
        } else {
            if (parent != db.getGenome(this.selectionTargetID_)) {
                System.err.println("handle stale reference!");
                throw new IllegalStateException();
            }
            vfg = parent instanceof GenomeInstance ? (GenomeInstance)parent : null;
            targetNode = this.selectionNode_;
        }
        String nextKey = db.getNextKey();
        GenomeInstance gi = new GenomeInstance(newName, nextKey, vfg == null ? null : vfg.getID(), timeBounded, minTime, maxTime);
        DatabaseChange dc = db.addGenomeInstanceExistingLabel(nextKey, gi);
        support.addEdit(new DatabaseChangeCmd(dc));
        support.addEvent(new ModelChangeEvent(nextKey, 4));
        if (vfg == null) {
            String nextloKey = db.getNextKey();
            Layout lo = new Layout(nextloKey, nextKey);
            dc = db.addLayout(nextloKey, lo);
            support.addEdit(new DatabaseChangeCmd(dc));
        }
        this.doSelectionIgnore_ = true;
        NavTreeChange ntc = nt.addNode(newName, vfg == null ? null : vfg.getID(), nextKey);
        support.addEdit(new NavTreeChangeCmd(ntc));
        ec.expanded = nt.mapAllPaths(ec.expanded, ntc, true);
        ec.selected = nt.mapAPath(ec.selected, ntc, true);
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(targetNode);
        this.doSelectionIgnore_ = false;
        Object[] tn = ((DefaultMutableTreeNode)targetNode).getPath();
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        this.expandPath(tp);
        Iterator plit = holdExpanded.iterator();
        while (plit.hasNext()) {
            tp = (TreePath)plit.next();
            this.expandPath(tp);
        }
        ec = this.buildExpansionChange(false);
        ec.expanded = nt.mapAllPaths(ec.expanded, ntc, false);
        ec.selected = nt.mapAPath(ec.selected, ntc, false);
        support.addEdit(new ExpansionChangeCmd(ec));
    }

    public void copyGenomeInstanceToNewSibling(String newName, boolean doRecursive, DynamicInstanceProxy proxyBase, UndoSupport support) {
        Database db = Database.getDB();
        if (!(this.popupTarget_ instanceof GenomeInstance)) {
            return;
        }
        GenomeInstance vfg = (GenomeInstance)this.popupTarget_;
        NavTree nt = db.getNavTree();
        ExpansionChange ec = this.buildExpansionChange(true);
        List holdExpanded = ec.expanded;
        support.addEdit(new ExpansionChangeCmd(ec));
        int sibIndex = nt.getNewSiblingIndex(this.popupNode_);
        HashMap children = new HashMap();
        children.put(vfg.getID(), new ArrayList());
        if (doRecursive) {
            List ordered = nt.getPreorderListing(this.popupNode_);
            Iterator oit = ordered.iterator();
            while (oit.hasNext()) {
                String gkey = (String)oit.next();
                GenomeInstance gi = (GenomeInstance)db.getGenome(gkey);
                if (gi == vfg) continue;
                GenomeInstance currParent = gi.getVfgParent();
                String currParentID = currParent.getID();
                ArrayList<String> kids = (ArrayList<String>)children.get(currParentID);
                if (kids == null) {
                    kids = new ArrayList<String>();
                    children.put(currParentID, kids);
                }
                kids.add(gkey);
            }
        }
        ArrayList navTreeChanges = new ArrayList();
        GenomeInstance parent = vfg.getVfgParent();
        HashMap groupIDMap = new HashMap();
        HashMap modelIDMap = new HashMap();
        HashMap noteIDMap = new HashMap();
        HashMap ovrIDMap = new HashMap();
        HashMap modIDMap = new HashMap();
        HashMap modLinkIDMap = new HashMap();
        String topCopy = null;
        if (proxyBase == null) {
            topCopy = this.recursiveGenomeInstanceCopy(vfg, parent, newName, db, children, nt, ec, true, navTreeChanges, groupIDMap, modelIDMap, noteIDMap, ovrIDMap, modIDMap, modLinkIDMap, new Integer(sibIndex), support);
        } else {
            this.recursiveDynamicProxyCopy(proxyBase, parent, newName, db, children, nt, ec, true, navTreeChanges, groupIDMap, modelIDMap, noteIDMap, ovrIDMap, modIDMap, modLinkIDMap, new Integer(sibIndex), support);
        }
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.popupNode_);
        Object[] tn = ((DefaultMutableTreeNode)this.popupNode_).getPath();
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        Iterator plit = holdExpanded.iterator();
        while (plit.hasNext()) {
            tp = (TreePath)plit.next();
            this.expandPath(tp);
        }
        NavTreeChange ntc = (NavTreeChange)navTreeChanges.get(navTreeChanges.size() - 1);
        ec = this.buildExpansionChange(false);
        ec.expanded = nt.mapAllPaths(ec.expanded, ntc, false);
        ec.selected = nt.mapAPath(ec.selected, ntc, false);
        support.addEdit(new ExpansionChangeCmd(ec));
        TemporalInputRangeData tird = db.getTemporalInputRangeData();
        TimeCourseData tcd = db.getTimeCourseData();
        boolean isRoot = vfg.isRootInstance();
        GenomeInstance rootInstance = isRoot ? vfg : vfg.getVfgParentRoot();
        Iterator grit = rootInstance.getGroupIterator();
        while (grit.hasNext()) {
            TimeCourseChange tcc;
            TemporalInputChange tic;
            Group origGroup = (Group)grit.next();
            String oldID = origGroup.getID();
            String newID = (String)groupIDMap.get(oldID);
            if (newID == null) {
                newID = oldID;
            }
            if ((tic = tird.copyTemporalRangeGroupMapForDuplicateGroup(oldID, newID, modelIDMap)) != null) {
                support.addEdit(new TemporalInputChangeCmd(tic));
            }
            if ((tcc = tcd.copyTimeCourseGroupMapForDuplicateGroup(oldID, newID, modelIDMap)) == null) continue;
            support.addEdit(new TimeCourseChangeCmd(tcc));
        }
        boolean doAdd = !isRoot;
        String loTarg = isRoot ? topCopy : rootInstance.getID();
        Iterator loit = db.getLayoutIterator();
        while (loit.hasNext()) {
            Layout lo = (Layout)loit.next();
            if (!lo.getTarget().equals(loTarg)) continue;
            Layout.PropChange[] changes = lo.mapNoteProperties(noteIDMap, doAdd);
            if (changes.length > 0) {
                support.addEdit(new PropChangeCmd(changes));
            }
            if ((changes = lo.mapOverlayProperties(ovrIDMap, modIDMap, modLinkIDMap, doAdd)).length > 0) {
                support.addEdit(new PropChangeCmd(changes));
            }
            new DataLocator(this.cView_.getSUPanel()).setTitleLocation(support, vfg.getID(), newName);
        }
        db.clearAllDynamicProxyCaches();
    }

    private String recursiveGenomeInstanceCopy(GenomeInstance vfg, GenomeInstance newParent, String newName, Database db, Map children, NavTree nt, ExpansionChange ec, boolean isFirst, List navTreeChanges, Map groupIDMap, Map modelIDMap, Map noteIDMap, Map ovrIDMap, Map modIDMap, Map modLinkIDMap, Integer sibIndex, UndoSupport support) {
        ArrayList kidsToCopy;
        String currToCopy = vfg.getID();
        String newParentID = newParent == null ? null : newParent.getID();
        String nextKey = db.getNextKey();
        ArrayList imageChanges = new ArrayList();
        GenomeInstance gi = new GenomeInstance(vfg, newName, newParentID, nextKey, groupIDMap, noteIDMap, ovrIDMap, modIDMap, modLinkIDMap, imageChanges);
        modelIDMap.put(currToCopy, nextKey);
        DatabaseChange dc = db.addGenomeInstanceExistingLabel(nextKey, gi);
        support.addEdit(new DatabaseChangeCmd(dc));
        support.addEvent(new ModelChangeEvent(gi.getID(), 4));
        if (newParentID == null) {
            ArrayList<Layout> newLayouts = new ArrayList<Layout>();
            Iterator loit = db.getLayoutIterator();
            while (loit.hasNext()) {
                Layout lo = (Layout)loit.next();
                if (!lo.getTarget().equals(currToCopy)) continue;
                String nextloKey = db.getNextKey();
                Layout nlo = new Layout(lo, nextloKey, nextKey, groupIDMap);
                newLayouts.add(nlo);
            }
            int numNew = newLayouts.size();
            for (int i = 0; i < numNew; ++i) {
                Layout lo = (Layout)newLayouts.get(i);
                dc = db.addLayout(lo.getName(), lo);
                support.addEdit(new DatabaseChangeCmd(dc));
            }
        }
        int numIC = imageChanges.size();
        for (int i = 0; i < numIC; ++i) {
            ImageChange ic = (ImageChange)imageChanges.get(i);
            if (ic == null) continue;
            support.addEdit(new ImageChangeCmd(ic));
        }
        NavTreeChange ntc = sibIndex == null ? nt.addNode(newName, newParentID, nextKey) : nt.addNodeAtIndex(newName, newParentID, nextKey, sibIndex);
        support.addEdit(new NavTreeChangeCmd(ntc));
        navTreeChanges.add(ntc);
        if (isFirst) {
            ec.expanded = nt.mapAllPaths(ec.expanded, ntc, true);
            ec.selected = nt.mapAPath(ec.selected, ntc, true);
            isFirst = false;
        }
        if ((kidsToCopy = (ArrayList)children.get(currToCopy)) != null) {
            int numKtC = kidsToCopy.size();
            for (int i = 0; i < numKtC; ++i) {
                String kidID = (String)kidsToCopy.get(i);
                if (DynamicInstanceProxy.isDynamicInstance(kidID)) {
                    String proxKey = DynamicInstanceProxy.extractProxyID(kidID);
                    DynamicInstanceProxy kidDP = db.getDynamicProxy(proxKey);
                    String newKidName = kidDP.getName();
                    this.recursiveDynamicProxyCopy(kidDP, gi, newKidName, db, children, nt, ec, isFirst, navTreeChanges, groupIDMap, modelIDMap, noteIDMap, ovrIDMap, modIDMap, modLinkIDMap, null, support);
                    continue;
                }
                GenomeInstance kidGI = (GenomeInstance)db.getGenome(kidID);
                String newKidName = kidGI.getName();
                this.recursiveGenomeInstanceCopy(kidGI, gi, newKidName, db, children, nt, ec, isFirst, navTreeChanges, groupIDMap, modelIDMap, noteIDMap, ovrIDMap, modIDMap, modLinkIDMap, null, support);
            }
        }
        return nextKey;
    }

    private void recursiveDynamicProxyCopy(DynamicInstanceProxy dip, GenomeInstance newParent, String newName, Database db, Map children, NavTree nt, ExpansionChange ec, boolean isFirst, List navTreeChanges, Map groupIDMap, Map modelIDMap, Map noteIDMap, Map ovrIDMap, Map modIDMap, Map modLinkIDMap, Integer sibIndex, UndoSupport support) {
        ArrayList kidsToCopy;
        NavTreeChange ntc;
        String currToCopy = dip.getID();
        String newVfgParentID = newParent.getID();
        String nextKey = db.getNextKey();
        ArrayList imageChanges = new ArrayList();
        DynamicInstanceProxy dipCopy = new DynamicInstanceProxy(dip, newName, newVfgParentID, nextKey, groupIDMap, noteIDMap, ovrIDMap, modIDMap, modLinkIDMap, imageChanges);
        modelIDMap.put(currToCopy, nextKey);
        DatabaseChange dc = db.addDynamicProxyExistingLabel(nextKey, dipCopy);
        support.addEdit(new DatabaseChangeCmd(dc));
        int numIC = imageChanges.size();
        for (int i = 0; i < numIC; ++i) {
            ImageChange ic = (ImageChange)imageChanges.get(i);
            if (ic == null) continue;
            ic.proxyKey = nextKey;
            support.addEdit(new ImageChangeCmd(ic));
        }
        if (dipCopy.isSingle()) {
            List newNodes = dipCopy.getProxiedKeys();
            if (newNodes.size() != 1) {
                throw new IllegalStateException();
            }
            String key = (String)newNodes.iterator().next();
            ntc = sibIndex == null ? nt.addNode(dipCopy.getProxiedInstanceName(key), newVfgParentID, key) : nt.addNodeAtIndex(dipCopy.getProxiedInstanceName(key), newVfgParentID, key, sibIndex);
        } else {
            ntc = sibIndex == null ? nt.addProxyNode(dipCopy.getName(), newVfgParentID, dipCopy.getID()) : nt.addProxyNodeAtIndex(dipCopy.getName(), newVfgParentID, dipCopy.getID(), sibIndex);
        }
        support.addEdit(new NavTreeChangeCmd(ntc));
        navTreeChanges.add(ntc);
        if (isFirst) {
            ec.expanded = nt.mapAllPaths(ec.expanded, ntc, true);
            ec.selected = nt.mapAPath(ec.selected, ntc, true);
            isFirst = false;
        }
        if ((kidsToCopy = (ArrayList)children.get(dip.getFirstProxiedKey())) != null) {
            DynamicGenomeInstance par = dipCopy.getAnInstance();
            int numKtC = kidsToCopy.size();
            for (int i = 0; i < numKtC; ++i) {
                String kidID = (String)kidsToCopy.get(i);
                String proxKey = DynamicInstanceProxy.extractProxyID(kidID);
                DynamicInstanceProxy kidDIP = db.getDynamicProxy(proxKey);
                String newKidName = kidDIP.getName();
                this.recursiveDynamicProxyCopy(kidDIP, par, newKidName, db, children, nt, ec, isFirst, navTreeChanges, groupIDMap, modelIDMap, noteIDMap, ovrIDMap, modIDMap, modLinkIDMap, null, support);
            }
        }
    }

    private PathResolution resolvePath(TreePath tp) {
        Database db = Database.getDB();
        NavTree nt = db.getNavTree();
        String genomeID = nt.getGenomeID(tp);
        String proxyID = nt.getDynamicProxyID(tp);
        Genome pathTarget = null;
        TreeNode pathNode = null;
        if (genomeID != null) {
            pathTarget = db.getGenome(genomeID);
            pathNode = (TreeNode)tp.getLastPathComponent();
        } else if (proxyID != null) {
            DynamicInstanceProxy dip = db.getDynamicProxy(proxyID);
            genomeID = this.cView_.getCurrentSliderKey(dip);
            pathTarget = db.getGenome(genomeID);
            pathNode = (TreeNode)tp.getLastPathComponent();
        }
        if (pathTarget != null) {
            return new PathResolution(pathTarget, pathNode);
        }
        return null;
    }

    class ModelMenu {
        private AddGenomeInstanceWrapperAction agia_;
        private AddDynamicGenomeInstanceAction adgia_;
        private DeleteGenomeInstanceAction dgia_;
        private DeleteGenomeInstanceAction dcgia_;
        private EditModelPropertiesAction empa_;
        private CopyGenomeInstanceAction cgia_;
        private MoveNodeAction mnua_;
        private MoveNodeAction mnda_;
        private MakeStartupViewAction msva_;
        private SetCurrentOverlayForFirstView scoff_;

        ModelMenu(boolean readOnly) {
            if (!readOnly) {
                this.agia_ = new AddGenomeInstanceWrapperAction(false);
                this.adgia_ = new AddDynamicGenomeInstanceAction(false);
                this.cgia_ = new CopyGenomeInstanceAction(false);
                this.dgia_ = new DeleteGenomeInstanceAction(false, false);
                this.dcgia_ = new DeleteGenomeInstanceAction(false, true);
                this.empa_ = new EditModelPropertiesAction(false);
                this.mnua_ = new MoveNodeAction(false, false);
                this.mnda_ = new MoveNodeAction(false, true);
                this.msva_ = new MakeStartupViewAction(false);
                this.scoff_ = new SetCurrentOverlayForFirstView(false);
            }
        }

        void manageActionEnables(boolean readOnly, Genome modelTarget, TreeNode modelNode) {
            Database db = Database.getDB();
            NavTree nt = db.getNavTree();
            if (!readOnly) {
                boolean enableScoff = false;
                TreePath selPath = PopupTree.this.getSelectionPath();
                if (selPath != null) {
                    boolean showOverlayOpts = modelTarget.getNetworkOverlayCount() > 0;
                    boolean poppedSelection = (TreeNode)selPath.getLastPathComponent() == modelNode;
                    enableScoff = showOverlayOpts && poppedSelection;
                }
                this.scoff_.setEnabled(enableScoff);
                boolean hasKids = modelNode.getChildCount() > 0;
                this.dcgia_.setEnabled(hasKids);
                if (modelTarget instanceof DBGenome) {
                    this.agia_.setEnabled(true);
                    this.adgia_.setEnabled(false);
                    this.cgia_.setEnabled(false);
                    this.dgia_.setEnabled(false);
                    this.mnua_.setEnabled(false);
                    this.mnda_.setEnabled(false);
                } else if (modelTarget instanceof DynamicGenomeInstance) {
                    this.agia_.setEnabled(false);
                    this.dgia_.setEnabled(true);
                    this.cgia_.setEnabled(true);
                    DynamicGenomeInstance dgi = (DynamicGenomeInstance)PopupTree.this.popupTarget_;
                    DynamicInstanceProxy dip = db.getDynamicProxy(dgi.getProxyID());
                    this.adgia_.setEnabled(dip.isSingle());
                    this.mnua_.setEnabled(nt.canShiftNode((DefaultMutableTreeNode)modelNode, false));
                    this.mnda_.setEnabled(nt.canShiftNode((DefaultMutableTreeNode)modelNode, true));
                } else if (modelTarget instanceof GenomeInstance) {
                    this.agia_.setEnabled(true);
                    TimeCourseData tcd = db.getTimeCourseData();
                    this.adgia_.setEnabled(!tcd.isEmpty());
                    this.dgia_.setEnabled(true);
                    this.cgia_.setEnabled(true);
                    this.mnua_.setEnabled(nt.canShiftNode((DefaultMutableTreeNode)modelNode, false));
                    this.mnda_.setEnabled(nt.canShiftNode((DefaultMutableTreeNode)modelNode, true));
                } else {
                    System.err.println("Poptarg =" + modelTarget);
                    throw new IllegalStateException();
                }
            }
        }

        void fillMenu(boolean readOnly, MenuItemTarget menuTarg) {
            if (!readOnly) {
                menuTarg.add(this.agia_);
                menuTarg.add(this.adgia_);
                menuTarg.add(this.cgia_);
                menuTarg.add(this.dgia_);
                menuTarg.add(this.dcgia_);
                menuTarg.add(this.empa_);
                menuTarg.add(this.mnua_);
                menuTarg.add(this.mnda_);
                menuTarg.add(this.msva_);
                menuTarg.add(this.scoff_);
            }
        }
    }

    public class EditModelPropertiesAction
    extends AbstractAction {
        public EditModelPropertiesAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("ShortDescription", rMan.getString("treePopup.EditModelProperties"));
            this.putValue("Name", rMan.getString("treePopup.EditModelProperties"));
            if (doIcon) {
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            }
            char mnem = rMan.getChar("treePopup.EditModelPropertiesMnem");
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                NavTree nav = db.getNavTree();
                JFrame parent = (JFrame)PopupTree.this.getRootPane().getParent();
                UndoManager undo = PopupTree.this.cView_.getUndoManager();
                if (PopupTree.this.popupTarget_ instanceof DynamicGenomeInstance) {
                    String gid;
                    Genome gip;
                    DynamicGenomeInstance dgi = (DynamicGenomeInstance)PopupTree.this.popupTarget_;
                    DynamicInstanceProxy dip = db.getDynamicProxy(dgi.getProxyID());
                    TreeNode parentNode = PopupTree.this.popupNode_.getParent();
                    String proxyID = nav.getDynamicProxyID(parentNode);
                    if (proxyID == null && (gip = db.getGenome(gid = nav.getGenomeID(parentNode))) instanceof DynamicGenomeInstance) {
                        DynamicGenomeInstance dgip = (DynamicGenomeInstance)gip;
                        proxyID = dgip.getProxyID();
                    }
                    DynamicInstanceProxy parentProx = proxyID != null ? db.getDynamicProxy(proxyID) : null;
                    ArrayList<DynamicInstanceProxy> childList = new ArrayList<DynamicInstanceProxy>();
                    int childCount = PopupTree.this.popupNode_.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        proxyID = nav.getDynamicProxyID(PopupTree.this.popupNode_.getChildAt(i));
                        DynamicInstanceProxy childProx = db.getDynamicProxy(proxyID);
                        childList.add(childProx);
                    }
                    DynSingleModelPropDialog dsmpd = new DynSingleModelPropDialog(parent, dip, parentProx, childList, nav, PopupTree.this.popupNode_, PopupTree.this, PopupTree.this.cView_, undo);
                    dsmpd.setVisible(true);
                } else if (PopupTree.this.popupTarget_ instanceof DBGenome) {
                    SingleModelPropDialog smpd = new SingleModelPropDialog(parent, (DBGenome)PopupTree.this.popupTarget_, PopupTree.this.cView_.getSUPanel(), undo);
                    smpd.setVisible(true);
                } else {
                    SingleInstanceModelPropDialog simpd = new SingleInstanceModelPropDialog(parent, (GenomeInstance)PopupTree.this.popupTarget_, PopupTree.this.cView_.getSUPanel(), undo);
                    simpd.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class MoveNodeAction
    extends AbstractAction {
        private boolean doLower_;

        public MoveNodeAction(boolean doIcon, boolean doLower) {
            ResourceManager rMan = ResourceManager.getManager();
            this.doLower_ = doLower;
            String whichKey = this.doLower_ ? "treePopup.MoveNodeDown" : "treePopup.MoveNodeUp";
            String whichMnemKey = this.doLower_ ? "treePopup.MoveNodeDownMnem" : "treePopup.MoveNodeUpMnem";
            this.putValue("ShortDescription", rMan.getString(whichKey));
            this.putValue("Name", rMan.getString(whichKey));
            if (doIcon) {
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            }
            char mnem = rMan.getChar(whichMnemKey);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                UndoManager undo = PopupTree.this.cView_.getUndoManager();
                String whichKey = this.doLower_ ? "undo.moveModelDownInTree" : "undo.moveModelUpInTree";
                UndoSupport support = new UndoSupport(undo, whichKey);
                NavTree nt = db.getNavTree();
                ExpansionChange ec = PopupTree.this.buildExpansionChange(true);
                List holdExpanded = ec.expanded;
                support.addEdit(new ExpansionChangeCmd(ec));
                TreeNode parent = PopupTree.this.popupNode_.getParent();
                NavTreeChange ntc = nt.shiftNode((DefaultMutableTreeNode)PopupTree.this.popupNode_, this.doLower_);
                if (ntc == null) {
                    return;
                }
                NavTreeChangeCmd ntcc = new NavTreeChangeCmd(ntc);
                ec.expanded = nt.mapAllPaths(ec.expanded, ntc, true);
                ec.selected = nt.mapAPath(ec.selected, ntc, true);
                support.addEdit(ntcc);
                Object[] tn = ((DefaultMutableTreeNode)PopupTree.this.popupNode_).getPath();
                TreePath tp = new TreePath(tn);
                PopupTree.this.setSelectionPath(tp);
                Iterator plit = holdExpanded.iterator();
                while (plit.hasNext()) {
                    tp = (TreePath)plit.next();
                    if (!nt.isPathPresent(tp)) continue;
                    PopupTree.this.expandPath(tp);
                }
                PopupTree.this.scrollPathToVisible(new TreePath(tn));
                ec = PopupTree.this.buildExpansionChange(false);
                ec.expanded = nt.mapAllPaths(ec.expanded, ntc, false);
                ec.selected = nt.mapAPath(ec.selected, ntc, false);
                support.addEdit(new ExpansionChangeCmd(ec));
                support.finish();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class SetCurrentOverlayForFirstView
    extends AbstractAction {
        public SetCurrentOverlayForFirstView(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("ShortDescription", rMan.getString("treePopup.SetCurrOverlayFirst"));
            this.putValue("Name", rMan.getString("treePopup.SetCurrOverlayFirst"));
            if (doIcon) {
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            }
            char mnem = rMan.getChar("treePopup.SetCurrOverlayFirstMnem");
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                NetOverlayController noc = MainCommands.getCmds().getOverlayController();
                noc.setCurrentAsFirst();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class MakeStartupViewAction
    extends AbstractAction {
        public MakeStartupViewAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("ShortDescription", rMan.getString("treePopup.MakeStartupView"));
            this.putValue("Name", rMan.getString("treePopup.MakeStartupView"));
            if (doIcon) {
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            }
            char mnem = rMan.getChar("treePopup.MakeStartupViewMnem");
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                UndoManager undo = PopupTree.this.cView_.getUndoManager();
                UndoSupport support = new UndoSupport(undo, "undo.makeStartupView");
                DatabaseChange dc = db.setStartupView(new StartupView(PopupTree.this.popupTarget_.getID(), null, null, null));
                DatabaseChangeCmd dcc = new DatabaseChangeCmd(dc);
                support.addEdit(dcc);
                support.finish();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteGenomeInstanceAction
    extends AbstractAction {
        private boolean kidsOnly_;

        public DeleteGenomeInstanceAction(boolean doIcon, boolean kidsOnly) {
            ResourceManager rMan = ResourceManager.getManager();
            this.kidsOnly_ = kidsOnly;
            this.putValue("ShortDescription", rMan.getString(this.kidsOnly_ ? "treePopup.DeleteChildInstances" : "treePopup.DeleteInstance"));
            this.putValue("Name", rMan.getString(this.kidsOnly_ ? "treePopup.DeleteChildInstances" : "treePopup.DeleteInstance"));
            if (doIcon) {
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            }
            char mnem = rMan.getChar(this.kidsOnly_ ? "treePopup.DeleteChildInstancesMnem" : "treePopup.DeleteInstanceMnem");
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                GenomeInstance rootOne;
                Database db = Database.getDB();
                GenomeInstance genomeInstance = rootOne = PopupTree.this.popupTarget_ instanceof GenomeInstance ? (GenomeInstance)PopupTree.this.popupTarget_ : null;
                if (rootOne == null && !this.kidsOnly_) {
                    throw new IllegalStateException();
                }
                UndoManager undo = PopupTree.this.cView_.getUndoManager();
                UndoSupport support = new UndoSupport(undo, this.kidsOnly_ ? "undo.deleteChildGenomeInstances" : "undo.deleteGenomeInstance");
                UserTreePathController utpc = MainCommands.getCmds().getPathController();
                NavTree nt = db.getNavTree();
                nt.setSkipFlag(2);
                ExpansionChange ec = PopupTree.this.buildExpansionChange(true);
                List holdExpanded = ec.expanded;
                support.addEdit(new ExpansionChangeCmd(ec));
                support.addEdit(new UserTreePathControllerChangeCmd(utpc.recordStateForUndo(true)));
                JFrame topWindow = (JFrame)PopupTree.this.getRootPane().getParent();
                DeleteCommands dc = new DeleteCommands(topWindow, undo);
                HashSet deadOnes = new HashSet();
                if (rootOne == null) {
                    ArrayList<String> inList = new ArrayList<String>();
                    Iterator dii = db.getInstanceIterator();
                    while (dii.hasNext()) {
                        inList.add(((GenomeInstance)dii.next()).getID());
                    }
                    Iterator iit = inList.iterator();
                    while (iit.hasNext()) {
                        GenomeInstance gi;
                        String giid = (String)iit.next();
                        if (deadOnes.contains(giid) || (gi = (GenomeInstance)db.getGenome(giid)).getVfgParent() != null) continue;
                        deadOnes.addAll(dc.deleteGenomeInstance(gi.getID(), false, support));
                    }
                } else {
                    deadOnes.addAll(dc.deleteGenomeInstance(rootOne.getID(), this.kidsOnly_, support));
                }
                TreeNode parent = PopupTree.this.popupNode_.getParent();
                NavTreeChange ntc = this.kidsOnly_ ? nt.deleteNodeChildren((DefaultMutableTreeNode)PopupTree.this.popupNode_, deadOnes) : nt.deleteNode((DefaultMutableTreeNode)PopupTree.this.popupNode_, deadOnes);
                NavTreeChangeCmd ntcc = new NavTreeChangeCmd(ntc);
                ec.expanded = nt.mapAllPaths(ec.expanded, ntc, true);
                ec.selected = nt.mapAPath(ec.selected, ntc, true);
                support.addEdit(ntcc);
                TreeNode pathBot = this.kidsOnly_ ? PopupTree.this.popupNode_ : parent;
                Object[] tn = ((DefaultMutableTreeNode)pathBot).getPath();
                TreePath tp = new TreePath(tn);
                PopupTree.this.setSelectionPath(tp);
                PopupTree.this.expandPath(tp);
                Iterator plit = holdExpanded.iterator();
                while (plit.hasNext()) {
                    tp = (TreePath)plit.next();
                    if (!nt.isPathPresent(tp)) continue;
                    PopupTree.this.expandPath(tp);
                }
                ec = PopupTree.this.buildExpansionChange(false);
                ec.expanded = nt.mapAllPaths(ec.expanded, ntc, false);
                ec.selected = nt.mapAPath(ec.selected, ntc, false);
                support.addEdit(new UserTreePathControllerChangeCmd(utpc.recordStateForUndo(false)));
                support.addEdit(new ExpansionChangeCmd(ec));
                support.finish();
                nt.setSkipFlag(0);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class AddDynamicGenomeInstanceAction
    extends AbstractAction {
        public AddDynamicGenomeInstanceAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("ShortDescription", rMan.getString("treePopup.AddDynamicInstance"));
            this.putValue("Name", rMan.getString("treePopup.AddDynamicInstance"));
            if (doIcon) {
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            }
            char mnem = rMan.getChar("treePopup.AddDynamicInstanceMnem");
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                NavTreeChange ntc;
                GenomeInstance vfg;
                Database db = Database.getDB();
                Genome dbg = db.getGenome();
                GenomeInstance genomeInstance = vfg = PopupTree.this.popupTarget_ instanceof GenomeInstance ? (GenomeInstance)PopupTree.this.popupTarget_ : null;
                if (vfg == null) {
                    throw new IllegalArgumentException();
                }
                TimeCourseData tcd = db.getTimeCourseData();
                int minHour = tcd.getMinimumTime();
                int maxHour = tcd.getMaximumTime();
                boolean preferSum = true;
                if (PopupTree.this.popupTarget_ instanceof DynamicGenomeInstance) {
                    DynamicGenomeInstance dgi = (DynamicGenomeInstance)PopupTree.this.popupTarget_;
                    DynamicInstanceProxy dip = db.getDynamicProxy(dgi.getProxyID());
                    minHour = dip.getMinimumTime();
                    maxHour = dip.getMaximumTime();
                    preferSum = false;
                } else if (PopupTree.this.popupTarget_ instanceof GenomeInstance) {
                    GenomeInstance gi = (GenomeInstance)PopupTree.this.popupTarget_;
                    if (gi.hasTimeBounds()) {
                        minHour = gi.getMinTime();
                        maxHour = gi.getMaxTime();
                    } else {
                        ResourceManager rMan = ResourceManager.getManager();
                        JOptionPane.showMessageDialog(PopupTree.this.getRootPane(), rMan.getString("treePopup.noParentTimesError"), rMan.getString("treePopup.noParentTimesErrorTitle"), 0);
                        return;
                    }
                }
                DynamicInstanceCreationDialog dicd = new DynamicInstanceCreationDialog((JFrame)PopupTree.this.getRootPane().getParent(), db.getUniqueModelName(), minHour, maxHour, preferSum);
                dicd.setVisible(true);
                if (!dicd.haveResult()) {
                    return;
                }
                UndoSupport support = new UndoSupport(PopupTree.this.cView_.getUndoManager(), "undo.addDynamicGenomeInstance");
                NavTree nt = db.getNavTree();
                nt.setSkipFlag(2);
                ExpansionChange ec = PopupTree.this.buildExpansionChange(true);
                List holdExpanded = ec.expanded;
                support.addEdit(new ExpansionChangeCmd(ec));
                String nextKey = db.getNextKey();
                DynamicInstanceProxy dip = new DynamicInstanceProxy(dicd.getName(), nextKey, vfg, !dicd.isPerTime(), dicd.getMinTime(), dicd.getMaxTime());
                DatabaseChange dc = db.addDynamicProxyExistingLabel(nextKey, dip);
                support.addEdit(new DatabaseChangeCmd(dc));
                support.addEvent(new ModelChangeEvent(nextKey, 5));
                new DataLocator(PopupTree.this.cView_.getSUPanel()).setTitleLocation(support, vfg.getID(), dicd.getName());
                if (dip.isSingle()) {
                    List newNodes = dip.getProxiedKeys();
                    if (newNodes.size() != 1) {
                        throw new IllegalStateException();
                    }
                    String key = (String)newNodes.iterator().next();
                    ntc = nt.addNode(dip.getProxiedInstanceName(key), vfg.getID(), key);
                } else {
                    ntc = nt.addProxyNode(dip.getName(), vfg.getID(), dip.getID());
                }
                support.addEdit(new NavTreeChangeCmd(ntc));
                ec.expanded = nt.mapAllPaths(ec.expanded, ntc, true);
                ec.selected = nt.mapAPath(ec.selected, ntc, true);
                ((DefaultTreeModel)PopupTree.this.getModel()).nodeStructureChanged(PopupTree.this.popupNode_);
                Object[] tn = ((DefaultMutableTreeNode)PopupTree.this.popupNode_).getPath();
                TreePath tp = new TreePath(tn);
                PopupTree.this.setSelectionPath(tp);
                PopupTree.this.expandPath(tp);
                Iterator plit = holdExpanded.iterator();
                while (plit.hasNext()) {
                    tp = (TreePath)plit.next();
                    PopupTree.this.expandPath(tp);
                }
                ec = PopupTree.this.buildExpansionChange(false);
                ec.expanded = nt.mapAllPaths(ec.expanded, ntc, false);
                ec.selected = nt.mapAPath(ec.selected, ntc, false);
                support.addEdit(new ExpansionChangeCmd(ec));
                Database.getDB().clearAllDynamicProxyCaches();
                support.finish();
                nt.setSkipFlag(0);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class CopyGenomeInstanceAction
    extends AbstractAction {
        public CopyGenomeInstanceAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("ShortDescription", rMan.getString("treePopup.CopyInstance"));
            this.putValue("Name", rMan.getString("treePopup.CopyInstance"));
            if (doIcon) {
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            }
            char mnem = rMan.getChar("treePopup.CopyInstanceMnem");
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (!(PopupTree.this.popupTarget_ instanceof GenomeInstance)) {
                    return;
                }
                Database db = Database.getDB();
                JFrame parent = (JFrame)PopupTree.this.getRootPane().getParent();
                if (db.haveBuildInstructions()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(parent, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
                }
                GenomeInstance gi = (GenomeInstance)PopupTree.this.popupTarget_;
                String giID = gi.getID();
                String origName = gi.getName();
                DynamicInstanceProxy popupDip = null;
                if (PopupTree.this.popupTarget_ instanceof DynamicGenomeInstance) {
                    DynamicGenomeInstance dgi = (DynamicGenomeInstance)PopupTree.this.popupTarget_;
                    popupDip = db.getDynamicProxy(dgi.getProxyID());
                    origName = popupDip.getName();
                }
                boolean hasKids = false;
                if (popupDip == null) {
                    Iterator iit = db.getInstanceIterator();
                    while (iit.hasNext()) {
                        GenomeInstance testGi = (GenomeInstance)iit.next();
                        if (gi == testGi || !gi.isAncestor(testGi)) continue;
                        hasKids = true;
                        break;
                    }
                }
                if (!hasKids) {
                    Iterator dit = db.getDynamicProxyIterator();
                    while (dit.hasNext()) {
                        DynamicInstanceProxy dip = (DynamicInstanceProxy)dit.next();
                        if (popupDip != null) {
                            if (popupDip == dip || !dip.proxyIsAncestor(popupDip.getID())) continue;
                            hasKids = true;
                            break;
                        }
                        if (!dip.instanceIsAncestor(gi)) continue;
                        hasKids = true;
                        break;
                    }
                }
                GenomeInstanceCopyDialog gicd = new GenomeInstanceCopyDialog(parent, origName, hasKids);
                gicd.setVisible(true);
                if (!gicd.haveResult()) {
                    return;
                }
                String newName = gicd.getName();
                boolean doRecursive = gicd.isRecursive();
                UndoSupport support = new UndoSupport(PopupTree.this.cView_.getUndoManager(), "undo.copyGenomeToSibling");
                PopupTree.this.copyGenomeInstanceToNewSibling(newName, doRecursive, popupDip, support);
                support.finish();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class AddGenomeInstanceWrapperAction
    extends AbstractAction {
        public AddGenomeInstanceWrapperAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("ShortDescription", rMan.getString("treePopup.AddInstance"));
            this.putValue("Name", rMan.getString("treePopup.AddInstance"));
            if (doIcon) {
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            }
            char mnem = rMan.getChar("treePopup.AddInstanceMnem");
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Object[] setArg = new Object[]{PopupTree.this.popupTarget_};
                MainCommands.OneShot rlts = MainCommands.getCmds().getOneShot(15);
                rlts.performOperation(setArg);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class PopupHandler
    implements PopupMenuListener {
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.triggerPopup(me.getX(), me.getY());
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.triggerPopup(me.getX(), me.getY());
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.triggerPopup(me.getX(), me.getY());
            }
        }

        private void triggerPopup(int x, int y) {
            try {
                if (!PopupTree.this.readOnly_) {
                    TreePath tp = PopupTree.this.getPathForLocation(x, y);
                    PathResolution res = PopupTree.this.resolvePath(tp);
                    if (res == null) {
                        return;
                    }
                    PopupTree.this.popupTarget_ = res.pathTarget;
                    PopupTree.this.popupNode_ = res.pathNode;
                    PopupTree.this.popMenuContents_.manageActionEnables(PopupTree.this.readOnly_, PopupTree.this.popupTarget_, PopupTree.this.popupNode_);
                    PopupTree.this.leafPopup_.show(PopupTree.this, x, y);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private static class PathResolution {
        Genome pathTarget;
        TreeNode pathNode;

        PathResolution(Genome pathTarget, TreeNode pathNode) {
            this.pathTarget = pathTarget;
            this.pathNode = pathNode;
        }
    }
}

