/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.systemsbiology.biotapestry.app.ArgParser;
import org.systemsbiology.biotapestry.app.ViewerWindow;
import org.systemsbiology.biotapestry.gaggle.DeadGoose;
import org.systemsbiology.biotapestry.gaggle.GooseManager;
import org.systemsbiology.biotapestry.plugin.PlugInManager;

public class ViewerApplication {
    private JWindow splash_;

    public static void main(String[] argv) {
        ArgParser ap = new ArgParser();
        final Map argMap = ap.parse(1, argv);
        if (argMap == null) {
            System.err.print(ap.getUsage(1));
            System.exit(0);
        }
        final ViewerApplication va = new ViewerApplication();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    va.splash();
                }
            });
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        boolean ok = PlugInManager.getMgr().loadDataDisplayPlugIns(argMap);
        if (!ok) {
            System.err.println("Problems loading plugins");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                va.launch(argMap);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                va.unSplash();
            }
        });
    }

    private ViewerApplication() {
    }

    private void launch(Map args) {
        new ViewerWindow(args);
        GooseManager.getManager().setGoose(new DeadGoose());
    }

    private void splash() {
        this.splash_ = new JWindow();
        JPanel content = (JPanel)this.splash_.getContentPane();
        int width = 500;
        int height = 325;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - width) / 2;
        int y = (screen.height - height) / 2;
        this.splash_.setBounds(x, y, width, height);
        URL sugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/BioTapestrySplash.gif");
        JLabel label = new JLabel(new ImageIcon(sugif));
        content.setBackground(Color.white);
        content.add((Component)label, "Center");
        content.setBorder(BorderFactory.createLineBorder(new Color(3, 107, 3), 10));
        this.splash_.setVisible(true);
    }

    private void unSplash() {
        this.splash_.setVisible(false);
        this.splash_.dispose();
    }
}

