/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.app;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.util.ResourceManager;

public class ViewerWindow
extends JFrame {
    private CommonView cview_;

    public ViewerWindow(Map args) {
        super(ResourceManager.getManager().getString("window.viewerTitle"));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int winWidth = screenSize.width - 40;
        int winHeight = screenSize.height - 150;
        if (winWidth > 1600) {
            winWidth = 1600;
            winHeight = winHeight < 1200 ? winHeight : 1200;
        }
        this.setSize(winWidth, winHeight);
        Dimension frameSize = this.getSize();
        int x = (screenSize.width - frameSize.width) / 2;
        int y = (screenSize.height - frameSize.height) / 2;
        this.setLocation(x, y);
        Container cp = this.getContentPane();
        this.cview_ = new CommonView();
        URL aurl = this.getClass().getResource("/org/systemsbiology/biotapestry/data/about.html");
        Boolean doBig = (Boolean)args.get("bigScreen");
        this.cview_.buildViewOnlyView(this, cp, aurl, doBig);
        cp.setSize(new Dimension(winWidth, winHeight));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ViewerWindow.this.dispose();
                System.exit(0);
            }
        });
        URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/BioTapFab16White.gif");
        this.setIconImage(new ImageIcon(ugif).getImage());
        this.setResizable(true);
        this.setVisible(true);
        URL gurl = null;
        URL saltUrl = null;
        try {
            gurl = this.cview_.getURLFromArgs(args);
            saltUrl = this.cview_.getSaltURLFromArgs(args);
        }
        catch (MalformedURLException mue) {
            System.err.println("malformed URL argument");
            return;
        }
        if (gurl != null) {
            while (!this.cview_.loadRemoteGenome(gurl, saltUrl, true)) {
            }
        }
    }
}

