/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.DatabaseChangeCmd;
import org.systemsbiology.biotapestry.cmd.DeleteCommands;
import org.systemsbiology.biotapestry.cmd.GenomeChangeCmd;
import org.systemsbiology.biotapestry.cmd.GroupChangeCmd;
import org.systemsbiology.biotapestry.cmd.ModificationCommands;
import org.systemsbiology.biotapestry.cmd.NetOverlayChangeCmd;
import org.systemsbiology.biotapestry.cmd.NetOverlayOwnerChangeCmd;
import org.systemsbiology.biotapestry.cmd.OldPadMapper;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.cmd.PadConstraints;
import org.systemsbiology.biotapestry.cmd.PropChangeCmd;
import org.systemsbiology.biotapestry.cmd.ProxyChangeCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.event.LayoutChangeEvent;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.genome.DBGene;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBLinkage;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.GeneInstance;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupChange;
import org.systemsbiology.biotapestry.genome.GroupMember;
import org.systemsbiology.biotapestry.genome.GroupMembership;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.LinkageInstance;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleChange;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.NetworkOverlayChange;
import org.systemsbiology.biotapestry.genome.NetworkOverlayOwnerChange;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.genome.ProxyChange;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.ui.BusDrop;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.ColorAssigner;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.Grid;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutDataSource;
import org.systemsbiology.biotapestry.ui.LayoutDerivation;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LayoutOptionsManager;
import org.systemsbiology.biotapestry.ui.LinkBusDrop;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NodeInsertionDirective;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.NoteProperties;
import org.systemsbiology.biotapestry.ui.RectangularTreeEngine;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.ui.dialogs.DrawGeneInstanceCreationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.DrawLinkInstanceCreationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.DrawLinkInstanceExistingOptionsDialog;
import org.systemsbiology.biotapestry.ui.dialogs.DrawNodeInstanceCreationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.DrawNodeInstanceExistingOptionsDialog;
import org.systemsbiology.biotapestry.ui.dialogs.GeneCreationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.GroupAssignmentDialog;
import org.systemsbiology.biotapestry.ui.dialogs.GroupCreationDialogHandler;
import org.systemsbiology.biotapestry.ui.dialogs.LinkCreationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.NetModuleCreationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.NetOverlayCreationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.NodeCreationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.NotePropertiesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.SubGroupCreationDialog;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;
import org.systemsbiology.biotapestry.ui.freerender.NodeBounder;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.NetModuleLinkExtractor;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyInstructions;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngine;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutLinkData;
import org.systemsbiology.biotapestry.util.AffineCombination;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.DistanceMeasurer;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.PatternGrid;
import org.systemsbiology.biotapestry.util.PatternPlacerVerticalNesting;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;
import org.systemsbiology.biotapestry.util.Vector2D;

public class AddCommands {
    private static String lastGI_ = null;
    public static final int STOP_PROCESSING = 0;
    public static final int NO_AMBIGUITY = 1;
    public static final int USE_SOURCE = 2;
    public static final int USE_TARGET = 3;
    JFrame topWindow_;
    Node newNode_;
    Node newRootNode_;
    Node existingRootNode_;
    Set existingRootNodeOptions_;
    String existingLinkID_;
    Group newSubGroup_;
    int newSubGroupLayer_;
    Genome targetGenome_;
    Layout targetLayout_;
    UndoManager undom_;
    GroupCreationDialogHandler newHandler_;
    Group newGroup_;
    Map okSrcTrgMap_;
    public static final int CANCEL_REQUEST = 0;
    public static final int DO_IMMEDIATE_MODE = 1;
    public static final int DO_REGULAR_MODE = 2;
    private static final int ADDING_ONLY_TO_ROOT_ = 0;
    private static final int ADD_ALL_LEVELS_ = 1;
    private static final int ADD_BELOW_ROOT_ = 2;

    public AddCommands(JFrame topWindow, UndoManager undo) {
        this.topWindow_ = topWindow;
        this.undom_ = undo;
    }

    public AddCommands() {
    }

    public AddOverlayResult addNewNetworkOverlay(String genomeID, NetModuleFree.CurrentSettings overSettings, UndoSupport support) {
        NetOverlayProperties noProps;
        Layout.PropChange pc;
        Genome targGenome;
        Database db = Database.getDB();
        HashSet<String> existingNames = new HashSet<String>();
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeID);
        Iterator oit = owner.getNetworkOverlayIterator();
        while (oit.hasNext()) {
            NetworkOverlay no = (NetworkOverlay)oit.next();
            existingNames.add(no.getName());
        }
        NetOverlayCreationDialog nocd = new NetOverlayCreationDialog(this.topWindow_, existingNames);
        nocd.setVisible(true);
        if (!nocd.haveResult()) {
            return null;
        }
        String newName = nocd.getName();
        int type = nocd.getType();
        boolean hideLinks = nocd.getHideLinks();
        boolean changeViz = false;
        if (!(type != 1 || overSettings.intersectionMask == 1 && overSettings.intersectionMask == 0 || (targGenome = db.getGenome(genomeID)).isEmpty())) {
            ResourceManager rMan = ResourceManager.getManager();
            String message = UiUtil.convertMessageToHtml(rMan.getString("overlayAdded.resetViz"));
            int changeVizVal = JOptionPane.showConfirmDialog(this.topWindow_, message, rMan.getString("overlayAdded.resetVizTitle"), 1);
            if (changeVizVal == 2) {
                return null;
            }
            changeViz = changeVizVal == 0;
        }
        Layout glo = db.getLayout(new LayoutManager().getLayout(genomeID));
        DBGenome rootGenome = (DBGenome)db.getGenome();
        String viewID = rootGenome.getNextKey();
        NetworkOverlay nmView = new NetworkOverlay(viewID, newName, null);
        NetworkOverlayOwnerChange gc = owner.addNetworkOverlay(nmView);
        if (gc != null) {
            NetOverlayOwnerChangeCmd gcc = new NetOverlayOwnerChangeCmd(gc);
            support.addEdit(gcc);
        }
        if ((pc = glo.setNetOverlayProperties(viewID, noProps = new NetOverlayProperties(viewID, type, hideLinks))) != null) {
            support.addEdit(new PropChangeCmd(pc));
        }
        support.addEvent(new ModelChangeEvent(owner.getID(), 1));
        support.addEvent(new LayoutChangeEvent(glo.getName(), 1));
        return new AddOverlayResult(changeViz, viewID);
    }

    public NetModuleCandidate beginDrawNetworkModule(String genomeID, String layoutID, String overlayKey) {
        Database db = Database.getDB();
        this.targetGenome_ = db.getGenome(genomeID);
        this.targetLayout_ = db.getLayout(layoutID);
        NetworkOverlay nov = db.getOverlayOwnerFromGenomeKey(genomeID).getNetworkOverlay(overlayKey);
        HashSet<String> existingNames = new HashSet<String>();
        Iterator mit = nov.getModuleIterator();
        while (mit.hasNext()) {
            NetModule nm = (NetModule)mit.next();
            existingNames.add(nm.getName());
        }
        boolean askForAttach = !(this.targetGenome_ instanceof DBGenome);
        boolean gotNodes = this.targetGenome_.getFullNodeCount() > 0;
        NetModuleCreationDialog nmcd = new NetModuleCreationDialog(this.topWindow_, existingNames, askForAttach, gotNodes);
        nmcd.setVisible(true);
        if (!nmcd.haveResult()) {
            return null;
        }
        String newName = nmcd.getName();
        boolean doNodeAdd = nmcd.doNodeAdd();
        int displayType = nmcd.getDisplayType();
        boolean attachToGroup = nmcd.getAttachToGroup();
        return new NetModuleCandidate(newName, doNodeAdd, displayType, attachToGroup);
    }

    public String drawNetworkModuleFinish(UndoSupport support, NetModuleCandidate candidate, String overlayKey, FontRenderContext frc) {
        NetModuleProperties nmp;
        Layout.PropChange pc;
        NetworkOverlayChange noc;
        Database db = Database.getDB();
        String genomeKey = this.targetGenome_.getID();
        DBGenome rootGenome = (DBGenome)db.getGenome();
        String moduleID = rootGenome.getNextKey();
        NetModule nmod = new NetModule(moduleID, candidate.name, null, candidate.attachedGroup);
        if (candidate.addNodes) {
            int numMem = candidate.nodes.size();
            for (int i = 0; i < numMem; ++i) {
                String nodeID = (String)candidate.nodes.get(i);
                NetModuleMember nmm = new NetModuleMember(nodeID);
                nmod.addMember(nmm, genomeKey, this.targetGenome_.overlayModeForOwner(), overlayKey);
            }
        }
        Point2D memberOnlyLabelLoc = null;
        if (candidate.displayType == 2) {
            String firstNodeID = (String)candidate.nodes.get(0);
            memberOnlyLabelLoc = NodeBounder.prelimLabelLocation(firstNodeID, this.targetGenome_, this.targetLayout_, frc, 10);
        }
        if ((noc = db.getOverlayOwnerFromGenomeKey(genomeKey).addNetworkModule(overlayKey, nmod)) != null) {
            NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(noc);
            support.addEdit(gcc);
        }
        if ((pc = this.targetLayout_.setNetModuleProperties(moduleID, nmp = new NetModuleProperties(moduleID, candidate.displayType, candidate.allRects, memberOnlyLabelLoc), overlayKey)) != null) {
            support.addEdit(new PropChangeCmd(pc));
        }
        support.addEvent(new ModelChangeEvent(genomeKey, 1));
        support.addEvent(new LayoutChangeEvent(this.targetLayout_.getName(), 1));
        return moduleID;
    }

    public NetModuleLinkCandidate beginDrawNetworkModuleLink(String genomeID, String layoutID, String overlayKey) {
        Database db = Database.getDB();
        this.targetGenome_ = db.getGenome(genomeID);
        this.targetLayout_ = db.getLayout(layoutID);
        Vector signs = NetModuleLinkage.getLinkSigns();
        int numSigns = signs.size();
        Object[] forDisplay = new Object[numSigns];
        for (int i = 0; i < numSigns; ++i) {
            forDisplay[i] = signs.get(i);
        }
        ResourceManager rMan = ResourceManager.getManager();
        Object result = JOptionPane.showInputDialog(this.topWindow_, rMan.getString("drawModLink.chooseLinkSign"), rMan.getString("drawModLink.dialogTitle"), 3, null, forDisplay, forDisplay[2]);
        if (result == null) {
            return null;
        }
        int linkSign = ((ChoiceContent)result).val;
        return new NetModuleLinkCandidate(linkSign, overlayKey);
    }

    public boolean finishDrawNetworkModuleLink(NetModuleLinkCandidate nmlc, FontRenderContext frc) {
        Database db = Database.getDB();
        DBGenome rootGenome = (DBGenome)db.getGenome();
        String linkID = rootGenome.getNextKey();
        String genomeKey = this.targetGenome_.getID();
        if (!nmlc.srcIsModule) {
            return this.addToNetModuleLinkTree(this.targetLayout_, linkID, genomeKey, nmlc, frc);
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.newNetworkModuleLink");
        NetModuleLinkage nml = new NetModuleLinkage(linkID, nmlc.srcMod, nmlc.trgMod, nmlc.sign);
        NetworkOverlayChange noc = db.getOverlayOwnerFromGenomeKey(genomeKey).addNetworkModuleLinkage(nmlc.ovrKey, nml);
        if (noc != null) {
            NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(noc);
            support.addEdit(gcc);
        }
        NetModuleLinkageProperties nmlp = this.convertModuleLinkCandidate(this.targetGenome_, this.targetLayout_, nmlc, linkID, nmlc.srcMod);
        NetModuleProperties nmp = this.targetLayout_.getNetOverlayProperties(nmlc.ovrKey).getNetModuleProperties(nmlc.srcMod);
        nmlp.setColor(nmp.getColorTag());
        Layout.PropChange pc = this.targetLayout_.setNetModuleLinkageProperties(nmlp.getID(), nmlp, nmlc.ovrKey);
        if (pc != null) {
            support.addEdit(new PropChangeCmd(pc));
            Layout.PropChange pc2 = this.targetLayout_.tieNetModuleLinkToProperties(linkID, nmlp.getID(), nmlc.ovrKey);
            if (pc2 != null) {
                support.addEdit(new PropChangeCmd(pc2));
            }
        }
        support.addEvent(new ModelChangeEvent(genomeKey, 1));
        support.addEvent(new LayoutChangeEvent(this.targetLayout_.getName(), 1));
        support.finish();
        return true;
    }

    private NetModuleLinkageProperties convertModuleLinkCandidate(Genome genome, Layout layout, NetModuleLinkCandidate lc, String linkID, String src) {
        List segments = this.convertCandidateListToSegments(lc.points, null, true);
        NetOverlayProperties nop = this.targetLayout_.getNetOverlayProperties(lc.ovrKey);
        NetModuleFree.IntersectionExtraInfo srcEI = (NetModuleFree.IntersectionExtraInfo)lc.source.getSubID();
        Vector2D toStartSide = srcEI.padNorm.scaled(-1.0);
        NetModuleFree.IntersectionExtraInfo trgEI = (NetModuleFree.IntersectionExtraInfo)lc.target.getSubID();
        Vector2D toEndSide = trgEI.padNorm.scaled(-1.0);
        String newKey = ((DBGenome)Database.getDB().getGenome()).getNextKey();
        NetModuleLinkageProperties nmlp = new NetModuleLinkageProperties(newKey, lc.ovrKey, lc.srcMod, linkID, (Point2D)lc.points.get(0), (Point2D)lc.points.get(lc.points.size() - 1), toStartSide, toEndSide);
        Iterator sit = segments.iterator();
        while (sit.hasNext()) {
            LinkSegment ls = (LinkSegment)sit.next();
            nmlp.addSegmentInSeries(ls);
        }
        return nmlp;
    }

    private boolean addToNetModuleLinkTree(Layout layout, String linkID, String genomeKey, NetModuleLinkCandidate nmlc, FontRenderContext frc) {
        String treeID;
        NetModuleLinkageProperties nmlp;
        Layout.PropChange pc;
        NetOverlayOwner noo = Database.getDB().getOverlayOwnerFromGenomeKey(genomeKey);
        NetworkOverlay no = noo.getNetworkOverlay(nmlc.ovrKey);
        NetOverlayProperties nop = layout.getNetOverlayProperties(nmlc.ovrKey);
        LinkSegmentID[] segIDs = nmlc.source.segmentIDsFromIntersect();
        UndoSupport support = new UndoSupport(this.undom_, "undo.newNetworkModuleLink");
        NetModuleLinkage nml = new NetModuleLinkage(linkID, nmlc.srcMod, nmlc.trgMod, nmlc.sign);
        NetworkOverlayChange noc = noo.addNetworkModuleLinkage(nmlc.ovrKey, nml);
        if (noc != null) {
            NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(noc);
            support.addEdit(gcc);
        }
        if ((pc = this.targetLayout_.mergeNewModuleLinkToTreeAtSegment(nmlp = this.convertNetModLinkCandidateToPropsForMerge(nmlc, linkID), treeID = nmlc.source.getObjectID(), linkID, nmlc.ovrKey, segIDs[0], frc)) != null) {
            support.addEdit(new PropChangeCmd(pc));
            support.addEvent(new ModelChangeEvent(genomeKey, 1));
            support.addEvent(new LayoutChangeEvent(this.targetLayout_.getName(), 1));
            support.finish();
            return true;
        }
        return false;
    }

    private NetModuleLinkageProperties convertNetModLinkCandidateToPropsForMerge(NetModuleLinkCandidate nmlc, String linkID) {
        int numSeg = nmlc.points.size() - 2;
        ArrayList<LinkSegment> segments = new ArrayList<LinkSegment>();
        if (numSeg == 0) {
            Point pt = (Point)nmlc.points.get(0);
            Point2D.Float newPt = new Point2D.Float(pt.x, pt.y);
            LinkSegment ls = new LinkSegment(null, null, newPt, null);
            segments.add(ls);
        } else {
            Point2D.Float lastPt = null;
            Iterator pit = nmlc.points.iterator();
            while (pit.hasNext()) {
                Point pt = (Point)pit.next();
                if (!pit.hasNext()) break;
                Point2D.Float newPt = new Point2D.Float(pt.x, pt.y);
                if (lastPt != null) {
                    LinkSegment ls = new LinkSegment(null, null, lastPt, newPt);
                    segments.add(ls);
                }
                lastPt = newPt;
            }
        }
        Point2D.Double startPt = new Point2D.Double(0.0, 0.0);
        Vector2D toStartSide = new Vector2D(0.0, 0.0);
        Point targPt = (Point)nmlc.points.get(nmlc.points.size() - 1);
        Point2D.Float endPt = new Point2D.Float(targPt.x, targPt.y);
        NetModuleFree.IntersectionExtraInfo trgEI = (NetModuleFree.IntersectionExtraInfo)nmlc.target.getSubID();
        Vector2D toEndSide = trgEI.padNorm.scaled(-1.0);
        NetModuleLinkageProperties nNmlp = new NetModuleLinkageProperties("fakeID", nmlc.ovrKey, nmlc.srcMod, linkID, startPt, endPt, toStartSide, toEndSide);
        Iterator sit = segments.iterator();
        while (sit.hasNext()) {
            LinkSegment ls = (LinkSegment)sit.next();
            nNmlp.addSegmentInSeries(ls);
        }
        return nNmlp;
    }

    public NetModuleToModify beginAddRegionsToNetworkModule(String genomeID, String layoutID, String overlayKey, String moduleID) {
        Database db = Database.getDB();
        this.targetGenome_ = db.getGenome(genomeID);
        this.targetLayout_ = db.getLayout(layoutID);
        NetworkOverlay nov = db.getOverlayOwnerFromGenomeKey(genomeID).getNetworkOverlay(overlayKey);
        NetModule nmod = nov.getModule(moduleID);
        NetOverlayProperties nop = this.targetLayout_.getNetOverlayProperties(overlayKey);
        NetModuleProperties nmp = nop.getNetModuleProperties(moduleID);
        Color currCol = nmp.getColor();
        String attachedGroup = nmod.getGroupAttachment();
        return new NetModuleToModify(overlayKey, moduleID, nmp.getType(), attachedGroup, currCol);
    }

    public void finishAddRegionsToNetworkModule(UndoSupport support, NetModuleToModify nm2m, FontRenderContext frc) {
        Layout.PadNeedsForLayout padFixups = this.targetLayout_.findAllNetModuleLinkPadRequirements(frc);
        String genomeKey = this.targetGenome_.getID();
        NetOverlayOwner owner = Database.getDB().getOverlayOwnerFromGenomeKey(genomeKey);
        NetworkOverlay nov = owner.getNetworkOverlay(nm2m.netOverlayID);
        NetModule nmod = nov.getModule(nm2m.netModuleID);
        int numNodes = nm2m.nodes.size();
        for (int i = 0; i < numNodes; ++i) {
            NetModuleMember nmm;
            NetModuleChange nmc;
            String nodeID = (String)nm2m.nodes.get(i);
            if (nmod.isAMember(nodeID) || (nmc = nmod.addMember(nmm = new NetModuleMember(nodeID), owner.getID(), owner.overlayModeForOwner(), nm2m.netOverlayID)) == null) continue;
            NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmc);
            support.addEdit(gcc);
        }
        support.addEvent(new ModelChangeEvent(genomeKey, 1));
        if (nm2m.displayType != 2) {
            NetOverlayProperties noProps = this.targetLayout_.getNetOverlayProperties(nm2m.netOverlayID);
            NetModuleProperties nmp = noProps.getNetModuleProperties(nm2m.netModuleID);
            NetModuleProperties modProps = (NetModuleProperties)nmp.clone();
            Rectangle2D rect = (Rectangle2D)nm2m.allRects.get(0);
            modProps.addShape(rect);
            Layout.PropChange pc = this.targetLayout_.replaceNetModuleProperties(nm2m.netModuleID, modProps, nm2m.netOverlayID);
            if (pc != null) {
                support.addEdit(new PropChangeCmd(pc));
                support.addEvent(new LayoutChangeEvent(this.targetLayout_.getName(), 1));
            }
            this.finishNetModPadFixups(null, null, this.targetLayout_, padFixups, frc, support);
        }
    }

    public boolean addNodeToModule(String genomeID, String layoutID, String nodeID, String moduleID, String overlayKey, FontRenderContext frc) {
        NetworkOverlay nol;
        NetModule nmod;
        Database db = Database.getDB();
        Layout lo = db.getLayout(layoutID);
        Layout.PadNeedsForLayout padFixups = lo.findAllNetModuleLinkPadRequirements(frc);
        UndoSupport support = new UndoSupport(this.undom_, "undo.addNodeToNetworkModule");
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeID);
        NetModuleChange nmc = owner.addMemberToNetworkModule(overlayKey, nmod = (nol = owner.getNetworkOverlay(overlayKey)).getModule(moduleID), nodeID);
        if (nmc != null) {
            NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmc);
            support.addEdit(gcc);
        }
        this.finishNetModPadFixups(null, null, lo, padFixups, frc, support);
        support.addEvent(new ModelChangeEvent(genomeID, 1));
        support.finish();
        return true;
    }

    public boolean locateNewNode(boolean doGene, int x, int y, List modCandidates, String overlayKey, FontRenderContext frc, boolean intoBlackHole) {
        Database db = Database.getDB();
        Layout.PadNeedsForLayout padFixups = this.targetLayout_.findAllNetModuleLinkPadRequirements(frc);
        boolean changeViz = false;
        if (intoBlackHole) {
            ResourceManager rMan = ResourceManager.getManager();
            String message = UiUtil.convertMessageToHtml(rMan.getString("intoBlackHole.resetViz"));
            int changeVizVal = JOptionPane.showConfirmDialog(this.topWindow_, message, rMan.getString("intoBlackHole.resetVizTitle"), 1);
            if (changeVizVal == 2) {
                return false;
            }
            changeViz = changeVizVal == 0;
        }
        UndoSupport support = new UndoSupport(this.undom_, doGene ? "undo.addGene" : "undo.addNode");
        GenomeChange gc = doGene ? ((DBGenome)this.targetGenome_).addGeneWithExistingLabel((Gene)this.newNode_) : ((DBGenome)this.targetGenome_).addNodeWithExistingLabel(this.newNode_);
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        this.drawIntoNetModuleSupport(this.newNode_, modCandidates, this.targetGenome_, overlayKey, support);
        NodeProperties np = new NodeProperties(this.targetLayout_, this.newNode_.getNodeType(), this.newNode_.getID(), x, y, false);
        this.propagateProperties(db, this.targetGenome_, this.newNode_.getNodeType(), np, this.newNode_.getID(), support);
        this.finishNetModPadFixups(null, null, this.targetLayout_, padFixups, frc, support);
        support.addEvent(new ModelChangeEvent(this.targetGenome_.getID(), 1));
        support.finish();
        return changeViz;
    }

    public int addNewNodeInsertedIntoLinkageForegroundPrep(Intersection intersect, Set resolved) {
        LinkSegmentID oneSeg = intersect.segmentIDFromIntersect();
        BusProperties bp = this.targetLayout_.getLinkProperties(intersect.getObjectID());
        resolved.addAll(bp.resolveLinkagesThroughSegment(oneSeg, this.targetGenome_));
        int resolution = this.resolveNewGroupMembership(resolved);
        return resolution;
    }

    public void addNewNodeInsertedIntoLinkage(boolean doGene, int resolution, Set resolved, int x, int y, Intersection intersect, FontRenderContext frc, UndoSupport support, Map neededLinksPerGenomeInstance, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        Database db = Database.getDB();
        ArrayList directFixups = new ArrayList();
        HashMap preMidLinks = new HashMap();
        HashMap postMidLinks = new HashMap();
        LinkSegmentID oneSeg = intersect.segmentIDFromIntersect();
        BusProperties bp = this.targetLayout_.getLinkProperties(intersect.getObjectID());
        BusProperties origRootLp = (BusProperties)bp.clone();
        Point2D.Double nodeLoc = new Point2D.Double();
        Node useNode = this.addNewNodeIntoLinkageForRoot(doGene, x, y, oneSeg, resolved, bp, frc, origRootLp, directFixups, preMidLinks, postMidLinks, nodeLoc, support);
        HashMap linkInstanceToNodePerGenome = new HashMap();
        HashMap oldToNewForFanOutPerGenome = new HashMap();
        HashMap oldToNewForFanInPerGenome = new HashMap();
        HashSet processed = new HashSet();
        int pCount = 0;
        double currProg = startFrac;
        Iterator iit = db.getInstanceIterator();
        int totalCount = 0;
        int rootCount = 0;
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            ++totalCount;
            if (gi.getVfgParent() != null) continue;
            ++rootCount;
        }
        double rootFrac = rootCount == 0 ? 0.0 : (double)rootCount / (double)totalCount;
        double allRootFrac = (endFrac - startFrac) * rootFrac;
        double perRootFrac = rootCount == 0 ? 0.0 : allRootFrac / (double)rootCount;
        double allRootMax = startFrac + allRootFrac;
        Iterator it = db.getInstanceIterator();
        while (it.hasNext()) {
            GenomeInstance gi = (GenomeInstance)it.next();
            ++pCount;
            this.insertNodeInRootInstance(useNode, gi, resolved, linkInstanceToNodePerGenome, oldToNewForFanOutPerGenome, oldToNewForFanInPerGenome, neededLinksPerGenomeInstance, processed, directFixups, preMidLinks, postMidLinks, oneSeg, origRootLp, nodeLoc, frc, doGene, resolution, support);
            if (monitor == null || monitor.updateProgress((int)((currProg += perRootFrac) * 100.0))) continue;
            throw new AsynchExitRequestException();
        }
        if (monitor != null) {
            monitor.updateProgress((int)(allRootMax * 100.0));
        }
        this.addNewNodeInsertedIntoLinkageForSubsets(useNode, processed, pCount, linkInstanceToNodePerGenome, oldToNewForFanOutPerGenome, oldToNewForFanInPerGenome, doGene, support);
        this.addNewNodeInsertedIntoLinkageKillAndClean(resolved, directFixups, support);
        if (monitor != null) {
            monitor.updateProgress((int)(endFrac * 100.0));
        }
        db.clearAllDynamicProxyCaches();
    }

    private Node addNewNodeIntoLinkageForRoot(boolean doGene, int x, int y, LinkSegmentID oneSeg, Set resolved, BusProperties bp, FontRenderContext frc, BusProperties origRootLp, List directFixups, Map preMidLinks, Map postMidLinks, Point2D nodeLoc, UndoSupport support) {
        Database db = Database.getDB();
        LinkSegment segGeom = bp.getSegmentGeometryForID(oneSeg, this.targetGenome_, this.targetLayout_, frc, true);
        Vector2D travel = segGeom.getRun();
        GenomeChange gc = doGene ? ((DBGenome)this.targetGenome_).addGeneWithExistingLabel((Gene)this.newNode_) : ((DBGenome)this.targetGenome_).addNodeWithExistingLabel(this.newNode_);
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        INodeRenderer nRend = NodeProperties.chooseRenderer(this.newNode_.getNodeType(), 2);
        Point2D.Double insertionPt = new Point2D.Double(x, y);
        UiUtil.forceToGrid(insertionPt, 10.0);
        NodeInsertionDirective pir = nRend.getInsertionDirective(travel, insertionPt);
        double xCoord = UiUtil.forceToGridValue((double)x + pir.offset.getX(), 10.0);
        double yCoord = UiUtil.forceToGridValue((double)y + pir.offset.getY(), 10.0);
        nodeLoc.setLocation(xCoord, yCoord);
        NodeProperties np = new NodeProperties(this.targetLayout_, this.newNode_.getNodeType(), this.newNode_.getID(), xCoord, yCoord, false);
        np.setOrientation(pir.orientation);
        np.setColor(bp.getColorName());
        if (this.newNode_.getNodeType() == 5) {
            np.setSecondColor(bp.getColorName());
        }
        this.propagateProperties(db, this.targetGenome_, this.newNode_.getNodeType(), np, this.newNode_.getID(), support);
        String firstLinkID = null;
        Iterator rit = resolved.iterator();
        boolean haveToMid = false;
        while (rit.hasNext()) {
            String linkID = (String)rit.next();
            Linkage rootLink = this.targetGenome_.getLinkage(linkID);
            String trgID = rootLink.getTarget();
            String midID = this.newNode_.getID();
            if (!haveToMid) {
                String srcID = rootLink.getSource();
                firstLinkID = ((DBGenome)this.targetGenome_).getNextKey();
                DBLinkage newLinkage = new DBLinkage(null, firstLinkID, srcID, midID, 0, pir.landingPad, rootLink.getLaunchPad());
                gc = ((DBGenome)this.targetGenome_).addLinkWithExistingLabel(newLinkage);
                if (gc != null) {
                    GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                    support.addEdit(gcc);
                }
                preMidLinks.put(srcID, firstLinkID);
                haveToMid = true;
            }
            String newLinkID = ((DBGenome)this.targetGenome_).getNextKey();
            DBLinkage newLinkage2 = new DBLinkage(null, newLinkID, midID, trgID, rootLink.getSign(), rootLink.getLandingPad(), pir.launchPad);
            String origName = rootLink.getName();
            if (origName != null && !origName.trim().equals("")) {
                newLinkage2.setName(origName);
            }
            if ((gc = ((DBGenome)this.targetGenome_).addLinkWithExistingLabel(newLinkage2)) != null) {
                GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                support.addEdit(gcc);
            }
            postMidLinks.put(linkID, newLinkID);
        }
        HashMap directFixupLinks = new HashMap();
        Layout.PropChange[] changes = this.targetLayout_.supportLinkNodeInsertion(oneSeg, resolved, this.newNode_.getID(), firstLinkID, postMidLinks, this.targetGenome_, frc, directFixupLinks, pir);
        directFixups.add(new DirectFixupInfo(this.targetLayout_, this.targetGenome_, directFixupLinks));
        support.addEdit(new PropChangeCmd(changes));
        return this.newNode_;
    }

    private void insertNodeInRootInstance(Node useNode, GenomeInstance gi, Set resolved, Map linkInstanceToNodePerGenome, Map oldToNewForFanOutPerGenome, Map oldToNewForFanInPerGenome, Map neededLinksPerGenomeInstance, Set processed, List directFixups, Map preMidLinks, Map postMidLinks, LinkSegmentID oneSeg, BusProperties origRootLp, Point2D nodeLoc, FontRenderContext frc, boolean doGene, int resolution, UndoSupport support) {
        HashMap oldToNewForFanIn;
        if (gi.getVfgParent() != null) {
            return;
        }
        Database db = Database.getDB();
        String giID = gi.getID();
        HashMap linkInstanceToNode = (HashMap)linkInstanceToNodePerGenome.get(giID);
        if (linkInstanceToNode == null) {
            linkInstanceToNode = new HashMap();
            linkInstanceToNodePerGenome.put(giID, linkInstanceToNode);
        }
        HashMap nodeToExistingLinkages = new HashMap();
        HashMap oldToNewForFanOut = (HashMap)oldToNewForFanOutPerGenome.get(giID);
        if (oldToNewForFanOut == null) {
            oldToNewForFanOut = new HashMap();
            oldToNewForFanOutPerGenome.put(giID, oldToNewForFanOut);
        }
        if ((oldToNewForFanIn = (HashMap)oldToNewForFanInPerGenome.get(giID)) == null) {
            oldToNewForFanIn = new HashMap();
            oldToNewForFanInPerGenome.put(giID, oldToNewForFanIn);
        }
        HashMap propLinksForMid = new HashMap();
        Vector2D zeroOffset = new Vector2D(0.0, 0.0);
        Layout gilo = db.getLayout(new LayoutManager().getLayout(giID));
        HashMap directFixupLinksForGilo = new HashMap();
        directFixups.add(new DirectFixupInfo(gilo, gi, directFixupLinksForGilo));
        Map rememberProps = gilo.buildRememberProps(gi, frc);
        HashMap linkBuiltFromSource = new HashMap();
        processed.add(giID);
        Iterator resit = resolved.iterator();
        while (resit.hasNext()) {
            String linkID = (String)resit.next();
            this.insertNodeInRootInstancePerResolvedLink(linkID, useNode, gi, zeroOffset, linkInstanceToNode, nodeToExistingLinkages, propLinksForMid, oldToNewForFanIn, oldToNewForFanOut, linkBuiltFromSource, preMidLinks, postMidLinks, doGene, resolution, support);
        }
        Iterator ntelit = nodeToExistingLinkages.keySet().iterator();
        while (ntelit.hasNext()) {
            HashSet<String> needAuto;
            Layout.PropChange lochange;
            HashMap<String, BusProperties.RememberProps> mappedRememberProps;
            String loFirstLinkID;
            String newNodeID = (String)ntelit.next();
            Set existing = (Set)nodeToExistingLinkages.get(newNodeID);
            HashMap fanInLinks = (HashMap)oldToNewForFanIn.get(newNodeID);
            HashMap fanOutLinks = (HashMap)oldToNewForFanOut.get(newNodeID);
            int fanOut = fanOutLinks == null ? 0 : new HashSet(fanOutLinks.values()).size();
            int fanIn = fanInLinks == null ? 0 : new HashSet(fanInLinks.values()).size();
            boolean didLayout = false;
            Layout.InheritedLinkNodeInsertionResult result = null;
            if (fanIn == 1 && (result = gilo.supportInheritedLinkNodeInsertion(oneSeg, existing, origRootLp, nodeLoc, this.targetLayout_, this.targetGenome_, gi, frc, newNodeID, loFirstLinkID = (String)fanInLinks.values().iterator().next(), fanOutLinks, directFixupLinksForGilo)) != null) {
                support.addEdit(new PropChangeCmd(result.changes));
                didLayout = true;
            }
            if (result != null) {
                this.specialtyPadChanges(result.padChanges, gi, support);
            }
            if (fanIn > 1) {
                GenomeChange gc;
                int defPad;
                int needed;
                int currPads = useNode.getPadCount();
                int nodeType = useNode.getNodeType();
                int padInc = DBNode.getPadIncrement(nodeType);
                if (padInc != 0 && (needed = fanIn + 1) > (defPad = DBNode.getDefaultPadCount(nodeType)) && (needed = defPad + (int)UiUtil.forceToGridValueMax(needed - defPad, padInc)) > currPads && (gc = nodeType == 4 ? gi.changeGeneSize(useNode.getID(), needed) : gi.changeNodeSize(useNode.getID(), needed)) != null) {
                    GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                    support.addEdit(gcc);
                }
            }
            if (didLayout) continue;
            if (fanIn == 1) {
                mappedRememberProps = new HashMap<String, BusProperties.RememberProps>();
                HashMap combinedOldToNew = new HashMap();
                Iterator vit = oldToNewForFanOut.values().iterator();
                while (vit.hasNext()) {
                    Map perNode = (Map)vit.next();
                    combinedOldToNew.putAll(perNode);
                }
                Iterator kit = rememberProps.keySet().iterator();
                while (kit.hasNext()) {
                    String linkID = (String)kit.next();
                    BusProperties.RememberProps rp = (BusProperties.RememberProps)rememberProps.get(linkID);
                    rp.remapLinks(combinedOldToNew);
                    String mappedID = (String)combinedOldToNew.get(linkID);
                    mappedRememberProps.put(mappedID == null ? linkID : mappedID, rp);
                }
            } else {
                mappedRememberProps = null;
            }
            if ((lochange = gilo.bestFitNodePlacementForInsertion(this.targetLayout_, gi, newNodeID, frc)) != null) {
                support.addEdit(new PropChangeCmd(lochange));
            }
            if ((needAuto = (HashSet<String>)neededLinksPerGenomeInstance.get(giID)) == null) {
                needAuto = new HashSet<String>();
                neededLinksPerGenomeInstance.put(giID, needAuto);
            }
            List plfm = (List)propLinksForMid.get(newNodeID);
            this.multiFanInPadFixup(plfm, newNodeID, gi, gilo, support);
            Iterator plfmit = plfm.iterator();
            while (plfmit.hasNext()) {
                String lid = (String)plfmit.next();
                needAuto.add(lid);
                AddCommands.autoAddCrudeLinkProperties(gi, gilo, lid, support, mappedRememberProps, frc);
            }
        }
    }

    private void multiFanInPadFixup(List linksForNewNode, String newNodeID, GenomeInstance gi, Layout lo, UndoSupport support) {
        HashMap<String, PadConstraints> padConstraints = new HashMap<String, PadConstraints>();
        int numL = linksForNewNode.size();
        for (int i = 0; i < numL; ++i) {
            String linkID = (String)linksForNewNode.get(i);
            PadConstraints pc = new PadConstraints();
            padConstraints.put(linkID, pc);
        }
        HashSet<Node> newNodeInstances = new HashSet<Node>();
        Node newNodeInstance = gi.getNode(newNodeID);
        newNodeInstances.add(newNodeInstance);
        this.wigglePadCore(newNodeInstances.iterator(), lo, gi, padConstraints, support);
    }

    private int resolveNewGroupMembership(Set linkSet) {
        Database db = Database.getDB();
        Iterator it = db.getInstanceIterator();
        while (it.hasNext()) {
            GenomeInstance gi = (GenomeInstance)it.next();
            if (gi.getVfgParent() != null) continue;
            String giID = gi.getID();
            Iterator lit = gi.getLinkageIterator();
            while (lit.hasNext()) {
                String trgGrpID;
                LinkageInstance li = (LinkageInstance)lit.next();
                String liid = li.getID();
                if (!linkSet.contains(GenomeItemInstance.getBaseID(liid))) continue;
                NodeInstance src = (NodeInstance)gi.getNode(li.getSource());
                NodeInstance trg = (NodeInstance)gi.getNode(li.getTarget());
                GroupMembership srcGroupMemb = gi.getNodeGroupMembership(src);
                GroupMembership trgGroupMemb = gi.getNodeGroupMembership(trg);
                if (srcGroupMemb.mainGroups.size() != 1 || trgGroupMemb.mainGroups.size() != 1) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("insertNode.groupConfusion"), rMan.getString("insertNode.groupConfusionTitle"), 0);
                    return 0;
                }
                String srcGrpID = (String)srcGroupMemb.mainGroups.iterator().next();
                if (srcGrpID.equals(trgGrpID = (String)trgGroupMemb.mainGroups.iterator().next())) continue;
                ResourceManager rMan = ResourceManager.getManager();
                int result = JOptionPane.showOptionDialog(this.topWindow_, rMan.getString("insertNode.chooseRegionDestination"), rMan.getString("insertNode.chooseRegionDestinationTitle"), -1, 3, null, new Object[]{rMan.getString("insertNode.source"), rMan.getString("insertNode.target"), rMan.getString("dialogs.cancel")}, rMan.getString("insertNode.target"));
                if (result == -1) {
                    return 0;
                }
                if (result == 0) {
                    return 2;
                }
                if (result == 1) {
                    return 3;
                }
                return 0;
            }
        }
        return 1;
    }

    private void insertNodeInRootInstancePerResolvedLink(String linkID, Node useNode, GenomeInstance gi, Vector2D zeroOffset, Map linkInstanceToNode, Map nodeToExistingLinkages, Map propLinksForMid, Map oldToNewForFanIn, Map oldToNewForFanOut, Map linkBuiltFromSource, Map preMidLinks, Map postMidLinks, boolean doGene, int resolution, UndoSupport support) {
        String giID = gi.getID();
        ArrayList<LinkageInstance> newLinksToAdd = new ArrayList<LinkageInstance>();
        HashMap generatedINums = new HashMap();
        HashMap linkBuiltToTarget = new HashMap();
        Iterator lit = gi.getLinkageIterator();
        while (lit.hasNext()) {
            LinkageInstance newLink;
            int instanceCount;
            HashSet<Integer> excludeSet;
            HashMap<String, String> lbtt;
            HashMap<String, String> lbfs;
            HashMap<String, String> fanOutLinks;
            HashMap<String, String> fanInLinks;
            String nid;
            GroupMembership groupMemb;
            LinkageInstance li = (LinkageInstance)lit.next();
            String liid = li.getID();
            if (!GenomeItemInstance.getBaseID(liid).equals(linkID)) continue;
            NodeInstance src = (NodeInstance)gi.getNode(li.getSource());
            NodeInstance trg = (NodeInstance)gi.getNode(li.getTarget());
            GroupMembership groupMembership = groupMemb = resolution == 2 ? gi.getNodeGroupMembership(src) : gi.getNodeGroupMembership(trg);
            if (groupMemb.mainGroups.isEmpty()) {
                throw new IllegalStateException();
            }
            String grpID = (String)groupMemb.mainGroups.iterator().next();
            Group group = gi.getGroup(grpID);
            if (group.instanceIsInGroup(useNode.getID())) {
                Node niFromGroup = group.getInstanceInGroup(useNode.getID(), gi);
                nid = niFromGroup.getID();
            } else {
                NodeInstance ni = this.propagateNodeNoLayout(doGene, gi, (DBNode)this.newNode_, group, support, null);
                nid = ni.getID();
                Iterator grit = groupMemb.subGroups.iterator();
                while (grit.hasNext()) {
                    grpID = (String)grit.next();
                    group = gi.getGroup(grpID);
                    GroupChange grc = group.addMember(new GroupMember(nid), giID);
                    if (grc == null) continue;
                    GroupChangeCmd grcc = new GroupChangeCmd(grc);
                    support.addEdit(grcc);
                }
                this.propagateNodeLayoutProps(gi, (DBNode)useNode, ni, this.targetLayout_, zeroOffset, support);
            }
            linkInstanceToNode.put(liid, nid);
            HashSet<String> existingThruNode = (HashSet<String>)nodeToExistingLinkages.get(nid);
            if (existingThruNode == null) {
                existingThruNode = new HashSet<String>();
                nodeToExistingLinkages.put(nid, existingThruNode);
            }
            existingThruNode.add(liid);
            Linkage rootLink = this.targetGenome_.getLinkage(linkID);
            String midID = (String)linkInstanceToNode.get(liid);
            String srcID = src.getID();
            String trgID = trg.getID();
            NodeInstance mid = (NodeInstance)gi.getNode(midID);
            String preLinkID = (String)preMidLinks.get(rootLink.getSource());
            DBLinkage preLink = (DBLinkage)this.targetGenome_.getLinkage(preLinkID);
            String postLinkID = (String)postMidLinks.get(linkID);
            DBLinkage postLink = (DBLinkage)this.targetGenome_.getLinkage(postLinkID);
            ArrayList<String> propLinks = (ArrayList<String>)propLinksForMid.get(midID);
            if (propLinks == null) {
                propLinks = new ArrayList<String>();
                propLinksForMid.put(midID, propLinks);
            }
            if ((fanInLinks = (HashMap<String, String>)oldToNewForFanIn.get(midID)) == null) {
                fanInLinks = new HashMap<String, String>();
                oldToNewForFanIn.put(midID, fanInLinks);
            }
            if ((fanOutLinks = (HashMap<String, String>)oldToNewForFanOut.get(midID)) == null) {
                fanOutLinks = new HashMap<String, String>();
                oldToNewForFanOut.put(midID, fanOutLinks);
            }
            if ((lbfs = (HashMap<String, String>)linkBuiltFromSource.get(midID)) == null) {
                lbfs = new HashMap<String, String>();
                linkBuiltFromSource.put(midID, lbfs);
            }
            if ((lbtt = (HashMap<String, String>)linkBuiltToTarget.get(midID)) == null) {
                lbtt = new HashMap<String, String>();
                linkBuiltToTarget.put(midID, lbtt);
            }
            if (!lbfs.keySet().contains(srcID)) {
                excludeSet = (HashSet<Integer>)generatedINums.get(preLinkID);
                if (excludeSet == null) {
                    excludeSet = new HashSet<Integer>();
                    generatedINums.put(preLinkID, excludeSet);
                }
                instanceCount = gi.getNextLinkInstanceNumberWithExclusion(preLinkID, excludeSet);
                excludeSet.add(new Integer(instanceCount));
                int srcInstance = GenomeItemInstance.getInstanceID(src.getInstance());
                int midInstance = GenomeItemInstance.getInstanceID(mid.getInstance());
                newLink = new LinkageInstance(preLink, instanceCount, srcInstance, midInstance);
                newLink.setLaunchPad(li.getLaunchPad());
                propLinks.add(newLink.getID());
                newLinksToAdd.add(newLink);
                lbfs.put(srcID, newLink.getID());
                fanInLinks.put(liid, newLink.getID());
            } else {
                fanInLinks.put(liid, (String)lbfs.get(srcID));
            }
            if (!lbtt.keySet().contains(trgID)) {
                excludeSet = (HashSet<Integer>)generatedINums.get(postLinkID);
                if (excludeSet == null) {
                    excludeSet = new HashSet<Integer>();
                    generatedINums.put(postLinkID, excludeSet);
                }
                instanceCount = gi.getNextLinkInstanceNumberWithExclusion(postLinkID, excludeSet);
                excludeSet.add(new Integer(instanceCount));
                int midInstance = GenomeItemInstance.getInstanceID(mid.getInstance());
                int trgInstance = GenomeItemInstance.getInstanceID(trg.getInstance());
                newLink = new LinkageInstance(postLink, instanceCount, midInstance, trgInstance);
                newLink.setLandingPad(li.getLandingPad());
                propLinks.add(newLink.getID());
                newLinksToAdd.add(newLink);
                lbtt.put(trgID, newLink.getID());
                fanOutLinks.put(liid, newLink.getID());
                continue;
            }
            fanOutLinks.put(liid, (String)lbtt.get(trgID));
        }
        int numToAdd = newLinksToAdd.size();
        for (int i = 0; i < numToAdd; ++i) {
            LinkageInstance newLink = (LinkageInstance)newLinksToAdd.get(i);
            GenomeChange gc = gi.addLinkage(newLink);
            if (gc == null) continue;
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
    }

    private void addNewNodeInsertedIntoLinkageForSubsets(Node useNode, Set processed, int pCount, Map linkInstanceToNodePerGenome, Map oldToNewForFanOutPerGenome, Map oldToNewForFanInPerGenome, boolean doGene, UndoSupport support) {
        Database db = Database.getDB();
        String baseID = useNode.getID();
        while (processed.size() < pCount) {
            Iterator it = db.getInstanceIterator();
            while (it.hasNext()) {
                GenomeInstance parent;
                String parentID;
                GenomeInstance git = (GenomeInstance)it.next();
                String myID = git.getID();
                if (processed.contains(myID) || !processed.contains(parentID = (parent = git.getVfgParent()).getID())) continue;
                GenomeInstance rootInstance = git.getVfgParentRoot();
                String rootParentID = rootInstance.getID();
                processed.add(myID);
                HashMap linkInstanceToNode = (HashMap)linkInstanceToNodePerGenome.get(rootParentID);
                HashMap oldToNewForFanOut = (HashMap)oldToNewForFanOutPerGenome.get(rootParentID);
                HashMap oldToNewForFanIn = (HashMap)oldToNewForFanInPerGenome.get(rootParentID);
                ArrayList<String> linksToProp = new ArrayList<String>();
                Iterator lit = git.getLinkageIterator();
                while (lit.hasNext()) {
                    Map fanInMap;
                    String newLinkID;
                    Map fanOutMap;
                    LinkageInstance li = (LinkageInstance)lit.next();
                    String nid = (String)linkInstanceToNode.get(li.getID());
                    if (nid == null) continue;
                    if (git.getNode(nid) == null) {
                        NodeInstance ni = (NodeInstance)parent.getNode(nid);
                        this.addNewNodeToSubsetInstance(myID, ni, support);
                    }
                    if (oldToNewForFanOut != null && (fanOutMap = (Map)oldToNewForFanOut.get(nid)) != null && (newLinkID = (String)fanOutMap.get(li.getID())) != null) {
                        linksToProp.add(newLinkID);
                    }
                    if (oldToNewForFanIn == null || (fanInMap = (Map)oldToNewForFanIn.get(nid)) == null || (newLinkID = (String)fanInMap.get(li.getID())) == null) continue;
                    linksToProp.add(newLinkID);
                }
                int numPL = linksToProp.size();
                for (int i = 0; i < numPL; ++i) {
                    String linkID = (String)linksToProp.get(i);
                    LinkageInstance li = (LinkageInstance)parent.getLinkage(linkID);
                    this.addNewLinkToSubsetInstance(myID, li, support);
                }
            }
        }
    }

    private void addNewNodeInsertedIntoLinkageKillAndClean(Set resolved, List directFixups, UndoSupport support) {
        DeleteCommands dc = new DeleteCommands();
        dc.deleteLinkSetFromModel(resolved, this.targetGenome_.getID(), support);
        Iterator dfit = directFixups.iterator();
        while (dfit.hasNext()) {
            DirectFixupInfo dfi = (DirectFixupInfo)dfit.next();
            Layout dflo = dfi.doLayout;
            Iterator doit = dfi.doLinks.keySet().iterator();
            while (doit.hasNext()) {
                NodeInsertionDirective nid;
                String linkID = (String)doit.next();
                Layout.PropChange pc = dflo.makeLinkageDirectForLink(linkID, dfi.genome, nid = (NodeInsertionDirective)dfi.doLinks.get(linkID));
                if (pc == null) continue;
                support.addEdit(new PropChangeCmd(pc));
            }
        }
    }

    public void locateNewNote(NoteCandidate ntCand, int x, int y) {
        GenomeInstance root;
        UndoSupport support = new UndoSupport(this.undom_, "undo.addNote");
        GenomeChange gc = this.targetGenome_.addNoteWithExistingLabel(ntCand.newNote);
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        NoteProperties np = new NoteProperties(this.targetLayout_, ntCand.newNote.getID(), ntCand.newNoteColor, x, y);
        if (ntCand.newNoteFont != null) {
            np.setFontOverride(ntCand.newNoteFont);
        }
        Database db = Database.getDB();
        Iterator loit = db.getLayoutIterator();
        String genomeKey = this.targetGenome_.getID();
        if (this.targetGenome_ instanceof GenomeInstance && (root = ((GenomeInstance)this.targetGenome_).getVfgParentRoot()) != null) {
            genomeKey = root.getID();
        }
        while (loit.hasNext()) {
            Layout.PropChange[] lpc;
            Layout lo = (Layout)loit.next();
            String loTarg = lo.getTarget();
            if (!loTarg.equals(genomeKey) || (lpc = new Layout.PropChange[]{lo.setNoteProperties(ntCand.newNote.getID(), (NoteProperties)np.clone())})[0] == null) continue;
            PropChangeCmd pcc = new PropChangeCmd(lpc);
            support.addEdit(pcc);
        }
        support.addEvent(new ModelChangeEvent(this.targetGenome_.getID(), 1));
        support.finish();
    }

    public boolean addNewNodeToSubsetInstance(String genomeKey, NodeInstance useNode, UndoSupport support) {
        GenomeChange gc;
        NodeInstance newInstance;
        boolean doGene;
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeKey);
        if (!(genome instanceof GenomeInstance)) {
            throw new IllegalArgumentException();
        }
        GenomeInstance gi = (GenomeInstance)genome;
        GenomeInstance parent = gi.getVfgParent();
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = doGene = useNode.getNodeType() == 4;
        if (doGene) {
            newInstance = new GeneInstance((GeneInstance)useNode);
            gc = gi.addGene((Gene)((Object)newInstance));
        } else {
            newInstance = new NodeInstance(useNode);
            gc = gi.addNode(newInstance);
        }
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            if (support == null) {
                throw new IllegalArgumentException();
            }
            support.addEdit(gcc);
            support.addEvent(new ModelChangeEvent(genomeKey, 1));
        }
        return true;
    }

    public NodeCandidate addNewNodeToRoot(boolean doGene, String layoutKey, String overlayKey, Set modKeys) {
        Database db = Database.getDB();
        this.targetLayout_ = db.getLayout(layoutKey);
        DBGenome genome = (DBGenome)db.getGenome();
        NodeCreationInfo ni = doGene ? this.getInfoForNewRootGene(genome, overlayKey, modKeys) : this.getInfoForNewRootNode(genome, overlayKey, modKeys);
        if (ni == null) {
            return null;
        }
        String nodeID = genome.getNextKey();
        this.newNode_ = ni.newType == 4 ? new DBGene(ni.newName, nodeID) : new DBNode(ni.newType, ni.newName, nodeID);
        this.targetGenome_ = genome;
        NodeCandidate retval = new NodeCandidate();
        retval.node = this.newNode_;
        retval.addToModule = ni.addToModule;
        return retval;
    }

    private NodeCreationInfo getInfoForNewRootNode(DBGenome genome, String overlayKey, Set modKeys) {
        NodeCreationInfo retval = new NodeCreationInfo(null, null, 3, false, null, false);
        NodeCreationDialog ncd = new NodeCreationDialog(this.topWindow_, retval.newType, genome.getUniqueNodeName(), overlayKey, modKeys);
        ncd.show();
        if (!ncd.haveResult()) {
            return null;
        }
        retval.newName = ncd.getName();
        retval.newType = ncd.getType();
        retval.addToModule = ncd.doModuleAdd();
        return retval;
    }

    private NodeCreationInfo getInfoForNewRootGene(DBGenome genome, String overlayKey, Set modKeys) {
        NodeCreationInfo retval = new NodeCreationInfo(null, null, 4, false, null, false);
        Database db = Database.getDB();
        GeneCreationDialog ncd = new GeneCreationDialog(this.topWindow_, genome.getUniqueGeneName(), overlayKey, modKeys);
        ncd.show();
        if (!ncd.haveResult()) {
            return null;
        }
        retval.newName = ncd.getName();
        retval.addToModule = ncd.doModuleAdd();
        return retval;
    }

    public NodeCandidate drawNewNodeToInstance(boolean doGene, String genomeKey, String layoutKey, SUPanel.NetModuleIntersector intersector, String overlayKey, Set modKeys, FontRenderContext frc) {
        int rootType;
        Node rootNode;
        String nodeID;
        Database db = Database.getDB();
        GenomeInstance gi = (GenomeInstance)db.getGenome(genomeKey);
        this.targetLayout_ = db.getLayout(layoutKey);
        DBGenome genome = (DBGenome)db.getGenome();
        NodeCreationInfo ni = doGene ? this.getInfoForNewGene(gi, genome, overlayKey, modKeys) : this.getInfoForNewNode(gi, genome, overlayKey, modKeys);
        if (ni == null) {
            return null;
        }
        if (ni.oldID == null) {
            if (ni.oldIDOptions != null) {
                this.existingRootNodeOptions_ = ni.oldIDOptions;
            }
            nodeID = genome.getNextKey();
            this.newRootNode_ = doGene ? new DBGene(ni.newName, nodeID) : new DBNode(ni.newType, ni.newName, nodeID);
            this.existingRootNode_ = null;
            db.clearHoldingGenome();
            Genome holding = db.getHoldingGenome();
            if (doGene) {
                holding.addGene((Gene)this.newRootNode_);
            } else {
                holding.addNode(this.newRootNode_);
            }
            rootNode = this.newRootNode_;
            rootType = ni.newType;
        } else {
            nodeID = ni.oldID;
            this.newRootNode_ = null;
            rootNode = this.existingRootNode_ = genome.getNode(GenomeItemInstance.getBaseID(ni.oldID));
            rootType = this.existingRootNode_.getNodeType();
        }
        this.targetGenome_ = gi;
        if (ni.immediateAdd) {
            this.newNode_ = gi.getVfgParentRoot().getNode(nodeID);
            List modCandidates = null;
            if (ni.addToModule) {
                NodeProperties np = this.targetLayout_.getNodeProperties(nodeID);
                Point2D nodeLoc = np.getLocation();
                modCandidates = intersector.netModuleIntersections((int)nodeLoc.getX(), (int)nodeLoc.getY(), 0.0);
            }
            this.finishDrawNewNodeAddToInstance(true, 0, 0, null, modCandidates, overlayKey, frc, false);
            return null;
        }
        GenomeInstance rootInstance = gi.getVfgParentRoot();
        rootInstance = rootInstance == null ? gi : rootInstance;
        int instanceCount = rootInstance.getNextNodeInstanceNumber(nodeID);
        this.newNode_ = doGene ? new GeneInstance((DBGene)rootNode, instanceCount, null, 0) : new NodeInstance((DBNode)rootNode, rootType, instanceCount, null, 0);
        NodeCandidate retval = new NodeCandidate();
        retval.node = this.newNode_;
        retval.addToModule = ni.addToModule;
        return retval;
    }

    private NodeCreationInfo getInfoForNewNode(GenomeInstance gi, DBGenome genome, String overlayKey, Set modKeys) {
        NodeCreationInfo retval = new NodeCreationInfo(null, null, -1, false, null, false);
        DrawNodeInstanceCreationDialog ncd = new DrawNodeInstanceCreationDialog(this.topWindow_, (Genome)genome, gi, genome.getUniqueNodeName(), overlayKey, modKeys);
        ncd.show();
        if (!ncd.haveResult()) {
            return null;
        }
        if (ncd.haveImmediateAdd()) {
            retval.immediateAdd = true;
        }
        retval.addToModule = ncd.doModuleAdd();
        retval.oldID = ncd.getID();
        if (retval.oldID == null) {
            retval.newName = ncd.getName();
            retval.newType = ncd.getType();
            retval.oldIDOptions = ncd.getIDOptions();
        }
        return retval;
    }

    private NodeCreationInfo getInfoForNewGene(GenomeInstance gi, DBGenome genome, String overlayKey, Set modKeys) {
        NodeCreationInfo retval = new NodeCreationInfo(null, null, 4, false, null, false);
        DrawGeneInstanceCreationDialog ncd = new DrawGeneInstanceCreationDialog(this.topWindow_, (Genome)genome, gi, genome.getUniqueGeneName(), overlayKey, modKeys);
        ncd.show();
        if (!ncd.haveResult()) {
            return null;
        }
        if (ncd.haveImmediateAdd()) {
            retval.immediateAdd = true;
        }
        retval.addToModule = ncd.doModuleAdd();
        retval.oldID = ncd.getID();
        if (retval.oldID == null) {
            retval.newName = ncd.getName();
        }
        return retval;
    }

    public int checkForNodeReuseInGroup(Group group) {
        GenomeInstance tgi = (GenomeInstance)this.targetGenome_;
        if (this.existingRootNodeOptions_ == null) {
            return 2;
        }
        if (tgi.getVfgParent() == null) {
            HashSet<String> remainingOptions = new HashSet<String>();
            Iterator ernoit = this.existingRootNodeOptions_.iterator();
            while (ernoit.hasNext()) {
                String existingID = (String)ernoit.next();
                if (group.instanceIsInGroup(existingID)) continue;
                remainingOptions.add(existingID);
            }
            if (remainingOptions.size() > 0) {
                Genome rootGenome = Database.getDB().getGenome();
                DrawNodeInstanceExistingOptionsDialog eod = new DrawNodeInstanceExistingOptionsDialog(this.topWindow_, rootGenome, tgi, remainingOptions, new HashSet());
                eod.show();
                if (!eod.haveResult()) {
                    return 0;
                }
                if (!eod.doDraw()) {
                    this.newRootNode_ = null;
                    this.existingRootNode_ = rootGenome.getNode(eod.getID());
                    int instanceCount = tgi.getNextNodeInstanceNumber(eod.getID());
                    this.newNode_ = new NodeInstance((DBNode)this.existingRootNode_, this.existingRootNode_.getNodeType(), instanceCount, null, 0);
                }
            }
        } else {
            HashSet<String> remainingOptions = new HashSet<String>();
            HashSet<String> remainingInstanceOptions = new HashSet<String>();
            GenomeInstance rootVfg = tgi.getVfgParentRoot();
            String baseGrpID = Group.getBaseID(group.getID());
            int genCount = rootVfg.getGeneration();
            String inherit = Group.buildInheritedID(baseGrpID, genCount);
            Group rootGroup = rootVfg.getGroup(inherit);
            Iterator ernoit = this.existingRootNodeOptions_.iterator();
            while (ernoit.hasNext()) {
                String existingID = (String)ernoit.next();
                NodeInstance checkNodeInstance = (NodeInstance)rootGroup.getInstanceInGroup(existingID, rootVfg);
                if (checkNodeInstance == null) {
                    remainingOptions.add(existingID);
                    continue;
                }
                String inGrpID = checkNodeInstance.getID();
                Node inSub = this.targetGenome_.getNode(inGrpID);
                if (inSub != null) continue;
                remainingInstanceOptions.add(inGrpID);
            }
            if (remainingOptions.size() > 0 || remainingInstanceOptions.size() > 0) {
                Genome rootGenome = Database.getDB().getGenome();
                DrawNodeInstanceExistingOptionsDialog eod = new DrawNodeInstanceExistingOptionsDialog(this.topWindow_, rootGenome, tgi, remainingOptions, remainingInstanceOptions);
                eod.show();
                if (!eod.haveResult()) {
                    return 0;
                }
                if (!eod.doDraw()) {
                    this.newRootNode_ = null;
                    this.existingRootNode_ = rootGenome.getNode(eod.getID());
                    if (!GenomeItemInstance.getBaseID(eod.getID()).equals(eod.getID())) {
                        this.newNode_ = tgi.getVfgParentRoot().getNode(eod.getID());
                        return 1;
                    }
                    int instanceCount = rootVfg.getNextNodeInstanceNumber(eod.getID());
                    this.newNode_ = new NodeInstance((DBNode)this.existingRootNode_, this.existingRootNode_.getNodeType(), instanceCount, null, 0);
                }
            }
        }
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean finishDrawNewNodeAddToInstance(boolean doGene, int x, int y, Group group, List modCandidates, String overlayKey, FontRenderContext frc, boolean intoBlackHole) {
        GenomeInstance rootVfg;
        Group rootGroup;
        int mode;
        GenomeInstance tgi = (GenomeInstance)this.targetGenome_;
        String inGrpID = null;
        NodeInstance rootNodeInstance = null;
        if (tgi.getVfgParent() == null) {
            if (group.instanceIsInGroup(GenomeItemInstance.getBaseID(this.newNode_.getID()))) {
                return null;
            }
            mode = 0;
            rootGroup = group;
        } else if (group != null) {
            String baseID;
            int genCount;
            String baseGrpID;
            String inherit;
            rootVfg = tgi.getVfgParentRoot();
            rootGroup = rootVfg.getGroup(inherit = Group.buildInheritedID(baseGrpID = Group.getBaseID(group.getID()), genCount = rootVfg.getGeneration()));
            rootNodeInstance = (NodeInstance)rootGroup.getInstanceInGroup(baseID = GenomeItemInstance.getBaseID(this.newNode_.getID()), rootVfg);
            if (rootNodeInstance == null) {
                mode = 1;
            } else {
                inGrpID = rootNodeInstance.getID();
                Node inSub = this.targetGenome_.getNode(inGrpID);
                if (inSub != null) return null;
                mode = 2;
            }
        } else {
            mode = 2;
            rootGroup = null;
            rootVfg = tgi.getVfgParentRoot();
            rootNodeInstance = (NodeInstance)rootVfg.getNode(this.newNode_.getID());
        }
        Layout.PadNeedsForLayout rootFixups = null;
        Layout rootLo = null;
        if (this.newRootNode_ != null) {
            Database db = Database.getDB();
            rootLo = db.getLayout(new LayoutManager().getLayout(db.getGenome().getID()));
            rootFixups = rootLo.findAllNetModuleLinkPadRequirements(frc);
        }
        Layout.PadNeedsForLayout padFixups = this.targetLayout_.findAllNetModuleLinkPadRequirements(frc);
        boolean changeViz = false;
        if (intoBlackHole) {
            ResourceManager rMan = ResourceManager.getManager();
            String message = UiUtil.convertMessageToHtml(rMan.getString("intoBlackHole.resetViz"));
            int changeVizVal = JOptionPane.showConfirmDialog(this.topWindow_, message, rMan.getString("intoBlackHole.resetVizTitle"), 1);
            if (changeVizVal == 2) {
                return new Boolean(false);
            }
            changeViz = changeVizVal == 0;
        }
        UndoSupport support = new UndoSupport(this.undom_, doGene ? "undo.addGeneToInstance" : "undo.addNodeToInstance");
        ArrayList<GenomeInstance> ancestry = new ArrayList<GenomeInstance>();
        ancestry.add(tgi);
        for (GenomeInstance parent = tgi.getVfgParent(); parent != null; parent = parent.getVfgParent()) {
            ancestry.add(parent);
        }
        Collections.reverse(ancestry);
        GenomeInstance pgi = null;
        NodeInstance pInst = null;
        int aNum = ancestry.size();
        for (int i = 0; i < aNum; ++i) {
            GenomeInstance gi = (GenomeInstance)ancestry.get(i);
            if (i == 0) {
                if (mode != 2) {
                    this.drawNewNodeAddForRootInstance(doGene, x, y, rootGroup, gi, support);
                    if (mode == 0) {
                        this.drawIntoNetModuleSupport(this.newNode_, modCandidates, gi, overlayKey, support);
                        this.finishNetModPadFixups(rootLo, rootFixups, this.targetLayout_, padFixups, frc, support);
                        support.finish();
                        return new Boolean(changeViz);
                    }
                    pInst = (NodeInstance)this.newNode_;
                    inGrpID = this.newNode_.getID();
                } else {
                    pInst = rootNodeInstance;
                    inGrpID = pInst.getID();
                }
            } else {
                Node inSub = gi.getNode(inGrpID);
                if (inSub == null) {
                    this.addNewNodeToSubsetInstance(gi.getID(), pInst, support);
                    inSub = gi.getNode(inGrpID);
                    if (i == aNum - 1) {
                        this.drawIntoNetModuleSupport(inSub, modCandidates, gi, overlayKey, support);
                    }
                }
                pInst = (NodeInstance)inSub;
            }
            pgi = gi;
        }
        this.finishNetModPadFixups(rootLo, rootFixups, this.targetLayout_, padFixups, frc, support);
        support.finish();
        return new Boolean(changeViz);
    }

    public void drawIntoNetModuleSupport(Node newNode, List modCandidates, Genome genome, String overlayKey, UndoSupport support) {
        if (modCandidates != null && !modCandidates.isEmpty()) {
            NetOverlayOwner owner = Database.getDB().getOverlayOwnerFromGenomeKey(genome.getID());
            NetworkOverlay nol = owner.getNetworkOverlay(overlayKey);
            int numMod = modCandidates.size();
            for (int i = 0; i < numMod; ++i) {
                NetModuleChange nmc;
                GenomeInstance gi;
                Group group;
                String moduleID = (String)modCandidates.get(i);
                NetModule nmod = nol.getModule(moduleID);
                String attachedGroup = nmod.getGroupAttachment();
                if (attachedGroup != null && !(group = (gi = (GenomeInstance)genome).getGroup(attachedGroup)).isInGroup(newNode.getID(), gi) || (nmc = owner.addMemberToNetworkModule(overlayKey, nmod, newNode.getID())) == null) continue;
                NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmc);
                support.addEdit(gcc);
            }
        }
    }

    private void handleLayoutDerivation(GenomeInstance gi, Group group, UndoSupport support) {
        LayoutDataSource lds;
        Group rootGroup;
        GenomeInstance tgi;
        GenomeInstance parentGi = gi.getVfgParent();
        if (parentGi == null) {
            tgi = gi;
            rootGroup = group;
        } else {
            tgi = parentGi;
            String baseGrpID = Group.getBaseID(group.getID());
            int genCount = tgi.getGeneration();
            String inherit = Group.buildInheritedID(baseGrpID, genCount);
            rootGroup = tgi.getGroup(inherit);
        }
        Database db = Database.getDB();
        Genome rootGenome = db.getGenome();
        Layout rootLo = db.getLayout(new LayoutManager().getLayout(rootGenome.getID()));
        LayoutDerivation ld = rootLo.getDerivation();
        if (ld == null) {
            ld = new LayoutDerivation();
        }
        if (!ld.containsDirectiveModuloTransforms(lds = new LayoutDataSource(tgi.getID(), rootGroup.getID()))) {
            ld.addDirective(lds);
            Layout.PropChange lpc = rootLo.setDerivation(ld);
            PropChangeCmd pcc = new PropChangeCmd(lpc);
            support.addEdit(pcc);
        }
    }

    private boolean drawNewNodeAddForRootInstance(boolean doGene, int x, int y, Group group, GenomeInstance rootVfg, UndoSupport support) {
        GroupChange grc;
        GenomeChange gc;
        Database db = Database.getDB();
        if (this.newRootNode_ != null) {
            DBGenome genome = (DBGenome)db.getGenome();
            GenomeChange gc2 = doGene ? genome.addGeneWithExistingLabel((Gene)this.newRootNode_) : genome.addNodeWithExistingLabel(this.newRootNode_);
            if (gc2 != null) {
                GenomeChangeCmd gcc = new GenomeChangeCmd(gc2);
                support.addEdit(gcc);
            }
            support.addEvent(new ModelChangeEvent(genome.getID(), 1));
            db.clearHoldingGenome();
            Layout rootLo = db.getLayout(new LayoutManager().getLayout(genome.getID()));
            NodeProperties np = new NodeProperties(rootLo, this.newRootNode_.getNodeType(), this.newRootNode_.getID(), x, y, false);
            this.propagateProperties(db, genome, this.newRootNode_.getNodeType(), np, this.newRootNode_.getID(), support);
            this.handleLayoutDerivation(rootVfg, group, support);
        }
        if ((gc = doGene ? rootVfg.addGene((Gene)this.newNode_) : rootVfg.addNode(this.newNode_)) != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        if ((grc = group.addMember(new GroupMember(this.newNode_.getID()), rootVfg.getID())) != null) {
            GroupChangeCmd grcc = new GroupChangeCmd(grc);
            support.addEdit(grcc);
        }
        support.addEvent(new ModelChangeEvent(rootVfg.getID(), 1));
        NodeProperties newProp = new NodeProperties(this.targetLayout_, this.newNode_.getNodeType(), this.newNode_.getID(), x, y, false);
        this.propagateProperties(db, rootVfg, this.newNode_.getNodeType(), newProp, this.newNode_.getID(), support);
        return true;
    }

    public boolean addNewLinkFinish(String genomeKey, String layoutKey, LinkCandidate lc, FontRenderContext frc) {
        Database db = Database.getDB();
        Layout layout = db.getLayout(layoutKey);
        Genome genome = db.getGenome(genomeKey);
        if (genome instanceof DBGenome) {
            return this.addNewLinktoRootFinish((DBGenome)genome, layout, lc, frc);
        }
        return this.addNewLinkToInstanceFinish((GenomeInstance)genome, layout, lc, frc);
    }

    private boolean addNewLinktoRootFinish(DBGenome genome, Layout layout, LinkCandidate lc, FontRenderContext frc) {
        String linkID;
        Database db = Database.getDB();
        lc.builtID = linkID = genome.getNextKey();
        String src = lc.source.getObjectID();
        if (genome.getLinkage(src) != null) {
            return this.addToLinkTree(layout, linkID, genome, lc, frc);
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.addLink");
        int srcPad = ((Intersection.PadVal)lc.source.getSubID()).padNum;
        String targ = lc.target.getObjectID();
        this.switchLinkSign(genome, targ, lc);
        int trgPad = ((Intersection.PadVal)lc.target.getSubID()).padNum;
        DBLinkage newLinkage = new DBLinkage(lc.label, linkID, src, targ, lc.sign, trgPad, srcPad);
        GenomeChange gc = genome.addLinkWithExistingLabel(newLinkage);
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        BusProperties lp = this.convertCandidateToBus(genome, layout, lc, linkID, src);
        this.propagateLinkProperties(db, genome, lp, linkID, support);
        support.addEvent(new ModelChangeEvent(genome.getID(), 1));
        support.finish();
        return true;
    }

    private void switchLinkSign(Genome genome, String targ, LinkCandidate lc) {
        ResourceManager rMan;
        int changeSignVal;
        Node trgNode = genome.getNode(targ);
        int trgType = trgNode.getNodeType();
        if ((trgType == 5 || trgType == 6) && lc.sign != 0 && (changeSignVal = JOptionPane.showConfirmDialog(this.topWindow_, (rMan = ResourceManager.getManager()).getString("badSign.changeToNeutral"), rMan.getString("badSign.changeToNeutralTitle"), 0)) == 0) {
            lc.sign = 0;
        }
    }

    private boolean addToLinkTree(Layout layout, String linkID, Genome genome, LinkCandidate lc, FontRenderContext frc) {
        String src = lc.source.getObjectID();
        BusProperties lp = layout.getLinkProperties(src);
        LinkSegmentID[] segIDs = lc.source.segmentIDsFromIntersect();
        UndoSupport support = new UndoSupport(this.undom_, "undo.addLink");
        Linkage existing = genome.getLinkage(src);
        int srcPad = existing.getLaunchPad();
        String srcNode = existing.getSource();
        String targ = lc.target.getObjectID();
        int trgPad = ((Intersection.PadVal)lc.target.getSubID()).padNum;
        this.switchLinkSign(genome, targ, lc);
        DBLinkage newLinkage = new DBLinkage(lc.label, linkID, srcNode, targ, lc.sign, trgPad, srcPad);
        GenomeChange gc = ((DBGenome)genome).addLinkWithExistingLabel(newLinkage);
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        BusProperties nlp = this.convertCandidateToBusForMerge(genome, layout, lc, linkID);
        Layout.PropChange lpc = layout.mergeNewLinkToTreeAtSegment(frc, src, nlp, segIDs[0]);
        PropChangeCmd pcc = new PropChangeCmd(new Layout.PropChange[]{lpc});
        support.addEdit(pcc);
        support.addEvent(new ModelChangeEvent(genome.getID(), 1));
        support.finish();
        return true;
    }

    private BusProperties convertCandidateToBus(Genome genome, Layout layout, LinkCandidate lc, String linkID, String src) {
        Point2D.Double textLoc = new Point2D.Double();
        List segments = this.convertCandidateListToSegments(lc.points, textLoc, false);
        String colorTag = this.chooseNodeColor(genome, layout, src);
        BusProperties lp = new BusProperties(genome, linkID, (float)((Point2D)textLoc).getX(), (float)((Point2D)textLoc).getY(), colorTag);
        Iterator sit = segments.iterator();
        while (sit.hasNext()) {
            LinkSegment ls = (LinkSegment)sit.next();
            lp.addSegmentInSeries(ls);
        }
        return lp;
    }

    private List convertCandidateListToSegments(List points, Point2D textLoc, boolean haveTargetIntersection) {
        int numToDitch = haveTargetIntersection ? 2 : 1;
        int numSeg = points.size() - numToDitch;
        ArrayList<LinkSegment> segments = new ArrayList<LinkSegment>();
        float tx = 0.0f;
        float ty = 0.0f;
        if (numSeg == 0) {
            Point pt = (Point)points.get(0);
            tx = pt.x;
            ty = pt.y;
        } else if (numSeg == 1) {
            Point pt = (Point)points.get(1);
            Point2D.Float newPt = new Point2D.Float(pt.x, pt.y);
            LinkSegment ls = new LinkSegment(null, null, newPt, null);
            segments.add(ls);
            tx = pt.x;
            ty = pt.y;
        } else {
            Point2D.Float lastPt = null;
            Iterator pit = points.iterator();
            int halfSeg = numSeg / 2;
            int segCount = 0;
            pit.next();
            while (pit.hasNext()) {
                Point pt = (Point)pit.next();
                if (haveTargetIntersection && !pit.hasNext()) break;
                Point2D.Float newPt = new Point2D.Float(pt.x, pt.y);
                if (lastPt != null) {
                    LinkSegment ls = new LinkSegment(null, null, lastPt, newPt);
                    segments.add(ls);
                }
                lastPt = newPt;
                if (segCount == halfSeg) {
                    tx = pt.x;
                    ty = pt.y;
                }
                ++segCount;
            }
        }
        if (textLoc != null) {
            textLoc.setLocation(tx, ty);
        }
        return segments;
    }

    private BusProperties convertCandidateToBusForMerge(Genome genome, Layout layout, LinkCandidate lc, String linkID) {
        LinkSegment ls;
        int numSeg = lc.points.size() - 1;
        ArrayList<LinkSegment> segments = new ArrayList<LinkSegment>();
        float tx = 0.0f;
        float ty = 0.0f;
        if (numSeg == 0) {
            Point pt = (Point)lc.points.get(0);
            Point2D.Float newPt = new Point2D.Float(pt.x, pt.y);
            ls = new LinkSegment(null, null, newPt, null);
            segments.add(ls);
            tx = pt.x;
            ty = pt.y;
        } else {
            Point2D.Float lastPt = null;
            Iterator pit = lc.points.iterator();
            int halfSeg = numSeg / 2;
            int segCount = 0;
            while (pit.hasNext()) {
                Point pt = (Point)pit.next();
                Point2D.Float newPt = new Point2D.Float(pt.x, pt.y);
                if (lastPt != null) {
                    LinkSegment ls2 = new LinkSegment(null, null, lastPt, newPt);
                    segments.add(ls2);
                }
                lastPt = newPt;
                if (segCount == halfSeg) {
                    tx = pt.x;
                    ty = pt.y;
                }
                ++segCount;
            }
        }
        BusProperties nlp = new BusProperties(genome, linkID, tx, ty, "black");
        Iterator sit = segments.iterator();
        while (sit.hasNext()) {
            ls = (LinkSegment)sit.next();
            nlp.addSegmentInSeries(ls);
        }
        return nlp;
    }

    private boolean addNewLinkToInstanceFinish(GenomeInstance tgi, Layout layout, LinkCandidate lc, FontRenderContext frc) {
        InstanceAndCeiling iAndC;
        Map instanceOptions;
        Set rootOptions;
        ArrayList<GenomeInstance> ancestry = new ArrayList<GenomeInstance>();
        ancestry.add(tgi);
        for (GenomeInstance parent = tgi.getVfgParent(); parent != null; parent = parent.getVfgParent()) {
            ancestry.add(parent);
        }
        int aNum = ancestry.size();
        Genome rootGenome = Database.getDB().getGenome();
        if (lc != null) {
            if (this.existingLinkID_ == null) {
                rootOptions = this.newLinkInstanceHasParent(rootGenome, lc, tgi);
                instanceOptions = this.findInstanceMatches(lc, ancestry);
                iAndC = null;
            } else {
                rootOptions = null;
                instanceOptions = null;
                iAndC = null;
            }
        } else {
            rootOptions = null;
            instanceOptions = null;
            iAndC = this.findInstanceMatch(this.existingLinkID_, ancestry);
        }
        if (rootOptions != null || instanceOptions != null) {
            Set rootOptionSet = rootOptions == null ? new HashSet() : rootOptions;
            Set<Object> instanceOptionSet = instanceOptions == null ? new HashSet() : instanceOptions.keySet();
            DrawLinkInstanceExistingOptionsDialog eod = new DrawLinkInstanceExistingOptionsDialog(this.topWindow_, rootGenome, tgi, rootOptionSet, instanceOptionSet, frc);
            eod.show();
            if (!eod.haveResult()) {
                return false;
            }
            if (!eod.doDraw()) {
                String linkID = eod.getID();
                if (!GenomeItemInstance.isBaseID(linkID)) {
                    iAndC = (InstanceAndCeiling)instanceOptions.get(linkID);
                } else {
                    this.existingLinkID_ = linkID;
                }
                if (this.existingLinkID_ != null && instanceOptions != null) {
                    Iterator iit = instanceOptions.keySet().iterator();
                    while (iit.hasNext()) {
                        String intLinkID = (String)iit.next();
                        if (!GenomeItemInstance.getBaseID(intLinkID).equals(this.existingLinkID_)) continue;
                        iAndC = (InstanceAndCeiling)instanceOptions.get(intLinkID);
                        break;
                    }
                }
            }
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.addLink");
        Collections.reverse(ancestry);
        if (iAndC == null) {
            GenomeInstance gi = (GenomeInstance)ancestry.get(0);
            String linkInstanceToUse = this.addNewLinkToRootInstanceFinish(gi, layout, lc, frc, support).getID();
            iAndC = new InstanceAndCeiling(linkInstanceToUse, 0);
        }
        GenomeItemInstance pInst = null;
        for (int i = iAndC.propCeiling; i < aNum; ++i) {
            LinkageInstance checkpI;
            GenomeInstance gi = (GenomeInstance)ancestry.get(i);
            pInst = i == iAndC.propCeiling ? (LinkageInstance)gi.getLinkage(iAndC.instanceToUse) : ((checkpI = (LinkageInstance)gi.getLinkage(pInst.getID())) == null ? this.addNewLinkToSubsetInstance(gi.getID(), (LinkageInstance)pInst, support) : checkpI);
            if (lc.builtID != null) continue;
            lc.builtID = pInst.getID();
        }
        support.finish();
        return true;
    }

    private Map findInstanceMatches(LinkCandidate lc, List ancestry) {
        HashMap<String, InstanceAndCeiling> retval = new HashMap<String, InstanceAndCeiling>();
        Set kidInstances = null;
        int aNum = ancestry.size();
        for (int i = 0; i < aNum; ++i) {
            GenomeInstance gi = (GenomeInstance)ancestry.get(i);
            Set existingInstances = this.newLinkInstanceExists(lc, gi);
            if (kidInstances != null) {
                HashSet available = new HashSet(existingInstances);
                available.removeAll(kidInstances);
                Iterator ait = available.iterator();
                while (ait.hasNext()) {
                    String linkID = (String)ait.next();
                    InstanceAndCeiling iAndC = new InstanceAndCeiling(linkID, aNum - i - 1);
                    retval.put(linkID, iAndC);
                }
            }
            kidInstances = existingInstances;
        }
        return retval.isEmpty() ? null : retval;
    }

    private InstanceAndCeiling findInstanceMatch(String linkID, List ancestry) {
        int aNum = ancestry.size();
        for (int i = 0; i < aNum; ++i) {
            GenomeInstance gi = (GenomeInstance)ancestry.get(i);
            if (gi.getLinkage(linkID) == null) continue;
            InstanceAndCeiling iAndC = new InstanceAndCeiling(linkID, aNum - i - 1);
            return iAndC;
        }
        throw new IllegalArgumentException();
    }

    private LinkageInstance addNewLinkToRootInstanceFinish(GenomeInstance gi, Layout layout, LinkCandidate lc, FontRenderContext frc, UndoSupport support) {
        DBLinkage rootLink;
        Database db = Database.getDB();
        Genome rootGenome = db.getGenome();
        if (gi.getVfgParent() != null) {
            throw new IllegalArgumentException();
        }
        String src = lc.srcID;
        String targ = lc.target.getObjectID();
        boolean newInRoot = false;
        Layout rootLo = null;
        if (this.existingLinkID_ == null) {
            String rootSrc = GenomeItemInstance.getBaseID(src);
            String rootTarg = GenomeItemInstance.getBaseID(targ);
            OldPadMapper oldPads = null;
            PadCalculatorToo padCalc = new PadCalculatorToo();
            PadConstraints pc = padCalc.generatePadConstraints(rootSrc, rootTarg, oldPads, null, new HashMap());
            String rootName = lc.label != null && !lc.label.trim().equals("") ? lc.label : null;
            rootLink = (DBLinkage)this.autoAddOldOrNewLinkToRoot(rootName, rootSrc, rootTarg, lc.sign, null, support, true, null, pc, false, 0);
            this.existingLinkID_ = rootLink.getID();
            rootLo = db.getLayout(new LayoutManager().getLayout(rootGenome.getID()));
            AddCommands.autoAddCrudeLinkProperties(rootGenome, rootLo, this.existingLinkID_, support, null, frc);
            newInRoot = true;
            support.addEvent(new ModelChangeEvent(rootGenome.getID(), 1));
        } else {
            rootLink = (DBLinkage)rootGenome.getLinkage(this.existingLinkID_);
        }
        boolean startFromNode = lc.srcID.equals(lc.source.getObjectID());
        Linkage chkLink = !startFromNode ? gi.getLinkage(lc.source.getObjectID()) : null;
        int srcPad = startFromNode ? ((Intersection.PadVal)lc.source.getSubID()).padNum : chkLink.getLaunchPad();
        int trgPad = ((Intersection.PadVal)lc.target.getSubID()).padNum;
        int srcInstance = GenomeItemInstance.getInstanceID(src);
        int trgInstance = GenomeItemInstance.getInstanceID(targ);
        int instanceCount = gi.getNextLinkInstanceNumber(this.existingLinkID_);
        LinkageInstance newLink = new LinkageInstance(rootLink, instanceCount, srcInstance, trgInstance);
        lc.builtID = newLink.getID();
        newLink.setLaunchPad(srcPad);
        newLink.setLandingPad(trgPad);
        String newLinkID = newLink.getID();
        GenomeChange gc = gi.addLinkage(newLink);
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        if (!startFromNode) {
            BusProperties lp = layout.getLinkProperties(chkLink.getID());
            LinkSegmentID[] segIDs = lc.source.segmentIDsFromIntersect();
            BusProperties nlp = this.convertCandidateToBusForMerge(gi, layout, lc, newLinkID);
            Layout.PropChange lpc = layout.mergeNewLinkToTreeAtSegment(frc, chkLink.getID(), nlp, segIDs[0]);
            PropChangeCmd pcc = new PropChangeCmd(new Layout.PropChange[]{lpc});
            support.addEdit(pcc);
        } else {
            BusProperties bp = this.convertCandidateToBus(gi, layout, lc, newLinkID, src);
            if (newInRoot) {
                this.changeRootColor(bp, rootGenome, rootLo, newLinkID, support);
            }
            this.propagateLinkProperties(db, gi, bp, newLinkID, support);
        }
        support.addEvent(new ModelChangeEvent(gi.getID(), 1));
        return newLink;
    }

    public void changeRootColor(BusProperties bp, Genome rootGenome, Layout rootLo, String linkID, UndoSupport support) {
        String rootLinkID = GenomeItemInstance.getBaseID(linkID);
        BusProperties rootProps = rootLo.getLinkProperties(rootLinkID);
        String colorKey = bp.getColorName();
        if (!colorKey.equals(rootProps.getColorName())) {
            BusProperties changedProps = (BusProperties)rootProps.clone();
            changedProps.setColor(colorKey);
            Layout.PropChange[] lpc = new Layout.PropChange[]{rootLo.replaceLinkProperties(rootProps, changedProps)};
            if (lpc[0] != null) {
                PropChangeCmd mov = new PropChangeCmd(lpc);
                support.addEdit(mov);
                LayoutChangeEvent ev = new LayoutChangeEvent(rootLo.getName(), 1);
                support.addEvent(ev);
                this.changeNodeColor(rootGenome, rootLo, changedProps, rootLinkID, support);
            }
        }
    }

    public Linkage autoAddLinkToRoot(String srcID, String targID, int sign, UndoSupport support, boolean allowDuplicates, String oldID, PadConstraints padLimits, int evidenceLevel) {
        GenomeChange gc;
        Database db = Database.getDB();
        DBGenome genome = (DBGenome)db.getGenome();
        if (!allowDuplicates) {
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                DBLinkage link = (DBLinkage)lit.next();
                String src = link.getSource();
                String trg = link.getTarget();
                int testSign = link.getSign();
                if (!src.equals(srcID) || !trg.equals(targID) || testSign != sign) continue;
                return null;
            }
        }
        PadCalculatorToo pcalc = new PadCalculatorToo();
        PadCalculatorToo.PadResult pads = pcalc.padCalc(srcID, targID, padLimits, true);
        String linkID = oldID == null ? genome.getNextKey() : oldID;
        DBLinkage newLinkage = new DBLinkage(null, linkID, srcID, targID, sign, pads.landing, pads.launch);
        if (evidenceLevel != 0) {
            newLinkage.setTargetLevel(evidenceLevel);
        }
        if ((gc = genome.addLinkWithExistingLabel(newLinkage)) != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        return newLinkage;
    }

    public Linkage autoAddOldOrNewLinkToRoot(String srcID, String targID, int sign, DBGenome oldGenome, UndoSupport support, boolean allowDuplicates, String oldID, PadConstraints padLimits, int evidenceLevel) {
        return this.autoAddOldOrNewLinkToRoot(null, srcID, targID, sign, oldGenome, support, allowDuplicates, oldID, padLimits, true, evidenceLevel);
    }

    private Linkage autoAddOldOrNewLinkToRoot(String newName, String srcID, String targID, int sign, DBGenome oldGenome, UndoSupport support, boolean allowDuplicates, String oldID, PadConstraints padLimits, boolean nodesCanGrow, int evidenceLevel) {
        GenomeChange gc;
        DBLinkage newLinkage;
        String linkID;
        Database db = Database.getDB();
        DBGenome genome = (DBGenome)db.getGenome();
        if (!allowDuplicates) {
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                DBLinkage link = (DBLinkage)lit.next();
                String src = link.getSource();
                String trg = link.getTarget();
                int testSign = link.getSign();
                if (!src.equals(srcID) || !trg.equals(targID) || testSign != sign) continue;
                return null;
            }
        }
        Linkage oldLink = null;
        if (oldID != null) {
            oldLink = oldGenome.getLinkage(oldID);
        }
        PadCalculatorToo pcalc = new PadCalculatorToo();
        PadCalculatorToo.PadResult pads = pcalc.padCalc(srcID, targID, padLimits, nodesCanGrow);
        String string = linkID = oldID == null ? genome.getNextKey() : oldID;
        if (oldLink == null) {
            newLinkage = new DBLinkage(newName, linkID, srcID, targID, sign, pads.landing, pads.launch);
            if (evidenceLevel != 0) {
                newLinkage.setTargetLevel(evidenceLevel);
            }
        } else {
            if (newName != null) {
                throw new IllegalArgumentException();
            }
            newLinkage = new DBLinkage((DBLinkage)oldLink);
            if (evidenceLevel != 0) {
                newLinkage.setTargetLevel(evidenceLevel);
            }
        }
        if ((gc = genome.addLinkWithExistingLabel(newLinkage)) != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        return newLinkage;
    }

    public static boolean autoAddCrudeLinkProperties(Genome genome, Layout lo, String linkID, UndoSupport support, Map rememberProps, FontRenderContext frc) {
        BusProperties lp = null;
        Iterator lit = genome.getLinkageIterator();
        Linkage thisLink = genome.getLinkage(linkID);
        String srcID = thisLink.getSource();
        String trgID = thisLink.getTarget();
        String existingID = null;
        while (lit.hasNext()) {
            BusProperties testProp;
            Linkage link = (Linkage)lit.next();
            String src = link.getSource();
            if (!src.equals(srcID) || (testProp = lo.getLinkProperties(link.getID())) == null) continue;
            lp = testProp;
            existingID = link.getID();
        }
        BusProperties.RememberProps rp = rememberProps == null ? null : (BusProperties.RememberProps)rememberProps.get(linkID);
        float tx = 0.0f;
        float ty = 0.0f;
        if (lp == null) {
            HashSet<Point2D> points = new HashSet<Point2D>();
            points.add(lo.getNodeProperties(srcID).getLocation());
            points.add(lo.getNodeProperties(trgID).getLocation());
            Point2D labelLoc = AffineCombination.combination(points, 10.0);
            tx = labelLoc == null ? 0.0f : (float)labelLoc.getX();
            ty = labelLoc == null ? 0.0f : (float)labelLoc.getY();
        }
        BusProperties nlp = new BusProperties(genome, linkID, tx, ty, "black");
        if (rp != null) {
            rp.restore(nlp, lo, genome, frc);
        }
        Layout.PropChange lpc = null;
        lpc = lp == null ? lo.setLinkPropertiesForUndo(linkID, nlp, null) : lo.mergeNewLinkToTreeAtSegment(frc, existingID, nlp, null);
        if (support != null) {
            support.addEdit(new PropChangeCmd(new Layout.PropChange[]{lpc}));
        }
        return true;
    }

    public void junkLayout(DBGenome genome, Layout lo, UndoSupport support, FontRenderContext frc) {
        Database db = Database.getDB();
        String loKey = lo.getName();
        Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)allKeys.get(loKey);
        DatabaseChange dc = support != null ? db.startLayoutUndoTransaction(loKey) : null;
        Layout.SupplementalDataCoords sdc = lo.getSupplementalCoords(genome, frc, loModKeys);
        lo.dropProperties(genome, frc);
        DatabaseChange databaseChange = dc = support != null ? db.finishLayoutUndoTransaction(dc) : null;
        if (dc != null) {
            support.addEdit(new DatabaseChangeCmd(dc));
        }
        int numNodes = genome.getFullNodeCount();
        int cols = (int)Math.ceil(Math.sqrt(numNodes));
        Iterator anit = genome.getAllNodeIterator();
        int rowCount = 0;
        int colCount = 0;
        while (anit.hasNext()) {
            int nodeType;
            NodeProperties np;
            Node node = (Node)anit.next();
            Point2D.Double loc = new Point2D.Double((double)colCount++ * 200.0, (double)rowCount * 200.0);
            if (colCount > cols) {
                colCount = 0;
                ++rowCount;
            }
            UiUtil.forceToGrid(loc, 10.0);
            String nodeID = node.getID();
            Layout.PropChange[] lpc = new Layout.PropChange[]{lo.setNodeProperties(nodeID, np = new NodeProperties(lo, nodeType = node.getNodeType(), nodeID, ((Point2D)loc).getX(), ((Point2D)loc).getY(), false))};
            if (lpc == null || support == null) continue;
            PropChangeCmd pcc = new PropChangeCmd(lpc);
            support.addEdit(pcc);
        }
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            AddCommands.autoAddCrudeLinkProperties(genome, lo, linkID, support, null, frc);
        }
        dc = support != null ? db.startLayoutUndoTransaction(loKey) : null;
        lo.applySupplementalDataCoords(sdc, genome, frc, loModKeys);
        DatabaseChange databaseChange2 = dc = support != null ? db.finishLayoutUndoTransaction(dc) : null;
        if (dc != null) {
            support.addEdit(new DatabaseChangeCmd(dc));
        }
    }

    public LinkRouter.RoutingResult autoLayoutHierarchical(Point2D center, Map newNodeTypes, Set newLinks, Dimension size, DBGenome genome, UndoSupport support, FontRenderContext frc, List motifs, boolean incremental, Map colorMap, Map padConstraints, LayoutOptions options, BTProgressMonitor monitor, double startFrac, double endFrac, Layout.SupplementalDataCoords sdc, Map rememberLinkProps) throws AsynchExitRequestException {
        boolean strictOKGroups = false;
        Set newNodes = newNodeTypes.keySet();
        Database db = Database.getDB();
        RectangularTreeEngine ce = new RectangularTreeEngine();
        String genomeKey = genome.getID();
        Layout lo = db.getLayout(new LayoutManager().getLayout(genomeKey));
        int count = genome.getFullNodeCount();
        if (newNodes.size() == count) {
            incremental = false;
        }
        Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)allKeys.get(lo.getName());
        Grid grid = ce.layoutMotifsHier(motifs, newNodes, genomeKey, options, incremental, null, false);
        int colNum = grid.getNumCols();
        if (colNum == 0) {
            return new LinkRouter.RoutingResult();
        }
        int rowNum = grid.getNumRows();
        LinkRouter router = new LinkRouter();
        Point2D corner = null;
        if (incremental && !newNodes.isEmpty()) {
            int pad;
            LinkPlacementGrid oldLinkGrid = router.initGrid(genome, lo, frc, null, 1, monitor);
            PatternGrid oldGrid = oldLinkGrid.extractPatternGrid(false);
            MinMax xRange = oldGrid.getMinMaxXForRange(null);
            double leftie = this.calcIncrementalGridSpacing(genome, newNodes, grid, lo, xRange.min * 10, options);
            Pattern pat = grid.buildPattern();
            PatternPlacerVerticalNesting ppt = new PatternPlacerVerticalNesting(oldGrid, pat, (int)leftie / 10, pad = (int)Math.round(grid.getRowSpace() / 20.0), true);
            Point topCorner = ppt.locatePattern();
            if (topCorner == null) {
                corner = this.findBestVerticalPosition(genome, grid, lo, newNodeTypes, leftie);
            } else {
                Point topCorner10 = new Point(topCorner.x * 10, topCorner.y * 10);
                PatternPlacerVerticalNesting ppb = new PatternPlacerVerticalNesting(oldGrid, pat, (int)leftie / 10, pad, false);
                Point botCorner = ppb.locatePattern();
                Point botCorner10 = new Point(botCorner.x * 10, botCorner.y * 10);
                boolean useTop = this.topIsBest(genome, lo, newNodes, grid, topCorner10, botCorner10);
                if (useTop) {
                    corner = new Point2D.Double(topCorner10.x, topCorner10.y);
                    ppt.sinkPattern(topCorner);
                } else {
                    corner = new Point2D.Double(botCorner10.x, botCorner10.y);
                    ppb.sinkPattern(botCorner);
                }
            }
        }
        if (!incremental || corner != null) {
            for (int i = 0; i < rowNum; ++i) {
                for (int j = 0; j < colNum; ++j) {
                    String geneID = grid.getCellValue(i, j);
                    if (geneID == null) continue;
                    int nodeType = (Integer)newNodeTypes.get(geneID);
                    Point2D loc = incremental ? grid.getGridLocation(i, j, corner) : ce.placePoint(i * colNum + j, grid, center, size);
                    NodeProperties np = new NodeProperties(lo, nodeType, geneID, 0.0, 0.0, false);
                    double yOffset = np.getRenderer().getStraightThroughOffset();
                    double xOffset = np.getRenderer().getVerticalOffset();
                    np.setLocation(new Point2D.Double(loc.getX() + xOffset, loc.getY() + yOffset));
                    Layout.PropChange[] lpc = new Layout.PropChange[]{lo.setNodeProperties(geneID, new NodeProperties(np, lo, nodeType))};
                    if (lpc == null) continue;
                    PropChangeCmd pcc = new PropChangeCmd(lpc);
                    support.addEdit(pcc);
                    LayoutChangeEvent lcev = new LayoutChangeEvent(lo.getName(), 1);
                    support.addEvent(lcev);
                }
            }
        }
        Layout tempLayout = new Layout(lo);
        this.gridlessLinkLayoutPrep(genome, tempLayout, frc, newLinks, rememberLinkProps);
        this.wigglePads(tempLayout, genome, padConstraints, support);
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.2;
        double eFrac1 = startFrac + frac1;
        double frac2 = fullFrac * 0.3;
        double eFrac2 = eFrac1 + frac2;
        double frac3 = fullFrac * 0.1;
        double eFrac3 = eFrac2 + frac3;
        double frac4 = fullFrac * 0.4;
        double eFrac4 = eFrac3 + frac4;
        DatabaseChange dc = db.startLayoutUndoTransaction(lo.getName());
        try {
            HashSet needColors = new HashSet();
            LinkRouter.RoutingResult retval = router.multiPassLayout(genome, newLinks, tempLayout, frc, options, monitor, needColors, startFrac, eFrac1, null, false);
            if ((retval.linkResult & 2) == 0 || incremental) {
                lo.replaceContents(tempLayout);
            } else {
                Set targCollide = genome.hasLinkTargetPadCollisions();
                if (!targCollide.isEmpty()) {
                    lo.replaceContents(tempLayout);
                } else {
                    boolean success = false;
                    Layout baseLayout = tempLayout;
                    int maxPasses = 2;
                    double fracInc = frac2 / (double)maxPasses;
                    double halfFi = fracInc / 2.0;
                    double cFrac = eFrac1;
                    for (int mult = 1; mult <= maxPasses; ++mult) {
                        Layout etempLayout = new Layout(baseLayout);
                        TreeSet insertRows = new TreeSet();
                        TreeSet insertCols = new TreeSet();
                        etempLayout.chooseExpansionRows(genome, frc, 1.0, 1.0, null, loModKeys, insertRows, insertCols, false, monitor);
                        etempLayout.expand(genome, insertRows, insertCols, mult, false, frc, null, null, null, monitor, cFrac, cFrac + halfFi);
                        LinkRouter.RoutingResult eres = AddCommands.relayoutLinks(genome, null, etempLayout, frc, options, false, null, monitor, cFrac += halfFi, cFrac + halfFi, strictOKGroups);
                        cFrac += halfFi;
                        if ((eres.linkResult & 2) == 0) {
                            lo.replaceContents(etempLayout);
                            retval = eres;
                            success = true;
                            break;
                        }
                        baseLayout = etempLayout;
                    }
                    if (!success) {
                        lo.replaceContents(tempLayout);
                    }
                }
            }
            LinkPlacementGrid routerGrid = router.initGrid(genome, lo, frc, null, 1, monitor);
            lo.dropUselessCorners(genome, frc, null, null, eFrac2, eFrac3, monitor);
            lo.optimizeLinks(newLinks, routerGrid, genome, frc, null, null, new HashSet(), true, monitor, options.optimizationPasses, eFrac3, eFrac4);
            ColorAssigner ca = new ColorAssigner();
            ColorAssigner.ColorIssues issues = ca.assignColors(genome, lo, routerGrid, colorMap, false, incremental, needColors);
            if (issues.status != 0) {
                retval.linkResult |= 1;
                retval.colorResult = issues.status;
                retval.collisionSrc1 = issues.collisionSrc1 == null ? retval.collisionSrc1 : issues.collisionSrc1;
                retval.collisionSrc2 = issues.collisionSrc2 == null ? retval.collisionSrc2 : issues.collisionSrc2;
            }
            lo.applySupplementalDataCoords(sdc, genome, frc, loModKeys);
            dc = db.finishLayoutUndoTransaction(dc);
            support.addEdit(new DatabaseChangeCmd(dc));
            return retval;
        }
        catch (AsynchExitRequestException ex) {
            db.rollbackLayoutUndoTransaction(dc);
            throw ex;
        }
    }

    public void gridlessLinkLayoutPrep(Genome genome, Layout tempLayout, FontRenderContext frc, Set toDo, Map rememberProps) {
        Iterator xrit = toDo.iterator();
        while (xrit.hasNext()) {
            String linkID = (String)xrit.next();
            AddCommands.autoAddCrudeLinkProperties(genome, tempLayout, linkID, null, rememberProps, frc);
        }
    }

    public LinkRouter.RoutingResult relayoutLinksGlobally(List requests, UndoSupport support, FontRenderContext frc, LayoutOptions options, BTProgressMonitor monitor, double startFrac, double maxFrac) throws AsynchExitRequestException {
        LinkRouter.RoutingResult retval = new LinkRouter.RoutingResult();
        int numReq = requests.size();
        double currProg = startFrac;
        double perReqFrac = numReq == 0 ? 0.0 : (maxFrac - startFrac) / (double)numReq;
        boolean strictOKGroups = false;
        for (int i = 0; i < numReq; ++i) {
            GlobalLinkRequest glr = (GlobalLinkRequest)requests.get(i);
            Genome genome = glr.genome;
            Layout lo = glr.layout;
            Set badLinks = glr.badLinks;
            LinkRouter.RoutingResult oneRes = AddCommands.relayoutLinks(genome, support, lo, frc, options, false, badLinks, monitor, currProg, currProg + perReqFrac, strictOKGroups);
            retval.merge(oneRes);
            if (monitor == null || monitor.updateProgress((int)((currProg += perReqFrac) * 100.0))) continue;
            throw new AsynchExitRequestException();
        }
        return retval;
    }

    public static LinkRouter.RoutingResult relayoutLinks(Genome genome, UndoSupport support, Layout lo, FontRenderContext frc, LayoutOptions options, boolean doFull, Set badLinks, BTProgressMonitor monitor, double startFrac, double endFrac, boolean strictOKGroups) throws AsynchExitRequestException {
        Database db = Database.getDB();
        int linkCount = 0;
        HashMap<String, String> colorMap = new HashMap<String, String>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            BusProperties lp = lo.getLinkProperties(link.getID());
            String oldColor = lp.getColorName();
            colorMap.put(link.getID(), oldColor);
            ++linkCount;
        }
        LinkRouter router = new LinkRouter();
        HashSet<String> newLinks = null;
        if (!doFull) {
            Set badRuns = null;
            if (badLinks == null) {
                LinkPlacementGrid oldRouterGrid = router.initGrid(genome, lo, frc, null, 1, monitor);
                newLinks = lo.discoverNonOrthoLinks(genome, frc);
                badRuns = oldRouterGrid.findBadRuns();
            } else {
                newLinks = badLinks;
            }
            if (badRuns != null) {
                Iterator brlit = genome.getLinkageIterator();
                while (brlit.hasNext()) {
                    Linkage link = (Linkage)brlit.next();
                    if (!badRuns.contains(link.getSource())) continue;
                    newLinks.add(link.getID());
                }
            }
        }
        DatabaseChange dc = null;
        if (support != null) {
            dc = db.startLayoutUndoTransaction(lo.getName());
        }
        try {
            Iterator nlit;
            Map specials = lo.rememberSpecialLinks(genome);
            Map rememberProps = null;
            if (badLinks == null) {
                rememberProps = lo.dropSelectedLinkProperties(newLinks, genome, frc);
            } else {
                rememberProps = new HashMap();
                nlit = newLinks.iterator();
                while (nlit.hasNext()) {
                    String lid = (String)nlit.next();
                    lo.removeLinkPropertiesAndRemember(lid, rememberProps, genome, frc);
                }
            }
            if (doFull) {
                newLinks = new HashSet<String>();
                lit = genome.getLinkageIterator();
                while (lit.hasNext()) {
                    Linkage link = (Linkage)lit.next();
                    newLinks.add(link.getID());
                }
            }
            nlit = newLinks.iterator();
            while (nlit.hasNext()) {
                String linkID = (String)nlit.next();
                AddCommands.autoAddCrudeLinkProperties(genome, lo, linkID, null, rememberProps, frc);
            }
            double fullFrac = endFrac - startFrac;
            double frac1 = fullFrac * 0.6;
            double eFrac1 = startFrac + frac1;
            double frac2 = fullFrac * 0.4;
            double eFrac2 = eFrac1 + frac2;
            HashSet needColors = new HashSet();
            LinkRouter.RoutingResult retval = router.multiPassLayout(genome, newLinks, lo, frc, options, monitor, needColors, startFrac, eFrac1, null, strictOKGroups);
            LinkPlacementGrid routerGrid = router.initGrid(genome, lo, frc, retval.failedLinks, 1, monitor);
            lo.optimizeLinks(newLinks, routerGrid, genome, frc, null, null, new HashSet(), true, monitor, options.optimizationPasses, eFrac1, eFrac2);
            ColorAssigner ca = new ColorAssigner();
            ColorAssigner.ColorIssues issues = ca.assignColors(genome, lo, routerGrid, colorMap, true, true, needColors);
            if (issues.status != 0) {
                retval.linkResult |= 1;
                retval.colorResult = issues.status;
                retval.collisionSrc1 = issues.collisionSrc1 == null ? retval.collisionSrc1 : issues.collisionSrc1;
                retval.collisionSrc2 = issues.collisionSrc2 == null ? retval.collisionSrc2 : issues.collisionSrc2;
            }
            lo.restoreSpecialLinks(specials, genome);
            if (monitor != null && !monitor.updateProgress((int)(endFrac * 100.0))) {
                throw new AsynchExitRequestException();
            }
            if (support != null) {
                dc = db.finishLayoutUndoTransaction(dc);
                support.addEdit(new DatabaseChangeCmd(dc));
            }
            return retval;
        }
        catch (AsynchExitRequestException ex) {
            if (support != null) {
                db.rollbackLayoutUndoTransaction(dc);
            }
            throw ex;
        }
    }

    public LinkRouter.RoutingResult reassignColors(Genome genome, UndoSupport support, Layout lo, FontRenderContext frc) {
        LinkPlacementGrid routerGrid;
        Database db = Database.getDB();
        HashSet<String> seenSrcs = new HashSet<String>();
        HashSet<String> needColors = new HashSet<String>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            BusProperties lp = lo.getLinkProperties(link.getID());
            String src = link.getSource();
            if (seenSrcs.contains(src)) continue;
            seenSrcs.add(src);
            needColors.add(link.getID());
        }
        LinkRouter.RoutingResult retval = new LinkRouter.RoutingResult();
        if (needColors.isEmpty()) {
            return retval;
        }
        DatabaseChange dc = support != null ? db.startLayoutUndoTransaction(lo.getName()) : null;
        LinkRouter router = new LinkRouter();
        try {
            routerGrid = router.initGrid(genome, lo, frc, null, 1, null);
        }
        catch (AsynchExitRequestException ex) {
            throw new IllegalStateException();
        }
        ColorAssigner ca = new ColorAssigner();
        ColorAssigner.ColorIssues issues = ca.hasAmbiguousCrossing(genome, lo, routerGrid);
        if (issues == null) {
            return retval;
        }
        issues = ca.assignColors(genome, lo, routerGrid, null, false, false, needColors);
        if (issues.status != 0) {
            retval.linkResult |= 1;
            retval.colorResult = issues.status;
            retval.collisionSrc1 = issues.collisionSrc1 == null ? retval.collisionSrc1 : issues.collisionSrc1;
            String string = retval.collisionSrc2 = issues.collisionSrc2 == null ? retval.collisionSrc2 : issues.collisionSrc2;
        }
        if (support != null) {
            dc = db.finishLayoutUndoTransaction(dc);
            support.addEdit(new DatabaseChangeCmd(dc));
            support.finish();
        }
        return retval;
    }

    public LinkRouter.RoutingResult runSpecialtyLinkPlacement(SpecialtyLayoutEngine sle, UndoSupport support, BTProgressMonitor monitor, double startFrac, double maxFrac) throws AsynchExitRequestException {
        Database db = Database.getDB();
        Vector2D shiftedAmount = sle.getShiftedAmount();
        shiftedAmount.setXY(0.0, 0.0);
        List subsetList = sle.getSortedGenomeSubsets();
        int numSub = subsetList.size();
        if (numSub == 0) {
            return new LinkRouter.RoutingResult();
        }
        GenomeSubset firstSub = (GenomeSubset)subsetList.get(0);
        Genome baseGenome = firstSub.getBaseGenome();
        List propsList = sle.getInstructions();
        boolean isCompleteGenome = numSub == 1 && firstSub.isCompleteGenome();
        String overlayKey = firstSub.getOverlayID();
        boolean allAssign = false;
        HashMap allNodeColors = new HashMap();
        HashMap allLinkColors = new HashMap();
        if (isCompleteGenome) {
            SpecialtyInstructions props = (SpecialtyInstructions)propsList.get(0);
            allAssign = props.assignColorsAfterLayout;
            allNodeColors.putAll(props.nodeColors);
            allLinkColors.putAll(props.linkColors);
        } else {
            allAssign = false;
            for (int i = 0; i < numSub; ++i) {
                SpecialtyInstructions props = (SpecialtyInstructions)propsList.get(i);
                allNodeColors.putAll(props.nodeColors);
                allLinkColors.putAll(props.linkColors);
            }
        }
        int linkCount = 0;
        HashMap<String, String> colorMap = new HashMap<String, String>();
        Layout lo = sle.getLayout();
        Layout modifiedLayout = sle.getWorkingLayout();
        Iterator lit = baseGenome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            BusProperties lp = modifiedLayout.getLinkProperties(link.getID());
            String oldColor = lp.getColorName();
            colorMap.put(link.getID(), oldColor);
            ++linkCount;
        }
        FontRenderContext frc = sle.getFontRenderContext();
        LinkRouter router = new LinkRouter();
        DatabaseChange dc = support != null ? db.startLayoutUndoTransaction(lo.getName()) : null;
        try {
            lo.replaceContents(modifiedLayout);
            double currStart = startFrac;
            ArrayList forRecoveriesOut = new ArrayList();
            HashMap alienSources = new HashMap();
            HashMap srcToBetween = new HashMap();
            HashSet newLinks = new HashSet();
            Map specials = lo.rememberSpecialLinks(baseGenome);
            if (isCompleteGenome) {
                newLinks.addAll(DataUtil.setFromIterator(firstSub.getLinkageSuperSetIterator()));
                lo.dropSelectedLinkProperties(null, baseGenome, frc);
            } else {
                HashMap fakeRememberProps = new HashMap();
                forRecoveriesOut.addAll(sle.getForRecoveriesOut());
                alienSources.putAll(sle.getAlienSources());
                srcToBetween.putAll(sle.getSrcToBetween());
                newLinks.addAll(sle.getNewLinks());
                Iterator oosit = newLinks.iterator();
                while (oosit.hasNext()) {
                    String lid = (String)oosit.next();
                    lo.removeLinkPropertiesAndRemember(lid, fakeRememberProps, baseGenome, frc);
                }
            }
            Map rememberProps = sle.getRememberProps();
            this.gridlessLinkLayoutPrep(baseGenome, lo, frc, newLinks, rememberProps);
            Map overlaySplicePlans = null;
            if (!isCompleteGenome) {
                overlaySplicePlans = sle.getSplicePlans();
                Map nonOverlaySolutions = sle.getNonOverlaySplicePlans();
                this.spliceBoundaries(forRecoveriesOut, alienSources, propsList, numSub, nonOverlaySolutions, overlaySplicePlans);
            }
            double midFrac1 = currStart + (maxFrac - currStart) * 0.7;
            double midFrac2 = currStart + (maxFrac - currStart) * 0.75;
            NetModuleLinkExtractor.SubsetAnalysis sa = sle.getSubsetAnalysis();
            LinkRouter.RoutingResult retval = router.specialtyLayout(subsetList, propsList, alienSources, srcToBetween, sa, newLinks, lo, frc, overlaySplicePlans, monitor, currStart, midFrac1);
            Set ultimateFailures = sle.getUltimateFailures();
            if (!ultimateFailures.isEmpty()) {
                LayoutOptions options = LayoutOptionsManager.getMgr().getLayoutOptions();
                AddCommands.relayoutLinks(baseGenome, null, lo, frc, options, false, ultimateFailures, monitor, midFrac1, midFrac1, false);
            }
            lo.restoreSpecialLinks(specials, baseGenome);
            lo.dropUselessCorners(baseGenome, frc, null, null, midFrac1, midFrac2, monitor);
            if (isCompleteGenome) {
                lo.eliminateStaggeredRuns(10, baseGenome, frc, null, null, null, midFrac2, midFrac2, monitor);
            }
            if (!isCompleteGenome && numSub == 1) {
                Set fixLinks = sle.getNewLinks();
                List lps = lo.listOfProps(baseGenome, null, fixLinks);
                int numLps = lps.size();
                for (int i = 0; i < numLps; ++i) {
                    LinkProperties lp = (LinkProperties)lps.get(i);
                    lo.fixAllNonOrthoForTree(lp, baseGenome, frc, false, null, null, monitor, midFrac2, midFrac2);
                }
            }
            lo.repairAllTopology(frc, null, null, monitor, midFrac2, midFrac2);
            this.doColorOperations(sle.doFromScratch(), allAssign, router, allNodeColors, allLinkColors, baseGenome, lo, frc, retval, monitor);
            int boundCount = 0;
            for (int i = 0; i < numSub; ++i) {
                SpecialtyInstructions sip = (SpecialtyInstructions)propsList.get(i);
                if (sip.lcf == null) continue;
                boundCount += sip.lcf.boundCount();
            }
            double boundStart = midFrac2;
            double boundInc = (maxFrac - boundStart) / (double)boundCount;
            for (int i = 0; i < numSub; ++i) {
                SpecialtyInstructions sip = (SpecialtyInstructions)propsList.get(i);
                if (sip.lcf == null) continue;
                Iterator bit = sip.lcf.getBounds();
                while (bit.hasNext()) {
                    Rectangle brect = (Rectangle)bit.next();
                    SortedSet useEmptyRows = new TreeSet();
                    SortedSet useEmptyCols = new TreeSet();
                    brect.x += (int)shiftedAmount.getX();
                    brect.y += (int)shiftedAmount.getY();
                    lo.chooseCompressionRows(baseGenome, frc, 1.0, 1.0, brect, false, null, useEmptyRows, useEmptyCols, monitor);
                    useEmptyRows = DataUtil.trimOut(useEmptyRows, brect.y / 10, (brect.y + brect.height) / 10);
                    useEmptyCols = DataUtil.trimOut(useEmptyCols, brect.x / 10, (brect.x + brect.width) / 10);
                    double boundEnd = boundStart + boundInc;
                    lo.compress(baseGenome, useEmptyRows, useEmptyCols, brect, null, null, null, monitor, boundStart, boundEnd);
                    boundStart = boundEnd;
                }
                lo.repairStackedCompressionErrors(baseGenome, frc);
            }
            if (monitor != null && !monitor.updateProgress((int)(maxFrac * 100.0))) {
                throw new AsynchExitRequestException();
            }
            int overlayOption = sle.getOverlayOption();
            Layout.PadNeedsForLayout padNeedsForLayout = sle.getPadNeedsForLayout();
            Layout.OverlayKeySet loModKeys = padNeedsForLayout != null ? padNeedsForLayout.getFullModuleKeys() : null;
            Map moduleShapeRecovery = sle.getModuleShapeRecovery();
            if (moduleShapeRecovery != null && !moduleShapeRecovery.isEmpty() && overlayOption != 2) {
                Layout.OverlayKeySet reduced = loModKeys.dropOverlay(overlayKey);
                lo.shiftModuleShapesPerParams(reduced, moduleShapeRecovery, frc);
            }
            if (overlayKey != null) {
                for (int i = 0; i < numSub; ++i) {
                    SpecialtyInstructions sp = (SpecialtyInstructions)propsList.get(i);
                    Rectangle newSize = sp.getStrictGrownBounds();
                    if (newSize == null) {
                        newSize = sp.getPlacedFullBounds();
                    }
                    lo.sizeCoreToGivenBounds(baseGenome.getID(), overlayKey, sp.moduleID, new Rectangle(newSize));
                }
            }
            if (overlayKey != null) {
                Map modLinkCornerMoves = sle.getModLinkCornerMoves();
                lo.shiftModLinksToNewPositions(baseGenome.getID(), overlayKey, modLinkCornerMoves, false);
            }
            if (padNeedsForLayout != null) {
                Map orpho = lo.orphansOnlyForAll(false);
                if (overlayKey != null) {
                    orpho.put(overlayKey, new Boolean(true));
                }
                lo.repairAllNetModuleLinkPadRequirements(frc, padNeedsForLayout, orpho);
            }
            Layout.SupplementalDataCoords sdc = sle.getSupplementalDataCoords();
            Rectangle2D rect = lo.applySupplementalDataCoords(sdc, baseGenome, frc, loModKeys);
            lo.restoreLabelLocations(rememberProps, baseGenome, frc, rect);
            Point2D fullGenomeCenter = sle.getFullGenomeCenter();
            if (fullGenomeCenter != null) {
                Vector2D shifted = lo.recenterLayout(fullGenomeCenter, baseGenome, frc, true, true, true, null, null, null, loModKeys, padNeedsForLayout);
                shiftedAmount.setXY(shifted.getX(), shifted.getY());
            }
            if (sle.doHideNames()) {
                lo.hideAllMinorNodeNames();
            }
            if (support != null) {
                dc = db.finishLayoutUndoTransaction(dc);
                support.addEdit(new DatabaseChangeCmd(dc));
            }
            return retval;
        }
        catch (AsynchExitRequestException ex) {
            db.rollbackLayoutUndoTransaction(dc);
            throw ex;
        }
    }

    private void spliceBoundaries(List forRecoveriesOut, Map alienSources, List propsList, int numSub, Map nonOverlaySolutions, Map overlaySplicePlans) {
        SpecialtyLayoutLinkData si;
        if (!forRecoveriesOut.isEmpty()) {
            for (int i = 0; i < numSub; ++i) {
                SpecialtyInstructions sp = (SpecialtyInstructions)propsList.get(i);
                String modID = sp.getModuleID();
                Map forRecovery = (Map)forRecoveriesOut.get(i);
                if (forRecovery.isEmpty()) continue;
                Iterator sit = sp.getLinkSrcIterator();
                while (sit.hasNext()) {
                    String srcID = (String)sit.next();
                    si = sp.getLinkPointsForSrc(srcID);
                    SpecialtyLayoutLinkData recSi = (SpecialtyLayoutLinkData)forRecovery.get(srcID);
                    if (recSi == null) continue;
                    Map solnPerBorder = modID == null ? nonOverlaySolutions : (Map)overlaySplicePlans.get(modID);
                    si.mergeToStubs(recSi, solnPerBorder);
                }
            }
        }
        if (!alienSources.isEmpty()) {
            Iterator asit = alienSources.keySet().iterator();
            while (asit.hasNext()) {
                String srcID = (String)asit.next();
                SpecialtyLayoutLinkData recSi = (SpecialtyLayoutLinkData)alienSources.get(srcID);
                for (int i = 0; i < numSub; ++i) {
                    SpecialtyInstructions sp = (SpecialtyInstructions)propsList.get(i);
                    String modID = sp.getModuleID();
                    si = sp.getLinkPointsForSrc(srcID);
                    Map solnPerBorder = modID == null ? nonOverlaySolutions : (Map)overlaySplicePlans.get(modID);
                    recSi.mergeToAlienStub(si, solnPerBorder);
                }
            }
        }
    }

    private void doColorOperations(boolean fromScratch, boolean allAssign, LinkRouter router, Map allNodeColors, Map allLinkColors, Genome genome, Layout lo, FontRenderContext frc, LinkRouter.RoutingResult retval, BTProgressMonitor monitor) throws AsynchExitRequestException {
        ColorAssigner.ColorIssues issues = null;
        if (fromScratch) {
            HashSet<String> seenSrcs = new HashSet<String>();
            HashSet<String> needColors = new HashSet<String>();
            Iterator liit = genome.getLinkageIterator();
            while (liit.hasNext()) {
                Linkage link = (Linkage)liit.next();
                String src = link.getSource();
                if (seenSrcs.contains(src)) continue;
                seenSrcs.add(src);
                needColors.add(link.getID());
            }
            LinkPlacementGrid routerGrid = router.initGrid(genome, lo, frc, null, 1, monitor);
            ColorAssigner ca = new ColorAssigner();
            issues = ca.assignColors(genome, lo, routerGrid, null, false, false, needColors);
        } else if (allAssign) {
            LinkRouter.RoutingResult result = this.reassignColors(genome, null, lo, frc);
            if (result.colorResult != 0) {
                issues = new ColorAssigner.ColorIssues(result.collisionSrc1, result.collisionSrc2);
            }
        } else if (!allNodeColors.isEmpty() || !allLinkColors.isEmpty()) {
            LinkPlacementGrid routerGrid = router.initGrid(genome, lo, frc, null, 1, monitor);
            ColorAssigner ca = new ColorAssigner();
            issues = ca.assignViaMap(genome, lo, routerGrid, allNodeColors, allLinkColors);
        } else {
            LinkPlacementGrid routerGrid = router.initGrid(genome, lo, frc, null, 1, monitor);
            ColorAssigner ca = new ColorAssigner();
            issues = ca.hasAmbiguousCrossing(genome, lo, routerGrid);
        }
        if (issues != null && issues.status != 0) {
            retval.linkResult |= 1;
            retval.colorResult = issues.status;
            retval.collisionSrc1 = issues.collisionSrc1 == null ? retval.collisionSrc1 : issues.collisionSrc1;
            retval.collisionSrc2 = issues.collisionSrc2 == null ? retval.collisionSrc2 : issues.collisionSrc2;
        }
    }

    public LinkRouter.RoutingResult optimizeLinks(Set links, Set frozen, Genome genome, UndoSupport support, boolean allowReroutes, FontRenderContext frc, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        LinkRouter.RoutingResult retval = new LinkRouter.RoutingResult();
        Database db = Database.getDB();
        String genomeKey = genome.getID();
        Layout lo = db.getLayout(new LayoutManager().getLayout(genomeKey));
        DatabaseChange dc = db.startLayoutUndoTransaction(lo.getName());
        try {
            LinkRouter router = new LinkRouter();
            LinkPlacementGrid routerGrid = router.initGrid(genome, lo, frc, null, 1, monitor);
            lo.optimizeLinks(links, routerGrid, genome, frc, null, null, frozen, allowReroutes, monitor, 1, startFrac, endFrac);
            ColorAssigner ca = new ColorAssigner();
            ColorAssigner.ColorIssues issues = ca.hasAmbiguousCrossing(genome, lo, routerGrid);
            if (issues != null) {
                retval.colorResult = 1;
                retval.linkResult |= 1;
                retval.collisionSrc1 = issues.collisionSrc1 == null ? retval.collisionSrc1 : issues.collisionSrc1;
                retval.collisionSrc2 = issues.collisionSrc2 == null ? retval.collisionSrc2 : issues.collisionSrc2;
            }
            dc = db.finishLayoutUndoTransaction(dc);
            support.addEdit(new DatabaseChangeCmd(dc));
            return retval;
        }
        catch (AsynchExitRequestException ex) {
            db.rollbackLayoutUndoTransaction(dc);
            throw ex;
        }
    }

    private Vector2D avgDistance(Genome genome, Layout lo) {
        NodeProperties np;
        Node node;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        Iterator nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            node = (Node)nit.next();
            np = lo.getNodeProperties(node.getID());
            if (np == null) continue;
            points.add(np.getLocation());
        }
        nit = genome.getGeneIterator();
        while (nit.hasNext()) {
            node = (Node)nit.next();
            np = lo.getNodeProperties(node.getID());
            if (np == null) continue;
            points.add(np.getLocation());
        }
        return DistanceMeasurer.calcDistances(points);
    }

    private boolean topIsBest(Genome genome, Layout lo, Set newNodes, Grid grid, Point topCorner, Point bottomCorner) {
        if (topCorner.equals(bottomCorner)) {
            return true;
        }
        Iterator lit = genome.getLinkageIterator();
        double topDiffSum = 0.0;
        double botDiffSum = 0.0;
        while (lit.hasNext()) {
            Point2D trgLocBot;
            Point2D trgLocTop;
            Point2D srcLocBot;
            Point2D srcLocTop;
            boolean trgIsNew;
            Linkage link = (Linkage)lit.next();
            String src = link.getSource();
            String trg = link.getTarget();
            boolean srcIsNew = newNodes.contains(src);
            if (srcIsNew == (trgIsNew = newNodes.contains(trg))) continue;
            if (srcIsNew) {
                srcLocTop = grid.getGridLocation(src, topCorner);
                srcLocBot = grid.getGridLocation(src, bottomCorner);
            } else {
                NodeProperties sp = lo.getNodeProperties(src);
                srcLocBot = srcLocTop = sp.getLocation();
            }
            if (trgIsNew) {
                trgLocTop = grid.getGridLocation(trg, topCorner);
                trgLocBot = grid.getGridLocation(trg, bottomCorner);
            } else {
                NodeProperties tp = lo.getNodeProperties(trg);
                trgLocBot = trgLocTop = tp.getLocation();
            }
            topDiffSum += Math.abs(trgLocTop.getY() - srcLocTop.getY());
            botDiffSum += Math.abs(trgLocBot.getY() - srcLocBot.getY());
        }
        return topDiffSum <= botDiffSum;
    }

    private WeightedAverage findSourceWeightedAvg(Genome genome, Set newNodes, Grid grid, int col, Layout lo) {
        WeightedAverage wa = new WeightedAverage();
        wa.average = 0.0;
        wa.count = 0;
        Map topoSort = grid.getTopoSort();
        int numRows = grid.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            String nodeID = grid.getCellValue(i, col);
            if (nodeID == null) continue;
            int topoColTarg = (Integer)topoSort.get(nodeID);
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                int topoColSrc;
                String src;
                Linkage link = (Linkage)lit.next();
                String trg = link.getTarget();
                if (!trg.equals(nodeID) || newNodes.contains(src = link.getSource()) || (topoColSrc = ((Integer)topoSort.get(src)).intValue()) >= topoColTarg) continue;
                NodeProperties np = lo.getNodeProperties(src);
                double xOffset = np.getRenderer().getVerticalOffset();
                double val = np.getLocation().getX() - xOffset;
                wa.average += val;
                ++wa.count;
            }
        }
        if (wa.count != 0) {
            wa.average /= (double)wa.count;
        }
        return wa;
    }

    private WeightedAverage findTargetWeightedAvg(Genome genome, Set newNodes, Grid grid, int col, Layout lo) {
        WeightedAverage wa = new WeightedAverage();
        wa.average = 0.0;
        wa.count = 0;
        Map topoSort = grid.getTopoSort();
        int numRows = grid.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            String nodeID = grid.getCellValue(i, col);
            if (nodeID == null) continue;
            int topoColSrc = (Integer)topoSort.get(nodeID);
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                int topoColTarg;
                String trg;
                Linkage link = (Linkage)lit.next();
                String src = link.getSource();
                if (!src.equals(nodeID) || newNodes.contains(trg = link.getTarget()) || topoColSrc >= (topoColTarg = ((Integer)topoSort.get(trg)).intValue())) continue;
                NodeProperties np = lo.getNodeProperties(trg);
                double xOffset = np.getRenderer().getVerticalOffset();
                double val = np.getLocation().getX() - xOffset;
                wa.average += val;
                ++wa.count;
            }
        }
        if (wa.count != 0) {
            wa.average /= (double)wa.count;
        }
        return wa;
    }

    private Point2D findBestVerticalPosition(Genome genome, Grid grid, Layout lo, Map newNodeTypes, double leftie) {
        int rows = grid.getNumRows();
        int cols = grid.getNumCols();
        HashMap<String, Point2D> gridPos = new HashMap<String, Point2D>();
        Point2D.Double dummyCorner = new Point2D.Double(0.0, 0.0);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                String geneID = grid.getCellValue(i, j);
                if (geneID == null) continue;
                Point2D loc = grid.getGridLocation(i, j, dummyCorner);
                gridPos.put(geneID, loc);
            }
        }
        Set gridNodes = gridPos.keySet();
        int count = 0;
        double deltaSum = 0.0;
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            String oldNode;
            String newNode;
            Linkage link = (Linkage)lit.next();
            String trg = link.getTarget();
            String src = link.getSource();
            boolean gridHasTarg = gridNodes.contains(trg);
            if (gridHasTarg == gridNodes.contains(src)) continue;
            if (gridHasTarg) {
                newNode = trg;
                oldNode = src;
            } else {
                newNode = src;
                oldNode = trg;
            }
            NodeProperties np = lo.getNodeProperties(oldNode);
            Point2D oldPos = np.getLocation();
            Point2D newPos = (Point2D)gridPos.get(newNode);
            int nodeType = (Integer)newNodeTypes.get(newNode);
            np = new NodeProperties(lo, nodeType, newNode, 0.0, 0.0, false);
            double yOffset = np.getRenderer().getStraightThroughOffset();
            double yDiff = oldPos.getY() - (newPos.getY() + yOffset);
            ++count;
            deltaSum += yDiff;
        }
        return new Point2D.Double(leftie, deltaSum / (double)count);
    }

    private void calcColumnPositions(Genome genome, Set newNodes, Grid grid, Layout lo, double colW, double defaultLeft, SortedMap colLocs, SortedSet empties, LayoutOptions options) {
        TreeMap<Integer, WeightedAverage> absolutes = new TreeMap<Integer, WeightedAverage>();
        int numCols = grid.getNumCols();
        for (int i = 0; i < numCols; ++i) {
            int countForCol;
            double posForCol;
            if (grid.columnIsEmpty(i)) {
                empties.add(new Integer(i));
                continue;
            }
            WeightedAverage was = this.findSourceWeightedAvg(genome, newNodes, grid, i, lo);
            WeightedAverage wat = this.findTargetWeightedAvg(genome, newNodes, grid, i, lo);
            if (was.count == 0 && wat.count == 0) continue;
            if (was.count != 0 && wat.count != 0) {
                double posForSrc = was.average + colW;
                double posForTrg = wat.average - colW;
                posForCol = posForSrc;
                countForCol = was.count + wat.count;
                if (posForSrc > posForTrg) {
                    posForCol = (posForSrc * (double)was.count + posForTrg * (double)wat.count) / (double)countForCol;
                }
            } else if (was.count != 0) {
                posForCol = was.average + colW;
                countForCol = was.count;
            } else if (wat.count != 0) {
                posForCol = wat.average - colW;
                countForCol = wat.count;
            } else {
                throw new IllegalStateException();
            }
            absolutes.put(new Integer(i), new WeightedAverage(posForCol, countForCol));
        }
        Double currPosObj = new Double(0.0);
        double lastColPos = 0.0;
        for (int i = 0; i < numCols; ++i) {
            Integer iObj = new Integer(i);
            if (empties.contains(iObj)) continue;
            int numFilled = 0;
            double currPos = 0.0;
            int currCount = 0;
            double colWidth = 0.0;
            for (int j = i; j < numCols; ++j) {
                Integer jObj = new Integer(j);
                WeightedAverage colPos = (WeightedAverage)absolutes.get(jObj);
                if (colPos == null) {
                    if (options.incrementalCompress && empties.contains(jObj)) continue;
                    ++numFilled;
                    continue;
                }
                currPos += (colPos.average - colW * (double)numFilled) * (double)colPos.count;
                currCount += colPos.count;
                ++numFilled;
            }
            colWidth = colW;
            double minPos = !colLocs.isEmpty() ? lastColPos + colWidth : (currCount > 0 ? Double.NEGATIVE_INFINITY : defaultLeft);
            if (currCount == 0) {
                currPos = minPos;
                currPos = this.varianceReductionTweak(genome, lo, currPos, colW * 0.4, true);
            } else if ((currPos /= (double)currCount) < minPos) {
                currPos = minPos;
                currPos = this.varianceReductionTweak(genome, lo, currPos, colW * 0.4, true);
            } else {
                currPos = this.varianceReductionTweak(genome, lo, currPos, colW * 0.4, false);
            }
            lastColPos = currPos = (double)Math.round(currPos / 10.0) * 10.0;
            currPosObj = new Double(currPos);
            colLocs.put(iObj, currPosObj);
        }
    }

    private double calcIncrementalGridSpacing(Genome genome, Set newNodes, Grid grid, Layout lo, double defaultLeft, LayoutOptions options) {
        Vector2D avg = this.avgDistance(genome, lo);
        double avgW = avg.getX();
        double colWidth = avgW == 0.0 ? grid.getColSpace() : (double)Math.round(avgW / 10.0) * 10.0;
        double avgH = avg.getY();
        double rowHeight = avgH == 0.0 ? grid.getRowSpace() : (double)Math.round(avgH / 10.0) * 10.0;
        grid.setRowSpace(rowHeight);
        TreeMap colPos = new TreeMap();
        TreeSet empties = new TreeSet();
        this.calcColumnPositions(genome, newNodes, grid, lo, colWidth, defaultLeft, colPos, empties, options);
        double retval = 0.0;
        double lastval = 0.0;
        int lastCol = 0;
        boolean isFirst = true;
        boolean isSecond = false;
        double tweak = colWidth / 2.0;
        double delta = colWidth;
        Iterator ckit = colPos.keySet().iterator();
        while (ckit.hasNext()) {
            Integer colObj = (Integer)ckit.next();
            int col = colObj;
            double pos = (Double)colPos.get(colObj);
            if (isFirst) {
                retval = pos;
                isFirst = false;
                isSecond = true;
            } else if (isSecond) {
                tweak = (pos - lastval) / 2.0;
                isSecond = false;
                delta = pos - lastval;
                grid.overrideColSpace(lastCol, delta);
            } else {
                delta = pos - lastval;
                grid.overrideColSpace(lastCol, delta);
            }
            lastval = pos;
            lastCol = col;
        }
        grid.overrideColSpace(lastCol, delta);
        Iterator eit = empties.iterator();
        while (eit.hasNext()) {
            Integer colObj = (Integer)eit.next();
            int col = colObj;
            grid.overrideColSpace(col, 0.0);
        }
        return retval - tweak;
    }

    private double[] collectXCoords(Genome genome, Layout lo, double xCenter, double width) {
        Point2D loc;
        double xLoc;
        NodeProperties np;
        Node node;
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        Iterator nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            node = (Node)nit.next();
            np = lo.getNodeProperties(node.getID());
            if (np == null || !(Math.abs(xCenter - (xLoc = (loc = np.getLocation()).getX() - np.getRenderer().getVerticalOffset())) <= width)) continue;
            points.add(new Point2D.Double(xLoc, loc.getY()));
        }
        nit = genome.getGeneIterator();
        while (nit.hasNext()) {
            node = (Node)nit.next();
            np = lo.getNodeProperties(node.getID());
            if (np == null || !(Math.abs(xCenter - (xLoc = (loc = np.getLocation()).getX() - np.getRenderer().getVerticalOffset())) <= width)) continue;
            points.add(new Point2D.Double(xLoc, loc.getY()));
        }
        int size = points.size();
        double[] retval = new double[size];
        for (int i = 0; i < size; ++i) {
            retval[i] = ((Point2D)points.get(i)).getX();
        }
        return retval;
    }

    private double varianceReductionTweak(Genome genome, Layout lo, double xCenter, double width, boolean plusOnly) {
        double[] xCoords = this.collectXCoords(genome, lo, xCenter, width);
        int numCoords = xCoords.length;
        double[] xCoordsPlus = new double[numCoords + 1];
        System.arraycopy(xCoords, 0, xCoordsPlus, 0, numCoords);
        double minVariance = Double.POSITIVE_INFINITY;
        int minCoord = Integer.MIN_VALUE;
        int xMin = !plusOnly ? (int)Math.round((xCenter - width) / 10.0 * 10.0) : (int)Math.round(xCenter / 10.0 * 10.0);
        int xMax = (int)Math.ceil((double)Math.round((xCenter + width) / 10.0) * 10.0);
        if (numCoords != 0) {
            for (int i = xMin; i <= xMax; i += 10) {
                xCoordsPlus[numCoords] = i;
                double varSq = this.varianceSq(xCoordsPlus);
                if (!(varSq < minVariance)) continue;
                minVariance = varSq;
                minCoord = i;
            }
        }
        if (minVariance != Double.POSITIVE_INFINITY) {
            return minCoord;
        }
        return xCenter;
    }

    private double varianceSq(double[] values) {
        int size = values.length;
        double sum = 0.0;
        double sumsq = 0.0;
        for (int i = 0; i < size; ++i) {
            sum += values[i];
            sumsq += values[i] * values[i];
        }
        double n = size;
        double retval = 1.0 / (n - 1.0) * (sumsq - sum * sum / n);
        return retval;
    }

    public boolean addExtraProxyNode(String genomeKey, NodeInstance useNode, String groupToUse) {
        DynamicInstanceProxy.AddedNode added;
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeKey);
        if (!(genome instanceof DynamicGenomeInstance)) {
            throw new IllegalArgumentException();
        }
        DynamicGenomeInstance dgi = (DynamicGenomeInstance)genome;
        DynamicInstanceProxy dip = db.getDynamicProxy(dgi.getProxyID());
        ProxyChange pc = dip.addExtraNode(added = new DynamicInstanceProxy.AddedNode(useNode.getID(), groupToUse));
        if (pc != null) {
            ProxyChangeCmd pcc = new ProxyChangeCmd(pc);
            UndoSupport support = new UndoSupport(this.undom_, "undo.addExtraProxyNode");
            support.addEdit(pcc);
            support.addEvent(new ModelChangeEvent(genomeKey, 1));
            support.finish();
        }
        return true;
    }

    public NoteCandidate addNewNoteToGenome(String genomeKey, String layoutKey) {
        ResourceManager rMan = ResourceManager.getManager();
        NotePropertiesDialog ncd = new NotePropertiesDialog(this.topWindow_, null, null, this.undom_);
        ncd.show();
        if (!ncd.haveResult()) {
            return null;
        }
        Database db = Database.getDB();
        this.targetLayout_ = db.getLayout(layoutKey);
        Genome genome = db.getGenome(genomeKey);
        String noteID = genome.getNextNoteKey();
        Note newNote = new Note(noteID, ncd.getName(), ncd.getIsInteractive());
        newNote.setText(ncd.getText());
        NoteCandidate retval = new NoteCandidate(newNote, ncd.getColor(), ncd.getFontOverride(), ncd.getJustification());
        this.targetGenome_ = genome;
        return retval;
    }

    public LinkCandidate addNewLinkStart(String genomeKey, String layoutKey, FontRenderContext frc) {
        Database db = Database.getDB();
        this.targetLayout_ = db.getLayout(layoutKey);
        Genome genome = db.getGenome(genomeKey);
        String newName = null;
        int newSign = 0;
        if (genome instanceof DBGenome) {
            LinkCreationDialog lcd = new LinkCreationDialog(this.topWindow_);
            lcd.show();
            if (!lcd.haveResult()) {
                return null;
            }
            newSign = lcd.getSign();
            newName = lcd.getName();
            this.existingLinkID_ = null;
        } else {
            Genome rootGenome = db.getGenome();
            DrawLinkInstanceCreationDialog lcd = new DrawLinkInstanceCreationDialog(this.topWindow_, rootGenome, (GenomeInstance)genome, frc);
            lcd.show();
            if (!lcd.haveResult()) {
                return null;
            }
            this.existingLinkID_ = lcd.getID();
            if (this.existingLinkID_ == null) {
                newSign = lcd.getSign();
                newName = lcd.getName();
            } else {
                if (lcd.haveImmediateAdd()) {
                    this.addNewLinkToInstanceFinish((GenomeInstance)genome, this.targetLayout_, null, frc);
                    return null;
                }
                this.okSrcTrgMap_ = lcd.getOkSrcTrgMap();
                Linkage oldLink = rootGenome.getLinkage(this.existingLinkID_);
                newSign = oldLink.getSign();
                newName = oldLink.getName();
            }
        }
        LinkCandidate lc = new LinkCandidate();
        lc.label = newName;
        lc.sign = newSign;
        return lc;
    }

    public Map getOKSrcTrgMap() {
        return this.okSrcTrgMap_;
    }

    private Set newLinkInstanceHasParent(Genome rootGenome, LinkCandidate lc, GenomeInstance gi) {
        String srcID = lc.srcID;
        if (srcID == null) {
            throw new IllegalArgumentException();
        }
        String targ = lc.target.getObjectID();
        String rootSrc = GenomeItemInstance.getBaseID(srcID);
        String rootTarg = GenomeItemInstance.getBaseID(targ);
        HashSet<String> rootCand = new HashSet<String>();
        Iterator lit = rootGenome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (!link.getSource().equals(rootSrc) || !link.getTarget().equals(rootTarg) || link.getSign() != lc.sign) continue;
            rootCand.add(link.getID());
        }
        if (rootCand.isEmpty()) {
            return null;
        }
        HashSet rcOrig = new HashSet(rootCand);
        Iterator rcit = rcOrig.iterator();
        block1: while (rcit.hasNext()) {
            String rcid = (String)rcit.next();
            lit = gi.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                String iLinkID = link.getID();
                String iLinkIDBase = GenomeItemInstance.getBaseID(iLinkID);
                if (!iLinkIDBase.equals(rcid) || !srcID.equals(link.getSource()) || !targ.equals(link.getTarget())) continue;
                rootCand.remove(rcid);
                continue block1;
            }
        }
        if (rootCand.size() == 0) {
            return null;
        }
        return rootCand;
    }

    private Set newLinkInstanceExists(LinkCandidate lc, GenomeInstance gi) {
        HashSet<String> retval = new HashSet<String>();
        String srcID = lc.srcID;
        if (srcID == null) {
            throw new IllegalArgumentException();
        }
        String targ = lc.target.getObjectID();
        Iterator lit = gi.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (!link.getSource().equals(srcID) || !link.getTarget().equals(targ) || link.getSign() != lc.sign) continue;
            retval.add(link.getID());
        }
        return retval;
    }

    public boolean createSubGroupInGroup(String groupID, String layoutKey, GenomeInstance gi) {
        String newName = null;
        int layer = -1;
        ResourceManager rMan = ResourceManager.getManager();
        while (true) {
            SubGroupCreationDialog sgcd = new SubGroupCreationDialog(this.topWindow_);
            sgcd.show();
            if (!sgcd.haveResult()) {
                return false;
            }
            layer = sgcd.getStackingLayer();
            newName = sgcd.getName();
            if (!gi.groupNameInUse(newName)) break;
            JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("sgcreate.badName"), rMan.getString("sgcreate.badNameTitle"), 0);
        }
        String id = gi.getGenome().getNextKey();
        this.newSubGroup_ = new Group(id, newName, groupID);
        this.newSubGroupLayer_ = layer;
        return true;
    }

    public boolean locateNewSubGroup(int x, int y, String layoutKey, String genomeKey) {
        Database db = Database.getDB();
        Layout layout = db.getLayout(layoutKey);
        GenomeInstance gi = (GenomeInstance)db.getGenome(genomeKey);
        UndoSupport support = new UndoSupport(this.undom_, "undo.addNewSubGroup");
        GenomeChange gc = gi.addGroupWithExistingLabel(this.newSubGroup_);
        if (gc != null) {
            support.addEdit(new GenomeChangeCmd(gc));
            support.addEvent(new ModelChangeEvent(gi.getID(), 1));
        }
        String parent = this.newSubGroup_.getParentID();
        GroupProperties parProp = layout.getGroupProperties(parent);
        GroupProperties prop = new GroupProperties(this.newSubGroup_.getID(), layout, this.newSubGroupLayer_, (Point2D)new Point2D.Double(x, y), parProp.getOrder());
        Layout.PropChange[] lpc = new Layout.PropChange[]{layout.setGroupProperties(this.newSubGroup_.getID(), prop)};
        if (lpc != null) {
            support.addEdit(new PropChangeCmd(lpc));
            support.addEvent(new LayoutChangeEvent(layout.getName(), 1));
        }
        support.finish();
        return true;
    }

    public boolean addNodeToSubGroup(GenomeInstance gi, Group group, NodeInstance ni) {
        UndoSupport support = new UndoSupport(this.undom_, "undo.addNewSubGroup");
        GroupChange grc = group.addMember(new GroupMember(ni.getID()), gi.getID());
        if (grc != null) {
            GroupChangeCmd grcc = new GroupChangeCmd(grc);
            support.addEdit(grcc);
            ModelChangeEvent mcev = new ModelChangeEvent(gi.getID(), 1);
            support.addEvent(mcev);
        }
        support.finish();
        return true;
    }

    private void propagateProperties(Database db, Genome genome, int nodeType, NodeProperties np, String nodeID, UndoSupport support) {
        Iterator loit = db.getLayoutIterator();
        String genomeKey = genome.getID();
        while (loit.hasNext()) {
            Layout lo = (Layout)loit.next();
            String loTarg = lo.getTarget();
            if (!loTarg.equals(genomeKey)) continue;
            Layout.PropChange[] lpc = new Layout.PropChange[1];
            NodeProperties newProps = new NodeProperties(np, lo, nodeType);
            lpc[0] = lo.setNodeProperties(nodeID, newProps);
            if (lpc == null) continue;
            PropChangeCmd pcc = new PropChangeCmd(lpc);
            support.addEdit(pcc);
        }
    }

    private void propagateLinkProperties(Database db, Genome genome, BusProperties lp, String linkID, UndoSupport support) {
        Iterator loit = db.getLayoutIterator();
        String genomeKey = genome.getID();
        while (loit.hasNext()) {
            Layout lo = (Layout)loit.next();
            String loTarg = lo.getTarget();
            if (!loTarg.equals(genomeKey)) continue;
            BusProperties bp = new BusProperties(lp);
            Layout.PropChange[] lpc = new Layout.PropChange[]{lo.setLinkPropertiesForUndo(linkID, bp, null)};
            if (lpc != null) {
                PropChangeCmd pcc = new PropChangeCmd(lpc);
                support.addEdit(pcc);
            }
            this.changeNodeColor(genome, lo, bp, linkID, support);
        }
    }

    private void changeNodeColor(Genome genome, Layout lo, BusProperties bp, String linkID, UndoSupport support) {
        Linkage link = genome.getLinkage(linkID);
        String srcID = link.getSource();
        Node srcNode = genome.getNode(srcID);
        if (NodeProperties.setWithLinkColor(srcNode.getNodeType())) {
            String linkColor = bp.getColorName();
            Layout.PropChange[] lpc = new Layout.PropChange[1];
            NodeProperties oldProps = lo.getNodeProperties(srcID);
            NodeProperties newProps = (NodeProperties)oldProps.clone();
            if (srcNode.getNodeType() == 5) {
                if (newProps.getColorName().equals(linkColor)) {
                    newProps.setSecondColor(null);
                } else {
                    newProps.setSecondColor(linkColor);
                }
            } else {
                newProps.setColor(linkColor);
            }
            lpc[0] = lo.replaceNodeProperties(oldProps, newProps);
            if (lpc != null) {
                PropChangeCmd pcc = new PropChangeCmd(lpc);
                support.addEdit(pcc);
            }
        }
    }

    private String findNodeColorForLink(Genome genome, Layout layout, String src) {
        String colorTag = null;
        Node srcNode = genome.getNode(src);
        if (NodeProperties.setWithLinkColor(srcNode.getNodeType())) {
            NodeProperties srcProp = layout.getNodeProperties(src);
            if (srcNode.getNodeType() == 5) {
                colorTag = srcProp.getSecondColorName();
                if (colorTag == null) {
                    colorTag = srcProp.getColorName();
                }
            } else {
                colorTag = srcProp.getColorName();
            }
            if (colorTag == null) {
                colorTag = "black";
            }
        }
        return colorTag;
    }

    private String findGenomeInstanceConsensusColor(GenomeInstance gi, Layout layout, String src) {
        Object colorTag = null;
        GenomeInstance root = gi.getVfgParentRoot();
        if (root != null) {
            gi = root;
        }
        int myInstance = GenomeItemInstance.getInstanceID(src);
        Set instances = gi.getNodeInstances(GenomeItemInstance.getBaseID(src));
        HashMap<String, Integer> colorCounts = new HashMap<String, Integer>();
        Iterator iit = instances.iterator();
        while (iit.hasNext()) {
            String linkColor;
            String nodeID = (String)iit.next();
            if (nodeID.equals(src) || (linkColor = this.findNodeColorForLink(gi, layout, nodeID)) == null || linkColor.equals("black")) continue;
            Integer count = (Integer)colorCounts.get(linkColor);
            Integer newCount = count == null ? new Integer(1) : new Integer(count + 1);
            colorCounts.put(linkColor, newCount);
        }
        int maxCount = Integer.MIN_VALUE;
        String maxColor = null;
        Iterator cckit = colorCounts.keySet().iterator();
        while (cckit.hasNext()) {
            String color = (String)cckit.next();
            Integer count = (Integer)colorCounts.get(color);
            int countVal = count;
            if (countVal <= maxCount) continue;
            maxCount = countVal;
            maxColor = color;
        }
        return maxColor;
    }

    private String chooseNodeColor(Genome genome, Layout layout, String src) {
        String colorTag = this.findNodeColorForLink(genome, layout, src);
        if (colorTag == null) {
            return "black";
        }
        if (colorTag.equals("black")) {
            if (genome instanceof GenomeInstance) {
                colorTag = this.findGenomeInstanceConsensusColor((GenomeInstance)genome, layout, src);
                if (colorTag == null || colorTag.equals("black")) {
                    colorTag = Database.getDB().getNextColor();
                }
            } else {
                colorTag = Database.getDB().getNextColor();
            }
        }
        return colorTag;
    }

    private void downPropagateLinkProperties(Database db, GenomeInstance genome, BusProperties lp, FontRenderContext frc, LinkageInstance newLink, Point2D srcPt, UndoSupport support, String srcLinkID) {
        String linkID = newLink.getID();
        String source = newLink.getSource();
        Iterator loit = db.getLayoutIterator();
        String genomeKey = genome.getID();
        while (loit.hasNext()) {
            Layout lo = (Layout)loit.next();
            String loTarg = lo.getTarget();
            if (!loTarg.equals(genomeKey)) continue;
            NodeProperties snp = lo.getNodeProperties(source);
            Point2D startLoc = (Point2D)snp.getLocation().clone();
            String target = newLink.getTarget();
            NodeProperties tnp = lo.getNodeProperties(target);
            Point2D endLoc = (Point2D)tnp.getLocation().clone();
            Vector2D offset = new Vector2D(srcPt, startLoc);
            LinkBusDrop keepDrop = lp.getTargetDrop(srcLinkID);
            BusProperties spTree = new BusProperties(lp, (BusDrop)keepDrop);
            spTree = new BusProperties(spTree, source, linkID, offset);
            Layout.PropChange lpc = lo.foldInNewProperty(newLink, genome, spTree, frc);
            PropChangeCmd pcc = new PropChangeCmd(new Layout.PropChange[]{lpc});
            support.addEdit(pcc);
        }
    }

    public boolean addAllElementsInGroupToSubsetInstance(String genomeKey, GenomeInstance parent, String groupID) {
        UndoSupport support = new UndoSupport(this.undom_, "undo.addAllElementsInGroupToSubsetInstance");
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeKey);
        if (!(genome instanceof GenomeInstance)) {
            throw new IllegalArgumentException();
        }
        GenomeInstance gi = (GenomeInstance)genome;
        int genCount = parent.getGeneration();
        String baseID = Group.getBaseID(groupID);
        String inherit = Group.buildInheritedID(baseID, genCount);
        Group parentGroup = parent.getGroup(inherit);
        Iterator nit = parent.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            if (gi.getNode(node.getID()) != null || !parentGroup.isInGroup(node.getID(), parent)) continue;
            this.addNewNodeToSubsetInstance(genomeKey, (NodeInstance)node, support);
        }
        Iterator lit = parent.getLinkageIterator();
        while (lit.hasNext()) {
            Group trgGrp;
            Group srcGrp;
            Linkage link = (Linkage)lit.next();
            if (gi.getLinkage(link.getID()) != null || (srcGrp = parent.getGroupForNode(link.getSource(), 1)) == null || !srcGrp.getID().equals(inherit) || (trgGrp = parent.getGroupForNode(link.getTarget(), 1)) == null || !trgGrp.getID().equals(inherit)) continue;
            this.addNewLinkToSubsetInstance(genomeKey, (LinkageInstance)link, support);
        }
        support.addEvent(new ModelChangeEvent(genomeKey, 1));
        support.finish();
        return true;
    }

    public boolean addNewLinkWithNodesToSubsetInstance(String genomeKey, GenomeInstance parent, Set pullSurvivors, Set nodesToAdd) {
        UndoSupport support = new UndoSupport(this.undom_, "undo.addNewLinkWithNodesToSubsetInstance");
        Iterator ntait = nodesToAdd.iterator();
        while (ntait.hasNext()) {
            String nodeKey = (String)ntait.next();
            NodeInstance pNode = (NodeInstance)parent.getNode(nodeKey);
            int srcType = pNode.getNodeType();
            this.addNewNodeToSubsetInstance(genomeKey, pNode, support);
        }
        Iterator psit = pullSurvivors.iterator();
        while (psit.hasNext()) {
            LinkageInstance subsetLink = (LinkageInstance)psit.next();
            this.addNewLinkToSubsetInstance(genomeKey, subsetLink, support);
        }
        support.addEvent(new ModelChangeEvent(genomeKey, 1));
        support.finish();
        return true;
    }

    public LinkageInstance addNewLinkToSubsetInstance(String genomeKey, LinkageInstance useLink, UndoSupport support) {
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeKey);
        if (!(genome instanceof GenomeInstance)) {
            throw new IllegalArgumentException();
        }
        GenomeInstance gi = (GenomeInstance)genome;
        GenomeInstance parent = gi.getVfgParent();
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        LinkageInstance newInstance = new LinkageInstance(useLink);
        GenomeChange gc = gi.addLinkage(newInstance);
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        return newInstance;
    }

    public boolean addNewGroupToSubsetInstance(String genomeKey, Group useGroup, UndoSupport support) {
        GroupCreationDialogHandler handler = new GroupCreationDialogHandler(this.topWindow_, this.undom_);
        return handler.addNewGroupToSubsetInstance(genomeKey, useGroup, support);
    }

    public boolean makeSubGroupActive(String genomeKey, String parentKey, String activeSubset, UndoSupport support) {
        GroupCreationDialogHandler handler = new GroupCreationDialogHandler(this.topWindow_, this.undom_);
        return handler.makeSubGroupActive(genomeKey, parentKey, activeSubset, support);
    }

    public boolean includeSubGroup(String genomeKey, String parentKey, String newSubgroup) {
        GroupCreationDialogHandler handler = new GroupCreationDialogHandler(this.topWindow_, this.undom_);
        return handler.includeSubGroup(genomeKey, parentKey, newSubgroup);
    }

    public void finishNetModPadFixups(Layout rootLayout, Layout.PadNeedsForLayout rootFixups, Layout vfaLayout, Layout.PadNeedsForLayout padFixups, FontRenderContext frc, UndoSupport support) {
        PropChangeCmd padC;
        Map orpho;
        Layout.PropChange[] padLpc;
        if (rootFixups != null && (padLpc = rootLayout.repairAllNetModuleLinkPadRequirements(frc, rootFixups, orpho = rootLayout.orphansOnlyForAll(false))) != null && padLpc.length != 0) {
            padC = new PropChangeCmd(padLpc);
            support.addEdit(padC);
            support.addEvent(new LayoutChangeEvent(rootLayout.getName(), 1));
        }
        if ((padLpc = vfaLayout.repairAllNetModuleLinkPadRequirements(frc, padFixups, orpho = vfaLayout.orphansOnlyForAll(false))) != null && padLpc.length != 0) {
            padC = new PropChangeCmd(padLpc);
            support.addEdit(padC);
            support.addEvent(new LayoutChangeEvent(vfaLayout.getName(), 1));
        }
    }

    public boolean propagateDown(String genomeKey, String layoutKey, List intersections, FontRenderContext frc) {
        Database db = Database.getDB();
        Layout layout = db.getLayout(layoutKey);
        Genome genome = db.getGenome();
        if (!genome.getID().equals(genomeKey)) {
            return false;
        }
        GenomeInstance target = null;
        Iterator iit = db.getInstanceIterator();
        ArrayList<GenomeInstance> roots = new ArrayList<GenomeInstance>();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (gi.getVfgParent() != null) continue;
            roots.add(gi);
        }
        int numRoots = roots.size();
        if (numRoots == 0) {
            throw new IllegalStateException();
        }
        if (numRoots == 1) {
            target = (GenomeInstance)roots.get(0);
        } else {
            ChoiceMap cmap;
            int useIndex = 0;
            ArrayList<ChoiceMap> targsToSort = new ArrayList<ChoiceMap>();
            for (int i = 0; i < numRoots; ++i) {
                GenomeInstance gi = (GenomeInstance)roots.get(i);
                cmap = new ChoiceMap(gi.getName(), gi);
                targsToSort.add(cmap);
            }
            Collections.sort(targsToSort);
            Object[] targets = new ChoiceMap[numRoots];
            targsToSort.toArray(targets);
            for (int i = 0; i < numRoots; ++i) {
                cmap = (ChoiceMap)targsToSort.get(i);
                if (lastGI_ == null || !((GenomeInstance)cmap.item).getID().equals(lastGI_)) continue;
                useIndex = i;
            }
            ResourceManager rMan = ResourceManager.getManager();
            ChoiceMap targetChoice = (ChoiceMap)JOptionPane.showInputDialog(this.topWindow_, rMan.getString("propagate.PropChoose"), rMan.getString("propagate.PropTitle"), 3, null, targets, targets[useIndex]);
            if (targetChoice == null) {
                return false;
            }
            target = (GenomeInstance)targetChoice.item;
            lastGI_ = target.getID();
        }
        Iterator init = intersections.iterator();
        ArrayList<Gene> geneList = new ArrayList<Gene>();
        ArrayList<Node> nodeList = new ArrayList<Node>();
        while (init.hasNext()) {
            Intersection inter = (Intersection)init.next();
            String id = inter.getObjectID();
            Gene gene = genome.getGene(id);
            if (gene != null) {
                geneList.add(gene);
                continue;
            }
            Node node = genome.getNode(id);
            if (node == null) continue;
            nodeList.add(node);
        }
        Layout lo = db.getLayout(new LayoutManager().getLayout(target.getID()));
        Layout.PadNeedsForLayout padFixups = lo.findAllNetModuleLinkPadRequirements(frc);
        UndoSupport support = new UndoSupport(this.undom_, "undo.propagateDown");
        Group selectedGroup = null;
        if (nodeList.size() > 0 || geneList.size() > 0) {
            Iterator grit = target.getGroupIterator();
            ArrayList<Group> groupList = new ArrayList<Group>();
            while (grit.hasNext()) {
                Group group = (Group)grit.next();
                if (group.isASubset(target)) continue;
                boolean present = false;
                Iterator glit = geneList.iterator();
                while (glit.hasNext()) {
                    Gene gene = (Gene)glit.next();
                    if (!group.instanceIsInGroup(gene.getID())) continue;
                    present = true;
                    break;
                }
                if (present) continue;
                Iterator nlit = nodeList.iterator();
                while (nlit.hasNext()) {
                    Node node = (Node)nlit.next();
                    if (!group.instanceIsInGroup(node.getID())) continue;
                    present = true;
                    break;
                }
                if (present) continue;
                groupList.add(group);
            }
            boolean newGroup = false;
            String selectedGroupID = null;
            boolean wasForcedDirect = false;
            Iterator git = geneList.iterator();
            Iterator nit = nodeList.iterator();
            Rectangle approxBounds = layout.getApproxBounds(nit, git, genome);
            git = geneList.iterator();
            nit = nodeList.iterator();
            Point2D defaultCenter = layout.getApproxCenter(nit, git);
            if (defaultCenter == null) {
                defaultCenter = new Point2D.Double(approxBounds.getCenterX(), approxBounds.getCenterY());
            }
            Point2D directCenter = null;
            if (target.hasZeroOrOneInstancePerNodeAfterAdditions(geneList, nodeList)) {
                directCenter = (Point2D)defaultCenter.clone();
            }
            if (groupList.size() == 0) {
                GroupCreationDialogHandler handler = new GroupCreationDialogHandler(this.topWindow_, target, lo, true, approxBounds, defaultCenter, directCenter);
                selectedGroup = handler.handleCreation(support);
                if (selectedGroup == null) {
                    return false;
                }
                selectedGroupID = selectedGroup.getID();
                newGroup = true;
                wasForcedDirect = handler.wasForcedDirect();
            } else {
                GroupAssignmentDialog gad = new GroupAssignmentDialog(this.topWindow_, lo, target, support, groupList, approxBounds, directCenter);
                gad.show();
                selectedGroupID = gad.getResult();
                if (selectedGroupID == null) {
                    return false;
                }
                selectedGroup = target.getGroup(selectedGroupID);
                newGroup = gad.isNewGroup();
            }
            Vector2D offset = null;
            if (newGroup) {
                if (wasForcedDirect) {
                    offset = new Vector2D(0.0, 0.0);
                } else {
                    git = geneList.iterator();
                    nit = nodeList.iterator();
                    Point2D goingInCentroid = layout.getApproxCenter(nit, git);
                    GroupProperties gp = lo.getGroupProperties(selectedGroupID);
                    offset = goingInCentroid == null ? new Vector2D(0.0, 0.0) : new Vector2D(goingInCentroid, gp.getLabelLocation());
                }
            } else {
                Point2D existCentroid = lo.getApproxCenterForGroup(target, selectedGroupID, false);
                Point2D existOrigCentroid = layout.getApproxCenterForGroup(target, selectedGroupID, true);
                offset = existCentroid == null || existOrigCentroid == null ? new Vector2D(0.0, 0.0) : new Vector2D(existOrigCentroid, existCentroid);
            }
            Iterator glit = geneList.iterator();
            while (glit.hasNext()) {
                Gene gene = (Gene)glit.next();
                this.propagateNode(true, target, (DBGene)gene, layout, offset, selectedGroup, support);
            }
            Iterator nlit = nodeList.iterator();
            while (nlit.hasNext()) {
                Node node = (Node)nlit.next();
                this.propagateNode(false, target, (DBNode)node, layout, offset, selectedGroup, support);
            }
        }
        HashSet dbLinkages = new HashSet();
        init = intersections.iterator();
        while (init.hasNext()) {
            Intersection inter = (Intersection)init.next();
            String id = inter.getObjectID();
            Linkage link = genome.getLinkage(id);
            if (link == null) continue;
            dbLinkages.addAll(this.resolveLinkages(inter, genome, layout));
        }
        if (dbLinkages.size() == 0) {
            this.finishNetModPadFixups(null, null, lo, padFixups, frc, support);
            support.finish();
            return true;
        }
        GroupTupleResult tupResult = this.calculateGroupTwoTuples(target, dbLinkages, selectedGroup);
        Set surviving = tupResult.survivingLinks;
        ResourceManager rMan = ResourceManager.getManager();
        if (tupResult.result == 1) {
            JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("propagate.MissingEndpoint"), rMan.getString("propagate.MissingEndpointTitle"), 0);
            if (surviving.isEmpty()) {
                this.finishNetModPadFixups(null, null, lo, padFixups, frc, support);
                support.finish();
                return false;
            }
        } else {
            if (tupResult.result == 2) {
                JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("propagate.NoCommonGroupings"), rMan.getString("propagate.NoCommonGroupingsTitle"), 0);
                this.finishNetModPadFixups(null, null, lo, padFixups, frc, support);
                support.finish();
                return false;
            }
            if (tupResult.result == 3) {
                JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("propagate.TargetGroupNotPresent"), rMan.getString("propagate.TargetGroupNotPresentTitle"), 0);
                this.finishNetModPadFixups(null, null, lo, padFixups, frc, support);
                support.finish();
                return false;
            }
        }
        TreeSet groupTups = new TreeSet(tupResult.set);
        int numTups = groupTups.size();
        GenomeInstance.GroupTuple oneChosen = null;
        if (numTups == 1) {
            oneChosen = (GenomeInstance.GroupTuple)groupTups.iterator().next();
        } else if (tupResult.result != 4) {
            Object[] values = new Object[numTups];
            Iterator gtit = groupTups.iterator();
            int count = 0;
            while (gtit.hasNext()) {
                GenomeInstance.GroupTuple gt = (GenomeInstance.GroupTuple)gtit.next();
                Group sg = target.getGroup(gt.getSourceGroup());
                Group tg = target.getGroup(gt.getTargetGroup());
                String desc = sg.getName() + " --> " + tg.getName();
                values[count++] = new ChoiceMap(desc, gt);
            }
            ChoiceMap tupleChoice = (ChoiceMap)JOptionPane.showInputDialog(this.topWindow_, rMan.getString("propagate.TupleChoose"), rMan.getString("propagate.TupleTitle"), 3, null, values, values[0]);
            if (tupleChoice == null) {
                this.finishNetModPadFixups(null, null, lo, padFixups, frc, support);
                support.finish();
                return false;
            }
            oneChosen = (GenomeInstance.GroupTuple)tupleChoice.item;
        }
        Iterator sit = surviving.iterator();
        while (sit.hasNext()) {
            String lnkKey = (String)sit.next();
            DBLinkage dbLink = (DBLinkage)genome.getLinkage(lnkKey);
            GenomeInstance.GroupTuple chosen = oneChosen != null ? oneChosen : (GenomeInstance.GroupTuple)tupResult.singleTuplePerLink.get(lnkKey);
            this.propagateLinkage(target, dbLink, genome, layout, chosen, frc, support);
        }
        this.finishNetModPadFixups(null, null, lo, padFixups, frc, support);
        support.finish();
        return true;
    }

    public boolean propagateDownEntireRootToGroup(String genomeKey, String layoutKey, String groupKey, FontRenderContext frc) {
        GenomeInstance.GroupTuple tup;
        Database db = Database.getDB();
        Layout layout = db.getLayout(layoutKey);
        GenomeInstance target = (GenomeInstance)db.getGenome(genomeKey);
        Genome rootGenome = db.getGenome();
        Layout rootLayout = db.getLayout(new LayoutManager().getLayout(rootGenome.getID()));
        HashSet<Node> nodes = new HashSet<Node>();
        Group group = target.getGroup(groupKey);
        Iterator nit = rootGenome.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            if (group.instanceIsInGroup(node.getID())) continue;
            nodes.add(node);
        }
        HashSet<String> linkages = new HashSet<String>();
        Iterator lit = rootGenome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            Set ids = target.returnLinkInstanceIDsForBacking(link.getID());
            if (ids.isEmpty()) {
                linkages.add(link.getID());
                continue;
            }
            boolean notThere = true;
            Iterator sit = ids.iterator();
            while (sit.hasNext()) {
                String instanceID = (String)sit.next();
                tup = target.getRegionTuple(instanceID);
                if (!tup.getSourceGroup().equals(groupKey) || !tup.getTargetGroup().equals(groupKey)) continue;
                notThere = false;
                break;
            }
            if (!notThere) continue;
            linkages.add(link.getID());
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.propagateAllDownToGroup");
        Point2D existCentroid = layout.getApproxCenterForGroup(target, groupKey, false);
        Point2D existOrigCentroid = rootLayout.getApproxCenterForGroup(target, groupKey, true);
        if (existCentroid == null || existOrigCentroid == null) {
            GroupProperties gp = layout.getGroupProperties(groupKey);
            existCentroid = gp.getLabelLocation();
            existOrigCentroid = rootLayout.getApproxCenter(rootGenome.getAllNodeIterator());
        }
        Vector2D offset = existCentroid != null && existOrigCentroid != null ? new Vector2D(existOrigCentroid, existCentroid) : new Vector2D(0.0, 0.0);
        Iterator nlit = nodes.iterator();
        while (nlit.hasNext()) {
            Node node = (Node)nlit.next();
            this.propagateNode(node.getNodeType() == 4, target, (DBNode)node, rootLayout, offset, group, support);
        }
        tup = new GenomeInstance.GroupTuple(groupKey, groupKey);
        Iterator sit = linkages.iterator();
        while (sit.hasNext()) {
            String lnkKey = (String)sit.next();
            DBLinkage dbLink = (DBLinkage)rootGenome.getLinkage(lnkKey);
            this.propagateLinkage(target, dbLink, rootGenome, rootLayout, tup, frc, support);
        }
        support.finish();
        return true;
    }

    public boolean linkInstanceExists(String baseID, String genomeKey, String groupKey1, String groupKey2) {
        Set ids;
        Database db = Database.getDB();
        GenomeInstance target = (GenomeInstance)db.getGenome(genomeKey);
        if (groupKey2 == null) {
            groupKey2 = groupKey1;
        }
        if ((ids = target.returnLinkInstanceIDsForBacking(baseID)).isEmpty()) {
            return false;
        }
        Iterator sit = ids.iterator();
        while (sit.hasNext()) {
            String instanceID = (String)sit.next();
            GenomeInstance.GroupTuple tup = target.getRegionTuple(instanceID);
            if (!tup.getSourceGroup().equals(groupKey1) || !tup.getTargetGroup().equals(groupKey2)) continue;
            return true;
        }
        return false;
    }

    public boolean propagateDownElementsFromRootToGroup(Set nodeIDs, Set linkIDs, String genomeKey, String layoutKey, String groupKey1, String groupKey2, FontRenderContext frc) {
        GenomeInstance.GroupTuple tup;
        Database db = Database.getDB();
        Layout layout = db.getLayout(layoutKey);
        GenomeInstance target = (GenomeInstance)db.getGenome(genomeKey);
        Genome rootGenome = db.getGenome();
        Layout rootLayout = db.getLayout(new LayoutManager().getLayout(rootGenome.getID()));
        if (groupKey2 == null) {
            groupKey2 = groupKey1;
        }
        boolean splitGroups = !groupKey2.equals(groupKey1);
        Group group1 = target.getGroup(groupKey1);
        Group group2 = target.getGroup(groupKey2);
        HashSet<String> nodes = new HashSet<String>();
        Iterator nit = nodeIDs.iterator();
        while (nit.hasNext()) {
            String nodeID = (String)nit.next();
            int iNum = target.getInstanceForNodeInGroup(nodeID, groupKey1);
            if (iNum != -1) continue;
            nodes.add(nodeID);
        }
        HashSet<String> group2Nodes = new HashSet<String>();
        HashSet<String> linkages = new HashSet<String>();
        Iterator lit = linkIDs.iterator();
        while (lit.hasNext()) {
            String trg;
            String linkID = (String)lit.next();
            boolean added = false;
            Set ids = target.returnLinkInstanceIDsForBacking(linkID);
            if (ids.isEmpty()) {
                linkages.add(linkID);
                added = true;
            } else {
                boolean notThere = true;
                Iterator sit = ids.iterator();
                while (sit.hasNext()) {
                    String instanceID = (String)sit.next();
                    tup = target.getRegionTuple(instanceID);
                    if (!tup.getSourceGroup().equals(groupKey1) || !tup.getTargetGroup().equals(groupKey2)) continue;
                    notThere = false;
                    break;
                }
                if (notThere) {
                    linkages.add(linkID);
                    added = true;
                }
            }
            if (!added) continue;
            Linkage link = rootGenome.getLinkage(linkID);
            String src = link.getSource();
            int iNum = target.getInstanceForNodeInGroup(src, groupKey1);
            if (iNum == -1) {
                nodes.add(src);
            }
            if ((iNum = target.getInstanceForNodeInGroup(trg = link.getTarget(), groupKey2)) != -1) continue;
            if (splitGroups) {
                group2Nodes.add(trg);
                continue;
            }
            nodes.add(trg);
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.propagateElementsDownToGroup");
        Point2D existCentroid = layout.getApproxCenterForGroup(target, groupKey1, false);
        Point2D existOrigCentroid = rootLayout.getApproxCenterForGroup(target, groupKey1, true);
        if (existCentroid == null || existOrigCentroid == null) {
            GroupProperties gp = layout.getGroupProperties(groupKey1);
            existCentroid = gp.getLabelLocation();
            existOrigCentroid = rootLayout.getApproxCenter(rootGenome.getAllNodeIterator());
        }
        Vector2D offset = existCentroid != null && existOrigCentroid != null ? new Vector2D(existOrigCentroid, existCentroid) : new Vector2D(0.0, 0.0);
        Iterator nlit = nodes.iterator();
        while (nlit.hasNext()) {
            String nodeID = (String)nlit.next();
            Node node = rootGenome.getNode(nodeID);
            this.propagateNode(node.getNodeType() == 4, target, (DBNode)node, rootLayout, offset, group1, support);
        }
        Iterator nlit2 = group2Nodes.iterator();
        while (nlit2.hasNext()) {
            String nodeID = (String)nlit2.next();
            Node node = rootGenome.getNode(nodeID);
            this.propagateNode(node.getNodeType() == 4, target, (DBNode)node, rootLayout, offset, group2, support);
        }
        tup = new GenomeInstance.GroupTuple(groupKey1, groupKey2);
        Iterator sit = linkages.iterator();
        while (sit.hasNext()) {
            String lnkKey = (String)sit.next();
            DBLinkage dbLink = (DBLinkage)rootGenome.getLinkage(lnkKey);
            this.propagateLinkage(target, dbLink, rootGenome, rootLayout, tup, frc, support);
        }
        support.addEvent(new ModelChangeEvent(genomeKey, 1));
        support.finish();
        return true;
    }

    public boolean superAddForNode(String nodeID, List superAddPairs) {
        Database db = Database.getDB();
        String rootNodeID = GenomeItemInstance.getBaseID(nodeID);
        HashMap<String, HashSet<String>> groupsPerModel = new HashMap<String, HashSet<String>>();
        int numSAP = superAddPairs.size();
        for (int i = 0; i < numSAP; ++i) {
            SuperAddPair sap = (SuperAddPair)superAddPairs.get(i);
            HashSet<String> groupSet = (HashSet<String>)groupsPerModel.get(sap.genomeID);
            if (groupSet == null) {
                groupSet = new HashSet<String>();
                groupsPerModel.put(sap.genomeID, groupSet);
            }
            groupSet.add(sap.groupID);
        }
        Set models = groupsPerModel.keySet();
        ArrayList<String> orderedModelsToHit = new ArrayList<String>();
        NavTree navTree = db.getNavTree();
        String rootID = db.getGenome().getID();
        List navList = navTree.getPreorderListing(true);
        Iterator nlit = navList.iterator();
        while (nlit.hasNext()) {
            String gkey = (String)nlit.next();
            if (!models.contains(gkey)) continue;
            orderedModelsToHit.add(gkey);
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.superAddNode");
        Genome rootGenome = db.getGenome();
        LayoutManager lm = new LayoutManager();
        Layout rootLayout = db.getLayout(lm.getLayout(rootGenome.getID()));
        int numOM = orderedModelsToHit.size();
        for (int i = 0; i < numOM; ++i) {
            String gKey = (String)orderedModelsToHit.get(i);
            GenomeInstance target = (GenomeInstance)db.getGenome(gKey);
            boolean needLayout = target.getVfgParent() == null;
            HashSet groupSet = (HashSet)groupsPerModel.get(gKey);
            Iterator gsit = groupSet.iterator();
            while (gsit.hasNext()) {
                String groupID = (String)gsit.next();
                if (needLayout) {
                    Layout giLayout = db.getLayout(lm.getLayout(gKey));
                    Point2D existCentroid = giLayout.getApproxCenterForGroup(target, groupID, false);
                    Point2D existOrigCentroid = rootLayout.getApproxCenterForGroup(target, groupID, true);
                    if (existCentroid == null || existOrigCentroid == null) {
                        GroupProperties gp = giLayout.getGroupProperties(groupID);
                        existCentroid = gp.getLabelLocation();
                        existOrigCentroid = rootLayout.getApproxCenter(rootGenome.getAllNodeIterator());
                    }
                    Group targGroup = target.getGroup(groupID);
                    Vector2D offset = existCentroid != null && existOrigCentroid != null ? new Vector2D(existOrigCentroid, existCentroid) : new Vector2D(0.0, 0.0);
                    Node node = rootGenome.getNode(rootNodeID);
                    this.propagateNode(node.getNodeType() == 4, target, (DBNode)node, rootLayout, offset, targGroup, support);
                    continue;
                }
                GenomeInstance rpgi = target.getVfgParentRoot();
                int iNum = rpgi.getInstanceForNodeInGroup(rootNodeID, Group.getBaseID(groupID));
                GenomeInstance pgi = target.getVfgParent();
                String instanceKey = GenomeItemInstance.getCombinedID(rootNodeID, Integer.toString(iNum));
                NodeInstance pNode = (NodeInstance)pgi.getNode(instanceKey);
                this.addNewNodeToSubsetInstance(gKey, pNode, support);
            }
        }
        support.finish();
        return true;
    }

    public Group drawGroupInInstance(String genomeKey, String layoutKey) {
        Database db = Database.getDB();
        Genome genome = db.getGenome();
        if (genome.getID().equals(genomeKey)) {
            return null;
        }
        this.targetGenome_ = db.getGenome(genomeKey);
        GenomeInstance gi = (GenomeInstance)this.targetGenome_;
        Layout targetLayout = db.getLayout(layoutKey);
        this.newHandler_ = new GroupCreationDialogHandler(this.topWindow_, gi, targetLayout, true);
        String groupName = null;
        String groupKey = null;
        if (gi.getVfgParent() == null) {
            groupName = this.newHandler_.handleCreationPartOne();
            if (groupName == null) {
                return null;
            }
        } else {
            GroupCreationDialogHandler.GroupCreationInfo gci = this.newHandler_.handleCreationPartOneForSubsets();
            if (gci == null) {
                return null;
            }
            groupName = gci.name;
            groupKey = gci.oldID;
        }
        if (groupKey != null) {
            this.newGroup_ = new Group(groupKey, groupName);
            this.drawGroupInInstanceFinish(0, 0);
            return null;
        }
        groupKey = gi.getGenome().getNextKey();
        this.newGroup_ = new Group(groupKey, groupName);
        return this.newGroup_;
    }

    public boolean drawGroupInInstanceFinish(int x, int y) {
        GenomeInstance gi = (GenomeInstance)this.targetGenome_;
        UndoSupport support = new UndoSupport(this.undom_, "undo.groupDraw");
        Point2D.Double groupCenter = new Point2D.Double(x, y);
        if (gi.getVfgParent() != null) {
            this.newHandler_.finishSubsetInstanceGroupDraw(support, this.newGroup_, this.newGroup_.getID(), (Point2D)groupCenter);
        } else {
            this.newHandler_.handleCreationPartThree(support, this.newGroup_, this.newGroup_.getID(), (Point2D)groupCenter, null);
        }
        support.finish();
        return true;
    }

    private void duplicateNodes(GenomeInstance targGI, Group toCopy, Group createdGroup, ArrayList genesToCopy, ArrayList nodesToCopy, Layout srcLayout, Vector2D offset, UndoSupport support, Map nodeIDMap) {
        Iterator glit = genesToCopy.iterator();
        while (glit.hasNext()) {
            GeneInstance gene = (GeneInstance)glit.next();
            String newID = this.copyNodeInstance(targGI, gene, true, toCopy, createdGroup, srcLayout, offset, support);
            nodeIDMap.put(gene.getID(), newID);
        }
        Iterator nlit = nodesToCopy.iterator();
        while (nlit.hasNext()) {
            NodeInstance node = (NodeInstance)nlit.next();
            String newID = this.copyNodeInstance(targGI, node, false, toCopy, createdGroup, srcLayout, offset, support);
            nodeIDMap.put(node.getID(), newID);
        }
    }

    private void combineLinksToDuplicate(ArrayList internalLinks, ArrayList inboundLinks, ArrayList outboundLinks, Set combinedLinks) {
        combinedLinks.addAll(internalLinks);
        combinedLinks.addAll(inboundLinks);
        combinedLinks.addAll(outboundLinks);
    }

    private void duplicateAllowedLinks(GenomeInstance srcGI, GenomeInstance targGI, Map createdGroupMap, Set linkCandidates, Layout srcLayout, FontRenderContext frc, Vector2D offset, UndoSupport support) {
        boolean sameModel = srcGI.getID().equals(targGI.getID());
        Iterator lcit = linkCandidates.iterator();
        while (lcit.hasNext()) {
            String trgGrpID;
            String mappedTrgGrpID;
            String linkID = (String)lcit.next();
            GenomeInstance.GroupTuple origTuple = srcGI.getRegionTuple(linkID);
            String srcGrpID = origTuple.getSourceGroup();
            String mappedSrcGrpID = (String)createdGroupMap.get(srcGrpID);
            if (mappedSrcGrpID == null && sameModel) {
                mappedSrcGrpID = srcGrpID;
            }
            if ((mappedTrgGrpID = (String)createdGroupMap.get(trgGrpID = origTuple.getTargetGroup())) == null && sameModel) {
                mappedTrgGrpID = trgGrpID;
            }
            if (mappedSrcGrpID == null || mappedTrgGrpID == null) continue;
            GenomeInstance.GroupTuple tuple = new GenomeInstance.GroupTuple(mappedSrcGrpID, mappedTrgGrpID);
            LinkageInstance link = (LinkageInstance)srcGI.getLinkage(linkID);
            this.copyLinkageInstance(targGI, link, tuple, srcLayout, frc, offset, support);
        }
    }

    private void handleModuleDuplication(GenomeInstance srcGI, GenomeInstance targGI, Layout srcLayout, Layout targetLayout, Map nodeIDMap, String regionID, String createdGroupID, Vector2D offset, UndoSupport support) {
        Database db = Database.getDB();
        Map moduleMap = srcGI.findModulesOwnedByGroup(regionID);
        if (!moduleMap.isEmpty()) {
            DBGenome rootGenome = (DBGenome)db.getGenome();
            HashMap<String, String> groupMap = new HashMap<String, String>();
            HashMap<String, String> modIDMap = new HashMap<String, String>();
            groupMap.put(regionID, createdGroupID);
            Iterator mmkit = moduleMap.keySet().iterator();
            ResourceManager rMan = ResourceManager.getManager();
            while (mmkit.hasNext()) {
                String nokey = (String)mmkit.next();
                NetworkOverlay novr = srcGI.getNetworkOverlay(nokey);
                NetOverlayProperties nop = srcLayout.getNetOverlayProperties(nokey);
                Set modSet = (Set)moduleMap.get(nokey);
                Iterator msit = modSet.iterator();
                while (msit.hasNext()) {
                    NetModuleProperties newNmp;
                    Layout.PropChange pc;
                    String copyName;
                    boolean nameExists;
                    String modID = (String)msit.next();
                    NetModule module = novr.getModule(modID);
                    NetModuleProperties nmp = nop.getNetModuleProperties(modID);
                    String newModID = rootGenome.getNextKey();
                    modIDMap.put(modID, newModID);
                    NetModule newMod = new NetModule(module, newModID, groupMap, nodeIDMap);
                    String form = rMan.getString("duplicateRegion.nameFormat");
                    String currentName = newMod.getName();
                    int count = 1;
                    block2: do {
                        Integer copyNum = new Integer(count++);
                        copyName = MessageFormat.format(form, currentName, copyNum);
                        Iterator moit = novr.getModuleIterator();
                        nameExists = false;
                        while (moit.hasNext()) {
                            NetModule nm = (NetModule)moit.next();
                            if (!DataUtil.keysEqual(nm.getName(), copyName)) continue;
                            nameExists = true;
                            continue block2;
                        }
                    } while (nameExists);
                    newMod.setName(copyName);
                    NetworkOverlayChange noc = targGI.addNetworkModule(nokey, newMod);
                    if (noc != null) {
                        NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(noc);
                        support.addEdit(gcc);
                    }
                    if ((pc = targetLayout.setNetModuleProperties(newModID, newNmp = new NetModuleProperties(nmp, newModID, offset), nokey)) == null) continue;
                    support.addEdit(new PropChangeCmd(pc));
                }
            }
        }
    }

    public boolean duplicateRegion(String genomeKey, String layoutKey, String regionID, FontRenderContext frc) {
        HashSet<String> regionIDs = new HashSet<String>();
        regionIDs.add(regionID);
        return this.duplicateRegions(genomeKey, layoutKey, regionIDs, frc);
    }

    public boolean duplicateRegions(String genomeKey, String layoutKey, Set regionIDs, FontRenderContext frc) {
        GroupCreationDialogHandler.GroupDuplicationInfo cgd;
        int i;
        Database db = Database.getDB();
        Layout srcLayout = db.getLayout(layoutKey);
        Genome srcGenome = db.getGenome(genomeKey);
        if (!(srcGenome instanceof GenomeInstance)) {
            return false;
        }
        GenomeInstance srcGI = (GenomeInstance)srcGenome;
        if (!srcGI.isRootInstance()) {
            return false;
        }
        ModificationCommands mc = new ModificationCommands();
        Map globalPadNeeds = mc.getGlobalNetModuleLinkPadNeeds(frc);
        GroupCreationDialogHandler handler = new GroupCreationDialogHandler(this.topWindow_, srcGI, srcLayout, regionIDs);
        UndoSupport support = new UndoSupport(this.undom_, "undo.duplicateRegion");
        List dupedGroups = handler.handleCopyCreation(support);
        if (dupedGroups == null) {
            return false;
        }
        HashSet combinedLinks = new HashSet();
        HashMap<String, String> createdGroupMap = new HashMap<String, String>();
        Vector2D linkOffset = null;
        int numGroups = dupedGroups.size();
        GenomeInstance targGI = null;
        for (i = 0; i < numGroups; ++i) {
            cgd = (GroupCreationDialogHandler.GroupDuplicationInfo)dupedGroups.get(i);
            if (genomeKey.equals(cgd.targetGiID)) break;
            String srcGroupID = cgd.toCopy.getID();
            Map moduleMap = srcGI.findModulesOwnedByGroup(srcGroupID);
            if (moduleMap.isEmpty()) continue;
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("duplicateRegion.cannotDupModules"), rMan.getString("duplicateRegion.cannotDupModulesTitle"), 2);
            break;
        }
        for (i = 0; i < numGroups; ++i) {
            cgd = (GroupCreationDialogHandler.GroupDuplicationInfo)dupedGroups.get(i);
            targGI = (GenomeInstance)db.getGenome(cgd.targetGiID);
            Group createdGroup = cgd.dupGroup;
            String createdGroupID = createdGroup.getID();
            Layout targetLayout = db.getLayout(new LayoutManager().getLayout(cgd.targetGiID));
            Vector2D offset = cgd.bifg.myOffset;
            if (linkOffset == null) {
                linkOffset = offset;
            }
            HashMap nodeIDMap = new HashMap();
            this.duplicateNodes(targGI, cgd.toCopy, createdGroup, cgd.genesToCopy, cgd.nodesToCopy, srcLayout, offset, support, nodeIDMap);
            if (genomeKey.equals(cgd.targetGiID)) {
                this.handleModuleDuplication(srcGI, targGI, srcLayout, targetLayout, nodeIDMap, cgd.toCopy.getID(), createdGroupID, offset, support);
            }
            createdGroupMap.put(cgd.toCopy.getID(), createdGroupID);
            this.combineLinksToDuplicate(cgd.internalLinks, cgd.inboundLinks, cgd.outboundLinks, combinedLinks);
        }
        this.duplicateAllowedLinks(srcGI, targGI, createdGroupMap, combinedLinks, srcLayout, frc, linkOffset, support);
        mc.repairNetModuleLinkPadsGlobally(globalPadNeeds, frc, false, support);
        support.finish();
        return true;
    }

    public boolean autoPropagateNodeDown(boolean doGene, GenomeInstance target, String selectedGroupID, DBNode node, UndoSupport support) {
        Database db = Database.getDB();
        Genome genome = db.getGenome();
        Layout topLayout = db.getLayout(new LayoutManager().getLayout(genome.getID()));
        Layout targLayout = db.getLayout(new LayoutManager().getLayout(target.getID()));
        Group selectedGroup = target.getGroup(selectedGroupID);
        Point2D existCentroid = targLayout.getApproxCenterForGroup(target, selectedGroupID, false);
        Point2D existOrigCentroid = topLayout.getApproxCenterForGroup(target, selectedGroupID, true);
        Vector2D offset = existCentroid == null || existOrigCentroid == null ? new Vector2D(0.0, 0.0) : new Vector2D(existOrigCentroid, existCentroid);
        this.propagateNode(doGene, target, node, topLayout, offset, selectedGroup, support);
        return true;
    }

    public String copyNodeInstance(GenomeInstance targetGi, NodeInstance node, boolean isGene, Group srcGroup, Group trgGroup, Layout srcLayout, Vector2D offset, UndoSupport support) {
        NodeInstance ni = this.copyNodeInstanceNoLayout(targetGi, node, isGene, srcGroup, trgGroup, support);
        this.propagateNodeLayoutProps(targetGi, node, ni, srcLayout, offset, support);
        return ni.getID();
    }

    public NodeInstance copyNodeInstanceNoLayout(GenomeInstance targetGi, NodeInstance node, boolean isGene, Group srcGroup, Group trgGroup, UndoSupport support) {
        GroupChange grc;
        GenomeChange gc;
        int instanceCount = targetGi.getNextNodeInstanceNumber(GenomeItemInstance.getBaseID(node.getID()));
        NodeInstance newNode = isGene ? new GeneInstance((GeneInstance)node, instanceCount) : new NodeInstance(node, instanceCount);
        GenomeChange genomeChange = gc = isGene ? targetGi.addGene((Gene)((Object)newNode)) : targetGi.addNode(newNode);
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        if ((grc = trgGroup.addMember(new GroupMember(newNode.getID()), targetGi.getID())) != null) {
            GroupChangeCmd grcc = new GroupChangeCmd(grc);
            support.addEdit(grcc);
        }
        support.addEvent(new ModelChangeEvent(targetGi.getID(), 1));
        return newNode;
    }

    public boolean propagateNode(boolean doGene, GenomeInstance gi, DBNode node, Layout layout, Vector2D offset, Group group, UndoSupport support) {
        NodeInstance newNode = this.propagateNodeNoLayout(doGene, gi, node, group, support, null);
        return this.propagateNodeLayoutProps(gi, node, newNode, layout, offset, support);
    }

    public boolean propagateNodeLayoutProps(GenomeInstance targetGi, Node node, Node newNode, Layout srcLayout, Vector2D offset, UndoSupport support) {
        Database db = Database.getDB();
        Layout targetLo = db.getLayout(new LayoutManager().getLayout(targetGi.getID()));
        NodeProperties oldProp = srcLayout.getNodeProperties(node.getID());
        Point2D loc = oldProp.getLocation();
        double xPos = loc.getX() + offset.getX();
        double yPos = loc.getY() + offset.getY();
        NodeProperties newProp = new NodeProperties(targetLo, newNode.getNodeType(), newNode.getID(), xPos, yPos, false);
        newProp.setColor(oldProp.getColorName());
        newProp.setSecondColor(oldProp.getSecondColorName());
        newProp.setOrientation(oldProp.getOrientation());
        this.propagateProperties(db, targetGi, newNode.getNodeType(), newProp, newNode.getID(), support);
        return true;
    }

    public NodeInstance propagateNodeNoLayout(boolean doGene, GenomeInstance gi, DBNode node, Group group, UndoSupport support, String instanceID) {
        return this.propagateOldOrNewNodeNoLayout(doGene, gi, null, node, group, support, instanceID);
    }

    public NodeInstance propagateOldOrNewNodeNoLayout(boolean doGene, GenomeInstance gi, GenomeInstance oldGi, DBNode node, Group group, UndoSupport support, String instanceID) {
        GroupChange grc;
        GenomeChange gc;
        NodeInstance newNode;
        int instanceCount = instanceID == null ? gi.getNextNodeInstanceNumber(node.getID()) : GenomeItemInstance.getInstanceID(instanceID);
        Node oldNode = null;
        if (instanceID != null && oldGi != null) {
            oldNode = oldGi.getNode(GenomeItemInstance.getCombinedID(node.getID(), instanceID));
        }
        if (doGene) {
            newNode = oldNode == null ? new GeneInstance((DBGene)node, instanceCount, null, 0) : new GeneInstance((GeneInstance)oldNode);
            gc = gi.addGene((Gene)((Object)newNode));
        } else {
            newNode = oldNode == null ? new NodeInstance(node, node.getNodeType(), instanceCount, null, 0) : new NodeInstance((NodeInstance)oldNode);
            gc = gi.addNode(newNode);
        }
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        if ((grc = group.addMember(new GroupMember(newNode.getID()), gi.getID())) != null) {
            GroupChangeCmd grcc = new GroupChangeCmd(grc);
            support.addEdit(grcc);
        }
        return newNode;
    }

    private Set resolveLinkages(Intersection inter, Genome genome, Layout layout) {
        HashSet allSet = new HashSet();
        BusProperties lp = layout.getLinkProperties(inter.getObjectID());
        LinkSegmentID[] segIDs = inter.segmentIDsFromIntersect();
        if (segIDs == null) {
            List allLinks = lp.getLinkageList();
            allSet.addAll(allLinks);
            return allSet;
        }
        for (int i = 0; i < segIDs.length; ++i) {
            LinkSegmentID segID = segIDs[i];
            Set resolved = lp.resolveLinkagesThroughSegment(segID, genome);
            allSet.addAll(resolved);
        }
        return allSet;
    }

    private GroupTupleResult calculateGroupTwoTuples(GenomeInstance gi, Set dbLinkages, Group group) {
        Set<GenomeInstance.GroupTuple> retval = null;
        int resultVal = 0;
        boolean haveSomeResults = false;
        HashMap singleTuplePerLink = new HashMap();
        HashSet<String> surviving = new HashSet<String>();
        Iterator sit = dbLinkages.iterator();
        while (sit.hasNext()) {
            String lnkKey = (String)sit.next();
            Set forLink = gi.getNewConnectionTuples(lnkKey);
            if (forLink.isEmpty()) {
                resultVal = 1;
                continue;
            }
            if (forLink.size() == 1) {
                singleTuplePerLink.put(lnkKey, forLink.iterator().next());
            }
            haveSomeResults = true;
            surviving.add(lnkKey);
            if (retval == null) {
                retval = forLink;
                continue;
            }
            retval.retainAll(forLink);
        }
        if (retval == null) {
            retval = new HashSet();
        }
        if (retval.size() == 0) {
            int zeroRet;
            HashMap retMap = null;
            if (haveSomeResults) {
                if (singleTuplePerLink.size() == surviving.size()) {
                    zeroRet = 4;
                    retMap = singleTuplePerLink;
                } else {
                    zeroRet = 2;
                }
            } else {
                zeroRet = 1;
            }
            return new GroupTupleResult(zeroRet, retval, surviving, retMap);
        }
        if (retval.size() == 1) {
            return new GroupTupleResult(0, retval, surviving, null);
        }
        if (group != null) {
            String grid = group.getID();
            GenomeInstance.GroupTuple testTuple = new GenomeInstance.GroupTuple(grid, grid);
            Iterator rit = retval.iterator();
            while (rit.hasNext()) {
                GenomeInstance.GroupTuple gt = (GenomeInstance.GroupTuple)rit.next();
                if (!gt.equals(testTuple)) continue;
                retval = new HashSet();
                retval.add(gt);
                return new GroupTupleResult(resultVal, retval, surviving, null);
            }
            return new GroupTupleResult(3, new HashSet(), surviving, null);
        }
        return new GroupTupleResult(resultVal, retval, surviving, null);
    }

    public boolean propagateLinkage(GenomeInstance gi, DBLinkage link, Genome genome, Layout layout, GenomeInstance.GroupTuple groupTup, FontRenderContext frc, UndoSupport support) {
        LinkageInstance newLink = this.propagateLinkageNoLayout(gi, link, genome, layout, groupTup, support, null);
        String sourceID = link.getSource();
        BusProperties lp = layout.getLinkProperties(link.getID());
        NodeProperties nps = layout.getNodeProperties(sourceID);
        Point2D srcPt = nps.getLocation();
        Database db = Database.getDB();
        String srcLinkID = GenomeItemInstance.getBaseID(link.getID());
        this.downPropagateLinkProperties(db, gi, lp, frc, newLink, srcPt, support, srcLinkID);
        return true;
    }

    public LinkageInstance propagateLinkageNoLayout(GenomeInstance gi, DBLinkage link, Genome genome, Layout layout, GenomeInstance.GroupTuple groupTup, UndoSupport support, String instanceID) {
        return this.propagateOldOrNewLinkageNoLayout(gi, null, link, genome, layout, groupTup, support, instanceID);
    }

    public LinkageInstance propagateOldOrNewLinkageNoLayout(GenomeInstance gi, GenomeInstance oldGi, DBLinkage link, Genome genome, Layout layout, GenomeInstance.GroupTuple groupTup, UndoSupport support, String instanceID) {
        GenomeChange gc;
        LinkageInstance newLink;
        String sourceID = link.getSource();
        String targID = link.getTarget();
        int srcInstance = gi.getInstanceForNodeInGroup(sourceID, groupTup.getSourceGroup());
        int trgInstance = gi.getInstanceForNodeInGroup(targID, groupTup.getTargetGroup());
        String srcID = GenomeItemInstance.getCombinedID(sourceID, Integer.toString(srcInstance));
        Integer srcPad = this.findSourcePad(srcID, link.getLaunchPad(), gi, layout);
        int instanceCount = instanceID == null ? gi.getNextLinkInstanceNumber(link.getID()) : GenomeItemInstance.getInstanceID(instanceID);
        Linkage oldLink = null;
        if (instanceID != null && oldGi != null) {
            oldLink = oldGi.getLinkage(GenomeItemInstance.getCombinedID(link.getID(), instanceID));
        }
        LinkageInstance linkageInstance = newLink = oldLink == null ? new LinkageInstance(link, instanceCount, srcInstance, trgInstance) : new LinkageInstance((LinkageInstance)oldLink);
        if (oldLink == null) {
            if (srcPad != null) {
                newLink.setLaunchPad(srcPad);
            } else {
                this.emergencyPadForce(srcID, gi, support);
                newLink.setLaunchPad(link.getLaunchPad());
            }
            String trgID = GenomeItemInstance.getCombinedID(targID, Integer.toString(trgInstance));
            int landPad = this.findLandingPad(trgID, link.getLandingPad(), gi, layout);
            newLink.setLandingPad(landPad);
        }
        if ((gc = gi.addLinkage(newLink)) != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        return newLink;
    }

    public void emergencyPadForce(String srcID, GenomeInstance gi, UndoSupport support) {
        Iterator git = Database.getDB().getInstanceIterator();
        boolean doGeneral = false;
        while (git.hasNext()) {
            GenomeChange[] gca;
            GenomeInstance cgi = (GenomeInstance)git.next();
            if (!cgi.isAncestor(gi) || (gca = cgi.revertPadsToRoot(srcID)) == null) continue;
            for (int i = 0; i < gca.length; ++i) {
                if (gca[i] == null) continue;
                GenomeChangeCmd gcc = new GenomeChangeCmd(gca[i]);
                support.addEdit(gcc);
                support.addEvent(new ModelChangeEvent(cgi.getID(), 1));
                doGeneral = true;
            }
        }
        if (doGeneral) {
            support.addEvent(new GeneralChangeEvent(1));
        }
    }

    public void copyLinkageInstance(GenomeInstance gi, LinkageInstance link, GenomeInstance.GroupTuple groupTup, Layout layout, FontRenderContext frc, Vector2D offset, UndoSupport support) {
        LinkageInstance li = this.copyLinkageInstanceNoLayout(gi, link, groupTup, support);
        BusProperties lp = layout.getLinkProperties(link.getID());
        lp = (BusProperties)lp.clone();
        String sourceID = link.getSource();
        NodeProperties nps = layout.getNodeProperties(sourceID);
        Point2D srcPt = nps.getLocation();
        Database db = Database.getDB();
        this.downPropagateLinkProperties(db, gi, lp, frc, li, srcPt, support, link.getID());
    }

    public LinkageInstance copyLinkageInstanceNoLayout(GenomeInstance gi, LinkageInstance link, GenomeInstance.GroupTuple groupTup, UndoSupport support) {
        int trgInstance;
        int instanceCount = gi.getNextLinkInstanceNumber(GenomeItemInstance.getBaseID(link.getID()));
        String sourceID = link.getSource();
        String targID = link.getTarget();
        int srcInstance = gi.getInstanceForNodeInGroup(GenomeItemInstance.getBaseID(sourceID), groupTup.getSourceGroup());
        LinkageInstance newLink = new LinkageInstance(link, instanceCount, srcInstance, trgInstance = gi.getInstanceForNodeInGroup(GenomeItemInstance.getBaseID(targID), groupTup.getTargetGroup()));
        GenomeChange gc = gi.addLinkage(newLink);
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        return newLink;
    }

    public Integer findSourcePad(String srcID, int parentSource, GenomeInstance gi, Layout lo) {
        Integer srcPad = gi.getSourcePad(srcID);
        if (srcPad != null) {
            return srcPad;
        }
        Integer psObj = new Integer(parentSource);
        Node node = gi.getNode(srcID);
        INodeRenderer srcRenderer = NodeProperties.chooseRenderer(node.getNodeType(), lo.getLayoutType());
        if (!srcRenderer.sharedPadNamespaces()) {
            return psObj;
        }
        MinMax padRange = srcRenderer.getSourcePadRange(node);
        TreeSet<Integer> srcPads = new TreeSet<Integer>();
        for (int i = padRange.min; i <= padRange.max; ++i) {
            srcPads.add(new Integer(i));
        }
        Iterator lit = gi.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String trg = link.getTarget();
            if (!trg.equals(srcID)) continue;
            int lpad = link.getLandingPad();
            srcPads.remove(new Integer(lpad));
        }
        if (srcPads.isEmpty()) {
            return null;
        }
        if (srcPads.contains(psObj)) {
            return psObj;
        }
        return (Integer)srcPads.first();
    }

    public int findLandingPad(String trgID, int parentTarget, GenomeInstance gi, Layout lo) {
        Node node = gi.getNode(trgID);
        INodeRenderer trgRenderer = NodeProperties.chooseRenderer(node.getNodeType(), lo.getLayoutType());
        if (!trgRenderer.sharedPadNamespaces()) {
            return parentTarget;
        }
        Integer srcPadObj = gi.getSourcePad(trgID);
        if (srcPadObj == null || srcPadObj != parentTarget) {
            return parentTarget;
        }
        int srcPad = srcPadObj;
        MinMax padRange = trgRenderer.getTargetPadRange(node);
        TreeSet<Integer> trgPads = new TreeSet<Integer>();
        for (int i = padRange.min; i <= padRange.max; ++i) {
            trgPads.add(new Integer(i));
        }
        Iterator lit = gi.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String trg = link.getTarget();
            if (!trg.equals(trgID)) continue;
            int lpad = link.getLandingPad();
            trgPads.remove(new Integer(lpad));
        }
        if (trgRenderer.sharedPadNamespaces()) {
            trgPads.remove(new Integer(srcPad));
        }
        if (trgPads.isEmpty()) {
            return srcPad == 0 ? 1 : 0;
        }
        return (Integer)trgPads.first();
    }

    private void wigglePads(Layout lo, DBGenome genome, Map padConstraints, UndoSupport support) {
        Iterator nit = genome.getGeneIterator();
        nit = genome.getNodeIterator();
        this.wigglePadCore(nit, lo, genome, padConstraints, support);
    }

    private void wigglePadCore(Iterator nit, Layout lo, Genome genome, Map padConstraints, UndoSupport support) {
        PadCalculatorToo padCalc = new PadCalculatorToo();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            Map swaps = padCalc.recommendLinkSwaps(genome, node.getID(), lo, padConstraints);
            Iterator skit = swaps.keySet().iterator();
            while (skit.hasNext()) {
                GenomeChangeCmd gcc;
                GenomeChange gc;
                String linkID = (String)skit.next();
                Linkage link = genome.getLinkage(linkID);
                PadCalculatorToo.PadResult pres = (PadCalculatorToo.PadResult)swaps.get(linkID);
                if (pres.launch != link.getLaunchPad() && (gc = genome.changeLinkageSource(link, pres.launch)) != null) {
                    gcc = new GenomeChangeCmd(gc);
                    support.addEdit(gcc);
                }
                if (pres.landing == (link = genome.getLinkage(linkID)).getLandingPad() || (gc = genome.changeLinkageTarget(link, pres.landing)) == null) continue;
                gcc = new GenomeChangeCmd(gc);
                support.addEdit(gcc);
            }
        }
    }

    public void specialtyPadChanges(Map padChanges, Genome genome, UndoSupport support) {
        Iterator pcit = padChanges.keySet().iterator();
        while (pcit.hasNext()) {
            String linkID = (String)pcit.next();
            PadCalculatorToo.PadResult pres = (PadCalculatorToo.PadResult)padChanges.get(linkID);
            Linkage link = genome.getLinkage(linkID);
            String src = link.getSource();
            HashSet<String> allLinks = new HashSet<String>();
            Iterator alit = genome.getLinkageIterator();
            while (alit.hasNext()) {
                Linkage nextLink = (Linkage)alit.next();
                if (!nextLink.getSource().equals(src) || pres.launch == nextLink.getLaunchPad()) continue;
                allLinks.add(nextLink.getID());
            }
            ModificationCommands.changeLinkSourceCore(pres.launch, genome, support, allLinks);
            link = genome.getLinkage(linkID);
            if (pres.landing == link.getLandingPad()) continue;
            ModificationCommands.changeLinkTargetCore(pres.landing, genome, support, linkID);
        }
    }

    public static class AddOverlayResult {
        public boolean changeViz;
        public String overlayID;

        AddOverlayResult(boolean changeViz, String overlayID) {
            this.changeViz = changeViz;
            this.overlayID = overlayID;
        }
    }

    public static class InstanceAndCeiling {
        public String instanceToUse;
        public int propCeiling;

        InstanceAndCeiling(String instanceToUse, int propCeiling) {
            this.instanceToUse = instanceToUse;
            this.propCeiling = propCeiling;
        }
    }

    private class NodeCreationInfo {
        String newName;
        String oldID;
        int newType;
        boolean immediateAdd;
        Set oldIDOptions;
        boolean addToModule;

        NodeCreationInfo(String newName, String oldID, int newType, boolean immediateAdd, Set oldIDOptions, boolean addToModule) {
            this.newName = newName;
            this.oldID = oldID;
            this.newType = newType;
            this.immediateAdd = immediateAdd;
            this.oldIDOptions = oldIDOptions;
            this.addToModule = addToModule;
        }
    }

    private class DirectFixupInfo {
        Layout doLayout;
        Map doLinks;
        Genome genome;

        DirectFixupInfo(Layout doLayout, Genome genome, Map doLinks) {
            this.doLayout = doLayout;
            this.doLinks = doLinks;
            this.genome = genome;
        }
    }

    private class WeightedAverage {
        int count;
        double average;

        WeightedAverage() {
        }

        WeightedAverage(double avg, int count) {
            this.count = count;
            this.average = avg;
        }
    }

    private class GroupTupleResult {
        static final int OK = 0;
        static final int MISSING_ENDPOINT = 1;
        static final int NO_COMMON_GROUPINGS = 2;
        static final int TARGET_GROUP_NOT_PRESENT = 3;
        static final int SINGLE_TUPLE_PER_LINK = 4;
        int result;
        Set set;
        Set survivingLinks;
        Map singleTuplePerLink;

        GroupTupleResult(int result, Set set, Set survivingLinks, Map singleTuplePerLink) {
            this.set = set;
            this.result = result;
            this.survivingLinks = survivingLinks;
            this.singleTuplePerLink = singleTuplePerLink;
        }
    }

    static class ChoiceMap
    implements Comparable {
        String description;
        Object item;

        ChoiceMap(String desc, Object item) {
            this.description = desc;
            this.item = item;
        }

        public String toString() {
            return this.description;
        }

        public int compareTo(Object o) {
            ChoiceMap other = (ChoiceMap)o;
            return this.description.compareToIgnoreCase(other.description);
        }
    }

    public static class SuperAddPair {
        public String genomeID;
        public String groupID;

        public SuperAddPair(String genomeID, String groupID) {
            this.genomeID = genomeID;
            this.groupID = groupID;
        }
    }

    public static class GlobalLinkRequest {
        public Genome genome;
        public Layout layout;
        public Set badLinks;
    }

    public static class NetModuleLinkCandidate {
        public static final int EMPTY = 0;
        public static final int ADDING = 1;
        public static final int DONE = 2;
        public ArrayList points;
        public Intersection source;
        public Intersection target;
        public boolean srcIsModule;
        public int buildState = 0;
        public int sign;
        public String trgMod;
        public String srcMod;
        public String ovrKey;

        public NetModuleLinkCandidate(int sign, String ovrKey) {
            this.sign = sign;
            this.points = new ArrayList();
            this.ovrKey = ovrKey;
        }
    }

    public static class NetModuleCandidate {
        public static final int EMPTY = 0;
        public static final int ADDING = 1;
        public static final int DONE = 2;
        public ArrayList points;
        public int buildState;
        public String name;
        public ArrayList allRects;
        public ArrayList nodes;
        public boolean addNodes;
        public int displayType;
        public boolean keepGoing;
        public boolean attachToGroup;
        public String attachedGroup;

        public NetModuleCandidate(String name, boolean addNodes, int displayType, boolean attachToGroup) {
            this.name = name;
            this.addNodes = addNodes;
            this.displayType = displayType;
            this.attachToGroup = attachToGroup;
            this.buildState = 0;
            this.points = new ArrayList();
            this.nodes = new ArrayList();
            this.allRects = new ArrayList();
            this.keepGoing = displayType != 0;
        }

        public Rectangle2D getCurrentRect(int x, int y) {
            if (this.points.size() == 0) {
                return null;
            }
            Point pt = (Point)this.points.get(0);
            int ulx = pt.x;
            int uly = pt.y;
            int lrx = x;
            int lry = y;
            if (ulx > lrx) {
                ulx = x;
                lrx = pt.x;
            }
            if (uly > lry) {
                uly = y;
                lry = pt.y;
            }
            Rectangle2D.Double retval = new Rectangle2D.Double(ulx, uly, lrx - ulx, lry - uly);
            return retval;
        }
    }

    public static class NetModuleToModify {
        public static final int EMPTY = 0;
        public static final int ADDING = 1;
        public static final int DONE = 2;
        public ArrayList points;
        public String netOverlayID;
        public String netModuleID;
        public ArrayList nodes;
        public boolean addNodes;
        public Color color;
        public int buildState;
        public ArrayList allRects;
        public int displayType;
        public String attachedGroup;

        public NetModuleToModify(String netOverlayID, String netModuleID, int displayType, String attachedGroup, Color currCol) {
            this.netOverlayID = netOverlayID;
            this.netModuleID = netModuleID;
            this.displayType = displayType;
            this.attachedGroup = attachedGroup;
            this.color = currCol;
            this.buildState = 0;
            this.points = new ArrayList();
            this.nodes = new ArrayList();
            this.allRects = new ArrayList();
        }

        public void reset() {
            this.buildState = 0;
            this.points.clear();
            this.nodes.clear();
            this.allRects.clear();
        }

        public Rectangle2D getCurrentRect(int x, int y) {
            if (this.points.size() == 0) {
                return null;
            }
            Point pt = (Point)this.points.get(0);
            int ulx = pt.x;
            int uly = pt.y;
            int lrx = x;
            int lry = y;
            if (ulx > lrx) {
                ulx = x;
                lrx = pt.x;
            }
            if (uly > lry) {
                uly = y;
                lry = pt.y;
            }
            Rectangle2D.Double retval = new Rectangle2D.Double(ulx, uly, lrx - ulx, lry - uly);
            return retval;
        }
    }

    public static class NodeCandidate {
        public Node node;
        public boolean addToModule;
    }

    public static class NoteCandidate {
        public Note newNote;
        public String newNoteColor;
        public FontManager.FontOverride newNoteFont;
        public int justification;

        NoteCandidate(Note newNote, String newNoteColor, FontManager.FontOverride newNoteFont, int justification) {
            this.newNote = newNote;
            this.newNoteColor = newNoteColor;
            this.newNoteFont = newNoteFont;
            this.justification = justification;
        }
    }

    public static class LinkCandidate {
        public static final int EMPTY = 0;
        public static final int ADDING = 1;
        public static final int DONE = 2;
        public ArrayList points = new ArrayList();
        public int buildState = 0;
        public Intersection source;
        public Intersection target;
        public int sign = 0;
        public String label;
        public String srcID;
        public String builtID;
    }
}

