/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.GeneralBuildInstruction;
import org.systemsbiology.biotapestry.cmd.InstructionRegions;
import org.systemsbiology.biotapestry.cmd.LoneNodeBuildInstruction;
import org.systemsbiology.biotapestry.cmd.SignalBuildInstruction;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public abstract class BuildInstruction
implements Cloneable {
    public static final int MIN_NODE_TYPE = 1;
    public static final int MAX_NODE_TYPE = 7;
    protected String id_;
    protected int sourceType_;
    protected String sourceName_;
    protected int targType_;
    protected String targName_;
    protected InstructionRegions regions_;
    protected static final int BASE_TOKENS = 2;

    public BuildInstruction(String id, int sourceType, String sourceName, int targType, String targName) {
        this.id_ = id;
        this.sourceType_ = sourceType;
        this.sourceName_ = sourceName;
        this.targType_ = targType;
        this.targName_ = targName;
        this.regions_ = null;
    }

    public BuildInstruction(BuildInstruction other) {
        this.id_ = other.id_;
        this.sourceType_ = other.sourceType_;
        this.sourceName_ = other.sourceName_;
        this.targType_ = other.targType_;
        this.targName_ = other.targName_;
        this.regions_ = other.regions_ == null ? null : new InstructionRegions(other.regions_);
    }

    public String getID() {
        return this.id_;
    }

    public void setID(String id) {
        this.id_ = id;
    }

    public int getSourceType() {
        return this.sourceType_;
    }

    public void setSourceType(int sourceType) {
        this.sourceType_ = sourceType;
    }

    public String getSourceName() {
        return this.sourceName_;
    }

    public void setSourceName(String sourceName) {
        this.sourceName_ = sourceName;
    }

    public boolean hasTarget() {
        return this.targName_ != null;
    }

    public int getTargType() {
        return this.targType_;
    }

    public void setTargType(int targType) {
        this.targType_ = targType;
    }

    public String getTargName() {
        return this.targName_;
    }

    public void setTargName(String targName) {
        this.targName_ = targName;
    }

    public boolean hasRegions() {
        return this.regions_ != null;
    }

    public InstructionRegions getRegions() {
        return this.regions_;
    }

    public void setRegions(InstructionRegions regions) {
        this.regions_ = regions;
    }

    public Object clone() {
        try {
            BuildInstruction retval = (BuildInstruction)super.clone();
            retval.regions_ = this.regions_ == null ? null : (InstructionRegions)this.regions_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public abstract boolean hasEvidenceLevel();

    public abstract Set getNamedNodes();

    public abstract Set getNamedSourceRegionNodes();

    public abstract Set getNamedTargetRegionNodes();

    public abstract void addMotifs(List var1, Map var2);

    public abstract boolean typesAreConsistent(Map var1);

    protected void typeCheckSupport(String name, int type, Map typeTracker) {
        if (!this.typeChecks(name, type, typeTracker)) {
            throw new IllegalStateException();
        }
    }

    protected boolean typeChecks(String name, int type, Map typeTracker) {
        String norm = DataUtil.normKey(name);
        Integer oldType = (Integer)typeTracker.get(norm);
        if (oldType != null && oldType != type) {
            return false;
        }
        typeTracker.put(norm, new Integer(type));
        return true;
    }

    protected void writeXMLSupport(PrintWriter out, Indenter ind) {
        if (this.regions_ != null) {
            throw new IllegalStateException();
        }
        out.print(" id=\"");
        out.print(this.id_);
        out.print("\" srcName=\"");
        out.print(CharacterEntityMapper.mapEntities(this.sourceName_, false));
        out.print("\" srcType=\"");
        out.print(BuildInstruction.mapToNodeTypeTag(this.sourceType_));
        if (this.targName_ != null) {
            out.print("\" targName=\"");
            out.print(CharacterEntityMapper.mapEntities(this.targName_, false));
            out.print("\" targType=\"");
            out.print(BuildInstruction.mapToNodeTypeTag(this.targType_));
        }
        out.print("\"");
    }

    public abstract void writeXML(PrintWriter var1, Indenter var2);

    public abstract String toCSVString(StringBuffer var1, String var2);

    public boolean sameDefinition(BuildInstruction other) {
        return this.sourceType_ == other.sourceType_ && this.targType_ == other.targType_ && DataUtil.keysEqual(this.sourceName_, other.sourceName_) && (this.targName_ == null && other.targName_ == null || this.targName_ != null && other.targName_ != null && DataUtil.keysEqual(this.targName_, other.targName_));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof BuildInstruction)) {
            return false;
        }
        BuildInstruction otherBI = (BuildInstruction)other;
        if (!this.id_.equals(otherBI.id_)) {
            return false;
        }
        if (!this.sameDefinition(otherBI)) {
            return false;
        }
        if (this.regions_ == null) {
            return otherBI.regions_ == null;
        }
        return this.regions_.equals(otherBI.regions_);
    }

    public String toString() {
        return "BuildInstruction: " + this.id_ + " " + this.sourceType_ + " " + this.sourceName_ + " " + this.targType_ + " " + this.targName_ + " " + this.regions_;
    }

    public abstract String displayStringUI(ResourceManager var1);

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("generalBuildInstruction");
        retval.add("signalBuildInstruction");
        retval.add("loneNodeBuildInstruction");
        return retval;
    }

    public static BuildInstruction buildFromXML(String elemName, Attributes attrs) throws IOException {
        int targType;
        int sourceType;
        if (!(elemName.equals("generalBuildInstruction") || elemName.equals("loneNodeBuildInstruction") || elemName.equals("signalBuildInstruction"))) {
            return null;
        }
        boolean noTargs = elemName.equals("loneNodeBuildInstruction");
        String id = null;
        String sourceTypeStr = null;
        String sourceName = null;
        String targTypeStr = null;
        String targName = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("id")) {
                    id = val;
                    continue;
                }
                if (key.equals("srcType")) {
                    sourceTypeStr = val;
                    continue;
                }
                if (key.equals("srcName")) {
                    sourceName = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("targType")) {
                    targTypeStr = val;
                    continue;
                }
                if (!key.equals("targName")) continue;
                targName = CharacterEntityMapper.unmapEntities(val, false);
            }
        }
        if (sourceTypeStr == null || sourceName == null) {
            throw new IOException();
        }
        if (!(noTargs || targTypeStr != null && targName != null)) {
            throw new IOException();
        }
        try {
            sourceType = BuildInstruction.mapFromNodeTypeTag(sourceTypeStr);
            targType = !noTargs ? BuildInstruction.mapFromNodeTypeTag(targTypeStr) : -1;
        }
        catch (IllegalArgumentException iae) {
            System.err.println("bad map");
            throw new IOException();
        }
        if (elemName.equals("generalBuildInstruction")) {
            return GeneralBuildInstruction.buildFromXML(elemName, attrs, id, sourceType, sourceName, targType, targName);
        }
        if (elemName.equals("signalBuildInstruction")) {
            return SignalBuildInstruction.buildFromXML(elemName, attrs, id, sourceType, sourceName, targType, targName);
        }
        if (elemName.equals("loneNodeBuildInstruction")) {
            return LoneNodeBuildInstruction.buildFromXML(elemName, attrs, id, sourceType, sourceName);
        }
        throw new IllegalStateException();
    }

    public static BuildInstruction buildFromTokens(List tokens, String typeStr, int startIndex, String id) throws IOException {
        BuildInstruction retval;
        int regCount;
        int tokCount;
        int targType;
        int sourceType;
        int baseCount;
        if (!(typeStr.equals("general") || typeStr.equals("nodeOnly") || typeStr.equals("signal"))) {
            throw new IOException();
        }
        if (typeStr.equals("general")) {
            baseCount = 4;
        } else if (typeStr.equals("signal")) {
            baseCount = 4;
        } else if (typeStr.equals("nodeOnly")) {
            baseCount = 2;
        } else {
            throw new IllegalStateException();
        }
        if (tokens.size() < startIndex + baseCount) {
            throw new IOException();
        }
        String sourceTypeStr = ((String)tokens.get(startIndex)).toLowerCase();
        String sourceName = (String)tokens.get(startIndex + 1);
        String targTypeStr = null;
        String targName = null;
        if (baseCount == 4) {
            targTypeStr = ((String)tokens.get(startIndex + 2)).toLowerCase();
            targName = (String)tokens.get(startIndex + 3);
        }
        if (sourceTypeStr == null || sourceName == null) {
            throw new IOException();
        }
        if (baseCount == 4 && (targTypeStr == null || targName == null)) {
            throw new IOException();
        }
        if (sourceTypeStr.trim().equals("")) {
            throw new IOException();
        }
        if (sourceName.trim().equals("")) {
            throw new IOException();
        }
        if (baseCount == 4) {
            if (targTypeStr.trim().equals("")) {
                throw new IOException();
            }
            if (targName.trim().equals("")) {
                throw new IOException();
            }
        }
        try {
            sourceType = BuildInstruction.mapFromNodeTypeTag(sourceTypeStr);
            targType = baseCount == 4 ? BuildInstruction.mapFromNodeTypeTag(targTypeStr) : -1;
        }
        catch (IllegalArgumentException iae) {
            throw new IOException();
        }
        boolean advancedCount = false;
        if (typeStr.equals("general")) {
            tokCount = 1;
            regCount = 2;
            advancedCount = false;
            retval = GeneralBuildInstruction.buildFromCSV(tokens, startIndex, id, sourceType, sourceName, targType, targName);
        } else if (typeStr.equals("signal")) {
            tokCount = 3;
            regCount = 2;
            retval = SignalBuildInstruction.buildFromCSV(tokens, startIndex, id, sourceType, sourceName, targType, targName);
        } else if (typeStr.equals("nodeOnly")) {
            tokCount = 0;
            regCount = 1;
            retval = LoneNodeBuildInstruction.buildFromCSV(tokens, startIndex, id, sourceType, sourceName);
        } else {
            throw new IllegalStateException();
        }
        if (tokens.size() == startIndex + baseCount + tokCount) {
            return retval;
        }
        if (tokens.size() < startIndex + baseCount + tokCount + regCount) {
            throw new IOException();
        }
        String srcRegion = (String)tokens.get(startIndex + baseCount + tokCount);
        String targRegion = regCount > 1 ? (String)tokens.get(startIndex + baseCount + tokCount + 1) : null;
        InstructionRegions ir = new InstructionRegions();
        InstructionRegions.RegionTuple tup = new InstructionRegions.RegionTuple(srcRegion, targRegion);
        ir.addRegionTuple(tup);
        retval.setRegions(ir);
        return retval;
    }

    public static String mapToNodeTypeTag(int val) {
        return val == 4 ? "gene" : DBNode.mapToTag(val);
    }

    public static int mapFromNodeTypeTag(String tag) {
        return tag.equals("gene") ? 4 : DBNode.mapFromTag(tag);
    }
}

