/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.BuildInstruction;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.LinkageInstance;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class BuildInstructionInstance
implements Cloneable {
    private String baseID_;
    private String sourceRegionID_;
    private String targetRegionID_;
    private Double activityLevel_;
    private int activityType_;
    private static final String XML_TAG = "buildInstructionInstance";

    public BuildInstructionInstance(String baseID, String sourceRegionID, String targetRegionID) {
        this.baseID_ = baseID;
        this.sourceRegionID_ = sourceRegionID;
        this.targetRegionID_ = targetRegionID;
        this.activityLevel_ = null;
        this.activityType_ = 0;
    }

    public BuildInstructionInstance(BuildInstructionInstance other) {
        this.baseID_ = other.baseID_;
        this.sourceRegionID_ = other.sourceRegionID_;
        this.targetRegionID_ = other.targetRegionID_;
        this.activityLevel_ = other.activityLevel_;
        this.activityType_ = other.activityType_;
    }

    public Object clone() {
        try {
            BuildInstructionInstance retval = (BuildInstructionInstance)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String getBaseID() {
        return this.baseID_;
    }

    public void setBaseID(String baseID) {
        this.baseID_ = baseID;
    }

    public String getSourceRegionID() {
        return this.sourceRegionID_;
    }

    public void setSourceRegionID(String sourceRegionID) {
        this.sourceRegionID_ = sourceRegionID;
    }

    public String getTargetRegionID() {
        return this.targetRegionID_;
    }

    public boolean hasTargetRegionID() {
        return this.targetRegionID_ != null;
    }

    public void setTargetRegionID(String targetRegionID) {
        this.targetRegionID_ = targetRegionID;
    }

    public String toCSVString(StringBuffer buf, String modelName) {
        BuildInstruction bi = Database.getDB().getBuildInstruction(this.baseID_);
        String base = bi.toCSVString(buf, modelName);
        buf.setLength(0);
        buf.append(base);
        buf.append(",\"");
        buf.append(this.sourceRegionID_);
        buf.append("\"");
        if (this.targetRegionID_ != null) {
            buf.append(",\"");
            buf.append(this.targetRegionID_);
            buf.append("\"");
        }
        return buf.toString();
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<");
        out.print(XML_TAG);
        out.print(" ref=\"");
        out.print(this.baseID_);
        if (this.sourceRegionID_ != null) {
            out.print("\" srcRegion=\"");
            out.print(CharacterEntityMapper.mapEntities(this.sourceRegionID_, false));
        }
        if (this.targetRegionID_ != null) {
            out.print("\" targRegion=\"");
            out.print(CharacterEntityMapper.mapEntities(this.targetRegionID_, false));
        }
        if (this.activityType_ != 0) {
            out.print("\" activity=\"");
            out.print(LinkageInstance.mapActivityTypes(this.activityType_));
        }
        if (this.activityLevel_ != null) {
            out.print("\" activityLevel=\"");
            out.print(this.activityLevel_);
        }
        out.println("\" />");
    }

    public String toString() {
        return "buildInstructionInstance: " + this.baseID_ + " " + this.sourceRegionID_ + " " + this.targetRegionID_ + " " + this.activityType_ + " " + this.activityLevel_;
    }

    public int hashCode() {
        int retval = this.baseID_.hashCode();
        if (this.sourceRegionID_ != null) {
            retval += this.sourceRegionID_.hashCode();
        }
        if (this.targetRegionID_ != null) {
            retval += this.targetRegionID_.hashCode();
        }
        retval += this.activityType_;
        if (this.activityLevel_ != null) {
            retval = (int)((long)retval + Math.round(this.activityLevel_ * 100.0));
        }
        return retval;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof BuildInstructionInstance)) {
            return false;
        }
        BuildInstructionInstance otherBII = (BuildInstructionInstance)other;
        if (!this.baseID_.equals(otherBII.baseID_)) {
            return false;
        }
        if (this.sourceRegionID_ == null ? otherBII.sourceRegionID_ != null : !this.sourceRegionID_.equals(otherBII.sourceRegionID_)) {
            return false;
        }
        if (this.targetRegionID_ == null ? otherBII.targetRegionID_ != null : !this.targetRegionID_.equals(otherBII.targetRegionID_)) {
            return false;
        }
        if (this.activityType_ != otherBII.activityType_) {
            return false;
        }
        if (this.activityType_ == 2) {
            return this.activityLevel_.equals(otherBII.activityLevel_);
        }
        return true;
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(XML_TAG);
        return retval;
    }

    public static BuildInstructionInstance buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals(XML_TAG)) {
            return null;
        }
        String baseID = null;
        String sourceRegionID = null;
        String targetRegionID = null;
        String activityStr = null;
        String activityLevelStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("ref")) {
                    baseID = val;
                    continue;
                }
                if (key.equals("srcRegion")) {
                    sourceRegionID = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("targRegion")) {
                    targetRegionID = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("activity")) {
                    activityStr = val;
                    continue;
                }
                if (!key.equals("activityLevel")) continue;
                activityLevelStr = val;
            }
        }
        if (baseID == null) {
            throw new IOException();
        }
        return new BuildInstructionInstance(baseID, sourceRegionID, targetRegionID);
    }
}

