/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.awt.Dimension;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.BuildInstruction;
import org.systemsbiology.biotapestry.cmd.BuildInstructionInstance;
import org.systemsbiology.biotapestry.cmd.DatabaseChangeCmd;
import org.systemsbiology.biotapestry.cmd.DeleteCommands;
import org.systemsbiology.biotapestry.cmd.DuplicateInstructionTracker;
import org.systemsbiology.biotapestry.cmd.InstanceInstructionSet;
import org.systemsbiology.biotapestry.cmd.InstructionRegions;
import org.systemsbiology.biotapestry.cmd.LoneNodeBuildInstruction;
import org.systemsbiology.biotapestry.cmd.ModificationCommands;
import org.systemsbiology.biotapestry.cmd.ToolCommands;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class BuildInstructionProcessor {
    public List getInstructions(Genome genome) {
        ArrayList retval;
        block5: {
            Database db;
            String key;
            block4: {
                key = genome.getID();
                db = Database.getDB();
                retval = new ArrayList();
                if (!key.equals(db.getGenome().getID())) break block4;
                Iterator biit = db.getBuildInstructions();
                while (biit.hasNext()) {
                    retval.add(biit.next());
                }
                break block5;
            }
            HashMap<String, BuildInstruction> biMap = new HashMap<String, BuildInstruction>();
            HashMap<String, BuildInstruction> newBiMap = new HashMap<String, BuildInstruction>();
            Iterator biit = db.getBuildInstructions();
            while (biit.hasNext()) {
                BuildInstruction bi = (BuildInstruction)biit.next();
                String bid = bi.getID();
                biMap.put(bid, bi);
                BuildInstruction newBi = (BuildInstruction)bi.clone();
                newBi.setRegions(new InstructionRegions());
                newBiMap.put(bid, newBi);
                retval.add(newBi);
            }
            InstanceInstructionSet iis = db.getInstanceInstructionSet(key);
            if (iis == null) break block5;
            Iterator iit = iis.getInstructionIterator();
            while (iit.hasNext()) {
                BuildInstructionInstance bii = (BuildInstructionInstance)iit.next();
                String biid = bii.getBaseID();
                BuildInstruction newBi = (BuildInstruction)newBiMap.get(biid);
                if (newBi == null) {
                    throw new IllegalStateException();
                }
                InstructionRegions ireg = newBi.getRegions();
                ireg.addRegionTuple(new InstructionRegions.RegionTuple(bii.getSourceRegionID(), bii.getTargetRegionID()));
            }
        }
        return retval;
    }

    public void exportInstructions(PrintWriter out) {
        GenomeInstance gi;
        int i;
        Database db = Database.getDB();
        out.println("\"# Model Commands\"");
        ArrayList<String> modelOrder = new ArrayList<String>();
        List ordered = db.getNavTree().getPreorderListing(false);
        Iterator oit = ordered.iterator();
        while (oit.hasNext()) {
            String gkey = (String)oit.next();
            if (DynamicInstanceProxy.isDynamicInstance(gkey)) continue;
            modelOrder.add(gkey);
        }
        int nmo = modelOrder.size();
        for (i = 0; i < nmo; ++i) {
            String modelID = (String)modelOrder.get(i);
            Genome genome = db.getGenome(modelID);
            out.print("\"model\",\"");
            if (i == 0) {
                out.print("root");
                out.print("\"");
                out.println();
                continue;
            }
            gi = (GenomeInstance)genome;
            out.print(gi.getName());
            out.print("\",");
            GenomeInstance pgi = gi.getVfgParent();
            if (pgi == null) {
                out.println("\"root\"");
                continue;
            }
            out.print("\"");
            out.print(pgi.getName());
            out.println("\"");
        }
        out.println();
        out.println("\"# Region Commands\"");
        for (i = 1; i < nmo; ++i) {
            String modID = (String)modelOrder.get(i);
            InstanceInstructionSet iis = db.getInstanceInstructionSet(modID);
            if (iis == null) continue;
            gi = (GenomeInstance)db.getGenome(modID);
            Iterator rit = iis.getRegionIterator();
            while (rit.hasNext()) {
                InstanceInstructionSet.RegionInfo ri = (InstanceInstructionSet.RegionInfo)rit.next();
                out.print("\"region\",\"");
                out.print(gi.getName());
                out.print("\",\"");
                out.print(ri.name);
                out.print("\",\"");
                out.print(ri.abbrev);
                out.println("\"");
            }
        }
        out.println();
        out.println("\"# Root Model Interaction Commands\"");
        StringBuffer buf = new StringBuffer();
        Iterator biit = db.getBuildInstructions();
        while (biit.hasNext()) {
            BuildInstruction bi = (BuildInstruction)biit.next();
            out.println(bi.toCSVString(buf, "root"));
        }
        out.println();
        out.println("\"# Instance Interaction Commands\"");
        for (int i2 = 1; i2 < nmo; ++i2) {
            String modelID = (String)modelOrder.get(i2);
            GenomeInstance gi2 = (GenomeInstance)db.getGenome(modelID);
            String modelName = gi2.getName();
            InstanceInstructionSet iis = db.getInstanceInstructionSet(modelID);
            if (iis != null) {
                Iterator iit = iis.getInstructionIterator();
                while (iit.hasNext()) {
                    BuildInstructionInstance bii = (BuildInstructionInstance)iit.next();
                    bii.getBaseID();
                    out.println(bii.toCSVString(buf, modelName));
                }
            }
            out.println();
        }
    }

    public BuildChanges preProcess(String genomeID, List buildCmds) {
        Database db = Database.getDB();
        if (genomeID.equals(db.getGenome().getID())) {
            BuildChanges retval = new BuildChanges();
            retval.changedParentInstances = null;
            retval.changedChildInstances = null;
            retval.changedSiblingCousinInstances = null;
            retval.needDeletionType = false;
            ArrayList oldList = new ArrayList();
            Iterator biit = db.getBuildInstructions();
            while (biit.hasNext()) {
                oldList.add(biit.next());
            }
            Changes changes = this.compareInstructions(oldList, buildCmds);
            retval.haveNewDuplicates = changes.haveDuplicates;
            retval.haveNewLoneDuplicates = changes.haveLoneDuplicates;
            return retval;
        }
        List held = this.transferToHolders(buildCmds);
        ArrayList rootCmds = new ArrayList();
        InstanceInstructionSet iis = new InstanceInstructionSet(genomeID);
        ArrayList emptyCounts = new ArrayList();
        this.resolveHolders(held, rootCmds, iis, emptyCounts);
        GenomeInstance gi = (GenomeInstance)db.getGenome(genomeID);
        BuildChanges retval = this.scanForChanges(gi, rootCmds, iis);
        return retval;
    }

    public List findInstanceMismatches(List buildCmds) {
        MatchChecker mc;
        Database db = Database.getDB();
        HashMap<String, MatchChecker> checks = new HashMap<String, MatchChecker>();
        Iterator biit = db.getBuildInstructions();
        while (biit.hasNext()) {
            BuildInstruction bi = (BuildInstruction)biit.next();
            String bid = bi.getID();
            MatchChecker mc2 = new MatchChecker(bid, bi);
            checks.put(bid, mc2);
        }
        int size = buildCmds.size();
        for (int i = 0; i < size; ++i) {
            BuildInstruction bi = (BuildInstruction)buildCmds.get(i);
            String bid = bi.getID();
            if (bid.equals("")) continue;
            mc = (MatchChecker)checks.get(bid);
            if (mc == null) {
                throw new IllegalStateException();
            }
            if (bi.sameDefinition(mc.original)) {
                mc.sameCores.add(new Integer(i));
                continue;
            }
            int dcNum = mc.differentCores.size();
            boolean haveMatch = false;
            for (int j = 0; j < dcNum; ++j) {
                CoreInfo ci = (CoreInfo)mc.differentCores.get(j);
                if (!ci.core.sameDefinition(bi)) continue;
                ci.indices.add(new Integer(i));
                haveMatch = true;
                break;
            }
            if (haveMatch) continue;
            mc.differentCores.add(new CoreInfo(i, bi));
        }
        ArrayList<MatchChecker> retval = new ArrayList<MatchChecker>();
        Iterator kit = checks.keySet().iterator();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            mc = (MatchChecker)checks.get(key);
            int dcSize = mc.differentCores.size();
            int scSize = mc.sameCores.size();
            if (dcSize == 0 || scSize == 0 && dcSize == 1) continue;
            retval.add(mc);
        }
        return retval;
    }

    public LinkRouter.RoutingResult processInstructions(String genomeID, ToolCommands tc, List buildCmds, List regions, Point2D center, Dimension size, FontRenderContext frc, boolean keepLayout, boolean hideNames, LayoutOptions options, UndoSupport support, BTProgressMonitor monitor, boolean globalDelete, int dataDeletionAnswer) throws AsynchExitRequestException {
        Database db = Database.getDB();
        double startFrac = 0.1;
        double maxFrac = 1.0;
        int genCount = db.getGenomeCount();
        double perPass = (maxFrac - startFrac) / (double)genCount;
        double midFrac = startFrac + perPass;
        ModificationCommands mc = new ModificationCommands();
        Map globalPadNeeds = mc.getGlobalNetModuleLinkPadNeeds(frc);
        Map emptyModNeeds = mc.stockUpMemberOnlyModules(frc);
        Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        Map sdcCache = tc.buildSdcCache(frc, allKeys);
        boolean doRegions = !genomeID.equals(db.getGenome().getID());
        LinkRouter.RoutingResult result = new LinkRouter.RoutingResult();
        if (!doRegions) {
            int numBC = buildCmds.size();
            for (int i = 0; i < numBC; ++i) {
                BuildInstruction bi = (BuildInstruction)buildCmds.get(i);
                if (!bi.getID().equals("")) continue;
                bi.setID(db.getNextInstructionLabel());
            }
            ArrayList createdPairs = new ArrayList();
            HashMap newNodeToOldNode = new HashMap();
            HashMap newLinksToOldLinks = new HashMap();
            result = tc.buildRootFromInstructions(buildCmds, center, size, frc, keepLayout, hideNames, options, support, monitor, startFrac, midFrac, createdPairs, newNodeToOldNode, newLinksToOldLinks, dataDeletionAnswer, null, null, globalPadNeeds);
            this.applyRootChanges(buildCmds, support, createdPairs, tc, center, size, frc, options, monitor, keepLayout, hideNames, newNodeToOldNode, newLinksToOldLinks, globalPadNeeds, midFrac, maxFrac, dataDeletionAnswer);
        } else {
            InstanceInstructionSet iisOld = db.getInstanceInstructionSet(genomeID);
            if (iisOld == null) {
                iisOld = new InstanceInstructionSet(genomeID);
            }
            List held = this.transferToHolders(buildCmds);
            ArrayList rootCmds = new ArrayList();
            InstanceInstructionSet iis = new InstanceInstructionSet(genomeID);
            ArrayList emptyCounts = new ArrayList();
            this.resolveHolders(held, rootCmds, iis, emptyCounts);
            GenomeInstance gi = (GenomeInstance)db.getGenome(genomeID);
            this.killDeadSubGroups(gi, support);
            result = this.propagateChanges(iisOld, iis, gi, rootCmds, globalDelete, tc, center, size, frc, options, support, monitor, keepLayout, hideNames, startFrac, midFrac, maxFrac, emptyCounts, regions, dataDeletionAnswer, globalPadNeeds);
        }
        mc.repairEmptiedMemberOnlyModules(emptyModNeeds, support);
        mc.repairNetModuleLinkPadsGlobally(globalPadNeeds, frc, false, support);
        tc.processSdcCache(frc, sdcCache, allKeys, support);
        db.clearAllDynamicProxyCaches();
        DeleteCommands dc = new DeleteCommands();
        dc.cleanupDanglingGroupData(support);
        return result;
    }

    public LinkRouter.RoutingResult processInstructionsForFullHierarchy(List processOrder, Map buildCmds, Map regions, ToolCommands tc, Point2D center, Dimension size, FontRenderContext frc, boolean keepLayout, LayoutOptions options, Map nodeIDMap, String dbGenomeCSVName, Map newNodeToOldNode, boolean hideMinorNames, UndoSupport support, BTProgressMonitor monitor, double startFrac, double maxFrac, int dataDeletionAnswer) throws AsynchExitRequestException {
        Database db = Database.getDB();
        LinkRouter.RoutingResult result = new LinkRouter.RoutingResult();
        ModificationCommands mc = new ModificationCommands();
        Map globalPadNeeds = mc.getGlobalNetModuleLinkPadNeeds(frc);
        Map emptyModNeeds = mc.stockUpMemberOnlyModules(frc);
        FullGenomeHierarchyOracle fgho = new FullGenomeHierarchyOracle();
        Map allKeys = fgho.fullModuleKeysPerLayout();
        Map sdcCache = tc.buildSdcCache(frc, allKeys);
        double perPass = (maxFrac - startFrac) / (double)processOrder.size();
        double currStart = startFrac;
        double currFinish = currStart + perPass;
        this.killAllSubGroups(support);
        if (processOrder.size() == 0) {
            return result;
        }
        String rootID = (String)processOrder.get(0);
        ArrayList createdPairs = new ArrayList();
        if (newNodeToOldNode == null) {
            newNodeToOldNode = new HashMap();
        }
        HashMap newLinksToOldLinks = new HashMap();
        List rootCmds = (List)buildCmds.get(rootID);
        result = tc.buildRootFromInstructions(rootCmds, center, size, frc, keepLayout, hideMinorNames, options, support, monitor, currStart, currFinish, createdPairs, newNodeToOldNode, newLinksToOldLinks, dataDeletionAnswer, nodeIDMap, dbGenomeCSVName, globalPadNeeds);
        currStart = currFinish;
        currFinish = currStart + perPass;
        HashMap subsetCache = new HashMap();
        HashMap subsetRegionCache = new HashMap();
        HashMap<String, ToolCommands.LegacyInstanceIdMapper> liidmMap = new HashMap<String, ToolCommands.LegacyInstanceIdMapper>();
        int pNum = processOrder.size();
        for (int i = 1; i < pNum; ++i) {
            String genomeID = (String)processOrder.get(i);
            InstanceInstructionSet iisOld = db.getInstanceInstructionSet(genomeID);
            if (iisOld == null) {
                iisOld = new InstanceInstructionSet(genomeID);
            }
            List cmds = (List)buildCmds.get(genomeID);
            List held = this.transferToHolders(cmds);
            InstanceInstructionSet iis = new InstanceInstructionSet(genomeID);
            ArrayList emptyCounts = new ArrayList();
            this.resolveHolders(held, new ArrayList(), iis, emptyCounts);
            List regionList = (List)regions.get(genomeID);
            iis.replaceRegions(regionList);
            GenomeInstance gi = (GenomeInstance)db.getGenome(genomeID);
            DatabaseChange dc = db.setInstanceInstructionSet(genomeID, iis);
            support.addEdit(new DatabaseChangeCmd(dc));
            if (gi.getVfgParent() == null) {
                ToolCommands.LegacyInstanceIdMapper liidm = new ToolCommands.LegacyInstanceIdMapper(newNodeToOldNode, newLinksToOldLinks);
                liidmMap.put(genomeID, liidm);
                tc.propagateRootUsingInstructions(genomeID, createdPairs, center, size, frc, support, options, monitor, subsetCache, subsetRegionCache, liidm, nodeIDMap, globalPadNeeds, keepLayout, hideMinorNames, currStart, currFinish);
            } else {
                GenomeInstance pgi = gi.getVfgParentRoot();
                ToolCommands.LegacyInstanceIdMapper liidm = (ToolCommands.LegacyInstanceIdMapper)liidmMap.get(pgi.getID());
                tc.populateSubsetUsingInstructions(genomeID, createdPairs, support, liidm, nodeIDMap, subsetCache, subsetRegionCache);
            }
            currStart = currFinish;
            currFinish = currStart + perPass;
        }
        DeleteCommands delc = new DeleteCommands();
        delc.fixupDeletionsInNonInstructionModels(support, dataDeletionAnswer);
        mc.repairEmptiedMemberOnlyModules(emptyModNeeds, support);
        mc.repairNetModuleLinkPadsGlobally(globalPadNeeds, frc, false, support);
        allKeys = fgho.fullModuleKeysPerLayout();
        tc.processSdcCache(frc, sdcCache, allKeys, support);
        db.clearAllDynamicProxyCaches();
        DeleteCommands dc = new DeleteCommands();
        dc.cleanupDanglingGroupData(support);
        return result;
    }

    public LinkRouter.RoutingResult processInstructionsForSIF(List commands, ToolCommands tc, Point2D center, Dimension size, FontRenderContext frc, boolean keepLayout, boolean hideNames, LayoutOptions options, UndoSupport support, BTProgressMonitor monitor, double startFrac, double maxFrac, int dataDeletionAnswer) throws AsynchExitRequestException {
        ArrayList createdPairs = new ArrayList();
        HashMap newNodeToOldNode = new HashMap();
        HashMap newLinksToOldLinks = new HashMap();
        Database db = Database.getDB();
        int genCount = db.getGenomeCount();
        double perPass = (maxFrac - startFrac) / (double)genCount;
        double midFrac = startFrac + perPass;
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        ModificationCommands mc = new ModificationCommands();
        Map globalPadNeeds = mc.getGlobalNetModuleLinkPadNeeds(frc);
        Map emptyModNeeds = mc.stockUpMemberOnlyModules(frc);
        Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        Map sdcCache = tc.buildSdcCache(frc, allKeys);
        LinkRouter.RoutingResult result = tc.buildRootFromInstructions(commands, center, size, frc, keepLayout, hideNames, options, support, monitor, startFrac, midFrac, createdPairs, newNodeToOldNode, newLinksToOldLinks, dataDeletionAnswer, null, null, globalPadNeeds);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        this.applyRootChanges(commands, support, createdPairs, tc, center, size, frc, options, monitor, keepLayout, hideNames, newNodeToOldNode, newLinksToOldLinks, globalPadNeeds, midFrac, maxFrac, dataDeletionAnswer);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        mc.repairEmptiedMemberOnlyModules(emptyModNeeds, support);
        mc.repairNetModuleLinkPadsGlobally(globalPadNeeds, frc, false, support);
        tc.processSdcCache(frc, sdcCache, allKeys, support);
        db.clearAllDynamicProxyCaches();
        return result;
    }

    private LinkRouter.RoutingResult propagateChanges(InstanceInstructionSet iisOld, InstanceInstructionSet iisNew, GenomeInstance gi, List rootCmds, boolean globalDelete, ToolCommands tc, Point2D center, Dimension size, FontRenderContext frc, LayoutOptions options, UndoSupport support, BTProgressMonitor monitor, boolean keepLayout, boolean hideNames, double startFrac, double midFrac, double maxFrac, List emptyCounts, List regions, int dataDeletionAnswer, Map globalPadNeeds) throws AsynchExitRequestException {
        Database db = Database.getDB();
        DatabaseChange dc = db.setBuildInstructions(rootCmds);
        support.addEdit(new DatabaseChangeCmd(dc));
        iisNew.replaceRegions(regions);
        ChangesWithRegions cwr = this.calcInstanceChanges(iisOld, iisNew);
        List procList = this.buildProcessingList(gi, false);
        HashMap subsetCache = new HashMap();
        HashMap subsetRegionCache = new HashMap();
        int pSize = procList.size();
        block6: for (int i = 0; i < pSize; ++i) {
            InstanceToProcess itp = (InstanceToProcess)procList.get(i);
            switch (itp.type) {
                case 2: {
                    dc = db.setInstanceInstructionSet(itp.id, iisNew);
                    support.addEdit(new DatabaseChangeCmd(dc));
                    continue block6;
                }
                case 1: {
                    this.changeParent(itp.id, rootCmds, cwr, globalDelete, support);
                    continue block6;
                }
                case 0: {
                    this.changeChild(itp.id, cwr, support);
                    continue block6;
                }
                case 3: {
                    this.changeCousinOrSibling(itp.id, rootCmds, support);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        DuplicateInstructionTracker dit = new DuplicateInstructionTracker();
        List analysis = dit.analyzeAllCores(gi.getID(), emptyCounts);
        List newCmds = dit.optimize(analysis, procList, support);
        if (newCmds != null) {
            rootCmds = newCmds;
        }
        ArrayList createdPairs = new ArrayList();
        HashMap newNodeToOldNode = new HashMap();
        HashMap newLinksToOldLinks = new HashMap();
        LinkRouter.RoutingResult result = tc.buildRootFromInstructionsNoRootInstall(rootCmds, center, size, frc, keepLayout, hideNames, options, support, monitor, startFrac, midFrac, createdPairs, newNodeToOldNode, newLinksToOldLinks, dataDeletionAnswer, null, null, globalPadNeeds);
        double perPass = pSize == 0 ? maxFrac - midFrac : (maxFrac - midFrac) / (double)pSize;
        double currStart = midFrac;
        double currFinish = currStart + perPass;
        HashMap<String, ToolCommands.LegacyInstanceIdMapper> liidmMap = new HashMap<String, ToolCommands.LegacyInstanceIdMapper>();
        for (int i = 0; i < pSize; ++i) {
            InstanceToProcess itp = (InstanceToProcess)procList.get(i);
            GenomeInstance cgi = (GenomeInstance)db.getGenome(itp.id);
            InstanceInstructionSet iis = db.getInstanceInstructionSet(itp.id);
            if (iis != null) {
                if (cgi.getVfgParent() == null) {
                    ToolCommands.LegacyInstanceIdMapper liidm = new ToolCommands.LegacyInstanceIdMapper(newNodeToOldNode, newLinksToOldLinks);
                    liidmMap.put(cgi.getID(), liidm);
                    tc.propagateRootUsingInstructions(itp.id, createdPairs, center, size, frc, support, options, monitor, subsetCache, subsetRegionCache, liidm, null, globalPadNeeds, keepLayout, hideNames, currStart, currFinish);
                } else {
                    GenomeInstance pgi = cgi.getVfgParentRoot();
                    ToolCommands.LegacyInstanceIdMapper liidm = (ToolCommands.LegacyInstanceIdMapper)liidmMap.get(pgi.getID());
                    tc.populateSubsetUsingInstructions(itp.id, createdPairs, support, liidm, null, subsetCache, subsetRegionCache);
                }
            }
            currStart = currFinish;
            currFinish = currStart + perPass;
        }
        DeleteCommands delc = new DeleteCommands();
        delc.fixupDeletionsInNonInstructionModels(support, dataDeletionAnswer);
        return result;
    }

    private void applyRootChanges(List rootCmds, UndoSupport support, List createdPairs, ToolCommands tc, Point2D center, Dimension size, FontRenderContext frc, LayoutOptions options, BTProgressMonitor monitor, boolean keepLayout, boolean hideNames, Map newNodeToOldNode, Map newLinksToOldLinks, Map globalPadNeeds, double startFrac, double maxFrac, int dataDeletionAnswer) throws AsynchExitRequestException {
        Database db = Database.getDB();
        ArrayList<GenomeInstance> rootList = new ArrayList<GenomeInstance>();
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            GenomeInstance currGi = (GenomeInstance)giit.next();
            String key = currGi.getID();
            this.applyRootDeletions(key, rootCmds, support);
            if (currGi.getVfgParent() != null) continue;
            rootList.add(currGi);
        }
        HashMap<String, ToolCommands.LegacyInstanceIdMapper> liidmMap = new HashMap<String, ToolCommands.LegacyInstanceIdMapper>();
        int numRoot = rootList.size();
        for (int j = 0; j < numRoot; ++j) {
            GenomeInstance gi = (GenomeInstance)rootList.get(j);
            List procList = this.buildProcessingList(gi, true);
            HashMap subsetCache = new HashMap();
            HashMap subsetRegionCache = new HashMap();
            int pSize = procList.size();
            double perPass = pSize == 0 ? maxFrac - startFrac : (maxFrac - startFrac) / (double)pSize;
            double currStart = startFrac;
            double currFinish = currStart + perPass;
            for (int i = 0; i < pSize; ++i) {
                InstanceToProcess itp = (InstanceToProcess)procList.get(i);
                GenomeInstance cgi = (GenomeInstance)db.getGenome(itp.id);
                InstanceInstructionSet iis = db.getInstanceInstructionSet(itp.id);
                if (iis != null) {
                    switch (itp.type) {
                        case 2: {
                            ToolCommands.LegacyInstanceIdMapper liidm = new ToolCommands.LegacyInstanceIdMapper(newNodeToOldNode, newLinksToOldLinks);
                            liidmMap.put(itp.id, liidm);
                            tc.propagateRootUsingInstructions(itp.id, createdPairs, center, size, frc, support, options, monitor, subsetCache, subsetRegionCache, liidm, null, globalPadNeeds, keepLayout, hideNames, currStart, currFinish);
                            break;
                        }
                        case 0: {
                            GenomeInstance pgi = cgi.getVfgParentRoot();
                            ToolCommands.LegacyInstanceIdMapper liidm = (ToolCommands.LegacyInstanceIdMapper)liidmMap.get(pgi.getID());
                            tc.populateSubsetUsingInstructions(itp.id, createdPairs, support, liidm, null, subsetCache, subsetRegionCache);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                currStart = currFinish;
                currFinish = currStart + perPass;
            }
        }
        DeleteCommands delc = new DeleteCommands();
        delc.fixupDeletionsInNonInstructionModels(support, dataDeletionAnswer);
    }

    private void changeChild(String key, ChangesWithRegions cwr, UndoSupport support) {
        Database db = Database.getDB();
        InstanceInstructionSet iis = db.getInstanceInstructionSet(key);
        if (iis == null) {
            return;
        }
        iis = new InstanceInstructionSet(iis);
        Iterator drit = cwr.deletedRegions.iterator();
        while (drit.hasNext()) {
            InstanceInstructionSet.RegionInfo ri = (InstanceInstructionSet.RegionInfo)drit.next();
            iis.deleteRegion(ri.abbrev);
        }
        Iterator dit = cwr.deletedInstruct.iterator();
        while (dit.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)dit.next();
            iis.deleteInstruction(bii);
        }
        DatabaseChange dc = db.setInstanceInstructionSet(key, iis);
        support.addEdit(new DatabaseChangeCmd(dc));
    }

    private void changeParent(String key, List rootCmds, ChangesWithRegions cwr, boolean forceDelete, UndoSupport support) {
        Database db = Database.getDB();
        HashSet<String> cmdIDs = new HashSet<String>();
        int numBC = rootCmds.size();
        for (int i = 0; i < numBC; ++i) {
            BuildInstruction bi = (BuildInstruction)rootCmds.get(i);
            cmdIDs.add(bi.getID());
        }
        InstanceInstructionSet iis = db.getInstanceInstructionSet(key);
        iis = iis == null ? new InstanceInstructionSet(key) : new InstanceInstructionSet(iis);
        HashSet<InstanceInstructionSet.RegionInfo> myRegions = new HashSet<InstanceInstructionSet.RegionInfo>();
        Iterator rit = iis.getRegionIterator();
        while (rit.hasNext()) {
            InstanceInstructionSet.RegionInfo regI = (InstanceInstructionSet.RegionInfo)rit.next();
            myRegions.add(new InstanceInstructionSet.RegionInfo(regI));
        }
        HashSet<BuildInstructionInstance> myInstruct = new HashSet<BuildInstructionInstance>();
        Iterator iit = iis.getInstructionIterator();
        while (iit.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)iit.next();
            myInstruct.add(bii);
        }
        Iterator arit = cwr.addedRegions.iterator();
        while (arit.hasNext()) {
            InstanceInstructionSet.RegionInfo ri = (InstanceInstructionSet.RegionInfo)arit.next();
            if (myRegions.contains(ri)) continue;
            iis.addRegion(new InstanceInstructionSet.RegionInfo(ri));
        }
        Iterator ait = cwr.addedInstruct.iterator();
        while (ait.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)ait.next();
            if (myInstruct.contains(bii)) continue;
            iis.addInstruction(new BuildInstructionInstance(bii));
        }
        if (forceDelete) {
            Iterator drit = cwr.deletedRegions.iterator();
            while (drit.hasNext()) {
                InstanceInstructionSet.RegionInfo ri = (InstanceInstructionSet.RegionInfo)drit.next();
                iis.deleteRegion(ri.abbrev);
            }
        }
        Iterator dit = cwr.deletedInstruct.iterator();
        while (dit.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)dit.next();
            if (!forceDelete) continue;
            iis.deleteInstruction(bii);
        }
        HashSet<String> deadSet = new HashSet<String>();
        Iterator isit = iis.getInstructionIterator();
        while (isit.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)isit.next();
            String baseID = bii.getBaseID();
            if (cmdIDs.contains(baseID)) continue;
            deadSet.add(baseID);
        }
        Iterator dsit = deadSet.iterator();
        while (dsit.hasNext()) {
            String bid = (String)dsit.next();
            iis.deleteInstructions(bid);
        }
        DatabaseChange dc = db.setInstanceInstructionSet(key, iis);
        support.addEdit(new DatabaseChangeCmd(dc));
    }

    private void changeCousinOrSibling(String key, List rootCmds, UndoSupport support) {
        Database db = Database.getDB();
        InstanceInstructionSet iis = db.getInstanceInstructionSet(key);
        if (iis == null) {
            return;
        }
        this.applyRootDeletions(key, rootCmds, support);
    }

    private void applyRootDeletions(String key, List rootCmds, UndoSupport support) {
        Database db = Database.getDB();
        HashSet<String> cmdIDs = new HashSet<String>();
        int numBC = rootCmds.size();
        for (int i = 0; i < numBC; ++i) {
            BuildInstruction bi = (BuildInstruction)rootCmds.get(i);
            cmdIDs.add(bi.getID());
        }
        InstanceInstructionSet iis = db.getInstanceInstructionSet(key);
        if (iis == null) {
            return;
        }
        iis = new InstanceInstructionSet(iis);
        HashSet<BuildInstructionInstance> deadInstruct = new HashSet<BuildInstructionInstance>();
        Iterator iit = iis.getInstructionIterator();
        while (iit.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)iit.next();
            if (cmdIDs.contains(bii.getBaseID())) continue;
            deadInstruct.add(bii);
        }
        Iterator dit = deadInstruct.iterator();
        while (dit.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)dit.next();
            iis.deleteInstruction(bii);
        }
        DatabaseChange dc = db.setInstanceInstructionSet(key, iis);
        support.addEdit(new DatabaseChangeCmd(dc));
    }

    private ChangesWithRegions calcInstanceChanges(InstanceInstructionSet iisOld, InstanceInstructionSet iisNew) {
        ChangesWithRegions cwr = new ChangesWithRegions();
        HashSet<InstanceInstructionSet.RegionInfo> oldRegions = new HashSet<InstanceInstructionSet.RegionInfo>();
        Iterator ori = iisOld.getRegionIterator();
        while (ori.hasNext()) {
            InstanceInstructionSet.RegionInfo regI = (InstanceInstructionSet.RegionInfo)ori.next();
            oldRegions.add(new InstanceInstructionSet.RegionInfo(regI));
        }
        HashSet<InstanceInstructionSet.RegionInfo> newRegions = new HashSet<InstanceInstructionSet.RegionInfo>();
        Iterator nri = iisNew.getRegionIterator();
        while (nri.hasNext()) {
            InstanceInstructionSet.RegionInfo regI = (InstanceInstructionSet.RegionInfo)nri.next();
            newRegions.add(new InstanceInstructionSet.RegionInfo(regI));
        }
        cwr.deletedRegions.addAll(oldRegions);
        cwr.deletedRegions.removeAll(newRegions);
        cwr.addedRegions.addAll(newRegions);
        cwr.addedRegions.removeAll(oldRegions);
        HashSet<BuildInstructionInstance> oldInstruct = new HashSet<BuildInstructionInstance>();
        Iterator oii = iisOld.getInstructionIterator();
        while (oii.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)oii.next();
            oldInstruct.add(bii);
        }
        HashSet<BuildInstructionInstance> newInstruct = new HashSet<BuildInstructionInstance>();
        Iterator nii = iisNew.getInstructionIterator();
        while (nii.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)nii.next();
            newInstruct.add(bii);
        }
        cwr.deletedInstruct.addAll(oldInstruct);
        cwr.deletedInstruct.removeAll(newInstruct);
        cwr.addedInstruct.addAll(newInstruct);
        cwr.addedInstruct.removeAll(oldInstruct);
        return cwr;
    }

    private void resolveHolders(List holders, List rootCmds, InstanceInstructionSet iis, List emptyCounts) {
        InstructionHolder ihold;
        int i;
        int hSize = holders.size();
        for (i = 0; i < hSize; ++i) {
            ihold = (InstructionHolder)holders.get(i);
            if (ihold.unassigned.getNumTuples() != 0) {
                InstructionRegions ua = ihold.unassigned;
                Iterator rtit = ua.getRegionTuples();
                while (rtit.hasNext()) {
                    InstructionRegions.RegionTuple tup = (InstructionRegions.RegionTuple)rtit.next();
                    this.pushToAssigned(ihold, tup);
                }
            }
            ihold.unassigned = new InstructionRegions();
        }
        for (i = 0; i < hSize; ++i) {
            ihold = (InstructionHolder)holders.get(i);
            Iterator arkit = ihold.assignedRegions.keySet().iterator();
            while (arkit.hasNext()) {
                String key = (String)arkit.next();
                InstructionRegions iReg = (InstructionRegions)ihold.assignedRegions.get(key);
                BuildInstruction abi = (BuildInstruction)ihold.coreInstruct.clone();
                abi.setID(key);
                rootCmds.add(abi);
                if (iReg.getNumTuples() == 0) {
                    throw new IllegalStateException();
                }
                Iterator irit = iReg.getRegionTuples();
                while (irit.hasNext()) {
                    InstructionRegions.RegionTuple tup = (InstructionRegions.RegionTuple)irit.next();
                    BuildInstructionInstance bii = new BuildInstructionInstance(key, tup.sourceRegion, tup.targetRegion);
                    iis.addInstruction(bii);
                }
            }
            Iterator aekit = ihold.assignedEmpty.keySet().iterator();
            int totalNeeded = 0;
            HashSet<String> available = new HashSet<String>();
            while (aekit.hasNext()) {
                String key = (String)aekit.next();
                Integer needed = (Integer)ihold.assignedEmpty.get(key);
                InstructionRegions iReg = (InstructionRegions)ihold.assignedRegions.get(key);
                if (iReg == null) {
                    available.add(key);
                }
                totalNeeded += needed.intValue();
            }
            int remainingEmpties = totalNeeded + ihold.emptyUnassigned;
            DuplicateInstructionTracker.CoreCount count = new DuplicateInstructionTracker.CoreCount((BuildInstruction)ihold.coreInstruct.clone(), remainingEmpties);
            emptyCounts.add(count);
            Iterator avit = available.iterator();
            while (avit.hasNext()) {
                String key = (String)avit.next();
                if (remainingEmpties == 0) break;
                BuildInstruction abi = (BuildInstruction)ihold.coreInstruct.clone();
                abi.setID(key);
                rootCmds.add(abi);
                --remainingEmpties;
            }
            for (int j = 0; j < remainingEmpties; ++j) {
                String instrID = Database.getDB().getNextInstructionLabel();
                BuildInstruction abi = (BuildInstruction)ihold.coreInstruct.clone();
                abi.setID(instrID);
                rootCmds.add(abi);
            }
        }
    }

    private void pushToAssigned(InstructionHolder ihold, InstructionRegions.RegionTuple tup) {
        Iterator arkit = ihold.assignedRegions.keySet().iterator();
        while (arkit.hasNext()) {
            String key = (String)arkit.next();
            InstructionRegions iReg = (InstructionRegions)ihold.assignedRegions.get(key);
            if (iReg.hasTuple(tup)) continue;
            iReg.addRegionTuple(new InstructionRegions.RegionTuple(tup));
            return;
        }
        String instrID = Database.getDB().getNextInstructionLabel();
        InstructionRegions newIR = new InstructionRegions();
        newIR.addRegionTuple(new InstructionRegions.RegionTuple(tup));
        ihold.assignedRegions.put(instrID, newIR);
    }

    private List transferToHolders(List buildCmds) {
        ArrayList<InstructionHolder> held = new ArrayList<InstructionHolder>();
        int bcSize = buildCmds.size();
        for (int i = 0; i < bcSize; ++i) {
            BuildInstruction bi = (BuildInstruction)buildCmds.get(i);
            int heldNum = held.size();
            boolean found = false;
            for (int j = 0; j < heldNum; ++j) {
                InstructionHolder ihold = (InstructionHolder)held.get(j);
                if (!ihold.coreInstruct.sameDefinition(bi)) continue;
                this.mergeInstructions(ihold, bi);
                found = true;
                break;
            }
            if (found) continue;
            held.add(new InstructionHolder(bi));
        }
        return held;
    }

    private void mergeInstructions(InstructionHolder ihold, BuildInstruction bi) {
        InstructionRegions biir = bi.getRegions();
        if (biir == null) {
            throw new IllegalArgumentException();
        }
        String instrID = bi.getID();
        if (instrID.equals("")) {
            if (biir.getNumTuples() == 0) {
                ++ihold.emptyUnassigned;
            } else {
                ihold.unassigned.merge(biir);
            }
        } else if (biir.getNumTuples() == 0) {
            Integer emptyCount = (Integer)ihold.assignedEmpty.get(instrID);
            int newCount = emptyCount == null ? 1 : emptyCount + 1;
            ihold.assignedEmpty.put(instrID, new Integer(newCount));
        } else {
            InstructionRegions toCheck = (InstructionRegions)ihold.assignedRegions.get(instrID);
            if (toCheck == null) {
                toCheck = new InstructionRegions(biir);
                ihold.assignedRegions.put(instrID, toCheck);
            } else {
                toCheck.mergeUniquely(biir, ihold.unassigned);
            }
            if (toCheck.hasDuplicates()) {
                throw new IllegalStateException();
            }
        }
    }

    private BuildChanges scanForChanges(GenomeInstance gi, List newList, InstanceInstructionSet newIis) {
        InstanceInstructionSet oldIis;
        BuildChanges retval = new BuildChanges();
        retval.changedParentInstances = new HashSet();
        retval.changedChildInstances = new HashSet();
        retval.changedSiblingCousinInstances = new HashSet();
        retval.needDeletionType = false;
        ArrayList oldList = new ArrayList();
        Database db = Database.getDB();
        Iterator biit = db.getBuildInstructions();
        while (biit.hasNext()) {
            oldList.add(biit.next());
        }
        Changes changes = this.compareInstructions(oldList, newList);
        retval.haveNewDuplicates = changes.haveDuplicates;
        retval.haveNewLoneDuplicates = changes.haveLoneDuplicates;
        String myKey = gi.getID();
        retval.needDeletionType = false;
        if (gi.getVfgParent() != null && this.regionLost(oldIis = db.getInstanceInstructionSet(myKey), newIis, newList)) {
            retval.needDeletionType = true;
        }
        List procList = this.buildProcessingList(gi, false);
        int pSize = procList.size();
        block6: for (int i = 0; i < pSize; ++i) {
            InstanceToProcess itp = (InstanceToProcess)procList.get(i);
            InstanceInstructionSet iis = db.getInstanceInstructionSet(itp.id);
            if (itp.type == 2 || !this.changeIsImportant(iis, changes)) continue;
            switch (itp.type) {
                case 1: {
                    retval.changedParentInstances.add(itp.id);
                    continue block6;
                }
                case 0: {
                    retval.changedChildInstances.add(itp.id);
                    continue block6;
                }
                case 3: {
                    retval.changedSiblingCousinInstances.add(itp.id);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return retval;
    }

    private Changes compareInstructions(List oldList, List newList) {
        HashMap<String, BuildInstruction> oldInstr = new HashMap<String, BuildInstruction>();
        int oSize = oldList.size();
        for (int i = 0; i < oSize; ++i) {
            BuildInstruction bi = (BuildInstruction)oldList.get(i);
            oldInstr.put(bi.getID(), bi);
        }
        Set oldIDs = oldInstr.keySet();
        HashMap<String, BuildInstruction> newInstr = new HashMap<String, BuildInstruction>();
        int nSize = newList.size();
        for (int i = 0; i < nSize; ++i) {
            BuildInstruction bi = (BuildInstruction)newList.get(i);
            newInstr.put(bi.getID(), bi);
        }
        Set newIDs = newInstr.keySet();
        Changes retval = new Changes();
        retval.deletions.addAll(oldIDs);
        retval.deletions.removeAll(newIDs);
        retval.additions.addAll(newIDs);
        retval.additions.removeAll(oldIDs);
        HashSet sharedIDs = new HashSet(oldIDs);
        sharedIDs.retainAll(newIDs);
        Iterator siit = sharedIDs.iterator();
        while (siit.hasNext()) {
            BuildInstruction nbi;
            String key = (String)siit.next();
            BuildInstruction obi = (BuildInstruction)oldInstr.get(key);
            if (obi.equals(nbi = (BuildInstruction)newInstr.get(key))) continue;
            retval.edits.add(key);
        }
        retval.haveDuplicates = false;
        Set newDups = this.getDuplicates(newList);
        if (!newDups.isEmpty()) {
            Set oldDups = this.getDuplicates(oldList);
            newDups.removeAll(oldDups);
            if (!newDups.isEmpty()) {
                retval.haveDuplicates = true;
            }
        }
        retval.haveLoneDuplicates = false;
        Set newLoneDups = this.getDuplicatedLoneNodes(newList);
        if (!newLoneDups.isEmpty()) {
            Set oldLoneDups = this.getDuplicatedLoneNodes(oldList);
            newLoneDups.removeAll(oldLoneDups);
            if (!newLoneDups.isEmpty()) {
                retval.haveLoneDuplicates = true;
            }
        }
        return retval;
    }

    private Set getDuplicates(List biList) {
        int biSize = biList.size();
        HashSet<String> retval = new HashSet<String>();
        for (int i = 0; i < biSize; ++i) {
            BuildInstruction bi1 = (BuildInstruction)biList.get(i);
            if (bi1 instanceof LoneNodeBuildInstruction) continue;
            for (int j = 0; j < biSize; ++j) {
                BuildInstruction bi2;
                if (j == i || (bi2 = (BuildInstruction)biList.get(j)) instanceof LoneNodeBuildInstruction || !bi1.sameDefinition(bi2)) continue;
                retval.add(bi1.getID());
                retval.add(bi2.getID());
            }
        }
        return retval;
    }

    private Set getSuperfluousLoneNodes(List biList) {
        int biSize = biList.size();
        HashSet loneNodes = new HashSet();
        HashSet otherNodes = new HashSet();
        for (int i = 0; i < biSize; ++i) {
            BuildInstruction bi = (BuildInstruction)biList.get(i);
            if (bi instanceof LoneNodeBuildInstruction) {
                loneNodes.addAll(DataUtil.normalizeList(new ArrayList(bi.getNamedNodes())));
                continue;
            }
            otherNodes.addAll(DataUtil.normalizeList(new ArrayList(bi.getNamedNodes())));
        }
        HashSet retval = new HashSet(loneNodes);
        retval.retainAll(otherNodes);
        return retval;
    }

    private Set getSuperfluousLoneNodesWithRegionContext(InstanceInstructionSet iis, Set loneCands, List buildInst) {
        if (iis == null) {
            return new HashSet();
        }
        HashMap<String, BuildInstruction> biMap = new HashMap<String, BuildInstruction>();
        Iterator biit = buildInst.iterator();
        while (biit.hasNext()) {
            BuildInstruction bi = (BuildInstruction)biit.next();
            String bid = bi.getID();
            biMap.put(bid, bi);
        }
        HashMap regionMap = new HashMap();
        HashMap loneRegionMap = new HashMap();
        Iterator iit = iis.getInstructionIterator();
        while (iit.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)iit.next();
            String biid = bii.getBaseID();
            BuildInstruction bi = (BuildInstruction)biMap.get(biid);
            HashMap useMap = bi instanceof LoneNodeBuildInstruction ? loneRegionMap : regionMap;
            List srcRegionNodes = DataUtil.normalizeList(new ArrayList(bi.getNamedSourceRegionNodes()));
            String srcReg = bii.getSourceRegionID();
            HashSet nodesPerReg = (HashSet)useMap.get(srcReg);
            if (nodesPerReg == null) {
                nodesPerReg = new HashSet();
                useMap.put(srcReg, nodesPerReg);
            }
            nodesPerReg.addAll(srcRegionNodes);
            List trgRegionNodes = DataUtil.normalizeList(new ArrayList(bi.getNamedTargetRegionNodes()));
            String trgReg = bii.getTargetRegionID();
            if (trgReg == null) continue;
            nodesPerReg = (HashSet)useMap.get(trgReg);
            if (nodesPerReg == null) {
                nodesPerReg = new HashSet();
                useMap.put(trgReg, nodesPerReg);
            }
            nodesPerReg.addAll(trgRegionNodes);
        }
        HashSet retval = new HashSet(loneCands);
        Iterator lrmkit = loneRegionMap.keySet().iterator();
        while (lrmkit.hasNext()) {
            String regID = (String)lrmkit.next();
            HashSet lones = (HashSet)loneRegionMap.get(regID);
            HashSet nonLones = (HashSet)regionMap.get(regID);
            if (nonLones == null) {
                retval.removeAll(lones);
                continue;
            }
            HashSet diffs = new HashSet(lones);
            diffs.removeAll(nonLones);
            retval.removeAll(diffs);
        }
        return retval;
    }

    private Set getDuplicatedLoneNodes(List biList) {
        int biSize = biList.size();
        HashSet<String> retval = new HashSet<String>();
        for (int i = 0; i < biSize; ++i) {
            BuildInstruction bi1 = (BuildInstruction)biList.get(i);
            if (!(bi1 instanceof LoneNodeBuildInstruction)) continue;
            for (int j = 0; j < biSize; ++j) {
                if (j == i) continue;
                BuildInstruction bi2 = (BuildInstruction)biList.get(j);
                if (!(bi1 instanceof LoneNodeBuildInstruction) || !bi1.sameDefinition(bi2)) continue;
                retval.add(bi1.getID());
                retval.add(bi2.getID());
            }
        }
        return retval;
    }

    private boolean changeIsImportant(InstanceInstructionSet iis, Changes changes) {
        if (iis == null) {
            return true;
        }
        Iterator iit = iis.getInstructionIterator();
        while (iit.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)iit.next();
            String biid = bii.getBaseID();
            if (changes.deletions.contains(biid)) {
                return true;
            }
            if (!changes.edits.contains(biid)) continue;
            return true;
        }
        return false;
    }

    private boolean regionLost(InstanceInstructionSet oldIis, InstanceInstructionSet newIis, List newInst) {
        if (oldIis == null) {
            return false;
        }
        Iterator oiit = oldIis.getInstructionIterator();
        while (oiit.hasNext()) {
            BuildInstructionInstance obii = (BuildInstructionInstance)oiit.next();
            boolean stillAround = false;
            Iterator niit = newIis.getInstructionIterator();
            while (niit.hasNext()) {
                BuildInstructionInstance nbii = (BuildInstructionInstance)niit.next();
                if (!nbii.equals(obii)) continue;
                stillAround = true;
                break;
            }
            if (stillAround) continue;
            String id = obii.getBaseID();
            int nSize = newInst.size();
            for (int i = 0; i < nSize; ++i) {
                BuildInstruction bi = (BuildInstruction)newInst.get(i);
                String bid = bi.getID();
                if (bid == null || !bid.equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    private List buildProcessingList(GenomeInstance gi, boolean onlySelfAndKids) {
        ArrayList retval = new ArrayList();
        Database db = Database.getDB();
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            GenomeInstance currGi = (GenomeInstance)giit.next();
            this.buildProcessingListCore(gi, currGi, retval, onlySelfAndKids);
        }
        return retval;
    }

    private void buildProcessingListCore(GenomeInstance orig, GenomeInstance gi, List theList, boolean onlySelfAndKids) {
        String giID = gi.getID();
        int size = theList.size();
        for (int i = 0; i < size; ++i) {
            InstanceToProcess itp = (InstanceToProcess)theList.get(i);
            if (!itp.id.equals(giID)) continue;
            return;
        }
        GenomeInstance parent = gi.getVfgParent();
        if (parent != null) {
            this.buildProcessingListCore(orig, parent, theList, onlySelfAndKids);
        }
        if (giID.equals(orig.getID())) {
            theList.add(new InstanceToProcess(giID, 2));
        } else if (gi.isAncestor(orig) && !onlySelfAndKids) {
            theList.add(new InstanceToProcess(giID, 1));
        } else if (orig.isAncestor(gi)) {
            theList.add(new InstanceToProcess(giID, 0));
        } else if (!onlySelfAndKids) {
            theList.add(new InstanceToProcess(giID, 3));
        }
    }

    private void killDeadSubGroups(GenomeInstance current, UndoSupport support) {
        Set models = this.getInstructionDependentRootInstances();
        if (current != null) {
            GenomeInstance rootGI = current.getVfgParentRoot();
            if (rootGI == null) {
                models.add(current.getID());
            } else {
                models.add(rootGI.getID());
            }
        }
        Database db = Database.getDB();
        DeleteCommands dc = new DeleteCommands();
        Iterator mit = models.iterator();
        while (mit.hasNext()) {
            String id = (String)mit.next();
            GenomeInstance gi = (GenomeInstance)db.getGenome(id);
            Set subs = gi.getAllSubsets();
            Iterator sit = subs.iterator();
            while (sit.hasNext()) {
                String subID = (String)sit.next();
                dc.deleteSubGroupFromModel(subID, id, support);
            }
        }
    }

    private void killAllSubGroups(UndoSupport support) {
        Database db = Database.getDB();
        HashSet<GenomeInstance> models = new HashSet<GenomeInstance>();
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (gi.getVfgParent() != null) continue;
            models.add(gi);
        }
        DeleteCommands dc = new DeleteCommands();
        Iterator mit = models.iterator();
        while (mit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)mit.next();
            Set subs = gi.getAllSubsets();
            Iterator sit = subs.iterator();
            while (sit.hasNext()) {
                String subID = (String)sit.next();
                dc.deleteSubGroupFromModel(subID, gi.getID(), support);
            }
        }
    }

    private Set getInstructionDependentRootInstances() {
        Database db = Database.getDB();
        HashSet<String> models = new HashSet<String>();
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            String giid;
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (gi.getVfgParent() != null || db.getInstanceInstructionSet(giid = gi.getID()) == null) continue;
            models.add(giid);
        }
        return models;
    }

    private void getInstructionDependentModelsAndProxies(Set models, Set proxies) {
        GenomeInstance gi;
        Database db = Database.getDB();
        boolean rootUses = db.haveBuildInstructions();
        HashSet<String> pending = new HashSet<String>();
        HashSet<String> done = new HashSet<String>();
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi2 = (GenomeInstance)iit.next();
            String giid = gi2.getID();
            if (rootUses || db.getInstanceInstructionSet(giid) != null) {
                models.add(giid);
                done.add(giid);
                continue;
            }
            if (gi2.getVfgParent() == null) {
                done.add(giid);
                continue;
            }
            pending.add(giid);
        }
        block1: while (pending.size() > 0) {
            Iterator pit = pending.iterator();
            while (pit.hasNext()) {
                String pID;
                String pendID = (String)pit.next();
                gi = (GenomeInstance)db.getGenome(pendID);
                GenomeInstance parent = gi.getVfgParent();
                if (parent == null || !done.contains(pID = parent.getID())) continue;
                if (models.contains(pID)) {
                    models.add(pendID);
                }
                pending.remove(pendID);
                done.add(pendID);
                continue block1;
            }
        }
        Iterator dpit = db.getDynamicProxyIterator();
        while (dpit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dpit.next();
            gi = dip.getStaticVfgParent();
            if (!models.contains(gi.getID())) continue;
            proxies.add(dip.getID());
        }
    }

    private static class ChangesWithRegions {
        HashSet addedRegions = new HashSet();
        HashSet deletedRegions = new HashSet();
        HashSet addedInstruct = new HashSet();
        HashSet deletedInstruct = new HashSet();

        ChangesWithRegions() {
        }
    }

    private static class Changes {
        HashSet additions = new HashSet();
        HashSet deletions = new HashSet();
        HashSet edits = new HashSet();
        boolean haveDuplicates = false;
        boolean haveLoneDuplicates = false;

        Changes() {
        }
    }

    private static class InstructionHolder {
        BuildInstruction coreInstruct;
        InstructionRegions unassigned;
        HashMap assignedRegions = new HashMap();
        HashMap assignedEmpty = new HashMap();
        int emptyUnassigned;

        InstructionHolder(BuildInstruction instruct) {
            String instrID = instruct.getID();
            InstructionRegions iReg = new InstructionRegions(instruct.getRegions());
            if (instrID.equals("")) {
                this.unassigned = iReg;
                this.emptyUnassigned = iReg.getNumTuples() == 0 ? 1 : 0;
            } else {
                this.unassigned = new InstructionRegions();
                this.emptyUnassigned = 0;
                if (iReg.getNumTuples() > 0) {
                    this.assignedRegions.put(instrID, iReg);
                } else {
                    this.assignedEmpty.put(instrID, new Integer(1));
                }
            }
            this.coreInstruct = (BuildInstruction)instruct.clone();
            this.coreInstruct.setID(null);
            this.coreInstruct.setRegions(null);
        }

        public String toString() {
            StringBuffer retval = new StringBuffer();
            retval.append("InstructionHolder: instruction = ");
            retval.append(this.coreInstruct);
            retval.append("\nunassigned: \n");
            retval.append(this.unassigned);
            retval.append("\n");
            Iterator mit = this.assignedRegions.keySet().iterator();
            while (mit.hasNext()) {
                String key = (String)mit.next();
                retval.append("unempty instrID: ");
                retval.append(key);
                retval.append(" : ");
                retval.append(this.assignedRegions.get(key));
                retval.append("\n");
            }
            Iterator eit = this.assignedEmpty.keySet().iterator();
            while (eit.hasNext()) {
                String key = (String)eit.next();
                retval.append("empty instrID: ");
                retval.append(key);
                retval.append(" : ");
                retval.append(this.assignedEmpty.get(key));
                retval.append("\n");
            }
            retval.append("\nempty unassigned: \n");
            retval.append(this.emptyUnassigned);
            retval.append("\n");
            return retval.toString();
        }
    }

    public static class InstanceToProcess {
        static final int CHILD = 0;
        static final int PARENT = 1;
        static final int SELF = 2;
        static final int COUSIN_OR_SIBLING = 3;
        String id;
        int type;

        InstanceToProcess(String id, int type) {
            this.id = id;
            this.type = type;
        }
    }

    public static class CoreInfo {
        public List indices = new ArrayList();
        public BuildInstruction core;

        CoreInfo(int index, BuildInstruction core) {
            this.indices.add(new Integer(index));
            this.core = core;
        }

        CoreInfo(BuildInstruction core) {
            this.core = core;
        }
    }

    public static class MatchChecker {
        public String instanceID;
        public BuildInstruction original;
        public List sameCores;
        public List differentCores;

        MatchChecker(String instanceID, BuildInstruction original) {
            this.instanceID = instanceID;
            this.original = original;
            this.sameCores = new ArrayList();
            this.differentCores = new ArrayList();
        }
    }

    public static final class BuildChanges {
        public List deletions;
        public boolean needDeletionType;
        public Set changedParentInstances;
        public Set changedChildInstances;
        public Set changedSiblingCousinInstances;
        public boolean haveNewDuplicates;
        public boolean haveNewLoneDuplicates;
    }
}

