/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.gaggle.GooseAppInterface;
import org.systemsbiology.biotapestry.gaggle.GooseManager;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.SUPanel;

public class CheckGutsCache {
    public static final int NONE = 0;
    public static final int LAYOUT = 1;
    public static final int MODEL = 2;
    public static final int SELECT = 3;
    public static final int GENERAL = 4;
    public static final int OVERLAY = 5;
    private int type_;
    private Genome genome_;
    private CommonView suw_;
    private Integer genomeCount_;
    private Boolean gaggleIsActive_;
    private Boolean showingModule_;
    private Boolean overlayExists_;
    private Boolean hasSelection_;
    private Boolean hasMultiSelections_;
    private Boolean hasAGroup_;
    private Boolean hasANode_;
    private Boolean hasALink_;
    private Boolean hasAModule_;
    private Boolean linksHidden_;

    public CheckGutsCache(Genome genome, int type, CommonView suw) {
        this.genome_ = genome;
        this.type_ = type;
        this.suw_ = suw;
        this.genomeCount_ = null;
        this.gaggleIsActive_ = null;
        this.showingModule_ = null;
        this.overlayExists_ = null;
        this.hasSelection_ = null;
        this.hasMultiSelections_ = null;
        this.hasAGroup_ = null;
        this.hasANode_ = null;
        this.hasALink_ = null;
        this.hasAModule_ = null;
    }

    int getType() {
        return this.type_;
    }

    boolean genomeNotNull() {
        return this.genome_ != null;
    }

    boolean genomeNotEmpty() {
        return this.genome_ != null && !this.genome_.isEmpty();
    }

    boolean genomeCanWriteSBML() {
        if (this.genome_ == null) {
            return false;
        }
        return this.genome_.canWriteSBML();
    }

    boolean moreThanOneModel() {
        return this.loadGenomeCount() > 1;
    }

    boolean genomeHasImage() {
        if (this.genome_ == null) {
            return false;
        }
        return this.genome_.getGenomeImage() != null;
    }

    boolean haveSubmodelsOrOverlay() {
        if (this.genome_ == null) {
            return false;
        }
        if (this.loadGenomeCount() > 1) {
            return true;
        }
        return this.loadOverlayExists();
    }

    boolean haveASelection() {
        if (this.genome_ == null || this.genome_.isEmpty()) {
            return false;
        }
        return this.loadHasSelection();
    }

    boolean hasMultiSelections() {
        if (this.genome_ == null || this.genome_.isEmpty()) {
            return false;
        }
        return this.loadHasMultiSelections();
    }

    boolean canAdd() {
        if (this.genome_ == null) {
            return false;
        }
        if (this.genome_ instanceof DBGenome) {
            return true;
        }
        if (this.genome_ instanceof DynamicGenomeInstance) {
            return false;
        }
        return this.loadHasAGroup();
    }

    boolean canAddLink() {
        if (this.genome_ == null) {
            return false;
        }
        if (this.genome_ instanceof DynamicGenomeInstance) {
            return false;
        }
        if (this.loadLinksHidden()) {
            return false;
        }
        return this.loadHasANode();
    }

    boolean canLayoutLinks() {
        if (this.genome_ == null) {
            return false;
        }
        if (this.genome_ instanceof DynamicGenomeInstance) {
            return false;
        }
        if (this.loadLinksHidden()) {
            return false;
        }
        return this.loadHasALink();
    }

    boolean canPropagateDown() {
        if (this.genome_ == null) {
            return false;
        }
        if (this.genome_ instanceof GenomeInstance) {
            return false;
        }
        if (this.loadGenomeCount() < 2) {
            return false;
        }
        return this.loadHasSelection();
    }

    boolean genomeIsRoot() {
        if (this.genome_ == null) {
            return false;
        }
        return !(this.genome_ instanceof GenomeInstance);
    }

    boolean isNonDynamicInstance() {
        if (this.genome_ == null) {
            return false;
        }
        return this.genome_ instanceof GenomeInstance && !(this.genome_ instanceof DynamicGenomeInstance);
    }

    boolean isDynamicInstance() {
        if (this.genome_ == null) {
            return false;
        }
        return this.genome_ instanceof DynamicGenomeInstance;
    }

    boolean isNotDynamicInstance() {
        if (this.genome_ == null) {
            return false;
        }
        return !(this.genome_ instanceof DynamicGenomeInstance);
    }

    boolean genomeIsRootInstance() {
        if (this.genome_ == null) {
            return false;
        }
        if (!(this.genome_ instanceof GenomeInstance)) {
            return false;
        }
        if (this.genome_ instanceof DynamicGenomeInstance) {
            return false;
        }
        GenomeInstance gi = (GenomeInstance)this.genome_;
        return gi.getVfgParent() == null;
    }

    boolean isRootOrRootInstance() {
        if (this.genome_ == null) {
            return false;
        }
        if (this.genome_ instanceof DBGenome) {
            return true;
        }
        GenomeInstance parent = ((GenomeInstance)this.genome_).getVfgParent();
        return parent == null;
    }

    boolean haveBuildInstructions() {
        if (this.genome_ == null) {
            return false;
        }
        return Database.getDB().haveBuildInstructions();
    }

    boolean gooseIsActive() {
        return this.loadGooseActive();
    }

    boolean canShowBubbles() {
        boolean gotModules = this.loadShowingModule();
        return this.genome_ != null && (!this.genome_.isEmpty() || gotModules);
    }

    boolean canLayoutByOverlay() {
        boolean gotModules = this.loadShowingModule();
        return this.genome_ != null && !this.genome_.isEmpty() && gotModules;
    }

    boolean haveTimeCourseData() {
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        return tcd != null && tcd.haveData();
    }

    boolean timeCourseNotEmpty() {
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        return !tcd.isEmpty();
    }

    boolean timeCourseHasTemplate() {
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        return tcd.hasGeneTemplate();
    }

    boolean genomeHasModule() {
        return this.genome_ != null && this.loadHasAModule();
    }

    boolean canPullDown() {
        if (this.genome_ == null) {
            return false;
        }
        if (!(this.genome_ instanceof GenomeInstance)) {
            return false;
        }
        GenomeInstance gi = (GenomeInstance)this.genome_;
        GenomeInstance parent = gi.getVfgParent();
        if (parent == null) {
            return this.loadHasAGroup();
        }
        return true;
    }

    boolean noModel() {
        return this.loadGenomeCount() == 0 || this.genome_ == null;
    }

    boolean oneRoot() {
        return this.loadGenomeCount() == 1 && this.genome_ != null;
    }

    boolean oneEmptyRoot() {
        return this.loadGenomeCount() == 1 && this.genome_ != null && this.genome_.isEmpty();
    }

    boolean hasPerturbationData() {
        Database db = Database.getDB();
        PerturbationData pd = db.getPertData();
        return pd.haveData();
    }

    boolean hasPertSources() {
        Database db = Database.getDB();
        PerturbationData pd = db.getPertData();
        return pd.havePertSources();
    }

    boolean canSquash() {
        if (this.genome_ == null) {
            return false;
        }
        boolean genomeOK = this.genome_ instanceof DBGenome;
        if (!genomeOK) {
            GenomeInstance parent = ((GenomeInstance)this.genome_).getVfgParent();
            boolean bl = genomeOK = parent == null;
        }
        if (!genomeOK) {
            return false;
        }
        if (this.loadShowingModule()) {
            return true;
        }
        return !this.genome_.isEmpty();
    }

    boolean canStretch() {
        return this.canSquash();
    }

    private int loadGenomeCount() {
        if (this.genomeCount_ == null) {
            Database db = Database.getDB();
            this.genomeCount_ = new Integer(db.getGenomeCount());
        }
        return this.genomeCount_;
    }

    private boolean loadGooseActive() {
        if (this.gaggleIsActive_ == null) {
            GooseAppInterface goose = GooseManager.getManager().getGoose();
            this.gaggleIsActive_ = new Boolean(goose != null && goose.isActivated());
        }
        return this.gaggleIsActive_;
    }

    private boolean loadShowingModule() {
        if (this.showingModule_ == null) {
            SUPanel sup = this.suw_.getSUPanel();
            this.showingModule_ = new Boolean(sup.getCurrentOverlay() != null && !sup.getCurrentNetModules().set.isEmpty());
        }
        return this.showingModule_;
    }

    private boolean loadOverlayExists() {
        if (this.overlayExists_ == null) {
            this.overlayExists_ = new Boolean(new FullGenomeHierarchyOracle().overlayExists());
        }
        return this.overlayExists_;
    }

    private boolean loadHasSelection() {
        if (this.hasSelection_ == null) {
            SUPanel sup = this.suw_.getSUPanel();
            this.hasSelection_ = new Boolean(sup.hasASelection());
        }
        return this.hasSelection_;
    }

    private boolean loadHasMultiSelections() {
        if (this.hasMultiSelections_ == null) {
            SUPanel sup = this.suw_.getSUPanel();
            this.hasMultiSelections_ = new Boolean(sup.haveMultipleSelectionsForBounds());
        }
        return this.hasMultiSelections_;
    }

    private boolean loadLinksHidden() {
        if (this.linksHidden_ == null) {
            SUPanel sup = this.suw_.getSUPanel();
            this.linksHidden_ = new Boolean(sup.linksAreHidden());
        }
        return this.linksHidden_;
    }

    private boolean loadHasAGroup() {
        GenomeInstance gi = (GenomeInstance)this.genome_;
        if (this.hasAGroup_ == null) {
            this.hasAGroup_ = new Boolean(gi.getGroupIterator().hasNext());
        }
        return this.hasAGroup_;
    }

    private boolean loadHasANode() {
        if (this.hasANode_ == null) {
            this.hasANode_ = new Boolean(this.genome_.getGeneIterator().hasNext() || this.genome_.getNodeIterator().hasNext());
        }
        return this.hasANode_;
    }

    private boolean loadHasALink() {
        if (this.hasALink_ == null) {
            this.hasALink_ = new Boolean(this.genome_.getLinkageIterator().hasNext());
        }
        return this.hasALink_;
    }

    private boolean loadHasAModule() {
        if (this.hasAModule_ == null) {
            this.hasAModule_ = new Boolean(this.genome_.getNetworkModuleCount() > 0);
        }
        return this.hasAModule_;
    }
}

