/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.DatabaseChangeCmd;
import org.systemsbiology.biotapestry.cmd.GenomeChangeCmd;
import org.systemsbiology.biotapestry.cmd.GroupChangeCmd;
import org.systemsbiology.biotapestry.cmd.GroupSettingChangeCmd;
import org.systemsbiology.biotapestry.cmd.ImageChangeCmd;
import org.systemsbiology.biotapestry.cmd.InstanceInstructionSet;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.ModificationCommands;
import org.systemsbiology.biotapestry.cmd.NetOverlayChangeCmd;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.cmd.NetOverlayOwnerChangeCmd;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.cmd.PropChangeCmd;
import org.systemsbiology.biotapestry.cmd.ProxyChangeCmd;
import org.systemsbiology.biotapestry.cmd.TemporalInputChangeCmd;
import org.systemsbiology.biotapestry.cmd.TimeCourseChangeCmd;
import org.systemsbiology.biotapestry.cmd.UserTreePathChangeCmd;
import org.systemsbiology.biotapestry.cmd.UserTreePathController;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.db.StartupView;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.event.LayoutChangeEvent;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupChange;
import org.systemsbiology.biotapestry.genome.GroupMembership;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.LinkageInstance;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleChange;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.NetworkOverlayChange;
import org.systemsbiology.biotapestry.genome.NetworkOverlayOwnerChange;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.genome.ProxyChange;
import org.systemsbiology.biotapestry.nav.GroupSettingChange;
import org.systemsbiology.biotapestry.nav.GroupSettingManager;
import org.systemsbiology.biotapestry.nav.ImageChange;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.nav.UserTreePathChange;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputChange;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseChange;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class DeleteCommands {
    public static final int SINGLE_DELETE = 0;
    public static final int ASK_FOR_ALL = 1;
    public static final int PREVIOUS_NO = 2;
    public static final int PREVIOUS_YES = 3;
    public static final int OFFLINE_YES = 4;
    public static final int OFFLINE_NO = 5;
    public static final int NO_DELETION = 0;
    public static final int NO_DECISION = 1;
    public static final int YES_FOR_ALL = 2;
    public static final int NO_FOR_ALL = 3;
    private JFrame topWindow_;
    private UndoManager undom_;

    public DeleteCommands(JFrame topWindow, UndoManager undo) {
        this.topWindow_ = topWindow;
        this.undom_ = undo;
    }

    public DeleteCommands() {
        this.topWindow_ = null;
        this.undom_ = null;
    }

    public void deleteNetworkOverlay(Genome genome, String ovrKey, UndoSupport support) {
        NetworkOverlayOwnerChange gc;
        Database db = Database.getDB();
        String genomeID = genome.getID();
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeID);
        Layout glo = db.getLayout(new LayoutManager().getLayout(genomeID));
        UserTreePathController utpc = MainCommands.getCmds().getPathController();
        UserTreePathChange[] chgs = utpc.dropStopsOnOverlay(genomeID, ovrKey);
        for (int i = 0; i < chgs.length; ++i) {
            UserTreePathChangeCmd cmd = new UserTreePathChangeCmd(chgs[i]);
            support.addEdit(cmd);
        }
        Layout.PropChange pc = glo.removeNetOverlayProperties(ovrKey);
        if (pc != null) {
            support.addEdit(new PropChangeCmd(pc));
        }
        if ((gc = owner.removeNetworkOverlay(ovrKey)) != null) {
            NetOverlayOwnerChangeCmd gcc = new NetOverlayOwnerChangeCmd(gc);
            support.addEdit(gcc);
        }
        support.addEvent(new LayoutChangeEvent(glo.getName(), 1));
        support.addEvent(new ModelChangeEvent(genomeID, 1));
        support.finish();
    }

    public void deleteNetworkModule(String genomeID, String ovrKey, String modKey, UndoSupport support) {
        NetworkOverlayChange[] gc;
        Database db = Database.getDB();
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeID);
        Layout glo = db.getLayout(new LayoutManager().getLayout(genomeID));
        UserTreePathController utpc = MainCommands.getCmds().getPathController();
        UserTreePathChange[] chgs = utpc.dropOrChangeStopsOnModules(genomeID, ovrKey, modKey);
        for (int i = 0; i < chgs.length; ++i) {
            UserTreePathChangeCmd cmd = new UserTreePathChangeCmd(chgs[i]);
            support.addEdit(cmd);
        }
        Layout.PropChange pc = glo.removeNetModuleProperties(modKey, ovrKey);
        if (pc != null) {
            support.addEdit(new PropChangeCmd(pc));
        }
        if ((gc = owner.removeNetworkModule(ovrKey, modKey)) != null && gc.length > 0) {
            for (int i = 0; i < gc.length; ++i) {
                NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(gc[i]);
                support.addEdit(gcc);
            }
        }
        NetworkOverlay nov = owner.getNetworkOverlay(ovrKey);
        HashSet<String> linkIDs = new HashSet<String>();
        Iterator lit = nov.getLinkageIterator();
        while (lit.hasNext()) {
            NetModuleLinkage nlm = (NetModuleLinkage)lit.next();
            if (!modKey.equals(nlm.getSource()) && !modKey.equals(nlm.getTarget())) continue;
            linkIDs.add(nlm.getID());
        }
        this.deleteNetworkModuleLinkageSet(genomeID, ovrKey, linkIDs, support);
        support.addEvent(new LayoutChangeEvent(glo.getName(), 1));
        support.addEvent(new ModelChangeEvent(genomeID, 1));
    }

    public boolean deleteNetworkModuleLinkage(Genome genome, String ovrKey, Intersection intersect, UndoSupport support) {
        Database db = Database.getDB();
        String genomeID = genome.getID();
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeID);
        Layout glo = db.getLayout(new LayoutManager().getLayout(genomeID));
        String treeID = intersect.getObjectID();
        LinkSegmentID segID = intersect.segmentIDFromIntersect();
        NetOverlayProperties nop = glo.getNetOverlayProperties(ovrKey);
        NetModuleLinkageProperties nmlp = nop.getNetModuleLinkagePropertiesFromTreeID(treeID);
        Set resolved = nmlp.resolveLinkagesThroughSegment(segID, genome);
        return this.deleteNetworkModuleLinkageSet(genomeID, ovrKey, resolved, support);
    }

    public boolean deleteNetworkModuleLinkageSet(String genomeID, String ovrKey, Set linkIDs, UndoSupport support) {
        Database db = Database.getDB();
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeID);
        Layout glo = db.getLayout(new LayoutManager().getLayout(genomeID));
        boolean retval = false;
        Iterator resit = linkIDs.iterator();
        while (resit.hasNext()) {
            String nextDeadID = (String)resit.next();
            NetworkOverlayChange gc = owner.removeNetworkModuleLinkage(ovrKey, nextDeadID);
            if (gc == null) continue;
            NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(gc);
            support.addEdit(gcc);
            Layout.PropChange pc = glo.removeNetModuleLinkageProperties(nextDeadID, ovrKey);
            if (pc == null) continue;
            support.addEdit(new PropChangeCmd(pc));
            retval = true;
        }
        support.addEvent(new LayoutChangeEvent(glo.getName(), 1));
        support.addEvent(new ModelChangeEvent(genomeID, 1));
        return retval;
    }

    public void deleteNetworkModuleRegion(String genomeID, String ovrKey, String modKey, NetModuleFree.IntersectionExtraInfo iexi, FontRenderContext frc, UndoSupport support) {
        Database db = Database.getDB();
        Layout glo = db.getLayout(new LayoutManager().getLayout(genomeID));
        Layout.PadNeedsForLayout padFixups = glo.findAllNetModuleLinkPadRequirements(frc);
        NetOverlayProperties noProps = glo.getNetOverlayProperties(ovrKey);
        NetModuleProperties nmp = noProps.getNetModuleProperties(modKey);
        NetModuleProperties modProps = (NetModuleProperties)nmp.clone();
        if (!modProps.removeBiggestShape(iexi)) {
            return;
        }
        Layout.PropChange pc = glo.replaceNetModuleProperties(modKey, modProps, ovrKey);
        if (pc != null) {
            support.addEdit(new PropChangeCmd(pc));
        }
        new AddCommands().finishNetModPadFixups(null, null, glo, padFixups, frc, support);
        support.addEvent(new LayoutChangeEvent(glo.getName(), 1));
        support.finish();
    }

    public boolean deleteNodeFromModule(String genomeID, String nodeID, String moduleID, String overlayKey, FontRenderContext frc) {
        NetOverlayProperties noProps;
        NetModuleProperties nmp;
        Database db = Database.getDB();
        Layout glo = db.getLayout(new LayoutManager().getLayout(genomeID));
        Layout.PadNeedsForLayout padFixups = glo.findAllNetModuleLinkPadRequirements(frc);
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeID);
        NetworkOverlay nov = owner.getNetworkOverlay(overlayKey);
        NetModule nmod = nov.getModule(moduleID);
        if (nmod.getMemberCount() == 1 && (nmp = (noProps = glo.getNetOverlayProperties(overlayKey)).getNetModuleProperties(moduleID)).getType() == 2) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("deleteNodefromMod.lastOne"), rMan.getString("deleteNodefromMod.lastOneTitle"), 0);
            return false;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.deleteNodeFromNetworkModule");
        NetModuleChange nmc = owner.deleteMemberFromNetworkModule(overlayKey, nmod, nodeID);
        if (nmc != null) {
            NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmc);
            support.addEdit(gcc);
        }
        new AddCommands().finishNetModPadFixups(null, null, glo, padFixups, frc, support);
        support.addEvent(new ModelChangeEvent(genomeID, 1));
        support.finish();
        return true;
    }

    public void deleteWarningHelper(String genomeKey, JFrame parent) {
        Database db = Database.getDB();
        boolean gotRootInstructions = db.haveBuildInstructions();
        boolean isRoot = db.getGenome().getID().equals(genomeKey);
        boolean showRootDialog = false;
        boolean showNonInstructDialog = false;
        boolean showInstructDialog = false;
        if (isRoot) {
            showRootDialog = gotRootInstructions;
        } else if (gotRootInstructions) {
            InstanceInstructionSet iis = db.getInstanceInstructionSet(genomeKey);
            if (iis == null) {
                showNonInstructDialog = true;
            } else {
                showInstructDialog = true;
            }
        }
        ResourceManager rMan = ResourceManager.getManager();
        if (showRootDialog || showInstructDialog) {
            JOptionPane.showMessageDialog(parent, rMan.getString("instructWarning.deleteMessageI"), rMan.getString("instructWarning.deleteTitle"), 2);
        } else if (showNonInstructDialog) {
            JOptionPane.showMessageDialog(parent, rMan.getString("instructWarning.deleteMessageNI"), rMan.getString("instructWarning.deleteTitle"), 2);
        }
    }

    public Set deleteGenomeInstance(String genomeRootKey, boolean justKids, UndoSupport support) {
        TemporalInputRangeData tird;
        TimeCourseData tcd;
        String id;
        DynamicInstanceProxy dip;
        Iterator dpit;
        String id2;
        DynamicInstanceProxy dip2;
        Database db = Database.getDB();
        StartupView sView = db.getStartupView();
        Genome genome = db.getGenome(genomeRootKey);
        if (genome instanceof DBGenome) {
            throw new IllegalStateException();
        }
        GenomeInstance rootOne = (GenomeInstance)genome;
        boolean rootOneIsRootInstance = rootOne.getVfgParent() == null;
        HashSet<String> deadOnes = new HashSet<String>();
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (!rootOne.isAncestor(gi) || justKids && gi.getID().equals(genomeRootKey)) continue;
            deadOnes.add(gi.getID());
        }
        HashSet<String> deadProxies = new HashSet<String>();
        HashSet deadViz = new HashSet();
        if (genome instanceof DynamicGenomeInstance) {
            String pid = ((DynamicGenomeInstance)genome).getProxyID();
            if (!justKids) {
                deadProxies.add(pid);
                dip2 = db.getDynamicProxy(pid);
                deadViz.addAll(dip2.getProxiedKeys());
            }
        }
        Iterator pit = db.getDynamicProxyIterator();
        while (pit.hasNext()) {
            dip2 = (DynamicInstanceProxy)pit.next();
            if (!rootOne.isAncestor(dip2.getVfgParent())) continue;
            deadProxies.add(dip2.getID());
            deadViz.addAll(dip2.getProxiedKeys());
        }
        if (!rootOneIsRootInstance || justKids) {
            LayoutManager lm = new LayoutManager();
            Iterator dit = deadOnes.iterator();
            while (dit.hasNext()) {
                id2 = (String)dit.next();
                Layout glo = db.getLayout(lm.getLayout(id2));
                GenomeInstance gi = (GenomeInstance)db.getGenome(id2);
                Iterator noteIt = gi.getNoteIterator();
                Iterator overIt = gi.getNetworkOverlayIterator();
                this.cleanUpLayouts(noteIt, overIt, glo, support);
            }
            dpit = deadProxies.iterator();
            while (dpit.hasNext()) {
                String pid = (String)dpit.next();
                dip = db.getDynamicProxy(pid);
                GenomeInstance gi = dip.getStaticVfgParent();
                if (!gi.isRootInstance()) {
                    gi = gi.getVfgParentRoot();
                }
                Layout glo = db.getLayout(lm.getLayout(gi.getID()));
                Iterator noteIt = dip.getNoteIterator();
                Iterator overIt = dip.getNetworkOverlayIterator();
                this.cleanUpLayouts(noteIt, overIt, glo, support);
            }
        }
        UserTreePathController utpc = MainCommands.getCmds().getPathController();
        Iterator doit = deadOnes.iterator();
        while (doit.hasNext()) {
            id2 = (String)doit.next();
            GenomeInstance gi = (GenomeInstance)db.getGenome(id2);
            ImageChange ic = gi.dropGenomeImage();
            if (ic != null) {
                support.addEdit(new ImageChangeCmd(ic));
            }
            UserTreePathChange[] chgs = utpc.dropStopsOnModel(id2);
            for (int i = 0; i < chgs.length; ++i) {
                UserTreePathChangeCmd cmd = new UserTreePathChangeCmd(chgs[i]);
                support.addEdit(cmd);
            }
            if (sView == null || !id2.equals(sView.getModel())) continue;
            DatabaseChange dc = db.setStartupView(new StartupView());
            support.addEdit(new DatabaseChangeCmd(dc));
            sView = null;
        }
        dpit = deadProxies.iterator();
        while (dpit.hasNext()) {
            String id3 = (String)dpit.next();
            dip = db.getDynamicProxy(id3);
            ImageChange[] ich = dip.dropGenomeImages();
            if (ich == null) continue;
            int numIC = ich.length;
            for (int i = 0; i < numIC; ++i) {
                ImageChange ic = ich[i];
                if (ic == null) continue;
                support.addEdit(new ImageChangeCmd(ic));
            }
        }
        GroupSettingManager gsm = GroupSettingManager.getGroupMgr();
        doit = deadOnes.iterator();
        while (doit.hasNext()) {
            String id4 = (String)doit.next();
            GroupSettingChange gsc = gsm.dropGroupVisibilities(id4);
            if (gsc != null) {
                GroupSettingChangeCmd gscc = new GroupSettingChangeCmd(gsc);
                support.addEdit(gscc);
            }
            DatabaseChange[] dc = db.removeInstance(id4);
            for (int i = 0; i < dc.length; ++i) {
                DatabaseChangeCmd dcc = new DatabaseChangeCmd(dc[i]);
                support.addEdit(dcc);
            }
            if (db.getInstanceInstructionSet(id4) != null) {
                DatabaseChange riis = db.removeInstanceInstructionSet(id4);
                DatabaseChangeCmd riiscc = new DatabaseChangeCmd(riis);
                support.addEdit(riiscc);
            }
            support.addEvent(new ModelChangeEvent(id4, 2));
        }
        Iterator dvit = deadViz.iterator();
        while (dvit.hasNext()) {
            id = (String)dvit.next();
            GroupSettingChange gsc = gsm.dropGroupVisibilities(id);
            if (gsc != null) {
                GroupSettingChangeCmd gscc = new GroupSettingChangeCmd(gsc);
                support.addEdit(gscc);
            }
            UserTreePathChange[] chgs = utpc.dropStopsOnModel(id);
            for (int i = 0; i < chgs.length; ++i) {
                UserTreePathChangeCmd cmd = new UserTreePathChangeCmd(chgs[i]);
                support.addEdit(cmd);
            }
            if (sView == null || !id.equals(sView.getModel())) continue;
            DatabaseChange dc = db.setStartupView(new StartupView());
            support.addEdit(new DatabaseChangeCmd(dc));
            sView = null;
        }
        dpit = deadProxies.iterator();
        while (dpit.hasNext()) {
            id = (String)dpit.next();
            DatabaseChange[] dc = db.removeDynamicProxy(id);
            for (int i = 0; i < dc.length; ++i) {
                DatabaseChangeCmd dcc = new DatabaseChangeCmd(dc[i]);
                support.addEdit(dcc);
            }
        }
        if (rootOneIsRootInstance && !justKids) {
            HashSet<String> deadLayouts = new HashSet<String>();
            String deadOneID = rootOne.getID();
            Iterator loit = db.getLayoutIterator();
            while (loit.hasNext()) {
                Layout.PropChange lpc;
                Layout lo = (Layout)loit.next();
                if (lo.haveModelMetadataDependency(deadOneID) && (lpc = lo.dropModelMetadataDependency(deadOneID)) != null) {
                    PropChangeCmd pcc = new PropChangeCmd(lpc);
                    support.addEdit(pcc);
                }
                if (!lo.getTarget().equals(deadOneID)) continue;
                deadLayouts.add(lo.getName());
            }
            if (deadLayouts.size() != 1) {
                throw new IllegalStateException();
            }
            String lon = (String)deadLayouts.iterator().next();
            DatabaseChange dc = db.removeLayout(lon);
            DatabaseChangeCmd dcc = new DatabaseChangeCmd(dc);
            support.addEdit(dcc);
        }
        if ((tcd = db.getTimeCourseData()) != null) {
            dpit = deadProxies.iterator();
            while (dpit.hasNext()) {
                String id5 = (String)dpit.next();
                TimeCourseChange[] tcc = tcd.dropGroupMapsForProxy(id5);
                support.addEdits(TimeCourseChangeCmd.wrapChanges(tcc));
            }
        }
        if ((tird = db.getTemporalInputRangeData()) != null) {
            dpit = deadProxies.iterator();
            while (dpit.hasNext()) {
                String id6 = (String)dpit.next();
                TemporalInputChange[] tic = tird.dropGroupMapsForProxy(id6);
                support.addEdits(TemporalInputChangeCmd.wrapChanges(tic));
            }
        }
        return deadOnes;
    }

    private void cleanUpLayouts(Iterator noteIt, Iterator overIt, Layout glo, UndoSupport support) {
        PropChangeCmd mov;
        Layout.PropChange[] lpc;
        while (noteIt.hasNext()) {
            Note note = (Note)noteIt.next();
            lpc = new Layout.PropChange[]{glo.removeNoteProperties(note.getID())};
            if (lpc == null) continue;
            mov = new PropChangeCmd(lpc);
            support.addEdit(mov);
        }
        while (overIt.hasNext()) {
            NetworkOverlay ovr = (NetworkOverlay)overIt.next();
            lpc = new Layout.PropChange[]{glo.removeNetOverlayProperties(ovr.getID())};
            if (lpc == null) continue;
            mov = new PropChangeCmd(lpc);
            support.addEdit(mov);
        }
    }

    public boolean dropAllInstructions(UndoSupport support) {
        ResourceManager rMan = ResourceManager.getManager();
        String centered = UiUtil.convertMessageToHtml(rMan.getString("dropInstruct.dropQuestion"));
        int result = JOptionPane.showConfirmDialog(this.topWindow_, centered, rMan.getString("dropInstruct.messageTitle"), 0);
        if (result != 0) {
            return false;
        }
        Database db = Database.getDB();
        if (!db.haveBuildInstructions()) {
            return false;
        }
        DatabaseChange dc = db.dropBuildInstructions();
        DatabaseChangeCmd dcc = new DatabaseChangeCmd(dc);
        support.addEdit(dcc);
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            String giid = gi.getID();
            if (db.getInstanceInstructionSet(giid) == null) continue;
            DatabaseChange riis = db.removeInstanceInstructionSet(giid);
            DatabaseChangeCmd riiscc = new DatabaseChangeCmd(riis);
            support.addEdit(riiscc);
        }
        return true;
    }

    public void fixupDeletionsInNonInstructionModels(UndoSupport support, int runningUserValue) {
        Database db = Database.getDB();
        HashSet<String> pending = new HashSet<String>();
        HashSet<String> done = new HashSet<String>();
        HashSet<String> dynamics = new HashSet<String>();
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            GenomeInstance gi = (GenomeInstance)git.next();
            String giID = gi.getID();
            InstanceInstructionSet iis = db.getInstanceInstructionSet(giID);
            if (gi.getVfgParent() == null) {
                done.add(giID);
                continue;
            }
            if (iis != null) {
                done.add(giID);
                continue;
            }
            pending.add(giID);
            if (!(gi instanceof DynamicGenomeInstance)) continue;
            dynamics.add(giID);
        }
        block1: while (pending.size() > 0) {
            Iterator pit = pending.iterator();
            while (pit.hasNext()) {
                String pendID = (String)pit.next();
                GenomeInstance gi = (GenomeInstance)db.getGenome(pendID);
                GenomeInstance parent = gi.getVfgParent();
                if (parent == null || !done.contains(parent.getID())) continue;
                this.fixupDeletionsForSubsetModel(gi, parent, support, runningUserValue, false);
                pending.remove(pendID);
                done.add(pendID);
                continue block1;
            }
        }
        ArrayList<String> deadGroups = new ArrayList<String>();
        Iterator dpit = db.getDynamicProxyIterator();
        while (dpit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dpit.next();
            GenomeInstance lowestStatic = dip.getStaticVfgParent();
            Iterator grit = dip.getGroupIterator();
            deadGroups.clear();
            while (grit.hasNext()) {
                Group kgrp = (Group)grit.next();
                String inherit = Group.buildInheritedID(kgrp.getID(), lowestStatic.getGeneration());
                if (lowestStatic.getGroup(inherit) != null) continue;
                deadGroups.add(kgrp.getID());
            }
            Iterator dgit = deadGroups.iterator();
            while (dgit.hasNext()) {
                String dgid = (String)dgit.next();
                ProxyChange pxc = dip.removeGroupNoChecks(dgid);
                support.addEdit(new ProxyChangeCmd(pxc));
                ProxyChange[] pca = dip.deleteExtraNodesForGroup(Group.getBaseID(dgid));
                for (int i = 0; i < pca.length; ++i) {
                    support.addEdit(new ProxyChangeCmd(pca[i]));
                }
            }
            this.fixupAllDeletionsForDynamicProxy(dip, lowestStatic, support);
        }
        this.proxyPostExtraNodeDeletionSupport(support);
    }

    private void fixupDeletionsForSubsetModel(GenomeInstance gi, GenomeInstance parent, UndoSupport support, int runningUserValue, boolean keepEmptyMemOnly) {
        HashSet<String> deadLinks = new HashSet<String>();
        HashSet<String> deadNodes = new HashSet<String>();
        Iterator lit = gi.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String lid = link.getID();
            if (parent.getLinkage(lid) != null) continue;
            deadLinks.add(lid);
        }
        Iterator nit = gi.getAllNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            String nid = node.getID();
            if (parent.getNode(nid) != null) continue;
            deadNodes.add(nid);
        }
        this.deleteNodesAndLinksFromModel(deadNodes, deadLinks, gi.getID(), support, runningUserValue, keepEmptyMemOnly);
        Iterator git = gi.getGroupIterator();
        boolean dropped = false;
        while (git.hasNext()) {
            Group grp = (Group)git.next();
            String inherit = Group.buildInheritedID(grp.getID(), parent.getGeneration());
            if (parent.getGroup(inherit) != null) continue;
            GenomeChange gc = gi.removeGroupNoChecks(grp.getID());
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
            GroupSettingManager gsm = GroupSettingManager.getGroupMgr();
            GroupSettingChange gsc = gsm.dropGroupVisibility(gi.getID(), grp.getID());
            if (gsc != null) {
                GroupSettingChangeCmd gscc = new GroupSettingChangeCmd(gsc);
                support.addEdit(gscc);
            }
            dropped = true;
        }
        if (dropped) {
            support.addEvent(new ModelChangeEvent(gi.getID(), 1));
        }
    }

    private boolean fixupAllDeletionsForDynamicProxy(DynamicInstanceProxy dip, GenomeInstance staticParent, UndoSupport support) {
        HashSet<String> deadNodes = new HashSet<String>();
        Layout glo = Database.getDB().getLayout(new LayoutManager().getLayout(staticParent.getID()));
        boolean retval = false;
        Iterator oit = dip.getNetworkOverlayIterator();
        while (oit.hasNext()) {
            NetworkOverlay no = (NetworkOverlay)oit.next();
            String noID = no.getID();
            deadNodes.clear();
            Iterator nmit = no.getModuleIterator();
            while (nmit.hasNext()) {
                String nodeID;
                NetModule nmod = (NetModule)nmit.next();
                Iterator mit = nmod.getMemberIterator();
                while (mit.hasNext()) {
                    NetModuleMember nmm = (NetModuleMember)mit.next();
                    nodeID = nmm.getID();
                    if (staticParent.getNode(nodeID) != null) continue;
                    deadNodes.add(nodeID);
                }
                Iterator dnit = deadNodes.iterator();
                while (dnit.hasNext()) {
                    nodeID = (String)dnit.next();
                    NetModuleChange nmc = dip.deleteMemberFromNetworkModule(noID, nmod, nodeID);
                    if (nmc == null) continue;
                    NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmc);
                    support.addEdit(gcc);
                    retval = true;
                }
            }
        }
        return retval;
    }

    public void cleanupDanglingGroupData(UndoSupport support) {
        HashSet<String> liveGroups = new HashSet<String>();
        Database db = Database.getDB();
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)giit.next();
            Iterator git = gi.getGroupIterator();
            while (git.hasNext()) {
                Group grp = (Group)git.next();
                liveGroups.add(Group.getBaseID(grp.getID()));
            }
        }
        HashSet<String> deadGroups = new HashSet<String>();
        TimeCourseData tcd = db.getTimeCourseData();
        if (tcd != null) {
            Iterator tcgmkit = tcd.getGroupMapKeys();
            while (tcgmkit.hasNext()) {
                String key = (String)tcgmkit.next();
                if (liveGroups.contains(key)) continue;
                deadGroups.add(key);
            }
        }
        Iterator dgit = deadGroups.iterator();
        while (dgit.hasNext()) {
            String dgKey = (String)dgit.next();
            TimeCourseChange tcc = tcd.dropGroupMap(dgKey);
            TimeCourseChangeCmd tccc = new TimeCourseChangeCmd(tcc);
            support.addEdit(tccc);
        }
        deadGroups.clear();
        TemporalInputRangeData tird = db.getTemporalInputRangeData();
        if (tird != null) {
            Iterator kit = tird.getGroupMapKeys();
            while (kit.hasNext()) {
                String key = (String)kit.next();
                if (liveGroups.contains(key)) continue;
                deadGroups.add(key);
            }
        }
        dgit = deadGroups.iterator();
        while (dgit.hasNext()) {
            String dgKey = (String)dgit.next();
            TemporalInputChange tic = tird.dropGroupMap(dgKey);
            TemporalInputChangeCmd ticc = new TemporalInputChangeCmd(tic);
            support.addEdit(ticc);
        }
        this.cleanupDanglingVisibility(support);
    }

    public void cleanupDanglingVisibility(UndoSupport support) {
        GroupSettingManager gsm = GroupSettingManager.getGroupMgr();
        HashSet<String> liveGroups = new HashSet<String>();
        Database db = Database.getDB();
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)giit.next();
            liveGroups.clear();
            Iterator git = gi.getGroupIterator();
            while (git.hasNext()) {
                Group grp = (Group)git.next();
                liveGroups.add(grp.getID());
            }
            gsm.dropOrphanedVisibilities(gi.getID(), liveGroups, support);
        }
        Iterator dpit = db.getDynamicProxyIterator();
        while (dpit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dpit.next();
            Iterator grit = dip.getGroupIterator();
            liveGroups.clear();
            while (grit.hasNext()) {
                Group grp = (Group)grit.next();
                liveGroups.add(grp.getID());
            }
            gsm.dropOrphanedVisibilitiesForProxy(dip.getID(), liveGroups, support);
        }
    }

    public void deleteNodesAndLinksFromModel(Set nodes, Set links, String genomeKey, UndoSupport support, int runningUserValue, boolean keepEmptyMemOnly) {
        this.deleteLinkSetFromModel(links, genomeKey, support);
        Iterator nit = nodes.iterator();
        while (nit.hasNext()) {
            String nodeID = (String)nit.next();
            int useReply = this.deleteNodeFromModelCore(nodeID, genomeKey, support, runningUserValue, keepEmptyMemOnly);
            if (useReply == 3) {
                runningUserValue = 2;
                continue;
            }
            if (useReply != 2) continue;
            runningUserValue = 3;
        }
    }

    public int deleteNodeFromModel(Intersection intersect, String genomeKey, UndoSupport support, int multiDeleteMode, boolean keepEmptyMemOnly) {
        String nodeID = intersect.getObjectID();
        if (nodeID == null) {
            return 0;
        }
        return this.deleteNodeFromModelCore(nodeID, genomeKey, support, multiDeleteMode, keepEmptyMemOnly);
    }

    private int deleteNodeFromModelCore(String nodeID, String genomeKey, UndoSupport support, int multiDeleteMode, boolean keepEmptyMemOnly) {
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeKey);
        Node node = genome.getNode(nodeID);
        if (node == null) {
            return 0;
        }
        boolean localUndo = false;
        if (support == null) {
            localUndo = true;
            support = new UndoSupport(this.undom_, "undo.deleteNodeFromModel");
        }
        if (genome instanceof DynamicGenomeInstance) {
            boolean extraLost = false;
            String proxID = ((DynamicGenomeInstance)genome).getProxyID();
            DynamicInstanceProxy prox = db.getDynamicProxy(proxID);
            ProxyChange pc = prox.deleteExtraNode(nodeID);
            if (pc != null) {
                ProxyChangeCmd pcc = new ProxyChangeCmd(pc);
                support.addEdit(pcc);
                support.addEvent(new ModelChangeEvent(genomeKey, 1));
                extraLost = true;
            }
            boolean needGeneral = false;
            Iterator pxit = db.getDynamicProxyIterator();
            while (pxit.hasNext()) {
                DynamicInstanceProxy dip = (DynamicInstanceProxy)pxit.next();
                if (!dip.proxyIsAncestor(proxID) || !dip.hasAddedNode(nodeID) || (pc = dip.deleteExtraNode(nodeID)) == null) continue;
                ProxyChangeCmd pcc = new ProxyChangeCmd(pc);
                support.addEdit(pcc);
                needGeneral = true;
                extraLost = true;
            }
            if (extraLost && !keepEmptyMemOnly) {
                this.proxyPostExtraNodeDeletionSupport(support);
            }
            if (needGeneral) {
                support.addEvent(new GeneralChangeEvent(1));
            }
            if (localUndo) {
                support.finish();
            }
            return 1;
        }
        Iterator lit = genome.getLinkageIterator();
        HashSet<String> deadLinkSet = new HashSet<String>();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            if (!lnk.getSource().equals(nodeID) && !lnk.getTarget().equals(nodeID)) continue;
            deadLinkSet.add(lnk.getID());
        }
        Iterator dnit = deadLinkSet.iterator();
        while (dnit.hasNext()) {
            String linkID = (String)dnit.next();
            this.doLinkDelete(linkID, genome, support);
        }
        int retval = this.doNodeDelete(nodeID, genome, support, multiDeleteMode, keepEmptyMemOnly);
        if (localUndo) {
            support.finish();
        }
        return retval;
    }

    public boolean deleteDataMaps(UndoSupport support, String nodeID) {
        TemporalInputRangeData tird;
        TimeCourseChange tchg;
        TimeCourseData tcd;
        PertDataChangeCmd cmd;
        Database db = Database.getDB();
        boolean haveDelete = false;
        PerturbationData pd = db.getPertData();
        PertDataChange chg = pd.dropDataEntryKeys(nodeID);
        if (chg != null) {
            cmd = new PertDataChangeCmd(chg, false);
            support.addEdit(cmd);
            haveDelete = true;
        }
        if ((chg = pd.dropDataSourceKeys(nodeID)) != null) {
            cmd = new PertDataChangeCmd(chg, false);
            support.addEdit(cmd);
            haveDelete = true;
        }
        if ((tcd = db.getTimeCourseData()) != null && (tchg = tcd.dropDataKeys(nodeID)) != null) {
            TimeCourseChangeCmd cmd2 = new TimeCourseChangeCmd(tchg, false);
            support.addEdit(cmd2);
            haveDelete = true;
        }
        if ((tird = db.getTemporalInputRangeData()) != null) {
            TemporalInputChangeCmd cmd3;
            TemporalInputChange ticChg = tird.dropDataEntryKeys(nodeID);
            if (ticChg != null) {
                cmd3 = new TemporalInputChangeCmd(ticChg, false);
                support.addEdit(cmd3);
                haveDelete = true;
            }
            if ((ticChg = tird.dropDataSourceKeys(nodeID)) != null) {
                cmd3 = new TemporalInputChangeCmd(ticChg, false);
                support.addEdit(cmd3);
                haveDelete = true;
            }
        }
        return haveDelete;
    }

    public boolean deleteUnderlyingTables(UndoSupport support, String nodeID, String nodeName) {
        List keys;
        TemporalInputRangeData tird;
        List keys2;
        Database db = Database.getDB();
        boolean haveDelete = false;
        TimeCourseData tcd = db.getTimeCourseData();
        if (tcd != null && (keys2 = tcd.getTimeCourseTCMDataKeysWithDefaultGivenName(nodeID, nodeName)) != null) {
            Iterator kit = keys2.iterator();
            while (kit.hasNext()) {
                TimeCourseData.TCMapping tcm = (TimeCourseData.TCMapping)kit.next();
                TimeCourseChange tchg = tcd.dropGene(tcm.name);
                if (tchg == null) continue;
                TimeCourseChangeCmd cmd = new TimeCourseChangeCmd(tchg, false);
                support.addEdit(cmd);
                haveDelete = true;
            }
        }
        if ((tird = db.getTemporalInputRangeData()) != null && (keys = tird.getTemporalInputRangeEntryKeysWithDefaultGivenName(nodeID, nodeName)) != null) {
            Iterator kit = keys.iterator();
            while (kit.hasNext()) {
                String key = (String)kit.next();
                TemporalInputChange tichg = tird.dropEntry(key);
                if (tichg == null) continue;
                TemporalInputChangeCmd cmd = new TemporalInputChangeCmd(tichg, false);
                support.addEdit(cmd);
                haveDelete = true;
            }
        }
        return haveDelete;
    }

    public boolean deleteNote(Intersection intersect, String genomeKey, UndoSupport support) {
        GenomeInstance gi;
        GenomeInstance root;
        GenomeChange gc;
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeKey);
        String noteID = intersect.getObjectID();
        if (noteID == null) {
            return false;
        }
        Note note = genome.getNote(noteID);
        if (note == null) {
            return false;
        }
        boolean localUndo = false;
        if (support == null) {
            localUndo = true;
            support = new UndoSupport(this.undom_, "undo.deleteNote");
        }
        if ((gc = genome.removeNote(noteID)) != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        support.addEvent(new ModelChangeEvent(genomeKey, 1));
        if (genome instanceof GenomeInstance && (root = (gi = (GenomeInstance)genome).getVfgParentRoot()) != null) {
            genomeKey = root.getID();
        }
        Iterator layit = db.getLayoutIterator();
        while (layit.hasNext()) {
            Layout.PropChange[] lpc;
            Layout layout = (Layout)layit.next();
            if (!layout.getTarget().equals(genomeKey) || (lpc = new Layout.PropChange[]{layout.removeNoteProperties(noteID)}) == null) continue;
            PropChangeCmd mov = new PropChangeCmd(lpc);
            support.addEdit(mov);
        }
        if (localUndo) {
            support.finish();
        }
        return true;
    }

    public boolean deleteNodeFromSubGroup(GenomeInstance gi, Group group, NodeInstance ni, UndoSupport support) {
        GroupChange grc;
        boolean localUndo = false;
        if (support == null) {
            localUndo = true;
            support = new UndoSupport(this.undom_, "undo.deleteNode");
        }
        if ((grc = group.removeMember(ni.getID(), gi.getID())) != null) {
            GroupChangeCmd grcc = new GroupChangeCmd(grc);
            support.addEdit(grcc);
            support.addEvent(new ModelChangeEvent(gi.getID(), 1));
        }
        if (localUndo) {
            support.finish();
        }
        return true;
    }

    public boolean deleteGroupFromModel(Intersection intersect, String genomeKey, String layoutKey, UndoSupport support, boolean keepEmptyMemOnly, FontRenderContext frc) {
        String key = intersect.getObjectID();
        return this.deleteGroupFromModel(key, genomeKey, layoutKey, support, keepEmptyMemOnly, frc);
    }

    public boolean deleteGroupFromModel(String key, String genomeKey, String layoutKey, UndoSupport support, boolean keepEmptyMemOnly, FontRenderContext frc) {
        boolean isDynamic;
        boolean isRoot;
        GenomeInstance inst;
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeKey);
        if (genome instanceof GenomeInstance) {
            inst = (GenomeInstance)genome;
            isRoot = false;
            boolean topInstance = inst.getVfgParent() == null;
            isDynamic = genome instanceof DynamicGenomeInstance;
        } else {
            inst = null;
            isRoot = true;
            boolean topInstance = false;
            isDynamic = false;
        }
        if (isRoot) {
            throw new IllegalArgumentException();
        }
        ModificationCommands mc = new ModificationCommands();
        Layout.PadNeedsForLayout padNeeds = mc.getLocalNetModuleLinkPadNeeds(frc, genomeKey);
        boolean localUndo = false;
        if (support == null) {
            localUndo = true;
            support = new UndoSupport(this.undom_, "undo.groupDelete");
        }
        if (isDynamic) {
            this.deleteDynamicGroup(inst, key, support);
        } else {
            this.deleteStaticGroup(inst, key, support, keepEmptyMemOnly);
        }
        mc.repairNetModuleLinkPadsLocally(padNeeds, frc, genomeKey, false, support);
        if (localUndo) {
            support.finish();
        }
        return true;
    }

    public boolean deleteSubGroupFromModel(String groupKey, String genomeKey, UndoSupport support) {
        int i;
        ProxyChange[] pca;
        DynamicInstanceProxy dip;
        boolean isDynamic;
        boolean topInstance;
        boolean isRoot;
        GenomeInstance inst;
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeKey);
        if (genome instanceof GenomeInstance) {
            inst = (GenomeInstance)genome;
            isRoot = false;
            topInstance = inst.getVfgParent() == null;
            isDynamic = genome instanceof DynamicGenomeInstance;
        } else {
            inst = null;
            isRoot = true;
            topInstance = false;
            isDynamic = false;
        }
        if (isRoot) {
            throw new IllegalArgumentException();
        }
        boolean localUndo = false;
        if (support == null) {
            localUndo = true;
            support = new UndoSupport(this.undom_, "undo.groupDelete");
        }
        if (isDynamic) {
            this.deleteDynamicSubGroup(inst, groupKey, support);
        } else {
            this.deleteStaticSubGroup(inst, groupKey, support);
        }
        boolean needGeneral = false;
        Iterator dit = db.getDynamicProxyIterator();
        while (dit.hasNext()) {
            dip = (DynamicInstanceProxy)dit.next();
            pca = dip.deleteIllegalExtraNodes();
            for (i = 0; i < pca.length; ++i) {
                support.addEdit(new ProxyChangeCmd(pca[i]));
                needGeneral = true;
            }
        }
        if (!isDynamic) {
            dit = db.getDynamicProxyIterator();
            while (dit.hasNext()) {
                dip = (DynamicInstanceProxy)dit.next();
                if (!dip.instanceIsAncestor(inst)) continue;
                pca = dip.deleteExtraNodesForGroup(Group.getBaseID(groupKey));
                for (i = 0; i < pca.length; ++i) {
                    support.addEdit(new ProxyChangeCmd(pca[i]));
                    needGeneral = true;
                }
            }
        }
        dit = db.getDynamicProxyIterator();
        while (dit.hasNext()) {
            dip = (DynamicInstanceProxy)dit.next();
            pca = dip.deleteOrphanedExtraNodes();
            for (i = 0; i < pca.length; ++i) {
                support.addEdit(new ProxyChangeCmd(pca[i]));
                needGeneral = true;
            }
        }
        this.proxyPostExtraNodeDeletionSupport(support);
        if (needGeneral) {
            support.addEvent(new GeneralChangeEvent(1));
        }
        if (localUndo) {
            support.finish();
        }
        return true;
    }

    private void deleteDynamicGroup(GenomeInstance inst, String key, UndoSupport support) {
        DynamicInstanceProxy dip;
        Database db = Database.getDB();
        String proxID = ((DynamicGenomeInstance)inst).getProxyID();
        Iterator dpit = db.getDynamicProxyIterator();
        while (dpit.hasNext()) {
            String inherit;
            DynamicGenomeInstance kid;
            dip = (DynamicInstanceProxy)dpit.next();
            if (proxID == dip.getID() || !dip.proxyIsAncestor(proxID) || (kid = dip.getAnInstance()).getGroup(inherit = Group.buildInheritedID(key, kid.getGeneration())) == null) continue;
            this.deleteGroupDetails(kid, inherit, support);
            NetModuleChange[] nmca = dip.adjustDynamicGroupModuleMembers(kid);
            if (nmca == null) continue;
            for (int i = 0; i < nmca.length; ++i) {
                NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmca[i]);
                support.addEdit(gcc);
            }
        }
        this.deleteGroupDetails(inst, key, support);
        dip = db.getDynamicProxy(proxID);
        NetModuleChange[] nmca = dip.adjustDynamicGroupModuleMembers((DynamicGenomeInstance)inst);
        if (nmca != null) {
            for (int i = 0; i < nmca.length; ++i) {
                NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmca[i]);
                support.addEdit(gcc);
            }
        }
    }

    private void deleteStaticGroup(GenomeInstance inst, String key, UndoSupport support, boolean keepEmptyMemOnly) {
        String inherit;
        HashSet<GenomeItemInstance> deadSet = new HashSet<GenomeItemInstance>();
        Iterator lit = inst.getLinkageIterator();
        while (lit.hasNext()) {
            LinkageInstance li = (LinkageInstance)lit.next();
            GroupMembership memb = inst.getLinkGroupMembership(li);
            if (!memb.contains(key)) continue;
            deadSet.add(li);
        }
        Iterator dsit = deadSet.iterator();
        while (dsit.hasNext()) {
            LinkageInstance li = (LinkageInstance)dsit.next();
            this.doLinkDelete(li.getID(), inst, support);
        }
        deadSet.clear();
        Iterator nit = inst.getNodeIterator();
        while (nit.hasNext()) {
            NodeInstance ni = (NodeInstance)nit.next();
            GroupMembership memb = inst.getNodeGroupMembership(ni);
            if (!memb.contains(key)) continue;
            deadSet.add(ni);
        }
        Iterator git = inst.getGeneIterator();
        while (git.hasNext()) {
            NodeInstance gi = (NodeInstance)git.next();
            GroupMembership memb = inst.getNodeGroupMembership(gi);
            if (!memb.contains(key)) continue;
            deadSet.add(gi);
        }
        dsit = deadSet.iterator();
        while (dsit.hasNext()) {
            NodeInstance ni = (NodeInstance)dsit.next();
            this.doNodeDelete(ni.getID(), inst, support, 0, keepEmptyMemOnly);
        }
        Set subsets = inst.getGroup(key).getSubsets(inst);
        Database db = Database.getDB();
        Iterator dpit = db.getDynamicProxyIterator();
        boolean needGeneral = false;
        while (dpit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dpit.next();
            if (!dip.instanceIsAncestor(inst)) continue;
            DynamicGenomeInstance kid = dip.getAnInstance();
            if (kid.getGroup(inherit = Group.buildInheritedID(key, kid.getGeneration())) != null) {
                this.deleteGroupDetails(kid, inherit, support);
            }
            ProxyChange[] pca = dip.deleteExtraNodesForGroup(Group.getBaseID(key));
            for (int i = 0; i < pca.length; ++i) {
                support.addEdit(new ProxyChangeCmd(pca[i]));
                needGeneral = true;
            }
            NetModuleChange[] nmca = dip.adjustDynamicGroupModuleMembers(kid);
            if (nmca == null) continue;
            for (int i = 0; i < nmca.length; ++i) {
                NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmca[i]);
                support.addEdit(gcc);
            }
        }
        this.proxyPostExtraNodeDeletionSupport(support);
        if (needGeneral) {
            support.addEvent(new GeneralChangeEvent(1));
        }
        Iterator dit = db.getInstanceIterator();
        while (dit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)dit.next();
            if (gi == inst || !inst.isAncestor(gi) || gi.getGroup(inherit = Group.buildInheritedID(key, gi.getGeneration())) == null) continue;
            this.deleteGroupDetails(gi, inherit, support);
        }
        this.deleteGroupDetails(inst, key, support);
        Iterator ssit = subsets.iterator();
        while (ssit.hasNext()) {
            String subkey = (String)ssit.next();
            this.doTopInstanceGroupCleanup(inst, subkey, support);
        }
        this.doTopInstanceGroupCleanup(inst, key, support);
    }

    private void deleteDynamicSubGroup(GenomeInstance inst, String key, UndoSupport support) {
        DynamicInstanceProxy dip;
        Database db = Database.getDB();
        String proxID = ((DynamicGenomeInstance)inst).getProxyID();
        Iterator dpit = db.getDynamicProxyIterator();
        while (dpit.hasNext()) {
            String inherit;
            DynamicGenomeInstance kid;
            dip = (DynamicInstanceProxy)dpit.next();
            if (proxID == dip.getID() || !dip.proxyIsAncestor(proxID) || (kid = dip.getAnInstance()).getGroup(inherit = Group.buildInheritedID(key, kid.getGeneration())) == null) continue;
            this.deleteSubGroupDetails(kid, inherit, support);
            NetModuleChange[] nmca = dip.adjustDynamicGroupModuleMembers(kid);
            if (nmca == null) continue;
            for (int i = 0; i < nmca.length; ++i) {
                NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmca[i]);
                support.addEdit(gcc);
            }
        }
        dip = db.getDynamicProxy(proxID);
        this.deleteSubGroupDetails(inst, key, support);
        NetModuleChange[] nmca = dip.adjustDynamicGroupModuleMembers((DynamicGenomeInstance)inst);
        if (nmca != null) {
            for (int i = 0; i < nmca.length; ++i) {
                NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmca[i]);
                support.addEdit(gcc);
            }
        }
    }

    private void deleteStaticSubGroup(GenomeInstance inst, String key, UndoSupport support) {
        String inherit;
        Database db = Database.getDB();
        Iterator dpit = db.getDynamicProxyIterator();
        while (dpit.hasNext()) {
            DynamicGenomeInstance kid;
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dpit.next();
            if (!dip.instanceIsAncestor(inst) || (kid = dip.getAnInstance()).getGroup(inherit = Group.buildInheritedID(key, kid.getGeneration())) == null) continue;
            this.deleteSubGroupDetails(kid, inherit, support);
            NetModuleChange[] nmca = dip.adjustDynamicGroupModuleMembers(kid);
            if (nmca == null) continue;
            for (int i = 0; i < nmca.length; ++i) {
                NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmca[i]);
                support.addEdit(gcc);
            }
        }
        Iterator dit = db.getInstanceIterator();
        while (dit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)dit.next();
            if (gi == inst || !inst.isAncestor(gi) || gi.getGroup(inherit = Group.buildInheritedID(key, gi.getGeneration())) == null) continue;
            this.deleteSubGroupDetails(gi, inherit, support);
        }
        this.deleteSubGroupDetails(inst, key, support);
        this.doTopInstanceGroupCleanup(inst, key, support);
    }

    private void deleteSubGroupDetails(GenomeInstance inst, String key, UndoSupport support) {
        GroupSettingManager gsm;
        GroupSettingChange gsc;
        GenomeChange[] retval = inst.removeSubGroup(key);
        if (retval != null) {
            for (int i = 0; i < retval.length; ++i) {
                if (retval[i] == null) continue;
                GenomeChangeCmd gcc = new GenomeChangeCmd(retval[i]);
                support.addEdit(gcc);
                support.addEvent(new ModelChangeEvent(inst.getID(), 1));
            }
        }
        if ((gsc = (gsm = GroupSettingManager.getGroupMgr()).dropGroupVisibility(inst.getID(), key)) != null) {
            GroupSettingChangeCmd gscc = new GroupSettingChangeCmd(gsc);
            support.addEdit(gscc);
        }
    }

    private void deleteGroupDetails(GenomeInstance inst, String key, UndoSupport support) {
        GroupSettingManager gsm;
        GroupSettingChange gsc;
        GenomeChange[] retval;
        Map moduleMap = inst.findModulesOwnedByGroup(key);
        if (!moduleMap.isEmpty()) {
            NetOverlayController noc = MainCommands.getCmds().getOverlayController();
            Iterator mmkit = moduleMap.keySet().iterator();
            while (mmkit.hasNext()) {
                String nokey = (String)mmkit.next();
                NetworkOverlay novr = inst.getNetworkOverlay(nokey);
                Set modSet = (Set)moduleMap.get(nokey);
                Iterator msit = modSet.iterator();
                while (msit.hasNext()) {
                    String modID = (String)msit.next();
                    this.deleteNetworkModule(inst.getID(), nokey, modID, support);
                }
            }
            noc.cleanUpDeletedModules(moduleMap, support);
        }
        if ((retval = inst.removeEmptyGroup(key)) != null) {
            for (int i = 0; i < retval.length; ++i) {
                if (retval[i] == null) continue;
                GenomeChangeCmd gcc = new GenomeChangeCmd(retval[i]);
                support.addEdit(gcc);
                support.addEvent(new ModelChangeEvent(inst.getID(), 1));
            }
        }
        if ((gsc = (gsm = GroupSettingManager.getGroupMgr()).dropGroupVisibility(inst.getID(), key)) != null) {
            GroupSettingChangeCmd gscc = new GroupSettingChangeCmd(gsc);
            support.addEdit(gscc);
        }
    }

    private void doTopInstanceGroupCleanup(GenomeInstance inst, String key, UndoSupport support) {
        Database db = Database.getDB();
        GenomeInstance parent = inst.getVfgParent();
        if (parent != null) {
            return;
        }
        String topInstID = inst.getID();
        Iterator layit = db.getLayoutIterator();
        while (layit.hasNext()) {
            PropChangeCmd pcc;
            Layout.PropChange[] lpc;
            Layout layout = (Layout)layit.next();
            if (layout.haveGroupMetadataDependency(topInstID, key) && (lpc = layout.dropGroupMetadataDependency(topInstID, key)) != null) {
                pcc = new PropChangeCmd((Layout.PropChange)lpc);
                support.addEdit(pcc);
            }
            if (!layout.getTarget().equals(topInstID) || (lpc = new Layout.PropChange[]{layout.removeGroupProperties(key)})[0] == null) continue;
            pcc = new PropChangeCmd(lpc);
            support.addEdit(pcc);
            support.addEvent(new LayoutChangeEvent(layout.getName(), 1));
        }
        this.doTopInstanceGroupMapCleanup(inst, key, support);
    }

    public void doTopInstanceGroupMapCleanup(GenomeInstance inst, String key, UndoSupport support) {
        TemporalInputChange tichg;
        TemporalInputRangeData tird;
        TimeCourseChange tchg;
        Database db = Database.getDB();
        GenomeInstance parent = inst.getVfgParent();
        if (parent != null) {
            return;
        }
        TimeCourseData tcd = db.getTimeCourseData();
        if (tcd != null && (tchg = tcd.dropGroupMap(key)) != null) {
            TimeCourseChangeCmd cmd = new TimeCourseChangeCmd(tchg, false);
            support.addEdit(cmd);
            support.addEvent(new GeneralChangeEvent(2));
        }
        if ((tird = db.getTemporalInputRangeData()) != null && (tichg = tird.dropGroupMap(key)) != null) {
            TemporalInputChangeCmd cmd = new TemporalInputChangeCmd(tichg, false);
            support.addEdit(cmd);
            support.addEvent(new GeneralChangeEvent(2));
        }
    }

    public void deleteLinkSetFromModel(Set linkSet, String genomeKey, UndoSupport support) {
        Database db = Database.getDB();
        Genome genome = db.getGenome(genomeKey);
        Iterator lsit = linkSet.iterator();
        while (lsit.hasNext()) {
            String key = (String)lsit.next();
            this.doLinkDelete(key, genome, support);
        }
    }

    public boolean deleteLinksFromModel(Map intersections, String genomeKey, String layoutKey, UndoSupport support) {
        Database db = Database.getDB();
        Layout layout = db.getLayout(layoutKey);
        Genome genome = db.getGenome(genomeKey);
        boolean localUndo = false;
        if (support == null) {
            localUndo = true;
            support = new UndoSupport(this.undom_, "undo.linksDelete");
        }
        Iterator ikit = intersections.keySet().iterator();
        HashSet resolved = new HashSet();
        while (ikit.hasNext()) {
            String key = (String)ikit.next();
            Intersection intersect = (Intersection)intersections.get(key);
            BusProperties lp = layout.getLinkProperties(key);
            if (lp == null) continue;
            LinkSegmentID[] segIDs = intersect.segmentIDsFromIntersect();
            for (int i = 0; i < segIDs.length; ++i) {
                resolved.addAll(lp.resolveLinkagesThroughSegment(segIDs[i], genome));
            }
        }
        Iterator resit = resolved.iterator();
        while (resit.hasNext()) {
            String nextDeadID = (String)resit.next();
            this.doLinkDelete(nextDeadID, genome, support);
        }
        if (resolved.size() > 0 && localUndo) {
            support.finish();
        }
        return resolved.size() > 0;
    }

    public boolean deleteLinkFromModel(Intersection intersect, String genomeKey, String layoutKey, UndoSupport support) {
        Database db = Database.getDB();
        Layout layout = db.getLayout(layoutKey);
        Genome genome = db.getGenome(genomeKey);
        BusProperties bp = layout.getLinkProperties(intersect.getObjectID());
        if (bp == null) {
            return false;
        }
        boolean localUndo = false;
        if (support == null) {
            localUndo = true;
            support = new UndoSupport(this.undom_, "undo.linkDelete");
        }
        LinkSegmentID segID = intersect.segmentIDFromIntersect();
        Set resolved = bp.resolveLinkagesThroughSegment(segID, genome);
        Iterator resit = resolved.iterator();
        while (resit.hasNext()) {
            String nextDeadID = (String)resit.next();
            this.doLinkDelete(nextDeadID, genome, support);
        }
        if (localUndo) {
            support.finish();
        }
        return true;
    }

    private void doLinkDelete(String deadID, Genome genome, UndoSupport support) {
        boolean removeProperties;
        boolean isRoot;
        GenomeInstance inst;
        Database db = Database.getDB();
        if (genome instanceof GenomeInstance) {
            inst = (GenomeInstance)genome;
            isRoot = false;
            removeProperties = inst.getVfgParent() == null;
        } else {
            inst = null;
            isRoot = true;
            removeProperties = true;
        }
        Iterator iit = db.getInstanceIterator();
        HashSet<String> deadSet = new HashSet<String>();
        while (iit.hasNext()) {
            deadSet.clear();
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (isRoot || inst.isAncestor(gi)) {
                Iterator lit = gi.getLinkageIterator();
                while (lit.hasNext()) {
                    LinkageInstance li = (LinkageInstance)lit.next();
                    if ((!isRoot || !deadID.equals(li.getBacking().getID())) && !deadID.equals(li.getID())) continue;
                    deadSet.add(li.getID());
                }
            }
            Iterator dsit = deadSet.iterator();
            while (dsit.hasNext()) {
                String key = (String)dsit.next();
                GenomeChange gc = gi.removeLinkage(key);
                if (gc != null) {
                    GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                    support.addEdit(gcc);
                }
                if (!removeProperties) continue;
                Iterator layit = db.getLayoutIterator();
                while (layit.hasNext()) {
                    Layout.PropChange[] lpc;
                    Layout layout = (Layout)layit.next();
                    if (!layout.getTarget().equals(gi.getID()) || (lpc = new Layout.PropChange[]{layout.removeLinkProperties(key)})[0] == null) continue;
                    PropChangeCmd pcc = new PropChangeCmd(lpc);
                    support.addEdit(pcc);
                }
            }
        }
        if (isRoot) {
            GenomeChange gc = genome.removeLinkage(deadID);
            if (gc != null) {
                GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                support.addEdit(gcc);
            }
            Iterator layit = db.getLayoutIterator();
            while (layit.hasNext()) {
                Layout.PropChange[] lpc;
                Layout layout = (Layout)layit.next();
                if (!layout.getTarget().equals(genome.getID()) || (lpc = new Layout.PropChange[]{layout.removeLinkProperties(deadID)})[0] == null) continue;
                PropChangeCmd pcc = new PropChangeCmd(lpc);
                support.addEdit(pcc);
            }
        }
    }

    private int doNodeDelete(String deadID, Genome genome, UndoSupport support, int multiDelete, boolean keepEmptyMemOnly) {
        Layout.PropChange[] lpc;
        boolean removeProperties;
        boolean isRoot;
        GenomeInstance inst;
        Database db = Database.getDB();
        if (genome instanceof GenomeInstance) {
            inst = (GenomeInstance)genome;
            isRoot = false;
            removeProperties = inst.getVfgParent() == null;
        } else {
            inst = null;
            isRoot = true;
            removeProperties = true;
        }
        boolean needGeneral = false;
        boolean goodbyeExtras = false;
        Iterator iit = db.getInstanceIterator();
        HashSet<String> deadSet = new HashSet<String>();
        while (iit.hasNext()) {
            deadSet.clear();
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (isRoot || inst.isAncestor(gi)) {
                NodeInstance ni;
                Iterator nit = gi.getNodeIterator();
                while (nit.hasNext()) {
                    ni = (NodeInstance)nit.next();
                    if ((!isRoot || !deadID.equals(ni.getBacking().getID())) && !deadID.equals(ni.getID())) continue;
                    deadSet.add(ni.getID());
                }
                nit = gi.getGeneIterator();
                while (nit.hasNext()) {
                    ni = (NodeInstance)nit.next();
                    if ((!isRoot || !deadID.equals(ni.getBacking().getID())) && !deadID.equals(ni.getID())) continue;
                    deadSet.add(ni.getID());
                }
            }
            Iterator dsit = deadSet.iterator();
            while (dsit.hasNext()) {
                String key = (String)dsit.next();
                GenomeChange gc = gi.removeNode(key);
                if (gc != null) {
                    GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                    support.addEdit(gcc);
                }
                Iterator layit = db.getLayoutIterator();
                while (layit.hasNext()) {
                    NodeProperties np;
                    Layout layout = (Layout)layit.next();
                    if (layout.haveNodeMetadataDependency(gi.getID(), key) && (lpc = layout.dropNodeMetadataDependency(gi.getID(), key)) != null) {
                        PropChangeCmd pcc = new PropChangeCmd((Layout.PropChange)lpc);
                        support.addEdit(pcc);
                    }
                    if (!layout.getTarget().equals(gi.getID()) || (np = layout.getNodeProperties(key)) == null) continue;
                    Layout.PropChange[] lpc2 = new Layout.PropChange[]{layout.removeNodeProperties(key)};
                    if (lpc2 == null) continue;
                    PropChangeCmd pcc = new PropChangeCmd(lpc2);
                    support.addEdit(pcc);
                }
                Iterator git = gi.getGroupIterator();
                while (git.hasNext()) {
                    GroupChange grc;
                    Group gr = (Group)git.next();
                    if (gr.isInherited() || !gr.isInGroup(key, gi) || (grc = gr.removeMember(key, gi.getID())) == null) continue;
                    GroupChangeCmd gcc = new GroupChangeCmd(grc);
                    support.addEdit(gcc);
                }
                this.supportNodeDeletionFromOverlays(gi, gi.getID(), support, key, keepEmptyMemOnly);
                Iterator pxit = db.getDynamicProxyIterator();
                while (pxit.hasNext()) {
                    DynamicInstanceProxy dip = (DynamicInstanceProxy)pxit.next();
                    if (!dip.instanceIsAncestor(gi)) continue;
                    if (dip.hasAddedNode(key)) {
                        ProxyChange pc = dip.deleteExtraNode(key);
                        if (pc == null) continue;
                        ProxyChangeCmd pcc = new ProxyChangeCmd(pc);
                        support.addEdit(pcc);
                        needGeneral = true;
                        goodbyeExtras = true;
                        continue;
                    }
                    if (!this.supportNodeDeletionFromOverlays(dip, dip.getFirstProxiedKey(), support, key, keepEmptyMemOnly)) continue;
                    needGeneral = true;
                }
            }
        }
        if (!keepEmptyMemOnly && goodbyeExtras && this.proxyPostExtraNodeDeletionSupport(support)) {
            needGeneral = true;
        }
        int retval = 1;
        if (isRoot) {
            String deadName = genome.getNode(deadID).getRootName();
            GenomeChange gc = genome.removeNode(deadID);
            if (gc != null) {
                GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                support.addEdit(gcc);
            }
            this.supportNodeDeletionFromOverlays(genome, genome.getID(), support, deadID, keepEmptyMemOnly);
            Iterator layit = db.getLayoutIterator();
            while (layit.hasNext()) {
                NodeProperties np;
                Layout layout = (Layout)layit.next();
                if (!layout.getTarget().equals(genome.getID()) || (np = layout.getNodeProperties(deadID)) == null) continue;
                lpc = new Layout.PropChange[]{layout.removeNodeProperties(deadID)};
                if (lpc == null) continue;
                PropChangeCmd mov = new PropChangeCmd(lpc);
                support.addEdit(mov);
            }
            TimeCourseData tcd = db.getTimeCourseData();
            TemporalInputRangeData tird = db.getTemporalInputRangeData();
            boolean deleteUnderlyingTables = false;
            ResourceManager rMan = ResourceManager.getManager();
            if (tcd != null && tcd.haveDataForNodeOrName(deadID, deadName) || tird != null && tird.haveDataForNodeOrName(deadID, deadName)) {
                if (multiDelete == 3 || multiDelete == 4) {
                    deleteUnderlyingTables = true;
                } else if (multiDelete == 2 || multiDelete == 5) {
                    deleteUnderlyingTables = false;
                } else if (multiDelete == 0) {
                    int result = JOptionPane.showConfirmDialog(this.topWindow_, rMan.getString("nodeDelete.doDataMessage"), rMan.getString("nodeDelete.messageTitle"), 0);
                    deleteUnderlyingTables = result == 0;
                } else if (multiDelete == 1) {
                    int result = JOptionPane.showOptionDialog(this.topWindow_, rMan.getString("nodeDelete.doDataMessage"), rMan.getString("nodeDelete.messageTitle"), -1, 3, null, new Object[]{rMan.getString("dialogs.yesToAll"), rMan.getString("dialogs.noToAll"), rMan.getString("dialogs.yes"), rMan.getString("dialogs.no")}, rMan.getString("dialogs.no"));
                    boolean bl = deleteUnderlyingTables = result == 0 || result == 2;
                    if (result == 0) {
                        retval = 2;
                    } else if (result == 1) {
                        retval = 3;
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
            boolean haveDeleted = false;
            if (deleteUnderlyingTables) {
                haveDeleted = this.deleteUnderlyingTables(support, deadID, deadName);
            }
            if ((haveDeleted |= this.deleteDataMaps(support, deadID)) || needGeneral) {
                support.addEvent(new GeneralChangeEvent(2));
            }
        }
        return retval;
    }

    public boolean supportNodeDeletionFromOverlays(NetOverlayOwner owner, String genomeID, UndoSupport support, String key, boolean keepEmptyMemOnly) {
        Layout glo = Database.getDB().getLayout(new LayoutManager().getLayout(genomeID));
        boolean retval = false;
        HashMap<String, HashSet<String>> deadMods = new HashMap<String, HashSet<String>>();
        Iterator oit = owner.getNetworkOverlayIterator();
        while (oit.hasNext()) {
            NetworkOverlay no = (NetworkOverlay)oit.next();
            String noID = no.getID();
            Iterator nmit = no.getModuleIterator();
            while (nmit.hasNext()) {
                NetModuleChange nmc;
                NetOverlayProperties noProps;
                NetModuleProperties nmp;
                NetModule nmod = (NetModule)nmit.next();
                String nmID = nmod.getID();
                if (!nmod.isAMember(key)) continue;
                if (!keepEmptyMemOnly && nmod.getMemberCount() == 1 && (nmp = (noProps = glo.getNetOverlayProperties(noID)).getNetModuleProperties(nmID)).getType() == 2) {
                    HashSet<String> deadSet = (HashSet<String>)deadMods.get(noID);
                    if (deadSet == null) {
                        deadSet = new HashSet<String>();
                        deadMods.put(noID, deadSet);
                    }
                    deadSet.add(nmID);
                }
                if ((nmc = owner.deleteMemberFromNetworkModule(noID, nmod, key)) == null) continue;
                NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmc);
                support.addEdit(gcc);
                retval = true;
            }
        }
        if (!deadMods.isEmpty()) {
            NetOverlayController noc = MainCommands.getCmds().getOverlayController();
            Iterator dmit = deadMods.keySet().iterator();
            while (dmit.hasNext()) {
                String ovrKey = (String)dmit.next();
                HashSet deadSet = (HashSet)deadMods.get(ovrKey);
                Iterator dsit = deadSet.iterator();
                while (dsit.hasNext()) {
                    String deadModID = (String)dsit.next();
                    this.deleteNetworkModule(genomeID, ovrKey, deadModID, support);
                }
            }
            noc.cleanUpDeletedModules(deadMods, support);
        }
        return retval;
    }

    public boolean proxyPostExtraNodeDeletionSupport(UndoSupport support) {
        Database db = Database.getDB();
        LayoutManager lm = new LayoutManager();
        NetOverlayController noc = MainCommands.getCmds().getOverlayController();
        Iterator dit = db.getDynamicProxyIterator();
        boolean didIt = false;
        while (dit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dit.next();
            String genomeID = dip.getFirstProxiedKey();
            Layout glo = db.getLayout(lm.getLayout(genomeID));
            HashMap<String, HashSet<String>> deadMods = new HashMap<String, HashSet<String>>();
            Iterator oit = dip.getNetworkOverlayIterator();
            while (oit.hasNext()) {
                NetworkOverlay no = (NetworkOverlay)oit.next();
                String noID = no.getID();
                Iterator nmit = no.getModuleIterator();
                while (nmit.hasNext()) {
                    NetOverlayProperties noProps;
                    NetModuleProperties nmp;
                    NetModule nmod = (NetModule)nmit.next();
                    String nmID = nmod.getID();
                    if (nmod.getMemberCount() != 0 || (nmp = (noProps = glo.getNetOverlayProperties(noID)).getNetModuleProperties(nmID)).getType() != 2) continue;
                    HashSet<String> deadSet = (HashSet<String>)deadMods.get(noID);
                    if (deadSet == null) {
                        deadSet = new HashSet<String>();
                        deadMods.put(noID, deadSet);
                    }
                    deadSet.add(nmID);
                }
            }
            if (deadMods.isEmpty()) continue;
            Iterator dmit = deadMods.keySet().iterator();
            while (dmit.hasNext()) {
                String ovrKey = (String)dmit.next();
                HashSet deadSet = (HashSet)deadMods.get(ovrKey);
                Iterator dsit = deadSet.iterator();
                while (dsit.hasNext()) {
                    String deadModID = (String)dsit.next();
                    this.deleteNetworkModule(genomeID, ovrKey, deadModID, support);
                }
            }
            noc.cleanUpDeletedModules(deadMods, support);
            didIt = true;
        }
        return didIt;
    }

    public static class LinkCandidate {
        public static final int EMPTY = 0;
        public static final int ADDING = 1;
        public static final int DONE = 2;
        public ArrayList points = new ArrayList();
        public int buildState = 0;
        public Intersection source;
        public Intersection target;
        public int sign = 0;
        public String label;
    }
}

