/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.DialogBuiltGeneralMotif;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotif;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotifPair;
import org.systemsbiology.biotapestry.cmd.DialogBuiltProtoMotif;
import org.systemsbiology.biotapestry.cmd.GeneralBuildInstruction;
import org.systemsbiology.biotapestry.cmd.OldPadMapper;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.cmd.PadConstraints;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBLinkage;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class DialogBuiltGeneralProtoMotif
extends DialogBuiltProtoMotif {
    protected int linkSign_;
    protected int evidenceLevel_;

    public DialogBuiltGeneralProtoMotif() {
    }

    public DialogBuiltGeneralProtoMotif(String sourceName, int sourceType, String targetName, int targetType, int linkSign, int evidenceLevel) {
        super(sourceName, sourceType, targetName, targetType);
        this.linkSign_ = linkSign;
        this.evidenceLevel_ = evidenceLevel;
    }

    public Object clone() {
        DialogBuiltGeneralProtoMotif retval = (DialogBuiltGeneralProtoMotif)super.clone();
        return retval;
    }

    public int getLinkSign() {
        return this.linkSign_;
    }

    public void setLinkSign(int linkSign) {
        this.linkSign_ = linkSign;
    }

    public String toString() {
        return "DialogBuiltGeneralProtoMotif: (" + super.toString() + ")" + " linkSign_ = " + this.linkSign_ + " evidenceLevel_ = " + this.evidenceLevel_;
    }

    public void patternMatchMotif(DBGenome genome, Node oldNode, DialogBuiltMotifPair pair, List fullList, OldPadMapper oldPads) {
        if (pair.proto != this) {
            throw new IllegalArgumentException();
        }
        DialogBuiltGeneralMotif real = new DialogBuiltGeneralMotif();
        pair.real = real;
        if (oldNode == null) {
            return;
        }
        if (oldNode.getNodeType() != this.sourceType_) {
            throw new IllegalArgumentException();
        }
        real.setSourceId(oldNode.getID());
        Node targNode = DialogBuiltGeneralProtoMotif.nodeMatchingNameAndType(genome, this.targetName_, this.targetType_);
        if (targNode == null) {
            return;
        }
        real.setTargetId(targNode.getID());
        Set existing = this.matchingLinkSet(genome, pair, fullList);
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (!link.getSource().equals(real.getSourceId()) || !link.getTarget().equals(real.getTargetId()) || GeneralBuildInstruction.mapFromLinkageSign(link.getSign()) != this.linkSign_ || existing.contains(link.getID())) continue;
            real.setLinkId(link.getID());
            if (oldPads != null) {
                oldPads.setPadPair(link.getSource(), link.getTarget(), link.getID(), link.getLaunchPad(), link.getLandingPad());
            }
            return;
        }
    }

    public DialogBuiltMotif getEmptyRealMotif() {
        return new DialogBuiltGeneralMotif();
    }

    public void generateRealMotif(DBGenome genome, DBGenome oldGenome, DialogBuiltMotifPair pair, DialogBuiltMotif oldMotif, List fullList, List existingList, Map newNodeToOldNode, Map newLinksToOldLinks, Map newTypesByID, AddCommands ac, OldPadMapper opm, Map padConstraintSaver, UndoSupport support, boolean existingOnly) {
        DialogBuiltMotifPair oldPair;
        DialogBuiltMotifPair nextPair;
        int i;
        String newID;
        DBNode newNode;
        DialogBuiltGeneralMotif real = (DialogBuiltGeneralMotif)pair.real;
        DialogBuiltGeneralMotif oldGen = (DialogBuiltGeneralMotif)oldMotif;
        int lsize = fullList.size();
        String oldID = oldGen.getSourceId();
        if (!(oldID == null && existingOnly || real.getSourceId() != null)) {
            newNode = this.genNode(genome, oldGenome, this.sourceName_, this.sourceType_, oldID, support);
            newID = newNode.getID();
            real.setSourceId(newID);
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                oldPair = (DialogBuiltMotifPair)existingList.get(i);
                nextPair.proto.fillNodesFromMatches(newNode, pair, oldPair, newNodeToOldNode, nextPair.real);
            }
            if (newNodeToOldNode.get(newID) == null) {
                newTypesByID.put(newID, new Integer(this.sourceType_));
            }
        }
        if (!((oldID = oldGen.getTargetId()) == null && existingOnly || real.getTargetId() != null || this.targetName_ == null)) {
            newNode = this.genNode(genome, oldGenome, this.targetName_, this.targetType_, oldID, support);
            newID = newNode.getID();
            real.setTargetId(newID);
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                oldPair = (DialogBuiltMotifPair)existingList.get(i);
                nextPair.proto.fillNodesFromMatches(newNode, pair, oldPair, newNodeToOldNode, nextPair.real);
            }
            if (newNodeToOldNode.get(newID) == null) {
                newTypesByID.put(newID, new Integer(this.targetType_));
            }
        }
        if ((oldID = oldGen.getLinkId()) != null || !existingOnly) {
            PadCalculatorToo padCalc = new PadCalculatorToo();
            PadConstraints pc = padCalc.generatePadConstraints(real.getSourceId(), real.getTargetId(), opm, oldGen.getLinkId(), newNodeToOldNode);
            if (real.getLinkId() == null && this.targetName_ != null) {
                DBLinkage newLink = (DBLinkage)ac.autoAddOldOrNewLinkToRoot(real.getSourceId(), real.getTargetId(), GeneralBuildInstruction.mapToLinkageSign(this.linkSign_), oldGenome, support, true, oldID, pc, this.evidenceLevel_);
                real.setLinkId(newLink.getID());
                padConstraintSaver.put(real.getLinkId(), pc);
                newLinksToOldLinks.put(real.getLinkId(), oldGen.getLinkId());
                for (int i2 = 0; i2 < lsize; ++i2) {
                    DialogBuiltMotifPair nextPair2 = (DialogBuiltMotifPair)fullList.get(i2);
                    nextPair2.proto.fillLinksFromMatches(newLink, pair, nextPair2.real);
                }
            }
        }
    }

    public void fillNodesFromMatches(DBNode newNode, DialogBuiltMotifPair filledPair, DialogBuiltMotifPair oldPair, Map newNodeToOldNode, DialogBuiltMotif realMotif) {
        String normName = DataUtil.normKey(newNode.getName());
        if (normName.equals("")) {
            return;
        }
        if (DataUtil.keysEqual(this.sourceName_, normName)) {
            if (realMotif.getSourceId() == null) {
                if (newNode.getNodeType() != this.sourceType_) {
                    throw new IllegalStateException();
                }
                realMotif.setSourceId(newNode.getID());
            }
            if (oldPair.real.getSourceId() != null) {
                newNodeToOldNode.put(newNode.getID(), oldPair.real.getSourceId());
            }
        }
        if (DataUtil.keysEqual(this.targetName_, normName)) {
            if (realMotif.getTargetId() == null) {
                if (newNode.getNodeType() != this.targetType_) {
                    throw new IllegalStateException();
                }
                realMotif.setTargetId(newNode.getID());
            }
            if (oldPair.real.getTargetId() != null) {
                newNodeToOldNode.put(newNode.getID(), oldPair.real.getTargetId());
            }
        }
    }

    public void fillLinksFromMatches(DBLinkage newLink, DialogBuiltMotifPair filledPair, DialogBuiltMotif realMotif) {
    }

    private Set matchingLinkSet(DBGenome genome, DialogBuiltMotifPair pair, List fullList) {
        DialogBuiltGeneralMotif myMotif = (DialogBuiltGeneralMotif)pair.real;
        if (myMotif.getSourceId() == null || myMotif.getTargetId() == null || myMotif.getLinkId() != null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> retval = new HashSet<String>();
        int size = fullList.size();
        for (int i = 0; i < size; ++i) {
            DialogBuiltGeneralMotif nextMotif;
            DialogBuiltMotifPair nextPair = (DialogBuiltMotifPair)fullList.get(i);
            if (nextPair.real == null || !(nextPair.real instanceof DialogBuiltGeneralMotif) || (nextMotif = (DialogBuiltGeneralMotif)nextPair.real).getSourceId() == null || nextMotif.getTargetId() == null || !myMotif.getSourceId().equals(nextMotif.getSourceId()) || !myMotif.getTargetId().equals(nextMotif.getTargetId()) || nextMotif.getLinkId() == null) continue;
            retval.add(nextMotif.getLinkId());
        }
        return retval;
    }
}

