/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.util.List;
import java.util.Map;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.DialogBuiltLoneNodeMotif;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotif;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotifPair;
import org.systemsbiology.biotapestry.cmd.DialogBuiltProtoMotif;
import org.systemsbiology.biotapestry.cmd.OldPadMapper;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBLinkage;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class DialogBuiltLoneNodeProtoMotif
extends DialogBuiltProtoMotif {
    public DialogBuiltLoneNodeProtoMotif() {
    }

    public DialogBuiltLoneNodeProtoMotif(String sourceName, int sourceType) {
        super(sourceName, sourceType, null, -1);
    }

    public Object clone() {
        DialogBuiltLoneNodeProtoMotif retval = (DialogBuiltLoneNodeProtoMotif)super.clone();
        return retval;
    }

    public String toString() {
        return "DialogBuiltLoneProtoMotif: (" + super.toString() + ")";
    }

    public void patternMatchMotif(DBGenome genome, Node oldNode, DialogBuiltMotifPair pair, List fullList, OldPadMapper oldPads) {
        if (pair.proto != this) {
            throw new IllegalArgumentException();
        }
        DialogBuiltLoneNodeMotif real = new DialogBuiltLoneNodeMotif();
        pair.real = real;
        if (oldNode == null) {
            return;
        }
        if (oldNode.getNodeType() != this.sourceType_) {
            throw new IllegalArgumentException();
        }
        real.setSourceId(oldNode.getID());
    }

    public DialogBuiltMotif getEmptyRealMotif() {
        return new DialogBuiltLoneNodeMotif();
    }

    public void generateRealMotif(DBGenome genome, DBGenome oldGenome, DialogBuiltMotifPair pair, DialogBuiltMotif oldMotif, List fullList, List existingList, Map newNodeToOldNode, Map newLinksToOldLinks, Map newTypesByID, AddCommands ac, OldPadMapper opm, Map padConstraintSaver, UndoSupport support, boolean existingOnly) {
        DialogBuiltLoneNodeMotif real = (DialogBuiltLoneNodeMotif)pair.real;
        DialogBuiltLoneNodeMotif oldLone = (DialogBuiltLoneNodeMotif)oldMotif;
        int lsize = fullList.size();
        String oldID = oldLone.getSourceId();
        if (!(oldID == null && existingOnly || real.getSourceId() != null)) {
            DBNode newNode = this.genNode(genome, oldGenome, this.sourceName_, this.sourceType_, oldID, support);
            String newID = newNode.getID();
            real.setSourceId(newID);
            for (int i = 0; i < lsize; ++i) {
                DialogBuiltMotifPair nextPair = (DialogBuiltMotifPair)fullList.get(i);
                DialogBuiltMotifPair oldPair = (DialogBuiltMotifPair)existingList.get(i);
                nextPair.proto.fillNodesFromMatches(newNode, pair, oldPair, newNodeToOldNode, nextPair.real);
            }
            if (newNodeToOldNode.get(newID) == null) {
                newTypesByID.put(newID, new Integer(this.sourceType_));
            }
        }
    }

    public void fillNodesFromMatches(DBNode newNode, DialogBuiltMotifPair filledPair, DialogBuiltMotifPair oldPair, Map newNodeToOldNode, DialogBuiltMotif realMotif) {
        String normName = DataUtil.normKey(newNode.getName());
        if (normName.equals("")) {
            return;
        }
        if (DataUtil.keysEqual(this.sourceName_, normName)) {
            if (realMotif.getSourceId() == null) {
                if (newNode.getNodeType() != this.sourceType_) {
                    throw new IllegalStateException();
                }
                realMotif.setSourceId(newNode.getID());
            }
            if (oldPair.real.getSourceId() != null) {
                newNodeToOldNode.put(newNode.getID(), oldPair.real.getSourceId());
            }
        }
    }

    public void fillLinksFromMatches(DBLinkage newLink, DialogBuiltMotifPair filledPair, DialogBuiltMotif realMotif) {
    }
}

