/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.PatternGrid;

public abstract class DialogBuiltMotif {
    public static final int SOURCE_SOURCE = 0;
    public static final int SOURCE_TARGET = 1;
    public static final int TARGET_TARGET = 2;
    public static final int TARGET_SOURCE = 3;
    protected String sourceId_;
    protected String targetId_;

    public DialogBuiltMotif() {
    }

    public DialogBuiltMotif(String sourceId, String targetId) {
        this.sourceId_ = sourceId;
        this.targetId_ = targetId;
    }

    public String getSourceId() {
        return this.sourceId_;
    }

    public void setSourceId(String sourceId) {
        this.sourceId_ = sourceId;
    }

    public boolean hasTarget() {
        return this.targetId_ != null;
    }

    public String getTargetId() {
        return this.targetId_;
    }

    public void setTargetId(String targetId) {
        this.targetId_ = targetId;
    }

    public abstract String[] ordering();

    public abstract int getLinkCount();

    public abstract Link getLink(int var1);

    public abstract DialogBuiltMotif emptyCopy();

    public Placement getPlacementInfo(Map columnInfo, Set placed, Set needToPlace, PatternGrid grid) {
        Integer[] colData = this.getColumns(columnInfo, placed, needToPlace);
        Pattern pat = this.genPattern(colData);
        if (pat == null) {
            return null;
        }
        int leftColumn = Integer.MAX_VALUE;
        int size = colData.length;
        for (int i = 0; i < size; ++i) {
            int value;
            if (colData[i] == null || (value = colData[i].intValue()) >= leftColumn) continue;
            leftColumn = value;
        }
        Integer[] rowData = null;
        if (this.nodeIsPlaced(colData)) {
            rowData = this.getRows(grid, placed, needToPlace);
        }
        Integer suggestedRow = this.getSuggestedRow(rowData);
        return new Placement(pat, suggestedRow, new Integer(leftColumn));
    }

    public Integer getSuggestedRow(Integer[] rowData) {
        Integer suggestedRow = null;
        if (rowData != null) {
            int size = rowData.length;
            for (int i = 0; i < size; ++i) {
                if (rowData[i] == null) continue;
                suggestedRow = rowData[i];
                break;
            }
        }
        return suggestedRow;
    }

    protected boolean nodeIsPlaced(Integer[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] != null) continue;
            return true;
        }
        return false;
    }

    protected Integer[] getColumns(Map columnInfo, Set placed, Set needToPlace) {
        Integer[] retval = new Integer[2];
        if (needToPlace.contains(this.sourceId_) && !placed.contains(this.sourceId_)) {
            retval[0] = (Integer)columnInfo.get(this.sourceId_);
        }
        if (needToPlace.contains(this.targetId_) && !placed.contains(this.targetId_)) {
            retval[1] = (Integer)columnInfo.get(this.targetId_);
        }
        return retval;
    }

    protected Pattern genPattern(Integer[] columns) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            if (columns[i] == null) continue;
            int value = columns[i];
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        if (min == Integer.MAX_VALUE || max == Integer.MIN_VALUE) {
            return null;
        }
        Pattern retval = new Pattern(max - min + 1, 1);
        if (columns[0] != null) {
            retval.fill(columns[0] - min, 0, this.sourceId_);
        }
        if (columns[1] != null) {
            retval.fill(columns[1] - min, 0, this.targetId_);
        }
        return retval;
    }

    protected Integer[] getRows(PatternGrid grid, Set placed, Set needToPlace) {
        Integer[] retval = new Integer[2];
        if (placed.contains(this.sourceId_)) {
            retval[0] = new Integer(grid.getLocation((String)this.sourceId_).y);
        }
        if (placed.contains(this.targetId_)) {
            retval[1] = new Integer(grid.getLocation((String)this.targetId_).y);
        }
        return retval;
    }

    public void getExistingNodesAndLinks(Set nodes, Set links) {
        if (this.sourceId_ != null) {
            nodes.add(this.sourceId_);
        }
        if (this.targetId_ != null) {
            nodes.add(this.targetId_);
        }
    }

    public void getRegionAssignments(Set srcRegionNodes, Set targRegionNodes, Map linkTupleMap) {
        if (this.sourceId_ != null) {
            srcRegionNodes.add(this.sourceId_);
        }
        if (this.targetId_ != null) {
            targRegionNodes.add(this.targetId_);
        }
    }

    public String toString() {
        return "DialogBuiltMotif:sourceId = " + this.sourceId_ + "targetId = " + this.targetId_;
    }

    public static class DBMComparator
    implements Comparator {
        public Pattern pattern;
        public Integer suggestedRow;
        public Integer leftColumn;

        public int compare(Object first, Object second) {
            boolean sht;
            DialogBuiltMotif firstDbm = (DialogBuiltMotif)first;
            DialogBuiltMotif secondDbm = (DialogBuiltMotif)second;
            int fComp = firstDbm.getSourceId().compareTo(secondDbm.getSourceId());
            if (fComp != 0) {
                return fComp;
            }
            boolean fht = firstDbm.hasTarget();
            if (fht == (sht = secondDbm.hasTarget())) {
                if (!fht) {
                    return 0;
                }
                return firstDbm.getTargetId().compareTo(secondDbm.getTargetId());
            }
            return fht ? -1 : 1;
        }
    }

    public static class Placement {
        public Pattern pattern;
        public Integer suggestedRow;
        public Integer leftColumn;

        public Placement(Pattern pattern, Integer suggestedRow, Integer leftColumn) {
            this.pattern = pattern;
            this.suggestedRow = suggestedRow;
            this.leftColumn = leftColumn;
        }
    }
}

