/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotif;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotifPair;
import org.systemsbiology.biotapestry.cmd.GenomeChangeCmd;
import org.systemsbiology.biotapestry.cmd.OldPadMapper;
import org.systemsbiology.biotapestry.genome.DBGene;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBLinkage;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.util.UndoSupport;

public abstract class DialogBuiltProtoMotif
implements Cloneable {
    protected int sourceType_;
    protected String sourceName_;
    protected String targetName_;
    protected int targetType_;

    public DialogBuiltProtoMotif() {
    }

    public DialogBuiltProtoMotif(String sourceName, int sourceType, String targetName, int targetType) {
        this.sourceName_ = sourceName;
        this.sourceType_ = sourceType;
        this.targetName_ = targetName;
        this.targetType_ = targetType;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String getSourceName() {
        return this.sourceName_;
    }

    public int getSourceType() {
        return this.sourceType_;
    }

    public void setSourceName(String sourceName) {
        this.sourceName_ = sourceName;
    }

    public void setSourceType(int sourceType) {
        this.sourceType_ = sourceType;
    }

    public String getTargetName() {
        return this.targetName_;
    }

    public int getTargetType() {
        return this.targetType_;
    }

    public void setTargetName(String targetName) {
        this.targetName_ = targetName;
    }

    public void setTargetType(int targetType) {
        this.targetType_ = targetType;
    }

    public String toString() {
        return "DialogBuiltProtoMotif: sourceName = " + this.sourceName_ + " sourceType = " + this.sourceType_ + " targetName = " + this.targetName_ + " targetType = " + this.targetType_;
    }

    public abstract void patternMatchMotif(DBGenome var1, Node var2, DialogBuiltMotifPair var3, List var4, OldPadMapper var5);

    public static Node nodeMatchingNameAndType(DBGenome genome, String name, int type) {
        if (type == 4) {
            return genome.getGeneWithName(name);
        }
        Set oldNodes = genome.getNodesWithName(name);
        Iterator onit = oldNodes.iterator();
        while (onit.hasNext()) {
            Node nextNode = (Node)onit.next();
            if (nextNode.getNodeType() != type) continue;
            return nextNode;
        }
        return null;
    }

    public abstract void generateRealMotif(DBGenome var1, DBGenome var2, DialogBuiltMotifPair var3, DialogBuiltMotif var4, List var5, List var6, Map var7, Map var8, Map var9, AddCommands var10, OldPadMapper var11, Map var12, UndoSupport var13, boolean var14);

    public abstract DialogBuiltMotif getEmptyRealMotif();

    public abstract void fillNodesFromMatches(DBNode var1, DialogBuiltMotifPair var2, DialogBuiltMotifPair var3, Map var4, DialogBuiltMotif var5);

    public abstract void fillLinksFromMatches(DBLinkage var1, DialogBuiltMotifPair var2, DialogBuiltMotif var3);

    protected DBNode genNode(DBGenome genome, DBGenome oldGenome, String name, int type, String oldID, UndoSupport support) {
        DBNode newNode;
        GenomeChange gc;
        String nodeID = oldID == null ? genome.getNextKey() : oldID;
        Node oldNode = null;
        if (oldID != null) {
            oldNode = oldGenome.getNode(oldID);
        }
        if (type == 4) {
            DBGene newGene = oldNode == null ? new DBGene(name, nodeID) : new DBGene((DBGene)oldNode);
            gc = genome.addGeneWithExistingLabel(newGene);
            newNode = newGene;
        } else {
            newNode = oldNode == null ? new DBNode(type, name, nodeID) : new DBNode((DBNode)oldNode);
            gc = genome.addNodeWithExistingLabel(newNode);
        }
        if (gc == null) {
            throw new IllegalStateException();
        }
        support.addEdit(new GenomeChangeCmd(gc));
        return newNode;
    }
}

