/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotif;
import org.systemsbiology.biotapestry.util.Pattern;
import org.systemsbiology.biotapestry.util.PatternGrid;

public class DialogBuiltSignalMotif
extends DialogBuiltMotif {
    protected static final int SOURCE_ = 0;
    protected static final int SIGNAL_ = 1;
    protected static final int BUBBLE_ = 2;
    protected static final int TRANSFAC_ = 3;
    protected static final int TARGET_ = 4;
    protected static final int NUM_COL_TAGS_ = 5;
    protected String signalId_;
    protected String toSignalLinkId_;
    protected String bubbleId_;
    protected String toBubbleLinkId_;
    protected String transFacId_;
    protected String fromTransFacLinkId_;
    protected String toTargetPosLinkId_;
    protected String toTargetNegLinkId_;
    protected int signalMode_;

    public DialogBuiltSignalMotif() {
    }

    public DialogBuiltSignalMotif(String sourceId, String targetId, String signalId, String toSignalLinkId, String bubbleId, String toBubbleLinkId, String transFacId, String fromTransFacLinkId, String toTargetPosLinkId, String toTargetNegLinkId, int signalMode) {
        super(sourceId, targetId);
        this.toSignalLinkId_ = toSignalLinkId;
        this.bubbleId_ = bubbleId;
        this.toBubbleLinkId_ = toBubbleLinkId;
        this.transFacId_ = transFacId;
        this.fromTransFacLinkId_ = fromTransFacLinkId;
        this.toTargetPosLinkId_ = toTargetPosLinkId;
        this.toTargetNegLinkId_ = toTargetNegLinkId;
        this.signalMode_ = signalMode;
    }

    public String getSignalId() {
        return this.signalId_;
    }

    public void setSignalId(String signalId) {
        this.signalId_ = signalId;
    }

    public String getSignalLinkId() {
        return this.toSignalLinkId_;
    }

    public void setSignalLinkId(String toSignalLinkId) {
        this.toSignalLinkId_ = toSignalLinkId;
    }

    public String getBubbleId() {
        return this.bubbleId_;
    }

    public void setBubbleId(String bubbleId) {
        this.bubbleId_ = bubbleId;
    }

    public String getBubbleLinkId() {
        return this.toBubbleLinkId_;
    }

    public void setBubbleLinkId(String toBubbleLinkId) {
        this.toBubbleLinkId_ = toBubbleLinkId;
    }

    public String getTransFacId() {
        return this.transFacId_;
    }

    public void setTransFacId(String transFacId) {
        this.transFacId_ = transFacId;
    }

    public String getTransFacLinkId() {
        return this.fromTransFacLinkId_;
    }

    public void setTransFacLinkId(String fromTransFacLinkId) {
        this.fromTransFacLinkId_ = fromTransFacLinkId;
    }

    public String getTargetPosLinkId() {
        return this.toTargetPosLinkId_;
    }

    public void setTargetPosLinkId(String toTargetPosLinkId) {
        this.toTargetPosLinkId_ = toTargetPosLinkId;
    }

    public String getTargetNegLinkId() {
        return this.toTargetNegLinkId_;
    }

    public void setTargetNegLinkId(String toTargetNegLinkId) {
        this.toTargetNegLinkId_ = toTargetNegLinkId;
    }

    public int getSignalMode() {
        return this.signalMode_;
    }

    public void setSignalMode(int signalMode) {
        this.signalMode_ = signalMode;
    }

    public String[] ordering() {
        return new String[]{this.sourceId_, this.signalId_, this.transFacId_, this.bubbleId_, this.targetId_};
    }

    public DialogBuiltMotif emptyCopy() {
        return new DialogBuiltSignalMotif();
    }

    public void getExistingNodesAndLinks(Set nodes, Set links) {
        super.getExistingNodesAndLinks(nodes, links);
        if (this.signalId_ != null) {
            nodes.add(this.signalId_);
        }
        if (this.toSignalLinkId_ != null) {
            links.add(this.toSignalLinkId_);
        }
        if (this.bubbleId_ != null) {
            nodes.add(this.bubbleId_);
        }
        if (this.toBubbleLinkId_ != null) {
            links.add(this.toBubbleLinkId_);
        }
        if (this.transFacId_ != null) {
            nodes.add(this.transFacId_);
        }
        if (this.fromTransFacLinkId_ != null) {
            links.add(this.fromTransFacLinkId_);
        }
        if (this.toTargetPosLinkId_ != null) {
            links.add(this.toTargetPosLinkId_);
        }
        if (this.toTargetNegLinkId_ != null) {
            links.add(this.toTargetNegLinkId_);
        }
    }

    public void getRegionAssignments(Set srcRegionNodes, Set targRegionNodes, Map linkTupleMap) {
        super.getRegionAssignments(srcRegionNodes, targRegionNodes, linkTupleMap);
        if (this.signalId_ != null) {
            targRegionNodes.add(this.signalId_);
        }
        if (this.bubbleId_ != null) {
            targRegionNodes.add(this.bubbleId_);
        }
        if (this.transFacId_ != null) {
            targRegionNodes.add(this.transFacId_);
        }
        if (this.toSignalLinkId_ != null) {
            linkTupleMap.put(this.toSignalLinkId_, new Integer(1));
        }
        if (this.toBubbleLinkId_ != null) {
            linkTupleMap.put(this.toBubbleLinkId_, new Integer(2));
        }
        if (this.fromTransFacLinkId_ != null) {
            linkTupleMap.put(this.fromTransFacLinkId_, new Integer(2));
        }
        if (this.toTargetPosLinkId_ != null) {
            linkTupleMap.put(this.toTargetPosLinkId_, new Integer(2));
        }
        if (this.toTargetNegLinkId_ != null) {
            linkTupleMap.put(this.toTargetNegLinkId_, new Integer(2));
        }
    }

    public String toString() {
        return "DialogBuiltSignalMotif: (" + super.toString() + ")" + " signalId_ = " + this.signalId_ + " toSignalLinkId_ = " + this.toSignalLinkId_ + " bubbleId_ = " + this.bubbleId_ + " toBubbleLinkId_ = " + this.toBubbleLinkId_ + " transFacId_ = " + this.transFacId_ + " fromTransFacLinkId_ = " + this.fromTransFacLinkId_ + " toTargetPosLinkId_ = " + this.toTargetPosLinkId_ + " toTargetNegLinkId_ = " + this.toTargetNegLinkId_ + " signalMode_ = " + this.signalMode_;
    }

    public int getLinkCount() {
        return this.signalMode_ == 2 ? 5 : 4;
    }

    public Link getLink(int index) {
        switch (index) {
            case 0: {
                return new Link(this.sourceId_, this.signalId_);
            }
            case 1: {
                return new Link(this.signalId_, this.bubbleId_);
            }
            case 2: {
                return new Link(this.transFacId_, this.bubbleId_);
            }
            case 3: {
                return new Link(this.bubbleId_, this.targetId_);
            }
            case 4: {
                if (this.signalMode_ != 2) {
                    throw new IllegalArgumentException();
                }
                return new Link(this.bubbleId_, this.targetId_);
            }
        }
        throw new IllegalArgumentException();
    }

    protected Integer[] getColumns(Map columnInfo, Set placed, Set needToPlace) {
        Integer[] retval = new Integer[5];
        if (needToPlace.contains(this.sourceId_) && !placed.contains(this.sourceId_)) {
            retval[0] = (Integer)columnInfo.get(this.sourceId_);
        }
        if (needToPlace.contains(this.signalId_) && !placed.contains(this.signalId_)) {
            retval[1] = (Integer)columnInfo.get(this.signalId_);
        }
        if (needToPlace.contains(this.bubbleId_) && !placed.contains(this.bubbleId_)) {
            retval[2] = (Integer)columnInfo.get(this.bubbleId_);
        }
        if (needToPlace.contains(this.targetId_) && !placed.contains(this.targetId_) && !this.targetId_.equals(this.sourceId_)) {
            retval[4] = (Integer)columnInfo.get(this.targetId_);
        }
        if (needToPlace.contains(this.transFacId_) && !placed.contains(this.transFacId_) && !this.transFacId_.equals(this.sourceId_) && !this.transFacId_.equals(this.targetId_)) {
            retval[3] = (Integer)columnInfo.get(this.transFacId_);
        }
        return retval;
    }

    protected Pattern genPattern(Integer[] columns) {
        int row;
        Integer count;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            if (columns[i] == null) continue;
            int value = columns[i];
            if (value < min) {
                min = value;
            }
            if (value <= max) continue;
            max = value;
        }
        if (min == Integer.MAX_VALUE || max == Integer.MIN_VALUE) {
            return null;
        }
        HashMap<Integer, Integer> numPerCol = new HashMap<Integer, Integer>();
        for (int i = 0; i < 5; ++i) {
            Integer column = columns[i];
            if (column == null) continue;
            Integer count2 = (Integer)numPerCol.get(column);
            if (count2 == null) {
                numPerCol.put(column, new Integer(1));
                continue;
            }
            numPerCol.put(column, new Integer(count2 + 1));
        }
        int numRow = 1;
        Iterator vit = numPerCol.values().iterator();
        while (vit.hasNext()) {
            Integer val = (Integer)vit.next();
            if (val <= numRow) continue;
            numRow = val;
        }
        Pattern retval = new Pattern(max - min + 1, numRow);
        if (columns[0] != null) {
            count = (Integer)numPerCol.get(columns[0]);
            row = count;
            numPerCol.put(columns[0], new Integer(row - 1));
            retval.fill(columns[0] - min, numRow - row, this.sourceId_);
        }
        if (columns[3] != null) {
            count = (Integer)numPerCol.get(columns[3]);
            row = count;
            numPerCol.put(columns[3], new Integer(row - 1));
            retval.fill(columns[3] - min, numRow - row, this.transFacId_);
        }
        if (columns[4] != null) {
            count = (Integer)numPerCol.get(columns[4]);
            row = count;
            numPerCol.put(columns[4], new Integer(row - 1));
            retval.fill(columns[4] - min, numRow - row, this.targetId_);
        }
        if (columns[1] != null) {
            count = (Integer)numPerCol.get(columns[1]);
            row = count;
            numPerCol.put(columns[1], new Integer(row - 1));
            retval.fill(columns[1] - min, numRow - row, this.signalId_);
        }
        if (columns[2] != null) {
            count = (Integer)numPerCol.get(columns[2]);
            row = count;
            numPerCol.put(columns[2], new Integer(row - 1));
            retval.fill(columns[2] - min, numRow - row, this.bubbleId_);
        }
        return retval;
    }

    protected Integer[] getRows(PatternGrid grid, Set placed, Set needToPlace) {
        Integer[] retval = new Integer[5];
        if (placed.contains(this.sourceId_)) {
            retval[0] = new Integer(grid.getLocation((String)this.sourceId_).y);
        }
        if (placed.contains(this.signalId_)) {
            retval[1] = new Integer(grid.getLocation((String)this.signalId_).y);
        }
        if (placed.contains(this.bubbleId_)) {
            retval[2] = new Integer(grid.getLocation((String)this.bubbleId_).y);
        }
        if (placed.contains(this.transFacId_)) {
            retval[3] = new Integer(grid.getLocation((String)this.transFacId_).y);
        }
        if (placed.contains(this.targetId_)) {
            retval[4] = new Integer(grid.getLocation((String)this.targetId_).y);
        }
        return retval;
    }

    public Integer getSuggestedRow(Integer[] rowData) {
        if (rowData != null) {
            if (rowData[0] != null) {
                return new Integer(rowData[0] - 1);
            }
            if (rowData[3] != null) {
                return rowData[3];
            }
            if (rowData[4] != null) {
                return new Integer(rowData[4] - 1);
            }
            if (rowData[1] != null) {
                return new Integer(rowData[1] - 1);
            }
            if (rowData[2] != null) {
                return new Integer(rowData[2] - 1);
            }
        }
        return null;
    }
}

