/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotif;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotifPair;
import org.systemsbiology.biotapestry.cmd.DialogBuiltProtoMotif;
import org.systemsbiology.biotapestry.cmd.DialogBuiltSignalMotif;
import org.systemsbiology.biotapestry.cmd.OldPadMapper;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.cmd.PadConstraints;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBLinkage;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class DialogBuiltSignalProtoMotif
extends DialogBuiltProtoMotif {
    private static final int POSITIVE_ = 0;
    private static final int NEGATIVE_ = 1;
    protected String transFacName_;
    protected int transFacType_;
    protected int signalMode_;
    protected int evidenceLevel_;

    public DialogBuiltSignalProtoMotif() {
    }

    public DialogBuiltSignalProtoMotif(String sourceName, int sourceType, String targetName, int targetType, String transFacName, int transFacType, int signalMode) {
        super(sourceName, sourceType, targetName, targetType);
        this.transFacName_ = transFacName;
        this.transFacType_ = transFacType;
        this.signalMode_ = signalMode;
        this.evidenceLevel_ = 0;
    }

    public Object clone() {
        DialogBuiltSignalProtoMotif retval = (DialogBuiltSignalProtoMotif)super.clone();
        return retval;
    }

    public void setTransFacName(String transFacName) {
        this.transFacName_ = transFacName;
    }

    public void setTransFacType(int transFacType) {
        this.transFacType_ = transFacType;
    }

    public int getSignalMode() {
        return this.signalMode_;
    }

    public void setSignalMode(int signalMode) {
        this.signalMode_ = signalMode;
    }

    public String toString() {
        return "DialogBuiltSignalProtoMotif: (" + super.toString() + ")" + " transFacName_ = " + this.transFacName_ + " transFacType_ = " + this.transFacType_ + " signalMode_ = " + this.signalMode_;
    }

    public void patternMatchMotif(DBGenome genome, Node oldNode, DialogBuiltMotifPair pair, List fullList, OldPadMapper oldPads) {
        Linkage sigBubLink;
        Linkage toSigLink;
        Node trFacNode;
        if (pair.proto != this) {
            throw new IllegalArgumentException();
        }
        DialogBuiltSignalMotif real = new DialogBuiltSignalMotif();
        pair.real = real;
        if (oldNode == null) {
            return;
        }
        if (oldNode.getNodeType() != this.sourceType_) {
            throw new IllegalArgumentException();
        }
        real.setSourceId(oldNode.getID());
        Node targNode = DialogBuiltSignalProtoMotif.nodeMatchingNameAndType(genome, this.targetName_, this.targetType_);
        if (targNode != null) {
            real.setTargetId(targNode.getID());
        }
        if ((trFacNode = DialogBuiltSignalProtoMotif.nodeMatchingNameAndType(genome, this.transFacName_, this.transFacType_)) != null) {
            real.setTransFacId(trFacNode.getID());
        }
        if ((toSigLink = this.linkExists(genome, real.getSourceId(), null, 0, null, "", 5)) == null) {
            return;
        }
        real.setSignalId(toSigLink.getTarget());
        if (toSigLink.getSign() == 0) {
            real.setSignalLinkId(toSigLink.getID());
            if (oldPads != null) {
                oldPads.setPadPair(toSigLink.getSource(), toSigLink.getTarget(), toSigLink.getID(), toSigLink.getLaunchPad(), toSigLink.getLandingPad());
            }
        }
        if ((sigBubLink = this.linkExists(genome, real.getSignalId(), null, 0, null, "", 3)) == null) {
            return;
        }
        String sigBubID = sigBubLink.getTarget();
        Linkage trfBubLink = this.linkExists(genome, real.getTransFacId(), null, 0, sigBubID, null, 0);
        if (trfBubLink == null) {
            return;
        }
        real.setBubbleId(sigBubID);
        if (sigBubLink.getSign() == 1) {
            real.setBubbleLinkId(sigBubLink.getID());
            if (oldPads != null) {
                oldPads.setPadPair(sigBubLink.getSource(), sigBubLink.getTarget(), sigBubLink.getID(), sigBubLink.getLaunchPad(), sigBubLink.getLandingPad());
            }
        }
        if (trfBubLink.getSign() == 1) {
            real.setTransFacLinkId(trfBubLink.getID());
            if (oldPads != null) {
                oldPads.setPadPair(trfBubLink.getSource(), trfBubLink.getTarget(), trfBubLink.getID(), trfBubLink.getLaunchPad(), trfBubLink.getLandingPad());
            }
        }
        Set[] existing = this.matchingLinkSet(genome, pair, fullList);
        real.setSignalMode(this.signalMode_);
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (link.getSource().equals(real.getBubbleId()) && link.getTarget().equals(real.getTargetId())) {
                int linkSign = link.getSign();
                if (linkSign == -1) {
                    if (!(this.signalMode_ != 1 && this.signalMode_ != 2 || existing[1].contains(link.getID()))) {
                        real.setTargetNegLinkId(link.getID());
                        if (oldPads != null) {
                            oldPads.setPadPair(link.getSource(), link.getTarget(), link.getID(), link.getLaunchPad(), link.getLandingPad());
                        }
                    }
                } else if (!(linkSign != 1 || this.signalMode_ != 0 && this.signalMode_ != 2 || existing[0].contains(link.getID()))) {
                    real.setTargetPosLinkId(link.getID());
                    if (oldPads != null) {
                        oldPads.setPadPair(link.getSource(), link.getTarget(), link.getID(), link.getLaunchPad(), link.getLandingPad());
                    }
                }
            }
            if (!this.satisfied(real)) continue;
            break;
        }
    }

    private boolean satisfied(DialogBuiltSignalMotif real) {
        int mode = real.getSignalMode();
        if (mode == 1 && real.getTargetNegLinkId() != null) {
            return true;
        }
        if (mode == 0 && real.getTargetPosLinkId() != null) {
            return true;
        }
        return mode == 2 && real.getTargetNegLinkId() != null && real.getTargetPosLinkId() != null;
    }

    private Linkage linkExists(DBGenome genome, String srcID, String srcName, int srcType, String trgID, String trgName, int trgType) {
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Node trgNode;
            Node srcNode;
            Linkage link = (Linkage)lit.next();
            String src = link.getSource();
            String trg = link.getTarget();
            if (srcID == null ? (srcNode = genome.getNode(src)).getNodeType() != srcType || !DataUtil.keysEqual(srcName, srcNode.getName()) : !srcID.equals(src)) continue;
            if (trgID != null ? !trgID.equals(trg) : (trgNode = genome.getNode(trg)).getNodeType() != trgType || !DataUtil.keysEqual(trgName, trgNode.getName())) continue;
            return link;
        }
        return null;
    }

    private Set[] matchingLinkSet(DBGenome genome, DialogBuiltMotifPair pair, List fullList) {
        DialogBuiltSignalMotif myMotif = (DialogBuiltSignalMotif)pair.real;
        HashSet<String> retvalPos = new HashSet<String>();
        HashSet<String> retvalNeg = new HashSet<String>();
        int size = fullList.size();
        for (int i = 0; i < size; ++i) {
            DialogBuiltMotifPair nextPair = (DialogBuiltMotifPair)fullList.get(i);
            if (nextPair.real == null || !(nextPair.real instanceof DialogBuiltSignalMotif)) continue;
            DialogBuiltSignalMotif nextMotif = (DialogBuiltSignalMotif)nextPair.real;
            String bubbleID = nextMotif.getBubbleId();
            String targetID = nextMotif.getTargetId();
            if (bubbleID == null || targetID == null) continue;
            String myBubID = myMotif.getBubbleId();
            String myTargID = myMotif.getTargetId();
            if (myBubID == null || myTargID == null || !myBubID.equals(bubbleID) || !myTargID.equals(targetID)) continue;
            if (nextMotif.getTargetNegLinkId() != null) {
                retvalNeg.add(nextMotif.getTargetNegLinkId());
            }
            if (nextMotif.getTargetPosLinkId() == null) continue;
            retvalPos.add(nextMotif.getTargetPosLinkId());
        }
        Set[] retval = new Set[]{retvalPos, retvalNeg};
        return retval;
    }

    public void fillNodesFromMatches(DBNode newNode, DialogBuiltMotifPair filledPair, DialogBuiltMotifPair oldPair, Map newNodeToOldNode, DialogBuiltMotif realMotif) {
        DialogBuiltSignalMotif realSignalMotif = (DialogBuiltSignalMotif)realMotif;
        String normName = DataUtil.normKey(newNode.getName());
        DialogBuiltSignalMotif oldSignalMotif = (DialogBuiltSignalMotif)oldPair.real;
        if (DataUtil.keysEqual(this.sourceName_, normName)) {
            if (realMotif.getSourceId() == null) {
                if (newNode.getNodeType() != this.sourceType_) {
                    throw new IllegalStateException();
                }
                realMotif.setSourceId(newNode.getID());
            }
            if (oldPair.real.getSourceId() != null) {
                newNodeToOldNode.put(newNode.getID(), oldPair.real.getSourceId());
            }
        }
        if (DataUtil.keysEqual(this.targetName_, normName)) {
            if (realMotif.getTargetId() == null) {
                if (newNode.getNodeType() != this.targetType_) {
                    throw new IllegalStateException();
                }
                realMotif.setTargetId(newNode.getID());
            }
            if (oldPair.real.getTargetId() != null) {
                newNodeToOldNode.put(newNode.getID(), oldPair.real.getTargetId());
            }
        }
        if (DataUtil.keysEqual(this.transFacName_, normName)) {
            if (realSignalMotif.getTransFacId() == null) {
                if (newNode.getNodeType() != this.transFacType_) {
                    throw new IllegalStateException();
                }
                realSignalMotif.setTransFacId(newNode.getID());
            }
            if (oldSignalMotif.getTransFacId() != null) {
                newNodeToOldNode.put(newNode.getID(), oldSignalMotif.getTransFacId());
            }
        }
        if (!(filledPair.proto instanceof DialogBuiltSignalProtoMotif)) {
            return;
        }
        DialogBuiltSignalProtoMotif protoSignalMotif = (DialogBuiltSignalProtoMotif)filledPair.proto;
        if (normName.equals("")) {
            if (newNode.getNodeType() == 5 && DataUtil.keysEqual(protoSignalMotif.sourceName_, this.sourceName_)) {
                realSignalMotif.setSignalId(newNode.getID());
                if (oldSignalMotif.getSignalId() != null) {
                    newNodeToOldNode.put(newNode.getID(), oldSignalMotif.getSignalId());
                }
            } else if (newNode.getNodeType() == 3 && DataUtil.keysEqual(protoSignalMotif.sourceName_, this.sourceName_) && DataUtil.keysEqual(protoSignalMotif.transFacName_, this.transFacName_)) {
                realSignalMotif.setBubbleId(newNode.getID());
                if (oldSignalMotif.getBubbleId() != null) {
                    newNodeToOldNode.put(newNode.getID(), oldSignalMotif.getBubbleId());
                }
            }
        }
    }

    public DialogBuiltMotif getEmptyRealMotif() {
        return new DialogBuiltSignalMotif();
    }

    public void generateRealMotif(DBGenome genome, DBGenome oldGenome, DialogBuiltMotifPair pair, DialogBuiltMotif oldMotif, List fullList, List existingList, Map newNodeToOldNode, Map newLinksToOldLinks, Map newTypesByID, AddCommands ac, OldPadMapper opm, Map padConstraintSaver, UndoSupport support, boolean existingOnly) {
        DBLinkage newLink;
        PadConstraints pc;
        DialogBuiltMotifPair oldPair;
        DialogBuiltMotifPair nextPair;
        int i;
        String newID;
        DBNode newNode;
        DialogBuiltSignalMotif real = (DialogBuiltSignalMotif)pair.real;
        DialogBuiltSignalMotif oldSig = (DialogBuiltSignalMotif)oldMotif;
        int lsize = fullList.size();
        PadCalculatorToo padCalc = new PadCalculatorToo();
        String oldID = oldSig.getSourceId();
        if (!(oldID == null && existingOnly || real.getSourceId() != null)) {
            newNode = this.genNode(genome, oldGenome, this.sourceName_, this.sourceType_, oldID, support);
            newID = newNode.getID();
            real.setSourceId(newID);
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                oldPair = (DialogBuiltMotifPair)existingList.get(i);
                nextPair.proto.fillNodesFromMatches(newNode, pair, oldPair, newNodeToOldNode, nextPair.real);
            }
            if (newNodeToOldNode.get(newID) == null) {
                newTypesByID.put(newID, new Integer(this.sourceType_));
            }
        }
        if (!((oldID = oldSig.getTargetId()) == null && existingOnly || real.getTargetId() != null)) {
            newNode = this.genNode(genome, oldGenome, this.targetName_, this.targetType_, oldID, support);
            newID = newNode.getID();
            real.setTargetId(newID);
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                oldPair = (DialogBuiltMotifPair)existingList.get(i);
                nextPair.proto.fillNodesFromMatches(newNode, pair, oldPair, newNodeToOldNode, nextPair.real);
            }
            if (newNodeToOldNode.get(newID) == null) {
                newTypesByID.put(newID, new Integer(this.targetType_));
            }
        }
        if (!((oldID = oldSig.getTransFacId()) == null && existingOnly || real.getTransFacId() != null)) {
            newNode = this.genNode(genome, oldGenome, this.transFacName_, this.transFacType_, oldID, support);
            newID = newNode.getID();
            real.setTransFacId(newID);
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                oldPair = (DialogBuiltMotifPair)existingList.get(i);
                nextPair.proto.fillNodesFromMatches(newNode, pair, oldPair, newNodeToOldNode, nextPair.real);
            }
            if (newNodeToOldNode.get(newID) == null) {
                newTypesByID.put(newID, new Integer(this.transFacType_));
            }
        }
        if (!((oldID = oldSig.getSignalId()) == null && existingOnly || real.getSignalId() != null)) {
            newNode = this.genNode(genome, oldGenome, "", 5, oldID, support);
            newID = newNode.getID();
            real.setSignalId(newID);
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                oldPair = (DialogBuiltMotifPair)existingList.get(i);
                nextPair.proto.fillNodesFromMatches(newNode, pair, oldPair, newNodeToOldNode, nextPair.real);
            }
            if (newNodeToOldNode.get(newID) == null) {
                newTypesByID.put(newID, new Integer(5));
            }
        }
        if (!((oldID = oldSig.getBubbleId()) == null && existingOnly || real.getBubbleId() != null)) {
            newNode = this.genNode(genome, oldGenome, "", 3, oldID, support);
            newID = newNode.getID();
            real.setBubbleId(newID);
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                oldPair = (DialogBuiltMotifPair)existingList.get(i);
                nextPair.proto.fillNodesFromMatches(newNode, pair, oldPair, newNodeToOldNode, nextPair.real);
            }
            if (newNodeToOldNode.get(newID) == null) {
                newTypesByID.put(newID, new Integer(3));
            }
        }
        if (!((oldID = oldSig.getSignalLinkId()) == null && existingOnly || real.getSignalLinkId() != null)) {
            pc = padCalc.generatePadConstraints(real.getSourceId(), real.getSignalId(), opm, oldSig.getSignalLinkId(), newNodeToOldNode);
            newLink = (DBLinkage)ac.autoAddOldOrNewLinkToRoot(real.getSourceId(), real.getSignalId(), 0, oldGenome, support, true, oldID, pc, 0);
            real.setSignalLinkId(newLink.getID());
            padConstraintSaver.put(real.getSignalLinkId(), pc);
            newLinksToOldLinks.put(real.getSignalLinkId(), oldSig.getSignalLinkId());
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                nextPair.proto.fillLinksFromMatches(newLink, pair, nextPair.real);
            }
        }
        if (!((oldID = oldSig.getBubbleLinkId()) == null && existingOnly || real.getBubbleLinkId() != null)) {
            pc = padCalc.generatePadConstraints(real.getSignalId(), real.getBubbleId(), opm, oldSig.getBubbleLinkId(), newNodeToOldNode);
            newLink = (DBLinkage)ac.autoAddOldOrNewLinkToRoot(real.getSignalId(), real.getBubbleId(), 1, oldGenome, support, true, oldID, pc, 0);
            real.setBubbleLinkId(newLink.getID());
            padConstraintSaver.put(real.getBubbleLinkId(), pc);
            newLinksToOldLinks.put(real.getBubbleLinkId(), oldSig.getBubbleLinkId());
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                nextPair.proto.fillLinksFromMatches(newLink, pair, nextPair.real);
            }
        }
        if (!((oldID = oldSig.getTransFacLinkId()) == null && existingOnly || real.getTransFacLinkId() != null)) {
            pc = padCalc.generatePadConstraints(real.getTransFacId(), real.getBubbleId(), opm, oldSig.getTransFacLinkId(), newNodeToOldNode);
            newLink = (DBLinkage)ac.autoAddLinkToRoot(real.getTransFacId(), real.getBubbleId(), 1, support, true, oldID, pc, 0);
            real.setTransFacLinkId(newLink.getID());
            padConstraintSaver.put(real.getTransFacLinkId(), pc);
            newLinksToOldLinks.put(real.getTransFacLinkId(), oldSig.getTransFacLinkId());
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                nextPair.proto.fillLinksFromMatches(newLink, pair, nextPair.real);
            }
        }
        if (!((oldID = oldSig.getTargetPosLinkId()) == null && existingOnly || real.getTargetPosLinkId() != null || this.signalMode_ != 0 && this.signalMode_ != 2)) {
            pc = padCalc.generatePadConstraints(real.getBubbleId(), real.getTargetId(), opm, oldSig.getTargetPosLinkId(), newNodeToOldNode);
            newLink = (DBLinkage)ac.autoAddLinkToRoot(real.getBubbleId(), real.getTargetId(), 1, support, true, oldID, pc, this.evidenceLevel_);
            real.setTargetPosLinkId(newLink.getID());
            padConstraintSaver.put(real.getTargetPosLinkId(), pc);
            newLinksToOldLinks.put(real.getTargetPosLinkId(), oldSig.getTargetPosLinkId());
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                nextPair.proto.fillLinksFromMatches(newLink, pair, nextPair.real);
            }
        }
        if (!((oldID = oldSig.getTargetNegLinkId()) == null && existingOnly || real.getTargetNegLinkId() != null || this.signalMode_ != 1 && this.signalMode_ != 2)) {
            pc = padCalc.generatePadConstraints(real.getBubbleId(), real.getTargetId(), opm, oldSig.getTargetNegLinkId(), newNodeToOldNode);
            newLink = (DBLinkage)ac.autoAddLinkToRoot(real.getBubbleId(), real.getTargetId(), -1, support, true, oldID, pc, this.evidenceLevel_);
            real.setTargetNegLinkId(newLink.getID());
            padConstraintSaver.put(real.getTargetNegLinkId(), pc);
            newLinksToOldLinks.put(real.getTargetNegLinkId(), oldSig.getTargetNegLinkId());
            for (i = 0; i < lsize; ++i) {
                nextPair = (DialogBuiltMotifPair)fullList.get(i);
                nextPair.proto.fillLinksFromMatches(newLink, pair, nextPair.real);
            }
        }
        real.setSignalMode(this.signalMode_);
    }

    public void fillLinksFromMatches(DBLinkage newLink, DialogBuiltMotifPair filledPair, DialogBuiltMotif realMotif) {
        if (!(filledPair.real instanceof DialogBuiltSignalMotif)) {
            return;
        }
        DialogBuiltSignalMotif rsm = (DialogBuiltSignalMotif)realMotif;
        DialogBuiltSignalMotif filledRealSignalMotif = (DialogBuiltSignalMotif)filledPair.real;
        String filledSource = filledRealSignalMotif.getSourceId();
        String filledSignal = filledRealSignalMotif.getSignalId();
        String filledSignalLink = filledRealSignalMotif.getSignalLinkId();
        if (newLink.getID().equals(filledSignalLink)) {
            if (filledSource != null && filledSignal != null && filledSignalLink != null && filledSource.equals(rsm.getSourceId()) && filledSignal.equals(rsm.getSignalId()) && rsm.getSignalLinkId() == null) {
                rsm.setSignalLinkId(filledSignalLink);
            }
            return;
        }
        String filledBubble = filledRealSignalMotif.getBubbleId();
        String filledBubbleLink = filledRealSignalMotif.getBubbleLinkId();
        if (newLink.getID().equals(filledBubbleLink)) {
            if (filledSignal != null && filledBubble != null && filledBubbleLink != null && filledSignal.equals(rsm.getSignalId()) && filledBubble.equals(rsm.getBubbleId()) && rsm.getBubbleLinkId() == null) {
                rsm.setBubbleLinkId(filledBubbleLink);
            }
            return;
        }
        String filledTransFac = filledRealSignalMotif.getTransFacId();
        String filledTransFacLink = filledRealSignalMotif.getTransFacLinkId();
        if (newLink.getID().equals(filledTransFacLink)) {
            if (filledBubble != null && filledTransFac != null && filledTransFacLink != null && filledBubble.equals(rsm.getBubbleId()) && filledTransFac.equals(rsm.getTransFacId()) && rsm.getTransFacLinkId() == null) {
                rsm.setTransFacLinkId(filledTransFacLink);
            }
            return;
        }
    }
}

