/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.cmd.BuildInstruction;
import org.systemsbiology.biotapestry.cmd.BuildInstructionInstance;
import org.systemsbiology.biotapestry.cmd.DatabaseChangeCmd;
import org.systemsbiology.biotapestry.cmd.InstanceInstructionSet;
import org.systemsbiology.biotapestry.cmd.InstructionRegions;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class DuplicateInstructionTracker {
    public List analyzeAllCores(String modelID, List emptyCounts) {
        Database db = Database.getDB();
        HashMap<String, BuildInstruction> biMap = new HashMap<String, BuildInstruction>();
        ArrayList<CoreData> cores = new ArrayList<CoreData>();
        Iterator biit = db.getBuildInstructions();
        while (biit.hasNext()) {
            BuildInstruction bi = (BuildInstruction)biit.next();
            String bid = bi.getID();
            biMap.put(bid, bi);
            CoreData cd = this.getDataForCore(bi, cores);
            if (cd == null) {
                cd = new CoreData(bi);
                cores.add(cd);
                CoreCount emptyCount = this.getCountForCore(bi, emptyCounts);
                cd.emptyRequired = emptyCount.count;
            }
            cd.idCounts.put(bid, new Integer(0));
            cd.emptyForModel = modelID;
        }
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            String key;
            InstanceInstructionSet iis;
            GenomeInstance currGi = (GenomeInstance)giit.next();
            if (currGi.getVfgParent() != null || (iis = db.getInstanceInstructionSet(key = currGi.getID())) == null) continue;
            Iterator iit = iis.getInstructionIterator();
            while (iit.hasNext()) {
                BuildInstructionInstance bii = (BuildInstructionInstance)iit.next();
                String biid = bii.getBaseID();
                BuildInstruction bi = (BuildInstruction)biMap.get(biid);
                CoreData cd = this.getDataForCore(bi, cores);
                cd.add(bii, key);
            }
        }
        int cSize = cores.size();
        for (int i = 0; i < cSize; ++i) {
            CoreData cd = (CoreData)cores.get(i);
            cd.calcMinAndSurplus();
        }
        return cores;
    }

    public boolean haveDuplicateInstructions(List coreAnalysis) {
        int cSize = coreAnalysis.size();
        for (int i = 0; i < cSize; ++i) {
            CoreData cd = (CoreData)coreAnalysis.get(i);
            if (!cd.isMultiCore()) continue;
            return true;
        }
        return false;
    }

    public List optimize(List coreAnalysis, List procList, UndoSupport support) {
        if (!this.haveDuplicateInstructions(coreAnalysis)) {
            return null;
        }
        HashMap oldToNew = new HashMap();
        List removed = this.removeSurplusInstructions(coreAnalysis, oldToNew);
        this.compressInstructions(coreAnalysis, oldToNew);
        Database db = Database.getDB();
        ArrayList<BuildInstruction> newCmds = new ArrayList<BuildInstruction>();
        Iterator biit = db.getBuildInstructions();
        while (biit.hasNext()) {
            BuildInstruction bi = (BuildInstruction)biit.next();
            String bid = bi.getID();
            if (removed.contains(bid)) continue;
            newCmds.add(bi);
        }
        DatabaseChange dc = db.setBuildInstructions(newCmds);
        support.addEdit(new DatabaseChangeCmd(dc));
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            GenomeInstance currGi = (GenomeInstance)giit.next();
            String key = currGi.getID();
            GenomeInstance rootParent = currGi.getVfgParentRoot();
            String parentKey = rootParent == null ? key : rootParent.getID();
            HashMap mapForModel = (HashMap)oldToNew.get(parentKey);
            InstanceInstructionSet iis = db.getInstanceInstructionSet(key);
            if (iis == null) continue;
            InstanceInstructionSet iisNew = new InstanceInstructionSet(iis);
            iisNew.deleteAllInstructions();
            Iterator iit = iis.getInstructionIterator();
            while (iit.hasNext()) {
                BuildInstructionInstance oldBii = (BuildInstructionInstance)iit.next();
                BuildInstructionInstance newBii = null;
                if (mapForModel != null) {
                    newBii = (BuildInstructionInstance)mapForModel.get(oldBii);
                }
                if (newBii == null) {
                    iisNew.addInstruction(new BuildInstructionInstance(oldBii));
                    continue;
                }
                iisNew.addInstruction(newBii);
            }
            dc = db.setInstanceInstructionSet(key, iisNew);
            support.addEdit(new DatabaseChangeCmd(dc));
        }
        return newCmds;
    }

    private CoreData getDataForCore(BuildInstruction bi, List cores) {
        int cSize = cores.size();
        for (int i = 0; i < cSize; ++i) {
            CoreData cd = (CoreData)cores.get(i);
            if (!cd.aCore.sameDefinition(bi)) continue;
            return cd;
        }
        return null;
    }

    private CoreCount getCountForCore(BuildInstruction bi, List cores) {
        int cSize = cores.size();
        for (int i = 0; i < cSize; ++i) {
            CoreCount cc = (CoreCount)cores.get(i);
            if (!cc.core.sameDefinition(bi)) continue;
            return cc;
        }
        return null;
    }

    private List removeSurplusInstructions(List coreAnalysis, Map oldToNew) {
        ArrayList retval = new ArrayList();
        int cSize = coreAnalysis.size();
        for (int i = 0; i < cSize; ++i) {
            CoreData cd = (CoreData)coreAnalysis.get(i);
            if (cd.surplus <= 0) continue;
            List lu = cd.getLeastUsed(cd.surplus);
            cd.reallocateOrphanedInstructions(lu, oldToNew);
            retval.addAll(lu);
        }
        return retval;
    }

    private void compressInstructions(List coreAnalysis, Map oldToNew) {
        int cSize = coreAnalysis.size();
        for (int i = 0; i < cSize; ++i) {
            CoreData cd = (CoreData)coreAnalysis.get(i);
            cd.compressInstructions(oldToNew);
        }
    }

    private static final class ModelAndTuple {
        String modelID;
        InstructionRegions.RegionTuple tuple;

        ModelAndTuple(String modelID, InstructionRegions.RegionTuple tuple) {
            this.modelID = modelID;
            this.tuple = new InstructionRegions.RegionTuple(tuple);
        }

        ModelAndTuple(String modelID, String srcID, String trgID) {
            this.modelID = modelID;
            this.tuple = new InstructionRegions.RegionTuple(srcID, trgID);
        }

        public String toString() {
            return "ModelAndTuple: " + this.modelID + " [" + this.tuple + "]";
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof ModelAndTuple)) {
                return false;
            }
            ModelAndTuple otherMAT = (ModelAndTuple)other;
            return this.modelID.equals(otherMAT.modelID) && this.tuple.equals(otherMAT.tuple);
        }

        public int hashCode() {
            return this.modelID.hashCode() + this.tuple.hashCode();
        }
    }

    private static final class CoreData {
        BuildInstruction aCore;
        HashMap idCounts;
        HashMap modelCounts;
        HashMap globalUsage;
        int emptyRequired;
        int minRequired;
        int surplus;
        String emptyForModel;

        CoreData(BuildInstruction bi) {
            this.aCore = bi;
            this.idCounts = new HashMap();
            this.modelCounts = new HashMap();
            this.globalUsage = new HashMap();
        }

        boolean isMultiCore() {
            return this.idCounts.size() > 1;
        }

        void add(BuildInstructionInstance bii, String modelID) {
            InstructionRegions.RegionTuple rTup;
            Integer countForTuple;
            String baseID = bii.getBaseID();
            Integer count = (Integer)this.idCounts.get(baseID);
            this.idCounts.put(baseID, new Integer(count + 1));
            HashMap<InstructionRegions.RegionTuple, Integer> countsForModel = (HashMap<InstructionRegions.RegionTuple, Integer>)this.modelCounts.get(modelID);
            if (countsForModel == null) {
                countsForModel = new HashMap<InstructionRegions.RegionTuple, Integer>();
                this.modelCounts.put(modelID, countsForModel);
            }
            int newCount = (countForTuple = (Integer)countsForModel.get(rTup = new InstructionRegions.RegionTuple(bii.getSourceRegionID(), bii.getTargetRegionID()))) == null ? 1 : countForTuple + 1;
            countsForModel.put(rTup, new Integer(newCount));
            HashSet<ModelAndTuple> usage = (HashSet<ModelAndTuple>)this.globalUsage.get(baseID);
            if (usage == null) {
                usage = new HashSet<ModelAndTuple>();
                this.globalUsage.put(baseID, usage);
            }
            usage.add(new ModelAndTuple(modelID, rTup));
        }

        int organizeCoresByUsage(SortedMap instructPerCount) {
            Iterator idcid = this.idCounts.keySet().iterator();
            int total = 0;
            while (idcid.hasNext()) {
                String id = (String)idcid.next();
                Integer count = (Integer)this.idCounts.get(id);
                TreeSet<String> idsForCount = (TreeSet<String>)instructPerCount.get(count);
                if (idsForCount == null) {
                    idsForCount = new TreeSet<String>();
                    instructPerCount.put(count, idsForCount);
                }
                idsForCount.add(id);
                ++total;
            }
            return total;
        }

        List flattenUsageList(SortedMap instructPerCount) {
            ArrayList<String> retval = new ArrayList<String>();
            Iterator ipcid = instructPerCount.keySet().iterator();
            while (ipcid.hasNext()) {
                Integer count = (Integer)ipcid.next();
                TreeSet idsForCount = (TreeSet)instructPerCount.get(count);
                Iterator ifcit = idsForCount.iterator();
                while (ifcit.hasNext()) {
                    String key = (String)ifcit.next();
                    retval.add(key);
                }
            }
            return retval;
        }

        List getLeastUsed(int num) {
            TreeMap instructPerCount = new TreeMap();
            int total = this.organizeCoresByUsage(instructPerCount);
            if (total < num) {
                throw new IllegalArgumentException();
            }
            ArrayList retval = new ArrayList();
            Iterator ipcid = instructPerCount.keySet().iterator();
            block0: while (ipcid.hasNext() && num > 0) {
                Integer count = (Integer)ipcid.next();
                TreeSet idsForCount = (TreeSet)instructPerCount.get(count);
                int ifcSize = idsForCount.size();
                if (ifcSize < num) {
                    retval.addAll(idsForCount);
                    num -= ifcSize;
                    continue;
                }
                Iterator ifcid = idsForCount.iterator();
                while (ifcid.hasNext()) {
                    retval.add(ifcid.next());
                    if (--num != 0) continue;
                    continue block0;
                }
            }
            return retval;
        }

        void calcMinAndSurplus() {
            this.minRequired = 0;
            int minForEmptyModel = 0;
            Iterator mit = this.modelCounts.keySet().iterator();
            while (mit.hasNext()) {
                String key = (String)mit.next();
                HashMap countsForModel = (HashMap)this.modelCounts.get(key);
                Iterator cit = countsForModel.keySet().iterator();
                while (cit.hasNext()) {
                    InstructionRegions.RegionTuple tup = (InstructionRegions.RegionTuple)cit.next();
                    Integer count = (Integer)countsForModel.get(tup);
                    int countVal = count;
                    if (countVal > this.minRequired) {
                        this.minRequired = countVal;
                    }
                    if (!key.equals(this.emptyForModel) || countVal <= minForEmptyModel) continue;
                    minForEmptyModel = countVal;
                }
            }
            if (this.minRequired < (minForEmptyModel += this.emptyRequired)) {
                this.minRequired = minForEmptyModel;
            }
            this.surplus = this.idCounts.size() - this.minRequired;
        }

        void dropSurplusCores(List deadList) {
            Iterator dlit = deadList.iterator();
            while (dlit.hasNext()) {
                String key = (String)dlit.next();
                this.idCounts.remove(key);
                this.globalUsage.remove(key);
            }
        }

        private void processUsageSetToOrphans(String key, HashSet usage, Map oldToNew) {
            if (usage == null) {
                return;
            }
            Iterator uit = usage.iterator();
            while (uit.hasNext()) {
                ModelAndTuple mat = (ModelAndTuple)uit.next();
                HashMap<BuildInstructionInstance, BuildInstructionInstance> mapForModel = (HashMap<BuildInstructionInstance, BuildInstructionInstance>)oldToNew.get(mat.modelID);
                if (mapForModel == null) {
                    mapForModel = new HashMap<BuildInstructionInstance, BuildInstructionInstance>();
                    oldToNew.put(mat.modelID, mapForModel);
                }
                BuildInstructionInstance oldBii = new BuildInstructionInstance(key, mat.tuple.sourceRegion, mat.tuple.targetRegion);
                BuildInstructionInstance newBii = new BuildInstructionInstance(null, mat.tuple.sourceRegion, mat.tuple.targetRegion);
                mapForModel.put(oldBii, newBii);
            }
        }

        private void assignNewID(String oldID, String newID, ModelAndTuple mat, Map oldToNew) {
            HashMap mapForModel = (HashMap)oldToNew.get(mat.modelID);
            if (mapForModel == null) {
                throw new IllegalStateException();
            }
            BuildInstructionInstance oldBii = new BuildInstructionInstance(oldID, mat.tuple.sourceRegion, mat.tuple.targetRegion);
            BuildInstructionInstance newBii = (BuildInstructionInstance)mapForModel.get(oldBii);
            newBii.setBaseID(newID);
        }

        void reallocateOrphanedInstructions(List deadList, Map oldToNew) {
            Iterator dlit = deadList.iterator();
            while (dlit.hasNext()) {
                String key = (String)dlit.next();
                HashSet usage = (HashSet)this.globalUsage.get(key);
                this.processUsageSetToOrphans(key, usage, oldToNew);
            }
            this.dropSurplusCores(deadList);
            TreeMap instructPerCount = new TreeMap();
            this.organizeCoresByUsage(instructPerCount);
            List orderedCores = this.flattenUsageList(instructPerCount);
            for (int i = 0; i < this.emptyRequired; ++i) {
                String key = (String)orderedCores.get(i);
                HashSet usage = (HashSet)this.globalUsage.get(key);
                this.processUsageSetToOrphans(key, usage, oldToNew);
                usage.clear();
                this.idCounts.put(key, new Integer(0));
            }
            Iterator otnit = oldToNew.keySet().iterator();
            while (otnit.hasNext()) {
                String modelID = (String)otnit.next();
                HashMap mapForModel = (HashMap)oldToNew.get(modelID);
                Iterator mfmit = mapForModel.keySet().iterator();
                block3: while (mfmit.hasNext()) {
                    BuildInstructionInstance oldBii = (BuildInstructionInstance)mfmit.next();
                    ModelAndTuple mat = new ModelAndTuple(modelID, oldBii.getSourceRegionID(), oldBii.getTargetRegionID());
                    instructPerCount = new TreeMap(Collections.reverseOrder());
                    this.organizeCoresByUsage(instructPerCount);
                    orderedCores = this.flattenUsageList(instructPerCount);
                    int ocNum = orderedCores.size();
                    for (int i = 0; i < ocNum; ++i) {
                        String key = (String)orderedCores.get(i);
                        HashSet usage = (HashSet)this.globalUsage.get(key);
                        if (usage.contains(mat)) continue;
                        usage.add(mat);
                        Integer count = (Integer)this.idCounts.get(key);
                        this.idCounts.put(key, new Integer(count + 1));
                        this.assignNewID(oldBii.getBaseID(), key, mat, oldToNew);
                        continue block3;
                    }
                }
            }
        }

        void compressInstructions(Map oldToNew) {
            boolean rebuild = false;
            block0: do {
                TreeMap instructPerCount = new TreeMap(Collections.reverseOrder());
                this.organizeCoresByUsage(instructPerCount);
                List orderedCores = this.flattenUsageList(instructPerCount);
                int ocNum = orderedCores.size();
                for (int i = 0; i < ocNum; ++i) {
                    String key = (String)orderedCores.get(i);
                    ArrayList targetCores = new ArrayList();
                    for (int j = 0; j < i; ++j) {
                        targetCores.add(orderedCores.get(j));
                    }
                    HashSet usage = (HashSet)this.globalUsage.get(key);
                    rebuild = this.compressUsage(key, usage, targetCores, oldToNew);
                    if (rebuild) continue block0;
                }
            } while (rebuild);
        }

        private boolean compressUsage(String srcKey, HashSet usage, List targetCores, Map oldToNew) {
            Iterator uit = usage.iterator();
            while (uit.hasNext()) {
                ModelAndTuple mat = (ModelAndTuple)uit.next();
                int tcNum = targetCores.size();
                for (int i = 0; i < tcNum; ++i) {
                    String targKey = (String)targetCores.get(i);
                    HashSet targUsage = (HashSet)this.globalUsage.get(targKey);
                    if (targUsage.contains(mat)) continue;
                    this.transferUsage(mat, srcKey, usage, targKey, targUsage, oldToNew);
                    return true;
                }
            }
            return false;
        }

        private void transferUsage(ModelAndTuple mat, String srcKey, HashSet usage, String targKey, HashSet targUsage, Map oldToNew) {
            usage.remove(mat);
            targUsage.add(mat);
            Integer sCount = (Integer)this.idCounts.get(srcKey);
            this.idCounts.put(srcKey, new Integer(sCount - 1));
            Integer tCount = (Integer)this.idCounts.get(targKey);
            this.idCounts.put(targKey, new Integer(tCount + 1));
            HashMap<BuildInstructionInstance, BuildInstructionInstance> mapForModel = (HashMap<BuildInstructionInstance, BuildInstructionInstance>)oldToNew.get(mat.modelID);
            if (mapForModel == null) {
                mapForModel = new HashMap<BuildInstructionInstance, BuildInstructionInstance>();
                oldToNew.put(mat.modelID, mapForModel);
            }
            BuildInstructionInstance oldBii = new BuildInstructionInstance(srcKey, mat.tuple.sourceRegion, mat.tuple.targetRegion);
            BuildInstructionInstance newBii = new BuildInstructionInstance(targKey, mat.tuple.sourceRegion, mat.tuple.targetRegion);
            mapForModel.put(oldBii, newBii);
        }
    }

    public static class CoreCount {
        public BuildInstruction core;
        public int count;

        public CoreCount(BuildInstruction core, int count) {
            this.core = core;
            this.count = count;
        }
    }
}

