/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.BuildInstruction;
import org.systemsbiology.biotapestry.cmd.DialogBuiltGeneralProtoMotif;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotifPair;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class GeneralBuildInstruction
extends BuildInstruction {
    public static final int POSITIVE = 0;
    public static final int NEGATIVE = 1;
    public static final int NEUTRAL = 2;
    public static final int NUM_SIGN_TYPES = 3;
    public static final String POSITIVE_STR = "positive";
    public static final String NEGATIVE_STR = "negative";
    public static final String NEUTRAL_STR = "neutral";
    public static final String CSV_TAG = "general";
    public static final int CSV_TOKEN_COUNT = 1;
    public static final int CSV_TARGET_COUNT = 2;
    public static final int CSV_REGION_COUNT = 2;
    public static final int CSV_ADVANCED_COUNT = 0;
    protected static final String XML_TAG = "generalBuildInstruction";
    private int linkSign_;
    private int evidenceLevel_;

    public GeneralBuildInstruction(String id, int sourceType, String sourceName, int linkSign, int targType, String targName) {
        this(id, sourceType, sourceName, linkSign, targType, targName, 0);
    }

    public GeneralBuildInstruction(String id, int sourceType, String sourceName, int linkSign, int targType, String targName, int evidenceLevel) {
        super(id, sourceType, sourceName, targType, targName);
        this.linkSign_ = linkSign;
        this.evidenceLevel_ = evidenceLevel;
    }

    public GeneralBuildInstruction(GeneralBuildInstruction other) {
        super(other);
        this.linkSign_ = other.linkSign_;
        this.evidenceLevel_ = other.evidenceLevel_;
    }

    public Object clone() {
        return super.clone();
    }

    public int getLinkSign() {
        return this.linkSign_;
    }

    public void setLinkSign(int linkSign) {
        this.linkSign_ = linkSign;
    }

    public boolean hasEvidenceLevel() {
        return this.evidenceLevel_ != 0;
    }

    public Set getNamedNodes() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(this.sourceName_);
        retval.add(this.targName_);
        return retval;
    }

    public Set getNamedSourceRegionNodes() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(this.sourceName_);
        return retval;
    }

    public Set getNamedTargetRegionNodes() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(this.targName_);
        return retval;
    }

    public void addMotifs(List motifs, Map typeTracker) {
        this.typeCheckSupport(this.sourceName_, this.sourceType_, typeTracker);
        this.typeCheckSupport(this.targName_, this.targType_, typeTracker);
        DialogBuiltGeneralProtoMotif dbgpm = new DialogBuiltGeneralProtoMotif(this.sourceName_, this.sourceType_, this.targName_, this.targType_, this.linkSign_, this.evidenceLevel_);
        motifs.add(new DialogBuiltMotifPair(this.id_, dbgpm, null));
    }

    public boolean typesAreConsistent(Map typeTracker) {
        if (!this.typeChecks(this.sourceName_, this.sourceType_, typeTracker)) {
            return false;
        }
        return this.typeChecks(this.targName_, this.targType_, typeTracker);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<");
        out.print(XML_TAG);
        this.writeXMLSupport(out, ind);
        out.print(" linkSign=\"");
        out.print(GeneralBuildInstruction.mapToSignTag(this.linkSign_));
        if (this.evidenceLevel_ != 0) {
            out.print("\" evidence=\"");
            out.print(this.evidenceLevel_);
        }
        out.println("\" />");
    }

    public boolean sameDefinition(BuildInstruction other) {
        if (!(other instanceof GeneralBuildInstruction)) {
            return false;
        }
        if (!super.sameDefinition(other)) {
            return false;
        }
        GeneralBuildInstruction otherGbi = (GeneralBuildInstruction)other;
        if (this.linkSign_ != otherGbi.linkSign_) {
            return false;
        }
        return this.evidenceLevel_ == otherGbi.evidenceLevel_;
    }

    public String toString() {
        return super.toString() + " " + this.linkSign_ + " " + this.evidenceLevel_;
    }

    public String toCSVString(StringBuffer buf, String modelName) {
        buf.setLength(0);
        buf.append("\"");
        buf.append(CSV_TAG);
        buf.append("\",\"");
        buf.append(modelName);
        buf.append("\",\"");
        buf.append(GeneralBuildInstruction.mapToNodeTypeTag(this.sourceType_));
        buf.append("\",\"");
        buf.append(this.sourceName_);
        buf.append("\",\"");
        buf.append(GeneralBuildInstruction.mapToNodeTypeTag(this.targType_));
        buf.append("\",\"");
        buf.append(this.targName_);
        buf.append("\",\"");
        buf.append(GeneralBuildInstruction.mapToSignTag(this.linkSign_));
        buf.append("\"");
        return buf.toString();
    }

    public String displayStringUI(ResourceManager rMan) {
        String dispSrc = rMan.getString("buildInstruction." + BuildInstruction.mapToNodeTypeTag(this.sourceType_));
        String dispTrg = rMan.getString("buildInstruction." + BuildInstruction.mapToNodeTypeTag(this.targType_));
        String dispSign = rMan.getString("buildInstruction.general" + GeneralBuildInstruction.mapToSignTag(this.linkSign_));
        String retval = MessageFormat.format(rMan.getString("buildInstruction.generalDisplay"), dispSrc, this.sourceName_, dispSign, dispTrg, this.targName_);
        return retval;
    }

    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof GeneralBuildInstruction)) {
            return false;
        }
        GeneralBuildInstruction otherGbi = (GeneralBuildInstruction)other;
        if (this.linkSign_ != otherGbi.linkSign_) {
            return false;
        }
        return this.evidenceLevel_ == otherGbi.evidenceLevel_;
    }

    public static BuildInstruction buildFromXML(String elemName, Attributes attrs, String id, int sourceType, String sourceName, int targType, String targName) throws IOException {
        int linkSign;
        if (!elemName.equals(XML_TAG)) {
            return null;
        }
        String linkSignStr = null;
        String evidenceStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("linkSign")) {
                    linkSignStr = val;
                    continue;
                }
                if (!key.equals("evidence")) continue;
                evidenceStr = val;
            }
        }
        if (linkSignStr == null) {
            throw new IOException();
        }
        try {
            linkSign = GeneralBuildInstruction.mapFromSignTag(linkSignStr);
        }
        catch (IllegalArgumentException iae) {
            System.err.println("bad map");
            throw new IOException();
        }
        int evidenceLevel = 0;
        if (evidenceStr != null) {
            try {
                evidenceLevel = Integer.parseInt(evidenceStr);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
        return new GeneralBuildInstruction(id, sourceType, sourceName, linkSign, targType, targName, evidenceLevel);
    }

    public static String mapToSignTag(int val) {
        switch (val) {
            case 0: {
                return POSITIVE_STR;
            }
            case 1: {
                return NEGATIVE_STR;
            }
            case 2: {
                return NEUTRAL_STR;
            }
        }
        throw new IllegalStateException();
    }

    public static int invertSign(int val) {
        switch (val) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromSignTag(String tag) {
        if (tag.equals(POSITIVE_STR)) {
            return 0;
        }
        if (tag.equals(NEGATIVE_STR)) {
            return 1;
        }
        if (tag.equals(NEUTRAL_STR)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static int mapToLinkageSign(int val) {
        switch (val) {
            case 0: {
                return 1;
            }
            case 1: {
                return -1;
            }
            case 2: {
                return 0;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromLinkageSign(int linkageSign) {
        switch (linkageSign) {
            case 1: {
                return 0;
            }
            case -1: {
                return 1;
            }
            case 0: {
                return 2;
            }
        }
        throw new IllegalStateException();
    }

    public static BuildInstruction buildFromCSV(List tokens, int startIndex, String id, int sourceType, String sourceName, int targType, String targName) throws IOException {
        int linkSign;
        if (tokens.size() < startIndex + 2 + 2 + 1) {
            throw new IOException();
        }
        String linkSignStr = ((String)tokens.get(startIndex + 2 + 2 + 1 - 1)).trim().toLowerCase();
        if (linkSignStr == null || linkSignStr.trim().equals("")) {
            throw new IOException();
        }
        try {
            linkSign = GeneralBuildInstruction.mapFromSignTag(linkSignStr);
        }
        catch (IllegalArgumentException iae) {
            System.err.println("bad map: " + linkSignStr);
            throw new IOException();
        }
        boolean activityType = false;
        Object activityLevel = null;
        int evidenceLevel = 0;
        int advancedBase = startIndex + 2 + 2 + 1 + 2;
        if (tokens.size() > advancedBase) {
            String evidenceStr;
            int evidenceIndex = advancedBase;
            if (tokens.size() > evidenceIndex && !(evidenceStr = ((String)tokens.get(evidenceIndex)).trim().toLowerCase()).equals("")) {
                try {
                    evidenceLevel = Integer.parseInt(evidenceStr);
                    if (evidenceLevel < 0 || evidenceLevel > 10) {
                        throw new IOException();
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new IOException();
                }
            }
        }
        return new GeneralBuildInstruction(id, sourceType, sourceName, linkSign, targType, targName, evidenceLevel);
    }
}

