/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import org.systemsbiology.biotapestry.cmd.BTUndoCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.event.EventManager;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeChange;

public class GenomeChangeCmd
extends BTUndoCmd {
    private GenomeChange restore_;
    private boolean doEvent_;

    public GenomeChangeCmd(GenomeChange restore) {
        this.restore_ = restore;
        this.doEvent_ = false;
    }

    public GenomeChangeCmd(GenomeChange restore, boolean doEvent) {
        this.restore_ = restore;
        this.doEvent_ = doEvent;
    }

    public String getPresentationName() {
        return "Model Change";
    }

    public void undo() {
        super.undo();
        Database db = Database.getDB();
        Genome genome = db.getGenome(this.restore_.genomeKey);
        genome.changeUndo(this.restore_);
        if (this.doEvent_) {
            ModelChangeEvent ev = new ModelChangeEvent(this.restore_.genomeKey, 1);
            EventManager.getManager().sendModelChangeEvent(ev);
        }
    }

    public void redo() {
        super.redo();
        Database db = Database.getDB();
        Genome genome = db.getGenome(this.restore_.genomeKey);
        genome.changeRedo(this.restore_);
        if (this.doEvent_) {
            ModelChangeEvent ev = new ModelChangeEvent(this.restore_.genomeKey, 1);
            EventManager.getManager().sendModelChangeEvent(ev);
        }
    }
}

