/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import org.systemsbiology.biotapestry.cmd.BTUndoCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.GlobalChange;
import org.systemsbiology.biotapestry.event.EventManager;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;

public class GlobalChangeCmd
extends BTUndoCmd {
    private GlobalChange restore_;
    private boolean doEvent_;

    public GlobalChangeCmd(GlobalChange restore) {
        this.restore_ = restore;
        this.doEvent_ = false;
    }

    public GlobalChangeCmd(GlobalChange restore, boolean doEvent) {
        this.restore_ = restore;
        this.doEvent_ = doEvent;
    }

    public String getPresentationName() {
        return "Global Change";
    }

    public void undo() {
        super.undo();
        Database db = Database.getDB();
        db.changeUndo(this.restore_);
        if (this.doEvent_) {
            GeneralChangeEvent ev = new GeneralChangeEvent(1);
            EventManager.getManager().sendGeneralChangeEvent(ev);
        }
    }

    public void redo() {
        super.redo();
        Database db = Database.getDB();
        db.changeRedo(this.restore_);
        if (this.doEvent_) {
            GeneralChangeEvent ev = new GeneralChangeEvent(1);
            EventManager.getManager().sendGeneralChangeEvent(ev);
        }
    }
}

