/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import org.systemsbiology.biotapestry.cmd.BTUndoCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.nav.ImageChange;

public class ImageChangeCmd
extends BTUndoCmd {
    private ImageChange restore_;

    public ImageChangeCmd(ImageChange restore) {
        this.restore_ = restore;
    }

    public String getPresentationName() {
        return "Image Change";
    }

    public void undo() {
        super.undo();
        Database db = Database.getDB();
        if (this.restore_.genomeKey != null) {
            Genome imgGenome = db.getGenome(this.restore_.genomeKey);
            imgGenome.imageChangeUndo(this.restore_);
        } else if (this.restore_.proxyKey != null) {
            DynamicInstanceProxy dip = db.getDynamicProxy(this.restore_.proxyKey);
            dip.imageChangeUndo(this.restore_);
        }
    }

    public void redo() {
        super.redo();
        Database db = Database.getDB();
        if (this.restore_.genomeKey != null) {
            Genome imgGenome = db.getGenome(this.restore_.genomeKey);
            imgGenome.imageChangeRedo(this.restore_);
        } else if (this.restore_.proxyKey != null) {
            DynamicInstanceProxy dip = db.getDynamicProxy(this.restore_.proxyKey);
            dip.imageChangeRedo(this.restore_);
        }
    }
}

