/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.BuildInstructionInstance;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class InstanceInstructionSet {
    private ArrayList instruct_ = new ArrayList();
    private ArrayList regions_;
    private String instanceID_;
    private static final String XML_TAG = "instanceInstructionSet";

    public InstanceInstructionSet(String instanceID) {
        this.regions_ = new ArrayList();
        this.instanceID_ = instanceID;
    }

    public InstanceInstructionSet(InstanceInstructionSet other) {
        int size = other.instruct_.size();
        for (int i = 0; i < size; ++i) {
            BuildInstructionInstance otherBii = (BuildInstructionInstance)other.instruct_.get(i);
            this.instruct_.add(new BuildInstructionInstance(otherBii));
        }
        this.regions_ = new ArrayList();
        int rSize = other.regions_.size();
        for (int i = 0; i < rSize; ++i) {
            RegionInfo otherRI = (RegionInfo)other.regions_.get(i);
            this.regions_.add(new RegionInfo(otherRI));
        }
        this.instanceID_ = other.instanceID_;
    }

    public String getInstanceID() {
        return this.instanceID_;
    }

    public void addInstruction(BuildInstructionInstance inst) {
        this.instruct_.add(inst);
    }

    public void deleteInstruction(BuildInstructionInstance inst) {
        int size = this.instruct_.size();
        for (int i = 0; i < size; ++i) {
            BuildInstructionInstance bii = (BuildInstructionInstance)this.instruct_.get(i);
            if (!bii.equals(inst)) continue;
            this.instruct_.remove(i);
            return;
        }
    }

    public void deleteInstructions(String id) {
        int size = this.instruct_.size();
        int count = 0;
        while (count < size) {
            BuildInstructionInstance bii = (BuildInstructionInstance)this.instruct_.get(count);
            if (bii.getBaseID().equals(id)) {
                this.instruct_.remove(count);
                --size;
                continue;
            }
            ++count;
        }
    }

    public void deleteAllInstructions() {
        this.instruct_.clear();
    }

    public int getInstructionCount() {
        return this.instruct_.size();
    }

    public Iterator getInstructionIterator() {
        return this.instruct_.iterator();
    }

    public void addRegion(String name, String abbrev) {
        this.regions_.add(new RegionInfo(name, abbrev));
    }

    public void deleteRegion(String abbrev) {
        int size = this.regions_.size();
        for (int i = 0; i < size; ++i) {
            RegionInfo ri = (RegionInfo)this.regions_.get(i);
            if (!ri.abbrev.equals(abbrev)) continue;
            this.regions_.remove(i);
            return;
        }
    }

    public void addRegion(RegionInfo newRI) {
        this.regions_.add(new RegionInfo(newRI));
    }

    public void replaceRegions(List newRegions) {
        this.regions_ = new ArrayList();
        int size = newRegions.size();
        for (int i = 0; i < size; ++i) {
            RegionInfo newRI = (RegionInfo)newRegions.get(i);
            this.regions_.add(new RegionInfo(newRI));
        }
    }

    public int getRegionCount() {
        return this.regions_.size();
    }

    public Iterator getRegionIterator() {
        return this.regions_.iterator();
    }

    public RegionInfo getRegionForAbbreviation(String abbrev) {
        int size = this.regions_.size();
        for (int i = 0; i < size; ++i) {
            RegionInfo ri = (RegionInfo)this.regions_.get(i);
            if (!ri.abbrev.equalsIgnoreCase(abbrev)) continue;
            return ri;
        }
        return null;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<");
        out.print(XML_TAG);
        out.print(" forInstance=\"");
        out.print(this.instanceID_);
        out.println("\" >");
        ind.up();
        this.writeRegions(out, ind);
        this.writeInstructions(out, ind);
        ind.down().indent();
        out.print("</");
        out.print(XML_TAG);
        out.println(">");
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(XML_TAG);
        return retval;
    }

    public static String regionKeyword() {
        return "instructionRegion";
    }

    public static InstanceInstructionSet buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals(XML_TAG)) {
            return null;
        }
        String instanceID = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (!key.equals("forInstance")) continue;
                instanceID = val;
            }
        }
        if (instanceID == null) {
            throw new IOException();
        }
        return new InstanceInstructionSet(instanceID);
    }

    public static RegionInfo extractRegion(String elemName, Attributes attrs) throws IOException {
        String regionName = AttributeExtractor.extractAttribute(elemName, attrs, "instructionRegion", "id", true);
        regionName = CharacterEntityMapper.unmapEntities(regionName, false);
        String regionAbbrev = AttributeExtractor.extractAttribute(elemName, attrs, "instructionRegion", "abbrev", true);
        regionAbbrev = CharacterEntityMapper.unmapEntities(regionAbbrev, false);
        return new RegionInfo(regionName, regionAbbrev);
    }

    private void writeRegions(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<regionTags>");
        Iterator regions = this.getRegionIterator();
        ind.up();
        while (regions.hasNext()) {
            ind.indent();
            RegionInfo region = (RegionInfo)regions.next();
            out.print("<instructionRegion");
            out.print(" id=\"");
            out.print(CharacterEntityMapper.mapEntities(region.name, false));
            out.print("\" abbrev=\"");
            out.print(CharacterEntityMapper.mapEntities(region.abbrev, false));
            out.println("\" />");
        }
        ind.down().indent();
        out.println("</regionTags>");
    }

    private void writeInstructions(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<instructionInstances>");
        Iterator iit = this.getInstructionIterator();
        ind.up();
        while (iit.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)iit.next();
            bii.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</instructionInstances>");
    }

    public static class RegionInfo {
        public String name;
        public String abbrev;

        public RegionInfo(String name, String abbrev) {
            this.name = name;
            this.abbrev = abbrev;
        }

        public RegionInfo(RegionInfo other) {
            this.name = other.name;
            this.abbrev = other.abbrev;
        }

        public int hashCode() {
            return this.name.hashCode() + this.abbrev.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof RegionInfo)) {
                return false;
            }
            RegionInfo otherRI = (RegionInfo)other;
            return otherRI.name.equals(this.name) && otherRI.abbrev.equals(this.abbrev);
        }

        public boolean consistent(RegionInfo other) {
            boolean equalNames = DataUtil.keysEqual(other.name, this.name);
            boolean equalAbbrev = DataUtil.keysEqual(other.abbrev, this.abbrev);
            return equalNames && equalAbbrev || !equalNames && !equalAbbrev;
        }

        public String toString() {
            return this.name + " (" + this.abbrev + ")";
        }
    }
}

