/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.BuildInstructionInstance;
import org.systemsbiology.biotapestry.cmd.InstanceInstructionSet;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.parser.ParserClient;
import org.xml.sax.Attributes;

public class InstanceInstructionSetFactory
implements ParserClient {
    private InstanceInstructionSet currSet_;
    private Set setKeys_ = InstanceInstructionSet.keywordsOfInterest();
    private String regionKey_;
    private Set instructionKeys_ = BuildInstructionInstance.keywordsOfInterest();
    private HashSet allKeys_;

    public InstanceInstructionSetFactory() {
        this.regionKey_ = InstanceInstructionSet.regionKeyword();
        this.allKeys_ = new HashSet();
        this.allKeys_.addAll(this.setKeys_);
    }

    public void setContainer(Object container) {
    }

    public boolean finishElement(String elemName) {
        return this.allKeys_.contains(elemName);
    }

    public void processCharacters(char[] chars, int start, int length) {
    }

    public Set keywordsOfInterest() {
        return this.allKeys_;
    }

    public Object processElement(String elemName, Attributes attrs) throws IOException {
        if (this.setKeys_.contains(elemName)) {
            InstanceInstructionSet iis = InstanceInstructionSet.buildFromXML(elemName, attrs);
            if (iis != null) {
                Database db = Database.getDB();
                db.addInstanceInstructionSet(iis.getInstanceID(), iis);
                this.currSet_ = iis;
                return iis;
            }
        } else if (this.instructionKeys_.contains(elemName)) {
            BuildInstructionInstance bii = BuildInstructionInstance.buildFromXML(elemName, attrs);
            if (bii != null) {
                this.currSet_.addInstruction(bii);
            }
        } else if (this.regionKey_.equals(elemName)) {
            this.currSet_.addRegion(InstanceInstructionSet.extractRegion(elemName, attrs));
        }
        return null;
    }
}

