/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InstructionRegions
implements Cloneable {
    private ArrayList tuples_ = new ArrayList();

    public InstructionRegions() {
    }

    public InstructionRegions(InstructionRegions other) {
        int size = other.tuples_.size();
        for (int i = 0; i < size; ++i) {
            this.tuples_.add(new RegionTuple((RegionTuple)other.tuples_.get(i)));
        }
    }

    public Object clone() {
        try {
            InstructionRegions retval = (InstructionRegions)super.clone();
            retval.tuples_ = new ArrayList();
            int size = this.tuples_.size();
            for (int i = 0; i < size; ++i) {
                RegionTuple tup = (RegionTuple)this.tuples_.get(i);
                retval.tuples_.add((RegionTuple)tup.clone());
            }
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public int getNumTuples() {
        return this.tuples_.size();
    }

    public Iterator getRegionTuples() {
        return this.tuples_.iterator();
    }

    public void setRegionTuples(List newTuples) {
        this.tuples_.clear();
        this.tuples_.addAll(newTuples);
    }

    public void merge(InstructionRegions other) {
        int size = other.tuples_.size();
        for (int i = 0; i < size; ++i) {
            this.tuples_.add(new RegionTuple((RegionTuple)other.tuples_.get(i)));
        }
    }

    public void mergeUniquely(InstructionRegions other, InstructionRegions overflow) {
        int size = other.tuples_.size();
        for (int i = 0; i < size; ++i) {
            RegionTuple currTup = new RegionTuple((RegionTuple)other.tuples_.get(i));
            if (!this.hasTuple(currTup)) {
                this.tuples_.add(currTup);
                continue;
            }
            overflow.addRegionTuple(currTup);
        }
    }

    public void distributeUniquely(InstructionRegions other, List overflows) {
    }

    public boolean hasDuplicates() {
        int size = this.tuples_.size();
        for (int i = 0; i < size; ++i) {
            RegionTuple rt1 = (RegionTuple)this.tuples_.get(i);
            for (int j = 0; j < size; ++j) {
                RegionTuple rt2;
                if (i == j || !(rt2 = (RegionTuple)this.tuples_.get(j)).equals(rt1)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasTuple(RegionTuple rt) {
        int size = this.tuples_.size();
        for (int i = 0; i < size; ++i) {
            RegionTuple rt1 = (RegionTuple)this.tuples_.get(i);
            if (!rt.equals(rt1)) continue;
            return true;
        }
        return false;
    }

    public void addRegionTuple(RegionTuple newTuple) {
        this.tuples_.add(newTuple);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("InstructionRegion: [");
        int size = this.tuples_.size();
        for (int i = 0; i < size; ++i) {
            buf.append(this.tuples_.get(i).toString());
            if (i == size - 1) continue;
            buf.append(" : ");
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean equals(Object other) {
        RegionTuple rt;
        int i;
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof InstructionRegions)) {
            return false;
        }
        InstructionRegions otherIR = (InstructionRegions)other;
        if (this.tuples_.size() != otherIR.tuples_.size()) {
            return false;
        }
        int size = this.tuples_.size();
        for (i = 0; i < size; ++i) {
            rt = (RegionTuple)this.tuples_.get(i);
            if (otherIR.hasTuple(rt)) continue;
            return false;
        }
        size = otherIR.tuples_.size();
        for (i = 0; i < size; ++i) {
            rt = (RegionTuple)otherIR.tuples_.get(i);
            if (this.hasTuple(rt)) continue;
            return false;
        }
        return true;
    }

    public boolean losesRegion(InstructionRegions otherIR) {
        if (this == otherIR) {
            return false;
        }
        int size = this.tuples_.size();
        for (int i = 0; i < size; ++i) {
            RegionTuple rt = (RegionTuple)this.tuples_.get(i);
            if (otherIR.hasTuple(rt)) continue;
            return true;
        }
        return false;
    }

    public static class RegionTuple
    implements Cloneable {
        public String sourceRegion;
        public String targetRegion;

        public RegionTuple(String sourceRegion, String targetRegion) {
            if (sourceRegion == null) {
                throw new IllegalArgumentException();
            }
            this.sourceRegion = sourceRegion;
            this.targetRegion = targetRegion;
        }

        public RegionTuple(RegionTuple other) {
            this.sourceRegion = other.sourceRegion;
            this.targetRegion = other.targetRegion;
        }

        public Object clone() {
            try {
                RegionTuple retval = (RegionTuple)super.clone();
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        public String toString() {
            return this.sourceRegion + " " + this.targetRegion;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof RegionTuple)) {
                return false;
            }
            RegionTuple otherRT = (RegionTuple)other;
            if (!this.sourceRegion.equals(otherRT.sourceRegion)) {
                return false;
            }
            if (this.targetRegion == null) {
                return otherRT.targetRegion == null;
            }
            return this.targetRegion.equals(otherRT.targetRegion);
        }

        public int hashCode() {
            return this.sourceRegion.hashCode() + (this.targetRegion == null ? 0 : this.targetRegion.hashCode());
        }
    }
}

