/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.BuildInstruction;
import org.systemsbiology.biotapestry.cmd.DialogBuiltLoneNodeProtoMotif;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotifPair;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class LoneNodeBuildInstruction
extends BuildInstruction {
    public static final String CSV_TAG = "nodeOnly";
    public static final int CSV_TOKEN_COUNT = 0;
    public static final int CSV_TARGET_COUNT = 0;
    public static final int CSV_REGION_COUNT = 1;
    protected static final String XML_TAG = "loneNodeBuildInstruction";

    public LoneNodeBuildInstruction(String id, int nodeType, String nodeName) {
        super(id, nodeType, nodeName, -1, null);
    }

    public LoneNodeBuildInstruction(LoneNodeBuildInstruction other) {
        super(other);
    }

    public Object clone() {
        return super.clone();
    }

    public boolean hasEvidenceLevel() {
        return false;
    }

    public Set getNamedNodes() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(this.sourceName_);
        return retval;
    }

    public Set getNamedSourceRegionNodes() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(this.sourceName_);
        return retval;
    }

    public Set getNamedTargetRegionNodes() {
        HashSet retval = new HashSet();
        return retval;
    }

    public void addMotifs(List motifs, Map typeTracker) {
        this.typeCheckSupport(this.sourceName_, this.sourceType_, typeTracker);
        DialogBuiltLoneNodeProtoMotif dbgpm = new DialogBuiltLoneNodeProtoMotif(this.sourceName_, this.sourceType_);
        motifs.add(new DialogBuiltMotifPair(this.id_, dbgpm, null));
    }

    public boolean typesAreConsistent(Map typeTracker) {
        return this.typeChecks(this.sourceName_, this.sourceType_, typeTracker);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<");
        out.print(XML_TAG);
        this.writeXMLSupport(out, ind);
        out.println(" />");
    }

    public String toCSVString(StringBuffer buf, String modelName) {
        buf.setLength(0);
        buf.append("\"");
        buf.append(CSV_TAG);
        buf.append("\",\"");
        buf.append(modelName);
        buf.append("\",\"");
        buf.append(LoneNodeBuildInstruction.mapToNodeTypeTag(this.sourceType_));
        buf.append("\",\"");
        buf.append(this.sourceName_);
        buf.append("\"");
        return buf.toString();
    }

    public boolean sameDefinition(BuildInstruction other) {
        if (!(other instanceof LoneNodeBuildInstruction)) {
            return false;
        }
        return super.sameDefinition(other);
    }

    public String toString() {
        return super.toString();
    }

    public String displayStringUI(ResourceManager rMan) {
        String dispSrc = rMan.getString("buildInstruction." + BuildInstruction.mapToNodeTypeTag(this.sourceType_));
        String retval = MessageFormat.format(rMan.getString("buildInstruction.loneNodeDisplay"), dispSrc, this.sourceName_);
        return retval;
    }

    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return other instanceof LoneNodeBuildInstruction;
    }

    public static BuildInstruction buildFromXML(String elemName, Attributes attrs, String id, int sourceType, String sourceName) throws IOException {
        if (!elemName.equals(XML_TAG)) {
            return null;
        }
        return new LoneNodeBuildInstruction(id, sourceType, sourceName);
    }

    public static BuildInstruction buildFromCSV(List tokens, int startIndex, String id, int sourceType, String sourceName) throws IOException {
        if (tokens.size() < startIndex + 2 + 0 + 0) {
            throw new IOException();
        }
        return new LoneNodeBuildInstruction(id, sourceType, sourceName);
    }
}

