/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.app.EditorWindow;
import org.systemsbiology.biotapestry.app.PopupTree;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.BuildInstructionProcessor;
import org.systemsbiology.biotapestry.cmd.CheckGutsCache;
import org.systemsbiology.biotapestry.cmd.DatabaseChangeCmd;
import org.systemsbiology.biotapestry.cmd.DeleteCommands;
import org.systemsbiology.biotapestry.cmd.ImageChangeCmd;
import org.systemsbiology.biotapestry.cmd.InstanceInstructionSet;
import org.systemsbiology.biotapestry.cmd.ModificationCommands;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.cmd.PropChangeCmd;
import org.systemsbiology.biotapestry.cmd.RecentFilesManager;
import org.systemsbiology.biotapestry.cmd.ToolCommands;
import org.systemsbiology.biotapestry.cmd.UserTreePathController;
import org.systemsbiology.biotapestry.cmd.ZoomChangeTracker;
import org.systemsbiology.biotapestry.cmd.ZoomCommandSupport;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.db.DatabaseFactory;
import org.systemsbiology.biotapestry.db.StartupView;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.db.Workspace;
import org.systemsbiology.biotapestry.event.EventManager;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.event.GeneralChangeListener;
import org.systemsbiology.biotapestry.event.LayoutChangeEvent;
import org.systemsbiology.biotapestry.event.LayoutChangeListener;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.event.ModelChangeListener;
import org.systemsbiology.biotapestry.event.OverlayDisplayChangeEvent;
import org.systemsbiology.biotapestry.event.OverlayDisplayChangeListener;
import org.systemsbiology.biotapestry.event.SelectionChangeEvent;
import org.systemsbiology.biotapestry.event.SelectionChangeListener;
import org.systemsbiology.biotapestry.gaggle.GooseAppInterface;
import org.systemsbiology.biotapestry.gaggle.GooseManager;
import org.systemsbiology.biotapestry.gaggle.InboundGaggleOp;
import org.systemsbiology.biotapestry.gaggle.SelectionSupport;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBGenomeSIFFormatFactory;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.FullHierarchyBuilder;
import org.systemsbiology.biotapestry.genome.FullHierarchyCSVFormatFactory;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupMember;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.nav.GroupSettingManager;
import org.systemsbiology.biotapestry.nav.ImageChange;
import org.systemsbiology.biotapestry.nav.ImageManager;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.nav.SelectionNavController;
import org.systemsbiology.biotapestry.nav.UserTreePathManager;
import org.systemsbiology.biotapestry.parser.SUParser;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbCsvFormatFactory;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.timeCourse.CopiesPerEmbryoData;
import org.systemsbiology.biotapestry.timeCourse.CopiesPerEmbryoFormatFactory;
import org.systemsbiology.biotapestry.timeCourse.PerturbedTimeCourseGeneCSVFormatFactory;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeData;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeFormatFactory;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseFormatFactory;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.ImageExporter;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutDerivation;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LayoutOptionsManager;
import org.systemsbiology.biotapestry.ui.LayoutRubberStamper;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.ui.dialogs.AllowReparentOptimizeDialog;
import org.systemsbiology.biotapestry.ui.dialogs.BuildNetworkDialog;
import org.systemsbiology.biotapestry.ui.dialogs.ColorEditorDialog;
import org.systemsbiology.biotapestry.ui.dialogs.CompressionPercentDialog;
import org.systemsbiology.biotapestry.ui.dialogs.DevelopmentSpecDialog;
import org.systemsbiology.biotapestry.ui.dialogs.DisplayOptionsDialog;
import org.systemsbiology.biotapestry.ui.dialogs.ExportSettingsDialog;
import org.systemsbiology.biotapestry.ui.dialogs.ExportSettingsPublishDialog;
import org.systemsbiology.biotapestry.ui.dialogs.FontDialog;
import org.systemsbiology.biotapestry.ui.dialogs.GenomeInstanceCreationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.LayoutCenteringDialog;
import org.systemsbiology.biotapestry.ui.dialogs.LayoutParametersDialog;
import org.systemsbiology.biotapestry.ui.dialogs.LayoutPropagationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.ModelDataDialog;
import org.systemsbiology.biotapestry.ui.dialogs.NetOverlayPropertiesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.PullDownFromRootFrame;
import org.systemsbiology.biotapestry.ui.dialogs.RegionInheritDialog;
import org.systemsbiology.biotapestry.ui.dialogs.RegionSetupDialog;
import org.systemsbiology.biotapestry.ui.dialogs.ResizeWorkspaceDialog;
import org.systemsbiology.biotapestry.ui.dialogs.SIFImportChoicesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.SyncLayoutChoicesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.SyncLayoutTargetDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TemporalInputTableManageDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TimeAxisSetupDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TimeCourseCSVExportOptionsDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TimeCourseSetupDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TimeCourseTableManageDialog;
import org.systemsbiology.biotapestry.ui.dialogs.UserTreePathStopCreationDialog;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.DesignBatchKeyDialog;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PerturbationsManagementWindow;
import org.systemsbiology.biotapestry.ui.dialogs.utils.MessageTableReportingDialog;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.HaloLayout;
import org.systemsbiology.biotapestry.ui.layouts.NetModuleLinkExtractor;
import org.systemsbiology.biotapestry.ui.layouts.OverlayLayoutAnalyzer;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayout;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutData;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngine;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParamDialog;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngineParams;
import org.systemsbiology.biotapestry.ui.layouts.StackedBlockLayout;
import org.systemsbiology.biotapestry.ui.layouts.WorksheetLayout;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BackgroundWorker;
import org.systemsbiology.biotapestry.util.BackgroundWorkerClient;
import org.systemsbiology.biotapestry.util.BackgroundWorkerOwner;
import org.systemsbiology.biotapestry.util.DirectoryNamedOutputStreamSource;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FileExtensionFilters;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.InvalidInputException;
import org.systemsbiology.biotapestry.util.NamedOutputStreamSource;
import org.systemsbiology.biotapestry.util.ObjChoiceContent;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;
import org.systemsbiology.biotapestry.util.WebPublisher;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.app.SimulationLauncher;
import org.systemsbiology.chem.sbml.ModelBuilderMarkupLanguage;

public class MainCommands
implements SelectionChangeListener,
LayoutChangeListener,
ModelChangeListener,
GeneralChangeListener,
OverlayDisplayChangeListener,
ZoomChangeTracker {
    public static final boolean FILE_MUST_EXIST_DONT_CARE = false;
    public static final boolean FILE_MUST_EXIST = true;
    public static final boolean FILE_CAN_CREATE_DONT_CARE = false;
    public static final boolean FILE_CAN_CREATE = true;
    public static final boolean FILE_DONT_CHECK_OVERWRITE = false;
    public static final boolean FILE_CHECK_OVERWRITE = true;
    public static final boolean FILE_MUST_BE_FILE = false;
    public static final boolean FILE_MUST_BE_DIRECTORY = true;
    public static final boolean FILE_CAN_WRITE_DONT_CARE = false;
    public static final boolean FILE_CAN_WRITE = true;
    public static final boolean FILE_CAN_READ_DONT_CARE = false;
    public static final boolean FILE_CAN_READ = true;
    public static final int GENERAL_PUSH = 1;
    public static final int ALLOW_NAV_PUSH = 2;
    public static final int SKIP_PULLDOWN_PUSH = 4;
    public static final int SKIP_ADD_MODULE_REGIONS_PUSH = 8;
    public static final int SKIP_OVERLAY_VIZ_PUSH = 16;
    public static final int LAUNCH_SIMULATION = 0;
    public static final int CLOSE = 1;
    public static final int EXPORT = 2;
    public static final int QPCR_WRITER = 3;
    public static final int SBML_WRITER = 4;
    public static final int WEB = 5;
    public static final int SAVE = 6;
    public static final int SAVE_AS = 7;
    public static final int LOAD = 8;
    public static final int NEW_MODEL = 9;
    public static final int PRINT = 10;
    public static final int ZOOM = 11;
    public static final int SELECT_ALL = 12;
    public static final int ADD = 13;
    public static final int ADD_LINK = 14;
    public static final int PROPAGATE_DOWN = 15;
    public static final int ADD_NODE = 16;
    public static final int PULLDOWN = 17;
    public static final int TOGGLE_BUBBLES = 18;
    public static final int SET_FONT = 19;
    public static final int UNDO = 20;
    public static final int REDO = 21;
    public static final int ZOOM_OUT = 22;
    public static final int ZOOM_IN = 23;
    public static final int APPLET_ABOUT = 24;
    public static final int ABOUT = 25;
    public static final int SPECIALTY_LAYOUT_SELECTED = 26;
    public static final int ZOOM_TO_CURRENT_MODEL = 27;
    public static final int SPECIALTY_LAYOUT_STACKED = 28;
    public static final int IMPORT_TIME_COURSE_XML = 29;
    public static final int IMPORT_TEMPORAL_INPUT_XML = 30;
    public static final int EXPRESSION_TABLES_TO_CSV = 31;
    public static final int PERTURBATION_TO_CSV = 32;
    public static final int TIME_COURSE_TABLE_SETUP = 33;
    public static final int ZOOM_TO_CURRENT_SELECTED = 35;
    public static final int TIME_COURSE_TABLE_MANAGE = 36;
    public static final int TEMPORAL_INPUT_TABLE_MANAGE = 37;
    public static final int CHANGE_MODEL_DATA = 38;
    public static final int ADD_NOTE = 39;
    public static final int IMPORT_PERTURBED_EXPRESSION_CSV = 40;
    public static final int IMPORT_PERTURB_CSV_FROM_FILE = 41;
    public static final int EDIT_COLORS = 42;
    public static final int ADD_QPCR_TO_ROOT_INSTANCES = 43;
    public static final int IMPORT_GENOME_FROM_SIF = 44;
    public static final int NETWORK_SEARCH = 45;
    public static final int ADD_EXTRA_PROXY_NODE = 46;
    public static final int CANCEL_ADD_MODE = 47;
    public static final int BUILD_FROM_DIALOG = 48;
    public static final int GENOME_TO_SIF = 49;
    public static final int SQUASH_GENOME = 50;
    public static final int EXPAND_GENOME = 51;
    public static final int RELAYOUT_ALL_LINKS = 52;
    public static final int SET_AUTOLAYOUT_OPTIONS = 53;
    public static final int RELAYOUT_DIAG_LINKS = 54;
    public static final int OPTIMIZE_LINKS = 55;
    public static final int PROP_ROOT_WITH_EXP_DATA = 56;
    public static final int IMPORT_FULL_HIERARCHY_FROM_CSV = 57;
    public static final int SYNC_ALL_LAYOUTS = 58;
    public static final int ALIGN_ALL_LAYOUTS = 59;
    public static final int SET_DISPLAY_OPTIONS = 60;
    public static final int DROP_ALL_INSTRUCTIONS = 61;
    public static final int APPLY_KID_LAYOUTS_TO_ROOT = 62;
    public static final int GET_MODEL_COUNTS = 63;
    public static final int COPIES_PER_EMBRYO_IMPORT = 64;
    public static final int EXPORT_PUBLISH = 65;
    public static final int DROP_NODE_SELECTIONS = 66;
    public static final int DROP_LINK_SELECTIONS = 67;
    public static final int TIME_COURSE_REGION_HIERARCHY = 68;
    public static final int SPECIALTY_LAYOUT_HALO = 71;
    public static final int SPECIALTY_LAYOUT_WORKSHEET = 72;
    public static final int RECOLOR_LAYOUT = 73;
    public static final int DEFINE_TIME_AXIS = 74;
    public static final int SELECT_NON_ORTHO_SEGS = 75;
    public static final int ZOOM_TO_ALL_SELECTED = 76;
    public static final int ZOOM_TO_ALL_MODELS = 77;
    public static final int CENTER_CURRENT_MODEL_ON_WORKSPACE = 78;
    public static final int RESIZE_WORKSPACE = 79;
    public static final int ZOOM_TO_SHOW_WORKSPACE = 80;
    public static final int SHIFT_ALL_MODELS_TO_WORKSPACE = 81;
    public static final int SELECT_NONE = 82;
    public static final int ASSIGN_IMAGE_TO_MODEL = 83;
    public static final int DROP_IMAGE_FOR_MODEL = 84;
    public static final int TREE_PATH_BACK = 85;
    public static final int TREE_PATH_FORWARD = 86;
    public static final int TREE_PATH_CREATE = 87;
    public static final int TREE_PATH_DELETE = 88;
    public static final int TREE_PATH_ADD_STOP = 89;
    public static final int TREE_PATH_DELETE_STOP = 90;
    public static final int GAGGLE_GOOSE_UPDATE = 91;
    public static final int GAGGLE_RAISE_GOOSE = 92;
    public static final int GAGGLE_LOWER_GOOSE = 93;
    public static final int GAGGLE_SEND_NETWORK = 94;
    public static final int GAGGLE_SEND_NAMELIST = 95;
    public static final int GAGGLE_PROCESS_INBOUND = 96;
    public static final int DRAW_GROUP_IN_INSTANCE = 97;
    public static final int ADD_NETWORK_OVERLAY = 98;
    public static final int DRAW_NETWORK_MODULE = 99;
    public static final int REMOVE_CURR_NETWORK_OVERLAY = 100;
    public static final int EDIT_CURR_NETWORK_OVERLAY = 101;
    public static final int ZOOM_TO_CURRENT_NETWORK_MODULE = 102;
    public static final int MULTI_GROUP_COPY = 103;
    public static final int DRAW_NETWORK_MODULE_LINK = 104;
    public static final int TOGGLE_MODULE_COMPONENT_DISPLAY = 105;
    public static final int ADD_GENOME_INSTANCE = 106;
    public static final int PERTURB_MANAGE = 107;
    public static final int SPECIALTY_LAYOUT_PER_OVERLAY = 108;
    public static final int BUILD_INSTRUCTIONS_TO_CSV = 109;
    public static final int REPAIR_ALL_NON_ORTHO_MIN_SHIFT = 110;
    public static final int REPAIR_ALL_NON_ORTHO_MIN_SPLIT = 111;
    public static final int SPECIALTY_LAYOUT_DIAGONAL = 112;
    public static final int CENTER_ON_NEXT_SELECTED = 113;
    public static final int CENTER_ON_PREVIOUS_SELECTED = 114;
    public static final int REPAIR_ALL_TOPOLOGY = 115;
    public static final int RELAYOUT_LINKS_THRU_SEGMENT = 1;
    public static final int OPTIMIZE_SINGLE_LINK_TREE = 2;
    public static final int COMPRESS_SINGLE_REGION = 3;
    public static final int EXPAND_SINGLE_REGION = 4;
    public static final int HEADLESS_LOAD = 5;
    public static final int HEADLESS_IMPORT_FULL_HIERARCHY_FROM_CSV = 6;
    public static final int HEADLESS_EXPORT = 7;
    public static final int HEADLESS_WEB = 8;
    public static final int HEADLESS_SAVE_AS = 9;
    public static final int ZOOM_TO_GROUP = 10;
    public static final int ZOOM_TO_NET_MODULE = 11;
    public static final int DELETE_CURRENT_OVERLAY = 12;
    public static final int EDIT_CURRENT_OVERLAY = 13;
    public static final int ZOOM_TO_CURRENT_NET_MODULE_SET = 14;
    public static final int ONE_SHOT_ADD_GENOME_INSTANCE = 15;
    public static final int REMOVE_SELECTIONS_FOR_NODE_TYPE = 16;
    public static final int LAYOUT_SINGLE_REGION = 18;
    public static final int FIX_NON_ORTHO_TREE = 19;
    public static final int ONE_TREE_TOPOLOGY_REPAIR = 20;
    private static MainCommands singleton_;
    private CommonView suw_;
    private JFrame topWindow_;
    private File currentFile_;
    private ZoomCommandSupport zoomer_;
    private boolean isHeadless_;
    private HashMap withIcons_;
    private HashMap noIcons_;
    private JButton gaggleButton_;
    private JButton gaggleUpdateGooseButton_;
    private Color gaggleButtonOffColor_;
    private boolean isAMac_;
    private boolean amPulling_ = false;
    private boolean amAdding_ = false;
    private JMenu recentMenu_;
    private JMenu userPathsMenu_;
    private JComboBox userPathsCombo_;
    private ClearRecentAction cra_;
    private UserTreePathController pathControl_;
    private SelectionNavController selectionNavControl_;
    private boolean managingPathControls_;
    private NetOverlayController overlayControl_;
    private JMenu gaggleGooseChooseMenu_;
    private JComboBox gaggleGooseCombo_;
    private boolean managingGaggleControls_;
    private PerturbationsManagementWindow pmw_;

    public boolean isHeadless() {
        return this.isHeadless_;
    }

    public SUPanel getSUPanel() {
        return this.suw_.getSUPanel();
    }

    public OneShot getOneShot(int actionKey) {
        OneShot retval;
        switch (actionKey) {
            case 1: {
                retval = new RelayoutLinksAction();
                break;
            }
            case 2: {
                retval = new OptimizeLinksAction();
                break;
            }
            case 3: {
                retval = new SquashGenomeAction();
                break;
            }
            case 18: {
                retval = new SpecialtyLayoutAction();
                break;
            }
            case 4: {
                retval = new ExpandGenomeAction();
                break;
            }
            case 5: {
                retval = new LoadAction();
                break;
            }
            case 6: {
                retval = new ImportFullHierarchyFromCSVAction();
                break;
            }
            case 7: {
                retval = new ExportAction();
                break;
            }
            case 8: {
                retval = new WebAction();
                break;
            }
            case 9: {
                retval = new SaveAsAction();
                break;
            }
            case 10: {
                retval = new ZoomToGroup();
                break;
            }
            case 11: {
                retval = new ZoomToNetworkModule();
                break;
            }
            case 12: {
                retval = new RemoveNetworkOverlayAction();
                break;
            }
            case 13: {
                retval = new EditNetworkOverlayAction();
                break;
            }
            case 14: {
                retval = new ZoomToCurrentNetworkModule();
                break;
            }
            case 15: {
                retval = new AddGenomeInstanceAction();
                break;
            }
            case 16: {
                retval = new DropNodeSelectionsAction();
                break;
            }
            case 19: {
                retval = new RepairNonOrthoLinkSegmentsAction();
                break;
            }
            case 20: {
                retval = new LinkTopologyRepair();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return retval;
    }

    public UserTreePathController getPathController() {
        return this.pathControl_;
    }

    public NetOverlayController getOverlayController() {
        return this.overlayControl_;
    }

    public SelectionNavController getSelectionNavController() {
        return this.selectionNavControl_;
    }

    public ChecksForEnabled getAction(int actionKey, boolean withIcon, Object[] optionArgs) {
        Integer actionKeyObject;
        HashMap useMap = withIcon ? this.withIcons_ : this.noIcons_;
        ChecksForEnabled retval = (ChecksForEnabled)useMap.get(actionKeyObject = new Integer(actionKey));
        if (retval != null) {
            return retval;
        }
        switch (actionKey) {
            case 0: {
                retval = new LaunchSimulationAction(withIcon);
                break;
            }
            case 1: {
                retval = new CloseAction(withIcon);
                break;
            }
            case 2: {
                retval = new ExportAction(withIcon);
                break;
            }
            case 3: {
                retval = new QPCRWriterAction(withIcon);
                break;
            }
            case 4: {
                retval = new SBMLWriterAction(withIcon);
                break;
            }
            case 5: {
                retval = new WebAction(withIcon);
                break;
            }
            case 6: {
                retval = new SaveAction(withIcon);
                break;
            }
            case 7: {
                retval = new SaveAsAction(withIcon);
                break;
            }
            case 8: {
                retval = new LoadAction(withIcon);
                break;
            }
            case 9: {
                retval = new NewModelAction(withIcon);
                break;
            }
            case 10: {
                retval = new PrintAction(withIcon);
                break;
            }
            case 11: {
                throw new IllegalArgumentException();
            }
            case 12: {
                retval = new SelectAllAction(withIcon);
                break;
            }
            case 13: {
                retval = new AddAction(withIcon);
                break;
            }
            case 14: {
                retval = new AddLinkAction(withIcon);
                break;
            }
            case 15: {
                retval = new PropagateDownAction(withIcon);
                break;
            }
            case 16: {
                retval = new AddNodeAction(withIcon);
                break;
            }
            case 18: {
                retval = new ToggleBubblesAction(withIcon);
                break;
            }
            case 19: {
                retval = new SetFontAction(withIcon);
                break;
            }
            case 20: {
                retval = new UndoAction(withIcon);
                break;
            }
            case 21: {
                retval = new RedoAction(withIcon);
                break;
            }
            case 22: {
                retval = new InOutZoomAction(withIcon, '-');
                break;
            }
            case 23: {
                retval = new InOutZoomAction(withIcon, '+');
                break;
            }
            case 24: {
                retval = new AppletAboutAction(withIcon, (AppletContext)optionArgs[0], (URL)optionArgs[1]);
                break;
            }
            case 25: {
                retval = new AboutAction(withIcon, (URL)optionArgs[0]);
                break;
            }
            case 17: {
                retval = new PulldownAction(withIcon);
                break;
            }
            case 27: {
                retval = new ZoomToCurrentModel(withIcon);
                break;
            }
            case 29: {
                retval = new ImportTimeCourseXml(withIcon);
                break;
            }
            case 30: {
                retval = new ImportTemporalInputXml(withIcon);
                break;
            }
            case 33: {
                retval = new TimeCourseTableSetupAction(withIcon);
                break;
            }
            case 68: {
                retval = new TimeCourseRegionHierarchyAction(withIcon);
                break;
            }
            case 36: {
                retval = new TimeCourseTableManageAction(withIcon);
                break;
            }
            case 37: {
                retval = new TemporalInputTableManageAction(withIcon);
                break;
            }
            case 38: {
                retval = new ChangeModelDataAction(withIcon);
                break;
            }
            case 39: {
                retval = new AddNoteAction(withIcon);
                break;
            }
            case 40: {
                retval = new ImportPerturbedExpressionCSV(withIcon);
                break;
            }
            case 41: {
                retval = new ImportPerturbCsvFromFileAction(withIcon);
                break;
            }
            case 42: {
                retval = new EditColorsAction(withIcon);
                break;
            }
            case 43: {
                retval = new AddQpcrToRootInstancesAction(withIcon);
                break;
            }
            case 44: {
                retval = new ImportGenomeFromSIFAction(withIcon);
                break;
            }
            case 45: {
                retval = new NetworkSearchAction(withIcon);
                break;
            }
            case 46: {
                retval = new AddExtraProxyNodeAction(withIcon);
                break;
            }
            case 47: {
                retval = new CancelAddModeAction(withIcon);
                break;
            }
            case 48: {
                retval = new BuildFromDialogAction(withIcon);
                break;
            }
            case 49: {
                retval = new GenomeToSIFAction(withIcon);
                break;
            }
            case 50: {
                retval = new SquashGenomeAction(withIcon);
                break;
            }
            case 51: {
                retval = new ExpandGenomeAction(withIcon);
                break;
            }
            case 52: {
                retval = new RelayoutLinksAction(withIcon, true, false);
                break;
            }
            case 53: {
                retval = new SetAutolayoutOptionsAction(withIcon);
                break;
            }
            case 54: {
                retval = new RelayoutLinksAction(withIcon, false, true);
                break;
            }
            case 55: {
                retval = new OptimizeLinksAction(withIcon);
                break;
            }
            case 56: {
                retval = new PropRootWithExpDataAction(withIcon);
                break;
            }
            case 57: {
                retval = new ImportFullHierarchyFromCSVAction(withIcon);
                break;
            }
            case 58: {
                retval = new SyncLayoutsAction(withIcon);
                break;
            }
            case 59: {
                retval = new AlignLayoutsAction(withIcon);
                break;
            }
            case 60: {
                retval = new SetDisplayOptionsAction(withIcon);
                break;
            }
            case 61: {
                retval = new DropAllInstructionsAction(withIcon);
                break;
            }
            case 65: {
                retval = new ExportPublishAction(withIcon);
                break;
            }
            case 66: {
                retval = new DropNodeSelectionsAction(withIcon);
                break;
            }
            case 67: {
                retval = new DropLinkSelectionsAction(withIcon);
                break;
            }
            case 71: {
                retval = new SpecialtyLayoutAction(withIcon, new HaloLayout(), 0);
                break;
            }
            case 72: {
                retval = new SpecialtyLayoutAction(withIcon, new WorksheetLayout(false), 0);
                break;
            }
            case 112: {
                retval = new SpecialtyLayoutAction(withIcon, new WorksheetLayout(true), 0);
                break;
            }
            case 28: {
                retval = new SpecialtyLayoutAction(withIcon, new StackedBlockLayout(), 0);
                break;
            }
            case 26: {
                retval = new SpecialtyLayoutAction(withIcon, new StackedBlockLayout(), 1);
                break;
            }
            case 108: {
                retval = new SpecialtyLayoutAction(withIcon, new StackedBlockLayout(), 2);
                break;
            }
            case 73: {
                retval = new RecolorLayoutAction(withIcon);
                break;
            }
            case 74: {
                retval = new DefineTimeAxisAction(withIcon);
                break;
            }
            case 75: {
                retval = new SelectNonOrthoLinkSegmentsAction(withIcon);
                break;
            }
            case 76: {
                retval = new ZoomToSelected(withIcon, false);
                break;
            }
            case 35: {
                retval = new ZoomToSelected(withIcon, true);
                break;
            }
            case 113: {
                retval = new CenterOnPrevNextSelected(withIcon, false);
                break;
            }
            case 114: {
                retval = new CenterOnPrevNextSelected(withIcon, true);
                break;
            }
            case 77: {
                retval = new ZoomToAllModels(withIcon);
                break;
            }
            case 78: {
                retval = new CenterCurrentModelOnWorksheet(withIcon);
                break;
            }
            case 79: {
                retval = new ResizeWorkspace(withIcon);
                break;
            }
            case 80: {
                retval = new ZoomToShowWorkspace(withIcon);
                break;
            }
            case 81: {
                retval = new ShiftAllToWorkspace(withIcon);
                break;
            }
            case 82: {
                retval = new SelectNoneAction(withIcon);
                break;
            }
            case 83: {
                retval = new AssignImageToModelAction(withIcon);
                break;
            }
            case 84: {
                retval = new DropImageFromModelAction(withIcon);
                break;
            }
            case 85: {
                retval = new UserTreePathBackwardAction(withIcon);
                break;
            }
            case 86: {
                retval = new UserTreePathForwardAction(withIcon);
                break;
            }
            case 87: {
                retval = new UserTreePathCreateAction(withIcon);
                break;
            }
            case 88: {
                retval = new UserTreePathDeleteAction(withIcon);
                break;
            }
            case 89: {
                retval = new UserTreePathAddStopAction(withIcon);
                break;
            }
            case 90: {
                retval = new UserTreePathDeleteStopAction(withIcon);
                break;
            }
            case 91: {
                retval = new GaggleUpdateGeese(withIcon);
                break;
            }
            case 92: {
                retval = new GaggleRaiseGoose(withIcon);
                break;
            }
            case 93: {
                retval = new GaggleLowerGoose(withIcon);
                break;
            }
            case 94: {
                retval = new GaggleSendNetwork(withIcon);
                break;
            }
            case 95: {
                retval = new GaggleSendNameList(withIcon);
                break;
            }
            case 96: {
                retval = new GaggleProcessInbound(withIcon);
                break;
            }
            case 64: {
                retval = new ImportCountsPerEmbryoXml(withIcon);
                break;
            }
            case 97: {
                retval = new DrawGroupInInstance(withIcon);
                break;
            }
            case 62: {
                retval = new ApplyKidLayoutsToRootAction(withIcon);
                break;
            }
            case 63: {
                retval = new ModelCountsAction(withIcon);
                break;
            }
            case 98: {
                retval = new AddNetworkOverlayAction(withIcon);
                break;
            }
            case 99: {
                retval = new DrawNewNetworkModule(withIcon);
                break;
            }
            case 100: {
                retval = new RemoveNetworkOverlayAction(withIcon);
                break;
            }
            case 101: {
                retval = new EditNetworkOverlayAction(withIcon);
                break;
            }
            case 102: {
                retval = new ZoomToCurrentNetworkModule(withIcon);
                break;
            }
            case 103: {
                retval = new CopyMultiGroupAction(withIcon);
                break;
            }
            case 104: {
                retval = new DrawNetworkModuleLink(withIcon);
                break;
            }
            case 105: {
                retval = new ToggleModuleComponentDisplay(withIcon);
                break;
            }
            case 106: {
                retval = new AddGenomeInstanceAction(withIcon);
                break;
            }
            case 107: {
                retval = new PerturbManageAction(withIcon);
                break;
            }
            case 31: {
                retval = new ExpressionToCSVAction(withIcon);
                break;
            }
            case 32: {
                retval = new PerturbToCSVAction(withIcon);
                break;
            }
            case 109: {
                retval = new BuildInstructionsToCSVAction(withIcon);
                break;
            }
            case 110: {
                retval = new RepairNonOrthoLinkSegmentsAction(withIcon, false);
                break;
            }
            case 111: {
                retval = new RepairNonOrthoLinkSegmentsAction(withIcon, true);
                break;
            }
            case 115: {
                retval = new LinkTopologyRepair(withIcon);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        useMap.put(actionKeyObject, retval);
        return retval;
    }

    public void pushDisabled(int pushCondition) {
        JMenuItem item;
        int i;
        Iterator wiit = this.withIcons_.values().iterator();
        while (wiit.hasNext()) {
            ChecksForEnabled cfe = (ChecksForEnabled)wiit.next();
            cfe.pushDisabled(pushCondition);
        }
        Iterator niit = this.noIcons_.values().iterator();
        while (niit.hasNext()) {
            ChecksForEnabled cfe = (ChecksForEnabled)niit.next();
            cfe.pushDisabled(pushCondition);
        }
        if (this.recentMenu_ != null) {
            int numRecent = this.recentMenu_.getItemCount();
            for (i = 0; i < numRecent; ++i) {
                item = this.recentMenu_.getItem(i);
                if (item == null) continue;
                item.setEnabled(false);
            }
        }
        if (this.userPathsMenu_ != null) {
            int numPaths = this.userPathsMenu_.getItemCount();
            for (i = 0; i < numPaths; ++i) {
                item = this.userPathsMenu_.getItem(i);
                if (item == null) continue;
                item.setEnabled(false);
            }
        }
        if (this.userPathsCombo_ != null) {
            this.userPathsCombo_.setEnabled(false);
        }
        boolean allowOverlayViz = (pushCondition & 0x10) != 0;
        this.overlayControl_.pushDisabled(allowOverlayViz);
    }

    public boolean havePerturbationEditsInProgress() {
        if (this.pmw_ == null) {
            return false;
        }
        return this.pmw_.havePendingEdit();
    }

    public void launchPerturbationsManagementWindow(PertFilterExpression pfe) {
        if (this.pmw_ != null) {
            this.pmw_.setExtendedState(0);
            this.pmw_.toFront();
            this.pmw_.jumpWithNewFilter(pfe);
            return;
        }
        if (!this.prepTimeAxisForDataImport()) {
            return;
        }
        PerturbationData pd = Database.getDB().getPertData();
        UndoManager undo = this.suw_.getUndoManager();
        this.pmw_ = new PerturbationsManagementWindow(this.topWindow_, pd, pfe, undo);
        this.pmw_.setVisible(true);
    }

    public void clearPerturbationsManagementWindow() {
        this.pmw_ = null;
    }

    public ZoomCommandSupport getZoomController() {
        return this.zoomer_;
    }

    public void setGaggleButtons(JButton button, JButton gooseButton, Color defaultColor) {
        this.gaggleButton_ = button;
        this.gaggleButtonOffColor_ = defaultColor;
        this.gaggleUpdateGooseButton_ = gooseButton;
    }

    public void triggerGaggleState(int whichAction, boolean activate) {
        if (whichAction == 96) {
            GaggleProcessInbound gpi = (GaggleProcessInbound)this.withIcons_.get(new Integer(96));
            gpi.setButtonCondition(activate);
        } else if (whichAction == 91) {
            GaggleUpdateGeese gug = (GaggleUpdateGeese)this.withIcons_.get(new Integer(91));
            gug.setButtonCondition(activate);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void popDisabled() {
        JMenuItem item;
        int i;
        Iterator wiit = this.withIcons_.values().iterator();
        while (wiit.hasNext()) {
            ChecksForEnabled cfe = (ChecksForEnabled)wiit.next();
            cfe.popDisabled();
        }
        Iterator niit = this.noIcons_.values().iterator();
        while (niit.hasNext()) {
            ChecksForEnabled cfe = (ChecksForEnabled)niit.next();
            cfe.popDisabled();
        }
        if (this.recentMenu_ != null) {
            int numRecent = this.recentMenu_.getItemCount();
            for (i = 0; i < numRecent; ++i) {
                item = this.recentMenu_.getItem(i);
                if (item == null) continue;
                item.setEnabled(true);
            }
            this.cra_.setEnabled(this.recentMenu_.getMenuComponentCount() > 2);
        }
        if (this.userPathsMenu_ != null) {
            int numPaths = this.userPathsMenu_.getItemCount();
            for (i = 0; i < numPaths; ++i) {
                item = this.userPathsMenu_.getItem(i);
                if (item == null) continue;
                item.setEnabled(true);
            }
        }
        if (this.userPathsCombo_ != null) {
            this.userPathsCombo_.setEnabled(true);
        }
        this.overlayControl_.popDisabled();
    }

    public void modelHasChanged(ModelChangeEvent mcev) {
        this.checkForChanges(this.suw_.getSUPanel().getGenome(), 2);
        int change = mcev.getChangeType();
        if (change == 2 && mcev.getGenomeKey().equals(Database.getDB().getGenome().getID()) && this.pmw_ != null) {
            this.pmw_.setVisible(false);
            this.pmw_.dispose();
            this.pmw_ = null;
        }
    }

    public void modelHasChanged(ModelChangeEvent event, int remaining) {
        if (remaining == 0) {
            this.modelHasChanged(event);
        }
    }

    public void layoutHasChanged(LayoutChangeEvent lcev) {
    }

    public void generalChangeOccurred(GeneralChangeEvent gcev) {
        if (this.pmw_ != null) {
            this.pmw_.modelChanged();
        }
        this.checkForChanges(this.suw_.getSUPanel().getGenome(), 4);
    }

    public void selectionHasChanged(SelectionChangeEvent scev) {
        this.checkForChanges(this.suw_.getSUPanel().getGenome(), 3);
    }

    public void overlayDisplayChangeOccurred(OverlayDisplayChangeEvent odcev) {
        this.checkForChanges(this.suw_.getSUPanel().getGenome(), 5);
    }

    private void checkForChanges(String genomeID, int checkType) {
        Database db = Database.getDB();
        Genome genome = genomeID == null ? null : db.getGenome(genomeID);
        CheckGutsCache cache = new CheckGutsCache(genome, checkType, this.suw_);
        Iterator wiit = this.withIcons_.values().iterator();
        while (wiit.hasNext()) {
            ChecksForEnabled cfe = (ChecksForEnabled)wiit.next();
            cfe.checkIfEnabled(cache);
        }
        Iterator niit = this.noIcons_.values().iterator();
        while (niit.hasNext()) {
            ChecksForEnabled cfe = (ChecksForEnabled)niit.next();
            cfe.checkIfEnabled(cache);
        }
        this.handlePathButtons();
        this.overlayControl_.checkForChanges();
    }

    public void setPreference(String key, String val) {
        Preferences prefs = Preferences.userNodeForPackage(MainCommands.class);
        prefs.put(key, val);
    }

    public String getPreference(String key) {
        Preferences prefs = Preferences.userNodeForPackage(MainCommands.class);
        String retval = prefs.get(key, null);
        return retval;
    }

    public void setCurrentFile(File file) {
        this.currentFile_ = file;
        if (this.currentFile_ == null || this.isHeadless_) {
            return;
        }
        this.setPreference("LoadDirectory", file.getAbsoluteFile().getParent());
        if (this.recentMenu_ == null) {
            return;
        }
        RecentFilesManager rfm = RecentFilesManager.getRecentFilesMgr();
        rfm.updateLatestFile(file);
        this.updateRecentMenu();
    }

    private void updateRecentMenu() {
        if (this.recentMenu_ == null) {
            return;
        }
        RecentFilesManager rfm = RecentFilesManager.getRecentFilesMgr();
        Iterator rfit = rfm.getRecentFiles();
        this.recentMenu_.removeAll();
        while (rfit.hasNext()) {
            String recentPath = (String)rfit.next();
            String recentName = rfm.getRecentFileName(recentPath);
            LoadRecentAction lra = new LoadRecentAction(recentName, recentPath);
            this.recentMenu_.add(lra);
        }
        if (this.cra_ == null) {
            this.cra_ = new ClearRecentAction(false);
        }
        this.cra_.setEnabled(this.recentMenu_.getMenuComponentCount() != 0);
        this.recentMenu_.add(new JSeparator());
        this.recentMenu_.add(this.cra_);
    }

    public void deleteAllStopsForModel() {
        this.pathControl_.deleteCurrentStop();
        this.handlePathButtons();
    }

    public void updateUserPathActions() {
        this.managingPathControls_ = true;
        Vector pathChoices = UserTreePathManager.getMgr().getPathChoices();
        int numPC = pathChoices.size();
        ResourceManager rMan = ResourceManager.getManager();
        String noPath = rMan.getString("pathController.noPath");
        if (this.userPathsMenu_ != null) {
            this.userPathsMenu_.removeAll();
            SetCurrentUserPathAction scupa = new SetCurrentUserPathAction(noPath, null);
            JCheckBoxMenuItem jcb = new JCheckBoxMenuItem(scupa);
            this.userPathsMenu_.add(jcb);
        }
        if (this.userPathsCombo_ != null) {
            this.userPathsCombo_.removeAllItems();
            this.userPathsCombo_.addItem(new ObjChoiceContent(noPath, null));
        }
        for (int i = 0; i < numPC; ++i) {
            ObjChoiceContent occ = (ObjChoiceContent)pathChoices.get(i);
            if (this.userPathsMenu_ != null) {
                SetCurrentUserPathAction scupa = new SetCurrentUserPathAction(occ.name, occ.val);
                JCheckBoxMenuItem jcb = new JCheckBoxMenuItem(scupa);
                this.userPathsMenu_.add(jcb);
            }
            if (this.userPathsCombo_ == null) continue;
            this.userPathsCombo_.addItem(occ);
        }
        if (this.userPathsCombo_ != null) {
            this.userPathsCombo_.invalidate();
            this.userPathsCombo_.validate();
        }
        this.suw_.makePathControlsVisible(numPC > 0);
        this.handlePathButtons();
        this.managingPathControls_ = false;
    }

    public void updateGaggleTargetActions() {
        GooseAppInterface goose = GooseManager.getManager().getGoose();
        if (goose != null && goose.isActivated()) {
            this.managingGaggleControls_ = true;
            SelectionSupport ss = goose.getSelectionSupport();
            List targets = ss.getGooseList();
            int numTarg = targets.size();
            if (this.gaggleGooseChooseMenu_ != null) {
                this.gaggleGooseChooseMenu_.removeAll();
                SetCurrentGaggleTargetAction scupa = new SetCurrentGaggleTargetAction("boss", 0);
                JCheckBoxMenuItem jcb = new JCheckBoxMenuItem(scupa);
                this.gaggleGooseChooseMenu_.add(jcb);
            }
            if (this.gaggleGooseCombo_ != null) {
                this.gaggleGooseCombo_.removeAllItems();
                this.gaggleGooseCombo_.addItem(new ObjChoiceContent("boss", "boss"));
            }
            for (int i = 0; i < numTarg; ++i) {
                String gooseName = (String)targets.get(i);
                ObjChoiceContent occ = new ObjChoiceContent(gooseName, gooseName);
                if (this.gaggleGooseChooseMenu_ != null) {
                    SetCurrentGaggleTargetAction scupa = new SetCurrentGaggleTargetAction(occ.val, i + 1);
                    JCheckBoxMenuItem jcb = new JCheckBoxMenuItem(scupa);
                    this.gaggleGooseChooseMenu_.add(jcb);
                }
                if (this.gaggleGooseCombo_ == null) continue;
                this.gaggleGooseCombo_.addItem(occ);
            }
            if (this.gaggleGooseChooseMenu_ != null) {
                JCheckBoxMenuItem jcbmi = (JCheckBoxMenuItem)this.gaggleGooseChooseMenu_.getItem(0);
                jcbmi.setSelected(true);
            }
            if (this.gaggleGooseCombo_ != null) {
                this.gaggleGooseCombo_.setSelectedIndex(0);
                this.gaggleGooseCombo_.invalidate();
                this.gaggleGooseCombo_.validate();
            }
            this.managingGaggleControls_ = false;
        }
    }

    public void setCurrentGaggleTarget(int index) {
        this.managingGaggleControls_ = true;
        if (this.gaggleGooseChooseMenu_ != null) {
            int numUpm = this.gaggleGooseChooseMenu_.getItemCount();
            for (int i = 0; i < numUpm; ++i) {
                JCheckBoxMenuItem jcbmi = (JCheckBoxMenuItem)this.gaggleGooseChooseMenu_.getItem(i);
                jcbmi.setSelected(i == index);
            }
        }
        if (this.gaggleGooseCombo_ != null) {
            this.gaggleGooseCombo_.setSelectedIndex(index);
            this.gaggleGooseCombo_.invalidate();
            this.gaggleGooseCombo_.validate();
        }
        this.managingGaggleControls_ = false;
    }

    public void setCurrentUserPath(int index) {
        this.managingPathControls_ = true;
        if (this.userPathsMenu_ != null) {
            int numUpm = this.userPathsMenu_.getItemCount();
            for (int i = 0; i < numUpm; ++i) {
                JCheckBoxMenuItem jcbmi = (JCheckBoxMenuItem)this.userPathsMenu_.getItem(i);
                jcbmi.setSelected(i == index);
            }
        }
        if (this.userPathsCombo_ != null) {
            this.userPathsCombo_.setSelectedIndex(index);
            this.userPathsCombo_.invalidate();
            this.userPathsCombo_.validate();
        }
        this.handlePathButtons();
        this.managingPathControls_ = false;
    }

    private boolean loadFromFile(File file) {
        return this.loadFromSource(file, null);
    }

    private boolean loadFromStream(InputStream stream) {
        return this.loadFromSource(null, stream);
    }

    private boolean loadFromSource(File file, InputStream stream) {
        String chosenFileName = file == null ? null : file.getName();
        Database db = Database.getDB();
        ModelChangeEvent mcev = new ModelChangeEvent(db.getGenome().getID(), 2);
        EventManager.getManager().sendModelChangeEvent(mcev);
        db.drop();
        db.setWorkspaceNeedsCenter();
        db.installLegacyTimeAxisDefinition();
        GroupSettingManager.getGroupMgr().drop();
        ArrayList<DatabaseFactory> alist = new ArrayList<DatabaseFactory>();
        alist.add(new DatabaseFactory(false));
        SUParser sup = new SUParser(alist);
        this.setCurrentFile(file);
        try {
            if (file != null) {
                sup.parse(file);
            } else {
                sup.parse(stream);
            }
            db.legacyIOFixup(this.isHeadless_ ? null : this.topWindow_);
        }
        catch (IOException ioe) {
            this.displayFileInputError(ioe);
            db.drop();
            chosenFileName = null;
            this.manageWindowTitle(null);
            if (!this.isHeadless_) {
                this.newModelOperations();
            }
            return false;
        }
        if (db.getGenome() == null) {
            this.displayFileInputError(null);
            db.drop();
            chosenFileName = null;
            this.manageWindowTitle(null);
            if (!this.isHeadless_) {
                this.newModelOperations();
            }
            return false;
        }
        this.manageWindowTitle(chosenFileName);
        this.postLoadOperations(false);
        return true;
    }

    boolean saveToFile(String fileName) {
        File file = null;
        if (fileName == null) {
            String dirName = this.getPreference("LoadDirectory");
            while (file == null) {
                int option;
                File startDir;
                JFileChooser chooser = new JFileChooser();
                chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".btp", "filterName.btp"));
                if (dirName != null && (startDir = new File(dirName)).exists()) {
                    chooser.setCurrentDirectory(startDir);
                }
                if ((option = chooser.showSaveDialog(this.topWindow_)) != 0) {
                    return true;
                }
                file = chooser.getSelectedFile();
                if (file == null) continue;
                ResourceManager rMan = ResourceManager.getManager();
                if (!file.exists() && !FileExtensionFilters.hasSuffix(file.getName(), ".btp")) {
                    file = new File(file.getAbsolutePath() + ".btp");
                }
                if (this.standardFileChecks(file, false, true, true, false, true, false)) continue;
                file = null;
            }
        } else {
            file = new File(fileName);
            if (!this.standardFileChecks(file, false, true, false, false, true, false)) {
                return false;
            }
        }
        try {
            this.saveToOutputStream(new FileOutputStream(file));
            this.setCurrentFile(file);
            this.manageWindowTitle(file.getName());
        }
        catch (IOException ioe) {
            this.displayFileOutputError();
            return false;
        }
        return true;
    }

    void saveToOutputStream(OutputStream stream) throws IOException {
        Database db = Database.getDB();
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, "UTF-8")));
        Indenter ind = new Indenter(out, 2);
        db.writeXML(out, ind);
        out.close();
        UndoSupport.clearTracking();
    }

    public boolean standardFileChecks(File target, boolean mustExist, boolean canCreate, boolean checkOverwrite, boolean mustBeDirectory, boolean canWrite, boolean canRead) {
        String overFormat;
        String overMsg;
        int overwrite;
        ResourceManager rMan = ResourceManager.getManager();
        boolean doesExist = target.exists();
        if (mustExist && !doesExist) {
            String noFileFormat = rMan.getString("fileChecks.noFileFormat");
            String noFileMsg = MessageFormat.format(noFileFormat, target.getName());
            if (this.isHeadless_) {
                System.err.println(noFileMsg);
            } else {
                JOptionPane.showMessageDialog(this.topWindow_, noFileMsg, rMan.getString("fileChecks.noFileTitle"), 0);
            }
            return false;
        }
        if (mustBeDirectory) {
            if (doesExist && !target.isDirectory()) {
                String notADirectoryFormat = rMan.getString("fileChecks.notADirectoryFormat");
                String notADirectoryMsg = MessageFormat.format(notADirectoryFormat, target.getName());
                if (this.isHeadless_) {
                    System.err.println(notADirectoryMsg);
                } else {
                    JOptionPane.showMessageDialog(this.topWindow_, notADirectoryMsg, rMan.getString("fileChecks.notADirectoryTitle"), 0);
                }
                return false;
            }
        } else if (doesExist && !target.isFile()) {
            String notAFileFormat = rMan.getString("fileChecks.notAFileFormat");
            String notAFileMsg = MessageFormat.format(notAFileFormat, target.getName());
            if (this.isHeadless_) {
                System.err.println(notAFileMsg);
            } else {
                JOptionPane.showMessageDialog(this.topWindow_, notAFileMsg, rMan.getString("fileChecks.notAFileTitle"), 0);
            }
            return false;
        }
        if (!doesExist && canCreate) {
            if (mustBeDirectory) {
                throw new IllegalArgumentException();
            }
            boolean couldNotCreate = false;
            try {
                if (!target.createNewFile()) {
                    couldNotCreate = true;
                }
            }
            catch (IOException ioex) {
                couldNotCreate = true;
            }
            if (couldNotCreate) {
                String noCreateFormat = rMan.getString("fileChecks.noCreateFormat");
                String noCreateMsg = MessageFormat.format(noCreateFormat, target.getName());
                if (this.isHeadless_) {
                    System.err.println(noCreateMsg);
                } else {
                    JOptionPane.showMessageDialog(this.topWindow_, noCreateMsg, rMan.getString("fileChecks.noCreateTitle"), 0);
                }
                return false;
            }
        }
        boolean didExist = doesExist;
        doesExist = target.exists();
        if (canWrite && doesExist && !target.canWrite()) {
            String noWriteFormat = rMan.getString("fileChecks.noWriteFormat");
            String noWriteMsg = MessageFormat.format(noWriteFormat, target.getName());
            if (this.isHeadless_) {
                System.err.println(noWriteMsg);
            } else {
                JOptionPane.showMessageDialog(this.topWindow_, noWriteMsg, rMan.getString("fileChecks.noWriteTitle"), 0);
            }
            return false;
        }
        if (canRead && doesExist && !target.canRead()) {
            String noReadFormat = rMan.getString("fileChecks.noReadFormat");
            String noReadMsg = MessageFormat.format(noReadFormat, target.getName());
            if (this.isHeadless_) {
                System.err.println(noReadMsg);
            } else {
                JOptionPane.showMessageDialog(this.topWindow_, noReadMsg, rMan.getString("fileChecks.noReadTitle"), 0);
            }
            return false;
        }
        return !didExist || !checkOverwrite || this.isHeadless_ || (overwrite = JOptionPane.showConfirmDialog(this.topWindow_, overMsg = MessageFormat.format(overFormat = rMan.getString("fileChecks.doOverwriteFormat"), target.getName()), rMan.getString("fileChecks.doOverwriteTitle"), 0)) == 0;
    }

    public void saveToFileOperations(OutputClient client) {
        String filename = this.getPreference(client.getPrefsTag());
        File file = null;
        while (file == null) {
            int option;
            File startDir;
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(client.getExtension(), client.getFilterName()));
            if (filename != null && (startDir = new File(filename)).exists()) {
                chooser.setCurrentDirectory(startDir);
            }
            if ((option = chooser.showSaveDialog(this.topWindow_)) != 0) {
                return;
            }
            file = chooser.getSelectedFile();
            if (file == null) continue;
            ResourceManager rMan = ResourceManager.getManager();
            if (!file.exists() && !FileExtensionFilters.hasSuffix(file.getName(), client.getExtension())) {
                file = new File(file.getAbsolutePath() + client.getExtension());
            }
            if (this.standardFileChecks(file, false, true, true, false, true, false)) continue;
            file = null;
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            client.writeOutput(out);
            out.close();
            if (client.isBtpOut()) {
                UndoSupport.clearTracking();
                this.setCurrentFile(file);
            } else {
                this.setPreference(client.getPrefsTag(), file.getAbsoluteFile().getParent());
            }
        }
        catch (IOException ioe) {
            this.displayFileOutputError();
        }
    }

    public void zoomStateChanged(boolean scrollOnly) {
        if (!scrollOnly) {
            this.handleZoomButtons();
        }
        this.suw_.getSUPanel().setCurrClipRect(this.zoomer_.getCurrClipRect());
    }

    private void handleZoomButtons() {
        InOutZoomAction zaOutWI = (InOutZoomAction)this.withIcons_.get(new Integer(22));
        InOutZoomAction zaOutNI = (InOutZoomAction)this.noIcons_.get(new Integer(22));
        InOutZoomAction zaInWI = (InOutZoomAction)this.withIcons_.get(new Integer(23));
        InOutZoomAction zaInNI = (InOutZoomAction)this.noIcons_.get(new Integer(23));
        if (this.zoomer_.zoomIsWide()) {
            zaOutWI.setConditionalEnabled(false);
            if (zaOutNI != null) {
                zaOutNI.setConditionalEnabled(false);
            }
            zaInWI.setConditionalEnabled(true);
            if (zaInNI != null) {
                zaInNI.setConditionalEnabled(true);
            }
        } else if (this.zoomer_.zoomIsMax()) {
            zaOutWI.setConditionalEnabled(true);
            if (zaOutNI != null) {
                zaOutNI.setConditionalEnabled(true);
            }
            zaInWI.setConditionalEnabled(false);
            if (zaInNI != null) {
                zaInNI.setConditionalEnabled(false);
            }
        } else {
            zaOutWI.setConditionalEnabled(true);
            if (zaOutNI != null) {
                zaOutNI.setConditionalEnabled(true);
            }
            zaInWI.setConditionalEnabled(true);
            if (zaInNI != null) {
                zaInNI.setConditionalEnabled(true);
            }
        }
    }

    void handleZoomToCurrentButton() {
        ZoomToSelected z2cWI = (ZoomToSelected)this.withIcons_.get(new Integer(35));
        ZoomToSelected z2cNI = (ZoomToSelected)this.noIcons_.get(new Integer(35));
        SUPanel sup = this.suw_.getSUPanel();
        boolean onSelPath = sup.haveCurrentSelectionForBounds();
        z2cWI.setConditionalEnabled(onSelPath);
        if (z2cNI != null) {
            z2cNI.setConditionalEnabled(onSelPath);
        }
    }

    private void handlePathButtons() {
        UserTreePathBackwardAction baWI = (UserTreePathBackwardAction)this.withIcons_.get(new Integer(85));
        UserTreePathBackwardAction baNI = (UserTreePathBackwardAction)this.noIcons_.get(new Integer(85));
        UserTreePathForwardAction faWI = (UserTreePathForwardAction)this.withIcons_.get(new Integer(86));
        UserTreePathForwardAction faNI = (UserTreePathForwardAction)this.noIcons_.get(new Integer(86));
        UserTreePathDeleteAction daWI = (UserTreePathDeleteAction)this.withIcons_.get(new Integer(88));
        UserTreePathDeleteAction daNI = (UserTreePathDeleteAction)this.noIcons_.get(new Integer(88));
        UserTreePathAddStopAction asaWI = (UserTreePathAddStopAction)this.withIcons_.get(new Integer(89));
        UserTreePathAddStopAction asaNI = (UserTreePathAddStopAction)this.noIcons_.get(new Integer(89));
        UserTreePathDeleteStopAction dsaWI = (UserTreePathDeleteStopAction)this.withIcons_.get(new Integer(90));
        UserTreePathDeleteStopAction dsaNI = (UserTreePathDeleteStopAction)this.noIcons_.get(new Integer(90));
        boolean goBack = this.pathControl_.canGoBackward();
        if (baWI != null) {
            baWI.setConditionalEnabled(goBack);
        }
        if (baNI != null) {
            baNI.setConditionalEnabled(goBack);
        }
        boolean goForward = this.pathControl_.canGoForward();
        if (faWI != null) {
            faWI.setConditionalEnabled(goForward);
        }
        if (faNI != null) {
            faNI.setConditionalEnabled(goForward);
        }
        boolean pathSelected = this.pathControl_.pathIsSelected();
        if (daWI != null) {
            daWI.setConditionalEnabled(pathSelected);
        }
        if (daNI != null) {
            daNI.setConditionalEnabled(pathSelected);
        }
        boolean hasAPath = this.pathControl_.hasAPath();
        if (asaWI != null) {
            asaWI.setConditionalEnabled(hasAPath);
        }
        if (asaNI != null) {
            asaNI.setConditionalEnabled(hasAPath);
        }
        boolean hasAStop = this.pathControl_.pathHasAStop();
        if (dsaWI != null) {
            dsaWI.setConditionalEnabled(hasAStop);
        }
        if (dsaNI != null) {
            dsaNI.setConditionalEnabled(hasAStop);
        }
    }

    public void updateOverlayActionStatus(String ovrKey, Set modKeys) {
        boolean modsSelected;
        boolean ovrSelected;
        RemoveNetworkOverlayAction rnoWI = (RemoveNetworkOverlayAction)this.withIcons_.get(new Integer(100));
        RemoveNetworkOverlayAction rnoNI = (RemoveNetworkOverlayAction)this.noIcons_.get(new Integer(100));
        DrawNewNetworkModule dnWI = (DrawNewNetworkModule)this.withIcons_.get(new Integer(99));
        DrawNewNetworkModule dnNI = (DrawNewNetworkModule)this.noIcons_.get(new Integer(99));
        EditNetworkOverlayAction enoWI = (EditNetworkOverlayAction)this.withIcons_.get(new Integer(101));
        EditNetworkOverlayAction enoNI = (EditNetworkOverlayAction)this.noIcons_.get(new Integer(101));
        ZoomToCurrentNetworkModule ztcWI = (ZoomToCurrentNetworkModule)this.withIcons_.get(new Integer(102));
        ZoomToCurrentNetworkModule ztcNI = (ZoomToCurrentNetworkModule)this.noIcons_.get(new Integer(102));
        DrawNetworkModuleLink dnmlWI = (DrawNetworkModuleLink)this.withIcons_.get(new Integer(104));
        DrawNetworkModuleLink dnmlNI = (DrawNetworkModuleLink)this.noIcons_.get(new Integer(104));
        ToggleModuleComponentDisplay tmcdWI = (ToggleModuleComponentDisplay)this.withIcons_.get(new Integer(105));
        ToggleModuleComponentDisplay tmcdNI = (ToggleModuleComponentDisplay)this.noIcons_.get(new Integer(105));
        boolean bl = ovrSelected = ovrKey != null;
        if (rnoWI != null) {
            rnoWI.setConditionalEnabled(ovrSelected);
        }
        if (rnoNI != null) {
            rnoNI.setConditionalEnabled(ovrSelected);
        }
        if (enoWI != null) {
            enoWI.setConditionalEnabled(ovrSelected);
        }
        if (enoNI != null) {
            enoNI.setConditionalEnabled(ovrSelected);
        }
        if (dnWI != null) {
            dnWI.setConditionalEnabled(ovrSelected);
        }
        if (dnNI != null) {
            dnNI.setConditionalEnabled(ovrSelected);
        }
        boolean bl2 = modsSelected = modKeys.size() >= 1;
        if (dnmlWI != null) {
            dnmlWI.setConditionalEnabled(modsSelected);
        }
        if (dnmlNI != null) {
            dnmlNI.setConditionalEnabled(modsSelected);
        }
        if (ztcWI != null) {
            ztcWI.setConditionalEnabled(modsSelected);
        }
        if (ztcNI != null) {
            ztcNI.setConditionalEnabled(modsSelected);
        }
        if (tmcdWI != null) {
            tmcdWI.setConditionalEnabled(modsSelected);
        }
        if (tmcdNI != null) {
            tmcdNI.setConditionalEnabled(modsSelected);
        }
    }

    public void manageWindowTitle(String fileName) {
        String title;
        if (this.topWindow_ == null) {
            return;
        }
        ResourceManager rMan = ResourceManager.getManager();
        if (fileName == null) {
            title = rMan.getString("window.editorTitle");
        } else {
            String titleFormat = rMan.getString("window.editorTitleWithName");
            title = MessageFormat.format(titleFormat, fileName);
        }
        this.topWindow_.setTitle(title);
    }

    public void newModelOperations() {
        Database db = Database.getDB();
        if (db.getGenome() != null) {
            ModelChangeEvent mcev = new ModelChangeEvent(db.getGenome().getID(), 2);
            EventManager.getManager().sendModelChangeEvent(mcev);
        }
        GroupSettingManager.getGroupMgr().drop();
        db.newModel();
        this.setCurrentFile(null);
        this.overlayControl_.resetControllerState();
        NavTree navTree = db.getNavTree();
        TreePath dstp = navTree.getDefaultSelection();
        JTree jtree = this.suw_.getTree();
        jtree.setSelectionPath(dstp);
        this.suw_.makeImageVisible(false);
        this.suw_.makeOverlayControlsVisible(false);
        this.suw_.makeSliderVisible(false);
        this.pathControl_.clearControllerState();
        this.suw_.makePathControlsVisible(false);
        this.updateUserPathActions();
        this.setCurrentUserPath(0);
        this.zoomer_.setCurrentZoomForNewModel();
        this.suw_.getUndoManager().discardAllEdits();
        UndoSupport.clearTracking();
    }

    public void newModelTweaks() {
        this.pathControl_.clearControllerState();
        this.overlayControl_.resetControllerState();
        this.updateUserPathActions();
        this.setCurrentUserPath(0);
        this.zoomer_.setCurrentZoomForNewModel();
    }

    public void expandAndSelectNode(boolean selectRoot) {
        Database db = Database.getDB();
        NavTree navTree = db.getNavTree();
        JTree jtree = this.suw_.getTree();
        jtree.setModel(navTree);
        List nonleafPaths = navTree.getAllPathsToNonLeaves();
        Iterator nlpit = nonleafPaths.iterator();
        while (nlpit.hasNext()) {
            TreePath tp = (TreePath)nlpit.next();
            jtree.expandPath(tp);
        }
        if (selectRoot) {
            DefaultTreeModel dtm = (DefaultTreeModel)jtree.getModel();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)dtm.getRoot();
            DefaultMutableTreeNode rootChild = (DefaultMutableTreeNode)rootNode.getChildAt(0);
            Object[] tn = rootChild.getPath();
            TreePath tp = new TreePath(tn);
            jtree.setSelectionPath(tp);
        } else {
            TreePath dstp = navTree.getDefaultSelection();
            jtree.setSelectionPath(dstp);
        }
    }

    public void postLoadOperations(boolean selectRoot) {
        Database db = Database.getDB();
        GroupSettingManager gsm = GroupSettingManager.getGroupMgr();
        NavTree navTree = db.getNavTree();
        JTree jtree = this.suw_.getTree();
        jtree.setModel(navTree);
        List nonleafPaths = navTree.getAllPathsToNonLeaves();
        Iterator nlpit = nonleafPaths.iterator();
        while (nlpit.hasNext()) {
            TreePath tp = (TreePath)nlpit.next();
            jtree.expandPath(tp);
        }
        this.pathControl_.clearControllerState();
        this.overlayControl_.resetControllerState();
        this.updateUserPathActions();
        this.setCurrentUserPath(0);
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)giit.next();
            gsm.setGroupVisibilities(gi, 4);
        }
        this.suw_.preloadWithoutRefresh();
        SUPanel sup = this.suw_.getSUPanel();
        Workspace ws = db.getWorkspace();
        if (ws.needsCenter()) {
            sup.fixCenterPoint(true, null, false);
        }
        this.suw_.makeImageVisible(ImageManager.getMgr().hasAnImage());
        this.suw_.makePathControlsVisible(UserTreePathManager.getMgr().getPathCount() > 0);
        this.suw_.makeOverlayControlsVisible(this.overlayControl_.aModelHasOverlays());
        this.suw_.makeSliderVisible(new FullGenomeHierarchyOracle().hourlyDynamicModelExists());
        StartupView sv = db.getStartupView();
        sv.installInTree(this.suw_, selectRoot, navTree, jtree);
        DisplayOptions dop = DisplayOptionsManager.getMgr().getDisplayOptions();
        switch (dop.getFirstZoomMode()) {
            case 0: {
                this.zoomer_.zoomToAllModels();
                break;
            }
            case 1: {
                this.zoomer_.zoomToModel();
                break;
            }
            case 2: {
                this.zoomer_.zoomToFullWorksheet();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.suw_.getUndoManager().discardAllEdits();
        UndoSupport.clearTracking();
    }

    public void displayFileInputError(IOException ioex) {
        ResourceManager rMan = ResourceManager.getManager();
        if (ioex == null || ioex.getMessage() == null || ioex.getMessage().trim().equals("")) {
            if (!this.isHeadless_) {
                JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("fileRead.errorMessage"), rMan.getString("fileRead.errorTitle"), 0);
            } else {
                System.err.println(rMan.getString("fileRead.errorMessage"));
            }
            return;
        }
        String errMsg = ioex.getMessage().trim();
        String format = rMan.getString("fileRead.inputErrorMessageForIOEx");
        String outMsg = MessageFormat.format(format, errMsg);
        if (!this.isHeadless_) {
            JOptionPane.showMessageDialog(this.topWindow_, outMsg, rMan.getString("fileRead.errorTitle"), 0);
        } else {
            System.err.println(outMsg);
        }
    }

    public boolean prepTimeAxisForDataImport() {
        Database db = Database.getDB();
        TimeAxisDefinition tad = db.getTimeAxisDefinition();
        if (tad.isInitialized()) {
            return true;
        }
        UndoManager undo = this.suw_.getUndoManager();
        TimeAxisSetupDialog tasd = TimeAxisSetupDialog.timeAxisSetupDialogWrapper((JFrame)this.topWindow_, (UndoManager)undo);
        tasd.setVisible(true);
        tad = db.getTimeAxisDefinition();
        if (!tad.isInitialized()) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("tcsedit.noTimeDefinition"), rMan.getString("tcsedit.noTimeDefinitionTitle"), 0);
            return false;
        }
        return true;
    }

    public void displayInvalidInputError(InvalidInputException iiex) {
        String outMsg;
        boolean haveLine;
        ResourceManager rMan = ResourceManager.getManager();
        String errKey = iiex.getErrorKey();
        boolean haveKey = errKey != null && !errKey.equals("BT_INPUT_ERROR_UNSPECIFIED");
        int lineno = iiex.getErrorLineNumber();
        boolean bl = haveLine = lineno != -1;
        if (haveKey && haveLine) {
            String format = rMan.getString("fileRead.inputErrorMessageForLineWithDesc");
            String keyedErr = rMan.getString("invalidInput." + errKey);
            outMsg = MessageFormat.format(format, new Integer(lineno + 1), keyedErr);
        } else if (haveKey && !haveLine) {
            String format = rMan.getString("fileRead.inputErrorMessageWithDesc");
            String keyedErr = rMan.getString("invalidInput." + errKey);
            outMsg = MessageFormat.format(format, keyedErr);
        } else if (!haveKey && haveLine) {
            String format = rMan.getString("fileRead.inputErrorMessageForLine");
            outMsg = MessageFormat.format(format, new Integer(lineno + 1));
        } else {
            outMsg = rMan.getString("fileRead.inputErrorMessage");
        }
        if (this.isHeadless_) {
            System.err.println(outMsg);
        } else {
            JOptionPane.showMessageDialog(this.topWindow_, outMsg, rMan.getString("fileRead.errorTitle"), 0);
        }
    }

    void displayFileOutputError() {
        ResourceManager rMan = ResourceManager.getManager();
        JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("fileWrite.errorMessage"), rMan.getString("fileWrite.errorTitle"), 0);
    }

    public void offerColorFixup(UndoManager undo, LinkRouter.RoutingResult result, String genomeKey, JFrame topWindow) {
        ResourceManager rMan;
        int doBranches;
        DisplayOptionsManager dopmgr;
        DisplayOptions dopt;
        if (topWindow == null) {
            return;
        }
        if ((result.linkResult & 1) != 0 && (dopt = (dopmgr = DisplayOptionsManager.getMgr()).getDisplayOptions()).getBranchMode() == 0 && (doBranches = JOptionPane.showConfirmDialog(topWindow, (rMan = ResourceManager.getManager()).getString("reassignColors.doBranches"), rMan.getString("reassignColors.doBranchesTitle"), 0)) == 0) {
            Genome genome = Database.getDB().getGenome(genomeKey);
            String loKey = new LayoutManager().getLayout(genome.getID());
            UndoSupport supportTos = new UndoSupport(undo, "undo.turnOnSpecialBranches");
            dopmgr.turnOnSpecialLinkBranches(loKey, supportTos);
        }
    }

    public NetworkBuilder getANetworkBuilder() {
        return new NetworkBuilder();
    }

    public static synchronized boolean isInitialized() {
        return singleton_ != null;
    }

    public static synchronized MainCommands getCmds() {
        if (singleton_ == null) {
            throw new IllegalStateException();
        }
        return singleton_;
    }

    public static synchronized MainCommands initCmds(CommonView suw, JFrame topWindow, JMenu recentMenu, JMenu userPathsMenu, JComboBox userPathsCombo, JMenu gaggleGooseChooseMenu, JComboBox gaggleGooseCombo) {
        if (singleton_ != null) {
            throw new IllegalStateException();
        }
        singleton_ = new MainCommands(suw, topWindow, recentMenu, userPathsMenu, userPathsCombo, gaggleGooseChooseMenu, gaggleGooseCombo);
        return singleton_;
    }

    private MainCommands(CommonView suw, JFrame topWindow, JMenu recentMenu, JMenu userPathsMenu, JComboBox userPathsCombo, JMenu gaggleGooseChooseMenu, JComboBox gaggleGooseCombo) {
        this.suw_ = suw;
        this.isHeadless_ = topWindow == null;
        this.recentMenu_ = recentMenu;
        this.updateRecentMenu();
        this.zoomer_ = new ZoomCommandSupport(this);
        this.pathControl_ = new UserTreePathController(this.suw_, this);
        this.selectionNavControl_ = new SelectionNavController(this.suw_);
        this.overlayControl_ = new NetOverlayController(this.suw_, this);
        this.isAMac_ = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        this.userPathsMenu_ = userPathsMenu;
        this.userPathsCombo_ = userPathsCombo;
        this.userPathsCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (MainCommands.this.managingPathControls_) {
                        return;
                    }
                    ObjChoiceContent occ = (ObjChoiceContent)MainCommands.this.userPathsCombo_.getSelectedItem();
                    MainCommands.this.pathControl_.setCurrentPath(occ == null ? null : occ.val);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        if (gaggleGooseChooseMenu != null && gaggleGooseCombo != null) {
            this.gaggleGooseChooseMenu_ = gaggleGooseChooseMenu;
            this.gaggleGooseCombo_ = gaggleGooseCombo;
            this.gaggleGooseCombo_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        if (MainCommands.this.managingGaggleControls_) {
                            return;
                        }
                        GooseAppInterface goose = GooseManager.getManager().getGoose();
                        if (goose != null && goose.isActivated()) {
                            ObjChoiceContent occ = (ObjChoiceContent)MainCommands.this.gaggleGooseCombo_.getSelectedItem();
                            goose.setCurrentGaggleTarget(occ == null ? null : occ.val);
                            MainCommands.this.setCurrentGaggleTarget(MainCommands.this.gaggleGooseCombo_.getSelectedIndex());
                        }
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                    }
                }
            });
        }
        this.topWindow_ = topWindow;
        this.withIcons_ = new HashMap();
        this.noIcons_ = new HashMap();
        EventManager em = EventManager.getManager();
        em.addLayoutChangeListener(this);
        em.addModelChangeListener(this);
        em.addSelectionChangeListener(this);
        em.addGeneralChangeListener(this);
        em.addOverlayDisplayChangeListener(this);
        this.overlayControl_.resetControllerState();
        this.updateUserPathActions();
        this.setCurrentUserPath(0);
    }

    public static class RemoveSingleTypeSelections
    extends AbstractAction {
        private Integer type_;

        public RemoveSingleTypeSelections(Integer type, String text) {
            ResourceManager rMan = ResourceManager.getManager();
            String desc = MessageFormat.format(rMan.getString("command.DropNodeTypeSelections"), text);
            this.putValue("Name", desc);
            this.type_ = type;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Object[] setArg = new Object[]{this.type_};
                OneShot csr = MainCommands.getCmds().getOneShot(16);
                csr.performOperation(setArg);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class WebRunner
    extends BackgroundWorker {
        private NamedOutputStreamSource streamSrc_;
        private boolean skipRoot_;
        private String topID_;
        private CommonView mySuw_;
        private Map mapRepository_;
        private boolean needHtmlSkeleton_;
        private List keyList_;

        public WebRunner(NamedOutputStreamSource streamSrc, CommonView mySuw, boolean skipRoot, String topID, boolean needHtmlSkeleton, Map mapRepository, Set publishKeys) {
            super(null);
            this.streamSrc_ = streamSrc;
            this.mySuw_ = mySuw;
            this.skipRoot_ = skipRoot;
            this.topID_ = topID;
            this.needHtmlSkeleton_ = needHtmlSkeleton;
            this.mapRepository_ = mapRepository;
            this.keyList_ = publishKeys == null ? this.buildFullKeyList() : new ArrayList(publishKeys);
        }

        public Object runCore() throws AsynchExitRequestException {
            SUPanel sup = this.mySuw_.getSUPanel();
            HashMap boundsMap = new HashMap();
            Map scaleMap = this.buildScaleMap();
            int total = this.keyList_.size();
            int done = 0;
            try {
                Object lastKey = null;
                Iterator oit = this.keyList_.iterator();
                while (oit.hasNext()) {
                    WebPublisher.ModelScale scaleKey = (WebPublisher.ModelScale)oit.next();
                    String gkey = scaleKey.getModelID();
                    if (lastKey == null || !gkey.equals(lastKey)) {
                        String layoutID = this.mySuw_.getLayoutMgr().getLayout(gkey);
                        sup.setGraphLayout(layoutID);
                        sup.setGenomeForUndo(gkey);
                    }
                    done = this.runForScaleKey(sup, scaleKey, scaleMap, boundsMap, done, total);
                }
                if (this.needHtmlSkeleton_) {
                    HashMap<WebPublisher.ModelScale, Map> justNotes = new HashMap<WebPublisher.ModelScale, Map>();
                    Iterator bmit = boundsMap.keySet().iterator();
                    while (bmit.hasNext()) {
                        WebPublisher.ModelScale key = (WebPublisher.ModelScale)bmit.next();
                        SUPanel.BoundsMaps supMaps = (SUPanel.BoundsMaps)boundsMap.get(key);
                        justNotes.put(key, supMaps.noteBounds);
                    }
                    WebPublisher pub = new WebPublisher();
                    pub.printHTML(this.streamSrc_, justNotes, this.skipRoot_, this.topID_);
                } else {
                    this.mapRepository_.clear();
                    this.mapRepository_.putAll(boundsMap);
                }
            }
            catch (IOException ex) {
                this.stashException(ex);
            }
            return null;
        }

        private Map buildScaleMap() {
            HashMap<Integer, Double> retval = new HashMap<Integer, Double>();
            retval.put(new Integer(0), new Double(0.38));
            retval.put(new Integer(1), new Double(0.5));
            retval.put(new Integer(2), new Double(0.62));
            retval.put(new Integer(3), new Double(1.0));
            return retval;
        }

        private int runForScaleKey(SUPanel sup, WebPublisher.ModelScale scaleKey, Map scaleMap, Map boundsMap, int done, int total) throws AsynchExitRequestException, IOException {
            Double zoomFacObj = (Double)scaleMap.get(new Integer(scaleKey.getSize()));
            OutputStream namedStream = this.streamSrc_.getNamedStream(scaleKey.getFileName());
            SUPanel.BoundsMaps smallBounds = sup.exportToStream(namedStream, true, "PNG", null, zoomFacObj, null);
            boundsMap.put(scaleKey, smallBounds);
            double currProg = (double)(++done) / (double)total;
            boolean keepGoing = this.updateProgress((int)(currProg * 100.0));
            if (!keepGoing) {
                throw new AsynchExitRequestException();
            }
            return done;
        }

        private List buildFullKeyList() {
            ArrayList<WebPublisher.ModelScale> retval = new ArrayList<WebPublisher.ModelScale>();
            NavTree navTree = Database.getDB().getNavTree();
            List ordered = navTree.getPreorderListing(this.skipRoot_);
            Iterator oit = ordered.iterator();
            while (oit.hasNext()) {
                String gkey = (String)oit.next();
                retval.add(new WebPublisher.ModelScale(gkey, 0));
                retval.add(new WebPublisher.ModelScale(gkey, 1));
                retval.add(new WebPublisher.ModelScale(gkey, 2));
                retval.add(new WebPublisher.ModelScale(gkey, 3));
            }
            return retval;
        }

        public Object postRunCore() {
            return null;
        }
    }

    private class CSVImportRunner
    extends BackgroundWorker {
        private FullHierarchyCSVFormatFactory fhcsv_;
        private FullHierarchyBuilder.BIPData bipd_;
        private UndoSupport support_;
        private UndoManager myUndo_;
        private CommonView mySuw_;
        private JFrame myTopWindow_;
        private int importMode_;
        private boolean doOpts_;
        private boolean doSquash_;
        private int overlayOption_;
        private Map nodeIDMap_;
        private String dbGenomeCSVName_;

        public CSVImportRunner(CommonView mySuw, FullHierarchyCSVFormatFactory fhcsv, FullHierarchyBuilder.BIPData bipd, Map nodeIDMap, String dbGenomeCSVName, UndoManager undo, UndoSupport support, JFrame topWindow, int importMode, boolean doOpts, boolean doSquash, int overlayOption, boolean isHeadless) {
            super(new LinkRouter.RoutingResult(), isHeadless);
            this.fhcsv_ = fhcsv;
            this.bipd_ = bipd;
            this.support_ = support;
            this.myUndo_ = undo;
            this.mySuw_ = mySuw;
            this.myTopWindow_ = topWindow;
            this.importMode_ = importMode;
            this.doOpts_ = doOpts;
            this.doSquash_ = doSquash;
            this.overlayOption_ = overlayOption;
            this.nodeIDMap_ = nodeIDMap;
            this.dbGenomeCSVName_ = dbGenomeCSVName;
        }

        public Object runCore() throws AsynchExitRequestException {
            SUPanel sup = this.mySuw_.getSUPanel();
            LinkRouter.RoutingResult res = this.fhcsv_.buildFromCSVBackground(this.bipd_, sup.getCanvasCenter(), sup.getCanvasSize(), sup.getFontRenderContext(), this.importMode_ == 1, this.support_, this.doOpts_, this.doSquash_, this.overlayOption_, this.nodeIDMap_, this.dbGenomeCSVName_, this, 0.0, 1.0);
            return res;
        }

        public Object postRunCore() {
            SUPanel sup = this.mySuw_.getSUPanel();
            if (sup.modelIsOutsideWorkspaceBounds()) {
                sup.setWorkspaceToModelBounds(this.support_);
            }
            return null;
        }
    }

    private class NewGaggleNetworkRunner
    extends BackgroundWorker {
        private CommonView mySuw_;
        private JFrame myTopWindow_;
        private UndoSupport support_;
        private int importMode_;
        private List commands_;
        private boolean doOpts_;
        private UndoManager myUndo_;

        public NewGaggleNetworkRunner(List commands, CommonView mySuw, JFrame topWindow, int importMode, boolean doOpts, UndoSupport support, UndoManager undo) {
            super(new LinkRouter.RoutingResult());
            this.commands_ = commands;
            this.mySuw_ = mySuw;
            this.myTopWindow_ = topWindow;
            this.importMode_ = importMode;
            this.doOpts_ = doOpts;
            this.support_ = support;
            this.myUndo_ = undo;
        }

        public Object runCore() throws AsynchExitRequestException {
            DBGenomeSIFFormatFactory sff = new DBGenomeSIFFormatFactory(MainCommands.this.suw_);
            SUPanel sup = this.mySuw_.getSUPanel();
            try {
                LinkRouter.RoutingResult res = sff.buildForGaggle(this.commands_, this.myTopWindow_, this.myUndo_, sup.getCanvasCenter(), sup.getCanvasSize(), sup.getFontRenderContext(), this.importMode_ == 1, this.support_, this.doOpts_, this, 0.0, 1.0);
                return res;
            }
            catch (IOException ex) {
                this.stashException(ex);
                return null;
            }
        }

        public Object postRunCore() {
            SUPanel sup = this.mySuw_.getSUPanel();
            if (sup.modelIsOutsideWorkspaceBounds()) {
                sup.setWorkspaceToModelBounds(this.support_);
            }
            return null;
        }
    }

    private class SIFImportRunner
    extends BackgroundWorker {
        private CommonView mySuw_;
        private JFrame myTopWindow_;
        private UndoSupport support_;
        private int importMode_;
        private File file_;
        private boolean doOpts_;
        private UndoManager myUndo_;
        private int overlayOption_;

        public SIFImportRunner(File file, CommonView mySuw, JFrame topWindow, int importMode, boolean doOpts, int overlayOption, UndoSupport support, UndoManager undo) {
            super(new LinkRouter.RoutingResult());
            this.file_ = file;
            this.mySuw_ = mySuw;
            this.myTopWindow_ = topWindow;
            this.importMode_ = importMode;
            this.doOpts_ = doOpts;
            this.support_ = support;
            this.myUndo_ = undo;
            this.overlayOption_ = overlayOption;
        }

        public Object runCore() throws AsynchExitRequestException {
            DBGenomeSIFFormatFactory sff = new DBGenomeSIFFormatFactory(MainCommands.this.suw_);
            SUPanel sup = this.mySuw_.getSUPanel();
            try {
                LinkRouter.RoutingResult res = sff.buildFromSIF(this.file_, this.myTopWindow_, this.myUndo_, sup.getCanvasCenter(), sup.getCanvasSize(), sup.getFontRenderContext(), this.importMode_ == 1, this.support_, this.doOpts_, this.overlayOption_, this, 0.0, 1.0);
                return res;
            }
            catch (IOException ex) {
                this.stashException(ex);
                return null;
            }
        }

        public Object postRunCore() {
            SUPanel sup = this.mySuw_.getSUPanel();
            if (sup.modelIsOutsideWorkspaceBounds()) {
                sup.setWorkspaceToModelBounds(this.support_);
            }
            return null;
        }
    }

    private class RepairNonOrthoRunner
    extends BackgroundWorker {
        private Genome genome_;
        private CommonView mySuw_;
        private UndoSupport support_;
        private String loKey_;
        private boolean minCorners_;
        private LinkProperties forOne_;
        private LinkSegmentID onlyLsid_;
        private String overID_;

        public RepairNonOrthoRunner(CommonView mySuw, Genome genome, boolean minCorners, LinkProperties forOne, LinkSegmentID onlyLsid, String overID, UndoSupport support) {
            super(new Layout.OrthoRepairInfo(0, false));
            this.support_ = support;
            this.mySuw_ = mySuw;
            this.genome_ = genome;
            this.minCorners_ = minCorners;
            this.forOne_ = forOne;
            this.onlyLsid_ = onlyLsid;
            this.overID_ = overID;
        }

        public Object runCore() throws AsynchExitRequestException {
            SUPanel sup = this.mySuw_.getSUPanel();
            this.loKey_ = new LayoutManager().getLayout(this.genome_.getID());
            Layout lo = Database.getDB().getLayout(this.loKey_);
            FontRenderContext frc = sup.getFontRenderContext();
            ModificationCommands mc = new ModificationCommands();
            Layout.OrthoRepairInfo ori = this.forOne_ == null ? mc.fixAllNonOrtho(lo, this.genome_, frc, this.minCorners_, this.overID_, sup, this.support_, this, 0.01, 1.0) : (this.onlyLsid_ == null ? mc.fixAllNonOrthoForTree(this.forOne_, lo, this.genome_, frc, this.minCorners_, this.overID_, sup, this.support_, this, 0.01, 1.0) : mc.fixNonOrtho(this.forOne_, this.onlyLsid_, lo, this.genome_, frc, this.minCorners_, this.overID_, sup, this.support_, this, 0.01, 1.0));
            return ori;
        }

        public Object postRunCore() {
            this.support_.addEvent(new LayoutChangeEvent(this.loKey_, 1));
            return null;
        }
    }

    private class RepairTopologyRunner
    extends BackgroundWorker {
        private Genome genome_;
        private CommonView mySuw_;
        private UndoSupport support_;
        private String loKey_;
        private LinkProperties forOne_;
        private String overID_;

        public RepairTopologyRunner(CommonView mySuw, Genome genome, LinkProperties forOne, String overID, UndoSupport support) {
            super(new Layout.OrthoRepairInfo(0, false));
            this.support_ = support;
            this.mySuw_ = mySuw;
            this.genome_ = genome;
            this.forOne_ = forOne;
            this.overID_ = overID;
        }

        public Object runCore() throws AsynchExitRequestException {
            SUPanel sup = this.mySuw_.getSUPanel();
            this.loKey_ = new LayoutManager().getLayout(this.genome_.getID());
            Layout lo = Database.getDB().getLayout(this.loKey_);
            FontRenderContext frc = sup.getFontRenderContext();
            Layout.TopoRepairInfo tri = this.forOne_ == null ? lo.repairAllTopology(frc, sup, this.overID_, this, 0.0, 1.0) : lo.repairTreeTopology(this.forOne_, frc, sup, this.overID_, this, 0.0, 1.0);
            if (tri.haveAChange()) {
                int numChg = tri.changes.size();
                for (int i = 0; i < numChg; ++i) {
                    PropChangeCmd pcc = new PropChangeCmd((Layout.PropChange)tri.changes.get(i));
                    this.support_.addEdit(pcc);
                }
            }
            return tri;
        }

        public Object postRunCore() {
            this.support_.addEvent(new LayoutChangeEvent(this.loKey_, 1));
            return null;
        }
    }

    private class SpecialtyLayoutRunner
    extends BackgroundWorker {
        private SpecialtyLayoutEngine mySle_;
        private Genome genome_;
        private CommonView mySuw_;
        private UndoSupport support_;
        private String loKey_;

        public SpecialtyLayoutRunner(SpecialtyLayoutEngine sle, CommonView mySuw, Genome genome, UndoSupport support) {
            super(new LinkRouter.RoutingResult());
            this.mySle_ = sle;
            this.support_ = support;
            this.mySuw_ = mySuw;
            this.genome_ = genome;
        }

        public Object runCore() throws AsynchExitRequestException {
            this.loKey_ = new LayoutManager().getLayout(this.genome_.getID());
            SUPanel sup = this.mySuw_.getSUPanel();
            FontRenderContext frc = sup.getFontRenderContext();
            ModificationCommands mc = new ModificationCommands();
            Layout.PadNeedsForLayout padNeedsForLayout = mc.getLocalNetModuleLinkPadNeeds(frc, this.genome_.getID());
            this.mySle_.setModuleRecoveryData(padNeedsForLayout, null);
            LinkRouter.RoutingResult res = this.mySle_.specialtyLayout(this.support_, this, 0.0, 1.0);
            sup.fixCenterPoint(true, this.support_, false);
            return res;
        }

        public Object postRunCore() {
            SUPanel sup = this.mySuw_.getSUPanel();
            if (sup.modelIsOutsideWorkspaceBounds()) {
                sup.setWorkspaceToModelBounds(this.support_);
            }
            this.support_.addEvent(new LayoutChangeEvent(this.loKey_, 1));
            return null;
        }
    }

    private class CompressExpandRunner
    extends BackgroundWorker {
        private Genome genome_;
        private CommonView mySuw_;
        private String groupID_;
        private double fracH_;
        private double fracV_;
        private JFrame myTopWindow_;
        private UndoSupport support_;
        private String loKey_;
        private UndoManager myUndo_;
        private boolean doCompress_;
        private LayoutOptions options_;

        public CompressExpandRunner(CommonView mySuw, Genome genome, String groupID, JFrame topWindow, double fracH, double fracV, LayoutOptions options, UndoManager undo, UndoSupport support, boolean doCompress) {
            super(new LinkRouter.RoutingResult());
            this.support_ = support;
            this.mySuw_ = mySuw;
            this.fracH_ = fracH;
            this.fracV_ = fracV;
            this.myTopWindow_ = topWindow;
            this.genome_ = genome;
            this.groupID_ = groupID;
            this.myUndo_ = undo;
            this.doCompress_ = doCompress;
            this.options_ = options;
        }

        public Object runCore() throws AsynchExitRequestException {
            SUPanel sup = this.mySuw_.getSUPanel();
            ToolCommands tc = new ToolCommands(this.myTopWindow_, this.mySuw_, this.myUndo_);
            this.loKey_ = new LayoutManager().getLayout(this.genome_.getID());
            Layout lo = Database.getDB().getLayout(this.loKey_);
            HashSet<String> groupIDSet = null;
            if (this.groupID_ != null) {
                groupIDSet = new HashSet<String>();
                groupIDSet.add(this.groupID_);
            }
            LinkRouter.RoutingResult myResult = this.doCompress_ ? tc.squashGenome(lo, this.genome_, groupIDSet, sup.getFontRenderContext(), sup.getRawCenterPoint(), this.fracH_, this.fracV_, this.support_, this.options_, this, 0.0, 1.0) : tc.expandGenome(lo, this.genome_, groupIDSet, sup, sup.getFontRenderContext(), sup.getRawCenterPoint(), this.fracH_, this.fracV_, this.support_, this.options_, this, 0.0, 1.0);
            sup.fixCenterPoint(true, this.support_, false);
            return myResult;
        }

        public Object postRunCore() {
            SUPanel sup;
            if (!this.doCompress_ && (sup = MainCommands.this.suw_.getSUPanel()).modelIsOutsideWorkspaceBounds()) {
                sup.setWorkspaceToModelBounds(this.support_);
            }
            this.support_.addEvent(new LayoutChangeEvent(this.loKey_, 1));
            return null;
        }
    }

    private class OptimizeRunner
    extends BackgroundWorker {
        private CommonView mySuw_;
        private Genome genome_;
        private JFrame myTopWindow_;
        private UndoSupport support_;
        private Set links_;
        private UndoManager undo_;
        private Set frozen_;
        private boolean allowReroutes_;
        private String loKey_;

        public OptimizeRunner(CommonView mySuw, Genome genome, Set links, Set frozen, boolean allowReroutes, JFrame topWindow, UndoManager undo, UndoSupport support) {
            super(new LinkRouter.RoutingResult());
            this.mySuw_ = mySuw;
            this.myTopWindow_ = topWindow;
            this.genome_ = genome;
            this.links_ = links;
            this.allowReroutes_ = allowReroutes;
            this.frozen_ = frozen;
            this.support_ = support;
            this.undo_ = undo;
        }

        public Object runCore() throws AsynchExitRequestException {
            SUPanel sup = this.mySuw_.getSUPanel();
            AddCommands ac = new AddCommands(this.myTopWindow_, this.undo_);
            this.loKey_ = new LayoutManager().getLayout(this.genome_.getID());
            LinkRouter.RoutingResult result = ac.optimizeLinks(this.links_, this.frozen_, this.genome_, this.support_, this.allowReroutes_, sup.getFontRenderContext(), this, 0.0, 1.0);
            return result;
        }

        public Object postRunCore() {
            this.support_.addEvent(new LayoutChangeEvent(this.loKey_, 1));
            return null;
        }
    }

    private class SyncLayoutRunner
    extends BackgroundWorker {
        private DBGenome genome_;
        private CommonView mySuw_;
        private JFrame myTopWindow_;
        private UndoSupport support_;
        private boolean doCompress_;
        private boolean keepGroups_;
        private boolean directCopy_;
        private boolean swapPads_;
        private int overlayOption_;
        private UndoManager myUndo_;
        private List targets_;

        public SyncLayoutRunner(CommonView mySuw, DBGenome genome, JFrame topWindow, boolean directCopy, boolean doCompress, boolean keepGroups, boolean swapPads, int overlayOption, List targets, UndoManager undo, UndoSupport support) {
            super(new LinkRouter.RoutingResult());
            this.mySuw_ = mySuw;
            this.myTopWindow_ = topWindow;
            this.genome_ = genome;
            this.doCompress_ = doCompress;
            this.keepGroups_ = keepGroups;
            this.directCopy_ = directCopy;
            this.swapPads_ = swapPads;
            this.overlayOption_ = overlayOption;
            this.targets_ = targets;
            this.support_ = support;
            this.myUndo_ = undo;
        }

        public Object runCore() throws AsynchExitRequestException {
            SUPanel sup = this.mySuw_.getSUPanel();
            LayoutOptions lopt = new LayoutOptions(LayoutOptionsManager.getMgr().getLayoutOptions());
            lopt.inheritanceSquash = this.doCompress_;
            lopt.overlayOption = this.overlayOption_;
            ToolCommands tc = new ToolCommands(this.myTopWindow_, this.mySuw_, this.myUndo_);
            LinkRouter.RoutingResult res = tc.synchronizeAllLayouts(this.genome_, sup.getFontRenderContext(), this.support_, lopt, sup.getRawCenterPoint(), this.directCopy_, this.keepGroups_, this.swapPads_, this.targets_, this);
            return res;
        }

        public Object postRunCore() {
            Database db = Database.getDB();
            Iterator lit = db.getLayoutIterator();
            String rootID = this.genome_.getID();
            while (lit.hasNext()) {
                Layout lo = (Layout)lit.next();
                String targ = lo.getTarget();
                if (targ.equals(rootID)) continue;
                this.support_.addEvent(new LayoutChangeEvent(lo.getName(), 1));
            }
            return null;
        }
    }

    private class LayoutRunner
    extends BackgroundWorker {
        private Genome genome_;
        private CommonView mySuw_;
        private boolean doFull_;
        private UndoSupport support_;
        private Set links_;
        private String loKey_;

        public LayoutRunner(CommonView mySuw, Genome genome, boolean doFull, Set links, JFrame topWindow, UndoSupport support) {
            super(new LinkRouter.RoutingResult());
            this.mySuw_ = mySuw;
            this.doFull_ = doFull;
            this.genome_ = genome;
            this.links_ = links;
            this.support_ = support;
        }

        public Object runCore() throws AsynchExitRequestException {
            SUPanel sup = this.mySuw_.getSUPanel();
            LayoutOptions lopt = new LayoutOptions(LayoutOptionsManager.getMgr().getLayoutOptions());
            this.loKey_ = new LayoutManager().getLayout(this.genome_.getID());
            Layout lo = Database.getDB().getLayout(new LayoutManager().getLayout(this.genome_.getID()));
            LinkRouter.RoutingResult res = AddCommands.relayoutLinks(this.genome_, this.support_, lo, sup.getFontRenderContext(), lopt, this.doFull_, this.links_, this, 0.0, 1.0, false);
            return res;
        }

        public Object postRunCore() {
            this.support_.addEvent(new LayoutChangeEvent(this.loKey_, 1));
            return null;
        }
    }

    private class PropRootWithExpDataAction
    extends ChecksForEnabled {
        PropRootWithExpDataAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.PropRootWithExpData"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.PropRootWithExpData"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.PropRootWithExpDataMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, undo);
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                LayoutOptions lopt = LayoutOptionsManager.getMgr().getLayoutOptions();
                ModificationCommands mc = new ModificationCommands();
                FontRenderContext frc = sup.getFontRenderContext();
                Map globalPadNeeds = mc.getGlobalNetModuleLinkPadNeeds(frc);
                UndoSupport support = new UndoSupport(undo, "undo.propagateRootUsingExpressionData");
                tc.propagateRootUsingExpressionData(sup, sup.getCanvasCenter(), sup.getCanvasSize(), frc, lopt, globalPadNeeds, support, null, 0.1, 1.0);
                mc.repairNetModuleLinkPadsGlobally(globalPadNeeds, frc, false, support);
                support.finish();
                MainCommands.this.zoomer_.zoomToWorksheetCenter();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            if (!cache.oneRoot()) {
                return false;
            }
            return cache.timeCourseNotEmpty();
        }
    }

    private class SetDisplayOptionsAction
    extends ChecksForEnabled {
        SetDisplayOptionsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SetDisplayOpts"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SetDisplayOpts"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SetDisplayOptsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                DisplayOptionsDialog dod = new DisplayOptionsDialog(MainCommands.this.topWindow_, sup.getLayoutKey(), MainCommands.this.suw_.getUndoManager());
                dod.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class SetAutolayoutOptionsAction
    extends ChecksForEnabled {
        SetAutolayoutOptionsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SetAutolayoutOpts"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SetAutolayoutOpts"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SetAutolayoutOptsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                LayoutParametersDialog lpd = new LayoutParametersDialog(MainCommands.this.topWindow_);
                lpd.show();
                if (lpd.haveResult()) {
                    LayoutOptionsManager lom = LayoutOptionsManager.getMgr();
                    lom.setLayoutOptions(lpd.getOptions());
                    lom.setWorksheetLayoutParams(lpd.getWorksheetParams());
                    lom.setStackedBlockLayoutParams(lpd.getStackedBlockParams());
                    lom.setDiagonalLayoutParams(lpd.getDiagonalParams());
                    lom.setHaloLayoutParams(lpd.getHaloParams());
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.isRootOrRootInstance();
        }
    }

    public class OptimizeLinksAction
    extends ChecksForEnabled
    implements OneShot,
    BackgroundWorkerOwner {
        OptimizeLinksAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.OptimizeLinks"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.OptimizeLinks"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.OptimizeLinksMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        OptimizeLinksAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            try {
                boolean allowReparent;
                Set links = args == null ? null : (Set)args[0];
                Set frozen = args == null ? new HashSet() : (Set)args[1];
                Boolean allowReparentObj = args == null ? null : (Boolean)args[2];
                Database db = Database.getDB();
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                String key = sup.getGenome();
                Genome genome = db.getGenome(key);
                if (allowReparentObj == null) {
                    AllowReparentOptimizeDialog arpd = new AllowReparentOptimizeDialog(MainCommands.this.topWindow_);
                    arpd.setVisible(true);
                    if (!arpd.haveResult()) {
                        return false;
                    }
                    allowReparent = arpd.allowReparenting();
                } else {
                    allowReparent = allowReparentObj;
                }
                if (sup.hasASelection()) {
                    sup.selectNone();
                    sup.repaint();
                }
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                String undoString = links == null ? "undo.optimizeLinks" : "undo.optimizeSingleTree";
                UndoSupport support = new UndoSupport(undo, undoString);
                OptimizeRunner runner = new OptimizeRunner(MainCommands.this.suw_, genome, links, frozen, allowReparent, MainCommands.this.topWindow_, undo, support);
                BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
                runner.setClient(bwc);
                bwc.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return true;
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void handleCancellation() {
        }

        public void cleanUpPostRepaint(Object result) {
            ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, MainCommands.this.suw_.getUndoManager());
            tc.doStatusAnnouncements((LinkRouter.RoutingResult)result, MainCommands.this.topWindow_);
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.isRootOrRootInstance();
        }
    }

    private class RecolorLayoutAction
    extends ChecksForEnabled {
        RecolorLayoutAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.RecolorLayout"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.RecolorLayout"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.RecolorLayoutMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                UndoSupport support = new UndoSupport(undo, "undo.reassignColors");
                AddCommands ac = new AddCommands(MainCommands.this.topWindow_, undo);
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                Database db = Database.getDB();
                String key = sup.getGenome();
                Genome genome = db.getGenome(key);
                String loKey = new LayoutManager().getLayout(key);
                Layout lo = db.getLayout(loKey);
                LinkRouter.RoutingResult result = ac.reassignColors(genome, support, lo, sup.getFontRenderContext());
                sup.repaint();
                ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, MainCommands.this.suw_.getUndoManager());
                tc.doStatusAnnouncements(result, MainCommands.this.topWindow_);
                MainCommands.this.offerColorFixup(undo, result, key, MainCommands.this.topWindow_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotNull();
        }
    }

    private class AlignLayoutsAction
    extends ChecksForEnabled {
        AlignLayoutsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.CenterAllLayouts"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.CenterAllLayouts"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.CenterAllLayoutsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                boolean ignoreOverlays;
                boolean doCentering;
                boolean doMatchups;
                boolean trackOverlays = new FullGenomeHierarchyOracle().overlayExists();
                boolean emptyRoot = Database.getDB().getGenome().isEmpty();
                if (emptyRoot && !trackOverlays) {
                    doMatchups = false;
                    doCentering = true;
                    ignoreOverlays = true;
                } else {
                    LayoutCenteringDialog dialog = new LayoutCenteringDialog(MainCommands.this.topWindow_, emptyRoot, trackOverlays);
                    dialog.show();
                    if (!dialog.haveResult()) {
                        return;
                    }
                    doMatchups = dialog.doMatchups();
                    doCentering = dialog.doCentering();
                    ignoreOverlays = dialog.ignoreOverlays();
                }
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, undo);
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                boolean done = tc.alignAllLayouts(doMatchups, doCentering, ignoreOverlays, sup, sup.getFontRenderContext());
                if (done) {
                    MainCommands.this.zoomer_.zoomToFullWorksheet();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.moreThanOneModel();
        }
    }

    private class SyncLayoutsAction
    extends ChecksForEnabled
    implements BackgroundWorkerOwner {
        SyncLayoutsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SyncLayouts"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SyncLayouts"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SyncLayoutsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                String key = sup.getGenome();
                SyncLayoutTargetDialog sltd = new SyncLayoutTargetDialog(MainCommands.this.topWindow_);
                sltd.show();
                if (!sltd.haveResult()) {
                    return;
                }
                List targets = sltd.getSuperAddPairs();
                boolean offerDirect = new LayoutRubberStamper().directCopyOptionAllowed();
                SyncLayoutChoicesDialog slcd = new SyncLayoutChoicesDialog(MainCommands.this.topWindow_, offerDirect);
                slcd.show();
                if (!slcd.haveResult()) {
                    return;
                }
                boolean directCopy = slcd.directCopy();
                boolean doCompress = slcd.doCompress();
                boolean keepGroups = slcd.keepGroups();
                boolean swapPads = slcd.swapPads();
                int overlayOption = slcd.getOverlayOption();
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                DBGenome dbg = (DBGenome)db.getGenome();
                UndoSupport support = new UndoSupport(undo, "undo.syncLayouts");
                SyncLayoutRunner runner = new SyncLayoutRunner(MainCommands.this.suw_, dbg, MainCommands.this.topWindow_, directCopy, doCompress, keepGroups, swapPads, overlayOption, targets, undo, support);
                BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
                runner.setClient(bwc);
                bwc.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void handleCancellation() {
        }

        public void cleanUpPostRepaint(Object result) {
            ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, MainCommands.this.suw_.getUndoManager());
            tc.doStatusAnnouncements((LinkRouter.RoutingResult)result, MainCommands.this.topWindow_);
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            if (!cache.genomeIsRoot()) {
                return false;
            }
            return cache.moreThanOneModel();
        }
    }

    private class ApplyKidLayoutsToRootAction
    extends ChecksForEnabled {
        ApplyKidLayoutsToRootAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ApplyKidLayouts"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ApplyKidLayouts"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ApplyKidLayoutsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                DBGenome dbg = (DBGenome)db.getGenome();
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                boolean showOverlayOpts = dbg.getNetworkOverlayCount() > 0;
                LayoutPropagationDialog propDialog = new LayoutPropagationDialog(MainCommands.this.topWindow_, sup.getFontRenderContext(), showOverlayOpts);
                propDialog.show();
                if (!propDialog.haveResult()) {
                    return;
                }
                LayoutDerivation ld = propDialog.getLayoutDerivation();
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                LayoutManager lm = new LayoutManager();
                Layout lor = db.getLayout(lm.getLayout(dbg.getID()));
                UndoSupport support = new UndoSupport(undo, "undo.applyKidLayouts");
                ToolCommands.UpwardLayoutSynch uls = new ToolCommands.UpwardLayoutSynch();
                uls.synchronizeRootLayoutFromChildrenAsynch(dbg, lor, sup.getFontRenderContext(), support, ld, sup.getRawCenterPoint(), MainCommands.this.suw_, MainCommands.this.topWindow_, undo);
                return;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return;
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            if (!cache.genomeNotNull()) {
                return false;
            }
            return cache.moreThanOneModel();
        }
    }

    public class SpecialtyLayoutAction
    extends ChecksForEnabled
    implements BackgroundWorkerOwner,
    OneShot {
        private SpecialtyLayout specL_;
        private int mode_;
        private String undoStr_;
        static final int LAYOUT_ALL = 0;
        static final int LAYOUT_SELECTION = 1;
        static final int LAYOUT_PER_OVERLAY = 2;
        private static final int LAYOUT_REGION = 3;

        SpecialtyLayoutAction(boolean doIcon, SpecialtyLayout specL, int mode) {
            char mnem;
            String menName;
            this.mode_ = mode;
            ResourceManager rMan = ResourceManager.getManager();
            switch (mode) {
                case 0: {
                    menName = specL.getMenuName();
                    mnem = specL.getMenuMnemonic();
                    this.undoStr_ = null;
                    break;
                }
                case 1: {
                    menName = rMan.getString("command.LayoutSelected");
                    mnem = rMan.getChar("command.LayoutSelectedMnem");
                    this.undoStr_ = "undo.layoutSelected";
                    break;
                }
                case 2: {
                    menName = rMan.getString("command.LayoutPerOverlay");
                    mnem = rMan.getChar("command.LayoutPerOverlayMnem");
                    this.undoStr_ = "undo.layoutPerOverlay";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.putValue("Name", menName);
            if (doIcon) {
                this.putValue("ShortDescription", menName);
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            this.specL_ = specL;
        }

        SpecialtyLayoutAction() {
            this.specL_ = new StackedBlockLayout();
            this.mode_ = 3;
            this.undoStr_ = "undo.layoutRegion";
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            try {
                Database db = Database.getDB();
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                String key = sup.getGenome();
                Genome genome = db.getGenome(key);
                ArrayList<GenomeSubset> subsetList = new ArrayList<GenomeSubset>();
                Map interModPaths = null;
                Point2D useCenter = null;
                Layout lo = Database.getDB().getLayout(new LayoutManager().getLayout(key));
                boolean isForSubset = this.mode_ != 0;
                FontRenderContext frc = sup.getFontRenderContext();
                switch (this.mode_) {
                    case 0: {
                        GenomeSubset subset = new GenomeSubset(key, sup.getCanvasCenter());
                        subsetList.add(subset);
                        useCenter = subset.getPreferredCenter();
                        break;
                    }
                    case 1: {
                        GenomeSubset subset = new GenomeSubset(key, sup.getSelectedNodes(), null);
                        subset.setOrigBounds(lo, frc);
                        subsetList.add(subset);
                        break;
                    }
                    case 2: {
                        GenomeSubset subset;
                        String overlayKey = sup.getCurrentOverlay();
                        if (overlayKey == null) break;
                        OverlayLayoutAnalyzer ola = new OverlayLayoutAnalyzer();
                        OverlayLayoutAnalyzer.OverlayReport olaor = ola.canSupport(genome, lo, frc, overlayKey);
                        if (olaor.getResult() == 5) {
                            MessageTableReportingDialog mtrd = new MessageTableReportingDialog(MainCommands.this.topWindow_, olaor.getMissingLinkMessages(), "specLayout.overlayMissingLinksTitle", "specLayout.overlayMissingLinks", "specLayout.overlayMissingLink", new Dimension(800, 800), false, true);
                            mtrd.setVisible(true);
                            return true;
                        }
                        if (olaor.getResult() != 0) {
                            ResourceManager rMan = ResourceManager.getManager();
                            String errText = olaor.getResultMessage();
                            String desc = MessageFormat.format(rMan.getString("specLayout.overlayNotAdequate"), errText);
                            JOptionPane.showMessageDialog(MainCommands.this.topWindow_, UiUtil.convertMessageToHtml(desc), rMan.getString("specLayout.overlayNotAdequateTitle"), 0);
                            return true;
                        }
                        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(key);
                        NetworkOverlay nov = owner.getNetworkOverlay(overlayKey);
                        Map boundsPerMod = lo.getLayoutBoundsForEachNetModule(genome, owner, overlayKey, frc);
                        Iterator mit = nov.getModuleIterator();
                        while (mit.hasNext()) {
                            NetModule nmod = (NetModule)mit.next();
                            Iterator memit = nmod.getMemberIterator();
                            HashSet<String> memIds = new HashSet<String>();
                            while (memit.hasNext()) {
                                NetModuleMember nmm = (NetModuleMember)memit.next();
                                memIds.add(nmm.getID());
                            }
                            String id = nmod.getID();
                            Rectangle bounds = (Rectangle)boundsPerMod.get(id);
                            subset = new GenomeSubset(key, memIds, null);
                            subset.setOrigBounds(bounds);
                            subset.setModuleID(id);
                            subset.setOverlayID(overlayKey);
                            subsetList.add(subset);
                        }
                        interModPaths = new NetModuleLinkExtractor().extract(genome, lo, frc, overlayKey, subsetList);
                        break;
                    }
                    case 3: {
                        HashSet<String> regNodes = new HashSet<String>();
                        String regionID = (String)args[0];
                        Group group = ((GenomeInstance)genome).getGroup(regionID);
                        Iterator mit = group.getMemberIterator();
                        while (mit.hasNext()) {
                            GroupMember gm = (GroupMember)mit.next();
                            regNodes.add(gm.getID());
                        }
                        GenomeSubset subset = new GenomeSubset(key, regNodes, null);
                        subset.setOrigBounds(lo, frc);
                        subset.setGroupID(regionID);
                        subsetList.add(subset);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                int topoProblems = 0;
                int numSub = subsetList.size();
                if (!isForSubset) {
                    topoProblems = this.specL_.topologyIsHandled(genome);
                } else {
                    for (int i = 0; i < numSub; ++i) {
                        GenomeSubset subset = (GenomeSubset)subsetList.get(i);
                        Genome fake = subset.getPseudoGenome();
                        int myTopoProblems = this.specL_.topologyIsHandled(fake);
                        if (myTopoProblems == 0) continue;
                        topoProblems = myTopoProblems;
                        if (myTopoProblems == 1) break;
                    }
                }
                if (topoProblems == 2) {
                    ResourceManager rMan = ResourceManager.getManager();
                    int keepGoing = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("specLayout.topoProblems"), rMan.getString("specLayout.topoProblemsTitle"), 0);
                    if (keepGoing == 1) {
                        return true;
                    }
                } else if (topoProblems == 1) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("specLayout.topoProblemsMustStop"), rMan.getString("specLayout.topoProblemsTitle"), 0);
                    return true;
                }
                String selectedID = sup.getSingleNodeSelection();
                if (this.undoStr_ == null) {
                    this.undoStr_ = this.specL_.getUndoString();
                }
                SpecialtyLayoutEngineParamDialog paramDialog = this.specL_.getParameterDialog(MainCommands.this.topWindow_, genome, selectedID, isForSubset);
                paramDialog.show();
                if (!paramDialog.haveResult()) {
                    return true;
                }
                SpecialtyLayoutEngineParams params = paramDialog.getParams();
                String problem = null;
                for (int i = 0; i < numSub; ++i) {
                    GenomeSubset subset = (GenomeSubset)subsetList.get(i);
                    SpecialtyLayoutData sld = new SpecialtyLayoutData(subset, lo, sup.getFontRenderContext(), params);
                    SpecialtyLayout forked = this.specL_.forkForSubset(sld);
                    String setupProblem = forked.setUpIsOK();
                    if (setupProblem == null) continue;
                    problem = setupProblem;
                    break;
                }
                if (problem != null) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, problem, rMan.getString("specLayout.setupProblemsTitle"), 0);
                    return true;
                }
                if (sup.hasASelection()) {
                    sup.selectNone();
                    sup.repaint();
                }
                NetModuleLinkExtractor.SubsetAnalysis sa = new NetModuleLinkExtractor().analyzeForMods(subsetList, interModPaths);
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                UndoSupport support = new UndoSupport(undo, this.undoStr_);
                AddCommands ac = new AddCommands(MainCommands.this.topWindow_, undo);
                SpecialtyLayoutEngine sle = new SpecialtyLayoutEngine(subsetList, lo, this.specL_, sa, useCenter, ac, params, false, false);
                SpecialtyLayoutRunner runner = new SpecialtyLayoutRunner(sle, MainCommands.this.suw_, genome, support);
                BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
                runner.setClient(bwc);
                bwc.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return true;
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
            MainCommands.this.zoomer_.zoomToWorksheetCenter();
        }

        public void handleCancellation() {
        }

        public void cleanUpPostRepaint(Object result) {
            ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, MainCommands.this.suw_.getUndoManager());
            tc.doStatusAnnouncements((LinkRouter.RoutingResult)result, MainCommands.this.topWindow_);
            String genomeKey = MainCommands.this.suw_.getSUPanel().getGenome();
            MainCommands.this.offerColorFixup(MainCommands.this.suw_.getUndoManager(), (LinkRouter.RoutingResult)result, genomeKey, MainCommands.this.topWindow_);
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            if (!cache.genomeNotEmpty()) {
                return false;
            }
            if (!cache.genomeIsRoot()) {
                return false;
            }
            if (this.mode_ == 1) {
                return cache.haveASelection();
            }
            if (this.mode_ == 2) {
                return cache.canLayoutByOverlay();
            }
            return true;
        }
    }

    public class RelayoutLinksAction
    extends ChecksForEnabled
    implements OneShot,
    BackgroundWorkerOwner {
        private boolean doFull_;
        private boolean doCrooked_;

        RelayoutLinksAction(boolean doIcon, boolean doFull, boolean doCrooked) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString(doFull ? "command.RelayoutLinks" : "command.RelayoutDiagLinks"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString(doFull ? "command.RelayoutLinks" : "command.RelayoutDiagLinks"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar(doFull ? "command.RelayoutLinksMnem" : "command.RelayoutDiagLinksMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            this.doFull_ = doFull;
            this.doCrooked_ = doCrooked;
        }

        RelayoutLinksAction() {
            this.doFull_ = false;
            this.doCrooked_ = false;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Set nonOrtho = null;
                if (!this.doFull_) {
                    SUPanel sup = MainCommands.this.suw_.getSUPanel();
                    Database db = Database.getDB();
                    String key = sup.getGenome();
                    Genome genome = db.getGenome(key);
                    Layout lo = db.getLayout(new LayoutManager().getLayout(key));
                    nonOrtho = lo.getLimitedNonOrthoLinks(genome, sup.getFontRenderContext());
                }
                this.performOperation(new Object[]{nonOrtho});
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            Set links = args == null ? null : (Set)args[0];
            Database db = Database.getDB();
            SUPanel sup = MainCommands.this.suw_.getSUPanel();
            String key = sup.getGenome();
            Genome genome = db.getGenome(key);
            if (sup.hasASelection()) {
                sup.selectNone();
                sup.repaint();
            }
            MainCommands.this.suw_.disableControls(1, true);
            UndoManager undo = MainCommands.this.suw_.getUndoManager();
            String undoString = this.doFull_ ? "undo.relayoutLinks" : (this.doCrooked_ ? "undo.relayoutDiagLinks" : "undo.relayoutLinksThruSegment");
            UndoSupport support = new UndoSupport(undo, undoString);
            LayoutRunner runner = new LayoutRunner(MainCommands.this.suw_, genome, this.doFull_, links, MainCommands.this.topWindow_, support);
            BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
            runner.setClient(bwc);
            bwc.launchWorker();
            return true;
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void handleCancellation() {
        }

        public void cleanUpPostRepaint(Object result) {
            ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, MainCommands.this.suw_.getUndoManager());
            tc.doStatusAnnouncements((LinkRouter.RoutingResult)result, MainCommands.this.topWindow_);
            String genomeKey = MainCommands.this.suw_.getSUPanel().getGenome();
            MainCommands.this.offerColorFixup(MainCommands.this.suw_.getUndoManager(), (LinkRouter.RoutingResult)result, genomeKey, MainCommands.this.topWindow_);
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.isRootOrRootInstance();
        }
    }

    private class ExpandGenomeAction
    extends ChecksForEnabled
    implements OneShot,
    BackgroundWorkerOwner {
        ExpandGenomeAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ExpandRoot"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ExpandRoot"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ExpandRootMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        ExpandGenomeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            String groupID = args == null ? null : (String)args[0];
            Database db = Database.getDB();
            SUPanel sup = MainCommands.this.suw_.getSUPanel();
            String key = sup.getGenome();
            Genome genome = db.getGenome(key);
            boolean showOverlayOpts = genome instanceof GenomeInstance && genome.getNetworkModuleCount() > 0;
            CompressionPercentDialog dialog = new CompressionPercentDialog(MainCommands.this.topWindow_, false, showOverlayOpts);
            dialog.show();
            if (!dialog.haveResult()) {
                return true;
            }
            double fracH = dialog.getHorizontalFraction();
            double fracV = dialog.getVerticalFraction();
            LayoutOptions options = new LayoutOptions(LayoutOptionsManager.getMgr().getLayoutOptions());
            options.overlayCpexOption = showOverlayOpts ? dialog.getOverlayCpexOption() : -1;
            UndoManager undo = MainCommands.this.suw_.getUndoManager();
            UndoSupport support = new UndoSupport(undo, "undo.expandRoot");
            CompressExpandRunner runner = new CompressExpandRunner(MainCommands.this.suw_, genome, groupID, MainCommands.this.topWindow_, fracH, fracV, options, undo, support, false);
            BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
            runner.setClient(bwc);
            bwc.launchWorker();
            return true;
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
            MainCommands.this.zoomer_.zoomToWorksheetCenter();
        }

        public void handleCancellation() {
        }

        public void cleanUpPostRepaint(Object result) {
            ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, MainCommands.this.suw_.getUndoManager());
            tc.doStatusAnnouncements((LinkRouter.RoutingResult)result, MainCommands.this.topWindow_);
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.canStretch();
        }
    }

    private class SquashGenomeAction
    extends ChecksForEnabled
    implements OneShot,
    BackgroundWorkerOwner {
        SquashGenomeAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SquashRoot"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SquashRoot"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SquashRootMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        SquashGenomeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            SUPanel sup;
            String key;
            Database db = Database.getDB();
            Genome genome = db.getGenome(key = (sup = MainCommands.this.suw_.getSUPanel()).getGenome());
            boolean showOverlayOpts = genome instanceof GenomeInstance && genome.getNetworkModuleCount() > 0;
            String groupID = args == null ? null : (String)args[0];
            CompressionPercentDialog dialog = new CompressionPercentDialog(MainCommands.this.topWindow_, true, showOverlayOpts);
            dialog.show();
            if (!dialog.haveResult()) {
                return true;
            }
            double fracH = dialog.getHorizontalFraction();
            double fracV = dialog.getVerticalFraction();
            LayoutOptions options = new LayoutOptions(LayoutOptionsManager.getMgr().getLayoutOptions());
            options.overlayCpexOption = showOverlayOpts ? dialog.getOverlayCpexOption() : -1;
            UndoManager undo = MainCommands.this.suw_.getUndoManager();
            UndoSupport support = new UndoSupport(undo, "undo.squashRoot");
            CompressExpandRunner runner = new CompressExpandRunner(MainCommands.this.suw_, genome, groupID, MainCommands.this.topWindow_, fracH, fracV, options, undo, support, true);
            BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
            runner.setClient(bwc);
            bwc.launchWorker();
            return true;
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
            MainCommands.this.zoomer_.zoomToWorksheetCenter();
        }

        public void handleCancellation() {
        }

        public void cleanUpPostRepaint(Object result) {
            ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, MainCommands.this.suw_.getUndoManager());
            tc.doStatusAnnouncements((LinkRouter.RoutingResult)result, MainCommands.this.topWindow_);
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.canSquash();
        }
    }

    private class NetworkSearchAction
    extends ChecksForEnabled {
        NetworkSearchAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.NodeSearch"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.NodeSearch"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Find24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.NodeSearchMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            char accel = rMan.getChar("command.NodeSearchAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (MainCommands.this.suw_.getSUPanel().doNetworkSearch()) {
                    MainCommands.this.zoomer_.zoomToSelected();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotNull();
        }
    }

    private class EditColorsAction
    extends ChecksForEnabled {
        EditColorsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.EditColors"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.EditColors"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.EditColorsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ColorEditorDialog ced = new ColorEditorDialog(MainCommands.this.topWindow_, MainCommands.this.suw_.getUndoManager(), null);
                ced.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class ImportFullHierarchyFromCSVAction
    extends ChecksForEnabled
    implements OneShot,
    BackgroundWorkerOwner {
        private int importMode_;
        private String chosenFile_;
        private boolean headlessFailure_;

        ImportFullHierarchyFromCSVAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ImportHierarchyCSV"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ImportHierarchyCSV"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ImportHierarchyCSVMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        ImportFullHierarchyFromCSVAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            FullHierarchyBuilder.BIPData bipd;
            FullHierarchyCSVFormatFactory fhcsv;
            int overlayOption;
            boolean doSquash;
            boolean doOpt;
            Map nodeIDMap = null;
            Map modelIDMap = null;
            if (args == null) {
                SIFImportChoicesDialog sicd = new SIFImportChoicesDialog(MainCommands.this.topWindow_, false);
                sicd.show();
                if (!sicd.haveResult()) {
                    return true;
                }
                this.importMode_ = sicd.getMode();
                doOpt = sicd.doOptimize();
                doSquash = sicd.doSquash();
                overlayOption = sicd.getOverlayOption();
                if (this.importMode_ == 1) {
                    int ok;
                    ResourceManager rMan = ResourceManager.getManager();
                    if (UndoSupport.hasAChange() && (ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("loadAction.warningMessage"), rMan.getString("loadAction.warningMessageTitle"), 0)) != 0) {
                        return true;
                    }
                }
            } else {
                doOpt = false;
                doSquash = (Boolean)args[0];
                this.importMode_ = (Integer)args[1];
                overlayOption = (Integer)args[2];
                this.headlessFailure_ = false;
                nodeIDMap = (Map)args[5];
                modelIDMap = (Map)args[6];
            }
            File file = null;
            InputStream stream = null;
            if (args == null) {
                String filename = MainCommands.this.getPreference("ImportDirectory");
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".csv", "filterName.csv"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showOpenDialog(MainCommands.this.topWindow_)) != 0) {
                        return true;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null || MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) continue;
                    file = null;
                }
            } else if (((Boolean)args[3]).booleanValue()) {
                file = new File((String)args[4]);
                if (!MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) {
                    return false;
                }
            } else {
                stream = (InputStream)args[4];
            }
            Database db = Database.getDB();
            String string = this.chosenFile_ = file == null ? null : file.getName();
            if (this.importMode_ == 1) {
                MainCommands.this.setCurrentFile(null);
                ModelChangeEvent mcev = new ModelChangeEvent(db.getGenome().getID(), 2);
                EventManager.getManager().sendModelChangeEvent(mcev);
                MainCommands.this.manageWindowTitle(this.chosenFile_);
                MainCommands.this.newModelOperations();
            }
            if (args == null) {
                MainCommands.this.setPreference("ImportDirectory", file.getAbsoluteFile().getParent());
                MainCommands.this.suw_.disableControls(1, true);
            }
            UndoSupport support = new UndoSupport(MainCommands.this.suw_.getUndoManager(), "undo.buildFromCSV");
            try {
                fhcsv = new FullHierarchyCSVFormatFactory(MainCommands.this.suw_);
                bipd = file != null ? fhcsv.buildFromCSVForeground(file, MainCommands.this.topWindow_, MainCommands.this.suw_.getUndoManager(), this.importMode_ == 1, support) : fhcsv.buildFromCSVForegroundStream(stream, MainCommands.this.topWindow_, MainCommands.this.suw_.getUndoManager(), this.importMode_ == 1, modelIDMap, support);
                if (bipd == null) {
                    MainCommands.this.suw_.enableControls();
                    this.finishedImport(new LinkRouter.RoutingResult(), null, null);
                    return true;
                }
            }
            catch (InvalidInputException iiex) {
                if (support != null) {
                    support.finish();
                }
                if (args == null) {
                    MainCommands.this.suw_.enableControls(true);
                }
                this.finishedImport(null, null, iiex);
                return false;
            }
            catch (IOException ioex) {
                if (support != null) {
                    support.finish();
                }
                if (args == null) {
                    MainCommands.this.suw_.enableControls(true);
                }
                this.finishedImport(null, ioex, null);
                return false;
            }
            String dbGenomeCSVName = null;
            if (modelIDMap != null) {
                String dbGenomeKey = db.getGenome().getID();
                Iterator kit = modelIDMap.keySet().iterator();
                while (kit.hasNext()) {
                    String cSVName = (String)kit.next();
                    String modelID = (String)modelIDMap.get(cSVName);
                    if (!modelID.equals(dbGenomeKey)) continue;
                    dbGenomeCSVName = cSVName;
                    break;
                }
            }
            CSVImportRunner runner = new CSVImportRunner(MainCommands.this.suw_, fhcsv, bipd, nodeIDMap, dbGenomeCSVName, MainCommands.this.suw_.getUndoManager(), support, MainCommands.this.topWindow_, this.importMode_, doOpt, doSquash, overlayOption, args != null);
            BackgroundWorkerClient bwc = args == null ? new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "linkLayout.waitTitle", "linkLayout.wait", support, true) : new BackgroundWorkerClient(this, runner, support);
            runner.setClient(bwc);
            bwc.launchWorker(false);
            return args == null ? true : !this.headlessFailure_;
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void handleCancellation() {
        }

        public void cleanUpPostRepaint(Object result) {
            this.headlessFailure_ = !this.finishedImport((LinkRouter.RoutingResult)result, null, null);
        }

        private boolean finishedImport(LinkRouter.RoutingResult result, IOException ioEx, InvalidInputException iiex) {
            if (result != null) {
                ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, MainCommands.this.suw_.getUndoManager());
                tc.doStatusAnnouncements(result, MainCommands.this.topWindow_);
            }
            Database db = Database.getDB();
            if (ioEx != null) {
                if (this.importMode_ == 1) {
                    db.drop();
                    MainCommands.this.manageWindowTitle(null);
                    MainCommands.this.newModelOperations();
                }
                MainCommands.this.displayFileInputError(ioEx);
                return false;
            }
            if (iiex != null) {
                if (this.importMode_ == 1) {
                    db.drop();
                    MainCommands.this.manageWindowTitle(null);
                    MainCommands.this.newModelOperations();
                }
                MainCommands.this.displayInvalidInputError(iiex);
                return false;
            }
            if (db.getGenome() == null) {
                db.drop();
                MainCommands.this.newModelOperations();
                MainCommands.this.manageWindowTitle(null);
                MainCommands.this.displayFileInputError(null);
                return false;
            }
            if (this.importMode_ == 1) {
                MainCommands.this.manageWindowTitle(this.chosenFile_);
                MainCommands.this.postLoadOperations(true);
            }
            String genomeKey = MainCommands.this.suw_.getSUPanel().getGenome();
            MainCommands.this.offerColorFixup(MainCommands.this.suw_.getUndoManager(), result, genomeKey, MainCommands.this.topWindow_);
            return true;
        }
    }

    private class ImportGenomeFromSIFAction
    extends ChecksForEnabled
    implements BackgroundWorkerOwner {
        private int importMode_;
        private String chosenFile_;

        ImportGenomeFromSIFAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ImportGenomeSIF"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ImportGenomeSIF"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ImportGenomeSIFMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SIFImportChoicesDialog sicd = new SIFImportChoicesDialog(MainCommands.this.topWindow_, true);
                sicd.show();
                if (!sicd.haveResult()) {
                    return;
                }
                this.importMode_ = sicd.getMode();
                boolean doOpt = sicd.doOptimize();
                int overlayOption = sicd.getOverlayOption();
                if (this.importMode_ == 1) {
                    int ok;
                    ResourceManager rMan = ResourceManager.getManager();
                    if (UndoSupport.hasAChange() && (ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("loadAction.warningMessage"), rMan.getString("loadAction.warningMessageTitle"), 0)) != 0) {
                        return;
                    }
                }
                String filename = MainCommands.this.getPreference("ImportDirectory");
                this.chosenFile_ = null;
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".sif", "filterName.sif"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showOpenDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null || MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) continue;
                    file = null;
                }
                Database db = Database.getDB();
                this.chosenFile_ = file.getName();
                if (this.importMode_ == 1) {
                    MainCommands.this.setCurrentFile(null);
                    ModelChangeEvent mcev = new ModelChangeEvent(db.getGenome().getID(), 2);
                    EventManager.getManager().sendModelChangeEvent(mcev);
                    MainCommands.this.manageWindowTitle(this.chosenFile_);
                    MainCommands.this.newModelOperations();
                }
                MainCommands.this.setPreference("ImportDirectory", file.getAbsoluteFile().getParent());
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                UndoSupport support = new UndoSupport(undo, "undo.buildFromSIF");
                SIFImportRunner runner = new SIFImportRunner(file, MainCommands.this.suw_, MainCommands.this.topWindow_, this.importMode_, doOpt, overlayOption, support, undo);
                BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
                runner.setClient(bwc);
                bwc.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean handleRemoteException(Exception remoteEx) {
            if (remoteEx instanceof IOException) {
                this.finishedImport(null, (IOException)remoteEx);
                return true;
            }
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void handleCancellation() {
        }

        public void cleanUpPostRepaint(Object result) {
            this.finishedImport((LinkRouter.RoutingResult)result, null);
        }

        private void finishedImport(LinkRouter.RoutingResult result, IOException ioEx) {
            if (result != null) {
                ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, MainCommands.this.suw_.getUndoManager());
                tc.doStatusAnnouncements(result, MainCommands.this.topWindow_);
            }
            Database db = Database.getDB();
            if (ioEx != null) {
                if (this.importMode_ == 1) {
                    db.drop();
                    MainCommands.this.manageWindowTitle(null);
                    MainCommands.this.newModelOperations();
                }
                MainCommands.this.displayFileInputError(ioEx);
                return;
            }
            if (db.getGenome() == null) {
                db.drop();
                MainCommands.this.manageWindowTitle(null);
                MainCommands.this.newModelOperations();
                MainCommands.this.displayFileInputError(null);
                return;
            }
            if (this.importMode_ == 1) {
                MainCommands.this.manageWindowTitle(this.chosenFile_);
                MainCommands.this.postLoadOperations(true);
            }
            String genomeKey = MainCommands.this.suw_.getSUPanel().getGenome();
            MainCommands.this.offerColorFixup(MainCommands.this.suw_.getUndoManager(), result, genomeKey, MainCommands.this.topWindow_);
        }
    }

    private class ImportPerturbCsvFromFileAction
    extends ChecksForEnabled {
        ImportPerturbCsvFromFileAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ImportPerturbCsv"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ImportPerturbCsv"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ImportPerturbCsvMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (MainCommands.this.pmw_ != null && MainCommands.this.pmw_.havePendingEdit()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    int ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("importPertCSV.droppingPendingEdits"), rMan.getString("importPertCSV.droppingPendingEditsTitle"), 0);
                    if (ok != 0) {
                        return;
                    }
                    MainCommands.this.pmw_.dropAllPendingEdits();
                }
                String filename = MainCommands.this.getPreference("ImportDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".csv", "filterName.csv"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showOpenDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null || MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) continue;
                    file = null;
                }
                try {
                    DesignBatchKeyDialog dbkd = new DesignBatchKeyDialog(MainCommands.this.topWindow_);
                    dbkd.show();
                    if (!dbkd.haveResult()) {
                        return;
                    }
                    boolean useDate = dbkd.useDate();
                    boolean useTime = dbkd.useTime();
                    boolean useBatch = dbkd.useBatch();
                    boolean useInvest = dbkd.useInvest();
                    boolean useCondition = dbkd.useCondition();
                    PerturbCsvFormatFactory csvff = new PerturbCsvFormatFactory(MainCommands.this.topWindow_, useDate, useTime, useBatch, useInvest, useCondition);
                    if (csvff.parsePerturbCSV(file, MainCommands.this.suw_.getUndoManager())) {
                        MainCommands.this.setPreference("ImportDirectory", file.getAbsoluteFile().getParent());
                    }
                }
                catch (IOException ioe) {
                    MainCommands.this.displayFileInputError(ioe);
                }
                catch (OutOfMemoryError oom) {
                    ExceptionHandler.getHandler().displayOutOfMemory(oom);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class AddQpcrToRootInstancesAction
    extends ChecksForEnabled {
        AddQpcrToRootInstancesAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.AddQPCRToRootInstances"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.AddQPCRToRootInstances"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AddQPCRToRootInstancesMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, undo);
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                int sliceMode = tc.getSliceMode(MainCommands.this.topWindow_);
                if (sliceMode == -1) {
                    return;
                }
                tc.addNewQPCRGenesToRootInstances(sup, sup.getCanvasCenter(), sup.getCanvasSize(), sliceMode, sup.getFontRenderContext());
                MainCommands.this.zoomer_.zoomToWorksheetCenter();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            if (!cache.oneEmptyRoot()) {
                return false;
            }
            return cache.timeCourseNotEmpty();
        }
    }

    private class BuildFromDialogAction
    extends ChecksForEnabled {
        BuildFromDialogAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.BuildFromDialog"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.BuildFromDialog"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.BuildFromDialogMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                String key = sup.getGenome();
                Database db = Database.getDB();
                Genome genome = db.getGenome(key);
                List working = null;
                if (!(genome instanceof DBGenome)) {
                    InstanceInstructionSet iis = db.getInstanceInstructionSet(key);
                    GenomeInstance gi = (GenomeInstance)genome;
                    GenomeInstance parent = gi.getVfgParent();
                    if (parent != null) {
                        InstanceInstructionSet piis = db.getInstanceInstructionSet(parent.getID());
                        ArrayList parentList = new ArrayList();
                        if (piis != null) {
                            Iterator prit = piis.getRegionIterator();
                            while (prit.hasNext()) {
                                parentList.add(prit.next());
                            }
                        }
                        working = new ArrayList();
                        if (iis != null && iis.getRegionCount() > 0) {
                            Iterator rit = iis.getRegionIterator();
                            while (rit.hasNext()) {
                                working.add(rit.next());
                            }
                        }
                        if (working.isEmpty() && !parentList.isEmpty()) {
                            RegionInheritDialog rid = new RegionInheritDialog(MainCommands.this.topWindow_, parentList, working);
                            rid.show();
                            if (!rid.haveResult()) {
                                return;
                            }
                            working = rid.getRegions();
                        }
                        if (working.isEmpty()) {
                            RegionSetupDialog rsd = new RegionSetupDialog(MainCommands.this.topWindow_, working);
                            rsd.show();
                            if (!rsd.haveResult()) {
                                return;
                            }
                            working = rsd.getRegions();
                        }
                    } else if (iis == null || iis.getRegionCount() == 0) {
                        RegionSetupDialog rsd = new RegionSetupDialog(MainCommands.this.topWindow_, new ArrayList());
                        rsd.show();
                        if (!rsd.haveResult()) {
                            return;
                        }
                        working = rsd.getRegions();
                    } else {
                        working = new ArrayList();
                        Iterator rit = iis.getRegionIterator();
                        while (rit.hasNext()) {
                            working.add(rit.next());
                        }
                    }
                }
                BuildNetworkDialog bnd = new BuildNetworkDialog(genome, MainCommands.this.topWindow_, MainCommands.this.suw_, sup.getCanvasCenter(), sup.getCanvasSize(), sup.getFontRenderContext(), sup, working, undo, MainCommands.this);
                bnd.show();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.isNotDynamicInstance();
        }
    }

    private class ChangeModelDataAction
    extends ChecksForEnabled {
        ChangeModelDataAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ChangeModelData"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ChangeModelData"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ChangeModelDataMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                ModelDataDialog npd = new ModelDataDialog(MainCommands.this.topWindow_, MainCommands.this.suw_.getSUPanel(), undo);
                npd.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class PulldownAction
    extends ChecksForEnabled
    implements ToggleAction {
        private boolean ignore_;

        PulldownAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Pulldown"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Pulldown"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Inherit24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.PulldownMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            this.ignore_ = false;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.ignore_) {
                    return;
                }
                MainCommands.this.amPulling_ = !MainCommands.this.amPulling_;
                Database db = Database.getDB();
                if (MainCommands.this.amPulling_) {
                    String key;
                    Genome genome;
                    GenomeInstance gi;
                    GenomeInstance parent;
                    SUPanel sup;
                    if (db.haveBuildInstructions()) {
                        ResourceManager rMan = ResourceManager.getManager();
                        JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("instructWarning.PullDownMessage"), rMan.getString("instructWarning.PullDownTitle"), 2);
                    }
                    sup.setToMode((parent = (gi = (GenomeInstance)(genome = db.getGenome(key = (sup = MainCommands.this.suw_.getSUPanel()).getGenome()))).getVfgParent()) == null ? 20 : 19, null);
                    if (parent == null) {
                        PullDownFromRootFrame pdfrd = new PullDownFromRootFrame(MainCommands.this.topWindow_, db.getGenome(), gi, sup);
                        sup.registerPullFrame((JDialog)pdfrd);
                        pdfrd.show();
                    }
                } else {
                    MainCommands.this.suw_.getSUPanel().cancelAddMode(1);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void setToIgnore(boolean arg) {
            this.ignore_ = arg;
        }

        public void setAsActive(boolean arg) {
            MainCommands.this.amPulling_ = arg;
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.canPullDown();
        }

        protected boolean canPush(int pushCondition) {
            return (pushCondition & 4) == 0;
        }
    }

    public class AboutAction
    extends ChecksForEnabled {
        private URL aboutURL_;
        private JEditorPane pane_;
        private JFrame frame_;
        private FixedJButton buttonB_;
        private URL gnuUrl_;
        private URL sunUrl_;
        private URL l4jUrl_;

        AboutAction(boolean doIcon, URL aboutURL) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.About"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.About"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/About24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AboutMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            this.aboutURL_ = aboutURL;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.frame_ != null) {
                    this.frame_.setExtendedState(0);
                    this.frame_.toFront();
                    return;
                }
                try {
                    this.pane_ = new JEditorPane(this.aboutURL_);
                }
                catch (IOException ioex) {
                    return;
                }
                this.gnuUrl_ = this.getClass().getResource("/org/systemsbiology/biotapestry/data/licenses/LICENSE");
                this.sunUrl_ = this.getClass().getResource("/org/systemsbiology/biotapestry/data/licenses/LICENSE-SUN");
                this.l4jUrl_ = this.getClass().getResource("/org/systemsbiology/biotapestry/data/licenses/launch4j-head-LICENSE.txt");
                ResourceManager rMan = ResourceManager.getManager();
                this.pane_.setEditable(false);
                this.frame_ = new JFrame(rMan.getString("window.aboutTitle"));
                this.pane_.addHyperlinkListener(new HyperlinkListener(){

                    public void hyperlinkUpdate(HyperlinkEvent ev) {
                        try {
                            if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                URL toUse = ev.getDescription().indexOf("-SUN") != -1 ? AboutAction.this.sunUrl_ : (ev.getDescription().indexOf("launch4j-") != -1 ? AboutAction.this.l4jUrl_ : AboutAction.this.gnuUrl_);
                                AboutAction.this.pane_.setPage(toUse);
                                AboutAction.this.buttonB_.setEnabled(true);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                this.frame_.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        AboutAction.this.frame_ = null;
                        e.getWindow().dispose();
                    }
                });
                JPanel cp = (JPanel)this.frame_.getContentPane();
                cp.setBackground(Color.white);
                cp.setBorder(new EmptyBorder(20, 20, 20, 20));
                cp.setLayout(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                URL sugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/BioTapestrySplash.gif");
                JLabel label = new JLabel(new ImageIcon(sugif));
                UiUtil.gbcSet(gbc, 0, 0, 1, 3, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
                cp.add((Component)label, gbc);
                JScrollPane jsp = new JScrollPane(this.pane_);
                UiUtil.gbcSet(gbc, 0, 3, 1, 2, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
                cp.add((Component)jsp, gbc);
                this.buttonB_ = new FixedJButton(rMan.getString("dialogs.back"));
                this.buttonB_.setEnabled(false);
                this.buttonB_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            AboutAction.this.pane_.setPage(AboutAction.this.aboutURL_);
                            AboutAction.this.buttonB_.setEnabled(false);
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                FixedJButton buttonC = new FixedJButton(rMan.getString("dialogs.close"));
                buttonC.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            AboutAction.this.frame_.setVisible(false);
                            AboutAction.this.frame_.dispose();
                            AboutAction.this.frame_ = null;
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                Box buttonPanel = Box.createHorizontalBox();
                buttonPanel.add(Box.createHorizontalGlue());
                buttonPanel.add(this.buttonB_);
                buttonPanel.add(Box.createHorizontalStrut(10));
                buttonPanel.add(buttonC);
                UiUtil.gbcSet(gbc, 0, 5, 1, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
                cp.add((Component)buttonPanel, gbc);
                this.frame_.setSize(700, 700);
                this.frame_.setLocationRelativeTo(MainCommands.this.topWindow_);
                this.frame_.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class AppletAboutAction
    extends ChecksForEnabled {
        private URL aboutURL_;
        private AppletContext ctxt_;

        AppletAboutAction(boolean doIcon, AppletContext ctxt, URL aboutURL) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.About"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.About"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/About24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AboutMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            this.ctxt_ = ctxt;
            this.aboutURL_ = aboutURL;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.ctxt_.showDocument(this.aboutURL_, "about");
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class ModelCountsAction
    extends ChecksForEnabled {
        ModelCountsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ModelCounts"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ModelCounts"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ModelCountsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                String key = sup.getGenome();
                Genome genome = db.getGenome(key);
                int numGenes = 0;
                int numRest = 0;
                int numLinks = 0;
                if (genome != null) {
                    numGenes = genome.getGeneCount();
                    int numAllNodes = genome.getFullNodeCount();
                    numRest = numAllNodes - numGenes;
                    numLinks = genome.getLinkageCount();
                }
                ResourceManager rMan = ResourceManager.getManager();
                String desc = MessageFormat.format(rMan.getString("modelCounts.message"), new Integer(numGenes), new Integer(numRest), new Integer(numLinks));
                desc = UiUtil.convertMessageToHtml(desc);
                JOptionPane.showMessageDialog(MainCommands.this.topWindow_, desc, rMan.getString("modelCounts.modelCountTitle"), 1);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotNull();
        }
    }

    private class ShiftAllToWorkspace
    extends ChecksForEnabled {
        ShiftAllToWorkspace(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ShiftAllToWorkspace"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ShiftAllToWorkspace"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ShiftAllToWorkspaceMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                Rectangle allBounds = sup.getAllModelBounds();
                int modelCenterX = allBounds.x + allBounds.width / 2;
                int modelCenterY = allBounds.y + allBounds.height / 2;
                Dimension currDims = sup.getCanvasSize();
                int wsCornerX = modelCenterX - currDims.width / 2;
                int wsCornerY = modelCenterY - currDims.height / 2;
                UndoSupport support = new UndoSupport(MainCommands.this.suw_.getUndoManager(), "undo.shiftAllToWorkspace");
                sup.setWorkspace(new Rectangle(wsCornerX, wsCornerY, currDims.width, currDims.height), support);
                MainCommands.this.zoomer_.zoomToFullWorksheet();
                sup.repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.moreThanOneModel();
        }
    }

    private class ResizeWorkspace
    extends ChecksForEnabled {
        ResizeWorkspace(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ResizeWorksheet"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ResizeWorksheet"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ResizeWorksheetMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                Dimension currDims = sup.getCanvasSize();
                double aspect = sup.getCanvasAspectRatio();
                Rectangle allBounds = sup.getAllModelBounds();
                Point2D center = sup.getRawCenterPoint();
                ResizeWorkspaceDialog rwd = new ResizeWorkspaceDialog(MainCommands.this.topWindow_, currDims, center, aspect, allBounds, 100);
                rwd.show();
                if (!rwd.haveResult()) {
                    return;
                }
                UndoSupport support = new UndoSupport(MainCommands.this.suw_.getUndoManager(), "undo.resizeWorkspace");
                sup.setWorkspace(rwd.getResults(), support);
                MainCommands.this.zoomer_.zoomToFullWorksheet();
                sup.repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class CenterCurrentModelOnWorksheet
    extends ChecksForEnabled {
        CenterCurrentModelOnWorksheet(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.CenterModelOnWorksheet"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.CenterModelOnWorksheet"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.CenterModelOnWorksheetMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, undo);
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                String key = sup.getGenome();
                Database db = Database.getDB();
                Genome genome = db.getGenome(key);
                tc.centerLayout(genome, sup.getRawCenterPoint(), sup.getFontRenderContext());
                MainCommands.this.zoomer_.zoomToFullWorksheet();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotEmpty();
        }
    }

    private class ZoomToNetworkModule
    implements OneShot {
        ZoomToNetworkModule() {
        }

        public boolean performOperation(Object[] args) {
            if (args == null) {
                throw new IllegalArgumentException();
            }
            String modID = (String)args[0];
            SUPanel sup = MainCommands.this.suw_.getSUPanel();
            String ovrKey = sup.getCurrentOverlay();
            TaggedSet modKeys = new TaggedSet();
            modKeys.set.add(modID);
            Database db = Database.getDB();
            String key = sup.getGenome();
            Genome genome = db.getGenome(key);
            Layout lo = db.getLayout(new LayoutManager().getLayout(key));
            NetOverlayOwner noo = db.getOverlayOwnerFromGenomeKey(key);
            Rectangle bounds = lo.getLayoutBoundsForNetModules(genome, noo, ovrKey, modKeys, sup.getFontRenderContext(), false);
            MainCommands.this.zoomer_.zoomToRect(bounds);
            return true;
        }
    }

    private class ZoomToGroup
    implements OneShot {
        ZoomToGroup() {
        }

        public boolean performOperation(Object[] args) {
            String groupID = args == null ? null : (String)args[0];
            Database db = Database.getDB();
            SUPanel sup = MainCommands.this.suw_.getSUPanel();
            String key = sup.getGenome();
            GenomeInstance gi = (GenomeInstance)db.getGenome(key);
            Layout lo = db.getLayout(new LayoutManager().getLayout(key));
            GenomeInstance rootInstance = gi.isRootInstance() ? gi : gi.getVfgParentRoot();
            Group grp = rootInstance.getGroup(Group.getBaseID(groupID));
            Rectangle bounds = lo.getLayoutBoundsForGroup(rootInstance, grp, sup.getFontRenderContext(), true);
            MainCommands.this.zoomer_.zoomToRect(bounds);
            return true;
        }
    }

    private class CenterOnPrevNextSelected
    extends ChecksForEnabled {
        private boolean forPrev_;

        CenterOnPrevNextSelected(boolean doIcon, boolean forPrev) {
            ResourceManager rMan = ResourceManager.getManager();
            String name = rMan.getString(forPrev ? "command.CenterOnPrevSelected" : "command.CenterOnNextSelected");
            String shortName = rMan.getString(forPrev ? "command.CenterOnPrevSelected" : "command.CenterOnNextSelected");
            String icon = forPrev ? "CenterOnPrevSelected24.gif" : "CenterOnNextSelected24.gif";
            this.putValue("Name", name);
            if (doIcon) {
                this.putValue("ShortDescription", shortName);
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/" + icon);
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar(forPrev ? "command.CenterOnPrevSelectedMnem" : "command.CenterOnNextSelectedMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            this.forPrev_ = forPrev;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.forPrev_) {
                    if (MainCommands.this.suw_.getSUPanel().haveCurrentSelectionForBounds()) {
                        MainCommands.this.zoomer_.centerToPreviousSelected();
                    } else {
                        MainCommands.this.zoomer_.zoomToPreviousSelected();
                    }
                } else if (MainCommands.this.suw_.getSUPanel().haveCurrentSelectionForBounds()) {
                    MainCommands.this.zoomer_.centerToNextSelected();
                } else {
                    MainCommands.this.zoomer_.zoomToNextSelected();
                }
                MainCommands.this.handleZoomToCurrentButton();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.haveASelection() && cache.hasMultiSelections();
        }
    }

    private class ZoomToSelected
    extends ChecksForEnabled {
        private boolean justCurrent_;

        ZoomToSelected(boolean doIcon, boolean justCurrent) {
            ResourceManager rMan = ResourceManager.getManager();
            String name = rMan.getString(justCurrent ? "command.ZoomToCurrentSelected" : "command.ZoomToSelected");
            String shortName = rMan.getString(justCurrent ? "command.ZoomToCurrentSelected" : "command.ZoomToSelected");
            String icon = justCurrent ? "ZoomToSelected24.gif" : "ZoomToAllSelections24.gif";
            this.putValue("Name", name);
            if (doIcon) {
                this.putValue("ShortDescription", shortName);
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/" + icon);
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar(justCurrent ? "command.ZoomToCurrentSelectedMnem" : "command.ZoomToSelectedMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            this.justCurrent_ = justCurrent;
            if (this.justCurrent_) {
                this.setConditionalEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.justCurrent_) {
                    MainCommands.this.zoomer_.zoomToCurrentSelected();
                } else {
                    MainCommands.this.zoomer_.zoomToSelected();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            if (!this.justCurrent_) {
                return cache.haveASelection();
            }
            return MainCommands.this.suw_.getSUPanel().haveCurrentSelectionForBounds();
        }
    }

    private class ZoomToShowWorkspace
    extends ChecksForEnabled {
        ZoomToShowWorkspace(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ZoomToShowWorkspace"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ZoomToShowWorkspace"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ZoomToShowWorkspaceMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.zoomer_.zoomToFullWorksheet();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class ZoomToAllModels
    extends ChecksForEnabled {
        ZoomToAllModels(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ZoomToAllModels"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ZoomToAllModels"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/ZoomToAllModels24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ZoomToAllModelsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.zoomer_.zoomToAllModels();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotEmpty() || cache.genomeHasModule();
        }
    }

    private class ZoomToCurrentModel
    extends ChecksForEnabled {
        ZoomToCurrentModel(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ZoomToModel"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ZoomToModel"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/ZoomToModel24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ZoomToModelMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.zoomer_.zoomToModel();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotEmpty() || cache.genomeHasModule();
        }
    }

    private class InOutZoomAction
    extends ChecksForEnabled {
        private char sign_;

        InOutZoomAction(boolean doIcon, char sign) {
            String accelName;
            String mnemName;
            String stringName;
            String iconName;
            this.sign_ = sign;
            ResourceManager rMan = ResourceManager.getManager();
            if (sign == '+') {
                iconName = "ZoomIn24.gif";
                stringName = "command.ZoomIn";
                mnemName = "command.ZoomInMnem";
                accelName = "command.ZoomInAccel";
            } else {
                iconName = "ZoomOut24.gif";
                stringName = "command.ZoomOut";
                mnemName = "command.ZoomOutMnem";
                accelName = "command.ZoomOutAccel";
            }
            this.putValue("Name", rMan.getString(stringName));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString(stringName));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/" + iconName);
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar(mnemName);
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            char accel = rMan.getChar(accelName);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.zoomer_.bumpZoomWrapper(this.sign_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }

        protected boolean canPush(int pushCondition) {
            return (pushCondition & 2) == 0;
        }
    }

    private class LaunchSimulationAction
    extends ChecksForEnabled {
        LaunchSimulationAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.DoSim"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.DoSim"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.DoSimMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            char accel = rMan.getChar("command.DoSimAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                StringBuffer buf = new StringBuffer();
                Indenter ind = new Indenter(buf, 2);
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                String key = sup.getGenome();
                Genome genome = db.getGenome(key);
                if (!(genome instanceof DBGenome)) {
                    return;
                }
                buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                buf.append("<!-- Created by BioTapestry " + new Date() + " -->\n");
                ind.indent();
                buf.append("<sbml xmlns=\"http://www.sbml.org/sbml/level1\" level=\"1\" version=\"2\">\n");
                ind.up();
                ((DBGenome)genome).writeSBML(buf, ind);
                ind.down().indent();
                buf.append("</sbml>\n");
                try {
                    String sbml = buf.toString();
                    ModelBuilderMarkupLanguage modelBuilder = new ModelBuilderMarkupLanguage();
                    StringReader stringReader = new StringReader(sbml);
                    BufferedReader bufferedReader = new BufferedReader(stringReader);
                    Model model = modelBuilder.buildModel(bufferedReader, null);
                    new SimulationLauncher("Dizzy", model, true);
                }
                catch (Exception ex) {
                    System.err.println(ex + " " + ex.getMessage());
                    ex.printStackTrace();
                    throw new IllegalStateException();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotEmpty() && cache.genomeCanWriteSBML();
        }
    }

    private class TemporalInputTableManageAction
    extends ChecksForEnabled {
        TemporalInputTableManageAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.TemporalInputManage"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.TemporalInputManage"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.TemporalInputManageMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                TemporalInputTableManageDialog titmd = new TemporalInputTableManageDialog(MainCommands.this.topWindow_, undo);
                titmd.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class TimeCourseTableManageAction
    extends ChecksForEnabled {
        TimeCourseTableManageAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.TimeCourseManage"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.TimeCourseManage"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.TimeCourseManageMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                TimeCourseTableManageDialog tctmd = new TimeCourseTableManageDialog(MainCommands.this.topWindow_, undo);
                tctmd.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class PerturbManageAction
    extends ChecksForEnabled {
        PerturbManageAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.PerturbManage"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.PerturbManage"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.PerturbManageMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.launchPerturbationsManagementWindow(new PertFilterExpression(1));
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class DefineTimeAxisAction
    extends ChecksForEnabled {
        DefineTimeAxisAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.DefineTimeAxis"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.DefineTimeAxis"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.DefineTimeAxisMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                TimeAxisSetupDialog tasd = TimeAxisSetupDialog.timeAxisSetupDialogWrapper((JFrame)MainCommands.this.topWindow_, (UndoManager)undo);
                tasd.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class TimeCourseRegionHierarchyAction
    extends ChecksForEnabled {
        TimeCourseRegionHierarchyAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.TimeCourseRegionHierarchy"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.TimeCourseRegionHierarchy"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.TimeCourseRegionHierarchyMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                DevelopmentSpecDialog.assembleAndApplyHierarchy((JFrame)MainCommands.this.topWindow_, (UndoManager)undo);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.timeCourseHasTemplate();
        }
    }

    private class TimeCourseTableSetupAction
    extends ChecksForEnabled {
        TimeCourseTableSetupAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.TimeCourseSetup"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.TimeCourseSetup"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.TimeCourseSetupMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                TimeCourseSetupDialog tcsd = TimeCourseSetupDialog.timeSourceSetupDialogWrapper((JFrame)MainCommands.this.topWindow_, (UndoManager)undo);
                if (tcsd == null) {
                    return;
                }
                tcsd.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class RedoAction
    extends ChecksForEnabled {
        RedoAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Redo"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Redo"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Redo24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.RedoMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            char accel = rMan.getChar("command.RedoAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo;
                if (MainCommands.this.pmw_ != null && MainCommands.this.pmw_.havePendingEdit()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    int ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("undo.droppingPendingEdits"), rMan.getString("undo.droppingPendingEditsTitle"), 0);
                    if (ok != 0) {
                        return;
                    }
                    MainCommands.this.pmw_.dropAllPendingEdits();
                }
                if ((undo = MainCommands.this.suw_.getUndoManager()).canRedo()) {
                    undo.redo();
                    MainCommands.this.suw_.getSUPanel().repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class UndoAction
    extends ChecksForEnabled {
        UndoAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Undo"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Undo"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Undo24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.UndoMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            char accel = rMan.getChar("command.UndoAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo;
                if (MainCommands.this.pmw_ != null && MainCommands.this.pmw_.havePendingEdit()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    int ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("undo.droppingPendingEdits"), rMan.getString("undo.droppingPendingEditsTitle"), 0);
                    if (ok != 0) {
                        return;
                    }
                    MainCommands.this.pmw_.dropAllPendingEdits();
                }
                if ((undo = MainCommands.this.suw_.getUndoManager()).canUndo()) {
                    undo.undo();
                    MainCommands.this.suw_.getSUPanel().repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class SetFontAction
    extends ChecksForEnabled {
        SetFontAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SetFont"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SetFont"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SetFontMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                FontDialog fd = new FontDialog(MainCommands.this.topWindow_, sup.getLayoutKey(), sup.getFontRenderContext(), MainCommands.this.suw_.getUndoManager());
                fd.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class ToggleModuleComponentDisplay
    extends ChecksForEnabled {
        ToggleModuleComponentDisplay(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ToggleModuleComponent"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ToggleModuleComponent"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/ShowModuleComps24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ToggleModuleCompMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.suw_.getSUPanel().toggleModuleComponents();
                MainCommands.this.suw_.getSUPanel().repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean canPush(int pushCondition) {
            return (pushCondition & 2) == 0;
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }
    }

    private class ToggleBubblesAction
    extends ChecksForEnabled {
        ToggleBubblesAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ToggleBubbles"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ToggleBubbles"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/ShowPads24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ToggleBubblesMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.suw_.getSUPanel().toggleTargetBubbles();
                MainCommands.this.suw_.getSUPanel().repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean canPush(int pushCondition) {
            return (pushCondition & 2) == 0;
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.canShowBubbles();
        }
    }

    private class CancelAddModeAction
    extends ChecksForEnabled {
        CancelAddModeAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.CancelAddMode"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.CancelAddMode"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Stop24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.CancelAddModeMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.suw_.getSUPanel().cancelAddMode();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return false;
        }

        protected boolean reversePush(int pushCondition) {
            return (pushCondition & 2) != 0;
        }
    }

    private class GaggleProcessInbound
    extends ChecksForEnabled {
        private ImageIcon standard_;
        private ImageIcon inbound_;

        GaggleProcessInbound(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.GaggleProcessInbound"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.GaggleProcessInbound"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/P24.gif");
                this.standard_ = new ImageIcon(ugif);
                if (MainCommands.this.isAMac_) {
                    ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/P24Selected.gif");
                    this.inbound_ = new ImageIcon(ugif);
                }
                this.putValue("SmallIcon", this.standard_);
            } else {
                char mnem = rMan.getChar("command.GaggleProcessInboundMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                GooseAppInterface goose = GooseManager.getManager().getGoose();
                if (goose != null && goose.isActivated()) {
                    this.setButtonCondition(false);
                    SelectionSupport ss = goose.getSelectionSupport();
                    List pending = ss.getPendingCommands();
                    Iterator pit = pending.iterator();
                    while (pit.hasNext()) {
                        InboundGaggleOp op = (InboundGaggleOp)pit.next();
                        op.executeOp();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void setButtonCondition(boolean activate) {
            if (MainCommands.this.isAMac_) {
                this.putValue("SmallIcon", activate ? this.inbound_ : this.standard_);
                MainCommands.this.gaggleButton_.validate();
            } else {
                MainCommands.this.gaggleButton_.setBackground(activate ? Color.orange : MainCommands.this.gaggleButtonOffColor_);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.gooseIsActive();
        }
    }

    private class GaggleSendNameList
    extends ChecksForEnabled {
        GaggleSendNameList(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.GaggleSendNameList"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.GaggleSendNameList"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/B24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.GaggleSendNameListMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                GooseAppInterface goose = GooseManager.getManager().getGoose();
                if (goose != null && goose.isActivated()) {
                    goose.transmitSelections();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.gooseIsActive();
        }
    }

    private class GaggleSendNetwork
    extends ChecksForEnabled {
        GaggleSendNetwork(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.GaggleSendNetwork"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.GaggleSendNetwork"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/N24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.GaggleSendNetworkMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                GooseAppInterface goose = GooseManager.getManager().getGoose();
                if (goose != null && goose.isActivated()) {
                    ResourceManager rMan;
                    SelectionSupport ss = goose.getSelectionSupport();
                    SelectionSupport.NetworkForSpecies net = ss.getOutboundNetwork();
                    if (net == null || net.getNodes().isEmpty()) {
                        return;
                    }
                    int choice = 1;
                    if (net.haveDupNames()) {
                        rMan = ResourceManager.getManager();
                        choice = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("gaggle.dupNames"), rMan.getString("gaggle.dupNamesTitle"), 0);
                        if (choice == 1) {
                            return;
                        }
                    }
                    choice = 1;
                    if (net.haveOptionalLinks()) {
                        rMan = ResourceManager.getManager();
                        choice = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("gaggle.networkChoice"), rMan.getString("gaggle.networkChoiceTitle"), 1);
                        if (choice == 2) {
                            return;
                        }
                    }
                    goose.transmitNetwork(net, choice == 0);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            if (!cache.gooseIsActive()) {
                return false;
            }
            return cache.genomeIsRoot();
        }
    }

    private class GaggleLowerGoose
    extends ChecksForEnabled {
        GaggleLowerGoose(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.GaggleLowerGoose"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.GaggleLowerGoose"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/H24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.GaggleLowerGooseMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                GooseAppInterface goose = GooseManager.getManager().getGoose();
                if (goose != null && goose.isActivated()) {
                    goose.hideCurrentTarget();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.gooseIsActive();
        }
    }

    private class GaggleRaiseGoose
    extends ChecksForEnabled {
        GaggleRaiseGoose(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.GaggleRaiseGoose"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.GaggleRaiseGoose"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/S24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.GaggleRaiseGooseMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                GooseAppInterface goose = GooseManager.getManager().getGoose();
                if (goose != null && goose.isActivated()) {
                    goose.raiseCurrentTarget();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.gooseIsActive();
        }
    }

    private class GaggleUpdateGeese
    extends ChecksForEnabled {
        private ImageIcon standard_;
        private ImageIcon inbound_;

        GaggleUpdateGeese(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.GaggleUpdateGeese"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.GaggleUpdateGeese"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/U24.gif");
                this.standard_ = new ImageIcon(ugif);
                if (MainCommands.this.isAMac_) {
                    ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/U24Selected.gif");
                    this.inbound_ = new ImageIcon(ugif);
                }
                this.putValue("SmallIcon", this.standard_);
            } else {
                char mnem = rMan.getChar("command.GaggleUpdateGeeseMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                GooseAppInterface goose = GooseManager.getManager().getGoose();
                if (goose != null && goose.isActivated()) {
                    this.setButtonCondition(false);
                    MainCommands.this.updateGaggleTargetActions();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void setButtonCondition(boolean activate) {
            if (MainCommands.this.isAMac_) {
                this.putValue("SmallIcon", activate ? this.inbound_ : this.standard_);
                MainCommands.this.gaggleUpdateGooseButton_.validate();
            } else {
                MainCommands.this.gaggleUpdateGooseButton_.setBackground(activate ? Color.orange : MainCommands.this.gaggleButtonOffColor_);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.gooseIsActive();
        }
    }

    public class SetCurrentGaggleTargetAction
    extends ChecksForEnabled {
        private String gooseName_;
        private int gooseIndex_;

        public SetCurrentGaggleTargetAction(String gooseName, int gooseIndex) {
            this.gooseName_ = gooseName;
            this.gooseIndex_ = gooseIndex;
            this.putValue("Name", gooseName);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                GooseAppInterface goose = GooseManager.getManager().getGoose();
                if (goose != null && goose.isActivated()) {
                    goose.setCurrentGaggleTarget(this.gooseName_);
                }
                MainCommands.this.setCurrentGaggleTarget(this.gooseIndex_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.gooseIsActive();
        }
    }

    private class DropAllInstructionsAction
    extends ChecksForEnabled {
        DropAllInstructionsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.DropAllInstructions"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.DropAllInstructions"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.DropAllInstructionsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                UndoSupport support = new UndoSupport(undo, "undo.dropBuildInstructions");
                DeleteCommands dc = new DeleteCommands(MainCommands.this.topWindow_, undo);
                boolean didIt = dc.dropAllInstructions(support);
                if (didIt) {
                    support.addEvent(new GeneralChangeEvent(1));
                    support.finish();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.haveBuildInstructions();
        }
    }

    private class AddExtraProxyNodeAction
    extends ChecksForEnabled {
        AddExtraProxyNodeAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.AddExtraProxyNode"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.AddExtraProxyNode"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AddExtraProxyNodeMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.suw_.getSUPanel().setToMode(18, null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.isDynamicInstance();
        }
    }

    public class CopyMultiGroupAction
    extends ChecksForEnabled {
        CopyMultiGroupAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.CopyMultiGroup"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.CopyMultiGroup"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.CopyMultiGroupMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                if (db.haveBuildInstructions()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
                }
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                String key = sup.getGenome();
                GenomeInstance gi = (GenomeInstance)db.getGenome(key);
                HashSet<String> allGroups = new HashSet<String>();
                Iterator git = gi.getGroupIterator();
                while (git.hasNext()) {
                    Group group = (Group)git.next();
                    if (group.isASubset(gi)) continue;
                    allGroups.add(group.getID());
                }
                UndoManager undom = MainCommands.this.suw_.getUndoManager();
                AddCommands ac = new AddCommands(MainCommands.this.topWindow_, undom);
                ac.duplicateRegions(key, new LayoutManager().getLayout(key), allGroups, sup.getFontRenderContext());
                sup.repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeIsRootInstance();
        }
    }

    private class ZoomToCurrentNetworkModule
    extends ChecksForEnabled
    implements OneShot {
        ZoomToCurrentNetworkModule(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ZoomToCurrentNetworkModule"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ZoomToCurrentNetworkModule"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ZoomToCurrentNetworkModuleMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        ZoomToCurrentNetworkModule() {
        }

        public boolean performOperation(Object[] args) {
            SUPanel sup = MainCommands.this.suw_.getSUPanel();
            String ovrKey = sup.getCurrentOverlay();
            TaggedSet modKeys = sup.getCurrentNetModules();
            if (modKeys.set.size() < 1) {
                return false;
            }
            Database db = Database.getDB();
            String key = sup.getGenome();
            Genome genome = db.getGenome(key);
            Layout lo = db.getLayout(new LayoutManager().getLayout(key));
            NetOverlayOwner noo = db.getOverlayOwnerFromGenomeKey(key);
            boolean showLinksToo = modKeys.set.size() > 1;
            Rectangle bounds = lo.getLayoutBoundsForNetModules(genome, noo, ovrKey, modKeys, sup.getFontRenderContext(), showLinksToo);
            MainCommands.this.zoomer_.zoomToRect(bounds);
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }
    }

    private class DrawNetworkModuleLink
    extends ChecksForEnabled {
        DrawNetworkModuleLink(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.DrawNetworkModuleLink"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.DrawNetworkModuleLink"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/CreateNewModuleLink24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.DrawNetworkModuleLinkMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.suw_.getSUPanel().setToMode(3, null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }
    }

    private class DrawNewNetworkModule
    extends ChecksForEnabled {
        DrawNewNetworkModule(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.DrawNewNetworkModule"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.DrawNewNetworkModule"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/CreateNewModule24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.DrawNewNetworkModuleMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.suw_.getSUPanel().setToMode(2, null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }
    }

    private class EditNetworkOverlayAction
    extends ChecksForEnabled
    implements OneShot {
        EditNetworkOverlayAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.EditNetworkOverlay"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.EditNetworkOverlay"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            }
            char mnem = rMan.getChar("command.EditNetworkOverlayMnem");
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        EditNetworkOverlayAction() {
        }

        public boolean performOperation(Object[] args) {
            SUPanel sup = MainCommands.this.suw_.getSUPanel();
            String key = sup.getGenome();
            UndoManager undo = MainCommands.this.suw_.getUndoManager();
            String ovrKey = sup.getCurrentOverlay();
            String layoutKey = sup.getLayoutKey();
            NetOverlayPropertiesDialog nopd = new NetOverlayPropertiesDialog(MainCommands.this.topWindow_, key, layoutKey, ovrKey, sup, undo);
            nopd.setVisible(true);
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }
    }

    private class RemoveNetworkOverlayAction
    extends ChecksForEnabled
    implements OneShot {
        RemoveNetworkOverlayAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.RemoveNetworkOverlay"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.RemoveNetworkOverlay"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            }
            char mnem = rMan.getChar("command.RemoveNetworkOverlayMnem");
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        RemoveNetworkOverlayAction() {
        }

        public boolean performOperation(Object[] args) {
            SUPanel sup = MainCommands.this.suw_.getSUPanel();
            Database db = Database.getDB();
            String key = sup.getGenome();
            Genome genome = db.getGenome(key);
            UndoManager undo = MainCommands.this.suw_.getUndoManager();
            String ovrKey = sup.getCurrentOverlay();
            UndoSupport support = new UndoSupport(undo, "undo.removeNetworkOverlay");
            DeleteCommands dc = new DeleteCommands(MainCommands.this.topWindow_, undo);
            MainCommands.this.overlayControl_.clearCurrentOverlay(support);
            dc.deleteNetworkOverlay(genome, ovrKey, support);
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }
    }

    private class AddNetworkOverlayAction
    extends ChecksForEnabled {
        AddNetworkOverlayAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.AddNetworkOverlay"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.AddNetworkOverlay"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/CreateOverlay24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AddNetworkOverlayMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                Database db = Database.getDB();
                String key = sup.getGenome();
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                UndoSupport support = new UndoSupport(undo, "undo.newNetworkOverlay");
                AddCommands ac = new AddCommands(MainCommands.this.topWindow_, undo);
                AddCommands.AddOverlayResult ovrRes = ac.addNewNetworkOverlay(key, sup.getCurrentOverlaySettings(), support);
                if (ovrRes == null) {
                    return;
                }
                MainCommands.this.overlayControl_.setCurrentOverlay(ovrRes.overlayID, support);
                support.finish();
                if (ovrRes.changeViz) {
                    MainCommands.this.overlayControl_.setSliderValue(50);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotNull();
        }
    }

    private class AddNoteAction
    extends ChecksForEnabled {
        AddNoteAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.AddNote"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.AddNote"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/DrawNewNote24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AddNoteMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.suw_.getSUPanel().setToMode(13, null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotNull();
        }
    }

    private class DrawGroupInInstance
    extends ChecksForEnabled {
        DrawGroupInInstance(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.DrawGroupInInstance"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.DrawGroupInInstance"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/DrawRegions24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.DrawGroupInInstanceMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                if (db.haveBuildInstructions()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
                }
                MainCommands.this.suw_.getSUPanel().setToMode(5, null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.isNonDynamicInstance();
        }
    }

    private class AddNodeAction
    extends ChecksForEnabled {
        AddNodeAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.AddNode"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.AddNode"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/NewNodes24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AddNodeMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                if (db.haveBuildInstructions()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
                }
                MainCommands.this.suw_.getSUPanel().setToMode(9, null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.canAdd();
        }
    }

    private class PropagateDownAction
    extends ChecksForEnabled {
        PropagateDownAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.PropagateDown"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.PropagateDown"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Propagate24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.PropagateDownMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                if (db.haveBuildInstructions()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("instructWarning.PropDownMessage"), rMan.getString("instructWarning.PropDownTitle"), 2);
                }
                MainCommands.this.suw_.getSUPanel().propagateDown();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.canPropagateDown();
        }
    }

    private class AddLinkAction
    extends ChecksForEnabled {
        AddLinkAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.AddLink"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.AddLink"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/NewLink24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AddLinkMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                if (db.haveBuildInstructions()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
                }
                MainCommands.this.suw_.getSUPanel().setToMode(8, null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.canAddLink();
        }
    }

    private class AddAction
    extends ChecksForEnabled {
        AddAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Add"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Add"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/NewGene24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AddMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                if (db.haveBuildInstructions()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
                }
                MainCommands.this.suw_.getSUPanel().setToMode(1, null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.canAdd();
        }
    }

    private class RepairNonOrthoLinkSegmentsAction
    extends ChecksForEnabled
    implements BackgroundWorkerOwner,
    OneShot {
        private boolean minCorners_;

        RepairNonOrthoLinkSegmentsAction() {
        }

        RepairNonOrthoLinkSegmentsAction(boolean doIcon, boolean minCorners) {
            this.minCorners_ = minCorners;
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString(this.minCorners_ ? "command.RepairAllNonOrthoLinksMinSplit" : "command.RepairAllNonOrthoLinksMinShift"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString(this.minCorners_ ? "command.RepairAllNonOrthoLinksMinSplit" : "command.RepairAllNonOrthoLinksMinShift"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar(this.minCorners_ ? "command.RepairAllNonOrthoLinksMinSplitMnem" : "command.RepairAllNonOrthoLinksMinShiftMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            try {
                SUPanel sup;
                LinkProperties forOne = null;
                LinkSegmentID onlyLsid = null;
                boolean useForMin = this.minCorners_;
                String overID = null;
                if (args != null) {
                    useForMin = (Boolean)args[0];
                    forOne = (LinkProperties)args[1];
                    onlyLsid = (LinkSegmentID)args[2];
                    overID = (String)args[3];
                }
                if ((sup = MainCommands.this.suw_.getSUPanel()).hasASelection()) {
                    sup.selectNone();
                    sup.repaint();
                }
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                UndoSupport support = forOne == null ? new UndoSupport(undo, "undo.repairAllNonOrtho") : (onlyLsid == null ? new UndoSupport(undo, "undo.fixAllNonOrthoForTree") : new UndoSupport(undo, "undo.fixNonOrtho"));
                Database db = Database.getDB();
                String key = sup.getGenome();
                Genome genome = db.getGenome(key);
                RepairNonOrthoRunner runner = new RepairNonOrthoRunner(MainCommands.this.suw_, genome, useForMin, forOne, onlyLsid, overID, support);
                BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
                runner.setClient(bwc);
                bwc.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return true;
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void cleanUpPostRepaint(Object result) {
            ResourceManager rMan = ResourceManager.getManager();
            Layout.OrthoRepairInfo ori = (Layout.OrthoRepairInfo)result;
            if (ori.failCount > 0) {
                if (ori.singleSeg) {
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("fixNonOrthoSeg.failWarning"), rMan.getString("fixNonOrthoSeg.failWarningTitle"), 2);
                } else {
                    boolean someOK = ori.chgs != null && ori.chgs.length != 0;
                    String form = rMan.getString(someOK ? "fixNonOrtho.partialFail" : "fixNonOrtho.fullFail");
                    form = UiUtil.convertMessageToHtml(form);
                    Integer failNum = new Integer(ori.failCount);
                    String failMsg = MessageFormat.format(form, failNum);
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString(failMsg), rMan.getString("fixNonOrtho.failWarningTitle"), 2);
                }
            }
        }

        public void handleCancellation() {
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotNull();
        }
    }

    private class LinkTopologyRepair
    extends ChecksForEnabled
    implements BackgroundWorkerOwner,
    OneShot {
        LinkTopologyRepair() {
        }

        LinkTopologyRepair(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.AllLinkTopologyRepair"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.AllLinkTopologyRepair"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AllLinkTopologyRepairMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            try {
                SUPanel sup;
                LinkProperties forOne = null;
                String overID = null;
                if (args != null) {
                    forOne = (LinkProperties)args[0];
                    overID = (String)args[1];
                }
                if ((sup = MainCommands.this.suw_.getSUPanel()).hasASelection()) {
                    sup.selectNone();
                    sup.repaint();
                }
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                UndoSupport support = forOne == null ? new UndoSupport(undo, "undo.allLinksTopoRepair") : new UndoSupport(undo, "undo.linkTopoRepair");
                Database db = Database.getDB();
                String key = sup.getGenome();
                Genome genome = db.getGenome(key);
                RepairTopologyRunner runner = new RepairTopologyRunner(MainCommands.this.suw_, genome, forOne, overID, support);
                BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
                runner.setClient(bwc);
                bwc.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return true;
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void cleanUpPostRepaint(Object result) {
            Layout.TopoRepairInfo tri = (Layout.TopoRepairInfo)result;
            if (tri.convergenceProblem()) {
                ResourceManager rMan = ResourceManager.getManager();
                String msg = tri.topoFix == 2 ? rMan.getString("linkTopoRepair.partialConvergenceFailWarning") : rMan.getString("linkTopoRepair.convergenceFailWarning");
                JOptionPane.showMessageDialog(MainCommands.this.topWindow_, msg, rMan.getString("linkTopoRepair.convergenceFailWarningTitle"), 2);
            }
        }

        public void handleCancellation() {
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.canLayoutLinks();
        }
    }

    private class SelectNonOrthoLinkSegmentsAction
    extends ChecksForEnabled {
        SelectNonOrthoLinkSegmentsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SelectNonOrthoLinkSegments"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SelectNonOrthoLinkSegments"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SelectNonOrthoLinkSegmentsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                Database db = Database.getDB();
                String key = sup.getGenome();
                Genome genome = db.getGenome(key);
                Layout lo = db.getLayout(new LayoutManager().getLayout(key));
                List nonOrtho = lo.getNonOrthoIntersections(genome, sup.getFontRenderContext(), null);
                sup.selectIntersectionList(nonOrtho);
                MainCommands.this.zoomer_.zoomToSelected();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotNull();
        }
    }

    private class DropLinkSelectionsAction
    extends ChecksForEnabled {
        DropLinkSelectionsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.DropLinkSelections"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.DropLinkSelections"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.DropLinkSelectionsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.suw_.getSUPanel().dropLinkSelections(false);
                MainCommands.this.suw_.getSUPanel().repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotEmpty();
        }
    }

    private class DropNodeSelectionsAction
    extends ChecksForEnabled
    implements OneShot {
        DropNodeSelectionsAction() {
        }

        DropNodeSelectionsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.DropNodeSelections"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.DropNodeSelections"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.DropNodeSelectionsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Object[] args = new Object[1];
                this.performOperation(args);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            MainCommands.this.suw_.getSUPanel().dropNodeSelections((Integer)args[0]);
            MainCommands.this.suw_.getSUPanel().repaint();
            return true;
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotEmpty();
        }
    }

    private class SelectNoneAction
    extends ChecksForEnabled {
        SelectNoneAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SelectNone"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SelectNone"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/ClearSelected24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SelectNoneMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            char accel = rMan.getChar("command.SelectNoneAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.suw_.getSUPanel().selectNone();
                MainCommands.this.suw_.getSUPanel().repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.haveASelection();
        }
    }

    private class SelectAllAction
    extends ChecksForEnabled {
        SelectAllAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SelectAll"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SelectAll"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SelectAllMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            char accel = rMan.getChar("command.SelectAllAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.suw_.getSUPanel().selectAll();
                MainCommands.this.suw_.getSUPanel().repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotEmpty();
        }
    }

    private class PrintAction
    extends ChecksForEnabled {
        PrintAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Print"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Print"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Print24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.PrintMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            char accel = rMan.getChar("command.PrintAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                PrinterJob pj = PrinterJob.getPrinterJob();
                PageFormat pf = pj.defaultPage();
                pf.setOrientation(0);
                pj.setPrintable(MainCommands.this.suw_.getSUPanel(), pf);
                if (pj.printDialog()) {
                    try {
                        pj.print();
                    }
                    catch (PrinterException pex) {
                        System.err.println(pex);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotNull();
        }
    }

    private class AddGenomeInstanceAction
    extends ChecksForEnabled
    implements OneShot {
        AddGenomeInstanceAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("ShortDescription", rMan.getString("command.AddInstance"));
            this.putValue("Name", rMan.getString("command.AddInstance"));
            if (doIcon) {
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/CreateSubmodel24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AddInstanceMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        AddGenomeInstanceAction() {
        }

        public boolean performOperation(Object[] args) {
            Database db = Database.getDB();
            Genome genome = args == null ? db.getGenome(MainCommands.this.suw_.getSUPanel().getGenome()) : (Genome)args[0];
            boolean isPopup = args != null;
            boolean timeBounded = false;
            boolean suggested = false;
            int minTime = -1;
            int maxTime = -1;
            if (genome instanceof GenomeInstance) {
                GenomeInstance gi = (GenomeInstance)genome;
                if (gi.hasTimeBounds()) {
                    timeBounded = true;
                    minTime = gi.getMinTime();
                    maxTime = gi.getMaxTime();
                }
            } else {
                suggested = true;
                TimeCourseData tcd = db.getTimeCourseData();
                if (tcd != null && tcd.haveData()) {
                    timeBounded = true;
                    minTime = tcd.getMinimumTime();
                    maxTime = tcd.getMaximumTime();
                }
            }
            GenomeInstanceCreationDialog gicd = new GenomeInstanceCreationDialog(MainCommands.this.topWindow_, db.getUniqueModelName(), timeBounded, minTime, maxTime, suggested, MainCommands.this.suw_.getUndoManager());
            gicd.setVisible(true);
            if (!gicd.haveResult()) {
                return false;
            }
            UndoSupport support = new UndoSupport(MainCommands.this.suw_.getUndoManager(), "undo.addGenomeInstance");
            NavTree nt = db.getNavTree();
            nt.setSkipFlag(2);
            PopupTree popTree = (PopupTree)MainCommands.this.suw_.getTree();
            popTree.addNewGenomeInstance(gicd.getName(), support, gicd.isTimeBounded(), gicd.getMinTime(), gicd.getMaxTime(), genome, isPopup);
            support.finish();
            nt.setSkipFlag(0);
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.isNotDynamicInstance();
        }
    }

    private class NewModelAction
    extends ChecksForEnabled {
        NewModelAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.NewModel"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.NewModel"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/New24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.NewModelMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            char accel = rMan.getChar("command.NewModelAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                int ok;
                ResourceManager rMan = ResourceManager.getManager();
                if (UndoSupport.hasAChange() && (ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("newModelAction.warningMessage"), rMan.getString("newModelAction.warningMessageTitle"), 0)) != 0) {
                    return;
                }
                MainCommands.this.manageWindowTitle(null);
                MainCommands.this.newModelOperations();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class ImportTemporalInputXml
    extends ChecksForEnabled {
        ImportTemporalInputXml(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ImportTemporalInputXml"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ImportTemporalInputXml"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ImportTemporalInputXmlMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                int ok;
                Database db = Database.getDB();
                TemporalInputRangeData tirdat = db.getTemporalInputRangeData();
                ResourceManager rMan = ResourceManager.getManager();
                if (tirdat != null && tirdat.haveData() && (ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("importTIXml.warningMessage"), rMan.getString("importTIXml.warningMessageTitle"), 0)) != 0) {
                    return;
                }
                if (!MainCommands.this.prepTimeAxisForDataImport()) {
                    return;
                }
                String filename = MainCommands.this.getPreference("ImportDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".xml", "filterName.xml"));
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".btp", "filterName.btp"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showOpenDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null || MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) continue;
                    file = null;
                }
                DatabaseChange dc = null;
                try {
                    UndoSupport support = new UndoSupport(MainCommands.this.suw_.getUndoManager(), "undo.tixml");
                    dc = db.startTemporalInputUndoTransaction();
                    ArrayList<TemporalInputRangeFormatFactory> alist = new ArrayList<TemporalInputRangeFormatFactory>();
                    alist.add(new TemporalInputRangeFormatFactory(true));
                    SUParser sup = new SUParser(alist);
                    sup.parse(file);
                    dc = db.finishTemporalInputUndoTransaction(dc);
                    support.addEdit(new DatabaseChangeCmd(dc));
                    support.addEvent(new GeneralChangeEvent(2));
                    support.finish();
                    MainCommands.this.setPreference("ImportDirectory", file.getAbsoluteFile().getParent());
                }
                catch (IOException ioe) {
                    if (dc != null) {
                        db.rollbackDataUndoTransaction(dc);
                    }
                    MainCommands.this.displayFileInputError(ioe);
                }
                Database.getDB().clearAllDynamicProxyCaches();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class ImportCountsPerEmbryoXml
    extends ChecksForEnabled {
        ImportCountsPerEmbryoXml(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ImportCountsPerEmbryoXml"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ImportCountsPerEmbryoXml"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ImportCountsPerEmbryoXmlMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                int ok;
                Database db = Database.getDB();
                CopiesPerEmbryoData cpedat = db.getCopiesPerEmbryoData();
                ResourceManager rMan = ResourceManager.getManager();
                if (cpedat != null && cpedat.haveData() && (ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("importCPEXml.warningMessage"), rMan.getString("importCPEXml.warningMessageTitle"), 0)) != 0) {
                    return;
                }
                if (!MainCommands.this.prepTimeAxisForDataImport()) {
                    return;
                }
                String filename = MainCommands.this.getPreference("ImportDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".xml", "filterName.xml"));
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".btp", "filterName.btp"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showOpenDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null || MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) continue;
                    file = null;
                }
                DatabaseChange dc = null;
                try {
                    UndoSupport support = new UndoSupport(MainCommands.this.suw_.getUndoManager(), "undo.cpexml");
                    dc = db.startCopiesPerEmbryoUndoTransaction();
                    ArrayList<CopiesPerEmbryoFormatFactory> alist = new ArrayList<CopiesPerEmbryoFormatFactory>();
                    alist.add(new CopiesPerEmbryoFormatFactory(true));
                    SUParser sup = new SUParser(alist);
                    sup.parse(file);
                    dc = db.finishCopiesPerEmbryoUndoTransaction(dc);
                    support.addEdit(new DatabaseChangeCmd(dc));
                    support.addEvent(new GeneralChangeEvent(2));
                    support.finish();
                    MainCommands.this.setPreference("ImportDirectory", file.getAbsoluteFile().getParent());
                }
                catch (IOException ioe) {
                    if (dc != null) {
                        db.rollbackDataUndoTransaction(dc);
                    }
                    MainCommands.this.displayFileInputError(ioe);
                }
                Database.getDB().clearAllDynamicProxyCaches();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class ImportPerturbedExpressionCSV
    extends ChecksForEnabled {
        ImportPerturbedExpressionCSV(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ImportPerturbedExpressionCSV"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ImportPerturbedExpressionCSV"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ImportPerturbedExpressionCSVMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String filename = MainCommands.this.getPreference("ImportDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".csv", "filterName.csv"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showOpenDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null || MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) continue;
                    file = null;
                }
                try {
                    PerturbedTimeCourseGeneCSVFormatFactory csvff = new PerturbedTimeCourseGeneCSVFormatFactory();
                    if (csvff.readPerturbedExpressionCSV(file, MainCommands.this.topWindow_, MainCommands.this.suw_.getUndoManager())) {
                        MainCommands.this.setPreference("ImportDirectory", file.getAbsoluteFile().getParent());
                    }
                }
                catch (InvalidInputException iiex) {
                    MainCommands.this.displayInvalidInputError(iiex);
                }
                catch (IOException ioe) {
                    MainCommands.this.displayFileInputError(ioe);
                }
                catch (OutOfMemoryError oom) {
                    ExceptionHandler.getHandler().displayOutOfMemory(oom);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.haveTimeCourseData() && cache.timeCourseNotEmpty() && cache.hasPerturbationData() && cache.hasPertSources();
        }
    }

    private class ImportTimeCourseXml
    extends ChecksForEnabled {
        ImportTimeCourseXml(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ImportTimeCourseXml"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ImportTimeCourseXml"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ImportTimeCourseXmlMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                int ok;
                Database db = Database.getDB();
                TimeCourseData tcdat = db.getTimeCourseData();
                ResourceManager rMan = ResourceManager.getManager();
                if (tcdat != null && tcdat.haveData() && (ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("importTCXml.warningMessage"), rMan.getString("importTCXml.warningMessageTitle"), 0)) != 0) {
                    return;
                }
                if (!MainCommands.this.prepTimeAxisForDataImport()) {
                    return;
                }
                String filename = MainCommands.this.getPreference("ImportDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".xml", "filterName.xml"));
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".btp", "filterName.btp"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showOpenDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null || MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) continue;
                    file = null;
                }
                DatabaseChange dc = null;
                try {
                    UndoSupport support = new UndoSupport(MainCommands.this.suw_.getUndoManager(), "undo.tcxml");
                    dc = db.startTimeCourseUndoTransaction();
                    ArrayList<TimeCourseFormatFactory> alist = new ArrayList<TimeCourseFormatFactory>();
                    alist.add(new TimeCourseFormatFactory(true, true));
                    SUParser sup = new SUParser(alist);
                    sup.parse(file);
                    dc = db.finishTimeCourseUndoTransaction(dc);
                    support.addEdit(new DatabaseChangeCmd(dc));
                    support.addEvent(new GeneralChangeEvent(2));
                    support.finish();
                    MainCommands.this.setPreference("ImportDirectory", file.getAbsoluteFile().getParent());
                }
                catch (IOException ioe) {
                    if (dc != null) {
                        db.rollbackDataUndoTransaction(dc);
                    }
                    MainCommands.this.displayFileInputError(ioe);
                }
                Database.getDB().clearAllDynamicProxyCaches();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class UserTreePathDeleteStopAction
    extends ChecksForEnabled {
        UserTreePathDeleteStopAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.TreePathDeleteStop"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.TreePathDeleteStop"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/TreePathDeleteStop24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.TreePathDeleteStopMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (MainCommands.this.pathControl_.pathHasOnlyOneStop()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    int ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("treePathDeleteStop.oneStopWarningMessage"), rMan.getString("treePathDeleteStop.oneStopWarningMessageTitle"), 0);
                    if (ok != 0) {
                        return;
                    }
                }
                MainCommands.this.pathControl_.deleteCurrentStop();
                MainCommands.this.handlePathButtons();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }
    }

    private class UserTreePathAddStopAction
    extends ChecksForEnabled {
        UserTreePathAddStopAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.TreePathAddStop"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.TreePathAddStop"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/TreePathAddStop24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.TreePathAddStopMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UserTreePathStopCreationDialog scd = new UserTreePathStopCreationDialog(MainCommands.this.topWindow_, MainCommands.this.pathControl_, MainCommands.this.suw_.getSUPanel());
                scd.show();
                if (!scd.haveResult()) {
                    return;
                }
                String addToPathKey = scd.getChosenPath();
                String insertMode = scd.getInsertionMode();
                MainCommands.this.pathControl_.addAStop(addToPathKey, insertMode);
                MainCommands.this.handlePathButtons();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }
    }

    private class UserTreePathDeleteAction
    extends ChecksForEnabled {
        UserTreePathDeleteAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.TreePathDelete"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.TreePathDelete"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/DeleteTreePath24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.TreePathDeleteMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.pathControl_.deleteCurrentPath();
                MainCommands.this.handlePathButtons();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }
    }

    private class UserTreePathCreateAction
    extends ChecksForEnabled {
        UserTreePathCreateAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.TreePathCreate"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.TreePathCreate"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/NewTreePath24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.TreePathCreateMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ResourceManager rMan = ResourceManager.getManager();
                String newName = (String)JOptionPane.showInputDialog(MainCommands.this.topWindow_, rMan.getString("addPath.ChooseName"), rMan.getString("addPath.ChooseTitle"), 3, null, null, rMan.getString("addPath.defaultName"));
                if (newName == null || newName.trim().equals("")) {
                    return;
                }
                JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("addPath.addsFirstStop"), rMan.getString("addPath.addsFirstStopTitle"), 2);
                MainCommands.this.pathControl_.addAPath(newName);
                MainCommands.this.handlePathButtons();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.haveSubmodelsOrOverlay();
        }
    }

    private class UserTreePathForwardAction
    extends ChecksForEnabled {
        UserTreePathForwardAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.TreePathForward"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.TreePathForward"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Forward24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.TreePathForwardMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.pathControl_.pathForward();
                MainCommands.this.handlePathButtons();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }
    }

    private class UserTreePathBackwardAction
    extends ChecksForEnabled {
        UserTreePathBackwardAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.TreePathBackward"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.TreePathBackward"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Back24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.TreePathBackwardMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.pathControl_.pathBackward();
                MainCommands.this.handlePathButtons();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void checkIfEnabled(CheckGutsCache cache) {
        }
    }

    public class SetCurrentUserPathAction
    extends ChecksForEnabled {
        private String pathName_;
        private String pathKey_;

        public SetCurrentUserPathAction(String pathName, String pathKey) {
            this.pathName_ = pathName;
            this.pathKey_ = pathKey;
            this.putValue("Name", pathName);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.this.pathControl_.setCurrentPath(this.pathKey_);
                MainCommands.this.handlePathButtons();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class DropImageFromModelAction
    extends ChecksForEnabled {
        DropImageFromModelAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.DropImageFromModel"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.DropImageFromModel"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.DropImageFromModelMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoSupport support = new UndoSupport(MainCommands.this.suw_.getUndoManager(), "undo.dropImage");
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                String key = sup.getGenome();
                Database db = Database.getDB();
                Genome genome = db.getGenome(key);
                ImageChange ic = genome.dropGenomeImage();
                if (ic != null) {
                    support.addEdit(new ImageChangeCmd(ic));
                }
                support.addEvent(new ModelChangeEvent(key, 3));
                support.finish();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeHasImage();
        }
    }

    private class AssignImageToModelAction
    extends ChecksForEnabled {
        AssignImageToModelAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.AssignImageToModel"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.AssignImageToModel"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.AssignImageToModelMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String imgKey;
                ImageManager mgr = ImageManager.getMgr();
                ResourceManager rMan = ResourceManager.getManager();
                String filename = MainCommands.this.getPreference("LoadImageDirectory");
                List supported = mgr.getSupportedFileSuffixes();
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.MultiExtensionFilter(supported, "filterName.img"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showOpenDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    if (MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) continue;
                    file = null;
                }
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                String key = sup.getGenome();
                UndoSupport support = new UndoSupport(MainCommands.this.suw_.getUndoManager(), "undo.setImage");
                try {
                    ImageManager.TypedImage ti = mgr.loadImageFromFileStart(file);
                    if (ti.getHeight() < 1 || ti.getWidth() < 1) {
                        JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("assignImage.zeroImageMessage"), rMan.getString("assignImage.errorMessageTitle"), 0);
                        return;
                    }
                    if (ti.getHeight() > 200 || ti.getWidth() > 200) {
                        String format = rMan.getString("assignImage.bigImageMessageFormat");
                        String formMsg = MessageFormat.format(format, new Integer(ti.getWidth()), new Integer(ti.getHeight()), new Integer(200), new Integer(200));
                        formMsg = "<html><center>" + formMsg + "</center></html>";
                        formMsg = formMsg.replaceAll("\n", "<br>");
                        int ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, formMsg, rMan.getString("assignImage.warningMessageTitle"), 0);
                        if (ok != 0) {
                            return;
                        }
                    }
                    ImageManager.NewImageInfo nii = mgr.loadImageFromFileFinish(ti);
                    if (nii.change != null) {
                        nii.change.genomeKey = key;
                        support.addEdit(new ImageChangeCmd(nii.change));
                    }
                    imgKey = nii.key;
                }
                catch (IOException ioex) {
                    MainCommands.this.displayFileInputError(ioex);
                    return;
                }
                MainCommands.this.setPreference("LoadImageDirectory", file.getAbsoluteFile().getParent());
                Database db = Database.getDB();
                Genome genome = db.getGenome(key);
                ImageChange[] ics = genome.setGenomeImage(imgKey);
                if (ics != null) {
                    int numic = ics.length;
                    for (int i = 0; i < numic; ++i) {
                        support.addEdit(new ImageChangeCmd(ics[i]));
                    }
                }
                support.addEvent(new ModelChangeEvent(key, 3));
                support.finish();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotNull();
        }
    }

    private class LoadAction
    extends ChecksForEnabled
    implements OneShot {
        LoadAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Load"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Load"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.LoadMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            char accel = rMan.getChar("command.LoadAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        LoadAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            int ok;
            ResourceManager rMan = ResourceManager.getManager();
            if (args == null && UndoSupport.hasAChange() && (ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("loadAction.warningMessage"), rMan.getString("loadAction.warningMessageTitle"), 0)) != 0) {
                return true;
            }
            File file = null;
            if (args == null) {
                String filename = MainCommands.this.getPreference("LoadDirectory");
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".btp", "filterName.btp"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showOpenDialog(MainCommands.this.topWindow_)) != 0) {
                        return true;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null) {
                        return true;
                    }
                    if (MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) continue;
                    file = null;
                }
                return MainCommands.this.loadFromFile(file);
            }
            if (((Boolean)args[0]).booleanValue()) {
                file = new File((String)args[1]);
                if (!MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) {
                    return false;
                }
                return MainCommands.this.loadFromFile(file);
            }
            return MainCommands.this.loadFromStream((InputStream)args[1]);
        }
    }

    private class ClearRecentAction
    extends ChecksForEnabled {
        ClearRecentAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.clearRecent"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.clearRecent"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.clearRecentMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                RecentFilesManager rfm = RecentFilesManager.getRecentFilesMgr();
                rfm.drop();
                MainCommands.this.recentMenu_.removeAll();
                MainCommands.this.recentMenu_.add(new JSeparator());
                this.setEnabled(false);
                MainCommands.this.recentMenu_.add(this);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class LoadRecentAction
    extends ChecksForEnabled {
        private String filePath_;

        public LoadRecentAction(String fileName, String filePath) {
            this.filePath_ = filePath;
            this.putValue("Name", fileName);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                int ok;
                ResourceManager rMan = ResourceManager.getManager();
                if (UndoSupport.hasAChange() && (ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("loadAction.warningMessage"), rMan.getString("loadAction.warningMessageTitle"), 0)) != 0) {
                    return;
                }
                File file = new File(this.filePath_);
                if (!MainCommands.this.standardFileChecks(file, true, false, false, false, false, true)) {
                    return;
                }
                MainCommands.this.loadFromFile(file);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class SaveAsAction
    extends ChecksForEnabled
    implements OneShot {
        SaveAsAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SaveAs"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SaveAs"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/SaveAs24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SaveAsMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        SaveAsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            if (args == null) {
                return MainCommands.this.saveToFile(null);
            }
            if (((Boolean)args[0]).booleanValue()) {
                String fileName = (String)args[1];
                return MainCommands.this.saveToFile(fileName);
            }
            OutputStream stream = (OutputStream)args[1];
            try {
                MainCommands.this.saveToOutputStream(stream);
            }
            catch (IOException ioe) {
                MainCommands.this.displayFileOutputError();
                return false;
            }
            return true;
        }
    }

    private class SaveAction
    extends ChecksForEnabled {
        SaveAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Save"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Save"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Save24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SaveMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
            char accel = rMan.getChar("command.SaveAccel");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel, 2, false));
        }

        public void actionPerformed(ActionEvent e) {
            block5: {
                try {
                    try {
                        if (MainCommands.this.currentFile_ != null) {
                            Database db = Database.getDB();
                            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(MainCommands.this.currentFile_), "UTF-8")));
                            Indenter ind = new Indenter(out, 2);
                            db.writeXML(out, ind);
                            out.close();
                            UndoSupport.clearTracking();
                            break block5;
                        }
                        MainCommands.this.saveToFile(null);
                    }
                    catch (IOException ioe) {
                        MainCommands.this.displayFileOutputError();
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        }
    }

    private class WebAction
    extends ChecksForEnabled
    implements OneShot,
    BackgroundWorkerOwner {
        private double zoom_;
        private String holdKey_;
        private UndoSupport support_;

        WebAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Web"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Web"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/WebComponent24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.WebMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        WebAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean performOperation(Object[] args) {
            Set publishKeys;
            Map intersectionMap;
            boolean wantHtmlSkeleton;
            NamedOutputStreamSource nos;
            boolean skipRoot = false;
            if (args == null) {
                ResourceManager rMan = ResourceManager.getManager();
                int doRoot = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("webPublish.wantRoot"), rMan.getString("webPublish.wantRootTitle"), 1);
                if (doRoot == 2) {
                    return true;
                }
                skipRoot = doRoot == 1;
                String filename = MainCommands.this.getPreference("WebDirectory");
                File targetDir = null;
                while (targetDir == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.setFileSelectionMode(1);
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setSelectedFile(startDir);
                    }
                    if ((option = chooser.showSaveDialog(MainCommands.this.topWindow_)) != 0) {
                        return true;
                    }
                    targetDir = chooser.getSelectedFile();
                    if (targetDir == null || MainCommands.this.standardFileChecks(targetDir, true, false, false, true, true, false)) continue;
                    targetDir = null;
                }
                MainCommands.this.setPreference("WebDirectory", targetDir.getAbsolutePath());
                nos = new DirectoryNamedOutputStreamSource(targetDir);
                wantHtmlSkeleton = true;
                intersectionMap = null;
                publishKeys = null;
            } else if (((Boolean)args[0]).booleanValue()) {
                File targetDir = new File((String)args[1]);
                if (!MainCommands.this.standardFileChecks(targetDir, true, false, false, true, true, false)) {
                    return false;
                }
                nos = new DirectoryNamedOutputStreamSource(targetDir);
                wantHtmlSkeleton = true;
                intersectionMap = null;
                publishKeys = null;
            } else {
                nos = (NamedOutputStreamSource)args[1];
                wantHtmlSkeleton = false;
                intersectionMap = (Map)args[2];
                publishKeys = (Set)args[3];
            }
            SUPanel sup = MainCommands.this.suw_.getSUPanel();
            this.zoom_ = sup.getZoomFactor();
            this.holdKey_ = sup.getGenome();
            NavTree navTree = Database.getDB().getNavTree();
            List ordered = navTree.getPreorderListing(skipRoot);
            Iterator oit = ordered.iterator();
            this.support_ = null;
            if (oit.hasNext()) {
                String gkey = (String)oit.next();
                String layoutID = MainCommands.this.suw_.getLayoutMgr().getLayout(gkey);
                sup.setGraphLayout(layoutID);
                this.support_ = new UndoSupport(MainCommands.this.suw_.getUndoManager(), "undo.selection");
                sup.setGenome(gkey, this.support_);
                WebRunner runner = new WebRunner(nos, MainCommands.this.suw_, skipRoot, gkey, wantHtmlSkeleton, intersectionMap, publishKeys);
                BackgroundWorkerClient bwc = args == null ? new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "webPublish.waitTitle", "webPublish.wait", this.support_, true) : new BackgroundWorkerClient(this, runner, this.support_);
                runner.setClient(bwc);
                bwc.launchWorker();
            }
            return true;
        }

        public boolean handleRemoteException(Exception remoteEx) {
            if (remoteEx instanceof IOException) {
                MainCommands.this.displayFileOutputError();
                return true;
            }
            return false;
        }

        public void cleanUpPreEnable(Object result) {
            SUPanel sup = MainCommands.this.suw_.getSUPanel();
            String layoutID = MainCommands.this.suw_.getLayoutMgr().getLayout(this.holdKey_);
            sup.setGraphLayout(layoutID);
            sup.setGenomeForUndo(this.holdKey_);
            sup.setZoomFactor(this.zoom_);
        }

        public void handleCancellation() {
            SUPanel sup = MainCommands.this.suw_.getSUPanel();
            String layoutID = MainCommands.this.suw_.getLayoutMgr().getLayout(this.holdKey_);
            sup.setGraphLayout(layoutID);
            sup.setGenomeForUndo(this.holdKey_);
            if (this.support_ != null) {
                this.support_.finish();
            }
            sup.setZoomFactor(this.zoom_);
        }

        public void cleanUpPostRepaint(Object result) {
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.moreThanOneModel();
        }
    }

    private class SBMLWriterAction
    extends ChecksForEnabled {
        SBMLWriterAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.SBMLWrite"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.SBMLWrite"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Export24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.SBMLWriteMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String filename = MainCommands.this.getPreference("SBMLWriterDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".xml", "filterName.xml"));
                    chooser.addChoosableFileFilter(new FileExtensionFilters.DoubleExtensionFilter(".sbm", ".sbml", "filterName.sbm"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showSaveDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    ResourceManager rMan = ResourceManager.getManager();
                    if (!(file.exists() || FileExtensionFilters.hasSuffix(file.getName(), ".xml") || FileExtensionFilters.hasSuffix(file.getName(), ".sbm") || FileExtensionFilters.hasSuffix(file.getName(), ".sbml"))) {
                        file = new File(file.getAbsolutePath() + ".sbm");
                    }
                    if (MainCommands.this.standardFileChecks(file, false, true, true, false, true, false)) continue;
                    file = null;
                }
                try {
                    Database db = Database.getDB();
                    PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
                    Indenter ind = new Indenter(out, 2);
                    SUPanel sup = MainCommands.this.suw_.getSUPanel();
                    String key = sup.getGenome();
                    Genome genome = db.getGenome(key);
                    out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    out.println("<!-- Created by BioTapestry " + new Date() + " -->");
                    ind.indent();
                    out.println("<sbml xmlns=\"http://www.sbml.org/sbml/level1\" level=\"1\" version=\"2\">");
                    ind.up();
                    genome.writeSBML(out, ind);
                    ind.down().indent();
                    out.println("</sbml>");
                    out.close();
                    MainCommands.this.setPreference("SBMLWriterDirectory", file.getAbsoluteFile().getParent());
                }
                catch (IOException ioe) {
                    MainCommands.this.displayFileOutputError();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeCanWriteSBML();
        }
    }

    private class GenomeToSIFAction
    extends ChecksForEnabled {
        GenomeToSIFAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.GenomeToSIF"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.GenomeToSIF"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Export24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.GenomeToSIFMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                PrintWriter out;
                String filename = MainCommands.this.getPreference("GenomeToSIFDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".sif", "filterName.sif"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showSaveDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    ResourceManager rMan = ResourceManager.getManager();
                    if (!file.exists() && !FileExtensionFilters.hasSuffix(file.getName(), ".sif")) {
                        file = new File(file.getAbsolutePath() + ".sif");
                    }
                    if (MainCommands.this.standardFileChecks(file, false, true, true, false, true, false)) continue;
                    file = null;
                }
                try {
                    out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
                }
                catch (IOException ioe) {
                    MainCommands.this.displayFileOutputError();
                    return;
                }
                Database db = Database.getDB();
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                String key = sup.getGenome();
                Genome genome = db.getGenome(key);
                genome.writeSIF(out);
                out.close();
                MainCommands.this.setPreference("QPCRToSIFDirectory", file.getAbsoluteFile().getParent());
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotEmpty();
        }
    }

    private class BuildInstructionsToCSVAction
    extends ChecksForEnabled {
        BuildInstructionsToCSVAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.BuildInstrToCSV"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.BuildInstrToCSV"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.BuildInstrToCSVMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                PrintWriter out;
                String filename = MainCommands.this.getPreference("BuildInstrToCSVDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".csv", "filterName.csv"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showSaveDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    if (!file.exists() && !FileExtensionFilters.hasSuffix(file.getName(), ".csv")) {
                        file = new File(file.getAbsolutePath() + ".csv");
                    }
                    if (MainCommands.this.standardFileChecks(file, false, true, true, false, true, false)) continue;
                    file = null;
                }
                try {
                    out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
                }
                catch (IOException ioe) {
                    MainCommands.this.displayFileOutputError();
                    return;
                }
                new BuildInstructionProcessor().exportInstructions(out);
                out.close();
                MainCommands.this.setPreference("BuildInstrToCSVDirectory", file.getAbsoluteFile().getParent());
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.haveBuildInstructions();
        }
    }

    private class ExpressionToCSVAction
    extends ChecksForEnabled {
        ExpressionToCSVAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ExpressToCSV"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ExpressToCSV"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ExpressToCSVMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                PrintWriter out;
                TimeCourseCSVExportOptionsDialog eod = new TimeCourseCSVExportOptionsDialog(MainCommands.this.topWindow_);
                eod.show();
                if (!eod.haveResult()) {
                    return;
                }
                boolean skipInt = eod.skipInternals();
                boolean ordByReg = eod.orderByRegions();
                boolean embedConf = eod.embedConfidence();
                String filename = MainCommands.this.getPreference("ExpressToCSVDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".csv", "filterName.csv"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showSaveDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    if (!file.exists() && !FileExtensionFilters.hasSuffix(file.getName(), ".csv")) {
                        file = new File(file.getAbsolutePath() + ".csv");
                    }
                    if (MainCommands.this.standardFileChecks(file, false, true, true, false, true, false)) continue;
                    file = null;
                }
                try {
                    out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
                }
                catch (IOException ioe) {
                    MainCommands.this.displayFileOutputError();
                    return;
                }
                Database db = Database.getDB();
                TimeCourseData tcd = db.getTimeCourseData();
                tcd.exportCSV(out, !ordByReg, embedConf, !skipInt);
                out.close();
                MainCommands.this.setPreference("ExpressToCSVDirectory", file.getAbsoluteFile().getParent());
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.haveTimeCourseData();
        }
    }

    private class PerturbToCSVAction
    extends ChecksForEnabled {
        PerturbToCSVAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.PerturbToCSV"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.PerturbToCSV"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/FIXME24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.PerturbToCSVMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                PrintWriter out;
                String filename = MainCommands.this.getPreference("PerturbToCSVDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.SimpleFilter(".csv", "filterName.csv"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showSaveDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    if (!file.exists() && !FileExtensionFilters.hasSuffix(file.getName(), ".csv")) {
                        file = new File(file.getAbsolutePath() + ".csv");
                    }
                    if (MainCommands.this.standardFileChecks(file, false, true, true, false, true, false)) continue;
                    file = null;
                }
                try {
                    out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
                }
                catch (IOException ioe) {
                    MainCommands.this.displayFileOutputError();
                    return;
                }
                Database db = Database.getDB();
                boolean ok = db.getPertData().publishAsCSV(out);
                out.close();
                if (!ok) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("PerturbToCSV.IOError"), rMan.getString("PerturbToCSV.IOErrorTitle"), 0);
                    return;
                }
                MainCommands.this.setPreference("PerturbToCSVDirectory", file.getAbsoluteFile().getParent());
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            PerturbationData pd = Database.getDB().getPertData();
            return pd != null && pd.haveData();
        }
    }

    private class QPCRWriterAction
    extends ChecksForEnabled {
        QPCRWriterAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("ShortDescription", rMan.getString("command.QPCRWrite"));
            this.putValue("Name", rMan.getString("command.QPCRWrite"));
            if (doIcon) {
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Export24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            }
            char mnem = rMan.getChar("command.QPCRWriteMnem");
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String filename = MainCommands.this.getPreference("QPCRWriterDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.DoubleExtensionFilter(".htm", ".html", "filterName.htm"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showSaveDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    if (!(file.exists() || FileExtensionFilters.hasSuffix(file.getName(), ".htm") || FileExtensionFilters.hasSuffix(file.getName(), ".html"))) {
                        file = new File(file.getAbsolutePath() + ".htm");
                    }
                    if (MainCommands.this.standardFileChecks(file, false, true, true, false, true, false)) continue;
                    file = null;
                }
                boolean ok = Database.getDB().getPertData().publish(file);
                if (!ok) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(MainCommands.this.topWindow_, rMan.getString("pertPublish.IOError"), rMan.getString("pertPublish.IOErrorTitle"), 0);
                    return;
                }
                MainCommands.this.setPreference("QPCRWriterDirectory", file.getAbsoluteFile().getParent());
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            PerturbationData pd = Database.getDB().getPertData();
            return pd != null && pd.haveData();
        }
    }

    private class ExportPublishAction
    extends ChecksForEnabled {
        ExportPublishAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.ExportPublish"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.ExportPublish"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Export24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ExportPublishMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SUPanel sup = MainCommands.this.suw_.getSUPanel();
                Dimension dim = sup.getBasicSize(true, true, 1);
                ExportSettingsPublishDialog esd = new ExportSettingsPublishDialog(MainCommands.this.topWindow_, dim.width, dim.height);
                esd.show();
                ExportSettingsDialog.ExportSettings set = esd.getResults();
                if (set == null) {
                    return;
                }
                List supported = ImageExporter.getSupportedFileSuffixes();
                String filename = MainCommands.this.getPreference("ExportDirectory");
                File file = null;
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.MultiExtensionFilter(supported, "filterName.img"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showSaveDialog(MainCommands.this.topWindow_)) != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    if (!file.exists()) {
                        List suffs = ImageExporter.getFileSuffixesForType(set.formatType);
                        if (!FileExtensionFilters.hasASuffix(file.getName(), ".", suffs)) {
                            file = new File(file.getAbsolutePath() + "." + ImageExporter.getPreferredSuffixForType(set.formatType));
                        }
                    }
                    if (MainCommands.this.standardFileChecks(file, false, true, true, false, true, false)) continue;
                    file = null;
                }
                try {
                    sup.exportToFile(file, false, set.formatType, set.res, set.zoomVal, set.size);
                    MainCommands.this.setPreference("ExportDirectory", file.getAbsoluteFile().getParent());
                }
                catch (IOException ioe) {
                    MainCommands.this.displayFileOutputError();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            catch (OutOfMemoryError oom) {
                ExceptionHandler.getHandler().displayOutOfMemory(oom);
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotNull();
        }
    }

    private class ExportAction
    extends ChecksForEnabled
    implements OneShot {
        ExportAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Export"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Export"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Export24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.ExportMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        ExportAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            catch (OutOfMemoryError oom) {
                ExceptionHandler.getHandler().displayOutOfMemory(oom);
            }
        }

        public boolean performOperation(Object[] args) {
            ExportSettingsDialog.ExportSettings set;
            SUPanel sup = MainCommands.this.suw_.getSUPanel();
            Dimension dim = sup.getBasicSize(true, true, 1);
            if (args == null) {
                ExportSettingsDialog esd = new ExportSettingsDialog(MainCommands.this.topWindow_, dim.width, dim.height);
                esd.show();
                set = esd.getResults();
                if (set == null) {
                    return true;
                }
            } else {
                set = (ExportSettingsDialog.ExportSettings)args[0];
            }
            File file = null;
            OutputStream stream = null;
            if (args == null) {
                List supported = ImageExporter.getSupportedFileSuffixes();
                String filename = MainCommands.this.getPreference("ExportDirectory");
                while (file == null) {
                    int option;
                    File startDir;
                    JFileChooser chooser = new JFileChooser();
                    chooser.addChoosableFileFilter(new FileExtensionFilters.MultiExtensionFilter(supported, "filterName.img"));
                    if (filename != null && (startDir = new File(filename)).exists()) {
                        chooser.setCurrentDirectory(startDir);
                    }
                    if ((option = chooser.showSaveDialog(MainCommands.this.topWindow_)) != 0) {
                        return true;
                    }
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    if (!file.exists()) {
                        List suffs = ImageExporter.getFileSuffixesForType(set.formatType);
                        if (!FileExtensionFilters.hasASuffix(file.getName(), ".", suffs)) {
                            file = new File(file.getAbsolutePath() + "." + ImageExporter.getPreferredSuffixForType(set.formatType));
                        }
                    }
                    if (MainCommands.this.standardFileChecks(file, false, true, true, false, true, false)) continue;
                    file = null;
                }
            } else if (((Boolean)args[1]).booleanValue()) {
                file = new File((String)args[2]);
                if (!MainCommands.this.standardFileChecks(file, false, true, true, false, true, false)) {
                    return false;
                }
            } else {
                stream = (OutputStream)args[2];
            }
            try {
                if (file != null) {
                    sup.exportToFile(file, false, set.formatType, set.res, set.zoomVal, set.size);
                } else {
                    sup.exportToStream(stream, false, set.formatType, set.res, set.zoomVal, set.size);
                }
                if (args == null) {
                    MainCommands.this.setPreference("ExportDirectory", file.getAbsoluteFile().getParent());
                }
                return true;
            }
            catch (IOException ioe) {
                MainCommands.this.displayFileOutputError();
                return false;
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return cache.genomeNotNull();
        }
    }

    private class CloseAction
    extends ChecksForEnabled {
        CloseAction(boolean doIcon) {
            ResourceManager rMan = ResourceManager.getManager();
            this.putValue("Name", rMan.getString("command.Close"));
            if (doIcon) {
                this.putValue("ShortDescription", rMan.getString("command.Close"));
                URL ugif = this.getClass().getResource("/org/systemsbiology/biotapestry/images/Stop24.gif");
                this.putValue("SmallIcon", new ImageIcon(ugif));
            } else {
                char mnem = rMan.getChar("command.CloseMnem");
                this.putValue("MnemonicKey", new Integer(mnem));
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ((EditorWindow)MainCommands.this.topWindow_).shutdownEditor(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        protected boolean canPush(int pushCondition) {
            return false;
        }
    }

    private class ZoomResult {
        boolean doCustom;
        int index;
        double customZoom;

        ZoomResult(int index) {
            this.doCustom = false;
            this.index = index;
        }

        ZoomResult(double customZoom) {
            this.doCustom = true;
            this.customZoom = customZoom;
        }
    }

    public abstract class ChecksForEnabled
    extends AbstractAction {
        protected static final int IGNORE = -1;
        protected static final int DISABLED = 0;
        protected static final int ENABLED = 1;
        protected boolean enabled_ = true;
        protected boolean pushed_ = false;

        public void checkIfEnabled(CheckGutsCache cache) {
            this.enabled_ = this.checkGuts(cache);
            if (!this.pushed_) {
                this.setEnabled(this.enabled_);
            }
        }

        public void pushDisabled(int pushCondition) {
            this.pushed_ = this.canPush(pushCondition);
            boolean reversed = this.reversePush(pushCondition);
            if (this.pushed_) {
                this.setEnabled(reversed);
            }
        }

        public void setConditionalEnabled(boolean enabled) {
            this.enabled_ = enabled;
            if (!this.pushed_) {
                this.setEnabled(this.enabled_);
            }
        }

        public boolean isPushed() {
            return this.pushed_;
        }

        public void popDisabled() {
            if (this.pushed_) {
                this.setEnabled(this.enabled_);
                this.pushed_ = false;
            }
        }

        protected boolean checkGuts(CheckGutsCache cache) {
            return true;
        }

        protected boolean canPush(int pushCondition) {
            return true;
        }

        protected boolean reversePush(int pushCondition) {
            return false;
        }
    }

    public static interface ToggleAction {
        public void setToIgnore(boolean var1);

        public void setAsActive(boolean var1);
    }

    public static interface OneShot {
        public boolean performOperation(Object[] var1);
    }

    public static interface OutputClient {
        public String getPrefsTag();

        public String getExtension();

        public String getFilterName();

        public void writeOutput(PrintWriter var1) throws IOException;

        public boolean isBtpOut();
    }

    public class NetworkBuilder
    implements BackgroundWorkerOwner {
        private int importMode_ = 1;
        private String species_;

        public void doNetworkBuild(String species, List instruct) {
            try {
                this.species_ = species;
                if (this.importMode_ == 1) {
                    int ok;
                    ResourceManager rMan = ResourceManager.getManager();
                    if (UndoSupport.hasAChange() && (ok = JOptionPane.showConfirmDialog(MainCommands.this.topWindow_, rMan.getString("loadAction.warningMessage"), rMan.getString("loadAction.warningMessageTitle"), 0)) != 0) {
                        return;
                    }
                }
                Database db = Database.getDB();
                if (this.importMode_ == 1) {
                    MainCommands.this.setCurrentFile(null);
                    ModelChangeEvent mcev = new ModelChangeEvent(db.getGenome().getID(), 2);
                    EventManager.getManager().sendModelChangeEvent(mcev);
                    MainCommands.this.manageWindowTitle("");
                    MainCommands.this.newModelOperations();
                }
                boolean doOpt = false;
                UndoManager undo = MainCommands.this.suw_.getUndoManager();
                UndoSupport support = new UndoSupport(undo, "undo.buildFromGaggleNetwork");
                NewGaggleNetworkRunner runner = new NewGaggleNetworkRunner(instruct, MainCommands.this.suw_, MainCommands.this.topWindow_, this.importMode_, doOpt, support, undo);
                BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, MainCommands.this.topWindow_, MainCommands.this.suw_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
                runner.setClient(bwc);
                bwc.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean handleRemoteException(Exception remoteEx) {
            if (remoteEx instanceof IOException) {
                this.finishedImport(null, (IOException)remoteEx);
                return true;
            }
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void handleCancellation() {
        }

        public void cleanUpPostRepaint(Object result) {
            this.finishedImport((LinkRouter.RoutingResult)result, null);
        }

        private void finishedImport(LinkRouter.RoutingResult result, IOException ioEx) {
            if (result != null) {
                ToolCommands tc = new ToolCommands(MainCommands.this.topWindow_, MainCommands.this.suw_, MainCommands.this.suw_.getUndoManager());
                tc.doStatusAnnouncements(result, MainCommands.this.topWindow_);
            }
            Database db = Database.getDB();
            if (ioEx != null) {
                if (this.importMode_ == 1) {
                    db.drop();
                    MainCommands.this.manageWindowTitle(null);
                    MainCommands.this.newModelOperations();
                }
                MainCommands.this.displayFileInputError(ioEx);
                return;
            }
            if (db.getGenome() == null) {
                db.drop();
                MainCommands.this.manageWindowTitle(null);
                MainCommands.this.newModelOperations();
                MainCommands.this.displayFileInputError(null);
                return;
            }
            GooseAppInterface goose = GooseManager.getManager().getGoose();
            if (goose != null && goose.isActivated()) {
                SelectionSupport ss = goose.getSelectionSupport();
                ss.setSpecies(this.species_);
            }
            if (this.importMode_ == 1) {
                ResourceManager rMan = ResourceManager.getManager();
                MainCommands.this.manageWindowTitle(rMan.getString("gaggleSupport.gaggle") + ": " + this.species_);
                MainCommands.this.postLoadOperations(true);
            }
            String genomeKey = MainCommands.this.suw_.getSUPanel().getGenome();
            MainCommands.this.offerColorFixup(MainCommands.this.suw_.getUndoManager(), result, genomeKey, MainCommands.this.topWindow_);
        }
    }
}

