/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.DeleteCommands;
import org.systemsbiology.biotapestry.cmd.GenomeChangeCmd;
import org.systemsbiology.biotapestry.cmd.GroupChangeCmd;
import org.systemsbiology.biotapestry.cmd.NetOverlayChangeCmd;
import org.systemsbiology.biotapestry.cmd.PropChangeCmd;
import org.systemsbiology.biotapestry.cmd.ProxyChangeCmd;
import org.systemsbiology.biotapestry.cmd.ToolCommands;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.event.LayoutChangeEvent;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupChange;
import org.systemsbiology.biotapestry.genome.GroupMember;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleChange;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.genome.ProxyChange;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LayoutOptionsManager;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.OverlayStateOracle;
import org.systemsbiology.biotapestry.ui.dialogs.ChangeNodeTypeDialog;
import org.systemsbiology.biotapestry.ui.dialogs.ChangeSourceOrTargetNodeReviewDialog;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.BackgroundWorker;
import org.systemsbiology.biotapestry.util.BackgroundWorkerClient;
import org.systemsbiology.biotapestry.util.BackgroundWorkerOwner;
import org.systemsbiology.biotapestry.util.LineBreaker;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class ModificationCommands {
    JFrame topWindow_;
    Gene newGene_;
    Node newNode_;
    Note newNote_;
    Genome targetGenome_;
    Layout targetLayout_;
    UndoManager undom_;
    private static final int AMBIGUOUS_ = 0;
    private static final int UNAMBIGUOUS_SIMPLE_ = 1;
    private static final int UNAMBIGUOUS_REGION_CHANGE_ = 2;
    private static final int UNAMBIGUOUS_COLLAPSE_ = 3;

    public ModificationCommands(JFrame topWindow, UndoManager undo) {
        this.topWindow_ = topWindow;
        this.undom_ = undo;
    }

    public ModificationCommands() {
    }

    public boolean resetModuleMembers(Set nodeIDs, String genomeID, String moduleID, String overlayKey, FontRenderContext frc) {
        NetOverlayProperties noProps;
        NetModuleProperties nmp;
        Database db = Database.getDB();
        Layout glo = db.getLayout(new LayoutManager().getLayout(genomeID));
        Layout.PadNeedsForLayout padFixups = glo.findAllNetModuleLinkPadRequirements(frc);
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeID);
        NetworkOverlay nov = owner.getNetworkOverlay(overlayKey);
        NetModule nmod = nov.getModule(moduleID);
        if (nodeIDs.isEmpty() && (nmp = (noProps = glo.getNetOverlayProperties(overlayKey)).getNetModuleProperties(moduleID)).getType() == 2) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("deleteNodefromMod.lastOne"), rMan.getString("deleteNodefromMod.lastOneTitle"), 0);
            return false;
        }
        HashSet<String> toDelete = new HashSet<String>();
        HashSet<String> currentMem = new HashSet<String>();
        Iterator mit = nmod.getMemberIterator();
        while (mit.hasNext()) {
            NetModuleMember nmm = (NetModuleMember)mit.next();
            String nodeID = nmm.getID();
            if (!nodeIDs.contains(nodeID)) {
                toDelete.add(nodeID);
            }
            currentMem.add(nodeID);
        }
        HashSet toAdd = new HashSet(nodeIDs);
        toAdd.removeAll(currentMem);
        UndoSupport support = new UndoSupport(this.undom_, "undo.modifyNetModuleMembers");
        Iterator tait = toAdd.iterator();
        while (tait.hasNext()) {
            String addID = (String)tait.next();
            NetModuleChange nmc = owner.addMemberToNetworkModule(overlayKey, nmod, addID);
            if (nmc == null) continue;
            NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmc);
            support.addEdit(gcc);
        }
        Iterator tdit = toDelete.iterator();
        while (tdit.hasNext()) {
            String delID = (String)tdit.next();
            NetModuleChange nmc = owner.deleteMemberFromNetworkModule(overlayKey, nmod, delID);
            if (nmc == null) continue;
            NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(nmc);
            support.addEdit(gcc);
        }
        new AddCommands().finishNetModPadFixups(null, null, glo, padFixups, frc, support);
        support.addEvent(new ModelChangeEvent(genomeID, 1));
        support.finish();
        return true;
    }

    public Map getGlobalNetModuleLinkPadNeeds(FontRenderContext frc) {
        HashMap<String, Layout.PadNeedsForLayout> retval = new HashMap<String, Layout.PadNeedsForLayout>();
        Database db = Database.getDB();
        Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        Iterator akit = allKeys.keySet().iterator();
        while (akit.hasNext()) {
            String layoutID = (String)akit.next();
            Layout lo = db.getLayout(layoutID);
            Layout.PadNeedsForLayout padsForLo = lo.findAllNetModuleLinkPadRequirements(frc, allKeys);
            retval.put(layoutID, padsForLo);
        }
        return retval;
    }

    public Layout.PadNeedsForLayout getLocalNetModuleLinkPadNeeds(FontRenderContext frc, String genomeKey) {
        Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        Database db = Database.getDB();
        String loKey = new LayoutManager().getLayout(genomeKey);
        Layout lo = db.getLayout(loKey);
        return lo.findAllNetModuleLinkPadRequirements(frc, allKeys);
    }

    public Map stockUpMemberOnlyModules(FontRenderContext frc) {
        HashMap<String, Map> retval = new HashMap<String, Map>();
        Database db = Database.getDB();
        Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        Iterator akit = allKeys.keySet().iterator();
        while (akit.hasNext()) {
            String layoutID = (String)akit.next();
            Layout lo = db.getLayout(layoutID);
            Map geomForLo = lo.stashMemberOnlyGeometry(frc, allKeys);
            retval.put(layoutID, geomForLo);
        }
        return retval;
    }

    public void repairEmptiedMemberOnlyModules(Map emptyModGeom, UndoSupport support) {
        Database db = Database.getDB();
        Iterator akit = emptyModGeom.keySet().iterator();
        while (akit.hasNext()) {
            String layoutID = (String)akit.next();
            Layout lo = db.getLayout(layoutID);
            Layout.PropChange[] emptyLpc = lo.repairAllEmptyMemberOnlyNetModules(emptyModGeom);
            if (emptyLpc == null || emptyLpc.length == 0) continue;
            PropChangeCmd emptyC = new PropChangeCmd(emptyLpc);
            support.addEdit(emptyC);
        }
    }

    public Layout.OrthoRepairInfo fixAllNonOrtho(Layout lo, Genome genome, FontRenderContext frc, boolean minCorners, String overID, OverlayStateOracle oso, UndoSupport support, BTProgressMonitor monitor, double startFrac, double maxFrac) throws AsynchExitRequestException {
        List nonOrtho = lo.getNonOrthoIntersections(genome, frc, overID);
        Layout.OrthoRepairInfo ori = lo.fixAllNonOrthoForLayout(nonOrtho, genome, frc, minCorners, oso, overID, monitor, startFrac, maxFrac);
        if (ori.chgs != null && ori.chgs.length != 0) {
            PropChangeCmd emptyC = new PropChangeCmd(ori.chgs);
            support.addEdit(emptyC);
        }
        return ori;
    }

    public Layout.OrthoRepairInfo fixAllNonOrthoForTree(LinkProperties lp, Layout lo, Genome genome, FontRenderContext frc, boolean minCorners, String ovrKey, OverlayStateOracle oso, UndoSupport support, BTProgressMonitor monitor, double startFrac, double maxFrac) throws AsynchExitRequestException {
        Layout.OrthoRepairInfo ori = lo.fixAllNonOrthoForTree(lp, genome, frc, minCorners, oso, ovrKey, monitor, startFrac, maxFrac);
        if (ori.chgs != null && ori.chgs.length != 0) {
            PropChangeCmd emptyC = new PropChangeCmd(ori.chgs);
            support.addEdit(emptyC);
        }
        return ori;
    }

    public Layout.OrthoRepairInfo fixNonOrtho(LinkProperties lp, LinkSegmentID lsid, Layout lo, Genome genome, FontRenderContext frc, boolean minCorners, String ovrKey, OverlayStateOracle oso, UndoSupport support, BTProgressMonitor monitor, double startFrac, double maxFrac) throws AsynchExitRequestException {
        Layout.OrthoRepairInfo ori = lo.fixNonOrtho(lp, lsid, genome, frc, minCorners, oso, ovrKey, monitor, startFrac, maxFrac);
        if (ori.chgs != null && ori.chgs.length != 0) {
            PropChangeCmd emptyC = new PropChangeCmd(ori.chgs);
            support.addEdit(emptyC);
        }
        return ori;
    }

    public void repairNetModuleLinkPadsLocally(Layout.PadNeedsForLayout padFixups, FontRenderContext frc, String genomeKey, boolean orphansOnly, UndoSupport support) {
        Map orpho;
        String loKey;
        Database db = Database.getDB();
        Layout lo = db.getLayout(loKey = new LayoutManager().getLayout(genomeKey));
        Layout.PropChange[] padLpc = lo.repairAllNetModuleLinkPadRequirements(frc, padFixups, orpho = lo.orphansOnlyForAll(orphansOnly));
        if (padLpc != null && padLpc.length != 0) {
            PropChangeCmd padC = new PropChangeCmd(padLpc);
            support.addEdit(padC);
        }
    }

    public void repairNetModuleLinkPadsGlobally(Map globalNeeds, FontRenderContext frc, boolean orphansOnly, UndoSupport support) {
        Database db = Database.getDB();
        Iterator akit = globalNeeds.keySet().iterator();
        while (akit.hasNext()) {
            Map orpho;
            Layout.PropChange[] pca;
            String layoutID = (String)akit.next();
            Layout lo = db.getLayout(layoutID);
            Layout.PadNeedsForLayout needsForLayout = (Layout.PadNeedsForLayout)globalNeeds.get(layoutID);
            if (needsForLayout == null || (pca = lo.repairAllNetModuleLinkPadRequirements(frc, needsForLayout, orpho = lo.orphansOnlyForAll(orphansOnly))) == null || pca.length == 0) continue;
            PropChangeCmd pcc = new PropChangeCmd(pca);
            support.addEdit(pcc);
            LayoutChangeEvent lcev = new LayoutChangeEvent(layoutID, 1);
            support.addEvent(lcev);
        }
    }

    public boolean swapLinkPads(Intersection cro, Intersection inter, Intersection.PadVal newPad, String id, Layout layout, Genome genome, int swapMode, String myLinkId) {
        Set allLinks;
        Node swapNode = genome.getNode(id);
        INodeRenderer nodeRenderer = NodeProperties.chooseRenderer(swapNode.getNodeType(), layout.getLayoutType());
        boolean swapNodeShared = nodeRenderer.sharedPadNamespaces();
        Linkage myLink = genome.getLinkage(myLinkId);
        int oldPad = swapMode == 1 ? myLink.getLandingPad() : myLink.getLaunchPad();
        HashSet<String> targLinksToSwapForward = new HashSet<String>();
        HashSet<String> targLinksToSwapBack = new HashSet<String>();
        String aSrcLinkToSwapForward = swapMode == 2 ? myLinkId : null;
        String aSrcLinkToSwapBack = null;
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            String src;
            String trg;
            Linkage link = (Linkage)lit.next();
            if ((swapMode == 1 || swapNodeShared) && (trg = link.getTarget()).equals(id)) {
                int land = link.getLandingPad();
                if (land == oldPad) {
                    targLinksToSwapForward.add(link.getID());
                } else if (land == newPad.padNum) {
                    targLinksToSwapBack.add(link.getID());
                }
            }
            if (swapMode != 2 && !swapNodeShared || aSrcLinkToSwapBack != null || !(src = link.getSource()).equals(id) || link.getLaunchPad() != newPad.padNum) continue;
            aSrcLinkToSwapBack = link.getID();
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.swapLinkPads");
        Iterator tfit = targLinksToSwapForward.iterator();
        while (tfit.hasNext()) {
            String linkID = (String)tfit.next();
            ModificationCommands.changeLinkTargetCore(newPad.padNum, genome, support, linkID);
        }
        Iterator tbit = targLinksToSwapBack.iterator();
        while (tbit.hasNext()) {
            String linkID = (String)tbit.next();
            ModificationCommands.changeLinkTargetCore(oldPad, genome, support, linkID);
        }
        if (aSrcLinkToSwapForward != null) {
            allLinks = layout.getSharedItems(aSrcLinkToSwapForward);
            ModificationCommands.changeLinkSourceCore(newPad.padNum, genome, support, allLinks);
        }
        if (aSrcLinkToSwapBack != null) {
            allLinks = layout.getSharedItems(aSrcLinkToSwapBack);
            ModificationCommands.changeLinkSourceCore(oldPad, genome, support, allLinks);
        }
        support.finish();
        return true;
    }

    public boolean changeLinkTarget(Intersection cro, Intersection inter, List padCand, String id, Layout layout, Genome genome) {
        LinkSegmentID[] linkIDs;
        int numCand = padCand.size();
        Intersection.PadVal winner = null;
        for (int i = 0; i < numCand; ++i) {
            Intersection.PadVal pad = (Intersection.PadVal)padCand.get(i);
            if (!pad.okEnd || !this.targPadIsClear(genome, layout, id, pad.padNum) || winner != null && !(winner.distance > pad.distance)) continue;
            winner = pad;
        }
        if (winner == null) {
            return false;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.changeLinkTarget");
        String lid = cro.getObjectID();
        BusProperties bp = layout.getLinkProperties(lid);
        Set throughSeg = bp.resolveLinkagesThroughSegment((linkIDs = cro.segmentIDsFromIntersect())[0], genome);
        String myLinkId = (String)throughSeg.iterator().next();
        Linkage link = genome.getLinkage(myLinkId);
        if (!link.getTarget().equals(id)) {
            return false;
        }
        ModificationCommands.changeLinkTargetCore(winner.padNum, genome, support, myLinkId);
        support.finish();
        return true;
    }

    public static void changeLinkTargetCore(int padNum, Genome genome, UndoSupport support, String myLinkId) {
        Database db = Database.getDB();
        Linkage link = genome.getLinkage(myLinkId);
        if (genome instanceof GenomeInstance) {
            GenomeInstance rootInstance = (GenomeInstance)genome;
            Iterator giit = db.getInstanceIterator();
            while (giit.hasNext()) {
                Linkage childLink;
                GenomeInstance gi = (GenomeInstance)giit.next();
                if (!rootInstance.isAncestor(gi) || (childLink = gi.getLinkage(myLinkId)) == null) continue;
                GenomeChange undo = gi.changeLinkageTarget(childLink, padNum);
                support.addEdit(new GenomeChangeCmd(undo));
                ModelChangeEvent mcev = new ModelChangeEvent(gi.getID(), 1);
                support.addEvent(mcev);
            }
        } else {
            GenomeChange undo = genome.changeLinkageTarget(link, padNum);
            support.addEdit(new GenomeChangeCmd(undo));
            ModelChangeEvent mcev = new ModelChangeEvent(genome.getID(), 1);
            support.addEvent(mcev);
        }
    }

    public boolean changeLinkSource(Intersection cro, Intersection inter, List padCand, String id, Layout layout, Genome genome) {
        int numCand = padCand.size();
        Intersection.PadVal winner = null;
        for (int i = 0; i < numCand; ++i) {
            Intersection.PadVal pad = (Intersection.PadVal)padCand.get(i);
            if (!pad.okStart || !this.sourcePadIsClear(genome, layout, id, pad.padNum) || winner != null && !(winner.distance > pad.distance)) continue;
            winner = pad;
        }
        if (winner == null) {
            return false;
        }
        String lid = cro.getObjectID();
        Set allLinks = layout.getSharedItems(lid);
        Iterator alit = allLinks.iterator();
        while (alit.hasNext()) {
            String nextLinkID = (String)alit.next();
            Linkage nextLink = genome.getLinkage(nextLinkID);
            if (nextLink.getSource().equals(id)) continue;
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("linkSrcChange.useNodeSwitch"), rMan.getString("linkSrcChange.useNodeSwitchTitle"), 0);
            return false;
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.changeLinkSource");
        ModificationCommands.changeLinkSourceCore(winner.padNum, genome, support, allLinks);
        support.finish();
        return true;
    }

    public static void changeLinkSourceCore(int padNum, Genome genome, UndoSupport support, Set allLinks) {
        Database db = Database.getDB();
        GenomeInstance rootInstance = null;
        if (genome instanceof GenomeInstance) {
            rootInstance = (GenomeInstance)genome;
        }
        Iterator alit = allLinks.iterator();
        while (alit.hasNext()) {
            String nextLinkID = (String)alit.next();
            Linkage nextLink = genome.getLinkage(nextLinkID);
            if (rootInstance != null) {
                Iterator giit = db.getInstanceIterator();
                while (giit.hasNext()) {
                    Linkage childLink;
                    GenomeInstance gi = (GenomeInstance)giit.next();
                    if (!rootInstance.isAncestor(gi) || (childLink = gi.getLinkage(nextLinkID)) == null) continue;
                    GenomeChange undo = gi.changeLinkageSource(childLink, padNum);
                    support.addEdit(new GenomeChangeCmd(undo));
                    ModelChangeEvent mcev = new ModelChangeEvent(gi.getID(), 1);
                    support.addEvent(mcev);
                }
                continue;
            }
            GenomeChange undo = genome.changeLinkageSource(nextLink, padNum);
            support.addEdit(new GenomeChangeCmd(undo));
            ModelChangeEvent mcev = new ModelChangeEvent(genome.getID(), 1);
            support.addEvent(mcev);
        }
    }

    private int linkNodeChangeIsAmbiguous(Set throughSeg, String nodeID, boolean isSource) {
        boolean regionSwitch = false;
        boolean haveCollapse = false;
        Database db = Database.getDB();
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)giit.next();
            boolean hasLink = false;
            HashSet<String> nodeGroups = new HashSet<String>();
            Iterator alit = throughSeg.iterator();
            while (alit.hasNext()) {
                String nextLinkID = (String)alit.next();
                Set instances = gi.returnLinkInstanceIDsForBacking(nextLinkID);
                if (instances.isEmpty()) continue;
                hasLink = true;
                Iterator iit = instances.iterator();
                while (iit.hasNext()) {
                    String iid = (String)iit.next();
                    Linkage linki = gi.getLinkage(iid);
                    String theNode = isSource ? linki.getSource() : linki.getTarget();
                    Group gfn = gi.getGroupForNode(theNode, 1);
                    if (gfn == null) {
                        return 0;
                    }
                    String grpID = gfn.getID();
                    nodeGroups.add(grpID);
                }
            }
            if (!hasLink) continue;
            Set nodeInst = gi.getNodeInstances(nodeID);
            if (nodeInst.size() != 1) {
                return 0;
            }
            if (nodeGroups.size() > 1) {
                haveCollapse = true;
                continue;
            }
            String oldGrpID = (String)nodeGroups.iterator().next();
            String theNode = (String)nodeInst.iterator().next();
            Group gfn = gi.getGroupForNode(theNode, 1);
            if (gfn == null) {
                return 0;
            }
            String newGrpID = gfn.getID();
            if (oldGrpID.equals(newGrpID)) continue;
            regionSwitch = true;
        }
        if (haveCollapse) {
            return 3;
        }
        if (regionSwitch) {
            return 2;
        }
        return 1;
    }

    private QuickKillResult ambiguousLinkNodeChangeIsQuickKill(Set throughSeg, String nodeID, Map quickKillMap, boolean isSource) {
        QuickKillResult retval = new QuickKillResult();
        retval.isQuickKill = true;
        retval.mustDeleteLinks = false;
        Database db = Database.getDB();
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)giit.next();
            String giid = gi.getID();
            HashMap<String, String> mapForModel = new HashMap<String, String>();
            quickKillMap.put(giid, mapForModel);
            HashMap<String, String> groupMap = new HashMap<String, String>();
            Set nodeInst = gi.getNodeInstances(nodeID);
            boolean haveATarget = !nodeInst.isEmpty();
            String lastResort = haveATarget ? (String)nodeInst.iterator().next() : null;
            Iterator niit = nodeInst.iterator();
            while (niit.hasNext()) {
                String theNode = (String)niit.next();
                Group gfn = gi.getGroupForNode(theNode, 1);
                if (gfn == null) {
                    retval.isQuickKill = false;
                    retval.mustDeleteLinks = retval.mustDeleteLinks || !haveATarget;
                    continue;
                }
                String newGrpID = gfn.getID();
                groupMap.put(newGrpID, theNode);
            }
            HashSet nodeGroups = new HashSet();
            Iterator alit = throughSeg.iterator();
            while (alit.hasNext()) {
                String nextLinkID = (String)alit.next();
                Set instances = gi.returnLinkInstanceIDsForBacking(nextLinkID);
                Iterator iit = instances.iterator();
                while (iit.hasNext()) {
                    String iid = (String)iit.next();
                    Linkage linki = gi.getLinkage(iid);
                    String theNode = isSource ? linki.getSource() : linki.getTarget();
                    Group grp = gi.getGroupForNode(theNode, 1);
                    if (grp == null) {
                        retval.isQuickKill = false;
                        boolean bl = retval.mustDeleteLinks = retval.mustDeleteLinks || !haveATarget;
                        if (!haveATarget) continue;
                        mapForModel.put(iid, lastResort);
                        continue;
                    }
                    String grpID = grp.getID();
                    String newNodeID = (String)groupMap.get(grpID);
                    if (newNodeID == null) {
                        retval.isQuickKill = false;
                        boolean bl = retval.mustDeleteLinks = retval.mustDeleteLinks || !haveATarget;
                        if (!haveATarget) continue;
                        mapForModel.put(iid, lastResort);
                        continue;
                    }
                    mapForModel.put(iid, newNodeID);
                }
            }
        }
        return retval;
    }

    public boolean inModuleAttachedToGroup(String nodeID, GenomeInstance gi) {
        Database db = Database.getDB();
        Group currGrp = gi.getGroupForNode(nodeID, 1);
        if (currGrp == null) {
            return false;
        }
        HashSet attached = new HashSet();
        gi.getModulesAttachedToGroup(currGrp.getID(), attached);
        Iterator ait = attached.iterator();
        while (ait.hasNext()) {
            NetModule.FullModuleKey fmk = (NetModule.FullModuleKey)ait.next();
            NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(fmk.ownerKey);
            NetworkOverlay no = noo.getNetworkOverlay(fmk.ovrKey);
            NetModule nmod = no.getModule(fmk.modKey);
            if (!nmod.isAMember(nodeID)) continue;
            return true;
        }
        return false;
    }

    public boolean changeNodeRegion(String nodeID, int x, int y, String targRegionID, Layout layout, GenomeInstance gi, FontRenderContext frc) {
        double dy;
        Database db = Database.getDB();
        GenomeInstance rootInstance = gi.isRootInstance() ? gi : gi.getVfgParentRoot();
        String rootID = rootInstance.getID();
        Map globalPadNeeds = this.getGlobalNetModuleLinkPadNeeds(frc);
        String baseID = GenomeItemInstance.getBaseID(nodeID);
        String groupBase = Group.getBaseID(targRegionID);
        Group targetGroup = rootInstance.getGroup(groupBase);
        if (targetGroup.instanceIsInGroup(baseID)) {
            return false;
        }
        Group currGrp = rootInstance.getGroupForNode(nodeID, 1);
        if (currGrp == null) {
            return false;
        }
        HashSet<String> killSet = new HashSet<String>();
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            String inherit;
            GenomeInstance gik = (GenomeInstance)giit.next();
            if (gik == rootInstance || !rootInstance.isAncestor(gik) || gik.getNode(nodeID) == null || gik.getGroup(inherit = Group.buildInheritedID(groupBase, gik.getGeneration())) != null) continue;
            killSet.add(gik.getID());
        }
        HashSet<String> trimmedKillSet = new HashSet<String>();
        Iterator ksit = killSet.iterator();
        while (ksit.hasNext()) {
            String deadGuy = (String)ksit.next();
            GenomeInstance dgi = (GenomeInstance)db.getGenome(deadGuy);
            if (dgi.isRootInstance()) {
                throw new IllegalStateException();
            }
            boolean haveParent = false;
            Iterator ksit2 = killSet.iterator();
            while (ksit2.hasNext()) {
                GenomeInstance cggi;
                String checkGuy = (String)ksit2.next();
                if (checkGuy.equals(deadGuy) || !(cggi = (GenomeInstance)db.getGenome(checkGuy)).isAncestor(dgi)) continue;
                haveParent = true;
                break;
            }
            if (haveParent) continue;
            trimmedKillSet.add(deadGuy);
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.changeNodeGroup");
        DeleteCommands dc = new DeleteCommands(this.topWindow_, this.undom_);
        Point2D oldLoc = layout.getNodeProperties(nodeID).getLocation();
        double dx = (double)x - oldLoc.getX();
        Layout.PropChange lpc = layout.moveNode(nodeID, rootInstance, dx, dy = (double)y - oldLoc.getY(), null);
        if (lpc != null) {
            PropChangeCmd pcc = new PropChangeCmd(lpc);
            support.addEdit(pcc);
        }
        HashSet attached = new HashSet();
        new FullGenomeHierarchyOracle().getModulesAttachedToGroup(rootInstance, currGrp.getID(), attached);
        Iterator ait = attached.iterator();
        while (ait.hasNext()) {
            NetModule.FullModuleKey fmk = (NetModule.FullModuleKey)ait.next();
            NetOverlayOwner noo = db.getOverlayOwnerWithOwnerKey(fmk.ownerKey);
            NetworkOverlay no = noo.getNetworkOverlay(fmk.ovrKey);
            NetModule nmod = no.getModule(fmk.modKey);
            if (!nmod.isAMember(nodeID)) continue;
            String genomeID = fmk.ownerType == 2 ? db.getDynamicProxy(fmk.ownerKey).getFirstProxiedKey() : fmk.ownerKey;
            dc.supportNodeDeletionFromOverlays(noo, genomeID, support, nodeID, false);
        }
        Iterator git = rootInstance.getGroupIterator();
        while (git.hasNext()) {
            GroupChange grc;
            Group gr = (Group)git.next();
            if (!gr.isInGroup(nodeID, rootInstance) || (grc = gr.removeMember(nodeID, rootID)) == null) continue;
            GroupChangeCmd gcc = new GroupChangeCmd(grc);
            support.addEdit(gcc);
        }
        GroupChange grc = targetGroup.addMember(new GroupMember(nodeID), rootID);
        if (grc != null) {
            GroupChangeCmd gcc = new GroupChangeCmd(grc);
            support.addEdit(gcc);
        }
        HashSet<String> nodes = new HashSet<String>();
        nodes.add(nodeID);
        HashSet links = new HashSet();
        Iterator tksit = trimmedKillSet.iterator();
        while (tksit.hasNext()) {
            String genomeKey = (String)tksit.next();
            dc.deleteNodesAndLinksFromModel(nodes, links, genomeKey, support, 0, false);
        }
        Iterator layit = db.getLayoutIterator();
        while (layit.hasNext()) {
            Layout nl = (Layout)layit.next();
            if (!nl.haveNodeMetadataDependency(gi.getID(), nodeID) || (lpc = nl.dropNodeMetadataDependency(gi.getID(), nodeID)) == null) continue;
            PropChangeCmd pcc = new PropChangeCmd(lpc);
            support.addEdit(pcc);
        }
        Iterator pxit = db.getDynamicProxyIterator();
        while (pxit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)pxit.next();
            if (!dip.instanceIsAncestor(gi) || !dip.hasAddedNode(nodeID)) continue;
            Iterator dgit = dip.getGroupIterator();
            while (dgit.hasNext()) {
                ProxyChange pc;
                Group dgrp = (Group)dgit.next();
                if (!Group.getBaseID(dgrp.getID()).equals(groupBase) || (pc = dip.deleteExtraNode(nodeID)) == null) continue;
                ProxyChangeCmd pcc = new ProxyChangeCmd(pc);
                support.addEdit(pcc);
            }
        }
        if (globalPadNeeds != null) {
            this.repairNetModuleLinkPadsGlobally(globalPadNeeds, frc, false, support);
        }
        support.addEvent(new ModelChangeEvent(rootID, 1));
        support.addEvent(new GeneralChangeEvent(2));
        support.finish();
        return true;
    }

    private Map findMatchingLinkSegsInRootInstances(Set throughSeg, LinkSegmentID breakSegID, DBGenome genome, FontRenderContext frc) {
        HashMap retval = new HashMap();
        if (throughSeg.isEmpty()) {
            return retval;
        }
        Database db = Database.getDB();
        LayoutManager lm = new LayoutManager();
        String rootGid = genome.getID();
        Layout rolo = db.getLayout(lm.getLayout(rootGid));
        String aLinkID = (String)throughSeg.iterator().next();
        BusProperties rootProps = rolo.getLinkProperties(aLinkID);
        Point2D rootSplit = rootProps.getSegmentGeometryForID(breakSegID, genome, rolo, frc, false).pointAtFraction(0.5);
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)giit.next();
            if (gi.getVfgParent() != null) continue;
            String giid = gi.getID();
            Layout lo = db.getLayout(lm.getLayout(giid));
            HashMap<String, Layout.InheritedInsertionInfo> resultsPerSrc = new HashMap<String, Layout.InheritedInsertionInfo>();
            retval.put(giid, resultsPerSrc);
            HashMap<String, HashSet<String>> linksPerSrc = null;
            linksPerSrc = new HashMap<String, HashSet<String>>();
            Iterator tsit = throughSeg.iterator();
            while (tsit.hasNext()) {
                String linkID = (String)tsit.next();
                Set linkSet = gi.returnLinkInstanceIDsForBacking(linkID);
                Iterator lit = linkSet.iterator();
                while (lit.hasNext()) {
                    String clid = (String)lit.next();
                    Linkage childLink = gi.getLinkage(clid);
                    String srcID = childLink.getSource();
                    HashSet<String> links = (HashSet<String>)linksPerSrc.get(srcID);
                    if (links == null) {
                        links = new HashSet<String>();
                        linksPerSrc.put(srcID, links);
                    }
                    links.add(clid);
                }
            }
            Iterator lpskit = linksPerSrc.keySet().iterator();
            while (lpskit.hasNext()) {
                String srcID = (String)lpskit.next();
                HashSet links = (HashSet)linksPerSrc.get(srcID);
                Layout.InheritedInsertionInfo iii = lo.findInheritedMatchingLinkSegment(breakSegID, links, rootProps, rootSplit, rolo, genome, gi, frc);
                if (iii == null) continue;
                resultsPerSrc.put(srcID, iii);
            }
        }
        return retval;
    }

    public boolean changeLinkSourceNode(Set throughSeg, LinkSegmentID breakSegID, Intersection inter, int padNum, LinkSegmentID segID, String sourceID, Layout layout, DBGenome genome, CommonView cView, FontRenderContext frc) {
        int ambiguity = this.linkNodeChangeIsAmbiguous(throughSeg, sourceID, true);
        Map quickKillMap = null;
        ResourceManager rMan = ResourceManager.getManager();
        switch (ambiguity) {
            case 0: {
                int resultMDL;
                quickKillMap = new HashMap();
                QuickKillResult isQuick = this.ambiguousLinkNodeChangeIsQuickKill(throughSeg, sourceID, quickKillMap, true);
                if (isQuick.mustDeleteLinks && (resultMDL = JOptionPane.showConfirmDialog(this.topWindow_, UiUtil.convertMessageToHtml(rMan.getString("srcChange.GottaDeleteMsg")), rMan.getString("srcChange.GottaDeleteTitle"), 0)) == 1) {
                    return false;
                }
                boolean showReview = false;
                if (isQuick.isQuickKill) {
                    int result = JOptionPane.showOptionDialog(this.topWindow_, UiUtil.convertMessageToHtml(rMan.getString("srcChange.doQuickKill")), rMan.getString("srcChange.messageTitle"), -1, 3, null, new Object[]{rMan.getString("srcChange.review"), rMan.getString("srcChange.continue"), rMan.getString("srcChange.cancel")}, rMan.getString("srcChange.continue"));
                    if (result == 0) {
                        showReview = true;
                    } else if (result == 2) {
                        return false;
                    }
                }
                if (isQuick.isQuickKill && !showReview) break;
                ChangeSourceOrTargetNodeReviewDialog csnrd = new ChangeSourceOrTargetNodeReviewDialog(this.topWindow_, sourceID, throughSeg, quickKillMap, true);
                csnrd.show();
                if (!csnrd.haveResult()) {
                    return false;
                }
                quickKillMap = csnrd.getInstanceChoices();
                break;
            }
            case 3: {
                int resultUC = JOptionPane.showConfirmDialog(this.topWindow_, UiUtil.convertMessageToHtml(rMan.getString("srcChange.unambiguousCollapseMsg")), rMan.getString("srcChange.unambiguousCollapseTitle"), 0);
                if (resultUC != 1) break;
                return false;
            }
            case 2: {
                int resultURC = JOptionPane.showConfirmDialog(this.topWindow_, UiUtil.convertMessageToHtml(rMan.getString("srcChange.unambiguousRegionChgMsg")), rMan.getString("srcChange.unambiguousRegionChgTitle"), 0);
                if (resultURC != 1) break;
                return false;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.changeLinkSourceNode");
        PostSourceNodeChanger changer = new PostSourceNodeChanger();
        AddCommands ac = new AddCommands(null, this.undom_);
        changer.manageTheChange(throughSeg, breakSegID, padNum, quickKillMap, ambiguity, segID, sourceID, genome, frc, cView, this.topWindow_, ac, this.undom_, support);
        return true;
    }

    public List changeLinkSourceNodeBackground(Set throughSeg, LinkSegmentID breakSegID, int padNum, Map quickKillMap, int ambiguity, LinkSegmentID segID, String sourceID, UndoSupport support, AddCommands ac, DBGenome genome, FontRenderContext frc, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        LayoutChangeEvent lcev;
        Database db = Database.getDB();
        ArrayList<AddCommands.GlobalLinkRequest> requestList = new ArrayList<AddCommands.GlobalLinkRequest>();
        DeleteCommands dc = new DeleteCommands(null, this.undom_);
        HashSet<String> changedModels = new HashSet<String>();
        LayoutManager lm = new LayoutManager();
        String rootGid = genome.getID();
        Layout rolo = db.getLayout(lm.getLayout(rootGid));
        Map matchingSegs = this.findMatchingLinkSegsInRootInstances(throughSeg, breakSegID, genome, frc);
        Map interSegs = null;
        String segTag = null;
        if (segID != null) {
            if (segID.isTaggedWithEndpoint()) {
                segTag = segID.startEndpointIsTagged() ? "S" : "E";
            }
            BusProperties bp = rolo.getBusForSource(sourceID);
            Set interSegLinks = bp.resolveLinkagesThroughSegment(segID, genome);
            interSegs = this.findMatchingLinkSegsInRootInstances(interSegLinks, segID, genome, frc);
        }
        String oldSource = genome.getLinkage((String)throughSeg.iterator().next()).getSource();
        HashMap oldSrcToLinkMap = new HashMap();
        Iterator alit = throughSeg.iterator();
        while (alit.hasNext()) {
            HashSet changeSet;
            GenomeInstance gi;
            String nextLinkID = (String)alit.next();
            Linkage nextLink = genome.getLinkage(nextLinkID);
            GenomeChange undo = genome.changeLinkageSourceNode(nextLink, sourceID, padNum);
            support.addEdit(new GenomeChangeCmd(undo));
            changedModels.add(genome.getID());
            HashMap<String, HashSet> changeMap = new HashMap<String, HashSet>();
            Iterator giit = db.getInstanceIterator();
            while (giit.hasNext()) {
                gi = (GenomeInstance)giit.next();
                if (gi.getVfgParent() != null) continue;
                Set nodeInst = gi.getNodeInstances(sourceID);
                String giid = gi.getID();
                Map quickKillForModel = quickKillMap == null ? null : (Map)quickKillMap.get(giid);
                Layout gilo = db.getLayout(lm.getLayout(giid));
                changeSet = new HashSet();
                changeMap.put(giid, changeSet);
                HashMap<String, HashSet<String>> o2nl4GI = (HashMap<String, HashSet<String>>)oldSrcToLinkMap.get(giid);
                if (o2nl4GI == null) {
                    o2nl4GI = new HashMap<String, HashSet<String>>();
                    oldSrcToLinkMap.put(giid, o2nl4GI);
                }
                Set linkSet = gi.returnLinkInstanceIDsForBacking(nextLinkID);
                Iterator lit = linkSet.iterator();
                while (lit.hasNext()) {
                    String newNodeID;
                    String clid = (String)lit.next();
                    Linkage childLink = gi.getLinkage(clid);
                    String oldSrc = childLink.getSource();
                    HashSet<String> linksForOld = (HashSet<String>)o2nl4GI.get(oldSrc);
                    if (linksForOld == null) {
                        linksForOld = new HashSet<String>();
                        o2nl4GI.put(oldSrc, linksForOld);
                    }
                    linksForOld.add(clid);
                    switch (ambiguity) {
                        case 0: {
                            newNodeID = (String)quickKillForModel.get(clid);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            if (nodeInst.size() != 1) {
                                throw new IllegalStateException();
                            }
                            newNodeID = (String)nodeInst.iterator().next();
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    if (newNodeID == null) {
                        HashSet<String> killSet = new HashSet<String>();
                        killSet.add(clid);
                        dc.deleteLinkSetFromModel(killSet, giid, support);
                    } else {
                        int currPadNum = this.prepareSourcePad(newNodeID, gi, padNum, gilo, support, ac);
                        undo = gi.changeLinkageSourceNode(childLink, newNodeID, currPadNum);
                        support.addEdit(new GenomeChangeCmd(undo));
                    }
                    changeSet.add(clid);
                    changedModels.add(giid);
                }
            }
            giit = db.getInstanceIterator();
            while (giit.hasNext()) {
                gi = (GenomeInstance)giit.next();
                if (gi.getVfgParent() == null) continue;
                String giid = gi.getID();
                Map quickKillForModel = quickKillMap == null ? null : (Map)quickKillMap.get(giid);
                GenomeInstance rgi = gi.getVfgParentRoot();
                String rgiid = rgi.getID();
                changeSet = (HashSet)changeMap.get(rgiid);
                if (changeSet == null && quickKillForModel == null) continue;
                Iterator csit = changeSet.iterator();
                while (csit.hasNext()) {
                    String clid = (String)csit.next();
                    Linkage rLink = rgi.getLinkage(clid);
                    undo = null;
                    if (rLink == null) {
                        undo = gi.removeLinkage(clid);
                    } else {
                        String srcID = rLink.getSource();
                        if (gi.getNode(srcID) == null || quickKillForModel != null && quickKillForModel.get(clid) == null) {
                            undo = gi.removeLinkage(clid);
                        } else {
                            Linkage cLink = gi.getLinkage(clid);
                            if (cLink != null) {
                                undo = gi.changeLinkageSourceNode(cLink, srcID, rLink.getLaunchPad());
                            }
                        }
                    }
                    if (undo == null) continue;
                    support.addEdit(new GenomeChangeCmd(undo));
                    changedModels.add(giid);
                }
            }
        }
        Iterator cmit = changedModels.iterator();
        while (cmit.hasNext()) {
            String modelID = (String)cmit.next();
            ModelChangeEvent mcev = new ModelChangeEvent(modelID, 1);
            support.addEvent(mcev);
        }
        Layout.PropChange[] pca = rolo.supportLinkSourceBreakoff(breakSegID, throughSeg, sourceID, segID, genome, frc);
        if (pca != null && pca.length != 0) {
            PropChangeCmd pcc = new PropChangeCmd(pca);
            support.addEdit(pcc);
            lcev = new LayoutChangeEvent(rolo.getName(), 1);
            support.addEvent(lcev);
        }
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            HashMap o2nl4GI;
            String loKey;
            Layout lo;
            String giid;
            Set needsLayout;
            GenomeInstance gi = (GenomeInstance)giit.next();
            if (gi.getVfgParent() != null || (needsLayout = this.breakUpInheritedTree(giid = gi.getID(), gi, lo = db.getLayout(loKey = lm.getLayout(giid)), matchingSegs, segTag, interSegs, o2nl4GI = (HashMap)oldSrcToLinkMap.get(giid), support, frc)).isEmpty()) continue;
            AddCommands.GlobalLinkRequest glr = new AddCommands.GlobalLinkRequest();
            glr.genome = gi;
            glr.layout = lo;
            glr.badLinks = needsLayout;
            requestList.add(glr);
        }
        lcev = new LayoutChangeEvent(rolo.getName(), 1);
        support.addEvent(lcev);
        return requestList;
    }

    public boolean changeLinkTargetNode(Linkage link, String targetID, int padNum, DBGenome genome) {
        HashSet<String> linkSet = new HashSet<String>();
        linkSet.add(link.getID());
        int ambiguity = this.linkNodeChangeIsAmbiguous(linkSet, targetID, false);
        Map quickKillMap = null;
        ResourceManager rMan = ResourceManager.getManager();
        switch (ambiguity) {
            case 0: {
                int resultMDL;
                quickKillMap = new HashMap();
                QuickKillResult isQuick = this.ambiguousLinkNodeChangeIsQuickKill(linkSet, targetID, quickKillMap, false);
                if (isQuick.mustDeleteLinks && (resultMDL = JOptionPane.showConfirmDialog(this.topWindow_, UiUtil.convertMessageToHtml(rMan.getString("trgChange.GottaDeleteMsg")), rMan.getString("trgChange.GottaDeleteTitle"), 0)) == 1) {
                    return false;
                }
                boolean showReview = false;
                if (isQuick.isQuickKill) {
                    int result = JOptionPane.showOptionDialog(this.topWindow_, UiUtil.convertMessageToHtml(rMan.getString("srcChange.doQuickKill")), rMan.getString("srcChange.messageTitle"), -1, 3, null, new Object[]{rMan.getString("srcChange.review"), rMan.getString("srcChange.continue"), rMan.getString("srcChange.cancel")}, rMan.getString("srcChange.continue"));
                    if (result == 0) {
                        showReview = true;
                    } else if (result == 2) {
                        return false;
                    }
                }
                if (isQuick.isQuickKill && !showReview) break;
                ChangeSourceOrTargetNodeReviewDialog csnrd = new ChangeSourceOrTargetNodeReviewDialog(this.topWindow_, targetID, linkSet, quickKillMap, false);
                csnrd.show();
                if (!csnrd.haveResult()) {
                    return false;
                }
                quickKillMap = csnrd.getInstanceChoices();
                break;
            }
            case 3: {
                int resultUC = JOptionPane.showConfirmDialog(this.topWindow_, UiUtil.convertMessageToHtml(rMan.getString("srcChange.unambiguousCollapseMsg")), rMan.getString("srcChange.unambiguousCollapseTitle"), 0);
                if (resultUC != 1) break;
                return false;
            }
            case 2: {
                int resultURC = JOptionPane.showConfirmDialog(this.topWindow_, UiUtil.convertMessageToHtml(rMan.getString("srcChange.unambiguousRegionChgMsg")), rMan.getString("srcChange.unambiguousRegionChgTitle"), 0);
                if (resultURC != 1) break;
                return false;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.changeLinkTargetNode");
        this.changeLinkTargetNodeComplete(link, targetID, padNum, quickKillMap, ambiguity, support, genome);
        Database.getDB().clearAllDynamicProxyCaches();
        support.finish();
        return true;
    }

    private void changeLinkTargetNodeComplete(Linkage link, String targetID, int padNum, Map quickKillMap, int ambiguity, UndoSupport support, DBGenome genome) {
        HashSet changeSet;
        GenomeInstance gi;
        Database db = Database.getDB();
        DeleteCommands dc = new DeleteCommands(null, this.undom_);
        AddCommands ac = new AddCommands(null, this.undom_);
        LayoutManager lm = new LayoutManager();
        String rootGid = genome.getID();
        Layout rolo = db.getLayout(lm.getLayout(rootGid));
        String linkID = link.getID();
        HashSet<String> changedModels = new HashSet<String>();
        HashMap totalChangeMap = new HashMap();
        GenomeChange undo = genome.changeLinkageTargetNode(link, targetID, padNum);
        support.addEdit(new GenomeChangeCmd(undo));
        changedModels.add(rootGid);
        HashMap<String, HashSet> changeMap = new HashMap<String, HashSet>();
        Iterator giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            gi = (GenomeInstance)giit.next();
            if (gi.getVfgParent() != null) continue;
            Set nodeInst = gi.getNodeInstances(targetID);
            String giid = gi.getID();
            Map quickKillForModel = quickKillMap == null ? null : (Map)quickKillMap.get(giid);
            Layout gilo = db.getLayout(lm.getLayout(giid));
            changeSet = new HashSet();
            changeMap.put(giid, changeSet);
            HashSet totalChangeSet = (HashSet)totalChangeMap.get(giid);
            if (totalChangeSet == null) {
                totalChangeSet = new HashSet();
                totalChangeMap.put(giid, totalChangeSet);
            }
            Set linkSet = gi.returnLinkInstanceIDsForBacking(linkID);
            Iterator lit = linkSet.iterator();
            while (lit.hasNext()) {
                String newNodeID;
                String clid = (String)lit.next();
                Linkage childLink = gi.getLinkage(clid);
                switch (ambiguity) {
                    case 0: {
                        newNodeID = (String)quickKillForModel.get(clid);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        if (nodeInst.size() != 1) {
                            throw new IllegalStateException();
                        }
                        newNodeID = (String)nodeInst.iterator().next();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (newNodeID == null) {
                    HashSet<String> killSet = new HashSet<String>();
                    killSet.add(clid);
                    dc.deleteLinkSetFromModel(killSet, giid, support);
                } else {
                    int currPadNum = ac.findLandingPad(newNodeID, padNum, gi, gilo);
                    undo = gi.changeLinkageTargetNode(childLink, newNodeID, currPadNum);
                    support.addEdit(new GenomeChangeCmd(undo));
                }
                changeSet.add(clid);
                changedModels.add(giid);
            }
            totalChangeSet.addAll(changeSet);
        }
        giit = db.getInstanceIterator();
        while (giit.hasNext()) {
            gi = (GenomeInstance)giit.next();
            if (gi.getVfgParent() == null) continue;
            String giid = gi.getID();
            Map quickKillForModel = quickKillMap == null ? null : (Map)quickKillMap.get(giid);
            GenomeInstance rgi = gi.getVfgParentRoot();
            String rgiid = rgi.getID();
            changeSet = (HashSet)changeMap.get(rgiid);
            if (changeSet == null && quickKillForModel == null) continue;
            Iterator csit = changeSet.iterator();
            while (csit.hasNext()) {
                String clid = (String)csit.next();
                Linkage rLink = rgi.getLinkage(clid);
                undo = null;
                if (rLink == null) {
                    undo = gi.removeLinkage(clid);
                } else {
                    String trgID = rLink.getTarget();
                    if (gi.getNode(trgID) == null || quickKillForModel != null && quickKillForModel.get(clid) == null) {
                        undo = gi.removeLinkage(clid);
                    } else {
                        Linkage cLink = gi.getLinkage(clid);
                        if (cLink != null) {
                            undo = gi.changeLinkageTargetNode(cLink, trgID, rLink.getLandingPad());
                        }
                    }
                }
                if (undo == null) continue;
                support.addEdit(new GenomeChangeCmd(undo));
                changedModels.add(giid);
            }
        }
        Iterator cmit = changedModels.iterator();
        while (cmit.hasNext()) {
            String modelID = (String)cmit.next();
            ModelChangeEvent mcev = new ModelChangeEvent(modelID, 1);
            support.addEvent(mcev);
        }
    }

    private int prepareSourcePad(String nodeID, GenomeInstance gi, int prefPad, Layout gilo, UndoSupport support, AddCommands ac) {
        Integer srcPad = gi.getSourcePad(nodeID);
        if (srcPad == null && (srcPad = ac.findSourcePad(nodeID, prefPad, gi, gilo)) == null) {
            ac.emergencyPadForce(nodeID, gi, support);
            srcPad = new Integer(prefPad);
        }
        return srcPad;
    }

    private Set breakUpInheritedTree(String giID, GenomeInstance gi, Layout lo, Map matchingSegs, String segTag, Map interSegs, Map oldSrcToLinks, UndoSupport support, FontRenderContext frc) {
        String newSrcID;
        Map segsPerSrc = (Map)matchingSegs.get(giID);
        boolean noBreakSegs = segsPerSrc == null;
        boolean noInterSegs = interSegs == null;
        Map interSegsPerSrc = null;
        if (!noInterSegs) {
            interSegsPerSrc = (Map)interSegs.get(giID);
            noInterSegs = interSegsPerSrc == null;
        }
        HashMap<String, String> newForOld = new HashMap<String, String>();
        HashSet<String> multiSources = new HashSet<String>();
        Iterator osit = oldSrcToLinks.keySet().iterator();
        block0: while (osit.hasNext()) {
            String oldSrcID = (String)osit.next();
            Set linkIDs = (Set)oldSrcToLinks.get(oldSrcID);
            Iterator lidit = linkIDs.iterator();
            while (lidit.hasNext()) {
                String linkID = (String)lidit.next();
                Linkage link = gi.getLinkage(linkID);
                if (link == null) continue;
                String srcID = link.getSource();
                newSrcID = (String)newForOld.get(oldSrcID);
                if (newSrcID == null) {
                    newForOld.put(oldSrcID, srcID);
                    continue;
                }
                if (newSrcID.equals(srcID)) continue;
                multiSources.add(oldSrcID);
                continue block0;
            }
        }
        HashSet<String> redoSet = new HashSet<String>();
        HashMap survivePerSrc = new HashMap();
        osit = oldSrcToLinks.keySet().iterator();
        while (osit.hasNext()) {
            String oldSrcID = (String)osit.next();
            Set linkIDs = (Set)oldSrcToLinks.get(oldSrcID);
            boolean gottaRedo = multiSources.contains(oldSrcID);
            boolean noBreakCandidate = noBreakSegs;
            if (!noBreakSegs) {
                Layout.InheritedInsertionInfo iii = (Layout.InheritedInsertionInfo)segsPerSrc.get(oldSrcID);
                noBreakCandidate = iii == null || iii.segID == null;
            }
            Iterator lidit = linkIDs.iterator();
            while (lidit.hasNext()) {
                HashSet<String> perOldSrcSet;
                String linkID = (String)lidit.next();
                Linkage link = gi.getLinkage(linkID);
                if (link == null) continue;
                if (gottaRedo || noBreakCandidate) {
                    redoSet.add(linkID);
                    continue;
                }
                String newSrcID2 = (String)newForOld.get(oldSrcID);
                HashMap<String, HashSet<String>> perOldSrcMap = (HashMap<String, HashSet<String>>)survivePerSrc.get(newSrcID2);
                if (perOldSrcMap == null) {
                    perOldSrcMap = new HashMap<String, HashSet<String>>();
                    survivePerSrc.put(newSrcID2, perOldSrcMap);
                }
                if ((perOldSrcSet = (HashSet<String>)perOldSrcMap.get(oldSrcID)) == null) {
                    perOldSrcSet = new HashSet<String>();
                    perOldSrcMap.put(oldSrcID, perOldSrcSet);
                }
                perOldSrcSet.add(linkID);
            }
        }
        Map remem = lo.buildRememberProps(gi, frc);
        Iterator rsit = redoSet.iterator();
        while (rsit.hasNext()) {
            String nextLinkID = (String)rsit.next();
            Layout.PropChange pc = lo.removeLinkProperties(nextLinkID);
            support.addEdit(new PropChangeCmd(pc));
        }
        HashMap<String, LinkSegmentID> taggedIntersegs = new HashMap<String, LinkSegmentID>();
        if (!noInterSegs) {
            Iterator spsit = survivePerSrc.keySet().iterator();
            while (spsit.hasNext()) {
                newSrcID = (String)spsit.next();
                Layout.InheritedInsertionInfo iiii = (Layout.InheritedInsertionInfo)interSegsPerSrc.get(newSrcID);
                LinkSegmentID segID = iiii == null || iiii.segID == null ? null : iiii.segID;
                if (segID == null) continue;
                LinkSegmentID tagged = (LinkSegmentID)segID.clone();
                tagged.tagIDWithEndpoint(segTag == null ? "E" : segTag);
                taggedIntersegs.put(newSrcID, tagged);
            }
        }
        Iterator spsit = survivePerSrc.keySet().iterator();
        while (spsit.hasNext()) {
            newSrcID = (String)spsit.next();
            HashMap perOldSrcMap = (HashMap)survivePerSrc.get(newSrcID);
            Iterator oskit = perOldSrcMap.keySet().iterator();
            while (oskit.hasNext()) {
                Layout.PropChange[] pca;
                BusProperties bp;
                String oldSrcID = (String)oskit.next();
                LinkSegmentID breakSegID = ((Layout.InheritedInsertionInfo)segsPerSrc.get((Object)oldSrcID)).segID;
                HashSet perOldSrcLinks = (HashSet)perOldSrcMap.get(oldSrcID);
                LinkSegmentID interSegID = (LinkSegmentID)taggedIntersegs.get(newSrcID);
                if ((interSegID == null || interSegID.isDirect()) && (bp = lo.getBusForSource(newSrcID)) != null) {
                    Layout.PropChange pc;
                    if (bp.isDirect() && (pc = lo.splitDirectLinkInHalf(gi, newSrcID, frc)) != null) {
                        PropChangeCmd pcc = new PropChangeCmd(pc);
                        support.addEdit(pcc);
                    }
                    LinkSegmentID rootDrop = LinkSegmentID.buildIDForStartDrop();
                    rootDrop.tagIDWithEndpoint("S");
                    taggedIntersegs.put(newSrcID, rootDrop);
                    interSegID = rootDrop;
                }
                if ((pca = lo.supportLinkSourceBreakoff(breakSegID, perOldSrcLinks, newSrcID, interSegID, gi, frc)) == null || pca.length == 0) continue;
                PropChangeCmd pcc = new PropChangeCmd(pca);
                support.addEdit(pcc);
            }
        }
        Genome aaclg = Database.getDB().getGenome(giID);
        rsit = redoSet.iterator();
        while (rsit.hasNext()) {
            String nextLinkID = (String)rsit.next();
            AddCommands.autoAddCrudeLinkProperties(aaclg, lo, nextLinkID, support, remem, frc);
        }
        LayoutChangeEvent lcev = new LayoutChangeEvent(lo.getName(), 1);
        support.addEvent(lcev);
        return redoSet;
    }

    public boolean changeNodeType(String id, Genome genome, FontRenderContext frc) {
        Database db = Database.getDB();
        if (db.haveBuildInstructions()) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
        }
        Node changeNode = genome.getNode(id);
        int existingType = changeNode.getNodeType();
        ChangeNodeTypeDialog cntd = new ChangeNodeTypeDialog(this.topWindow_, existingType);
        cntd.setVisible(true);
        Integer newType = cntd.getType();
        if (newType == null) {
            return false;
        }
        Map globalPadNeeds = this.getGlobalNetModuleLinkPadNeeds(frc);
        if (newType == 4) {
            boolean collision = false;
            boolean empty = false;
            if (changeNode instanceof NodeInstance) {
                String local = ((NodeInstance)changeNode).getOverrideName();
                String root = ((NodeInstance)changeNode).getRootName();
                empty = local != null && local.trim().equals("") || root == null || root.trim().equals("");
                collision = !empty && (local != null && db.matchesExistingGeneOrNodeName(local, genome, id) || db.matchesExistingGeneOrNodeName(root, genome, id));
            } else {
                String root = changeNode.getName();
                empty = root == null || root.trim().equals("");
                collision = !empty && db.matchesExistingGeneOrNodeName(root, genome, id);
            }
            ResourceManager rMan = ResourceManager.getManager();
            if (empty) {
                JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("changeType.EmptyName"), rMan.getString("changeType.ErrorTitle"), 0);
                return false;
            }
            if (collision) {
                JOptionPane.showMessageDialog(this.topWindow_, rMan.getString("changeType.BadName"), rMan.getString("changeType.ErrorTitle"), 0);
                return false;
            }
        }
        UndoSupport support = new UndoSupport(this.undom_, "undo.changeNodeType");
        Map limMap = NodeProperties.getFixedPadLimits();
        NodeProperties.PadLimits lim = (NodeProperties.PadLimits)limMap.get(newType);
        DBGenome rootGenome = genome instanceof DBGenome ? (DBGenome)genome : ((GenomeInstance)genome).getGenome();
        HashMap idMap = new HashMap();
        this.changeNodeTypeCore(GenomeItemInstance.getBaseID(id), newType, lim, rootGenome, support, idMap);
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            GenomeInstance gi = (GenomeInstance)git.next();
            this.changeNodeTypeCore(GenomeItemInstance.getBaseID(id), newType, lim, gi, support, idMap);
        }
        Set changed = idMap.keySet();
        Iterator lit = db.getLayoutIterator();
        while (lit.hasNext()) {
            Layout lo = (Layout)lit.next();
            if (!changed.contains(lo.getTarget())) continue;
            Set instSet = (Set)idMap.get(lo.getTarget());
            Iterator isit = instSet.iterator();
            while (isit.hasNext()) {
                String nodeID = (String)isit.next();
                Layout.PropChange lpc = lo.changeNodePropertiesType(nodeID, existingType, newType);
                support.addEdit(new PropChangeCmd(new Layout.PropChange[]{lpc}));
            }
            LayoutChangeEvent lcev = new LayoutChangeEvent(lo.getName(), 1);
            support.addEvent(lcev);
        }
        this.repairNetModuleLinkPadsGlobally(globalPadNeeds, frc, false, support);
        db.clearAllDynamicProxyCaches();
        support.finish();
        return true;
    }

    private boolean changeNodeTypeCore(String backingID, int newType, NodeProperties.PadLimits lim, Genome genome, UndoSupport support, Map idMap) {
        HashSet<String> instances = null;
        if (genome instanceof GenomeInstance) {
            instances = ((GenomeInstance)genome).getNodeInstances(backingID);
            if (instances.size() == 0) {
                return false;
            }
        } else {
            if (genome.getNode(backingID) == null) {
                throw new IllegalStateException();
            }
            instances = new HashSet<String>();
            instances.add(backingID);
        }
        idMap.put(genome.getID(), instances);
        ModelChangeEvent mcev = new ModelChangeEvent(genome.getID(), 1);
        support.addEvent(mcev);
        Iterator iit = instances.iterator();
        while (iit.hasNext()) {
            String id = (String)iit.next();
            GenomeChange gc = genome.changeNodeType(id, newType);
            support.addEdit(new GenomeChangeCmd(gc));
            GenomeChange[] gca = genome.resolvePadChanges(id, lim);
            for (int i = 0; i < gca.length; ++i) {
                support.addEdit(new GenomeChangeCmd(gca[i]));
            }
        }
        return true;
    }

    private boolean sourcePadIsClear(Genome genome, Layout lo, String id, int padNum) {
        NodeProperties np = lo.getNodeProperties(id);
        INodeRenderer rend = np.getRenderer();
        boolean shared = rend.sharedPadNamespaces();
        if (!shared) {
            return true;
        }
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            if (!lnk.getTarget().equals(id) || lnk.getLandingPad() != padNum) continue;
            return false;
        }
        return true;
    }

    private boolean targPadIsClear(Genome genome, Layout lo, String id, int padNum) {
        NodeProperties np = lo.getNodeProperties(id);
        INodeRenderer rend = np.getRenderer();
        boolean shared = rend.sharedPadNamespaces();
        if (!shared) {
            return true;
        }
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            if (!lnk.getSource().equals(id) || lnk.getLaunchPad() != padNum) continue;
            return false;
        }
        return true;
    }

    public void changeNodeNameBreaks(String nodeID, Genome genome, LineBreaker.LineBreakChangeSteps steps, String untrimmed, UndoSupport support) {
        Database db = Database.getDB();
        String baseID = GenomeItemInstance.getBaseID(nodeID);
        String genomeToSkip = genome.getID();
        String nodeToSkip = nodeID;
        HashSet<String> fixedLayouts = new HashSet<String>();
        Iterator loit = db.getLayoutIterator();
        while (loit.hasNext()) {
            Set nodesToFix;
            Layout lo = (Layout)loit.next();
            String loTarg = lo.getTarget();
            Genome gen = db.getGenome(loTarg);
            boolean checkForLocal = false;
            if (gen instanceof GenomeInstance) {
                GenomeInstance gi = (GenomeInstance)gen;
                nodesToFix = gi.getNodeInstances(baseID);
                checkForLocal = true;
            } else {
                nodesToFix = new HashSet<String>();
                nodesToFix.add(baseID);
            }
            if (nodesToFix.isEmpty()) continue;
            Iterator nit = nodesToFix.iterator();
            while (nit.hasNext()) {
                NodeProperties nextProp;
                NodeInstance ni;
                String overName;
                String nextNodeID = (String)nit.next();
                if (loTarg.equals(genomeToSkip) && nextNodeID.equals(nodeToSkip) || checkForLocal && (overName = (ni = (NodeInstance)gen.getNode(nextNodeID)).getOverrideName()) != null || (nextProp = lo.getNodeProperties(nextNodeID)).getLineBreakDef() == null) continue;
                NodeProperties changedProps = (NodeProperties)nextProp.clone();
                changedProps.applyLineBreakMod(steps, untrimmed);
                Layout.PropChange[] lpc = new Layout.PropChange[]{lo.replaceNodeProperties(nextProp, changedProps)};
                if (lpc[0] == null) continue;
                PropChangeCmd pcc = new PropChangeCmd(lpc);
                support.addEdit(pcc);
                fixedLayouts.add(lo.getName());
            }
        }
        Iterator flit = fixedLayouts.iterator();
        while (flit.hasNext()) {
            String loName = (String)flit.next();
            LayoutChangeEvent lcev = new LayoutChangeEvent(loName, 1);
            support.addEvent(lcev);
        }
    }

    private class SourceNodeChangeRunner
    extends BackgroundWorker {
        private Set throughSeg_;
        private LinkSegmentID breakSegID_;
        private int padNum_;
        private Map quickKillMap_;
        private int ambiguity_;
        private LinkSegmentID segID_;
        private String sourceID_;
        private DBGenome genome_;
        private FontRenderContext frc_;
        private JFrame myTopWindow_;
        private AddCommands ac_;
        private UndoManager undo_;
        private UndoSupport support_;
        private List requestList_;

        public SourceNodeChangeRunner(Set throughSeg, LinkSegmentID breakSegID, int padNum, Map quickKillMap, int ambiguity, LinkSegmentID segID, String sourceID, DBGenome genome, FontRenderContext frc, JFrame myTopWindow, AddCommands ac, UndoManager undo, UndoSupport support) {
            super(new LinkRouter.RoutingResult());
            this.throughSeg_ = throughSeg;
            this.breakSegID_ = breakSegID;
            this.padNum_ = padNum;
            this.quickKillMap_ = quickKillMap;
            this.ambiguity_ = ambiguity;
            this.segID_ = segID;
            this.sourceID_ = sourceID;
            this.genome_ = genome;
            this.frc_ = frc;
            this.myTopWindow_ = myTopWindow;
            this.ac_ = ac;
            this.undo_ = undo;
            this.support_ = support;
            this.requestList_ = new ArrayList();
        }

        public Object runCore() throws AsynchExitRequestException {
            this.requestList_ = ModificationCommands.this.changeLinkSourceNodeBackground(this.throughSeg_, this.breakSegID_, this.padNum_, this.quickKillMap_, this.ambiguity_, this.segID_, this.sourceID_, this.support_, this.ac_, this.genome_, this.frc_, this, 0.0, 0.2);
            LayoutOptions lopt = new LayoutOptions(LayoutOptionsManager.getMgr().getLayoutOptions());
            LinkRouter.RoutingResult result = this.ac_.relayoutLinksGlobally(this.requestList_, this.support_, this.frc_, lopt, this, 0.2, 1.0);
            int numReq = this.requestList_.size();
            for (int i = 0; i < numReq; ++i) {
                AddCommands.GlobalLinkRequest glr = (AddCommands.GlobalLinkRequest)this.requestList_.get(i);
                this.support_.addEvent(new LayoutChangeEvent(glr.layout.getName(), 1));
            }
            Database.getDB().clearAllDynamicProxyCaches();
            return result;
        }

        public Object postRunCore() {
            return null;
        }
    }

    private class PostSourceNodeChanger
    implements BackgroundWorkerOwner {
        private CommonView cView_;
        private JFrame myTopWindow_;
        private UndoManager myUndom_;

        private PostSourceNodeChanger() {
        }

        void manageTheChange(Set throughSeg, LinkSegmentID breakSegID, int padNum, Map quickKillMap, int ambiguity, LinkSegmentID segID, String sourceID, DBGenome genome, FontRenderContext frc, CommonView cView, JFrame myTopWindow, AddCommands ac, UndoManager undo, UndoSupport support) {
            this.cView_ = cView;
            this.myTopWindow_ = myTopWindow;
            this.myUndom_ = undo;
            SourceNodeChangeRunner runner = new SourceNodeChangeRunner(throughSeg, breakSegID, padNum, quickKillMap, ambiguity, segID, sourceID, genome, frc, this.myTopWindow_, ac, this.myUndom_, support);
            BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, this.myTopWindow_, this.cView_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
            runner.setClient(bwc);
            bwc.launchWorker();
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void handleCancellation() {
        }

        public void cleanUpPostRepaint(Object result) {
            ToolCommands tc = new ToolCommands(this.myTopWindow_, this.cView_, this.myUndom_);
            tc.doStatusAnnouncements((LinkRouter.RoutingResult)result, this.myTopWindow_);
        }
    }

    private class QuickKillResult {
        boolean isQuickKill;
        boolean mustDeleteLinks;

        private QuickKillResult() {
        }
    }
}

