/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import org.systemsbiology.biotapestry.cmd.BTUndoCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleChange;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.NetworkOverlayChange;

public class NetOverlayChangeCmd
extends BTUndoCmd {
    private NetModuleChange moduleRestore_;
    private NetworkOverlayChange overlayRestore_;

    public NetOverlayChangeCmd(NetModuleChange restore) {
        this.moduleRestore_ = restore;
        this.overlayRestore_ = null;
    }

    public NetOverlayChangeCmd(NetworkOverlayChange restore) {
        this.moduleRestore_ = null;
        this.overlayRestore_ = restore;
    }

    public String getPresentationName() {
        return "Network Overlay Change";
    }

    public void undo() {
        super.undo();
        Database db = Database.getDB();
        if (this.overlayRestore_ != null) {
            NetOverlayOwner noo = this.overlayRestore_.ownerMode == 2 ? db.getDynamicProxy(this.overlayRestore_.noOwnerKey) : db.getGenome(this.overlayRestore_.noOwnerKey);
            NetworkOverlay no = noo.getNetworkOverlay(this.overlayRestore_.overlayKey);
            no.changeUndo(this.overlayRestore_);
        } else {
            NetOverlayOwner noo = this.moduleRestore_.ownerMode == 2 ? db.getDynamicProxy(this.moduleRestore_.noOwnerKey) : db.getGenome(this.moduleRestore_.noOwnerKey);
            NetworkOverlay no = noo.getNetworkOverlay(this.moduleRestore_.overlayKey);
            NetModule nm = no.getModule(this.moduleRestore_.moduleKey);
            nm.changeUndo(this.moduleRestore_);
        }
    }

    public void redo() {
        super.redo();
        Database db = Database.getDB();
        if (this.overlayRestore_ != null) {
            NetOverlayOwner noo = this.overlayRestore_.ownerMode == 2 ? db.getDynamicProxy(this.overlayRestore_.noOwnerKey) : db.getGenome(this.overlayRestore_.noOwnerKey);
            NetworkOverlay no = noo.getNetworkOverlay(this.overlayRestore_.overlayKey);
            no.changeRedo(this.overlayRestore_);
        } else {
            NetOverlayOwner noo = this.moduleRestore_.ownerMode == 2 ? db.getDynamicProxy(this.moduleRestore_.noOwnerKey) : db.getGenome(this.moduleRestore_.noOwnerKey);
            NetworkOverlay no = noo.getNetworkOverlay(this.moduleRestore_.overlayKey);
            NetModule nm = no.getModule(this.moduleRestore_.moduleKey);
            nm.changeRedo(this.moduleRestore_);
        }
    }
}

