/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.app.NavigationChange;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.NavigationChangeCmd;
import org.systemsbiology.biotapestry.cmd.NetOverlayChangeCmd;
import org.systemsbiology.biotapestry.cmd.NetOverlayDisplayChangeCmd;
import org.systemsbiology.biotapestry.cmd.SelectionChangeCmd;
import org.systemsbiology.biotapestry.cmd.UserTreePathController;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.StartupView;
import org.systemsbiology.biotapestry.event.OverlayDisplayChangeEvent;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.NetworkOverlayChange;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.nav.OverlayDisplayChange;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.ui.dialogs.NetOverlayControlPanel;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;
import org.systemsbiology.biotapestry.util.CheckBoxList;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.FixedJComboBox;
import org.systemsbiology.biotapestry.util.ObjChoiceContent;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.TaggedString;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class NetOverlayController {
    public static final int NO_HIDING = 0;
    public static final int LINKS_NOT_SHOWN = 1;
    public static final int OPAQUE_OVERLAY = 2;
    private CommonView suw_;
    private MainCommands mcmd_;
    private JComboBox netOverlaysCombo_;
    private CheckBoxList netModuleChoices_;
    private FixedJButton allButtonA_;
    private FixedJButton allButtonS_;
    private FixedJButton revAllButton_;
    private FixedJButton hideAllButton_;
    private FixedJButton noneButtonA_;
    private FixedJButton noneButtonS_;
    private FixedJButton zoomButtonA_;
    private FixedJButton zoomButtonS_;
    private CardLayout myCard_;
    private JPanel buttonPanel_;
    private JLabel ovrLabel_;
    private JLabel modLabel_;
    private JLabel levelLabel_;
    private JPanel ovrPanel_;
    private boolean ovrEnabled_;
    private boolean downStrEnabled_;
    private boolean pushedAllowLevel_;
    private boolean pushed_;
    private boolean zoomCanShow_;
    private boolean showingRevControls_;
    private boolean activeRevControls_;
    private boolean managingOverlayControls_;
    private NetOverlayControlPanel nocp_;
    private HashMap lastSeenOverlayPerOwner_;
    private HashMap lastSeenModulePerOverlay_;
    private HashMap lastSeenRevealedPerOverlay_;
    private String pendingGenomeID_;
    private String pendingOvrKey_;
    private TaggedSet pendingModKeys_;
    private TaggedSet pendingRevealedKeys_;
    private static final int INITIALIZED_ = 1;

    public NetOverlayController(CommonView suw, MainCommands mcmd) {
        this.suw_ = suw;
        this.mcmd_ = mcmd;
        this.ovrEnabled_ = false;
        this.downStrEnabled_ = false;
        this.pushed_ = false;
        this.zoomCanShow_ = false;
        this.showingRevControls_ = false;
        this.activeRevControls_ = false;
        this.lastSeenOverlayPerOwner_ = new HashMap();
        this.lastSeenModulePerOverlay_ = new HashMap();
        this.lastSeenRevealedPerOverlay_ = new HashMap();
        this.init();
    }

    public void setSliderValue(int slideVal) {
        this.nocp_.setSliderValue(slideVal);
    }

    public boolean aModelHasOverlays() {
        return new FullGenomeHierarchyOracle().overlayExists();
    }

    public boolean maskingIsActive() {
        return this.showingRevControls_ && this.activeRevControls_;
    }

    public void checkForChanges() {
        SUPanel sup = this.suw_.getSUPanel();
        this.syncControlState(true, sup.getCurrentOverlay(), true, new TaggedSet(sup.getCurrentNetModules()), new TaggedSet(sup.getRevealedModules()), null);
    }

    public void checkMaskState(boolean maybeMasking) {
        this.activeRevControls_ = maybeMasking;
        Boolean pushedLevel = this.pushed_ ? new Boolean(this.pushedAllowLevel_) : null;
        this.downstreamSetEnabled(this.downStrEnabled_ && !this.pushed_, pushedLevel);
        this.ovrPanel_.invalidate();
        this.ovrPanel_.validate();
        this.netModuleChoices_.repaint();
    }

    public void resetControllerState() {
        TaggedSet ts = new TaggedSet();
        TaggedSet ts2 = new TaggedSet();
        this.pushDownState(null, ts, ts2);
        this.lastSeenOverlayPerOwner_.clear();
        this.lastSeenModulePerOverlay_.clear();
        this.lastSeenRevealedPerOverlay_.clear();
    }

    public void preloadForNextGenome(String genomeID, String ovrKey, TaggedSet modKeys, TaggedSet revealedKeys) {
        this.pendingGenomeID_ = genomeID;
        this.pendingOvrKey_ = ovrKey;
        this.pendingModKeys_ = (TaggedSet)modKeys.clone();
        this.pendingRevealedKeys_ = (TaggedSet)revealedKeys.clone();
    }

    public boolean hasPreloadForNextGenome(String genomeID) {
        return this.pendingGenomeID_ != null && this.pendingGenomeID_.equals(genomeID);
    }

    public void setForNewGenome(String genomeID, UndoSupport support, OverlayDisplayChange odc) {
        TaggedSet revsForOvr;
        TaggedSet modsForOvr;
        String useOvrKey;
        if (this.hasPreloadForNextGenome(genomeID)) {
            useOvrKey = this.pendingOvrKey_;
            modsForOvr = this.pendingModKeys_;
            revsForOvr = this.pendingRevealedKeys_;
            this.pendingOvrKey_ = null;
            this.pendingModKeys_ = null;
            this.pendingRevealedKeys_ = null;
            this.pendingGenomeID_ = null;
        } else {
            if (this.pendingGenomeID_ != null) {
                this.pendingOvrKey_ = null;
                this.pendingModKeys_ = null;
                this.pendingRevealedKeys_ = null;
                this.pendingGenomeID_ = null;
            }
            StartupView sv = this.getCachedStateForGenome(genomeID);
            useOvrKey = sv.getOverlay();
            modsForOvr = sv.getModules();
            revsForOvr = sv.getRevealedModules();
        }
        OdcAndSccBundle oasb = this.setFullStateGuts(useOvrKey, modsForOvr, revsForOvr, odc);
        if (oasb != null && support != null && oasb.odc != null) {
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(oasb.odc);
            support.addEdit(nodcc);
            if (oasb.bundle != null && oasb.bundle.cmd != null) {
                support.addEdit(oasb.bundle.cmd);
                support.addEvent(oasb.bundle.event);
            }
        }
    }

    public StartupView getCachedStateForGenome(String genomeID) {
        String useOvrKey;
        NetOverlayOwner owner = genomeID == null ? null : Database.getDB().getOverlayOwnerFromGenomeKey(genomeID);
        TaggedString taggedOvr = owner == null ? null : (TaggedString)this.lastSeenOverlayPerOwner_.get(owner.getID());
        TaggedSet modsForOvr = new TaggedSet();
        TaggedSet revsForOvr = new TaggedSet();
        if (owner != null && taggedOvr == null) {
            useOvrKey = owner.getFirstViewPreference(modsForOvr, revsForOvr);
        } else if (genomeID != null && taggedOvr != null && taggedOvr.value != null) {
            useOvrKey = taggedOvr.value;
            modsForOvr = (TaggedSet)this.lastSeenModulePerOverlay_.get(useOvrKey);
            if (modsForOvr == null) {
                modsForOvr = this.getAllModuleChoiceSet(this.getModuleChoices(genomeID, useOvrKey));
            }
            if ((revsForOvr = (TaggedSet)this.lastSeenRevealedPerOverlay_.get(useOvrKey)) == null) {
                revsForOvr = new TaggedSet();
            }
        } else {
            useOvrKey = null;
        }
        return new StartupView(genomeID, useOvrKey, modsForOvr, revsForOvr);
    }

    public void cleanUpDeletedModules(Map lostModules, UndoSupport support) {
        Iterator lmksit = lostModules.keySet().iterator();
        while (lmksit.hasNext()) {
            TaggedSet revs;
            TaggedSet newRevs;
            TaggedSet newMods;
            String ovrKey = (String)lmksit.next();
            boolean changed = false;
            TaggedSet mods = (TaggedSet)this.lastSeenModulePerOverlay_.get(ovrKey);
            TaggedSet taggedSet = newMods = mods == null ? null : (TaggedSet)mods.clone();
            if (mods != null) {
                Set lostModForOvr = (Set)lostModules.get(ovrKey);
                HashSet intersect = new HashSet(lostModForOvr);
                intersect.retainAll(mods.set);
                if (!intersect.isEmpty()) {
                    newMods.set.removeAll(intersect);
                    this.lastSeenModulePerOverlay_.put(ovrKey, newMods);
                    changed = true;
                }
            }
            TaggedSet taggedSet2 = newRevs = (revs = (TaggedSet)this.lastSeenRevealedPerOverlay_.get(ovrKey)) == null ? null : (TaggedSet)revs.clone();
            if (revs != null) {
                Set lostRevsForOvr = (Set)lostModules.get(ovrKey);
                HashSet intersect = new HashSet(lostRevsForOvr);
                intersect.retainAll(revs.set);
                if (!intersect.isEmpty()) {
                    newRevs.set.removeAll(intersect);
                    this.lastSeenRevealedPerOverlay_.put(ovrKey, newRevs);
                    changed = true;
                }
            }
            if (!changed) continue;
            OverlayDisplayChange odc = this.getDisplayChangeForLastSeen(ovrKey, mods, newMods, revs, newRevs);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(odc);
            support.addEdit(nodcc);
        }
        String currOvr = this.getCurrentOverlay();
        Set lostModForOvr = (Set)lostModules.get(currOvr);
        if (lostModForOvr != null) {
            TaggedSet currMods = this.getCurrentModules();
            HashSet intersect = new HashSet(lostModForOvr);
            intersect.retainAll(currMods.set);
            TaggedSet currRevs = this.getCurrentRevealed();
            HashSet intersectRev = new HashSet(lostModForOvr);
            intersectRev.retainAll(currRevs.set);
            if (!intersect.isEmpty()) {
                currMods = (TaggedSet)currMods.clone();
                currMods.set.removeAll(lostModForOvr);
                currRevs = (TaggedSet)currRevs.clone();
                currRevs.set.removeAll(lostModForOvr);
                this.setCurrentModules(currMods, currRevs, support);
            } else if (!intersectRev.isEmpty()) {
                currRevs = (TaggedSet)currRevs.clone();
                currRevs.set.removeAll(lostModForOvr);
                this.setCurrentRevealed(currRevs, support);
            } else {
                this.syncControlState(false, currOvr, true, currMods, currRevs, null);
            }
        }
    }

    private OverlayDisplayChange getDisplayChangeForLastSeen(String ovrKey, TaggedSet oldMods, TaggedSet newMods, TaggedSet oldRevs, TaggedSet newRevs) {
        OverlayDisplayChange retval = new OverlayDisplayChange();
        retval.useForModuleCache = true;
        retval.lastSeenModuleKey = ovrKey;
        retval.oldlastSeenModuleValue = oldMods == null ? null : (TaggedSet)oldMods.clone();
        retval.oldlastSeenRevealedValue = oldRevs == null ? null : (TaggedSet)oldRevs.clone();
        retval.newlastSeenModuleValue = newMods == null ? null : (TaggedSet)newMods.clone();
        retval.newlastSeenRevealedValue = newRevs == null ? null : (TaggedSet)newRevs.clone();
        return retval;
    }

    private void syncPathController(UndoSupport support) {
        UserTreePathController utpc = MainCommands.getCmds().getPathController();
        NavigationChange nc = new NavigationChange();
        nc.commonView = this.suw_;
        if (utpc.syncPathControls(nc)) {
            support.addEdit(new NavigationChangeCmd(nc));
        }
    }

    public void setFullOverlayState(String ovrKey, TaggedSet modKeys, TaggedSet revealedKeys, UndoSupport support) {
        OdcAndSccBundle oasb = this.setFullStateGuts(ovrKey, modKeys, revealedKeys, null);
        if (oasb != null && oasb.odc != null && support != null) {
            this.syncPathController(support);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(oasb.odc);
            support.addEdit(nodcc);
            if (oasb.bundle != null && oasb.bundle.cmd != null) {
                support.addEdit(oasb.bundle.cmd);
                support.addEvent(oasb.bundle.event);
            }
        }
    }

    public void setCurrentOverlay(String ovrKey, UndoSupport support) {
        OdcAndSccBundle oasb = this.setCurrentOverlayGuts(ovrKey);
        if (oasb != null && oasb.odc != null) {
            this.syncPathController(support);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(oasb.odc);
            support.addEdit(nodcc);
            support.addEvent(new OverlayDisplayChangeEvent(1));
            if (oasb.bundle != null && oasb.bundle.cmd != null) {
                support.addEdit(oasb.bundle.cmd);
                support.addEvent(oasb.bundle.event);
            }
        }
    }

    public void clearCurrentOverlay(UndoSupport support) {
        OdcAndSccBundle oasb = this.setCurrentOverlayGuts(null);
        if (oasb != null && oasb.odc != null) {
            this.syncPathController(support);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(oasb.odc);
            support.addEdit(nodcc);
            support.addEvent(new OverlayDisplayChangeEvent(1));
            if (oasb.bundle != null && oasb.bundle.cmd != null) {
                support.addEdit(oasb.bundle.cmd);
                support.addEvent(oasb.bundle.event);
            }
        }
    }

    public String getCurrentOverlay() {
        return this.suw_.getSUPanel().getCurrentOverlay();
    }

    public void addToCurrentModules(String modKey, UndoSupport support) {
        TaggedSet currMods = this.getCurrentModules();
        currMods = (TaggedSet)currMods.clone();
        currMods.set.add(modKey);
        TaggedSet currRev = this.getCurrentRevealed();
        OverlayDisplayChange odc = this.setCurrentModuleGuts(currMods, currRev);
        if (odc != null) {
            this.syncPathController(support);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(odc);
            support.addEdit(nodcc);
            support.addEvent(new OverlayDisplayChangeEvent(1));
        }
    }

    public void dropACurrentModule(String modKey, UndoSupport support) {
        TaggedSet currMods = this.getCurrentModules();
        currMods = (TaggedSet)currMods.clone();
        currMods.set.remove(modKey);
        TaggedSet currRev = this.getCurrentRevealed();
        currRev = (TaggedSet)currRev.clone();
        currRev.set.remove(modKey);
        OverlayDisplayChange odc = this.setCurrentModuleGuts(currMods, currRev);
        if (odc != null) {
            this.syncPathController(support);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(odc);
            support.addEdit(nodcc);
            support.addEvent(new OverlayDisplayChangeEvent(1));
        }
    }

    public void setToSingleCurrentModule(String modKey, UndoSupport support) {
        TaggedSet currMods = new TaggedSet();
        currMods.set.add(modKey);
        TaggedSet currRev = this.getCurrentRevealed();
        OverlayDisplayChange odc = this.setCurrentModuleGuts(currMods, currRev);
        if (odc != null) {
            this.syncPathController(support);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(odc);
            support.addEdit(nodcc);
            support.addEvent(new OverlayDisplayChangeEvent(1));
        }
    }

    public void updateModuleOptions(UndoSupport support) {
        TaggedSet currMods = this.getCurrentModules();
        currMods = (TaggedSet)currMods.clone();
        TaggedSet currRev = this.getCurrentRevealed();
        OverlayDisplayChange odc = this.setCurrentModuleGuts(currMods, currRev = (TaggedSet)currRev.clone());
        if (odc != null) {
            this.syncPathController(support);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(odc);
            support.addEdit(nodcc);
            support.addEvent(new OverlayDisplayChangeEvent(1));
        }
    }

    public TaggedSet getCurrentModules() {
        return this.suw_.getSUPanel().getCurrentNetModules();
    }

    public void toggleModContentDisplay(String modID, UndoSupport support) {
        TaggedSet revealed = this.getCurrentRevealed();
        TaggedSet updated = (TaggedSet)revealed.clone();
        if (revealed.set.contains(modID)) {
            updated.set.remove(modID);
        } else {
            updated.set.add(modID);
        }
        this.setCurrentRevealed(updated, support);
    }

    public void setCurrentRevealed(TaggedSet revealedKeys, UndoSupport support) {
        OverlayDisplayChange odc = this.setCurrentRevealedGuts(revealedKeys);
        if (odc != null) {
            this.syncPathController(support);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(odc);
            support.addEdit(nodcc);
        }
    }

    public TaggedSet getCurrentRevealed() {
        return this.suw_.getSUPanel().getRevealedModules();
    }

    public void pushDisabled(boolean allowLevel) {
        this.pushed_ = true;
        this.pushedAllowLevel_ = allowLevel;
        this.upstreamSetEnabled(false);
        this.downstreamSetEnabled(false, new Boolean(allowLevel));
    }

    public void popDisabled() {
        if (this.pushed_) {
            this.upstreamSetEnabled(this.ovrEnabled_);
            this.downstreamSetEnabled(this.downStrEnabled_, null);
            this.pushed_ = false;
        }
    }

    public CheckBoxList getNetModuleChoices() {
        return this.netModuleChoices_;
    }

    public JPanel getNetOverlayNavigator() {
        if (this.ovrPanel_ != null) {
            return this.ovrPanel_;
        }
        this.ovrPanel_ = new JPanel();
        this.ovrPanel_.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        ResourceManager rMan = ResourceManager.getManager();
        this.ovrLabel_ = new JLabel(rMan.getString("netOverlayController.chooseOverlay"));
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 0, 0, 0, 5, 5, 5, 5, 17, 0.0, 0.0);
        this.ovrPanel_.add((Component)this.ovrLabel_, gbc);
        UiUtil.gbcSet(gbc, 1, 0, 3, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.ovrPanel_.add((Component)this.netOverlaysCombo_, gbc);
        this.modLabel_ = new JLabel(rMan.getString("netOverlayController.chooseModule"));
        UiUtil.gbcSet(gbc, 0, 1, 4, 1, 2, 0, 0, 5, 5, 0, 5, 17, 1.0, 0.0);
        this.ovrPanel_.add((Component)this.modLabel_, gbc);
        UiUtil.gbcSet(gbc, 0, 2, 4, 4, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        JScrollPane jsp = new JScrollPane(this.netModuleChoices_);
        this.ovrPanel_.add((Component)jsp, gbc);
        Box buttonPanelAll = Box.createHorizontalBox();
        buttonPanelAll.add(this.zoomButtonA_);
        buttonPanelAll.add(Box.createHorizontalGlue());
        buttonPanelAll.add(this.allButtonA_);
        buttonPanelAll.add(Box.createHorizontalStrut(3));
        buttonPanelAll.add(this.revAllButton_);
        buttonPanelAll.add(Box.createHorizontalStrut(3));
        buttonPanelAll.add(this.hideAllButton_);
        buttonPanelAll.add(Box.createHorizontalStrut(3));
        buttonPanelAll.add(this.noneButtonA_);
        Box buttonPanelSome = Box.createHorizontalBox();
        buttonPanelSome.add(this.zoomButtonS_);
        buttonPanelSome.add(Box.createHorizontalGlue());
        buttonPanelSome.add(this.allButtonS_);
        buttonPanelSome.add(Box.createHorizontalStrut(3));
        buttonPanelSome.add(this.noneButtonS_);
        this.buttonPanel_ = new JPanel();
        this.myCard_ = new CardLayout();
        this.buttonPanel_.setLayout(this.myCard_);
        this.buttonPanel_.add((Component)buttonPanelAll, "All");
        this.buttonPanel_.add((Component)buttonPanelSome, "Some");
        UiUtil.gbcSet(gbc, 0, 6, 4, 1, 2, 0, 0, 0, 5, 0, 5, 14, 1.0, 0.0);
        this.ovrPanel_.add((Component)this.buttonPanel_, gbc);
        this.levelLabel_ = new JLabel(rMan.getString("netOverlayController.level"));
        UiUtil.gbcSet(gbc, 0, 7, 1, 1, 0, 0, 0, 10, 5, 5, 5, 11, 0.0, 0.0);
        this.ovrPanel_.add((Component)this.levelLabel_, gbc);
        UiUtil.gbcSet(gbc, 1, 7, 3, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        this.ovrPanel_.add((Component)this.nocp_, gbc);
        return this.ovrPanel_;
    }

    public void changeUndo(OverlayDisplayChange undo) {
        if (undo.useForModuleCache) {
            if (undo.oldlastSeenModuleValue == null) {
                this.lastSeenModulePerOverlay_.remove(undo.lastSeenModuleKey);
            } else {
                TaggedSet oldSet = (TaggedSet)undo.oldlastSeenModuleValue.clone();
                this.lastSeenModulePerOverlay_.put(undo.lastSeenModuleKey, oldSet);
            }
            if (undo.oldlastSeenRevealedValue == null) {
                this.lastSeenRevealedPerOverlay_.remove(undo.lastSeenModuleKey);
            } else {
                TaggedSet oldRev = (TaggedSet)undo.oldlastSeenRevealedValue.clone();
                this.lastSeenRevealedPerOverlay_.put(undo.lastSeenModuleKey, oldRev);
            }
            return;
        }
        this.syncControlState(true, undo.oldOvrKey, true, undo.oldModKeys, undo.oldRevealedKeys, undo.oldGenomeID);
        this.pushCore(true, undo.oldOvrKey, true, undo.oldModKeys, undo.oldRevealedKeys, true);
    }

    public void changeRedo(OverlayDisplayChange redo) {
        if (redo.useForModuleCache) {
            if (redo.newlastSeenModuleValue == null) {
                this.lastSeenModulePerOverlay_.remove(redo.lastSeenModuleKey);
            } else {
                TaggedSet newSet = (TaggedSet)redo.newlastSeenModuleValue.clone();
                this.lastSeenModulePerOverlay_.put(redo.lastSeenModuleKey, newSet);
            }
            if (redo.newlastSeenRevealedValue == null) {
                this.lastSeenRevealedPerOverlay_.remove(redo.lastSeenModuleKey);
            } else {
                TaggedSet newRev = (TaggedSet)redo.newlastSeenRevealedValue.clone();
                this.lastSeenRevealedPerOverlay_.put(redo.lastSeenModuleKey, newRev);
            }
            return;
        }
        this.syncControlState(true, redo.newOvrKey, true, redo.newModKeys, redo.newRevealedKeys, redo.newGenomeID);
        this.pushCore(true, redo.newOvrKey, true, redo.newModKeys, redo.newRevealedKeys, true);
    }

    public void setCurrentAsFirst() {
        UndoManager undo = this.suw_.getUndoManager();
        UndoSupport support = new UndoSupport(undo, "undo.setCurrOverlayFirst");
        SUPanel sup = this.suw_.getSUPanel();
        String genomeID = sup.getGenome();
        NetOverlayOwner owner = Database.getDB().getOverlayOwnerFromGenomeKey(genomeID);
        String ownID = owner.getID();
        int ownMode = owner.overlayModeForOwner();
        String ovrKey = sup.getCurrentOverlay();
        TaggedSet currMods = new TaggedSet(sup.getCurrentNetModules());
        TaggedSet currRevs = new TaggedSet(sup.getRevealedModules());
        currRevs = NetOverlayController.normalizedRevealedModules(genomeID, ovrKey, currMods, currRevs);
        Iterator noit = owner.getNetworkOverlayIterator();
        boolean didIt = false;
        while (noit.hasNext()) {
            NetworkOverlay no = (NetworkOverlay)noit.next();
            String noID = no.getID();
            TaggedSet fvs = new TaggedSet();
            TaggedSet fvr = new TaggedSet();
            boolean isFirst = no.getFirstViewState(fvs, fvr);
            NetworkOverlayChange noc = null;
            boolean setIt = false;
            boolean clearIt = false;
            if (isFirst) {
                clearIt = ovrKey == null || !ovrKey.equals(noID);
                setIt = ovrKey != null && ovrKey.equals(noID);
            } else {
                clearIt = false;
                boolean bl = setIt = ovrKey != null && ovrKey.equals(noID);
            }
            if (setIt) {
                noc = no.setAsFirstView(currMods, currRevs, ownID, ownMode);
            } else if (clearIt) {
                noc = no.clearAsFirstView(ownID, ownMode);
            }
            if (noc == null) continue;
            NetOverlayChangeCmd gcc = new NetOverlayChangeCmd(noc);
            support.addEdit(gcc);
            didIt = true;
        }
        if (didIt) {
            support.finish();
        }
    }

    public static TaggedSet normalizedRevealedModules(String genomeID, String ovrKey, TaggedSet currMods, TaggedSet revealed) {
        Database db = Database.getDB();
        Layout lo = db.getLayout(new LayoutManager().getLayout(genomeID));
        NetOverlayProperties nop = lo.getNetOverlayProperties(ovrKey);
        if (nop.getType() != 1) {
            return new TaggedSet();
        }
        TaggedSet retval = (TaggedSet)revealed.clone();
        retval.set.retainAll(currMods.set);
        return retval;
    }

    public static int hasObscuredElements(StartupView sv) {
        int retval = 0;
        Database db = Database.getDB();
        Layout lo = db.getLayout(new LayoutManager().getLayout(sv.getModel()));
        String ovrKey = sv.getOverlay();
        if (ovrKey == null) {
            return retval;
        }
        NetOverlayProperties nop = lo.getNetOverlayProperties(ovrKey);
        if (nop.getType() == 1) {
            retval |= 2;
        }
        if (nop.hideLinks()) {
            retval |= 1;
        }
        return retval;
    }

    OdcAndSccBundle setFullStateGuts(String ovrKey, TaggedSet modKeys, TaggedSet revealedKeys, OverlayDisplayChange odc) {
        SUPanel sup = this.suw_.getSUPanel();
        if (odc == null) {
            odc = new OverlayDisplayChange();
            odc.oldGenomeID = sup.getGenome();
            odc.oldOvrKey = sup.getCurrentOverlay();
            odc.oldModKeys = new TaggedSet(sup.getCurrentNetModules());
            odc.oldRevealedKeys = new TaggedSet(sup.getRevealedModules());
        }
        odc.newGenomeID = sup.getGenome();
        odc.newOvrKey = ovrKey;
        odc.newModKeys = new TaggedSet(modKeys);
        odc.newRevealedKeys = new TaggedSet(revealedKeys);
        OdcAndSccBundle retval = new OdcAndSccBundle();
        retval.odc = odc;
        this.syncControlState(true, ovrKey, true, modKeys, revealedKeys, null);
        retval.bundle = this.pushCore(true, ovrKey, true, modKeys, revealedKeys, false);
        return retval;
    }

    OdcAndSccBundle setCurrentOverlayGuts(String ovrKey) {
        OdcAndSccBundle retval = new OdcAndSccBundle();
        retval.odc = new OverlayDisplayChange();
        SUPanel sup = this.suw_.getSUPanel();
        String genomeID = sup.getGenome();
        String currOvrKey = sup.getCurrentOverlay();
        if (currOvrKey == null ? ovrKey == null : currOvrKey.equals(ovrKey)) {
            return null;
        }
        TaggedSet modsForOvr = null;
        TaggedSet revsForOvr = null;
        if (genomeID != null && ovrKey != null) {
            modsForOvr = (TaggedSet)this.lastSeenModulePerOverlay_.get(ovrKey);
            revsForOvr = (TaggedSet)this.lastSeenRevealedPerOverlay_.get(ovrKey);
        }
        if (modsForOvr == null) {
            modsForOvr = this.getAllModuleChoiceSet(this.getModuleChoices(genomeID, ovrKey));
        }
        if (revsForOvr == null) {
            revsForOvr = new TaggedSet();
        }
        TaggedSet currModKeys = sup.getCurrentNetModules();
        TaggedSet currRevKeys = sup.getRevealedModules();
        retval.odc.oldGenomeID = genomeID;
        retval.odc.newGenomeID = genomeID;
        retval.odc.oldOvrKey = currOvrKey;
        retval.odc.newOvrKey = ovrKey;
        retval.odc.oldModKeys = new TaggedSet(currModKeys);
        retval.odc.newModKeys = new TaggedSet(modsForOvr);
        retval.odc.oldRevealedKeys = new TaggedSet(currRevKeys);
        retval.odc.newRevealedKeys = new TaggedSet(revsForOvr);
        this.syncControlState(true, ovrKey, true, modsForOvr, revsForOvr, null);
        retval.bundle = this.pushCore(true, ovrKey, true, modsForOvr, revsForOvr, false);
        return retval;
    }

    OverlayDisplayChange setCurrentModuleGuts(TaggedSet modKeys, TaggedSet revKeys) {
        OverlayDisplayChange retval = new OverlayDisplayChange();
        SUPanel sup = this.suw_.getSUPanel();
        TaggedSet currModKeys = sup.getCurrentNetModules();
        TaggedSet currRevKeys = sup.getRevealedModules();
        String currOvrKey = sup.getCurrentOverlay();
        retval.newGenomeID = retval.oldGenomeID = sup.getGenome();
        retval.oldOvrKey = currOvrKey;
        retval.newOvrKey = currOvrKey;
        retval.oldModKeys = new TaggedSet(currModKeys);
        retval.newModKeys = new TaggedSet(modKeys);
        retval.oldRevealedKeys = new TaggedSet(currRevKeys);
        retval.newRevealedKeys = new TaggedSet(revKeys);
        TaggedSet revealedKeys = new TaggedSet(revKeys);
        this.syncControlState(false, currOvrKey, true, modKeys, revealedKeys, null);
        this.pushCore(false, currOvrKey, true, modKeys, revealedKeys, false);
        return retval;
    }

    OverlayDisplayChange setCurrentRevealedGuts(TaggedSet revealed) {
        OverlayDisplayChange retval = new OverlayDisplayChange();
        SUPanel sup = this.suw_.getSUPanel();
        TaggedSet currModKeys = sup.getCurrentNetModules();
        TaggedSet currRevKeys = sup.getRevealedModules();
        if (currRevKeys.set.equals(revealed.set) && currRevKeys.tag == revealed.tag) {
            return null;
        }
        String currOvrKey = sup.getCurrentOverlay();
        retval.newGenomeID = retval.oldGenomeID = sup.getGenome();
        retval.oldOvrKey = currOvrKey;
        retval.newOvrKey = currOvrKey;
        retval.oldModKeys = new TaggedSet(currModKeys);
        retval.newModKeys = new TaggedSet(currModKeys);
        retval.oldRevealedKeys = new TaggedSet(currRevKeys);
        retval.newRevealedKeys = new TaggedSet(revealed);
        this.syncControlState(false, currOvrKey, true, currModKeys, revealed, null);
        this.pushCore(false, currOvrKey, true, currModKeys, revealed, false);
        return retval;
    }

    private void setCurrentModules(TaggedSet modKeys, TaggedSet revKeys, UndoSupport support) {
        OverlayDisplayChange odc = this.setCurrentModuleGuts(modKeys, revKeys);
        if (odc != null) {
            this.syncPathController(support);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(odc);
            support.addEdit(nodcc);
        }
    }

    private void upstreamSetEnabled(boolean enabled) {
        if (this.netOverlaysCombo_ != null) {
            this.netOverlaysCombo_.setEnabled(enabled);
        }
        if (this.ovrLabel_ != null) {
            this.ovrLabel_.setEnabled(enabled);
        }
    }

    private void downstreamSetEnabled(boolean enabled, Boolean allowLevelSetting) {
        this.activeRevControls_ = this.nocp_.getMaskingState();
        if (this.netModuleChoices_ != null) {
            this.netModuleChoices_.setEnabled(enabled);
            this.netModuleChoices_.showAndEnableSubSelection(this.showingRevControls_, this.activeRevControls_ ? enabled : false);
        }
        if (this.modLabel_ != null) {
            this.modLabel_.setEnabled(enabled);
        }
        if (this.allButtonA_ != null) {
            this.allButtonA_.setEnabled(enabled);
            this.allButtonS_.setEnabled(enabled);
        }
        if (this.noneButtonA_ != null) {
            this.noneButtonA_.setEnabled(enabled);
            this.noneButtonS_.setEnabled(enabled);
        }
        if (this.hideAllButton_ != null) {
            this.hideAllButton_.setEnabled(this.activeRevControls_ ? enabled : false);
        }
        if (this.revAllButton_ != null) {
            this.revAllButton_.setEnabled(this.activeRevControls_ ? enabled : false);
        }
        if (this.zoomButtonA_ != null) {
            this.zoomButtonA_.setEnabled(this.zoomCanShow_ ? enabled : false);
            this.zoomButtonS_.setEnabled(this.zoomCanShow_ ? enabled : false);
        }
        boolean levelEnabled = enabled;
        if (!enabled && allowLevelSetting != null && allowLevelSetting.booleanValue()) {
            levelEnabled = true;
        }
        if (this.nocp_ != null) {
            this.nocp_.setEnabled(levelEnabled);
        }
        if (this.levelLabel_ != null) {
            this.levelLabel_.setEnabled(levelEnabled);
        }
    }

    private SelectionChangeCmd.Bundle pushDownState(String ovrKey, TaggedSet modKeys, TaggedSet revealedKeys) {
        this.syncControlState(true, ovrKey, true, modKeys, revealedKeys, null);
        SelectionChangeCmd.Bundle bundle = this.pushCore(true, ovrKey, true, modKeys, revealedKeys, false);
        return bundle;
    }

    private SelectionChangeCmd.Bundle pushCore(boolean doOvr, String ovrKey, boolean doModAndRev, TaggedSet modKeys, TaggedSet revealed, boolean forUndo) {
        SUPanel sup = this.suw_.getSUPanel();
        SelectionChangeCmd.Bundle bundle = null;
        if (doOvr) {
            bundle = sup.setCurrentOverlay(ovrKey, this.nocp_.getSettings(), forUndo);
        }
        if (doModAndRev) {
            sup.setCurrentNetModules(modKeys, forUndo);
            sup.setRevealedModules(revealed, forUndo);
        }
        sup.repaint();
        return bundle;
    }

    private void syncControlState(boolean doOvr, String ovrKey, boolean doModAndRev, TaggedSet modKeys, TaggedSet revealedKeys, String undoGenomeID) {
        NetOverlayOwner owner;
        String genomeID;
        String string = genomeID = undoGenomeID == null ? this.suw_.getSUPanel().getGenome() : undoGenomeID;
        if (doOvr) {
            this.updateNetOverlayOptions(genomeID);
        }
        if (doModAndRev) {
            this.updateNetModuleOptions(genomeID, ovrKey, modKeys);
        }
        if (doOvr) {
            this.selectCurrentOverlayInUI(ovrKey);
        }
        if (doModAndRev) {
            this.selectCurrentNetModulesInUI(modKeys, revealedKeys);
        }
        NetOverlayOwner netOverlayOwner = owner = genomeID == null ? null : Database.getDB().getOverlayOwnerFromGenomeKey(genomeID);
        if (owner != null) {
            if (ovrKey != null) {
                this.lastSeenOverlayPerOwner_.put(owner.getID(), new TaggedString(1, ovrKey));
                this.lastSeenModulePerOverlay_.put(ovrKey, modKeys);
                this.lastSeenRevealedPerOverlay_.put(ovrKey, revealedKeys);
            } else {
                this.lastSeenOverlayPerOwner_.put(owner.getID(), new TaggedString(1, null));
            }
        }
        int numOvr = -1;
        if (this.netOverlaysCombo_ != null) {
            numOvr = this.netOverlaysCombo_.getItemCount();
        }
        this.ovrEnabled_ = numOvr > 1;
        this.upstreamSetEnabled(this.ovrEnabled_ && !this.pushed_);
        this.downStrEnabled_ = ovrKey != null;
        this.zoomCanShow_ = !modKeys.set.isEmpty();
        Boolean pushedLevel = this.pushed_ ? new Boolean(this.pushedAllowLevel_) : null;
        this.downstreamSetEnabled(this.downStrEnabled_ && !this.pushed_, pushedLevel);
        this.mcmd_.updateOverlayActionStatus(ovrKey, modKeys.set);
    }

    private void selectCurrentOverlayInUI(String key) {
        this.managingOverlayControls_ = true;
        if (this.netOverlaysCombo_ != null) {
            int numUpm = this.netOverlaysCombo_.getItemCount();
            for (int i = 0; i < numUpm; ++i) {
                ObjChoiceContent occ = (ObjChoiceContent)this.netOverlaysCombo_.getItemAt(i);
                String ovKey = occ.val;
                boolean selected = false;
                selected = key == null ? ovKey == null : key.equals(ovKey);
                if (!selected) continue;
                this.netOverlaysCombo_.setSelectedIndex(i);
                this.netOverlaysCombo_.invalidate();
                this.netOverlaysCombo_.validate();
                break;
            }
        }
        this.managingOverlayControls_ = false;
    }

    private void selectCurrentNetModulesInUI(TaggedSet currKeys, TaggedSet revKeys) {
        this.managingOverlayControls_ = true;
        if (this.netModuleChoices_ != null) {
            ListModel myModel = this.netModuleChoices_.getModel();
            int numElem = myModel.getSize();
            for (int i = 0; i < numElem; ++i) {
                CheckBoxList.ListChoice choice = (CheckBoxList.ListChoice)myModel.getElementAt(i);
                choice.isSelected = currKeys.set.contains(choice.getObject());
                choice.isSubSelected = revKeys.set.contains(choice.getObject());
            }
            this.netModuleChoices_.repaint();
        }
        this.managingOverlayControls_ = false;
    }

    private Vector getOverlayChoices(String genomeID) {
        Vector<ObjChoiceContent> retval = new Vector<ObjChoiceContent>();
        if (genomeID == null) {
            return retval;
        }
        NetOverlayOwner owner = Database.getDB().getOverlayOwnerFromGenomeKey(genomeID);
        Iterator noit = owner.getNetworkOverlayIterator();
        while (noit.hasNext()) {
            NetworkOverlay ovr = (NetworkOverlay)noit.next();
            retval.add(new ObjChoiceContent(ovr.getName(), ovr.getID()));
        }
        return retval;
    }

    private Vector getModuleChoices(String genomeID, String ovrKey) {
        Vector<CheckBoxList.ListChoice> retval = new Vector<CheckBoxList.ListChoice>();
        if (genomeID == null || ovrKey == null) {
            return retval;
        }
        NetOverlayOwner owner = Database.getDB().getOverlayOwnerFromGenomeKey(genomeID);
        NetworkOverlay ovr = owner.getNetworkOverlay(ovrKey);
        Iterator nmit = ovr.getModuleIterator();
        while (nmit.hasNext()) {
            NetModule mod = (NetModule)nmit.next();
            CheckBoxList.ListChoice lc = new CheckBoxList.ListChoice(mod.getID(), mod.getName(), Color.white, false);
            retval.add(lc);
        }
        return retval;
    }

    private TaggedSet getAllModuleChoiceSet(Vector modChoices) {
        TaggedSet retval = new TaggedSet();
        int size = modChoices.size();
        for (int i = 0; i < size; ++i) {
            CheckBoxList.ListChoice lc = (CheckBoxList.ListChoice)modChoices.get(i);
            retval.set.add(lc.getObject());
        }
        return retval;
    }

    private void updateNetOverlayOptions(String genomeID) {
        this.managingOverlayControls_ = true;
        Vector overlayChoices = this.getOverlayChoices(genomeID);
        int numOV = overlayChoices.size();
        ResourceManager rMan = ResourceManager.getManager();
        String noOverlay = rMan.getString("netOverlayController.noOverlay");
        if (this.netOverlaysCombo_ != null) {
            this.netOverlaysCombo_.removeAllItems();
            this.netOverlaysCombo_.addItem(new ObjChoiceContent(noOverlay, null));
            for (int i = 0; i < numOV; ++i) {
                ObjChoiceContent occ = (ObjChoiceContent)overlayChoices.get(i);
                this.netOverlaysCombo_.addItem(occ);
            }
            this.netOverlaysCombo_.invalidate();
            this.netOverlaysCombo_.validate();
        }
        this.managingOverlayControls_ = false;
    }

    private void updateNetModuleOptions(String genomeID, String ovrKey, TaggedSet currModules) {
        this.managingOverlayControls_ = true;
        this.showingRevControls_ = false;
        if (genomeID != null && ovrKey != null) {
            Database db = Database.getDB();
            Layout lo = db.getLayout(new LayoutManager().getLayout(genomeID));
            NetOverlayProperties nop = lo.getNetOverlayProperties(ovrKey);
            this.showingRevControls_ = nop.getType() == 1;
        }
        Vector moduleChoices = this.getModuleChoices(genomeID, ovrKey);
        if (this.netModuleChoices_ != null) {
            this.netModuleChoices_.showAndEnableSubSelection(this.showingRevControls_, this.activeRevControls_);
            this.netModuleChoices_.setListData(moduleChoices);
            this.netModuleChoices_.invalidate();
            this.netModuleChoices_.validate();
        }
        if (this.buttonPanel_ != null) {
            this.myCard_.show(this.buttonPanel_, this.showingRevControls_ ? "All" : "Some");
            this.buttonPanel_.invalidate();
            this.buttonPanel_.validate();
        }
        this.managingOverlayControls_ = false;
    }

    private void unDoableSetOverlay(String ovKey) {
        UndoManager undo = this.suw_.getUndoManager();
        UndoSupport support = new UndoSupport(undo, "undo.setCurrentNetOverlay");
        OdcAndSccBundle oasb = this.setCurrentOverlayGuts(ovKey);
        if (oasb != null && oasb.odc != null) {
            this.syncPathController(support);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(oasb.odc);
            support.addEdit(nodcc);
            support.addEvent(new OverlayDisplayChangeEvent(1));
            if (oasb.bundle != null && oasb.bundle.cmd != null) {
                support.addEdit(oasb.bundle.cmd);
                support.addEvent(oasb.bundle.event);
            }
            support.finish();
        }
    }

    private void unDoableSetModules(TaggedSet modKeys, TaggedSet revKeys) {
        UndoManager undo = this.suw_.getUndoManager();
        UndoSupport support = new UndoSupport(undo, "undo.setCurrentNetModule");
        OverlayDisplayChange odc = this.setCurrentModuleGuts(modKeys, revKeys);
        if (odc != null) {
            this.syncPathController(support);
            NetOverlayDisplayChangeCmd nodcc = new NetOverlayDisplayChangeCmd(odc);
            support.addEdit(nodcc);
            support.addEvent(new OverlayDisplayChangeEvent(1));
            support.finish();
        }
    }

    private void init() {
        ResourceManager rMan = ResourceManager.getManager();
        this.nocp_ = new NetOverlayControlPanel(new NetModuleFree.CurrentSettings(), this.suw_, this);
        this.netOverlaysCombo_ = new FixedJComboBox(250);
        this.netOverlaysCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (NetOverlayController.this.managingOverlayControls_) {
                        return;
                    }
                    ObjChoiceContent occ = (ObjChoiceContent)NetOverlayController.this.netOverlaysCombo_.getSelectedItem();
                    String ovKey = occ == null ? null : occ.val;
                    NetOverlayController.this.unDoableSetOverlay(ovKey);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.netModuleChoices_ = new CheckBoxList(new CheckBoxList.CheckBoxListListener(){

            public void checkIsClicked() {
                try {
                    if (NetOverlayController.this.managingOverlayControls_) {
                        return;
                    }
                    boolean somebodyChecked = false;
                    ListModel myModel = NetOverlayController.this.netModuleChoices_.getModel();
                    TaggedSet modKeys = new TaggedSet();
                    TaggedSet revKeys = new TaggedSet();
                    int numElem = myModel.getSize();
                    for (int i = 0; i < numElem; ++i) {
                        CheckBoxList.ListChoice choice = (CheckBoxList.ListChoice)myModel.getElementAt(i);
                        if (choice.isSelected) {
                            modKeys.set.add(choice.getObject());
                            somebodyChecked = true;
                        }
                        if (!choice.isSubSelected) continue;
                        revKeys.set.add(choice.getObject());
                    }
                    NetOverlayController.this.zoomCanShow_ = somebodyChecked;
                    NetOverlayController.this.unDoableSetModules(modKeys, revKeys);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        }, true, true);
        this.netModuleChoices_.setToolTipText(rMan.getString("netOverlayController.mainTip"), rMan.getString("netOverlayController.subTip"));
        this.allButtonA_ = FixedJButton.miniFactory(rMan.getString("netOverlayController.allModules"), 12);
        this.allButtonA_.addActionListener(new AllActor());
        this.allButtonA_.setToolTipText(rMan.getString("netOverlayController.allModulesToolTip"));
        this.allButtonS_ = FixedJButton.miniFactory(rMan.getString("netOverlayController.allModules"), 12);
        this.allButtonS_.addActionListener(new AllActor());
        this.allButtonS_.setToolTipText(rMan.getString("netOverlayController.allModulesToolTip"));
        this.revAllButton_ = FixedJButton.miniFactory(rMan.getString("netOverlayController.revAllModules"), 12);
        this.revAllButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    SUPanel sup = NetOverlayController.this.suw_.getSUPanel();
                    String genomeID = sup.getGenome();
                    String currOvrKey = sup.getCurrentOverlay();
                    TaggedSet useChoices = sup.getCurrentNetModules();
                    TaggedSet currRevs = sup.getRevealedModules();
                    TaggedSet useRevs = (TaggedSet)useChoices.clone();
                    useRevs.set.addAll(currRevs.set);
                    NetOverlayController.this.unDoableSetModules(useChoices, useRevs);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.revAllButton_.setToolTipText(rMan.getString("netOverlayController.revAllModulesToolTip"));
        this.hideAllButton_ = FixedJButton.miniFactory(rMan.getString("netOverlayController.hideAllModules"), 12);
        this.hideAllButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    SUPanel sup = NetOverlayController.this.suw_.getSUPanel();
                    String genomeID = sup.getGenome();
                    String currOvrKey = sup.getCurrentOverlay();
                    TaggedSet useChoices = sup.getCurrentNetModules();
                    TaggedSet currRevs = sup.getRevealedModules();
                    TaggedSet useRevs = (TaggedSet)currRevs.clone();
                    useRevs.set.removeAll(useChoices.set);
                    NetOverlayController.this.unDoableSetModules(useChoices, useRevs);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.hideAllButton_.setToolTipText(rMan.getString("netOverlayController.hideAllModulesToolTip"));
        this.noneButtonA_ = FixedJButton.miniFactory(rMan.getString("netOverlayController.noModules"), 12);
        this.noneButtonA_.addActionListener(new NoneActor());
        this.noneButtonA_.setToolTipText(rMan.getString("netOverlayController.noModulesToolTip"));
        this.noneButtonS_ = FixedJButton.miniFactory(rMan.getString("netOverlayController.noModules"), 12);
        this.noneButtonS_.addActionListener(new NoneActor());
        this.noneButtonS_.setToolTipText(rMan.getString("netOverlayController.noModulesToolTip"));
        this.zoomButtonA_ = FixedJButton.miniFactory(rMan.getString("netOverlayController.zoom"), 12);
        this.zoomButtonA_.addActionListener(new ZoomActor());
        this.zoomButtonA_.setToolTipText(rMan.getString("netOverlayController.zoomToolTip"));
        this.zoomButtonS_ = FixedJButton.miniFactory(rMan.getString("netOverlayController.zoom"), 12);
        this.zoomButtonS_.addActionListener(new ZoomActor());
        this.zoomButtonS_.setToolTipText(rMan.getString("netOverlayController.zoomToolTip"));
    }

    private class NoneActor
    implements ActionListener {
        private NoneActor() {
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                SUPanel sup = NetOverlayController.this.suw_.getSUPanel();
                TaggedSet useChoices = new TaggedSet();
                TaggedSet useRevs = new TaggedSet();
                NetOverlayController.this.unDoableSetModules(useChoices, useRevs);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class AllActor
    implements ActionListener {
        private AllActor() {
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                SUPanel sup = NetOverlayController.this.suw_.getSUPanel();
                String genomeID = sup.getGenome();
                String currOvrKey = sup.getCurrentOverlay();
                TaggedSet useChoices = NetOverlayController.this.getAllModuleChoiceSet(NetOverlayController.this.getModuleChoices(genomeID, currOvrKey));
                TaggedSet useRevs = sup.getRevealedModules();
                NetOverlayController.this.unDoableSetModules(useChoices, useRevs);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class ZoomActor
    implements ActionListener {
        private ZoomActor() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.OneShot eco = MainCommands.getCmds().getOneShot(14);
                eco.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private static class OdcAndSccBundle {
        OverlayDisplayChange odc;
        SelectionChangeCmd.Bundle bundle;

        private OdcAndSccBundle() {
        }
    }
}

