/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OldPadMapper {
    private HashMap padsPerLink_ = new HashMap();
    private HashMap launchPerNode_ = new HashMap();
    private HashMap landingsPerNode_ = new HashMap();

    public void setPadPair(String srcNodeID, String targNodeID, String linkID, int launch, int landing) {
        this.padsPerLink_.put(linkID, new PadPair(launch, landing));
        this.launchPerNode_.put(srcNodeID, new Integer(launch));
        HashSet<Integer> lands = (HashSet<Integer>)this.landingsPerNode_.get(targNodeID);
        if (lands == null) {
            lands = new HashSet<Integer>();
            this.landingsPerNode_.put(targNodeID, lands);
        }
        lands.add(new Integer(landing));
    }

    public int getLaunch(String linkID) {
        PadPair pair = (PadPair)this.padsPerLink_.get(linkID);
        if (pair == null) {
            throw new IllegalStateException();
        }
        return pair.launchPad;
    }

    public int getLanding(String linkID) {
        PadPair pair = (PadPair)this.padsPerLink_.get(linkID);
        if (pair == null) {
            throw new IllegalStateException();
        }
        return pair.landingPad;
    }

    public Integer getNodeLaunch(String nodeID) {
        return (Integer)this.launchPerNode_.get(nodeID);
    }

    public Iterator getNodeLandings(String nodeID) {
        Set lands = (Set)this.landingsPerNode_.get(nodeID);
        if (lands == null) {
            return null;
        }
        return lands.iterator();
    }

    private static class PadPair {
        public int launchPad;
        public int landingPad;

        public PadPair(int launchPad, int landingPad) {
            this.launchPad = launchPad;
            this.landingPad = landingPad;
        }
    }
}

