/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.cmd.OldPadMapper;
import org.systemsbiology.biotapestry.cmd.PadConstraints;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBLinkage;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.PadDotRanking;
import org.systemsbiology.biotapestry.util.LinkPlacementGrid;
import org.systemsbiology.biotapestry.util.Vector2D;

public class PadCalculatorToo {
    public List checkForGeneSrcPadErrors() {
        Database db = Database.getDB();
        DBGenome genome = (DBGenome)db.getGenome();
        ArrayList fixList = new ArrayList();
        this.checkForGeneSrcErrorsInGenome(db, genome, fixList);
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            GenomeInstance gi = (GenomeInstance)git.next();
            if (gi.getVfgParent() != null) continue;
            this.checkForGeneSrcErrorsInGenome(db, gi, fixList);
        }
        return fixList;
    }

    private void checkForGeneSrcErrorsInGenome(Database db, Genome genome, List fixList) {
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String srcNodeID = link.getSource();
            Node srcNode = genome.getNode(srcNodeID);
            int nodeType = srcNode.getNodeType();
            if (nodeType != 4 && nodeType != 5 || link.getLaunchPad() == 0) continue;
            link.setLaunchPad(0);
            fixList.add(srcNode.getName());
        }
    }

    public List checkForPadErrors() {
        Map limMap = NodeProperties.getFixedPadLimits();
        Database db = Database.getDB();
        DBGenome genome = (DBGenome)db.getGenome();
        ArrayList fixList = new ArrayList();
        this.checkForPadErrorsInGenome(db, genome, limMap, fixList);
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            GenomeInstance gi = (GenomeInstance)git.next();
            if (gi.getVfgParent() != null) continue;
            this.checkForPadErrorsInGenome(db, gi, limMap, fixList);
        }
        return fixList;
    }

    private void checkForPadErrorsInGenome(Database db, Genome genome, Map limMap, List fixList) {
        String src;
        HashMap<String, HashSet<Integer>> landingPadsPerNode = new HashMap<String, HashSet<Integer>>();
        HashMap<String, HashSet<Integer>> sourcePadsPerNode = new HashMap<String, HashSet<Integer>>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            src = link.getSource();
            int srcPad = link.getLaunchPad();
            HashSet<Integer> usedPads = (HashSet<Integer>)sourcePadsPerNode.get(src);
            if (usedPads == null) {
                usedPads = new HashSet<Integer>();
                sourcePadsPerNode.put(src, usedPads);
            }
            usedPads.add(new Integer(srcPad));
            String trg = link.getTarget();
            int trgPad = link.getLandingPad();
            usedPads = (HashSet<Integer>)landingPadsPerNode.get(trg);
            if (usedPads == null) {
                usedPads = new HashSet<Integer>();
                landingPadsPerNode.put(trg, usedPads);
            }
            usedPads.add(new Integer(trgPad));
        }
        Iterator snit = sourcePadsPerNode.keySet().iterator();
        while (snit.hasNext()) {
            HashSet usedTargPads;
            src = (String)snit.next();
            Node node = genome.getNode(src);
            NodeProperties.PadLimits lim = (NodeProperties.PadLimits)limMap.get(new Integer(node.getNodeType()));
            HashSet usedPads = (HashSet)sourcePadsPerNode.get(src);
            Integer srcPad = usedPads.size() != 1 ? this.generateLaunchConsensus(genome, src, lim, (Set)landingPadsPerNode.get(src), fixList) : (Integer)usedPads.iterator().next();
            if (!lim.sharedNamespace || (usedTargPads = (HashSet)landingPadsPerNode.get(src)) == null || !usedTargPads.contains(srcPad)) continue;
            Layout lo = db.getLayout(new LayoutManager().getLayout(genome.getID()));
            this.resolveSrgTrgCollision(genome, node, lo, lim, srcPad, usedTargPads, fixList);
        }
    }

    private Integer generateLaunchConsensus(Genome genome, String nodeID, NodeProperties.PadLimits padLimits, Set landPads, List fixList) {
        Integer srcPadObj;
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        HashMap<Integer, HashSet<String>> linksPerPad = new HashMap<Integer, HashSet<String>>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String src = link.getSource();
            if (!src.equals(nodeID)) continue;
            int srcPad = link.getLaunchPad();
            srcPadObj = new Integer(srcPad);
            Integer padCount = (Integer)counts.get(srcPadObj);
            padCount = padCount == null ? new Integer(1) : new Integer(padCount + 1);
            counts.put(srcPadObj, padCount);
            HashSet<String> linksForThis = (HashSet<String>)linksPerPad.get(srcPadObj);
            if (linksForThis == null) {
                linksForThis = new HashSet<String>();
                linksPerPad.put(srcPadObj, linksForThis);
            }
            linksForThis.add(link.getID());
        }
        int maxCount = 0;
        TreeSet<Integer> maxPads = new TreeSet<Integer>();
        Iterator cit = counts.keySet().iterator();
        while (cit.hasNext()) {
            srcPadObj = (Integer)cit.next();
            Integer countObj = (Integer)counts.get(srcPadObj);
            int count = countObj;
            if (count > maxCount) {
                maxCount = count;
                maxPads.clear();
                maxPads.add(srcPadObj);
                continue;
            }
            if (count != maxCount) continue;
            maxPads.add(srcPadObj);
        }
        Integer consensus = null;
        if (maxPads.size() == 1 || !padLimits.sharedNamespace || landPads == null) {
            consensus = (Integer)maxPads.iterator().next();
        } else {
            Iterator mpit = maxPads.iterator();
            while (mpit.hasNext()) {
                Integer aPad = (Integer)mpit.next();
                if (landPads.contains(aPad)) {
                    if (mpit.hasNext()) continue;
                    consensus = aPad;
                    break;
                }
                consensus = aPad;
                break;
            }
        }
        if (consensus == null) {
            throw new IllegalStateException();
        }
        int conVal = consensus;
        Iterator pit = linksPerPad.keySet().iterator();
        while (pit.hasNext()) {
            Integer lipad = (Integer)pit.next();
            if (lipad.equals(consensus)) continue;
            HashSet linksForThis = (HashSet)linksPerPad.get(lipad);
            Iterator ltit = linksForThis.iterator();
            while (ltit.hasNext()) {
                String linkID = (String)ltit.next();
                IOFixup doFix = new IOFixup(genome.getID(), linkID, true, conVal);
                fixList.add(doFix);
            }
        }
        return consensus;
    }

    private void resolveSrgTrgCollision(Genome genome, Node node, Layout lo, NodeProperties.PadLimits padLimits, int sourcePad, Set landPads, List fixList) {
        int newTrgPad = Integer.MAX_VALUE;
        INodeRenderer trgRenderer = NodeProperties.chooseRenderer(node.getNodeType(), lo.getLayoutType());
        List nearby = trgRenderer.getNearbyPads(node, sourcePad, lo);
        if (nearby != null) {
            Iterator nit = nearby.iterator();
            while (nit.hasNext()) {
                Integer nearPad = (Integer)nit.next();
                if (landPads.contains(nearPad)) continue;
                newTrgPad = nearPad;
                break;
            }
        }
        if (newTrgPad == Integer.MAX_VALUE) {
            int newPadCount = node.getPadCount();
            int minPadNum = 0;
            if (newPadCount > padLimits.defaultPadCount) {
                minPadNum = padLimits.defaultPadCount - newPadCount;
            }
            if (minPadNum < 0 && !padLimits.landingPadsCanOverflow) {
                throw new IllegalStateException();
            }
            TreeSet trgPads = new TreeSet();
            for (int i = minPadNum; i < padLimits.landingPadMax; ++i) {
                Integer iObj;
                if (i == sourcePad || landPads.contains(iObj = new Integer(i)) && i != padLimits.landingPadMax - 1) continue;
                newTrgPad = i;
                break;
            }
        }
        if (newTrgPad == Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        String nodeID = node.getID();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            int trgPad;
            Linkage link = (Linkage)lit.next();
            String trg = link.getTarget();
            if (!trg.equals(nodeID) || (trgPad = link.getLandingPad()) != sourcePad) continue;
            IOFixup doFix = new IOFixup(genome.getID(), link.getID(), false, newTrgPad);
            fixList.add(doFix);
        }
    }

    public void fixIOPadErrors(List fixList) {
        Database db = Database.getDB();
        int numFix = fixList.size();
        for (int i = 0; i < numFix; ++i) {
            IOFixup doFix = (IOFixup)fixList.get(i);
            Genome genome = db.getGenome(doFix.genomeID);
            this.fixIOPadErrorsForGenome(doFix, genome);
            if (!(genome instanceof GenomeInstance)) continue;
            GenomeInstance rootInstance = (GenomeInstance)genome;
            Iterator git = db.getInstanceIterator();
            while (git.hasNext()) {
                GenomeInstance gi = (GenomeInstance)git.next();
                if (gi == rootInstance || !rootInstance.isAncestor(gi)) continue;
                this.fixIOPadErrorsForGenome(doFix, gi);
            }
        }
    }

    private void fixIOPadErrorsForGenome(IOFixup doFix, Genome genome) {
        Linkage link = genome.getLinkage(doFix.linkID);
        if (doFix.isLaunchChange) {
            link.setLaunchPad(doFix.newPad);
        } else {
            link.setLandingPad(doFix.newPad);
        }
    }

    public void decidePadChanges(Genome genome, String nodeID, NodeProperties.PadLimits padLimits, Map launchPads, Map landPads) {
        int newPadCount = genome.getNode(nodeID).getPadCount();
        int minPadNum = 0;
        if (newPadCount > padLimits.defaultPadCount) {
            minPadNum = padLimits.defaultPadCount - newPadCount;
        }
        if (minPadNum < 0 && !padLimits.landingPadsCanOverflow) {
            throw new IllegalStateException();
        }
        ArrayList<Linkage> outbound = new ArrayList<Linkage>();
        ArrayList<Linkage> inbound = new ArrayList<Linkage>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (link.getTarget().equals(nodeID)) {
                inbound.add(link);
            }
            if (!link.getSource().equals(nodeID)) continue;
            outbound.add(link);
        }
        Integer srcPad = null;
        if (outbound.size() > 0) {
            int srcMax = padLimits.launchPadMax - 1;
            int srcMin = padLimits.sharedNamespace ? minPadNum : 0;
            srcPad = genome.getSourcePad(nodeID);
            if (srcPad == null) {
                throw new IllegalStateException();
            }
            int srcPadVal = srcPad;
            if (srcPadVal > srcMax) {
                srcPadVal = srcMax;
            } else if (srcPadVal < srcMin) {
                srcPadVal = srcMin;
            }
            srcPad = new Integer(srcPadVal);
            Iterator oit = outbound.iterator();
            while (oit.hasNext()) {
                Linkage link = (Linkage)oit.next();
                launchPads.put(link.getID(), srcPad);
            }
        }
        TreeSet<Integer> trgPads = new TreeSet<Integer>();
        for (int i = minPadNum; i < padLimits.landingPadMax; ++i) {
            trgPads.add(new Integer(i));
        }
        if (padLimits.sharedNamespace && srcPad != null) {
            trgPads.remove(srcPad);
        }
        ArrayList<Linkage> pendingList = new ArrayList<Linkage>();
        Iterator iit = inbound.iterator();
        while (iit.hasNext()) {
            Linkage link = (Linkage)iit.next();
            int landPad = link.getLandingPad();
            if (srcPad != null && padLimits.sharedNamespace && landPad == srcPad) {
                pendingList.add(link);
                continue;
            }
            if (landPad < minPadNum) {
                pendingList.add(link);
                continue;
            }
            if (landPad >= padLimits.landingPadMax) {
                pendingList.add(link);
                continue;
            }
            Integer lp = new Integer(landPad);
            trgPads.remove(lp);
            landPads.put(link.getID(), lp);
        }
        Iterator pit = pendingList.iterator();
        while (pit.hasNext()) {
            Linkage link = (Linkage)pit.next();
            String linkID = link.getID();
            int landPad = link.getLandingPad();
            landPad = trgPads.isEmpty() ? this.getClosestOccupiedNonSource(linkID, landPad, padLimits, srcPad, minPadNum) : this.getClosestUnoccupiedNonSource(linkID, landPad, padLimits, trgPads, srcPad);
            Integer lp = new Integer(landPad);
            trgPads.remove(lp);
            landPads.put(link.getID(), lp);
        }
    }

    private int getClosestOccupiedNonSource(String linkID, int landPad, NodeProperties.PadLimits padLimits, Integer srcPad, int minPadNum) {
        int retval;
        int srcPadVal;
        boolean checkForSource = srcPad != null && padLimits.sharedNamespace;
        int n = srcPadVal = checkForSource ? srcPad : Integer.MIN_VALUE;
        if (landPad < minPadNum) {
            retval = minPadNum;
            if (checkForSource && retval == srcPadVal) {
                ++retval;
            }
        } else if (landPad >= padLimits.landingPadMax) {
            retval = padLimits.landingPadMax - 1;
            if (checkForSource && retval == srcPadVal) {
                --retval;
            }
        } else if (checkForSource && landPad == srcPadVal) {
            retval = landPad == minPadNum ? landPad + 1 : (landPad == padLimits.landingPadMax - 1 ? landPad - 1 : landPad + 1);
        } else {
            throw new IllegalStateException();
        }
        if (retval >= padLimits.landingPadMax || retval < minPadNum) {
            throw new IllegalStateException();
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getClosestUnoccupiedNonSource(String linkID, int landPad, NodeProperties.PadLimits padLimits, SortedSet trgPads, Integer srcPad) {
        Integer retval;
        Integer firstPad = (Integer)trgPads.first();
        if (landPad < firstPad) {
            retval = firstPad;
            trgPads.remove(retval);
            return retval;
        } else if (landPad >= padLimits.landingPadMax) {
            retval = (Integer)trgPads.last();
            trgPads.remove(retval);
            return retval;
        } else {
            if (srcPad == null || !padLimits.sharedNamespace || landPad != srcPad) throw new IllegalStateException();
            Integer greatestMin = null;
            Integer leastMax = null;
            int srcVal = srcPad;
            Iterator tpit = trgPads.iterator();
            while (tpit.hasNext()) {
                Integer curr = (Integer)tpit.next();
                if (curr < srcVal) {
                    greatestMin = curr;
                }
                if (curr <= srcVal || leastMax != null) continue;
                leastMax = curr;
            }
            if (leastMax != null) {
                retval = leastMax;
                return retval;
            } else {
                if (greatestMin == null) throw new IllegalStateException();
                retval = greatestMin;
            }
        }
        return retval;
    }

    private int getClosestUnoccupied(int landPad, SortedSet trgPads) {
        Integer retval;
        Integer greatestMin = null;
        Integer leastMax = null;
        Iterator tpit = trgPads.iterator();
        while (tpit.hasNext()) {
            Integer curr = (Integer)tpit.next();
            if (curr < landPad) {
                greatestMin = curr;
            }
            if (curr <= landPad || leastMax != null) continue;
            leastMax = curr;
        }
        if (leastMax != null) {
            retval = leastMax;
        } else if (greatestMin != null) {
            retval = greatestMin;
        } else {
            throw new IllegalStateException();
        }
        return retval;
    }

    private Integer getClosestUnoccupiedFromRankedCandidates(int landPad, SortedSet usedPads, List nearby) {
        int numNear = nearby == null ? 0 : nearby.size();
        for (int i = 0; i < numNear; ++i) {
            Integer check = (Integer)nearby.get(i);
            if (usedPads.contains(check)) continue;
            return check;
        }
        return null;
    }

    public PadResult padCalc(String srcID, String targID, PadConstraints padLimits, boolean nodesCanGrow) {
        int targMin;
        if (padLimits != null && padLimits.arePadsForced()) {
            return new PadResult(padLimits.getForcedLaunch(), padLimits.getForcedLanding());
        }
        Database db = Database.getDB();
        DBGenome genome = (DBGenome)db.getGenome();
        int srcPad = 0;
        TreeSet<Integer> trgPads = new TreeSet<Integer>();
        TreeSet<Integer> overflow = new TreeSet<Integer>();
        Layout lo = db.getLayout(new LayoutManager().getLayout(genome.getID()));
        Node node = genome.getNode(targID);
        INodeRenderer trgRenderer = NodeProperties.chooseRenderer(node.getNodeType(), lo.getLayoutType());
        int targMax = trgRenderer.getFixedLandingPadMax();
        for (int i = targMin = trgRenderer.sharedPadNamespaces() ? 1 : 0; i < targMax; ++i) {
            trgPads.add(new Integer(i));
        }
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            DBLinkage link = (DBLinkage)lit.next();
            String src = link.getSource();
            String trg = link.getTarget();
            if (src.equals(srcID)) {
                srcPad = link.getLaunchPad();
            }
            if (src.equals(targID) && trgRenderer.sharedPadNamespaces()) {
                trgPads.remove(new Integer(link.getLaunchPad()));
            }
            if (trg.equals(srcID) && trgRenderer.sharedPadNamespaces()) {
                trgPads.remove(new Integer(link.getLaunchPad()));
            }
            if (!trg.equals(targID)) continue;
            int lpad = link.getLandingPad();
            if (lpad >= 0) {
                trgPads.remove(new Integer(lpad));
                continue;
            }
            overflow.add(new Integer(lpad));
        }
        if (padLimits != null) {
            Iterator plit = padLimits.getUsedLaunchPads();
            if (plit != null) {
                while (plit.hasNext()) {
                    Integer launch = (Integer)plit.next();
                    srcPad = launch;
                    if (!trgRenderer.sharedPadNamespaces()) continue;
                    trgPads.remove(launch);
                }
            }
            if ((plit = padLimits.getUsedLandingPads()) != null) {
                while (plit.hasNext()) {
                    Integer landing = (Integer)plit.next();
                    int lpad = landing;
                    if (lpad >= 0) {
                        trgPads.remove(landing);
                        continue;
                    }
                    overflow.add(landing);
                }
            }
        }
        int trgPad = trgPads.isEmpty() ? (trgRenderer.landingPadsCanOverflow() && nodesCanGrow ? (overflow.isEmpty() ? -1 : (Integer)overflow.first() - 1) : targMax - 1) : (Integer)trgPads.iterator().next();
        return new PadResult(srcPad, trgPad);
    }

    public Map recommendLinkSwaps(Genome genome, String nodeID, Layout lo, Map padConstraints) {
        SortedSet bestLaunch = this.getBestLaunch(genome, nodeID, lo);
        Map bestLandings = this.getBestLandings(genome, nodeID, lo);
        Map resolved = this.resolvePadCollisions(genome, nodeID, bestLaunch, bestLandings, padConstraints, lo);
        return resolved;
    }

    public PadConstraints generatePadConstraints(String sourceID, String targetID, OldPadMapper opm, String oldLinkID, Map newNodeToOldNode) {
        Iterator olit;
        String oldTarget;
        Integer launch;
        PadConstraints retval = new PadConstraints();
        if (opm == null) {
            return retval;
        }
        if (oldLinkID != null) {
            retval.setForcedPads(opm.getLaunch(oldLinkID), opm.getLanding(oldLinkID));
            return retval;
        }
        String oldSource = (String)newNodeToOldNode.get(sourceID);
        if (oldSource != null && (launch = opm.getNodeLaunch(oldSource)) != null) {
            retval.addUsedLaunchPad(launch);
        }
        if ((oldTarget = (String)newNodeToOldNode.get(targetID)) != null && (olit = opm.getNodeLandings(oldTarget)) != null) {
            while (olit.hasNext()) {
                Integer oldLanding = (Integer)olit.next();
                retval.addUsedLandingPad(oldLanding);
            }
        }
        return retval;
    }

    public void getDirections(UpwardPadSyncData upsd, DBGenome dbg, Map launchDirections, Map landDirections, boolean forceUnique, Set orphanedLinks) {
        String trgID;
        String linkID;
        HashSet<String> targList = new HashSet<String>();
        HashMap<String, Integer> useSourcePadsPerNode = new HashMap<String, Integer>();
        Iterator lit = dbg.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String srcID = link.getSource();
            linkID = link.getID();
            Integer launch = (Integer)useSourcePadsPerNode.get(srcID);
            if (launch == null) {
                launch = this.calcSourcePad(upsd, srcID);
                if (launch == null) {
                    launch = new Integer(link.getLaunchPad());
                }
                useSourcePadsPerNode.put(srcID, launch);
            }
            launchDirections.put(linkID, launch);
            targList.add(link.getTarget());
        }
        UpwardPadSyncData orphUpsd = new UpwardPadSyncData();
        Iterator oit = orphanedLinks.iterator();
        while (oit.hasNext()) {
            linkID = (String)oit.next();
            Linkage orphLink = dbg.getLinkage(linkID);
            trgID = orphLink.getTarget();
            int orphPad = orphLink.getLandingPad();
            orphUpsd.setForTarget(linkID, trgID, orphPad);
        }
        Map lims = NodeProperties.getFixedPadLimits();
        Iterator tlit = targList.iterator();
        while (tlit.hasNext()) {
            trgID = (String)tlit.next();
            Integer srcPad = (Integer)useSourcePadsPerNode.get(trgID);
            this.figureTargetPads(upsd, orphUpsd, dbg, trgID, lims, srcPad, landDirections, forceUnique);
        }
        lit = dbg.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (landDirections.get(link.getID()) != null) continue;
            throw new IllegalStateException();
        }
    }

    public Map generateTerminalRegionsForCollisions(Genome genome, Layout lo, FontRenderContext frc, LinkPlacementGrid grid, Set inboundLinks, String targetID, Set needAltTargs, Map okGroupMap) {
        TreeSet<Integer> usedPads = new TreeSet<Integer>();
        HashSet<Point> usedEmerg = new HashSet<Point>();
        HashSet<Integer> grabbedPads = new HashSet<Integer>();
        Node node = genome.getNode(targetID);
        INodeRenderer trgRenderer = NodeProperties.chooseRenderer(node.getNodeType(), lo.getLayoutType());
        boolean dropSource = trgRenderer.sharedPadNamespaces();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            String trg;
            String src;
            Linkage link = (Linkage)lit.next();
            if (dropSource && (src = link.getSource()).equals(targetID)) {
                int srcPad = link.getLaunchPad();
                usedPads.add(new Integer(srcPad));
            }
            if (!(trg = link.getTarget()).equals(targetID)) continue;
            int lpad = link.getLandingPad();
            usedPads.add(new Integer(lpad));
        }
        HashMap<String, LinkPlacementGrid.TerminalRegion> retval = new HashMap<String, LinkPlacementGrid.TerminalRegion>();
        Iterator ilit = inboundLinks.iterator();
        while (ilit.hasNext()) {
            String inLink = (String)ilit.next();
            if (!needAltTargs.contains(inLink)) continue;
            Linkage link = genome.getLinkage(inLink);
            int lpad = link.getLandingPad();
            List nearby = trgRenderer.getNearbyPads(node, lpad, lo);
            Integer lpadObj = new Integer(lpad);
            boolean weAreDone = false;
            Integer closestObj = null;
            if (!grabbedPads.contains(lpadObj)) {
                grabbedPads.add(lpadObj);
                closestObj = lpadObj;
            } else {
                closestObj = this.getClosestUnoccupiedFromRankedCandidates(lpad, usedPads, nearby);
            }
            while (closestObj != null) {
                Set okGroups = (Set)okGroupMap.get(inLink);
                LinkPlacementGrid.TerminalRegion treg = LinkRouter.generateArrival(inLink, genome, lo, frc, grid, closestObj, okGroups);
                usedPads.add(closestObj);
                if (grid.terminalRegionCanBeReserved(treg)) {
                    retval.put(inLink, treg);
                    okGroupMap.put(inLink, okGroups);
                    weAreDone = true;
                    break;
                }
                closestObj = this.getClosestUnoccupiedFromRankedCandidates(lpad, usedPads, nearby);
            }
            if (weAreDone) continue;
            int ystart = 10;
            int xstart = -5;
            int xend = 5;
            int maxCount = 50;
            int yVal = ystart;
            int xVal = xstart;
            for (int count = 0; count < maxCount && !weAreDone; ++count) {
                Point checkPt = new Point(xVal, yVal);
                if (!usedEmerg.contains(checkPt) && xVal != 0) {
                    usedEmerg.add(checkPt);
                    HashSet okGroups = new HashSet();
                    LinkPlacementGrid.TerminalRegion emerReg = LinkRouter.generateEmergencyArrival(inLink, genome, lo, frc, grid, lpad, xVal, yVal, okGroups);
                    if (emerReg != null) {
                        okGroupMap.put(inLink, okGroups);
                        retval.put(inLink, emerReg);
                        weAreDone = true;
                    }
                }
                ++yVal;
                if (++xVal <= xend) continue;
                xVal = xstart;
            }
        }
        return retval;
    }

    private Integer calcSourcePad(UpwardPadSyncData upsd, String srcID) {
        HashMap launches = (HashMap)upsd.sourcePadsPerNode_.get(srcID);
        if (launches == null) {
            return null;
        }
        int maxWeight = Integer.MIN_VALUE;
        Integer winPad = null;
        Iterator kit = launches.keySet().iterator();
        while (kit.hasNext()) {
            Integer pad = (Integer)kit.next();
            Integer weight = (Integer)launches.get(pad);
            if (weight <= maxWeight) continue;
            winPad = pad;
            maxWeight = weight;
        }
        return winPad;
    }

    private void figureTargetPads(UpwardPadSyncData upsd, UpwardPadSyncData orphUpsd, Genome genome, String nodeID, Map padLims, Integer srcPad, Map landPads, boolean forceUnique) {
        boolean skipSrc;
        ArrayList orphLandings;
        ArrayList landings;
        Gene trgGene;
        Node trgNode = genome.getNode(nodeID);
        int nodeType = trgNode.getNodeType();
        NodeProperties.PadLimits padLimits = (NodeProperties.PadLimits)padLims.get(new Integer(nodeType));
        int newPadCount = trgNode.getPadCount();
        int minPadNum = 0;
        if (newPadCount > padLimits.defaultPadCount) {
            minPadNum = padLimits.defaultPadCount - newPadCount;
        }
        if (minPadNum < 0 && !padLimits.landingPadsCanOverflow) {
            throw new IllegalStateException();
        }
        boolean doNotChange = false;
        if (nodeType == 4 && (trgGene = (Gene)trgNode).getNumRegions() > 0) {
            doNotChange = true;
        }
        TreeSet<Integer> trgPads = new TreeSet<Integer>();
        for (int i = minPadNum; i < padLimits.landingPadMax; ++i) {
            trgPads.add(new Integer(i));
        }
        if (padLimits.sharedNamespace && srcPad != null) {
            trgPads.remove(srcPad);
        }
        if ((landings = (ArrayList)upsd.targetPadsPerNode_.get(nodeID)) == null) {
            landings = new ArrayList();
        }
        if ((orphLandings = (ArrayList)orphUpsd.targetPadsPerNode_.get(nodeID)) != null) {
            landings.addAll(orphLandings);
        }
        int numLand = landings.size();
        for (int i = 0; i < numLand; ++i) {
            LinkTargPad ltp = (LinkTargPad)landings.get(i);
            trgPads.remove(new Integer(ltp.landPad));
        }
        HashSet<Integer> assigned = new HashSet<Integer>();
        boolean bl = skipSrc = padLimits.sharedNamespace && srcPad != null;
        if (skipSrc) {
            assigned.add(srcPad);
        }
        for (int i = 0; i < numLand; ++i) {
            boolean srcCollide;
            LinkTargPad ltp = (LinkTargPad)landings.get(i);
            Integer lp = new Integer(ltp.landPad);
            if (!assigned.contains(lp) || doNotChange) {
                landPads.put(ltp.linkID, lp);
                assigned.add(lp);
                continue;
            }
            boolean bl2 = srcCollide = skipSrc && lp.equals(srcPad);
            if (srcCollide || forceUnique) {
                int landPad = srcCollide && trgPads.isEmpty() ? this.getClosestOccupiedNonSource(ltp.linkID, ltp.landPad, padLimits, srcPad, minPadNum) : (!trgPads.isEmpty() ? this.getClosestUnoccupied(ltp.landPad, trgPads) : ltp.landPad);
                lp = new Integer(landPad);
                trgPads.remove(lp);
            }
            assigned.add(lp);
            landPads.put(ltp.linkID, lp);
        }
    }

    private SortedSet getBestLaunch(Genome genome, String srcID, Layout lo) {
        double minDist = Double.POSITIVE_INFINITY;
        Point2D minDistPt = null;
        NodeProperties srcProp = lo.getNodeProperties(srcID);
        Point2D srcLoc = srcProp.getLocation();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            String trgID;
            Point2D trgLoc;
            Vector2D vec;
            double vecLen;
            Linkage link = (Linkage)lit.next();
            if (!link.getSource().equals(srcID) || !((vecLen = (vec = new Vector2D(srcLoc, trgLoc = lo.getNodeProperties(trgID = link.getTarget()).getLocation())).length()) < minDist)) continue;
            minDist = vecLen;
            minDistPt = trgLoc;
        }
        if (minDistPt == null) {
            return null;
        }
        return srcProp.getRenderer().suggestLaunchPad(genome.getNode(srcID), lo, minDistPt);
    }

    private Map getBestLandings(Genome genome, String nodeID, Layout lo) {
        String srcID;
        HashMap retval = new HashMap();
        Object minDistPt = null;
        NodeProperties myProp = lo.getNodeProperties(nodeID);
        Point2D myLoc = myProp.getLocation();
        HashMap<String, DistanceRank> srcToDist = new HashMap<String, DistanceRank>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String trgID = link.getTarget();
            if (!trgID.equals(nodeID)) continue;
            srcID = link.getSource();
            Point2D srcLoc = lo.getNodeProperties(srcID).getLocation();
            Vector2D vec = new Vector2D(myLoc, srcLoc);
            double vecLen = vec.length();
            DistanceRank rank = new DistanceRank(srcID, vecLen);
            srcToDist.put(srcID, rank);
        }
        Set sourceSet = srcToDist.keySet();
        lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            String trgID;
            Linkage link = (Linkage)lit.next();
            srcID = link.getSource();
            if (!sourceSet.contains(srcID) || (trgID = link.getTarget()).equals(nodeID)) continue;
            Point2D trgLoc = lo.getNodeProperties(trgID).getLocation();
            Vector2D vec = new Vector2D(myLoc, trgLoc);
            double vecLen = vec.length();
            DistanceRank rank = (DistanceRank)srcToDist.get(srcID);
            if (!(rank.distance > vecLen)) continue;
            Point2D srcLoc = lo.getNodeProperties(srcID).getLocation();
            Vector2D vecSt = new Vector2D(srcLoc, trgLoc);
            double vecLenSt = vecSt.length();
            Vector2D vecMy = new Vector2D(srcLoc, myLoc);
            if (!(1.25 * vecSt.length() < vecMy.length())) continue;
            rank.distance = vecLen;
            rank.id = trgID;
        }
        HashMap<String, SortedSet> ptForSrc = new HashMap<String, SortedSet>();
        INodeRenderer renderer = myProp.getRenderer();
        Node node = genome.getNode(nodeID);
        Iterator kit = srcToDist.keySet().iterator();
        while (kit.hasNext()) {
            String srcKey = (String)kit.next();
            DistanceRank rank = (DistanceRank)srcToDist.get(srcKey);
            Point2D srcLoc = lo.getNodeProperties(rank.id).getLocation();
            SortedSet pads = renderer.suggestLandingPads(node, lo, srcLoc);
            ptForSrc.put(srcKey, pads);
        }
        return ptForSrc;
    }

    private Map resolvePadCollisions(Genome genome, String nodeID, SortedSet bestLaunch, Map padsForSrc, Map padConstraints, Layout lo) {
        HashMap retLaunch = new HashMap();
        HashMap retLand = new HashMap();
        PadModel model = new PadModel(nodeID, genome, lo);
        ArrayList waitingSource = new ArrayList();
        ArrayList waitingTarget = new ArrayList();
        this.resolveForcedLaunch(genome, nodeID, padConstraints, model, retLaunch, waitingSource);
        this.resolveForcedLanding(genome, nodeID, padConstraints, model, retLand, waitingTarget);
        this.assignBestLaunch(genome, nodeID, model, retLaunch, retLand, bestLaunch, waitingSource, waitingTarget);
        this.assignBestLanding(genome, model, retLand, padsForSrc, waitingTarget);
        HashMap<String, PadResult> retval = new HashMap<String, PadResult>();
        Set launchKeys = retLaunch.keySet();
        HashSet allKeys = new HashSet(launchKeys);
        allKeys.addAll(retLand.keySet());
        Iterator kit = allKeys.iterator();
        while (kit.hasNext()) {
            String linkID = (String)kit.next();
            Integer launch = (Integer)retLaunch.get(linkID);
            int launchPad = launch == null ? genome.getLinkage(linkID).getLaunchPad() : launch.intValue();
            Integer land = (Integer)retLand.get(linkID);
            int landPad = land == null ? genome.getLinkage(linkID).getLandingPad() : land.intValue();
            retval.put(linkID, new PadResult(launchPad, landPad));
        }
        return retval;
    }

    private void resolveForcedLaunch(Genome genome, String nodeID, Map padConstraints, PadModel model, Map retLaunch, List waitingSource) {
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (!link.getSource().equals(nodeID)) continue;
            String linkID = link.getID();
            PadConstraints pc = (PadConstraints)padConstraints.get(linkID);
            if (pc != null && pc.arePadsForced()) {
                int launchPad = pc.getForcedLaunch();
                Integer res = new Integer(launchPad);
                retLaunch.put(linkID, res);
                if (model.launchPad != null) {
                    if (model.launchPad != launchPad) {
                        System.err.println("linkID = " + linkID + " modelLaunch = " + model.launchPad + " forced = " + launchPad);
                        throw new IllegalStateException();
                    }
                } else {
                    model.launchPad = new Integer(launchPad);
                    if (model.sharedNamespaces) {
                        model.trgPads.remove(model.launchPad);
                    }
                }
                Iterator wsit = waitingSource.iterator();
                while (wsit.hasNext()) {
                    String waitingLink = (String)wsit.next();
                    retLaunch.put(waitingLink, model.launchPad);
                }
                waitingSource.clear();
                continue;
            }
            if (model.launchPad != null) {
                retLaunch.put(linkID, model.launchPad);
                continue;
            }
            waitingSource.add(linkID);
        }
    }

    private void resolveForcedLanding(Genome genome, String nodeID, Map padConstraints, PadModel model, Map retLanding, List waitingTarget) {
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (!link.getTarget().equals(nodeID)) continue;
            String linkID = link.getID();
            PadConstraints pc = (PadConstraints)padConstraints.get(linkID);
            if (pc != null && pc.arePadsForced()) {
                int landingPad = pc.getForcedLanding();
                Integer res = new Integer(landingPad);
                retLanding.put(linkID, res);
                if (model.launchPad != null && model.sharedNamespaces && model.launchPad == landingPad) {
                    throw new IllegalStateException();
                }
                if (landingPad >= 0) {
                    model.trgPads.remove(new Integer(landingPad));
                    continue;
                }
                model.overflow.add(new Integer(landingPad));
                continue;
            }
            waitingTarget.add(linkID);
        }
    }

    private void assignBestLaunch(Genome genome, String nodeID, PadModel model, Map retLaunch, Map retLanding, SortedSet bestLaunch, List waitingSource, List waitingTarget) {
        if (model.launchPad == null && bestLaunch != null) {
            Integer chosenLaunch = null;
            if (model.sharedNamespaces) {
                Iterator blit = bestLaunch.iterator();
                while (blit.hasNext()) {
                    PadDotRanking pdr = (PadDotRanking)blit.next();
                    Integer launchPad = new Integer(pdr.padNum);
                    if (!model.trgPads.contains(launchPad)) continue;
                    model.trgPads.remove(launchPad);
                    chosenLaunch = launchPad;
                    break;
                }
            } else {
                chosenLaunch = new Integer(((PadDotRanking)bestLaunch.first()).padNum);
            }
            if (chosenLaunch == null) {
                chosenLaunch = new Integer(((PadDotRanking)bestLaunch.first()).padNum);
                this.backOutForcedLanding(genome, nodeID, retLanding, chosenLaunch, waitingTarget);
            }
            Iterator wsit = waitingSource.iterator();
            while (wsit.hasNext()) {
                String waitingLink = (String)wsit.next();
                retLaunch.put(waitingLink, chosenLaunch);
            }
            model.launchPad = chosenLaunch;
            waitingSource.clear();
        }
    }

    private void assignBestLandingOrig(Genome genome, PadModel model, Map retLanding, Map padsForSrc, List waitingTarget) {
        Iterator wtit = waitingTarget.iterator();
        while (wtit.hasNext()) {
            String linkID = (String)wtit.next();
            Linkage link = genome.getLinkage(linkID);
            String srcID = link.getSource();
            Set padPrefs = (Set)padsForSrc.get(srcID);
            Iterator ppit = padPrefs.iterator();
            Integer bestNonLaunch = null;
            boolean gottaPad = false;
            while (ppit.hasNext()) {
                PadDotRanking pdr = (PadDotRanking)ppit.next();
                Integer landingPad = new Integer(pdr.padNum);
                if (pdr.padNum >= 0) {
                    if (model.trgPads.contains(landingPad)) {
                        model.trgPads.remove(landingPad);
                        retLanding.put(linkID, landingPad);
                        gottaPad = true;
                        break;
                    }
                } else if (!model.overflow.contains(landingPad)) {
                    model.overflow.add(landingPad);
                    retLanding.put(linkID, landingPad);
                    gottaPad = true;
                    break;
                }
                if (bestNonLaunch != null || model.launchPad != null && model.launchPad.equals(landingPad)) continue;
                bestNonLaunch = landingPad;
            }
            if (gottaPad) continue;
            if (bestNonLaunch == null) {
                throw new IllegalStateException();
            }
            retLanding.put(linkID, bestNonLaunch);
        }
    }

    private void assignBestLanding(Genome genome, PadModel model, Map retLanding, Map padsForSrc, List waitingTarget) {
        PadAssign assign = this.buildPadAssign(genome, model, retLanding, padsForSrc, waitingTarget);
        List assignments = assign.getAssignments();
        int size = assignments.size();
        for (int i = 0; i < size; ++i) {
            PadChoice pc = (PadChoice)assignments.get(i);
            Integer pad = new Integer(pc.padNum);
            retLanding.put(pc.linkID, pad);
        }
    }

    private PadAssign buildPadAssign(Genome genome, PadModel model, Map retLanding, Map padsForSrc, List waitingTarget) {
        PadAssign retval = new PadAssign();
        Iterator wtit = waitingTarget.iterator();
        while (wtit.hasNext()) {
            String linkID = (String)wtit.next();
            Linkage link = genome.getLinkage(linkID);
            String srcID = link.getSource();
            Set padPrefs = (Set)padsForSrc.get(srcID);
            Iterator ppit = padPrefs.iterator();
            int choiceRank = 0;
            while (ppit.hasNext()) {
                PadDotRanking pdr = (PadDotRanking)ppit.next();
                Integer landingPad = new Integer(pdr.padNum);
                if (model.launchPad != null && model.launchPad.equals(landingPad) || (pdr.padNum >= 0 ? !model.trgPads.contains(landingPad) : model.overflow.contains(landingPad))) continue;
                PadChoice pc = new PadChoice(linkID, pdr.padNum, choiceRank++, pdr.dot);
                retval.register(pc);
            }
        }
        return retval;
    }

    private void backOutForcedLanding(Genome genome, String nodeID, Map retLanding, Integer forcedLaunch, List waitingTarget) {
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            String linkID;
            Integer pad;
            Linkage link = (Linkage)lit.next();
            if (!link.getTarget().equals(nodeID) || !(pad = (Integer)retLanding.get(linkID = link.getID())).equals(forcedLaunch)) continue;
            retLanding.remove(linkID);
            waitingTarget.add(linkID);
        }
    }

    private class PadAssign {
        HashMap requests = new HashMap();
        HashSet unassigned = new HashSet();

        PadAssign() {
        }

        void register(PadChoice choice) {
            Integer landingPad = new Integer(choice.padNum);
            ArrayList<PadChoice> padChoices = (ArrayList<PadChoice>)this.requests.get(landingPad);
            if (padChoices == null) {
                padChoices = new ArrayList<PadChoice>();
                this.requests.put(landingPad, padChoices);
            }
            padChoices.add(choice);
        }

        List getAssignments() {
            ArrayList<PadChoice> retval = new ArrayList<PadChoice>();
            while (this.needAssignment()) {
                if (this.unassigned.isEmpty()) {
                    this.unassigned = new HashSet(this.requests.keySet());
                }
                PadChoice next = this.findTopUnassignedChoice();
                retval.add(next);
                this.flushRequests(next);
                this.unassigned.remove(new Integer(next.padNum));
            }
            return retval;
        }

        void flushRequests(PadChoice choice) {
            Iterator rkit = this.requests.keySet().iterator();
            while (rkit.hasNext()) {
                Integer padNum = (Integer)rkit.next();
                List padChoices = (List)this.requests.get(padNum);
                int count = 0;
                while (count < padChoices.size()) {
                    PadChoice pc = (PadChoice)padChoices.get(count);
                    if (pc.linkID.equals(choice.linkID)) {
                        padChoices.remove(count);
                        continue;
                    }
                    ++count;
                }
            }
        }

        boolean needAssignment() {
            Iterator rkit = this.requests.keySet().iterator();
            while (rkit.hasNext()) {
                Integer padNum = (Integer)rkit.next();
                List padChoices = (List)this.requests.get(padNum);
                if (padChoices.isEmpty()) continue;
                return true;
            }
            return false;
        }

        PadChoice findNextInLine(PadChoice choice) {
            int lookingForRank = choice.choiceRank + 1;
            Iterator uait = this.unassigned.iterator();
            while (uait.hasNext()) {
                Integer padNum = (Integer)uait.next();
                List padChoices = (List)this.requests.get(padNum);
                int pcsize = padChoices.size();
                for (int i = 0; i < pcsize; ++i) {
                    PadChoice pc = (PadChoice)padChoices.get(i);
                    if (!pc.linkID.equals(choice.linkID) || pc.choiceRank != lookingForRank) continue;
                    return pc;
                }
            }
            return null;
        }

        PadChoice findTopUnassignedChoice() {
            double topDot = Double.NEGATIVE_INFINITY;
            PadChoice currentTop = null;
            Iterator uait = this.unassigned.iterator();
            while (uait.hasNext()) {
                Integer padNum = (Integer)uait.next();
                List padChoices = (List)this.requests.get(padNum);
                int pcsize = padChoices.size();
                for (int i = 0; i < pcsize; ++i) {
                    PadChoice pc = (PadChoice)padChoices.get(i);
                    if (pc.dot > topDot || currentTop == null) {
                        currentTop = pc;
                        topDot = pc.dot;
                        continue;
                    }
                    if (pc.dot != topDot) continue;
                    currentTop = this.breakDotTie(currentTop, pc);
                }
            }
            return currentTop;
        }

        PadChoice breakDotTie(PadChoice pc1, PadChoice pc2) {
            PadChoice next1 = this.findNextInLine(pc1);
            PadChoice next2 = this.findNextInLine(pc2);
            if (next1 != null && next2 != null) {
                if (next1.dot < next2.dot) {
                    return pc1;
                }
                if (next1.dot > next2.dot) {
                    return pc2;
                }
                return this.breakDotTie(next1, next2);
            }
            if (next1 == null && next2 == null) {
                int compVal = pc1.linkID.compareTo(pc2.linkID);
                return compVal < 0 ? pc1 : pc2;
            }
            return next1 == null ? pc1 : pc2;
        }
    }

    private class PadChoice {
        String linkID;
        int padNum;
        int choiceRank;
        double dot;

        PadChoice(String linkID, int padNum, int choiceRank, double dot) {
            this.linkID = linkID;
            this.padNum = padNum;
            this.choiceRank = choiceRank;
            this.dot = dot;
        }

        public String toString() {
            return "linkID = " + this.linkID + " padNum = " + this.padNum + " choiceRank = " + this.choiceRank + " dot = " + this.dot;
        }
    }

    private class PadModel {
        boolean sharedNamespaces;
        boolean canOverflow;
        Integer launchPad;
        TreeSet trgPads;
        TreeSet overflow;

        PadModel(String nodeID, Genome genome, Layout lo) {
            Database db = Database.getDB();
            Node node = genome.getNode(nodeID);
            INodeRenderer trgRenderer = NodeProperties.chooseRenderer(node.getNodeType(), lo.getLayoutType());
            this.sharedNamespaces = trgRenderer.sharedPadNamespaces();
            this.canOverflow = trgRenderer.landingPadsCanOverflow();
            int targMax = trgRenderer.getFixedLandingPadMax();
            this.trgPads = new TreeSet();
            for (int i = 0; i < targMax; ++i) {
                this.trgPads.add(new Integer(i));
            }
            if (this.canOverflow) {
                this.overflow = new TreeSet();
            }
            this.launchPad = null;
        }
    }

    private class DistanceRank
    implements Comparable {
        String id;
        double distance;

        DistanceRank(String id, double distance) {
            this.id = id;
            this.distance = distance;
        }

        public int compareTo(Object o) {
            DistanceRank other = (DistanceRank)o;
            double diff = this.distance - other.distance;
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return this.id.compareTo(other.id);
        }
    }

    private static class LinkTargPad {
        String linkID;
        String targID;
        int landPad;

        LinkTargPad(String linkID, String targID, int landPad) {
            this.linkID = linkID;
            this.targID = targID;
            this.landPad = landPad;
        }
    }

    public static class UpwardPadSyncData {
        HashMap sourcePadsPerNode_ = new HashMap();
        HashMap targetPadsPerNode_ = new HashMap();

        public void setForSource(String srcID, int launchPad, int weight) {
            int currWeight;
            Integer padKey;
            Integer weightForPad;
            HashMap<Integer, Integer> launches = (HashMap<Integer, Integer>)this.sourcePadsPerNode_.get(srcID);
            if (launches == null) {
                launches = new HashMap<Integer, Integer>();
                this.sourcePadsPerNode_.put(srcID, launches);
            }
            Integer nextWeight = (weightForPad = (Integer)launches.get(padKey = new Integer(launchPad))) == null ? new Integer(weight) : ((currWeight = weightForPad.intValue()) == Integer.MAX_VALUE ? weightForPad : new Integer(currWeight + weight));
            launches.put(padKey, nextWeight);
        }

        public void setForTarget(String linkID, String trgID, int landingPad) {
            ArrayList<LinkTargPad> landings = (ArrayList<LinkTargPad>)this.targetPadsPerNode_.get(trgID);
            if (landings == null) {
                landings = new ArrayList<LinkTargPad>();
                this.targetPadsPerNode_.put(trgID, landings);
            }
            landings.add(new LinkTargPad(linkID, trgID, landingPad));
        }
    }

    public static class IOFixup {
        String genomeID;
        String linkID;
        boolean isLaunchChange;
        int newPad;

        IOFixup(String genomeID, String linkID, boolean isLaunchChange, int newPad) {
            this.genomeID = genomeID;
            this.linkID = linkID;
            this.isLaunchChange = isLaunchChange;
            this.newPad = newPad;
        }
    }

    public static class PadResult {
        public int launch;
        public int landing;

        public PadResult(int launch, int landing) {
            this.launch = launch;
            this.landing = landing;
        }

        public String toString() {
            return "PadResult launch = " + this.launch + " landing = " + this.landing;
        }
    }
}

