/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.util.HashSet;
import java.util.Iterator;

public class PadConstraints {
    private boolean areForced_;
    private int forcedLaunch_;
    private int forcedLanding_;
    private HashSet usedLaunches_;
    private HashSet usedLandings_;

    public boolean arePadsForced() {
        return this.areForced_;
    }

    public int getForcedLaunch() {
        if (!this.areForced_) {
            throw new IllegalStateException();
        }
        return this.forcedLaunch_;
    }

    public int getForcedLanding() {
        if (!this.areForced_) {
            throw new IllegalStateException();
        }
        return this.forcedLanding_;
    }

    public void setForcedPads(int launchPad, int landingPad) {
        if (this.usedLaunches_ != null || this.usedLandings_ != null) {
            throw new IllegalStateException();
        }
        this.forcedLaunch_ = launchPad;
        this.forcedLanding_ = landingPad;
        this.areForced_ = true;
    }

    public Iterator getUsedLandingPads() {
        if (this.areForced_) {
            throw new IllegalStateException();
        }
        if (this.usedLandings_ == null) {
            return null;
        }
        return this.usedLandings_.iterator();
    }

    public Iterator getUsedLaunchPads() {
        if (this.areForced_) {
            throw new IllegalStateException();
        }
        if (this.usedLaunches_ == null) {
            return null;
        }
        return this.usedLaunches_.iterator();
    }

    public void addUsedLandingPad(int pad) {
        if (this.areForced_) {
            throw new IllegalStateException();
        }
        if (this.usedLandings_ == null) {
            this.usedLandings_ = new HashSet();
        }
        this.usedLandings_.add(new Integer(pad));
    }

    public void addUsedLaunchPad(int pad) {
        if (this.areForced_) {
            throw new IllegalStateException();
        }
        Integer newPad = new Integer(pad);
        if (this.usedLaunches_ == null) {
            this.usedLaunches_ = new HashSet();
            this.usedLaunches_.add(newPad);
        } else if (!this.usedLaunches_.contains(newPad)) {
            throw new IllegalStateException();
        }
    }
}

