/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import org.systemsbiology.biotapestry.cmd.BTUndoCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.event.EventManager;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PerturbationData;

public class PertDataChangeCmd
extends BTUndoCmd {
    private PertDataChange restore_;
    private boolean doEvent_;

    public PertDataChangeCmd(PertDataChange restore) {
        this.restore_ = restore;
        this.doEvent_ = false;
    }

    public PertDataChangeCmd(PertDataChange restore, boolean doEvent) {
        this.restore_ = restore;
        this.doEvent_ = doEvent;
    }

    public String getPresentationName() {
        return "Pert Change";
    }

    public void undo() {
        super.undo();
        Database db = Database.getDB();
        PerturbationData pd = db.getPertData();
        pd.changeUndo(this.restore_);
        if (this.doEvent_) {
            GeneralChangeEvent ev = new GeneralChangeEvent(2);
            EventManager.getManager().sendGeneralChangeEvent(ev);
        }
    }

    public void redo() {
        super.redo();
        Database db = Database.getDB();
        PerturbationData pd = db.getPertData();
        pd.changeRedo(this.restore_);
        if (this.doEvent_) {
            GeneralChangeEvent ev = new GeneralChangeEvent(2);
            EventManager.getManager().sendGeneralChangeEvent(ev);
        }
    }

    public static PertDataChangeCmd[] wrapChanges(PertDataChange[] restores) {
        PertDataChangeCmd[] retval = new PertDataChangeCmd[restores.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = new PertDataChangeCmd(restores[i]);
        }
        return retval;
    }
}

