/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.DeleteCommands;
import org.systemsbiology.biotapestry.cmd.GenomeChangeCmd;
import org.systemsbiology.biotapestry.cmd.GroupSettingChangeCmd;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.ModificationCommands;
import org.systemsbiology.biotapestry.cmd.NetOverlayChangeCmd;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.cmd.PertDataChangeCmd;
import org.systemsbiology.biotapestry.cmd.PropChangeCmd;
import org.systemsbiology.biotapestry.cmd.TemporalInputChangeCmd;
import org.systemsbiology.biotapestry.cmd.TimeCourseChangeCmd;
import org.systemsbiology.biotapestry.cmd.ToolCommands;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.event.LayoutChangeEvent;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleChange;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.nav.DataPopupManager;
import org.systemsbiology.biotapestry.nav.GroupSettingChange;
import org.systemsbiology.biotapestry.nav.GroupSettingManager;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.perturb.PertDataChange;
import org.systemsbiology.biotapestry.perturb.PertFilter;
import org.systemsbiology.biotapestry.perturb.PertFilterExpression;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputChange;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseChange;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.BusProperties;
import org.systemsbiology.biotapestry.ui.GenomePresentation;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Intersection;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LayoutOptionsManager;
import org.systemsbiology.biotapestry.ui.LinkProperties;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.LinkSegment;
import org.systemsbiology.biotapestry.ui.LinkSegmentID;
import org.systemsbiology.biotapestry.ui.NetModuleLinkageProperties;
import org.systemsbiology.biotapestry.ui.NetModuleProperties;
import org.systemsbiology.biotapestry.ui.NetOverlayProperties;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.NoteProperties;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.ui.SourceAndTargetSelector;
import org.systemsbiology.biotapestry.ui.dialogs.ChooseLinkToViewDialog;
import org.systemsbiology.biotapestry.ui.dialogs.EditModuleMemberDialog;
import org.systemsbiology.biotapestry.ui.dialogs.GenePropertiesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.GroupPropertiesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.LinkPropertiesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.LinkSegmentSpecialPropsDialog;
import org.systemsbiology.biotapestry.ui.dialogs.MultiSelectionPropertiesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.NetModulePropertiesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.NodePropertiesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.NotePropertiesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.PathDialog;
import org.systemsbiology.biotapestry.ui.dialogs.PerturbExpressionEntryDialog;
import org.systemsbiology.biotapestry.ui.dialogs.SimulationPropertiesDialog;
import org.systemsbiology.biotapestry.ui.dialogs.SuperAddTargetDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TemporalInputDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TemporalInputMappingDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TemporalInputRegionMappingDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TimeCourseEntryDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TimeCourseMappingDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TimeCourseRegionMappingTableDialog;
import org.systemsbiology.biotapestry.ui.dialogs.TimeCourseSetupDialog;
import org.systemsbiology.biotapestry.ui.dialogs.pertManage.PertMappingDialog;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleFree;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BackgroundWorker;
import org.systemsbiology.biotapestry.util.BackgroundWorkerClient;
import org.systemsbiology.biotapestry.util.BackgroundWorkerOwner;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class PopCommands {
    private static final int IS_FOR_TARGET_ = 0;
    private static final int IS_FOR_SOURCE_ = 1;
    private static final int IS_FOR_SWAP_ = 2;
    private String layout_;
    private String genomeKey_;
    private SUPanel suPanel_;
    private CommonView cView_;
    private Point2D popupPoint_;
    private UndoManager undom_;
    private GenomePresentation myGenomePre_;
    private JFrame parent_;
    private Intersection intersected_;
    private Point absScreen_;
    private boolean includeLinks_;
    private boolean appendToCurrent_;
    private boolean includeQueryNode_;

    public PopCommands(JFrame parent, CommonView cView, SUPanel suPanel, UndoManager undo, GenomePresentation pre) {
        this.undom_ = undo;
        this.cView_ = cView;
        this.suPanel_ = suPanel;
        this.myGenomePre_ = pre;
        this.parent_ = parent;
        this.includeLinks_ = true;
        this.includeQueryNode_ = true;
        this.appendToCurrent_ = false;
    }

    public void setLayout(String layout) {
        this.layout_ = layout;
    }

    public void setGenome(String genome) {
        this.genomeKey_ = genome;
    }

    public void setPopup(Point2D popupPoint) {
        this.popupPoint_ = popupPoint;
    }

    public void setIntersection(Intersection intersect) {
        this.intersected_ = intersect;
    }

    public void setAbsScreenPoint(Point absScreen) {
        this.absScreen_ = absScreen;
    }

    public void actionPerformedForTargetOrSource(int type, boolean forModules) {
        if (!this.amIValidForTargetOrSource(this.intersected_, type, forModules)) {
            return;
        }
        Database db = Database.getDB();
        Layout layout = db.getLayout(this.layout_);
        if (type == 0) {
            this.suPanel_.setToMode(forModules ? 22 : 15, this.intersected_);
        } else if (type == 1) {
            this.suPanel_.setToMode(forModules ? 23 : 16, this.intersected_);
        } else {
            String oid = this.intersected_.getObjectID();
            Genome genome = db.getGenome(this.genomeKey_);
            LinkSegmentID[] ids = this.intersected_.segmentIDsFromIntersect();
            String linkID = layout.segmentSynonymousWithTargetDrop(oid, ids[0], genome);
            boolean startOK = layout.segmentSynonymousWithStartDrop(oid, ids[0], genome);
            int swapMode = 0;
            if (linkID != null && startOK) {
                swapMode = ids[0].isForEndDrop() ? 1 : (ids[0].isForStartDrop() ? 2 : 3);
            } else if (linkID != null) {
                swapMode = 1;
            } else if (startOK) {
                swapMode = 2;
            } else {
                throw new IllegalStateException();
            }
            this.suPanel_.setToMode(17, new SUPanel.SwapPadArgs(swapMode, this.intersected_));
        }
    }

    private boolean amIValidForTargetOrSource(Intersection selected, int type, boolean forModules) {
        GenomeInstance parent;
        if (selected == null) {
            return false;
        }
        String oid = selected.getObjectID();
        if (oid == null) {
            return false;
        }
        LinkSegmentID[] ids = selected.segmentIDsFromIntersect();
        if (ids == null) {
            return false;
        }
        if (ids.length != 1) {
            return false;
        }
        Database db = Database.getDB();
        Layout layout = db.getLayout(this.layout_);
        String ovrID = this.suPanel_.getCurrentOverlay();
        FontRenderContext frc = this.myGenomePre_.getFontRenderContext();
        Genome genome = db.getGenome(this.genomeKey_);
        if (genome instanceof GenomeInstance && (parent = ((GenomeInstance)genome).getVfgParent()) != null) {
            return false;
        }
        if (forModules) {
            if (type == 0) {
                String targDrop = layout.segmentSynonymousWithModLinkTargetDrop(oid, ids[0], ovrID);
                if (targDrop == null) {
                    return false;
                }
                HashSet<String> allLinks = new HashSet<String>();
                allLinks.add(targDrop);
                if (!this.haveModLinkDOFs(this.genomeKey_, layout, allLinks, ovrID, frc)) {
                    return false;
                }
            } else if (type == 1) {
                Set allLinks = layout.segmentSynonymousWithModLinkStartDrop(oid, ids[0], this.suPanel_.getCurrentOverlay());
                if (allLinks == null) {
                    return false;
                }
                if (!this.haveModLinkDOFs(this.genomeKey_, layout, allLinks, ovrID, frc)) {
                    return false;
                }
            } else {
                throw new IllegalArgumentException();
            }
            return true;
        }
        if (type == 0) {
            if (layout.segmentSynonymousWithTargetDrop(oid, ids[0], genome) == null) {
                return false;
            }
            if (!this.haveTargetDOFs(genome, layout, oid)) {
                return false;
            }
        } else if (type == 1) {
            if (!layout.segmentSynonymousWithStartDrop(oid, ids[0], genome)) {
                return false;
            }
            if (!this.haveSourceDOFs(genome, layout, oid)) {
                return false;
            }
        } else if (type == 2) {
            String trg;
            Linkage link;
            String src;
            String linkID = layout.segmentSynonymousWithTargetDrop(oid, ids[0], genome);
            boolean startOK = layout.segmentSynonymousWithStartDrop(oid, ids[0], genome);
            if (linkID == null && !startOK) {
                return false;
            }
            boolean haveDOF = false;
            if (linkID != null && this.haveTargetDOFs(genome, layout, oid)) {
                haveDOF = true;
            }
            if (!haveDOF && startOK && this.haveSourceDOFs(genome, layout, oid)) {
                haveDOF = true;
            }
            if (!haveDOF) {
                return false;
            }
            if (linkID != null && startOK && !ids[0].isForEndDrop() && !ids[0].isForStartDrop() && (src = (link = genome.getLinkage(linkID)).getSource()).equals(trg = link.getTarget())) {
                return false;
            }
        } else {
            throw new IllegalArgumentException();
        }
        return true;
    }

    private boolean haveSourceDOFs(Genome genome, Layout layout, String linkID) {
        Linkage link = genome.getLinkage(linkID);
        String source = link.getSource();
        NodeProperties np = layout.getNodeProperties(source);
        INodeRenderer rend = np.getRenderer();
        boolean shared = rend.sharedPadNamespaces();
        int launchMax = rend.getFixedLaunchPadMax();
        return launchMax != 1 || shared;
    }

    private boolean haveTargetDOFs(Genome genome, Layout layout, String linkID) {
        Linkage link = genome.getLinkage(linkID);
        String target = link.getTarget();
        NodeProperties np = layout.getNodeProperties(target);
        Node targNode = genome.getNode(target);
        INodeRenderer rend = np.getRenderer();
        boolean shared = rend.sharedPadNamespaces();
        int numPads = targNode.getPadCount();
        return numPads != 1 || shared;
    }

    private boolean haveModLinkDOFs(String genomeKey, Layout layout, Set linkIDs, String ovrKey, FontRenderContext frc) {
        Database db = Database.getDB();
        NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(genomeKey);
        DynamicInstanceProxy dip = owner.overlayModeForOwner() == 2 ? (DynamicInstanceProxy)owner : null;
        NetworkOverlay nov = owner.getNetworkOverlay(ovrKey);
        Iterator lit = linkIDs.iterator();
        boolean noFeedBacks = true;
        String linkSrc = null;
        while (lit.hasNext()) {
            String linkID = (String)lit.next();
            NetModuleLinkage link = nov.getLinkage(linkID);
            linkSrc = link.getSource();
            if (!linkSrc.equals(link.getTarget())) continue;
            noFeedBacks = false;
            break;
        }
        if (noFeedBacks) {
            return true;
        }
        NetModule mod = nov.getModule(linkSrc);
        NetOverlayProperties nop = layout.getNetOverlayProperties(ovrKey);
        NetModuleProperties nmp = nop.getNetModuleProperties(linkSrc);
        Genome useGenome = db.getGenome(genomeKey);
        if (useGenome instanceof GenomeInstance) {
            GenomeInstance gi = (GenomeInstance)useGenome;
            GenomeInstance rootGI = gi.getVfgParentRoot();
            useGenome = rootGI == null ? gi : rootGI;
        }
        Set useGroups = owner.getGroupsForOverlayRendering();
        int pads = nmp.getRenderer().getPadCountForModule(useGenome, dip, useGroups, mod, layout, ovrKey, nmp, frc);
        return pads > 2;
    }

    static class ChoiceMap {
        String description;
        Object item;

        ChoiceMap(String desc, Object item) {
            this.description = desc;
            this.item = item;
        }

        public String toString() {
            return this.description;
        }
    }

    public class DeleteTemporalInputRegionMapAction
    extends AbstractAction {
        private String groupID_;

        public DeleteTemporalInputRegionMapAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public DeleteTemporalInputRegionMapAction(String groupID, String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.groupID_ = groupID;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TemporalInputChange tichg;
                String gid = this.groupID_;
                if (this.groupID_ == null && PopCommands.this.intersected_ != null) {
                    gid = PopCommands.this.intersected_.getObjectID();
                }
                if (gid == null) {
                    return;
                }
                gid = Group.getBaseID(gid);
                Database db = Database.getDB();
                TemporalInputRangeData tird = db.getTemporalInputRangeData();
                if (tird != null && (tichg = tird.dropGroupMap(gid)) != null) {
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteTIRM");
                    TemporalInputChangeCmd cmd = new TemporalInputChangeCmd(tichg, false);
                    support.addEdit(cmd);
                    support.addEvent(new GeneralChangeEvent(2));
                    support.finish();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteTimeCourseRegionMapAction
    extends AbstractAction {
        private String groupID_;

        public DeleteTimeCourseRegionMapAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public DeleteTimeCourseRegionMapAction(String groupID, String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.groupID_ = groupID;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TimeCourseChange tchg;
                String gid = this.groupID_;
                if (this.groupID_ == null && PopCommands.this.intersected_ != null) {
                    gid = PopCommands.this.intersected_.getObjectID();
                }
                if (gid == null) {
                    return;
                }
                gid = Group.getBaseID(gid);
                Database db = Database.getDB();
                TimeCourseData tcd = db.getTimeCourseData();
                if (tcd != null && (tchg = tcd.dropGroupMap(gid)) != null) {
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteTCRM");
                    TimeCourseChangeCmd cmd = new TimeCourseChangeCmd(tchg, false);
                    support.addEdit(cmd);
                    support.addEvent(new GeneralChangeEvent(2));
                    support.finish();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteTemporalInputMapAction
    extends AbstractAction {
        public DeleteTemporalInputMapAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    TemporalInputRangeData tird;
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    if ((tird = db.getTemporalInputRangeData()) != null) {
                        TemporalInputChange chg2;
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteTIM");
                        TemporalInputChange chg1 = tird.dropDataEntryKeys(id);
                        if (chg1 != null) {
                            support.addEdit(new TemporalInputChangeCmd(chg1, false));
                        }
                        if ((chg2 = tird.dropDataSourceKeys(id)) != null) {
                            support.addEdit(new TemporalInputChangeCmd(chg2, false));
                        }
                        if (chg1 != null || chg1 != null) {
                            support.addEvent(new GeneralChangeEvent(2));
                            support.finish();
                        }
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteTemporalInputAction
    extends AbstractAction {
        public DeleteTemporalInputAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    TemporalInputRangeData tird;
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    if ((tird = db.getTemporalInputRangeData()) != null) {
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteTIDat");
                        ArrayList mapped = tird.getTemporalInputRangeEntryKeysWithDefault(id);
                        mapped = mapped == null ? new ArrayList() : new ArrayList(mapped);
                        Iterator mit = mapped.iterator();
                        while (mit.hasNext()) {
                            String name = (String)mit.next();
                            TemporalInputChange[] changes = tird.dropMapsTo(name);
                            for (int j = 0; j < changes.length; ++j) {
                                support.addEdit(new TemporalInputChangeCmd(changes[j]));
                            }
                            TemporalInputChange tcc = tird.dropEntry(name);
                            support.addEdit(new TemporalInputChangeCmd(tcc));
                        }
                        support.addEvent(new GeneralChangeEvent(2));
                        support.finish();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class EditTemporalInputMapAction
    extends AbstractAction {
        public EditTemporalInputMapAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    TemporalInputRangeData tird = db.getTemporalInputRangeData();
                    if (genome instanceof GenomeInstance) {
                        genome = ((GenomeInstance)genome).getGenome();
                    }
                    TemporalInputMappingDialog timd = new TemporalInputMappingDialog(PopCommands.this.parent_, node.getName(), id, PopCommands.this.undom_);
                    timd.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteTimeCourseMapAction
    extends AbstractAction {
        public DeleteTimeCourseMapAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    TimeCourseData tcd;
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    if ((tcd = db.getTimeCourseData()) != null) {
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteTCM");
                        TimeCourseChange tchg = tcd.dropDataKeys(id);
                        if (tchg != null) {
                            TimeCourseChangeCmd cmd = new TimeCourseChangeCmd(tchg, false);
                            support.addEdit(cmd);
                            support.addEvent(new GeneralChangeEvent(2));
                            support.finish();
                        }
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteTimeCourseAction
    extends AbstractAction {
        public DeleteTimeCourseAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    TimeCourseData tcd;
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    if ((tcd = db.getTimeCourseData()) != null) {
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteTCDat");
                        ArrayList mapped = tcd.getTimeCourseTCMDataKeysWithDefault(id);
                        mapped = mapped == null ? new ArrayList() : TimeCourseData.TCMapping.cloneAList(mapped);
                        Iterator mit = mapped.iterator();
                        while (mit.hasNext()) {
                            TimeCourseData.TCMapping tcm = (TimeCourseData.TCMapping)mit.next();
                            TimeCourseChange[] changes = tcd.dropMapsTo(tcm.name);
                            for (int j = 0; j < changes.length; ++j) {
                                support.addEdit(new TimeCourseChangeCmd(changes[j]));
                            }
                            TimeCourseChange tcc = tcd.dropGene(tcm.name);
                            support.addEdit(new TimeCourseChangeCmd(tcc));
                        }
                        support.addEvent(new GeneralChangeEvent(2));
                        support.finish();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class EditTimeCourseMapAction
    extends AbstractAction {
        public EditTimeCourseMapAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    TimeCourseData tcd = db.getTimeCourseData();
                    TimeCourseMappingDialog tcmd = new TimeCourseMappingDialog(PopCommands.this.parent_, node.getName(), id);
                    tcmd.setVisible(true);
                    if (!tcmd.haveResult()) {
                        return;
                    }
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.tcmd");
                    List entries = tcmd.getEntryList();
                    TimeCourseChange tcc = tcd.addTimeCourseTCMMap(id, entries, true);
                    if (tcc != null) {
                        support.addEdit(new TimeCourseChangeCmd(tcc));
                    }
                    support.addEvent(new GeneralChangeEvent(2));
                    support.finish();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeletePertMapAction
    extends AbstractAction {
        public DeletePertMapAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    PerturbationData pd;
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    if ((pd = db.getPertData()) != null) {
                        PertDataChange chg2;
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteQPCRM");
                        PertDataChange chg1 = pd.dropDataEntryKeys(id);
                        if (chg1 != null) {
                            support.addEdit(new PertDataChangeCmd(chg1, false));
                        }
                        if ((chg2 = pd.dropDataSourceKeys(id)) != null) {
                            support.addEdit(new PertDataChangeCmd(chg2, false));
                        }
                        if (chg1 != null || chg1 != null) {
                            support.addEvent(new GeneralChangeEvent(2));
                            support.finish();
                        }
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeletePertAction
    extends AbstractAction {
        public DeletePertAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    PerturbationData pd;
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    if ((pd = db.getPertData()) != null) {
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteQPCRDat");
                        ArrayList mapped = pd.getDataEntryKeysWithDefault(id);
                        mapped = mapped == null ? new ArrayList() : new ArrayList(mapped);
                        Iterator mit = mapped.iterator();
                        while (mit.hasNext()) {
                            String entryID = (String)mit.next();
                            PertDataChange[] changes = pd.dropDanglingMapsForEntry(entryID);
                            support.addEdits(PertDataChangeCmd.wrapChanges(changes));
                            PertFilter targFilter = new PertFilter(5, 0, entryID);
                            PertFilterExpression pfe = new PertFilterExpression(targFilter);
                            PertDataChange dc = pd.dropPertDataForFilter(pfe);
                            support.addEdit(new PertDataChangeCmd(dc));
                        }
                        support.addEvent(new GeneralChangeEvent(3));
                        support.finish();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class EditTemporalInputAction
    extends AbstractAction {
        public EditTemporalInputAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    TemporalInputDialog tid;
                    List keys;
                    boolean waiting;
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    TemporalInputRangeData tird = db.getTemporalInputRangeData();
                    if (genome instanceof GenomeInstance) {
                        genome = ((GenomeInstance)genome).getGenome();
                    }
                    boolean hasInputs = ((DBGenome)genome).nodeHasInputs(id);
                    List targets = null;
                    if (!hasInputs && (targets = ((DBGenome)genome).getNodeTargetNames(id, true)).isEmpty()) {
                        ResourceManager rMan = ResourceManager.getManager();
                        int result = JOptionPane.showConfirmDialog(PopCommands.this.parent_, rMan.getString("tirdNoTargets.message"), rMan.getString("tirdNoTargets.title"), 0);
                        if (result == -1 || result == 1) {
                            return;
                        }
                    }
                    boolean bl = waiting = (keys = tird.getTemporalInputRangeEntryKeysWithDefault(id)) == null || keys.isEmpty();
                    if (waiting) {
                        while (waiting) {
                            TemporalInputMappingDialog timd = new TemporalInputMappingDialog(PopCommands.this.parent_, node.getName(), id, PopCommands.this.undom_);
                            timd.setVisible(true);
                            if (timd.wasCancelled()) {
                                return;
                            }
                            keys = tird.getCustomTemporalInputRangeEntryKeys(id);
                            waiting = keys == null || keys.isEmpty();
                            if (!waiting) continue;
                            ResourceManager rMan = ResourceManager.getManager();
                            JOptionPane.showMessageDialog(PopCommands.this.parent_, rMan.getString("tirdNoKey.message"), rMan.getString("tirdNoKey.title"), 0);
                        }
                    }
                    if (!hasInputs) {
                        ResourceManager rMan = ResourceManager.getManager();
                        int result = JOptionPane.showConfirmDialog(PopCommands.this.parent_, rMan.getString("tirdNoInputs.message"), rMan.getString("tirdNoInputs.title"), 0);
                        if (result == -1 || result == 1) {
                            return;
                        }
                    }
                    if ((tid = TemporalInputDialog.temporalInputDialogWrapper((JFrame)PopCommands.this.parent_, (List)keys, (boolean)false, (UndoManager)PopCommands.this.undom_)) != null) {
                        tid.setVisible(true);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class TemporalInputRegionMappingAction
    extends AbstractAction {
        String groupID_;

        public TemporalInputRegionMappingAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public TemporalInputRegionMappingAction(String groupID, String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.groupID_ = groupID;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String gid = this.groupID_;
                Database db = Database.getDB();
                GenomeInstance gi = (GenomeInstance)db.getGenome(PopCommands.this.genomeKey_);
                if (this.groupID_ == null && PopCommands.this.intersected_ != null) {
                    gid = PopCommands.this.intersected_.getObjectID();
                }
                if (gid == null) {
                    return;
                }
                gid = Group.getBaseID(gid);
                GenomeInstance root = gi.getVfgParentRoot();
                Group group = root == null ? gi.getGroup(gid) : root.getGroup(gid);
                TemporalInputRegionMappingDialog tirmd = new TemporalInputRegionMappingDialog(PopCommands.this.parent_, gid, group.getName(), PopCommands.this.undom_);
                tirmd.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class TimeCourseRegionMappingAction
    extends AbstractAction {
        private String groupID_;

        public TimeCourseRegionMappingAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public TimeCourseRegionMappingAction(String groupID, String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.groupID_ = groupID;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String gid = this.groupID_;
                if (this.groupID_ == null && PopCommands.this.intersected_ != null) {
                    gid = PopCommands.this.intersected_.getObjectID();
                }
                if (gid == null) {
                    return;
                }
                Database db = Database.getDB();
                TimeCourseData tcd = db.getTimeCourseData();
                if (!tcd.hasGeneTemplate()) {
                    TimeCourseSetupDialog tcsd = TimeCourseSetupDialog.timeSourceSetupDialogWrapper((JFrame)PopCommands.this.parent_, (UndoManager)PopCommands.this.undom_);
                    if (tcsd == null) {
                        return;
                    }
                    tcsd.setVisible(true);
                    if (!tcd.hasGeneTemplate()) {
                        ResourceManager rMan = ResourceManager.getManager();
                        JOptionPane.showMessageDialog(PopCommands.this.parent_, rMan.getString("tcdNoTemplate.message"), rMan.getString("tcdNoTemplate.title"), 0);
                        return;
                    }
                }
                GenomeInstance gi = (GenomeInstance)db.getGenome(PopCommands.this.genomeKey_);
                gid = Group.getBaseID(gid);
                GenomeInstance root = gi.getVfgParentRoot();
                Group group = root == null ? gi.getGroup(gid) : root.getGroup(gid);
                TimeCourseRegionMappingTableDialog tcrmd = new TimeCourseRegionMappingTableDialog(PopCommands.this.parent_, gid, group.getName(), PopCommands.this.undom_);
                tcrmd.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class EditPerturbedTimeCourseAction
    extends AbstractAction {
        public EditPerturbedTimeCourseAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    TimeCourseData tcd = db.getTimeCourseData();
                    List keys = tcd.getTimeCourseTCMDataKeysWithDefault(id);
                    PerturbExpressionEntryDialog tced = PerturbExpressionEntryDialog.perturbExpressionEntryDialogWrapper((JFrame)PopCommands.this.parent_, (List)keys, (boolean)false, (UndoManager)PopCommands.this.undom_);
                    if (tced != null) {
                        tced.setVisible(true);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            Database db = Database.getDB();
            TimeCourseData tcd = db.getTimeCourseData();
            String nodeID = PopCommands.this.intersected_.getObjectID();
            return tcd.haveDataForNode(GenomeItemInstance.getBaseID(nodeID));
        }
    }

    public class EditTimeCourseAction
    extends AbstractAction {
        public EditTimeCourseAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    List keys;
                    boolean waiting;
                    TimeCourseData tcd;
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    if (!(tcd = db.getTimeCourseData()).hasGeneTemplate()) {
                        TimeCourseSetupDialog tcsd = TimeCourseSetupDialog.timeSourceSetupDialogWrapper((JFrame)PopCommands.this.parent_, (UndoManager)PopCommands.this.undom_);
                        if (tcsd == null) {
                            return;
                        }
                        tcsd.setVisible(true);
                        if (!tcd.hasGeneTemplate()) {
                            ResourceManager rMan = ResourceManager.getManager();
                            JOptionPane.showMessageDialog(PopCommands.this.parent_, rMan.getString("tcdNoTemplate.message"), rMan.getString("tcdNoTemplate.title"), 0);
                            return;
                        }
                    }
                    boolean bl = waiting = (keys = tcd.getTimeCourseTCMDataKeysWithDefault(id)) == null || keys.isEmpty();
                    if (waiting) {
                        while (waiting) {
                            TimeCourseMappingDialog tcmd = new TimeCourseMappingDialog(PopCommands.this.parent_, node.getName(), id);
                            tcmd.setVisible(true);
                            if (!tcmd.haveResult()) {
                                return;
                            }
                            UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.tcmd");
                            List entries = tcmd.getEntryList();
                            TimeCourseChange tcc = tcd.addTimeCourseTCMMap(id, entries, true);
                            if (tcc != null) {
                                support.addEdit(new TimeCourseChangeCmd(tcc));
                            }
                            support.addEvent(new GeneralChangeEvent(2));
                            support.finish();
                            keys = tcd.getCustomTCMTimeCourseDataKeys(id);
                            waiting = keys == null || keys.isEmpty();
                            if (!waiting) continue;
                            ResourceManager rMan = ResourceManager.getManager();
                            JOptionPane.showMessageDialog(PopCommands.this.parent_, rMan.getString("tcdNoKey.message"), rMan.getString("tcdNoKey.title"), 0);
                        }
                    }
                    TimeCourseEntryDialog tced = new TimeCourseEntryDialog(PopCommands.this.parent_, keys, false, PopCommands.this.undom_);
                    tced.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class EditPertMapAction
    extends AbstractAction {
        public EditPertMapAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    this.doItGuts(db, node, id);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean doItGuts(Database db, Node node, String id) {
            PerturbationData pd = db.getPertData();
            List entries = pd.getCustomDataEntryKeys(id);
            List srcEntries = pd.getCustomDataSourceKeys(id);
            PertMappingDialog qmd = new PertMappingDialog(PopCommands.this.parent_, node.getName(), entries, srcEntries);
            qmd.setVisible(true);
            if (qmd.haveResult()) {
                UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.qmd");
                List eList = qmd.getEntryList();
                PertDataChange pdc = pd.setEntryMap(id, eList);
                PertDataChangeCmd pdcc = new PertDataChangeCmd(pdc);
                support.addEdit(pdcc);
                List sList = qmd.getSourceList();
                pdc = pd.setSourceMap(id, sList);
                pdcc = new PertDataChangeCmd(pdc);
                support.addEdit(pdcc);
                GeneralChangeEvent gcev = new GeneralChangeEvent(2);
                support.addEvent(gcev);
                support.finish();
                return true;
            }
            return false;
        }
    }

    public class EditPertAction
    extends AbstractAction {
        public EditPertAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    PerturbationData pd;
                    List keys;
                    Database db = Database.getDB();
                    String id = PopCommands.this.intersected_.getObjectID();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Node node = genome.getNode(id);
                    if (node instanceof NodeInstance) {
                        id = ((NodeInstance)node).getBacking().getID();
                    }
                    if ((keys = (pd = db.getPertData()).getDataEntryKeysWithDefault(id)).isEmpty()) {
                        EditPertMapAction epma = new EditPertMapAction("foo", 'f');
                        while (keys.isEmpty()) {
                            if (!epma.doItGuts(db, node, id)) {
                                return;
                            }
                            List cek = pd.getCustomDataEntryKeys(id);
                            if (cek == null) continue;
                            keys.addAll(cek);
                        }
                    }
                    PertFilterExpression pfe = null;
                    int numKeys = keys.size();
                    for (int i = 0; i < numKeys; ++i) {
                        String key = (String)keys.get(i);
                        PertFilter targFilter = new PertFilter(5, 0, key);
                        pfe = pfe == null ? new PertFilterExpression(targFilter) : new PertFilterExpression(4, pfe, targFilter);
                    }
                    MainCommands.getCmds().launchPerturbationsManagementWindow(pfe);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DisplayLinkDataAction
    extends AbstractAction {
        public DisplayLinkDataAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    String linkID;
                    LinkSegmentID segID;
                    Database db = Database.getDB();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Layout layout = db.getLayout(PopCommands.this.layout_);
                    BusProperties lp = layout.getLinkProperties(PopCommands.this.intersected_.getObjectID());
                    Set resolved = lp.resolveLinkagesThroughSegment(segID = PopCommands.this.intersected_.segmentIDFromIntersect(), genome);
                    if (resolved.size() > 1) {
                        boolean isRoot = genome instanceof DBGenome;
                        ChooseLinkToViewDialog cltv = new ChooseLinkToViewDialog(PopCommands.this.parent_, PopCommands.this.genomeKey_, resolved, isRoot);
                        cltv.setVisible(true);
                        if (!cltv.haveResult()) {
                            return;
                        }
                        linkID = cltv.getLink();
                    } else {
                        linkID = (String)resolved.iterator().next();
                    }
                    DataPopupManager.getPopupMgr().popupLinkData(PopCommands.this.genomeKey_, linkID);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DisplayDataAction
    extends AbstractAction {
        public DisplayDataAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    String id = PopCommands.this.intersected_.getObjectID();
                    DataPopupManager.getPopupMgr().popupData(PopCommands.this.genomeKey_, id);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class IncludeSubGroupAction
    extends AbstractAction {
        private String parentGroup_;
        private String baseSubKey_;

        public IncludeSubGroupAction(String parentGroup, String baseSubKey, String text) {
            super(text);
            this.parentGroup_ = parentGroup;
            this.baseSubKey_ = baseSubKey;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                AddCommands ac = new AddCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                ac.includeSubGroup(PopCommands.this.genomeKey_, this.parentGroup_, this.baseSubKey_);
                PopCommands.this.suPanel_.repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class ActivateSubGroupAction
    extends AbstractAction {
        private String parentGroup_;
        private String baseSubKey_;

        public ActivateSubGroupAction(String parentGroup, String baseSubKey, String text) {
            super(text);
            this.parentGroup_ = parentGroup;
            this.baseSubKey_ = baseSubKey;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                AddCommands ac = new AddCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                ac.makeSubGroupActive(PopCommands.this.genomeKey_, this.parentGroup_, this.baseSubKey_, null);
                PopCommands.this.suPanel_.repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteNodeFromSubGroupAction
    extends AbstractAction {
        private NodeInstance ni_;
        private Group group_;

        public DeleteNodeFromSubGroupAction(NodeInstance ni, Group group, String text) {
            super(text);
            this.ni_ = ni;
            this.group_ = group;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                GenomeInstance gi = (GenomeInstance)db.getGenome(PopCommands.this.genomeKey_);
                DeleteCommands dc = new DeleteCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteNodeFromSubGroup");
                if (dc.deleteNodeFromSubGroup(gi, this.group_, this.ni_, support)) {
                    support.finish();
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class AddNodeToSubGroupAction
    extends AbstractAction {
        private NodeInstance ni_;
        private Group group_;

        public AddNodeToSubGroupAction(NodeInstance ni, Group group, String text) {
            super(text);
            this.ni_ = ni;
            this.group_ = group;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                GenomeInstance gi = (GenomeInstance)db.getGenome(PopCommands.this.genomeKey_);
                AddCommands ac = new AddCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                ac.addNodeToSubGroup(gi, this.group_, this.ni_);
                PopCommands.this.suPanel_.repaint();
                return;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return;
            }
        }
    }

    public class CopyGroupAction
    extends AbstractAction {
        public CopyGroupAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Genome genome;
                    Database db = Database.getDB();
                    if (db.haveBuildInstructions()) {
                        ResourceManager rMan = ResourceManager.getManager();
                        JOptionPane.showMessageDialog(PopCommands.this.parent_, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
                    }
                    if ((genome = db.getGenome(PopCommands.this.genomeKey_)) instanceof GenomeInstance) {
                        Group group = ((GenomeInstance)genome).getGroup(PopCommands.this.intersected_.getObjectID());
                        String groupRef = group.getID();
                        AddCommands ac = new AddCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                        ac.duplicateRegion(PopCommands.this.genomeKey_, PopCommands.this.layout_, groupRef, PopCommands.this.myGenomePre_.getFontRenderContext());
                        PopCommands.this.suPanel_.repaint();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteSubGroupAction
    extends AbstractAction {
        private Group group_;
        private boolean forDeactivation_;

        public DeleteSubGroupAction(Group group, String text, boolean forDeactivation, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.group_ = group;
            this.forDeactivation_ = forDeactivation;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                if (genome instanceof GenomeInstance) {
                    Group parentModelGroup;
                    GenomeInstance gi = (GenomeInstance)genome;
                    GenomeInstance parentGi = null;
                    Group parentGroup = null;
                    if (this.forDeactivation_ && (parentModelGroup = (parentGi = gi.getVfgParent()).getGroup(Group.removeGeneration(this.group_.getID()))).isUsingParent()) {
                        String parentGroupID = this.group_.getParentGroup(gi);
                        parentGroup = gi.getGroup(parentGroupID);
                    }
                    DeleteCommands dc = new DeleteCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteSubgroup");
                    if (!dc.deleteSubGroupFromModel(this.group_.getID(), PopCommands.this.genomeKey_, support)) {
                        return;
                    }
                    if (parentGroup != null) {
                        dc.deleteGroupFromModel(parentGroup.getID(), PopCommands.this.genomeKey_, PopCommands.this.layout_, support, false, PopCommands.this.myGenomePre_.getFontRenderContext());
                    }
                    support.finish();
                }
                PopCommands.this.suPanel_.repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class CreateSubGroupAction
    extends AbstractAction {
        public CreateSubGroupAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db;
                Genome genome;
                if (PopCommands.this.intersected_ != null && (genome = (db = Database.getDB()).getGenome(PopCommands.this.genomeKey_)) instanceof GenomeInstance) {
                    GenomeInstance gi = (GenomeInstance)genome;
                    AddCommands pendingAdd = new AddCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    if (!pendingAdd.createSubGroupInGroup(PopCommands.this.intersected_.getObjectID(), PopCommands.this.layout_, gi)) {
                        pendingAdd = null;
                        return;
                    }
                    PopCommands.this.suPanel_.setToMode(14, pendingAdd);
                    PopCommands.this.suPanel_.getCursorMgr().showModeCursor();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteNodeAction
    extends AbstractAction {
        public DeleteNodeAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    DeleteCommands dc = new DeleteCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    dc.deleteWarningHelper(PopCommands.this.genomeKey_, PopCommands.this.parent_);
                    ModificationCommands mc = new ModificationCommands();
                    FontRenderContext frc = PopCommands.this.myGenomePre_.getFontRenderContext();
                    Map globalPadNeeds = mc.getGlobalNetModuleLinkPadNeeds(frc);
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteNode");
                    if (dc.deleteNodeFromModel(PopCommands.this.intersected_, PopCommands.this.genomeKey_, support, 0, false) != 0) {
                        PopCommands.this.myGenomePre_.clearSelections(PopCommands.this.genomeKey_, PopCommands.this.layout_, support);
                        if (globalPadNeeds != null) {
                            mc.repairNetModuleLinkPadsGlobally(globalPadNeeds, frc, false, support);
                        }
                        support.addEvent(new ModelChangeEvent(PopCommands.this.genomeKey_, 1));
                        support.finish();
                        PopCommands.this.suPanel_.repaint();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class EditNoteAction
    extends AbstractAction {
        public EditNoteAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Layout layout = db.getLayout(PopCommands.this.layout_);
                    String noteID = PopCommands.this.intersected_.getObjectID();
                    Note noteToEdit = genome.getNote(noteID);
                    NoteProperties nprop = layout.getNoteProperties(noteID);
                    NotePropertiesDialog ncd = new NotePropertiesDialog(PopCommands.this.parent_, noteToEdit, nprop, PopCommands.this.undom_);
                    ncd.show();
                    if (!ncd.haveResult()) {
                        return;
                    }
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.noteEdit");
                    GenomeChange gc = genome.changeNote(noteToEdit, ncd.getName(), ncd.getText(), ncd.getIsInteractive());
                    if (gc != null) {
                        GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                        support.addEdit(gcc);
                        support.addEvent(new ModelChangeEvent(PopCommands.this.genomeKey_, 1));
                    }
                    NoteProperties newProps = (NoteProperties)nprop.clone();
                    newProps.setColor(ncd.getColor());
                    newProps.setFontOverride(ncd.getFontOverride());
                    newProps.setJustification(ncd.getJustification());
                    Layout.PropChange lpc = layout.replaceNoteProperties(noteID, newProps);
                    if (lpc != null) {
                        PropChangeCmd mov = new PropChangeCmd(lpc);
                        support.addEdit(mov);
                        support.addEvent(new LayoutChangeEvent(PopCommands.this.layout_, 1));
                    }
                    support.finish();
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteNoteAction
    extends AbstractAction {
        public DeleteNoteAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    DeleteCommands dc = new DeleteCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteNote");
                    if (dc.deleteNote(PopCommands.this.intersected_, PopCommands.this.genomeKey_, support)) {
                        PopCommands.this.myGenomePre_.clearSelections(PopCommands.this.genomeKey_, PopCommands.this.layout_, support);
                        PopCommands.this.suPanel_.repaint();
                        support.addEvent(new ModelChangeEvent(PopCommands.this.genomeKey_, 1));
                        support.finish();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteLinkPointAction
    extends AbstractAction {
        public DeleteLinkPointAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    Layout layout = db.getLayout(PopCommands.this.layout_);
                    LinkSegmentID id = PopCommands.this.intersected_.segmentIDFromIntersect();
                    BusProperties lp = layout.getLinkProperties(PopCommands.this.intersected_.getObjectID());
                    Layout.PropChange[] lpc = new Layout.PropChange[]{layout.deleteLinkageCornerForTree(lp, id, null)};
                    if (lpc[0] != null) {
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteCorner");
                        PropChangeCmd mov = new PropChangeCmd(lpc);
                        support.addEdit(mov);
                        PopCommands.this.myGenomePre_.clearSelections(PopCommands.this.genomeKey_, PopCommands.this.layout_, support);
                        support.finish();
                    }
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class FixAllNonOrthoSegmentsInTreeAction
    extends AbstractAction {
        private boolean minCorners_;
        private boolean forModules_;

        public FixAllNonOrthoSegmentsInTreeAction(String text, boolean forModules, boolean minCorners, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.minCorners_ = minCorners;
            this.forModules_ = forModules;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.genomeKey_ != null && PopCommands.this.intersected_ != null) {
                    LinkProperties lp;
                    Database db = Database.getDB();
                    Layout layout = db.getLayout(PopCommands.this.layout_);
                    String interID = PopCommands.this.intersected_.getObjectID();
                    if (this.forModules_) {
                        String ovrKey = PopCommands.this.suPanel_.getCurrentOverlay();
                        lp = layout.getNetOverlayProperties(ovrKey).getNetModuleLinkagePropertiesFromTreeID(interID);
                    } else {
                        lp = layout.getLinkProperties(interID);
                    }
                    Object[] setArg = new Object[]{new Boolean(this.minCorners_), lp, null, this.forModules_ ? PopCommands.this.suPanel_.getCurrentOverlay() : null};
                    MainCommands.OneShot csr = MainCommands.getCmds().getOneShot(19);
                    csr.performOperation(setArg);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            FontRenderContext frc;
            Genome genome;
            Database db = Database.getDB();
            Layout layout = db.getLayout(PopCommands.this.layout_);
            BusProperties lp = layout.getLinkProperties(PopCommands.this.intersected_.getObjectID());
            Set nonOrtho = lp.getNonOrthoSegments(genome = db.getGenome(PopCommands.this.genomeKey_), layout, frc = PopCommands.this.myGenomePre_.getFontRenderContext());
            return !nonOrtho.isEmpty();
        }
    }

    public class FixNonOrthoSegmentAction
    extends AbstractAction {
        private boolean minCorners_;
        private boolean forModules_;

        public FixNonOrthoSegmentAction(String text, boolean forModules, boolean minCorners, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.minCorners_ = minCorners;
            this.forModules_ = forModules;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.genomeKey_ != null && PopCommands.this.intersected_ != null) {
                    LinkProperties lp;
                    Database db = Database.getDB();
                    Layout layout = db.getLayout(PopCommands.this.layout_);
                    String interID = PopCommands.this.intersected_.getObjectID();
                    if (this.forModules_) {
                        String ovrKey = PopCommands.this.suPanel_.getCurrentOverlay();
                        lp = layout.getNetOverlayProperties(ovrKey).getNetModuleLinkagePropertiesFromTreeID(interID);
                    } else {
                        lp = layout.getLinkProperties(interID);
                    }
                    LinkSegmentID id = PopCommands.this.intersected_.segmentIDFromIntersect();
                    Object[] setArg = new Object[]{new Boolean(this.minCorners_), lp, id, this.forModules_ ? PopCommands.this.suPanel_.getCurrentOverlay() : null};
                    MainCommands.OneShot csr = MainCommands.getCmds().getOneShot(19);
                    csr.performOperation(setArg);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            FontRenderContext frc;
            Genome genome;
            Database db = Database.getDB();
            Layout layout = db.getLayout(PopCommands.this.layout_);
            LinkSegmentID segID = PopCommands.this.intersected_.segmentIDFromIntersect();
            BusProperties lp = layout.getLinkProperties(PopCommands.this.intersected_.getObjectID());
            LinkSegment noSeg = lp.getSegmentGeometryForID(segID, genome = db.getGenome(PopCommands.this.genomeKey_), layout, frc = PopCommands.this.myGenomePre_.getFontRenderContext(), false);
            return !noSeg.isOrthogonal();
        }
    }

    public class IncludeAllForGroupAction
    extends AbstractAction {
        public IncludeAllForGroupAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    AddCommands pendingAdd = new AddCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    Genome genome = Database.getDB().getGenome(PopCommands.this.genomeKey_);
                    if (genome instanceof GenomeInstance) {
                        GenomeInstance gi = (GenomeInstance)genome;
                        GenomeInstance parent = gi.getVfgParent();
                        if (parent != null) {
                            pendingAdd.addAllElementsInGroupToSubsetInstance(PopCommands.this.genomeKey_, parent, PopCommands.this.intersected_.getObjectID());
                        } else {
                            pendingAdd.propagateDownEntireRootToGroup(PopCommands.this.genomeKey_, PopCommands.this.layout_, PopCommands.this.intersected_.getObjectID(), PopCommands.this.myGenomePre_.getFontRenderContext());
                        }
                        PopCommands.this.suPanel_.repaint();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class MoveGroupAction
    extends AbstractAction {
        public MoveGroupAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            block5: {
                try {
                    if (PopCommands.this.intersected_ == null) break block5;
                    boolean didWarp = false;
                    try {
                        Robot r = new Robot();
                        r.mouseMove(((PopCommands)PopCommands.this).absScreen_.x, ((PopCommands)PopCommands.this).absScreen_.y);
                        didWarp = true;
                    }
                    catch (AWTException awtex) {
                    }
                    catch (SecurityException secex) {
                        // empty catch block
                    }
                    Point pt = new Point();
                    PopCommands.this.suPanel_.transformClick(PopCommands.this.popupPoint_.getX(), PopCommands.this.popupPoint_.getY(), pt);
                    PopCommands.this.suPanel_.setToMode(6, new SUPanel.MoveGroupArgs(PopCommands.this.intersected_.getObjectID(), pt, didWarp ? (Point)pt.clone() : null));
                    PopCommands.this.suPanel_.repaint();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        }
    }

    public class LowerGroupAction
    extends AbstractAction {
        public LowerGroupAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Layout lo = Database.getDB().getLayout(PopCommands.this.layout_);
                    Layout.PropChange[] lpc = lo.lowerGroup(Group.getBaseID(PopCommands.this.intersected_.getObjectID()));
                    if (lpc != null) {
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.groupLower");
                        PropChangeCmd mov = new PropChangeCmd(lpc);
                        support.addEdit(mov);
                        support.addEvent(new LayoutChangeEvent(PopCommands.this.layout_, 1));
                        support.finish();
                    }
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class RaiseGroupAction
    extends AbstractAction {
        public RaiseGroupAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Layout lo = Database.getDB().getLayout(PopCommands.this.layout_);
                    Layout.PropChange[] lpc = lo.raiseGroup(Group.getBaseID(PopCommands.this.intersected_.getObjectID()));
                    if (lpc != null) {
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.groupRaise");
                        PropChangeCmd mov = new PropChangeCmd(lpc);
                        support.addEdit(mov);
                        support.addEvent(new LayoutChangeEvent(PopCommands.this.layout_, 1));
                        support.finish();
                    }
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteGroupAction
    extends AbstractAction {
        public DeleteGroupAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.groupDelete");
                    DeleteCommands dc = new DeleteCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    if (dc.deleteGroupFromModel(PopCommands.this.intersected_, PopCommands.this.genomeKey_, PopCommands.this.layout_, support, false, PopCommands.this.myGenomePre_.getFontRenderContext())) {
                        PopCommands.this.myGenomePre_.clearSelections(PopCommands.this.genomeKey_, PopCommands.this.layout_, support);
                        support.finish();
                        PopCommands.this.suPanel_.repaint();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class PerturbPathCompareAction
    extends AbstractAction {
        private String targetID_;
        private String sourceID_;
        private boolean showQPCR_;

        public PerturbPathCompareAction(String targetID, String sourceID, String text, boolean showQPCR) {
            super(text);
            this.targetID_ = targetID;
            this.sourceID_ = sourceID;
            this.showQPCR_ = showQPCR;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                Layout layout = db.getLayout(PopCommands.this.layout_);
                PathDialog pd = new PathDialog(PopCommands.this.parent_, PopCommands.this.genomeKey_, this.sourceID_, this.targetID_, layout, PopCommands.this.myGenomePre_.getFontRenderContext(), this.showQPCR_);
                ToolTipManager ttm = ToolTipManager.sharedInstance();
                int delay = ttm.getDismissDelay();
                ttm.setDismissDelay(240000);
                pd.setVisible(true);
                ttm.setDismissDelay(delay);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class AnalyzePathsForNodeAction
    extends AbstractAction {
        private String targetID_;
        private String sourceID_;
        private boolean showQPCR_;

        public AnalyzePathsForNodeAction(String targetID, String sourceID, String text, boolean showQPCR) {
            super(text);
            this.targetID_ = targetID;
            this.sourceID_ = sourceID;
            this.showQPCR_ = showQPCR;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                Layout layout = db.getLayout(PopCommands.this.layout_);
                PathDialog pd = new PathDialog(PopCommands.this.parent_, PopCommands.this.genomeKey_, this.sourceID_, this.targetID_, layout, PopCommands.this.myGenomePre_.getFontRenderContext(), this.showQPCR_);
                ToolTipManager ttm = ToolTipManager.sharedInstance();
                int delay = ttm.getDismissDelay();
                ttm.setDismissDelay(240000);
                pd.setVisible(true);
                ttm.setDismissDelay(delay);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class AnalyzePathsAction
    extends AbstractAction {
        private boolean showQPCR_;

        public AnalyzePathsAction(String text, boolean showQPCR, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.showQPCR_ = showQPCR;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    LinkSegmentID segID;
                    Database db = Database.getDB();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Layout layout = db.getLayout(PopCommands.this.layout_);
                    BusProperties lp = layout.getLinkProperties(PopCommands.this.intersected_.getObjectID());
                    Set resolved = lp.resolveLinkagesThroughSegment(segID = PopCommands.this.intersected_.segmentIDFromIntersect(), genome);
                    if (resolved.size() > 1) {
                        return;
                    }
                    String linkID = (String)resolved.iterator().next();
                    Linkage link = genome.getLinkage(linkID);
                    PathDialog pd = new PathDialog(PopCommands.this.parent_, PopCommands.this.genomeKey_, link.getSource(), link.getTarget(), layout, PopCommands.this.myGenomePre_.getFontRenderContext(), this.showQPCR_);
                    ToolTipManager ttm = ToolTipManager.sharedInstance();
                    int delay = ttm.getDismissDelay();
                    ttm.setDismissDelay(240000);
                    pd.setVisible(true);
                    ttm.setDismissDelay(delay);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            if (selected == null) {
                return false;
            }
            String oid = selected.getObjectID();
            if (oid == null) {
                return false;
            }
            Database db = Database.getDB();
            Layout layout = db.getLayout(PopCommands.this.layout_);
            BusProperties lp = layout.getLinkProperties(oid);
            Genome genome = db.getGenome(PopCommands.this.genomeKey_);
            LinkSegmentID segID = selected.segmentIDFromIntersect();
            Set resolved = lp.resolveLinkagesThroughSegment(segID, genome);
            return resolved.size() == 1;
        }
    }

    public class OptimizeLinkAction
    extends AbstractAction {
        private boolean allowReparent_;

        public OptimizeLinkAction(String text, char mnem, boolean allowReparent) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.allowReparent_ = allowReparent;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    LinkSegment seg;
                    Database db = Database.getDB();
                    Layout layout = db.getLayout(PopCommands.this.layout_);
                    BusProperties lp = layout.getLinkProperties(PopCommands.this.intersected_.getObjectID());
                    LinkSegmentID[] ids = PopCommands.this.intersected_.segmentIDsFromIntersect();
                    if (ids.length != 1) {
                        return;
                    }
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    HashSet<String> linkID = new HashSet<String>();
                    linkID.add(((LinkProperties)lp).getALinkID(genome));
                    HashSet below = new HashSet();
                    HashSet<Object> notBelow = new HashSet<Object>();
                    lp.splitTreePoints(ids[0], below, notBelow);
                    if (ids[0].isForSegment() && !(seg = lp.getSegment(ids[0])).isDegenerate()) {
                        notBelow.add(seg.getEnd().clone());
                    }
                    Object[] setArg = new Object[]{linkID, notBelow, new Boolean(this.allowReparent_)};
                    MainCommands.OneShot rlts = MainCommands.getCmds().getOneShot(2);
                    rlts.performOperation(setArg);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            if (selected == null) {
                return false;
            }
            String oid = selected.getObjectID();
            if (oid == null) {
                return false;
            }
            Database db = Database.getDB();
            Genome genome = db.getGenome(PopCommands.this.genomeKey_);
            if (genome instanceof GenomeInstance && ((GenomeInstance)genome).getVfgParent() != null) {
                return false;
            }
            Layout layout = db.getLayout(PopCommands.this.layout_);
            BusProperties lp = layout.getLinkProperties(PopCommands.this.intersected_.getObjectID());
            if (lp.isDirect()) {
                return false;
            }
            LinkSegmentID[] ids = PopCommands.this.intersected_.segmentIDsFromIntersect();
            if (ids.length != 1) {
                return false;
            }
            return !ids[0].isForEndDrop();
        }
    }

    public class RepairLinkTreeAction
    extends AbstractAction {
        private boolean forModules_;

        public RepairLinkTreeAction(String text, char mnem, boolean forModules) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.forModules_ = forModules;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    LinkProperties lp;
                    Database db = Database.getDB();
                    Layout layout = db.getLayout(PopCommands.this.layout_);
                    String interID = PopCommands.this.intersected_.getObjectID();
                    String ovrKey = null;
                    if (this.forModules_) {
                        ovrKey = PopCommands.this.suPanel_.getCurrentOverlay();
                        lp = layout.getNetOverlayProperties(ovrKey).getNetModuleLinkagePropertiesFromTreeID(interID);
                    } else {
                        lp = layout.getLinkProperties(interID);
                    }
                    Object[] setArg = new Object[]{lp, ovrKey};
                    MainCommands.OneShot rlts = MainCommands.getCmds().getOneShot(20);
                    rlts.performOperation(setArg);
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            if (selected == null) {
                return false;
            }
            String oid = selected.getObjectID();
            if (oid == null) {
                return false;
            }
            Database db = Database.getDB();
            Layout layout = db.getLayout(PopCommands.this.layout_);
            BusProperties lp = layout.getLinkProperties(oid);
            return !lp.isDirect();
        }
    }

    public class RelayoutLinkAction
    extends AbstractAction {
        public RelayoutLinkAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    Layout layout = db.getLayout(PopCommands.this.layout_);
                    BusProperties bp = layout.getLinkProperties(PopCommands.this.intersected_.getObjectID());
                    LinkSegmentID[] ids = PopCommands.this.intersected_.segmentIDsFromIntersect();
                    if (ids.length != 1) {
                        return;
                    }
                    Set linkIDs = bp.resolveLinkagesThroughSegment(ids[0], null);
                    Object[] setArg = new Object[]{linkIDs};
                    MainCommands.OneShot rlts = MainCommands.getCmds().getOneShot(1);
                    rlts.performOperation(setArg);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            if (selected == null) {
                return false;
            }
            String oid = selected.getObjectID();
            if (oid == null) {
                return false;
            }
            Database db = Database.getDB();
            Genome genome = db.getGenome(PopCommands.this.genomeKey_);
            return !(genome instanceof GenomeInstance) || ((GenomeInstance)genome).getVfgParent() == null;
        }
    }

    public class SelectLinkTargetsAction
    extends AbstractAction {
        public SelectLinkTargetsAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    Layout lo = db.getLayout(PopCommands.this.layout_);
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    BusProperties bp = lo.getLinkProperties(PopCommands.this.intersected_.getObjectID());
                    LinkSegmentID segID = PopCommands.this.intersected_.segmentIDFromIntersect();
                    Set linksThru = bp.resolveLinkagesThroughSegment(segID, genome);
                    SourceAndTargetSelector sats = new SourceAndTargetSelector(PopCommands.this.parent_, genome, PopCommands.this.layout_, PopCommands.this.myGenomePre_, PopCommands.this.myGenomePre_.getFontRenderContext(), PopCommands.this.undom_);
                    if (sats.doLinkSelection(linksThru, true)) {
                        MainCommands.getCmds().getZoomController().zoomToSelected();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class SelectLinkSourceAction
    extends AbstractAction {
        public SelectLinkSourceAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Linkage link = genome.getLinkage(PopCommands.this.intersected_.getObjectID());
                    String src = link.getSource();
                    HashSet<String> nodeSet = new HashSet<String>();
                    nodeSet.add(src);
                    SourceAndTargetSelector sats = new SourceAndTargetSelector(PopCommands.this.parent_, genome, PopCommands.this.layout_, PopCommands.this.myGenomePre_, PopCommands.this.myGenomePre_.getFontRenderContext(), PopCommands.this.undom_);
                    if (sats.doSelection(nodeSet, 2, PopCommands.this.includeQueryNode_, false, !PopCommands.this.appendToCurrent_)) {
                        MainCommands.getCmds().getZoomController().zoomToSelected();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteLinkageAction
    extends AbstractAction {
        public DeleteLinkageAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.linkDelete");
                    DeleteCommands dc = new DeleteCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    dc.deleteWarningHelper(PopCommands.this.genomeKey_, PopCommands.this.parent_);
                    if (dc.deleteLinkFromModel(PopCommands.this.intersected_, PopCommands.this.genomeKey_, PopCommands.this.layout_, support)) {
                        PopCommands.this.myGenomePre_.clearSelections(PopCommands.this.genomeKey_, PopCommands.this.layout_, support);
                        PopCommands.this.suPanel_.repaint();
                        support.addEvent(new ModelChangeEvent(PopCommands.this.genomeKey_, 1));
                        support.finish();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class SpecialLineAction
    extends AbstractAction {
        public SpecialLineAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    Layout lo = db.getLayout(PopCommands.this.layout_);
                    BusProperties lp = lo.getLinkProperties(PopCommands.this.intersected_.getObjectID());
                    LinkSegmentID[] ids = PopCommands.this.intersected_.segmentIDsFromIntersect();
                    if (ids.length != 1) {
                        return;
                    }
                    LinkSegmentSpecialPropsDialog spd = new LinkSegmentSpecialPropsDialog(PopCommands.this.parent_, lo, PopCommands.this.intersected_.getObjectID(), ids[0], PopCommands.this.undom_);
                    spd.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            if (selected == null) {
                return false;
            }
            String oid = selected.getObjectID();
            if (oid == null) {
                return false;
            }
            Database db = Database.getDB();
            Layout layout = db.getLayout(PopCommands.this.layout_);
            BusProperties bp = layout.getLinkProperties(oid);
            return !bp.isDirect();
        }
    }

    public class SimulationPropertiesAction
    extends AbstractAction {
        public SimulationPropertiesAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db;
                Genome genome;
                if (PopCommands.this.intersected_ != null && (genome = (db = Database.getDB()).getGenome(PopCommands.this.genomeKey_)) instanceof DBGenome) {
                    SimulationPropertiesDialog spd = new SimulationPropertiesDialog(PopCommands.this.parent_, PopCommands.this.genomeKey_, PopCommands.this.intersected_.getObjectID(), PopCommands.this.undom_);
                    spd.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class LinkPropertiesAction
    extends AbstractAction {
        public LinkPropertiesAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db;
                Layout layout;
                BusProperties lp;
                if (PopCommands.this.intersected_ != null && (lp = (layout = (db = Database.getDB()).getLayout(PopCommands.this.layout_)).getLinkProperties(PopCommands.this.intersected_.getObjectID())) != null) {
                    LinkPropertiesDialog lpd = new LinkPropertiesDialog(PopCommands.this.parent_, PopCommands.this.layout_, PopCommands.this.genomeKey_, PopCommands.this.intersected_.getObjectID(), PopCommands.this.undom_, false, null);
                    lpd.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class GroupPropertiesAction
    extends AbstractAction {
        private String groupID_;

        public GroupPropertiesAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public GroupPropertiesAction(String groupID, String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.groupID_ = groupID;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                GroupProperties gp = null;
                Database db = Database.getDB();
                Layout layout = db.getLayout(PopCommands.this.layout_);
                if (this.groupID_ == null) {
                    if (PopCommands.this.intersected_ != null) {
                        gp = layout.getGroupProperties(Group.getBaseID(PopCommands.this.intersected_.getObjectID()));
                    }
                } else {
                    gp = layout.getGroupProperties(Group.getBaseID(this.groupID_));
                }
                if (gp != null) {
                    GroupPropertiesDialog gpd = new GroupPropertiesDialog(PopCommands.this.parent_, PopCommands.this.layout_, gp, this.groupID_ != null, PopCommands.this.undom_);
                    gpd.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class LinkUsagesAction
    extends AbstractAction {
        public LinkUsagesAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    Layout lo = db.getLayout(PopCommands.this.layout_);
                    BusProperties bp = lo.getLinkProperties(PopCommands.this.intersected_.getObjectID());
                    LinkSegmentID segID = PopCommands.this.intersected_.segmentIDFromIntersect();
                    Set linksThru = bp.resolveLinkagesThroughSegment(segID, genome);
                    DataPopupManager.getPopupMgr().displayLinkUsages(PopCommands.this.parent_, linksThru, PopCommands.this.myGenomePre_);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class NodeUsagesAction
    extends AbstractAction {
        public NodeUsagesAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db;
                Genome genome;
                Node node;
                if (PopCommands.this.intersected_ != null && (node = (genome = (db = Database.getDB()).getGenome(PopCommands.this.genomeKey_)).getNode(PopCommands.this.intersected_.getObjectID())) != null) {
                    DataPopupManager.getPopupMgr().displayNodeUsages(PopCommands.this.parent_, node.getID(), PopCommands.this.myGenomePre_);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class NodeSuperAddAction
    extends AbstractAction {
        public NodeSuperAddAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String nodeID;
                Database db;
                Genome genome;
                Node node;
                if (PopCommands.this.intersected_ != null && (node = (genome = (db = Database.getDB()).getGenome(PopCommands.this.genomeKey_)).getNode(nodeID = PopCommands.this.intersected_.getObjectID())) != null) {
                    SuperAddTargetDialog satd = new SuperAddTargetDialog(PopCommands.this.parent_, nodeID);
                    satd.show();
                    if (!satd.haveResult()) {
                        return;
                    }
                    List superAddPairs = satd.getSuperAddPairs();
                    AddCommands ac = new AddCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    ac.superAddForNode(node.getID(), superAddPairs);
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class NodeTypeChangeAction
    extends AbstractAction {
        public NodeTypeChangeAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db;
                Genome genome;
                Node node;
                if (PopCommands.this.intersected_ != null && (node = (genome = (db = Database.getDB()).getGenome(PopCommands.this.genomeKey_)).getNode(PopCommands.this.intersected_.getObjectID())) != null) {
                    ModificationCommands mcmd = new ModificationCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    mcmd.changeNodeType(node.getID(), genome, PopCommands.this.myGenomePre_.getFontRenderContext());
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class AppendToCurrentSelectionToggle
    extends AbstractAction {
        private boolean ignore_;

        public AppendToCurrentSelectionToggle(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.ignore_ = false;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.ignore_) {
                    return;
                }
                PopCommands.this.appendToCurrent_ = !PopCommands.this.appendToCurrent_;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean shouldCheck() {
            return PopCommands.this.appendToCurrent_;
        }

        public void setToUpdate(boolean ignore) {
            this.ignore_ = ignore;
        }

        public boolean amIValid(Intersection selected) {
            return true;
        }
    }

    public class SelectQueryNodeToggle
    extends AbstractAction {
        private boolean ignore_;

        public SelectQueryNodeToggle(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.ignore_ = false;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.ignore_) {
                    return;
                }
                PopCommands.this.includeQueryNode_ = !PopCommands.this.includeQueryNode_;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean shouldCheck() {
            return PopCommands.this.includeQueryNode_;
        }

        public void setToUpdate(boolean ignore) {
            this.ignore_ = ignore;
        }

        public boolean amIValid(Intersection selected) {
            return true;
        }
    }

    public class SelectLinksToggle
    extends AbstractAction {
        private boolean ignore_;

        public SelectLinksToggle(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.ignore_ = false;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.ignore_) {
                    return;
                }
                PopCommands.this.includeLinks_ = !PopCommands.this.includeLinks_;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean shouldCheck() {
            return PopCommands.this.includeLinks_;
        }

        public void setToUpdate(boolean ignore) {
            this.ignore_ = ignore;
        }

        public boolean amIValid(Intersection selected) {
            return !PopCommands.this.suPanel_.linksAreHidden();
        }
    }

    public class SelectTargetsAction
    extends AbstractAction
    implements GraphSearcher.CriteriaJudge {
        private boolean genesOnly_;

        public SelectTargetsAction(String text, boolean genesOnly, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.genesOnly_ = genesOnly;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                if (PopCommands.this.intersected_ != null) {
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    SourceAndTargetSelector sats = new SourceAndTargetSelector(PopCommands.this.parent_, genome, PopCommands.this.layout_, PopCommands.this.myGenomePre_, PopCommands.this.myGenomePre_.getFontRenderContext(), PopCommands.this.undom_);
                    if (this.genesOnly_) {
                        if (sats.doCriteriaSelection(PopCommands.this.intersected_.getObjectID(), 0, PopCommands.this.includeQueryNode_, false, !PopCommands.this.appendToCurrent_, this)) {
                            MainCommands.getCmds().getZoomController().zoomToSelected();
                        }
                    } else {
                        HashSet<String> nodeSet = new HashSet<String>();
                        nodeSet.add(PopCommands.this.intersected_.getObjectID());
                        if (sats.doSelection(nodeSet, 0, PopCommands.this.includeQueryNode_, PopCommands.this.includeLinks_ && !PopCommands.this.suPanel_.linksAreHidden(), !PopCommands.this.appendToCurrent_)) {
                            MainCommands.getCmds().getZoomController().zoomToSelected();
                        }
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean stopHere(String nodeID) {
            if (PopCommands.this.intersected_.getObjectID().equals(nodeID)) {
                return false;
            }
            return Database.getDB().getGenome(PopCommands.this.genomeKey_).getGene(nodeID) != null;
        }

        public boolean amIValid(Intersection selected) {
            if (selected == null) {
                return false;
            }
            String oid = selected.getObjectID();
            if (oid == null) {
                return false;
            }
            Database db = Database.getDB();
            Genome genome = db.getGenome(PopCommands.this.genomeKey_);
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                String src = link.getSource();
                if (!oid.equals(src)) continue;
                return true;
            }
            return false;
        }
    }

    public class SelectSourcesAction
    extends AbstractAction
    implements GraphSearcher.CriteriaJudge {
        private boolean genesOnly_;

        public SelectSourcesAction(String text, boolean genesOnly, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.genesOnly_ = genesOnly;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    SourceAndTargetSelector sats = new SourceAndTargetSelector(PopCommands.this.parent_, genome, PopCommands.this.layout_, PopCommands.this.myGenomePre_, PopCommands.this.myGenomePre_.getFontRenderContext(), PopCommands.this.undom_);
                    if (this.genesOnly_) {
                        if (sats.doCriteriaSelection(PopCommands.this.intersected_.getObjectID(), 1, PopCommands.this.includeQueryNode_, false, !PopCommands.this.appendToCurrent_, this)) {
                            MainCommands.getCmds().getZoomController().zoomToSelected();
                        }
                    } else {
                        HashSet<String> nodeSet = new HashSet<String>();
                        nodeSet.add(PopCommands.this.intersected_.getObjectID());
                        if (sats.doSelection(nodeSet, 1, PopCommands.this.includeQueryNode_, PopCommands.this.includeLinks_ && !PopCommands.this.suPanel_.linksAreHidden(), !PopCommands.this.appendToCurrent_)) {
                            MainCommands.getCmds().getZoomController().zoomToSelected();
                        }
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean stopHere(String nodeID) {
            if (PopCommands.this.intersected_.getObjectID().equals(nodeID)) {
                return false;
            }
            return Database.getDB().getGenome(PopCommands.this.genomeKey_).getGene(nodeID) != null;
        }

        public boolean amIValid(Intersection selected) {
            if (selected == null) {
                return false;
            }
            String oid = selected.getObjectID();
            if (oid == null) {
                return false;
            }
            Database db = Database.getDB();
            Genome genome = db.getGenome(PopCommands.this.genomeKey_);
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                String trg = link.getTarget();
                if (!oid.equals(trg)) continue;
                return true;
            }
            return false;
        }
    }

    public class NodePropertiesAction
    extends AbstractAction {
        public NodePropertiesAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db;
                Layout layout;
                NodeProperties np;
                if (PopCommands.this.intersected_ != null && (np = (layout = (db = Database.getDB()).getLayout(PopCommands.this.layout_)).getNodeProperties(PopCommands.this.intersected_.getObjectID())) != null) {
                    NodePropertiesDialog npd = new NodePropertiesDialog(PopCommands.this.parent_, PopCommands.this.layout_, PopCommands.this.genomeKey_, np, PopCommands.this.myGenomePre_.getFontRenderContext(), PopCommands.this.undom_);
                    npd.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class GenePropertiesAction
    extends AbstractAction {
        public GenePropertiesAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db;
                Layout layout;
                NodeProperties np;
                if (PopCommands.this.intersected_ != null && (np = (layout = (db = Database.getDB()).getLayout(PopCommands.this.layout_)).getNodeProperties(PopCommands.this.intersected_.getObjectID())) != null) {
                    GenePropertiesDialog gpd = new GenePropertiesDialog(PopCommands.this.parent_, PopCommands.this.layout_, PopCommands.this.genomeKey_, np, PopCommands.this.myGenomePre_.getFontRenderContext(), PopCommands.this.undom_);
                    gpd.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class ChangeNodeGroupMembershipAction
    extends AbstractAction {
        public ChangeNodeGroupMembershipAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    if (db.haveBuildInstructions()) {
                        ResourceManager rMan = ResourceManager.getManager();
                        JOptionPane.showMessageDialog(PopCommands.this.parent_, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
                    }
                    PopCommands.this.suPanel_.setToMode(24, PopCommands.this.intersected_);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            Database db = Database.getDB();
            Genome genome = db.getGenome(PopCommands.this.genomeKey_);
            return genome instanceof GenomeInstance && !(genome instanceof DynamicGenomeInstance);
        }
    }

    public class DeleteFromModuleAction
    extends AbstractAction {
        private String moduleID_;

        public DeleteFromModuleAction(String text, String moduleID) {
            super(text);
            this.moduleID_ = moduleID;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    DeleteCommands dc = new DeleteCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    dc.deleteNodeFromModule(PopCommands.this.genomeKey_, PopCommands.this.intersected_.getObjectID(), this.moduleID_, PopCommands.this.suPanel_.getCurrentOverlay(), PopCommands.this.myGenomePre_.getFontRenderContext());
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            return PopCommands.this.suPanel_.getCurrentOverlay() != null;
        }
    }

    public class AddToModuleAction
    extends AbstractAction {
        private String moduleID_;

        public AddToModuleAction(String text, String moduleID) {
            super(text);
            this.moduleID_ = moduleID;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    AddCommands ac = new AddCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    ac.addNodeToModule(PopCommands.this.genomeKey_, PopCommands.this.layout_, PopCommands.this.intersected_.getObjectID(), this.moduleID_, PopCommands.this.suPanel_.getCurrentOverlay(), PopCommands.this.myGenomePre_.getFontRenderContext());
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            return PopCommands.this.suPanel_.getCurrentOverlay() != null;
        }
    }

    public class ChangeTargetNodeAction
    extends AbstractAction {
        public ChangeTargetNodeAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                if (db.haveBuildInstructions()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(PopCommands.this.parent_, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
                }
                PopCommands.this.suPanel_.setToMode(12, PopCommands.this.intersected_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            if (selected == null) {
                return false;
            }
            String oid = selected.getObjectID();
            if (oid == null) {
                return false;
            }
            Database db = Database.getDB();
            Genome genome = db.getGenome(PopCommands.this.genomeKey_);
            Layout layout = db.getLayout(PopCommands.this.layout_);
            if (!(genome instanceof DBGenome)) {
                return false;
            }
            LinkSegmentID[] ids = selected.segmentIDsFromIntersect();
            if (ids == null) {
                return false;
            }
            if (ids.length != 1) {
                return false;
            }
            return layout.segmentSynonymousWithTargetDrop(oid, ids[0], genome) != null;
        }
    }

    public class ChangeSourceNodeAction
    extends AbstractAction {
        public ChangeSourceNodeAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db = Database.getDB();
                if (db.haveBuildInstructions()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(PopCommands.this.parent_, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
                }
                PopCommands.this.suPanel_.setToMode(11, PopCommands.this.intersected_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            if (selected == null) {
                return false;
            }
            String oid = selected.getObjectID();
            if (oid == null) {
                return false;
            }
            Database db = Database.getDB();
            Genome genome = db.getGenome(PopCommands.this.genomeKey_);
            return genome instanceof DBGenome;
        }
    }

    public class RelocateSourceAction
    extends AbstractAction {
        private boolean forModules_;

        public RelocateSourceAction(String text, boolean forModules, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.forModules_ = forModules;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                PopCommands.this.actionPerformedForTargetOrSource(1, this.forModules_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            return PopCommands.this.amIValidForTargetOrSource(selected, 1, this.forModules_);
        }
    }

    public class RelocateTargetAction
    extends AbstractAction {
        private boolean forModules_;

        public RelocateTargetAction(String text, boolean forModules, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.forModules_ = forModules;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                PopCommands.this.actionPerformedForTargetOrSource(0, this.forModules_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            return PopCommands.this.amIValidForTargetOrSource(selected, 0, this.forModules_);
        }
    }

    public class SwapPadsAction
    extends AbstractAction {
        public SwapPadsAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                PopCommands.this.actionPerformedForTargetOrSource(2, false);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            return PopCommands.this.amIValidForTargetOrSource(selected, 2, false);
        }
    }

    public class RelocateSegmentAction
    extends AbstractAction {
        private boolean forModules_;

        public RelocateSegmentAction(String text, boolean forModules, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.forModules_ = forModules;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ == null) {
                    return;
                }
                String oid = PopCommands.this.intersected_.getObjectID();
                if (oid == null) {
                    return;
                }
                LinkSegmentID[] ids = PopCommands.this.intersected_.segmentIDsFromIntersect();
                if (ids.length != 1) {
                    return;
                }
                PopCommands.this.suPanel_.setToMode(this.forModules_ ? 21 : 10, PopCommands.this.intersected_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean amIValid(Intersection selected) {
            LinkProperties lp;
            if (selected == null) {
                return false;
            }
            String oid = selected.getObjectID();
            if (oid == null) {
                return false;
            }
            LinkSegmentID[] ids = selected.segmentIDsFromIntersect();
            if (ids.length != 1) {
                return false;
            }
            Database db = Database.getDB();
            Layout layout = db.getLayout(PopCommands.this.layout_);
            if (this.forModules_) {
                String ovrKey = PopCommands.this.suPanel_.getCurrentOverlay();
                NetOverlayProperties nop = layout.getNetOverlayProperties(ovrKey);
                lp = nop.getNetModuleLinkagePropertiesFromTreeID(oid);
                Set throughSeg = lp.resolveLinkagesThroughSegment(ids[0], null);
                if (!PopCommands.this.haveModLinkDOFs(PopCommands.this.genomeKey_, layout, throughSeg, ovrKey, PopCommands.this.myGenomePre_.getFontRenderContext())) {
                    return false;
                }
                int treeCount = nop.getOutboundTreeCountForModule(lp.getSourceTag());
                if ((ids[0].isDirect() || ids[0].isForStartDrop()) && treeCount == 1) {
                    return false;
                }
            } else {
                Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                if (genome instanceof GenomeInstance && ((GenomeInstance)genome).getVfgParent() != null) {
                    return false;
                }
                lp = layout.getLinkProperties(oid);
            }
            return layout.canRelocateSegmentOnTree(lp, ids[0]);
        }
    }

    public class FullLinkUnselectionAction
    extends AbstractAction {
        public FullLinkUnselectionAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    PopCommands.this.myGenomePre_.unselectFullLink(PopCommands.this.intersected_, PopCommands.this.genomeKey_, PopCommands.this.layout_);
                }
                PopCommands.this.suPanel_.repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class FullSelectionAction
    extends AbstractAction {
        public FullSelectionAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    PopCommands.this.myGenomePre_.selectFullItem(PopCommands.this.intersected_, PopCommands.this.genomeKey_, PopCommands.this.layout_);
                }
                PopCommands.this.suPanel_.repaint();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class GlobalLayoutRunner
    extends BackgroundWorker {
        private CommonView mySuw_;
        private JFrame myTopWindow_;
        private UndoSupport support_;
        private UndoManager undo_;
        private ArrayList requestList_;

        public GlobalLayoutRunner(Map neededLinksPerGenomeInstance, CommonView mySuw, JFrame topWindow, UndoManager undo, UndoSupport support) {
            super(new LinkRouter.RoutingResult());
            this.mySuw_ = mySuw;
            this.myTopWindow_ = topWindow;
            this.support_ = support;
            this.undo_ = undo;
            this.requestList_ = new ArrayList();
            Iterator nlpgikit = neededLinksPerGenomeInstance.keySet().iterator();
            Database db = Database.getDB();
            LayoutManager lmgr = new LayoutManager();
            while (nlpgikit.hasNext()) {
                String giID = (String)nlpgikit.next();
                AddCommands.GlobalLinkRequest glr = new AddCommands.GlobalLinkRequest();
                glr.genome = db.getGenome(giID);
                String loKey = lmgr.getLayout(giID);
                glr.layout = db.getLayout(loKey);
                glr.badLinks = (Set)neededLinksPerGenomeInstance.get(giID);
                this.requestList_.add(glr);
            }
        }

        public Object runCore() throws AsynchExitRequestException {
            SUPanel sup = this.mySuw_.getSUPanel();
            AddCommands ac = new AddCommands(this.myTopWindow_, this.undo_);
            LayoutOptions lopt = new LayoutOptions(LayoutOptionsManager.getMgr().getLayoutOptions());
            LinkRouter.RoutingResult result = ac.relayoutLinksGlobally(this.requestList_, this.support_, sup.getFontRenderContext(), lopt, this, 0.0, 1.0);
            return result;
        }

        public Object postRunCore() {
            int numReq = this.requestList_.size();
            for (int i = 0; i < numReq; ++i) {
                AddCommands.GlobalLinkRequest glr = (AddCommands.GlobalLinkRequest)this.requestList_.get(i);
                this.support_.addEvent(new LayoutChangeEvent(glr.layout.getName(), 1));
            }
            return null;
        }
    }

    private class NodeInsertionRunner
    extends BackgroundWorker {
        private CommonView mySuw_;
        private UndoSupport support_;
        private ArrayList requestList_;
        private int resolution_;
        private Set resolved_;
        private Point pt_;
        private Intersection intersected_;
        private boolean doGene_;
        private FontRenderContext frc_;
        private AddCommands ac_;

        public NodeInsertionRunner(AddCommands ac, boolean doGene, int resolution, Set resolved, Intersection intersected, Point pt, FontRenderContext frc, CommonView mySuw, JFrame topWindow, UndoManager undo, UndoSupport support) {
            super(new LinkRouter.RoutingResult());
            this.mySuw_ = mySuw;
            this.support_ = support;
            this.requestList_ = new ArrayList();
            this.pt_ = pt;
            this.intersected_ = intersected;
            this.doGene_ = doGene;
            this.frc_ = frc;
            this.ac_ = ac;
            this.resolved_ = resolved;
            this.resolution_ = resolution;
        }

        public Object runCore() throws AsynchExitRequestException {
            SUPanel sup = this.mySuw_.getSUPanel();
            HashMap neededLinksPerGenomeInstance = new HashMap();
            ModificationCommands mc = new ModificationCommands();
            Map globalPadNeeds = mc.getGlobalNetModuleLinkPadNeeds(this.frc_);
            this.ac_.addNewNodeInsertedIntoLinkage(this.doGene_, this.resolution_, this.resolved_, this.pt_.x, this.pt_.y, this.intersected_, this.frc_, this.support_, neededLinksPerGenomeInstance, this, 0.0, 0.2);
            Iterator nlpgikit = neededLinksPerGenomeInstance.keySet().iterator();
            Database db = Database.getDB();
            LayoutManager lmgr = new LayoutManager();
            while (nlpgikit.hasNext()) {
                String giID = (String)nlpgikit.next();
                AddCommands.GlobalLinkRequest glr = new AddCommands.GlobalLinkRequest();
                glr.genome = db.getGenome(giID);
                String loKey = lmgr.getLayout(giID);
                glr.layout = db.getLayout(loKey);
                glr.badLinks = (Set)neededLinksPerGenomeInstance.get(giID);
                this.requestList_.add(glr);
            }
            LayoutOptions lopt = new LayoutOptions(LayoutOptionsManager.getMgr().getLayoutOptions());
            LinkRouter.RoutingResult result = this.ac_.relayoutLinksGlobally(this.requestList_, this.support_, sup.getFontRenderContext(), lopt, this, 0.2, 1.0);
            mc.repairNetModuleLinkPadsGlobally(globalPadNeeds, this.frc_, false, this.support_);
            return result;
        }

        public Object postRunCore() {
            int numReq = this.requestList_.size();
            for (int i = 0; i < numReq; ++i) {
                AddCommands.GlobalLinkRequest glr = (AddCommands.GlobalLinkRequest)this.requestList_.get(i);
                this.support_.addEvent(new LayoutChangeEvent(glr.layout.getName(), 1));
            }
            return null;
        }
    }

    public class InsertNodeInLinkAction
    extends AbstractAction
    implements BackgroundWorkerOwner {
        private boolean doGene_;

        public InsertNodeInLinkAction(String text, boolean doGene, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.doGene_ = doGene;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String undoStr;
                Point pt = new Point();
                PopCommands.this.suPanel_.transformClick(PopCommands.this.popupPoint_.getX(), PopCommands.this.popupPoint_.getY(), pt);
                if (PopCommands.this.intersected_ == null) {
                    return;
                }
                Database db = Database.getDB();
                if (db.haveBuildInstructions()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(PopCommands.this.parent_, rMan.getString("instructWarning.message"), rMan.getString("instructWarning.title"), 2);
                }
                AddCommands ac = new AddCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                String string = undoStr = this.doGene_ ? "undo.insertGeneInLink" : "undo.insertNodeInLink";
                if (ac.addNewNodeToRoot(this.doGene_, PopCommands.this.layout_, null, null) == null) {
                    return;
                }
                HashSet resolved = new HashSet();
                int resolution = ac.addNewNodeInsertedIntoLinkageForegroundPrep(PopCommands.this.intersected_, resolved);
                if (resolution == 0) {
                    return;
                }
                UndoSupport support = new UndoSupport(PopCommands.this.undom_, undoStr);
                PopCommands.this.myGenomePre_.clearSelections(PopCommands.this.genomeKey_, PopCommands.this.layout_, support);
                NodeInsertionRunner runner = new NodeInsertionRunner(ac, this.doGene_, resolution, resolved, PopCommands.this.intersected_, pt, PopCommands.this.myGenomePre_.getFontRenderContext(), PopCommands.this.cView_, PopCommands.this.parent_, PopCommands.this.undom_, support);
                BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, PopCommands.this.parent_, PopCommands.this.cView_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
                runner.setClient(bwc);
                bwc.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void handleCancellation() {
        }

        public void cleanUpPostRepaint(Object result) {
            ToolCommands tc = new ToolCommands(PopCommands.this.parent_, PopCommands.this.cView_, PopCommands.this.undom_);
            tc.doStatusAnnouncements((LinkRouter.RoutingResult)result, PopCommands.this.parent_);
        }

        public boolean amIValid(Intersection selected) {
            if (selected == null) {
                return false;
            }
            String oid = selected.getObjectID();
            if (oid == null) {
                return false;
            }
            Database db = Database.getDB();
            Genome genome = db.getGenome(PopCommands.this.genomeKey_);
            return genome instanceof DBGenome;
        }
    }

    public class DivideAction
    extends AbstractAction {
        private boolean forModules_;

        public DivideAction(String text, boolean forModules, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.forModules_ = forModules;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Point pt = new Point();
                PopCommands.this.suPanel_.transformClick(PopCommands.this.popupPoint_.getX(), PopCommands.this.popupPoint_.getY(), pt);
                if (PopCommands.this.intersected_ != null) {
                    LinkProperties lp;
                    Layout.PropChange[] lumv = new Layout.PropChange[1];
                    Layout layout = Database.getDB().getLayout(PopCommands.this.layout_);
                    LinkSegmentID segID = PopCommands.this.intersected_.segmentIDFromIntersect();
                    Point2D.Double forcedSplit = new Point2D.Double();
                    UiUtil.forceToGrid(pt.getX(), pt.getY(), forcedSplit, 10.0);
                    String interID = PopCommands.this.intersected_.getObjectID();
                    String ovrKey = null;
                    if (this.forModules_) {
                        ovrKey = PopCommands.this.suPanel_.getCurrentOverlay();
                        lp = layout.getNetOverlayProperties(ovrKey).getNetModuleLinkagePropertiesFromTreeID(interID);
                    } else {
                        lp = layout.getLinkProperties(interID);
                    }
                    lumv[0] = layout.splitBusLink(segID, forcedSplit, lp, ovrKey);
                    if (lumv[0] != null) {
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.linkDivide");
                        PropChangeCmd lmov = new PropChangeCmd(lumv);
                        support.addEdit(lmov);
                        PopCommands.this.myGenomePre_.clearSelections(PopCommands.this.genomeKey_, PopCommands.this.layout_, support);
                        support.addEvent(new LayoutChangeEvent(PopCommands.this.layout_, 1));
                        support.finish();
                    }
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class ZoomToGroup
    extends AbstractAction {
        public ZoomToGroup(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String objID;
                Group group;
                Database db;
                Genome genome;
                if (PopCommands.this.genomeKey_ != null && PopCommands.this.intersected_ != null && (genome = (db = Database.getDB()).getGenome(PopCommands.this.genomeKey_)) instanceof GenomeInstance && (group = ((GenomeInstance)genome).getGroup(objID = PopCommands.this.intersected_.getObjectID())) != null) {
                    Object[] setArg = new Object[]{objID};
                    MainCommands.OneShot csr = MainCommands.getCmds().getOneShot(10);
                    csr.performOperation(setArg);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class CompressOrExpandGroupAction
    extends AbstractAction {
        private boolean doCompress_;

        public CompressOrExpandGroupAction(String text, boolean doCompress, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.doCompress_ = doCompress;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String objID;
                Group group;
                Database db;
                Genome genome;
                if (PopCommands.this.genomeKey_ != null && PopCommands.this.intersected_ != null && (genome = (db = Database.getDB()).getGenome(PopCommands.this.genomeKey_)) instanceof GenomeInstance && (group = ((GenomeInstance)genome).getGroup(objID = PopCommands.this.intersected_.getObjectID())) != null) {
                    Object[] setArg = new Object[]{objID};
                    int which = this.doCompress_ ? 3 : 4;
                    MainCommands.OneShot csr = MainCommands.getCmds().getOneShot(which);
                    csr.performOperation(setArg);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class LayoutGroupAction
    extends AbstractAction {
        public LayoutGroupAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String objID;
                Group group;
                Database db;
                Genome genome;
                if (PopCommands.this.genomeKey_ != null && PopCommands.this.intersected_ != null && (genome = (db = Database.getDB()).getGenome(PopCommands.this.genomeKey_)) instanceof GenomeInstance && (group = ((GenomeInstance)genome).getGroup(objID = PopCommands.this.intersected_.getObjectID())) != null) {
                    Object[] setArg = new Object[]{objID};
                    MainCommands.OneShot csr = MainCommands.getCmds().getOneShot(18);
                    csr.performOperation(setArg);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class ToggleAction
    extends AbstractAction {
        public ToggleAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Database db;
                Genome genome;
                if (PopCommands.this.genomeKey_ != null && PopCommands.this.intersected_ != null && (genome = (db = Database.getDB()).getGenome(PopCommands.this.genomeKey_)) instanceof GenomeInstance) {
                    Group group = ((GenomeInstance)genome).getGroup(PopCommands.this.intersected_.getObjectID());
                    String groupRef = group.getID();
                    GroupSettingManager gsm = GroupSettingManager.getGroupMgr();
                    int groupViz = gsm.getGroupVisibility(genome.getID(), groupRef);
                    int newSetting = groupViz == 4 ? 3 : 4;
                    GroupSettingChange gsc = gsm.setGroupVisibility(genome.getID(), groupRef, newSetting);
                    if (gsc != null) {
                        GroupSettingChangeCmd gscc = new GroupSettingChangeCmd(gsc);
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.regionToggle");
                        support.addEdit(gscc);
                        support.addEvent(new LayoutChangeEvent(PopCommands.this.layout_, 1));
                        support.finish();
                    }
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DetachModuleFromGroup
    extends AbstractAction {
        public DetachModuleFromGroup(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    String ovrKey = PopCommands.this.suPanel_.getCurrentOverlay();
                    String netModKey = PopCommands.this.intersected_.getObjectID();
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.detachModuleFromGroup");
                    NetOverlayOwner owner = db.getOverlayOwnerFromGenomeKey(PopCommands.this.genomeKey_);
                    NetworkOverlay novr = owner.getNetworkOverlay(ovrKey);
                    NetModule nmod = novr.getModule(netModKey);
                    NetModuleChange nmc = nmod.detachFromGroup(owner.getID(), owner.overlayModeForOwner(), ovrKey);
                    if (nmc != null) {
                        support.addEdit(new NetOverlayChangeCmd(nmc));
                        support.addEvent(new ModelChangeEvent(PopCommands.this.genomeKey_, 1));
                        PopCommands.this.suPanel_.repaint();
                        support.finish();
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class MoveNetModuleRegion
    extends AbstractAction {
        private boolean moveGuts_;
        private int moveMode_;

        public MoveNetModuleRegion(String text, boolean moveGuts, int moveMode, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
            this.moveGuts_ = moveGuts;
            this.moveMode_ = moveMode;
        }

        public void actionPerformed(ActionEvent e) {
            block5: {
                try {
                    if (PopCommands.this.intersected_ == null) break block5;
                    boolean didWarp = false;
                    try {
                        Robot r = new Robot();
                        r.mouseMove(((PopCommands)PopCommands.this).absScreen_.x, ((PopCommands)PopCommands.this).absScreen_.y);
                        didWarp = true;
                    }
                    catch (AWTException awtex) {
                    }
                    catch (SecurityException secex) {
                        // empty catch block
                    }
                    Point pt = new Point();
                    PopCommands.this.suPanel_.transformClick(PopCommands.this.popupPoint_.getX(), PopCommands.this.popupPoint_.getY(), pt);
                    PopCommands.this.suPanel_.setToMode(7, new SUPanel.MoveNetModuleArgs(PopCommands.this.intersected_, pt, this.moveGuts_, this.moveMode_, didWarp ? (Point)pt.clone() : null));
                    PopCommands.this.suPanel_.repaint();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        }
    }

    public class DropNetModuleRegion
    extends AbstractAction {
        public DropNetModuleRegion(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    String ovrKey = PopCommands.this.suPanel_.getCurrentOverlay();
                    FontRenderContext frc = PopCommands.this.suPanel_.getFontRenderContext();
                    String netModKey = PopCommands.this.intersected_.getObjectID();
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.removeNetworkModuleRegion");
                    DeleteCommands dc = new DeleteCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    NetModuleFree.IntersectionExtraInfo iexi = (NetModuleFree.IntersectionExtraInfo)PopCommands.this.intersected_.getSubID();
                    dc.deleteNetworkModuleRegion(PopCommands.this.genomeKey_, ovrKey, netModKey, iexi, frc, support);
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class SizeCoreToRegionBounds
    extends AbstractAction {
        public SizeCoreToRegionBounds(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    String ovrKey = PopCommands.this.suPanel_.getCurrentOverlay();
                    FontRenderContext frc = PopCommands.this.suPanel_.getFontRenderContext();
                    String netModKey = PopCommands.this.intersected_.getObjectID();
                    Layout layout = Database.getDB().getLayout(PopCommands.this.layout_);
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.sizeCoreToRegionBounds");
                    Layout.PropChange pc = layout.sizeCoreToRegionBounds(PopCommands.this.genomeKey_, ovrKey, netModKey, frc);
                    if (pc == null) {
                        return;
                    }
                    support.addEdit(new PropChangeCmd(pc));
                    support.addEvent(new LayoutChangeEvent(PopCommands.this.layout_, 1));
                    support.finish();
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DropFromCurrentNetModules
    extends AbstractAction {
        public DropFromCurrentNetModules(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    String netModKey = PopCommands.this.intersected_.getObjectID();
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.hideOneVisibleModule");
                    NetOverlayController noc = MainCommands.getCmds().getOverlayController();
                    noc.dropACurrentModule(netModKey, support);
                    support.finish();
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class SetAsSingleCurrentNetModule
    extends AbstractAction {
        public SetAsSingleCurrentNetModule(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    String netModKey = PopCommands.this.intersected_.getObjectID();
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.setSingleVisibleModule");
                    NetOverlayController noc = MainCommands.getCmds().getOverlayController();
                    noc.setToSingleCurrentModule(netModKey, support);
                    support.finish();
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class ZoomToNetModule
    extends AbstractAction {
        public ZoomToNetModule(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    String modID = PopCommands.this.intersected_.getObjectID();
                    Object[] setArg = new Object[]{modID};
                    MainCommands.OneShot csr = MainCommands.getCmds().getOneShot(11);
                    csr.performOperation(setArg);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class EditModuleMembers
    extends AbstractAction {
        public EditModuleMembers(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    String modID = PopCommands.this.intersected_.getObjectID();
                    String ovrKey = PopCommands.this.suPanel_.getCurrentOverlay();
                    Database db = Database.getDB();
                    Genome useGenome = db.getGenome(PopCommands.this.genomeKey_);
                    if (!(useGenome instanceof DynamicGenomeInstance)) {
                        throw new IllegalStateException();
                    }
                    DynamicGenomeInstance dgi = (DynamicGenomeInstance)useGenome;
                    String proxID = dgi.getProxyID();
                    DynamicInstanceProxy dip = db.getDynamicProxy(proxID);
                    GenomeInstance gi = dip.getStaticVfgParent();
                    EditModuleMemberDialog emmd = new EditModuleMemberDialog(PopCommands.this.parent_, PopCommands.this.genomeKey_, gi.getID(), ovrKey, modID, PopCommands.this.myGenomePre_.getFontRenderContext(), PopCommands.this.undom_);
                    emmd.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class ToggleNetModuleContentDisplay
    extends AbstractAction {
        public ToggleNetModuleContentDisplay(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    String modID = PopCommands.this.intersected_.getObjectID();
                    NetOverlayController noc = MainCommands.getCmds().getOverlayController();
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.toggleModuleViz");
                    noc.toggleModContentDisplay(modID, support);
                    support.finish();
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class EditSelectedNetworkModuleAction
    extends AbstractAction {
        public EditSelectedNetworkModuleAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    String modID = PopCommands.this.intersected_.getObjectID();
                    String ovrKey = PopCommands.this.suPanel_.getCurrentOverlay();
                    NetModulePropertiesDialog nmpd = new NetModulePropertiesDialog(PopCommands.this.parent_, PopCommands.this.genomeKey_, PopCommands.this.layout_, ovrKey, modID, PopCommands.this.suPanel_.getFontRenderContext(), PopCommands.this.undom_);
                    nmpd.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteModuleLinkPointAction
    extends AbstractAction {
        public DeleteModuleLinkPointAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    String overlayKey = PopCommands.this.suPanel_.getCurrentOverlay();
                    String treeID = PopCommands.this.intersected_.getObjectID();
                    Database db = Database.getDB();
                    Layout layout = db.getLayout(PopCommands.this.layout_);
                    NetOverlayProperties nop = layout.getNetOverlayProperties(overlayKey);
                    NetModuleLinkageProperties nmp = nop.getNetModuleLinkagePropertiesFromTreeID(treeID);
                    LinkSegmentID segID = PopCommands.this.intersected_.segmentIDFromIntersect();
                    Layout.PropChange[] lpc = new Layout.PropChange[]{layout.deleteCornerForNetModuleLinkTree(nmp, segID, overlayKey)};
                    if (lpc[0] != null) {
                        UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.deleteCorner");
                        PropChangeCmd mov = new PropChangeCmd(lpc);
                        support.addEdit(mov);
                        PopCommands.this.myGenomePre_.clearSelections(PopCommands.this.genomeKey_, PopCommands.this.layout_, support);
                        support.finish();
                    }
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteModuleLinkageAction
    extends AbstractAction {
        public DeleteModuleLinkageAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    String overlayKey = PopCommands.this.suPanel_.getCurrentOverlay();
                    Genome genome = db.getGenome(PopCommands.this.genomeKey_);
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.moduleLinkDelete");
                    DeleteCommands dc = new DeleteCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    if (dc.deleteNetworkModuleLinkage(genome, overlayKey, PopCommands.this.intersected_, support)) {
                        PopCommands.this.myGenomePre_.clearSelections(PopCommands.this.genomeKey_, PopCommands.this.layout_, support);
                        support.finish();
                    }
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class ModuleLinkPropertiesAction
    extends AbstractAction {
        public ModuleLinkPropertiesAction(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    String overlayKey = PopCommands.this.suPanel_.getCurrentOverlay();
                    LinkPropertiesDialog lpd = new LinkPropertiesDialog(PopCommands.this.parent_, PopCommands.this.layout_, PopCommands.this.genomeKey_, PopCommands.this.intersected_.getObjectID(), PopCommands.this.undom_, true, overlayKey);
                    lpd.setVisible(true);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class AddRegionToNetModule
    extends AbstractAction {
        public AddRegionToNetModule(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    PopCommands.this.suPanel_.setToMode(4, PopCommands.this.intersected_.getObjectID());
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class RemoveThisNetworkModule
    extends AbstractAction {
        public RemoveThisNetworkModule(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PopCommands.this.intersected_ != null) {
                    Database db = Database.getDB();
                    String ovrKey = PopCommands.this.suPanel_.getCurrentOverlay();
                    String modKey = PopCommands.this.intersected_.getObjectID();
                    NetOverlayController noc = MainCommands.getCmds().getOverlayController();
                    UndoSupport support = new UndoSupport(PopCommands.this.undom_, "undo.removeThisNetworkModule");
                    noc.dropACurrentModule(modKey, support);
                    DeleteCommands dc = new DeleteCommands(PopCommands.this.parent_, PopCommands.this.undom_);
                    dc.deleteNetworkModule(PopCommands.this.genomeKey_, ovrKey, PopCommands.this.intersected_.getObjectID(), support);
                    noc.updateModuleOptions(support);
                    support.finish();
                    PopCommands.this.suPanel_.repaint();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class DeleteCurrentOverlay
    extends AbstractAction {
        public DeleteCurrentOverlay(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.OneShot eco = MainCommands.getCmds().getOneShot(12);
                eco.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class EditCurrentOverlay
    extends AbstractAction {
        public EditCurrentOverlay(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MainCommands.OneShot eco = MainCommands.getCmds().getOneShot(13);
                eco.performOperation(null);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class EditMultiSelections
    extends AbstractAction {
        private Set genes_;
        private Set nodes_;
        private Set links_;

        public EditMultiSelections(String text, char mnem) {
            super(text);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        public void setSelections(Set genes, Set nodes, Set links) {
            this.genes_ = genes;
            this.nodes_ = nodes;
            this.links_ = links;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MultiSelectionPropertiesDialog mspd = new MultiSelectionPropertiesDialog(PopCommands.this.parent_, PopCommands.this.genomeKey_, PopCommands.this.layout_, PopCommands.this.suPanel_, this.genes_, this.nodes_, this.links_, PopCommands.this.undom_);
                mspd.setVisible(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }
}

