/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import org.systemsbiology.biotapestry.cmd.BTUndoCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.ui.Layout;

public class PropChangeCmd
extends BTUndoCmd {
    private Layout.PropChange[] restore_;

    public PropChangeCmd(Layout.PropChange[] restore) {
        this.restore_ = restore;
        for (int i = 0; i < restore.length; ++i) {
            Layout.PropChange pc = restore[i];
            if (pc == null || pc.newProps == null || pc.linkIDs != null) continue;
            throw new IllegalArgumentException();
        }
    }

    public PropChangeCmd(Layout.PropChange restore) {
        this.restore_ = new Layout.PropChange[1];
        this.restore_[0] = restore;
        for (int i = 0; i < this.restore_.length; ++i) {
            Layout.PropChange pc = this.restore_[i];
            if (pc == null || pc.newProps == null || pc.linkIDs != null) continue;
            throw new IllegalArgumentException();
        }
    }

    public String getPresentationName() {
        return "Property Change";
    }

    public void undo() {
        super.undo();
        Database db = Database.getDB();
        for (int i = this.restore_.length - 1; i >= 0; --i) {
            Layout.PropChange pc = this.restore_[i];
            if (pc == null) continue;
            Layout layout = db.getLayout(pc.layoutKey);
            if (pc.orig != null || pc.newProps != null) {
                layout.linkChangeUndo(pc);
                continue;
            }
            if (pc.nOrig != null || pc.nNewProps != null) {
                layout.nodeChangeUndo(pc);
                continue;
            }
            if (pc.ntOrig != null || pc.ntNewProps != null) {
                layout.noteChangeUndo(pc);
                continue;
            }
            if (pc.grOrig != null || pc.grNewProps != null) {
                layout.groupChangeUndo(pc);
                continue;
            }
            if (pc.dLocKey != null) {
                layout.dataPosChangeUndo(pc);
                continue;
            }
            if (pc.metaOrig != null) {
                layout.metaChangeUndo(pc);
                continue;
            }
            if (pc.nopOrig != null || pc.nopNew != null) {
                layout.overlayChangeUndo(pc);
                continue;
            }
            if (pc.nmpOrig != null || pc.nmpNew != null) {
                layout.netModChangeUndo(pc);
                continue;
            }
            if (pc.nmlpOrig == null && pc.nmlpNew == null && pc.nmlpTieLinkIDOrig == null) continue;
            layout.netModLinkChangeUndo(pc);
        }
    }

    public void redo() {
        super.redo();
        Database db = Database.getDB();
        for (int i = 0; i < this.restore_.length; ++i) {
            Layout.PropChange pc = this.restore_[i];
            if (pc == null) continue;
            Layout layout = db.getLayout(pc.layoutKey);
            if (pc.newProps != null || pc.orig != null) {
                layout.linkChangeRedo(pc);
                continue;
            }
            if (pc.nNewProps != null || pc.nOrig != null) {
                layout.nodeChangeRedo(pc);
                continue;
            }
            if (pc.ntNewProps != null || pc.ntOrig != null) {
                layout.noteChangeRedo(pc);
                continue;
            }
            if (pc.grNewProps != null || pc.grOrig != null) {
                layout.groupChangeRedo(pc);
                continue;
            }
            if (pc.dLocKey != null) {
                layout.dataPosChangeRedo(pc);
                continue;
            }
            if (pc.newMeta != null) {
                layout.metaChangeRedo(pc);
                continue;
            }
            if (pc.nopOrig != null || pc.nopNew != null) {
                layout.overlayChangeRedo(pc);
                continue;
            }
            if (pc.nmpOrig != null || pc.nmpNew != null) {
                layout.netModChangeRedo(pc);
                continue;
            }
            if (pc.nmlpOrig == null && pc.nmlpNew == null && pc.nmlpTieLinkIDOrig == null) continue;
            layout.netModLinkChangeRedo(pc);
        }
    }
}

