/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.prefs.Preferences;

public class RecentFilesManager {
    private static final int HISTORY_DEPTH_ = 6;
    private static RecentFilesManager singleton_;
    private ArrayList absPaths_ = new ArrayList();
    private HashMap names_ = new HashMap();

    public void drop() {
        this.absPaths_.clear();
        this.names_.clear();
        this.commitToPrefs();
    }

    public Iterator getRecentFiles() {
        return this.absPaths_.iterator();
    }

    public String getRecentFileName(String absPath) {
        return (String)this.names_.get(absPath);
    }

    public void updateLatestFile(File recentFile) {
        String absPath;
        if (this.canLoadFromPrefs()) {
            this.loadFromPrefs();
        }
        if (this.absPaths_.contains(absPath = recentFile.getAbsolutePath())) {
            this.absPaths_.remove(absPath);
        } else {
            int numPaths = this.absPaths_.size();
            if (numPaths == 6) {
                String lastAbs = (String)this.absPaths_.get(numPaths - 1);
                this.names_.remove(lastAbs);
                this.absPaths_.remove(numPaths - 1);
            }
        }
        this.names_.put(absPath, recentFile.getName());
        this.absPaths_.add(0, absPath);
        this.commitToPrefs();
    }

    private void commitToPrefs() {
        int i;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        StringBuffer buf = new StringBuffer();
        int numPaths = this.absPaths_.size();
        for (i = 0; i < numPaths; ++i) {
            buf.setLength(0);
            buf.append("RecentFile");
            buf.append(i);
            prefs.put(buf.toString(), (String)this.absPaths_.get(i));
        }
        for (i = numPaths; i < 6; ++i) {
            buf.setLength(0);
            buf.append("RecentFile");
            buf.append(i);
            prefs.remove(buf.toString());
        }
    }

    private boolean canLoadFromPrefs() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        StringBuffer buf = new StringBuffer();
        String filePath = prefs.get("RecentFile0", null);
        return filePath != null;
    }

    private void loadFromPrefs() {
        this.absPaths_.clear();
        this.names_.clear();
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 6; ++i) {
            buf.setLength(0);
            buf.append("RecentFile");
            buf.append(i);
            String filePath = prefs.get(buf.toString(), null);
            if (filePath == null) break;
            File recentFile = new File(filePath);
            this.absPaths_.add(filePath);
            this.names_.put(filePath, recentFile.getName());
        }
    }

    public static synchronized RecentFilesManager getRecentFilesMgr() {
        if (singleton_ == null) {
            singleton_ = new RecentFilesManager();
        }
        return singleton_;
    }

    private RecentFilesManager() {
        this.loadFromPrefs();
    }
}

