/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.BuildInstruction;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotifPair;
import org.systemsbiology.biotapestry.cmd.DialogBuiltSignalProtoMotif;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class SignalBuildInstruction
extends BuildInstruction {
    public static final int PROMOTE_SIGNAL = 0;
    public static final int REPRESS_SIGNAL = 1;
    public static final int SWITCH_SIGNAL = 2;
    public static final int NUM_SIGNAL_TYPES = 3;
    public static final String PROMOTE_SIGNAL_STR = "promoteSig";
    public static final String REPRESS_SIGNAL_STR = "repressSig";
    public static final String SWITCH_SIGNAL_STR = "switchSig";
    public static final String CSV_TAG = "signal";
    public static final int CSV_TOKEN_COUNT = 3;
    public static final int CSV_TARGET_COUNT = 2;
    public static final int CSV_REGION_COUNT = 2;
    protected static final String XML_TAG = "signalBuildInstruction";
    private int signalFactorType_;
    private String signalFactorName_;
    private int signalType_;

    public SignalBuildInstruction(String id, int sourceType, String sourceName, int targType, String targName, int signalFactorType, String signalFactorName, int signalType) {
        super(id, sourceType, sourceName, targType, targName);
        this.signalFactorType_ = signalFactorType;
        this.signalFactorName_ = signalFactorName;
        this.signalType_ = signalType;
    }

    public SignalBuildInstruction(SignalBuildInstruction other) {
        super(other);
        this.signalFactorType_ = other.signalFactorType_;
        this.signalFactorName_ = other.signalFactorName_;
        this.signalType_ = other.signalType_;
    }

    public Object clone() {
        return super.clone();
    }

    public int getSignalFactorType() {
        return this.signalFactorType_;
    }

    public void setSignalFactorType(int signalFactorType) {
        this.signalFactorType_ = signalFactorType;
    }

    public String getSignalFactorName() {
        return this.signalFactorName_;
    }

    public void setSignalFactorName(String signalFactorName) {
        this.signalFactorName_ = signalFactorName;
    }

    public int getSignalType() {
        return this.signalType_;
    }

    public void setSignalType(int signalType) {
        this.signalType_ = signalType;
    }

    public boolean hasEvidenceLevel() {
        return false;
    }

    public Set getNamedNodes() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(this.sourceName_);
        retval.add(this.targName_);
        retval.add(this.signalFactorName_);
        return retval;
    }

    public Set getNamedSourceRegionNodes() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(this.sourceName_);
        return retval;
    }

    public Set getNamedTargetRegionNodes() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(this.targName_);
        retval.add(this.signalFactorName_);
        return retval;
    }

    public void addMotifs(List motifs, Map types) {
        String sourceNorm = DataUtil.normKey(this.sourceName_);
        this.typeCheckSupport(this.sourceName_, this.sourceType_, types);
        this.typeCheckSupport(this.targName_, this.targType_, types);
        this.typeCheckSupport(this.signalFactorName_, this.signalFactorType_, types);
        DialogBuiltSignalProtoMotif dbspm = new DialogBuiltSignalProtoMotif(this.sourceName_, this.sourceType_, this.targName_, this.targType_, this.signalFactorName_, this.signalFactorType_, this.signalType_);
        motifs.add(new DialogBuiltMotifPair(this.id_, dbspm, null));
    }

    public boolean typesAreConsistent(Map typeTracker) {
        if (!this.typeChecks(this.sourceName_, this.sourceType_, typeTracker)) {
            return false;
        }
        if (!this.typeChecks(this.targName_, this.targType_, typeTracker)) {
            return false;
        }
        return this.typeChecks(this.signalFactorName_, this.signalFactorType_, typeTracker);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<");
        out.print(XML_TAG);
        this.writeXMLSupport(out, ind);
        out.print(" factorType=\"");
        out.print(SignalBuildInstruction.mapToNodeTypeTag(this.signalFactorType_));
        out.print("\" factorName=\"");
        out.print(CharacterEntityMapper.mapEntities(this.signalFactorName_, false));
        out.print("\" signalType=\"");
        out.print(SignalBuildInstruction.mapToSignalTypeTag(this.signalType_));
        out.println("\" />");
    }

    public String toCSVString(StringBuffer buf, String modelName) {
        buf.setLength(0);
        buf.append("\"");
        buf.append(CSV_TAG);
        buf.append("\",\"");
        buf.append(modelName);
        buf.append("\",\"");
        buf.append(SignalBuildInstruction.mapToNodeTypeTag(this.sourceType_));
        buf.append("\",\"");
        buf.append(this.sourceName_);
        buf.append("\",\"");
        buf.append(SignalBuildInstruction.mapToNodeTypeTag(this.targType_));
        buf.append("\",\"");
        buf.append(this.targName_);
        buf.append("\",\"");
        buf.append(SignalBuildInstruction.mapToNodeTypeTag(this.signalFactorType_));
        buf.append("\",\"");
        buf.append(this.signalFactorName_);
        buf.append("\",\"");
        buf.append(SignalBuildInstruction.mapToSignalTypeTag(this.signalType_));
        buf.append("\"");
        return buf.toString();
    }

    public boolean sameDefinition(BuildInstruction other) {
        if (!(other instanceof SignalBuildInstruction)) {
            return false;
        }
        if (!super.sameDefinition(other)) {
            return false;
        }
        SignalBuildInstruction otherSbi = (SignalBuildInstruction)other;
        return this.signalFactorType_ == otherSbi.signalFactorType_ && this.signalType_ == otherSbi.signalType_ && (this.signalFactorName_ == null && otherSbi.signalFactorName_ == null || this.signalFactorName_ != null && otherSbi.signalFactorName_ != null && DataUtil.keysEqual(this.signalFactorName_, otherSbi.signalFactorName_));
    }

    public String toString() {
        return super.toString() + " " + this.signalFactorType_ + " " + this.signalFactorName_ + " " + this.signalType_;
    }

    public String displayStringUI(ResourceManager rMan) {
        String dispSign = rMan.getString("buildInstruction." + SignalBuildInstruction.mapToSignalTypeTag(this.signalType_));
        String retval = MessageFormat.format(rMan.getString("buildInstruction.signalDisplay"), this.sourceName_, this.signalFactorName_, this.targName_, dispSign);
        return retval;
    }

    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof SignalBuildInstruction)) {
            return false;
        }
        SignalBuildInstruction otherSbi = (SignalBuildInstruction)other;
        return this.signalFactorType_ == otherSbi.signalFactorType_ && this.signalType_ == otherSbi.signalType_ && (this.signalFactorName_ == null && otherSbi.signalFactorName_ == null || this.signalFactorName_ != null && this.signalFactorName_.equals(otherSbi.signalFactorName_));
    }

    public static BuildInstruction buildFromXML(String elemName, Attributes attrs, String id, int sourceType, String sourceName, int targType, String targName) throws IOException {
        int signalType;
        int signalFactorType;
        if (!elemName.equals(XML_TAG)) {
            return null;
        }
        String signalFactorName = null;
        String signalFactorTypeStr = null;
        String signalTypeStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("factorType")) {
                    signalFactorTypeStr = val;
                    continue;
                }
                if (key.equals("factorName")) {
                    signalFactorName = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (!key.equals("signalType")) continue;
                signalTypeStr = val;
            }
        }
        if (signalFactorTypeStr == null || signalFactorName == null || signalTypeStr == null) {
            throw new IOException();
        }
        try {
            signalFactorType = SignalBuildInstruction.mapFromNodeTypeTag(signalFactorTypeStr);
            signalType = SignalBuildInstruction.mapFromSignalTypeTag(signalTypeStr);
        }
        catch (IllegalArgumentException iae) {
            System.err.println("bad map");
            throw new IOException();
        }
        return new SignalBuildInstruction(id, sourceType, sourceName, targType, targName, signalFactorType, signalFactorName, signalType);
    }

    public static String mapToSignalTypeTag(int val) {
        switch (val) {
            case 0: {
                return PROMOTE_SIGNAL_STR;
            }
            case 1: {
                return REPRESS_SIGNAL_STR;
            }
            case 2: {
                return SWITCH_SIGNAL_STR;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromSignalTypeTag(String tag) {
        if (tag.equalsIgnoreCase(PROMOTE_SIGNAL_STR)) {
            return 0;
        }
        if (tag.equalsIgnoreCase(REPRESS_SIGNAL_STR)) {
            return 1;
        }
        if (tag.equalsIgnoreCase(SWITCH_SIGNAL_STR)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static BuildInstruction buildFromCSV(List tokens, int startIndex, String id, int sourceType, String sourceName, int targType, String targName) throws IOException {
        int signalType;
        int signalFactorType;
        if (tokens.size() < startIndex + 2 + 2 + 3) {
            throw new IOException();
        }
        String signalFactorTypeStr = ((String)tokens.get(startIndex + 2 + 2 + 3 - 3)).trim().toLowerCase();
        String signalFactorName = (String)tokens.get(startIndex + 2 + 2 + 3 - 2);
        String signalTypeStr = ((String)tokens.get(startIndex + 2 + 2 + 3 - 1)).trim().toLowerCase();
        if (signalFactorTypeStr == null || signalFactorTypeStr.trim().equals("")) {
            throw new IOException();
        }
        if (signalFactorName == null || signalFactorName.trim().equals("")) {
            throw new IOException();
        }
        if (signalTypeStr == null || signalTypeStr.trim().equals("")) {
            throw new IOException();
        }
        try {
            signalFactorType = SignalBuildInstruction.mapFromNodeTypeTag(signalFactorTypeStr);
            signalType = SignalBuildInstruction.mapFromSignalTypeTag(signalTypeStr);
        }
        catch (IllegalArgumentException iae) {
            System.err.println("bad map");
            throw new IOException();
        }
        return new SignalBuildInstruction(id, sourceType, sourceName, targType, targName, signalFactorType, signalFactorName, signalType);
    }
}

