/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import org.systemsbiology.biotapestry.cmd.BTUndoCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.event.EventManager;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputChange;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeData;

public class TemporalInputChangeCmd
extends BTUndoCmd {
    private TemporalInputChange restore_;
    private boolean doEvent_;

    public TemporalInputChangeCmd(TemporalInputChange restore, boolean doEvent) {
        this.restore_ = restore;
        this.doEvent_ = doEvent;
    }

    public TemporalInputChangeCmd(TemporalInputChange restore) {
        this.restore_ = restore;
        this.doEvent_ = false;
    }

    public String getPresentationName() {
        return "Temporal Input Change";
    }

    public void undo() {
        super.undo();
        Database db = Database.getDB();
        TemporalInputRangeData tird = db.getTemporalInputRangeData();
        tird.changeUndo(this.restore_);
        if (this.doEvent_) {
            GeneralChangeEvent ev = new GeneralChangeEvent(2);
            EventManager.getManager().sendGeneralChangeEvent(ev);
        }
    }

    public void redo() {
        super.redo();
        Database db = Database.getDB();
        TemporalInputRangeData tird = db.getTemporalInputRangeData();
        tird.changeRedo(this.restore_);
        if (this.doEvent_) {
            GeneralChangeEvent ev = new GeneralChangeEvent(2);
            EventManager.getManager().sendGeneralChangeEvent(ev);
        }
    }

    public static TemporalInputChangeCmd[] wrapChanges(TemporalInputChange[] restores) {
        TemporalInputChangeCmd[] retval = new TemporalInputChangeCmd[restores.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = new TemporalInputChangeCmd(restores[i]);
        }
        return retval;
    }
}

