/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import org.systemsbiology.biotapestry.cmd.BTUndoCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.event.EventManager;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseChange;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;

public class TimeCourseChangeCmd
extends BTUndoCmd {
    private TimeCourseChange restore_;
    private boolean doEvent_;

    public TimeCourseChangeCmd(TimeCourseChange restore, boolean doEvent) {
        this.restore_ = restore;
        this.doEvent_ = doEvent;
    }

    public TimeCourseChangeCmd(TimeCourseChange restore) {
        this.restore_ = restore;
        this.doEvent_ = false;
    }

    public String getPresentationName() {
        return "Time Course Change";
    }

    public void undo() {
        super.undo();
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        tcd.changeUndo(this.restore_);
        if (this.doEvent_) {
            GeneralChangeEvent ev = new GeneralChangeEvent(2);
            EventManager.getManager().sendGeneralChangeEvent(ev);
        }
    }

    public void redo() {
        super.redo();
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        tcd.changeRedo(this.restore_);
        if (this.doEvent_) {
            GeneralChangeEvent ev = new GeneralChangeEvent(2);
            EventManager.getManager().sendGeneralChangeEvent(ev);
        }
    }

    public static TimeCourseChangeCmd[] wrapChanges(TimeCourseChange[] restores) {
        TimeCourseChangeCmd[] retval = new TimeCourseChangeCmd[restores.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = new TimeCourseChangeCmd(restores[i]);
        }
        return retval;
    }
}

